/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/abab/index.js":
/*!************************************!*\
  !*** ./node_modules/abab/index.js ***!
  \************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const atob = __webpack_require__(/*! ./lib/atob */ "./node_modules/abab/lib/atob.js");
const btoa = __webpack_require__(/*! ./lib/btoa */ "./node_modules/abab/lib/btoa.js");

module.exports = {
  atob,
  btoa
};


/***/ }),

/***/ "./node_modules/abab/lib/atob.js":
/*!***************************************!*\
  !*** ./node_modules/abab/lib/atob.js ***!
  \***************************************/
/***/ ((module) => {

"use strict";


/**
 * Implementation of atob() according to the HTML and Infra specs, except that
 * instead of throwing INVALID_CHARACTER_ERR we return null.
 */
function atob(data) {
  if (arguments.length === 0) {
    throw new TypeError("1 argument required, but only 0 present.");
  }

  // Web IDL requires DOMStrings to just be converted using ECMAScript
  // ToString, which in our case amounts to using a template literal.
  data = `${data}`;
  // "Remove all ASCII whitespace from data."
  data = data.replace(/[ \t\n\f\r]/g, "");
  // "If data's length divides by 4 leaving no remainder, then: if data ends
  // with one or two U+003D (=) code points, then remove them from data."
  if (data.length % 4 === 0) {
    data = data.replace(/==?$/, "");
  }
  // "If data's length divides by 4 leaving a remainder of 1, then return
  // failure."
  //
  // "If data contains a code point that is not one of
  //
  // U+002B (+)
  // U+002F (/)
  // ASCII alphanumeric
  //
  // then return failure."
  if (data.length % 4 === 1 || /[^+/0-9A-Za-z]/.test(data)) {
    return null;
  }
  // "Let output be an empty byte sequence."
  let output = "";
  // "Let buffer be an empty buffer that can have bits appended to it."
  //
  // We append bits via left-shift and or.  accumulatedBits is used to track
  // when we've gotten to 24 bits.
  let buffer = 0;
  let accumulatedBits = 0;
  // "Let position be a position variable for data, initially pointing at the
  // start of data."
  //
  // "While position does not point past the end of data:"
  for (let i = 0; i < data.length; i++) {
    // "Find the code point pointed to by position in the second column of
    // Table 1: The Base 64 Alphabet of RFC 4648. Let n be the number given in
    // the first cell of the same row.
    //
    // "Append to buffer the six bits corresponding to n, most significant bit
    // first."
    //
    // atobLookup() implements the table from RFC 4648.
    buffer <<= 6;
    buffer |= atobLookup(data[i]);
    accumulatedBits += 6;
    // "If buffer has accumulated 24 bits, interpret them as three 8-bit
    // big-endian numbers. Append three bytes with values equal to those
    // numbers to output, in the same order, and then empty buffer."
    if (accumulatedBits === 24) {
      output += String.fromCharCode((buffer & 0xff0000) >> 16);
      output += String.fromCharCode((buffer & 0xff00) >> 8);
      output += String.fromCharCode(buffer & 0xff);
      buffer = accumulatedBits = 0;
    }
    // "Advance position by 1."
  }
  // "If buffer is not empty, it contains either 12 or 18 bits. If it contains
  // 12 bits, then discard the last four and interpret the remaining eight as
  // an 8-bit big-endian number. If it contains 18 bits, then discard the last
  // two and interpret the remaining 16 as two 8-bit big-endian numbers. Append
  // the one or two bytes with values equal to those one or two numbers to
  // output, in the same order."
  if (accumulatedBits === 12) {
    buffer >>= 4;
    output += String.fromCharCode(buffer);
  } else if (accumulatedBits === 18) {
    buffer >>= 2;
    output += String.fromCharCode((buffer & 0xff00) >> 8);
    output += String.fromCharCode(buffer & 0xff);
  }
  // "Return output."
  return output;
}
/**
 * A lookup table for atob(), which converts an ASCII character to the
 * corresponding six-bit number.
 */

const keystr =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

function atobLookup(chr) {
  const index = keystr.indexOf(chr);
  // Throw exception if character is not in the lookup string; should not be hit in tests
  return index < 0 ? undefined : index;
}

module.exports = atob;


/***/ }),

/***/ "./node_modules/abab/lib/btoa.js":
/*!***************************************!*\
  !*** ./node_modules/abab/lib/btoa.js ***!
  \***************************************/
/***/ ((module) => {

"use strict";


/**
 * btoa() as defined by the HTML and Infra specs, which mostly just references
 * RFC 4648.
 */
function btoa(s) {
  if (arguments.length === 0) {
    throw new TypeError("1 argument required, but only 0 present.");
  }

  let i;
  // String conversion as required by Web IDL.
  s = `${s}`;
  // "The btoa() method must throw an "InvalidCharacterError" DOMException if
  // data contains any character whose code point is greater than U+00FF."
  for (i = 0; i < s.length; i++) {
    if (s.charCodeAt(i) > 255) {
      return null;
    }
  }
  let out = "";
  for (i = 0; i < s.length; i += 3) {
    const groupsOfSix = [undefined, undefined, undefined, undefined];
    groupsOfSix[0] = s.charCodeAt(i) >> 2;
    groupsOfSix[1] = (s.charCodeAt(i) & 0x03) << 4;
    if (s.length > i + 1) {
      groupsOfSix[1] |= s.charCodeAt(i + 1) >> 4;
      groupsOfSix[2] = (s.charCodeAt(i + 1) & 0x0f) << 2;
    }
    if (s.length > i + 2) {
      groupsOfSix[2] |= s.charCodeAt(i + 2) >> 6;
      groupsOfSix[3] = s.charCodeAt(i + 2) & 0x3f;
    }
    for (let j = 0; j < groupsOfSix.length; j++) {
      if (typeof groupsOfSix[j] === "undefined") {
        out += "=";
      } else {
        out += btoaLookup(groupsOfSix[j]);
      }
    }
  }
  return out;
}

/**
 * Lookup table for btoa(), which converts a six-bit number into the
 * corresponding ASCII character.
 */
const keystr =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

function btoaLookup(index) {
  if (index >= 0 && index < 64) {
    return keystr[index];
  }

  // Throw INVALID_CHARACTER_ERR exception here -- won't be hit in the tests.
  return undefined;
}

module.exports = btoa;


/***/ }),

/***/ "./node_modules/@converse/openpromise/openpromise.js":
/*!***********************************************************!*\
  !*** ./node_modules/@converse/openpromise/openpromise.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getOpenPromise": () => (/* binding */ getOpenPromise)
/* harmony export */ });
function getOpenPromise() {
  const wrapper = {
    isResolved: false,
    isPending: true,
    isRejected: false
  };
  const promise = new Promise((resolve, reject) => {
    wrapper.resolve = resolve;
    wrapper.reject = reject;
  });
  Object.assign(promise, wrapper);
  promise.then(function (v) {
    promise.isResolved = true;
    promise.isPending = false;
    promise.isRejected = false;
    return v;
  }, function (e) {
    promise.isResolved = false;
    promise.isPending = false;
    promise.isRejected = true;
    throw e;
  });
  return promise;
}

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/collection.js":
/*!***********************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/collection.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Collection": () => (/* binding */ Collection)
/* harmony export */ });
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/clone.js */ "./node_modules/lodash-es/clone.js");
/* harmony import */ var lodash_es_countBy_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lodash-es/countBy.js */ "./node_modules/lodash-es/countBy.js");
/* harmony import */ var lodash_es_difference_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es/difference.js */ "./node_modules/lodash-es/difference.js");
/* harmony import */ var lodash_es_every_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es/every.js */ "./node_modules/lodash-es/every.js");
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_findIndex_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! lodash-es/findIndex.js */ "./node_modules/lodash-es/findIndex.js");
/* harmony import */ var lodash_es_findLastIndex_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! lodash-es/findLastIndex.js */ "./node_modules/lodash-es/findLastIndex.js");
/* harmony import */ var lodash_es_groupBy_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! lodash-es/groupBy.js */ "./node_modules/lodash-es/groupBy.js");
/* harmony import */ var lodash_es_indexOf_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! lodash-es/indexOf.js */ "./node_modules/lodash-es/indexOf.js");
/* harmony import */ var lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lodash-es/isEmpty.js */ "./node_modules/lodash-es/isEmpty.js");
/* harmony import */ var lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash-es/isFunction.js */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/isString.js */ "./node_modules/lodash-es/isString.js");
/* harmony import */ var lodash_es_keyBy_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash-es/keyBy.js */ "./node_modules/lodash-es/keyBy.js");
/* harmony import */ var lodash_es_lastIndexOf_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! lodash-es/lastIndexOf.js */ "./node_modules/lodash-es/lastIndexOf.js");
/* harmony import */ var lodash_es_some_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/some.js */ "./node_modules/lodash-es/some.js");
/* harmony import */ var lodash_es_sortBy_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash-es/sortBy.js */ "./node_modules/lodash-es/sortBy.js");
//     Backbone.js 1.4.0
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.

// Collection
// ----------

// If models tend to represent a single row of data, a Collection is
// more analogous to a table full of data ... or a small slice or page of that
// table, or a collection of rows that belong together for a particular reason
// -- all of the messages in this particular folder, all of the documents
// belonging to this particular author, and so on. Collections maintain
// indexes of their models, both in order, and for lookup by `id`.




















const slice = Array.prototype.slice;

// Create a new **Collection**, perhaps to contain a specific type of `model`.
// If a `comparator` is specified, the Collection will maintain
// its models in sort order, as they're added and removed.
const Collection = function (models, options) {
  options || (options = {});
  this.preinitialize.apply(this, arguments);
  if (options.model) this.model = options.model;
  if (options.comparator !== undefined) this.comparator = options.comparator;
  this._reset();
  this.initialize.apply(this, arguments);
  if (models) this.reset(models, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    silent: true
  }, options));
};
Collection.extend = _helpers_js__WEBPACK_IMPORTED_MODULE_0__.inherits;

// Default options for `Collection#set`.
const setOptions = {
  add: true,
  remove: true,
  merge: true
};
const addOptions = {
  add: true,
  remove: false
};

// Splices `insert` into `array` at index `at`.
const splice = function (array, insert, at) {
  at = Math.min(Math.max(at, 0), array.length);
  const tail = Array(array.length - at);
  const length = insert.length;
  let i;
  for (i = 0; i < tail.length; i++) tail[i] = array[i + at];
  for (i = 0; i < length; i++) array[i + at] = insert[i];
  for (i = 0; i < tail.length; i++) array[i + length + at] = tail[i];
};

// Define the Collection's inheritable methods.
Object.assign(Collection.prototype, _events_js__WEBPACK_IMPORTED_MODULE_1__.Events, {
  // The default model for a collection is just a **Backbone.Model**.
  // This should be overridden in most cases.
  model: _model_js__WEBPACK_IMPORTED_MODULE_2__.Model,
  // preinitialize is an empty function by default. You can override it with a function
  // or object.  preinitialize will run before any instantiation logic is run in the Collection.
  preinitialize: function () {},
  // Initialize is an empty function by default. Override it with your own
  // initialization logic.
  initialize: function () {},
  // The JSON representation of a Collection is an array of the
  // models' attributes.
  toJSON: function (options) {
    return this.map(function (model) {
      return model.toJSON(options);
    });
  },
  // Proxy `Backbone.sync` by default.
  sync: function (method, model, options) {
    return (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.getSyncMethod)(this)(method, model, options);
  },
  // Add a model, or list of models to the set. `models` may be Backbone
  // Models or raw JavaScript objects to be converted to Models, or any
  // combination of the two.
  add: function (models, options) {
    return this.set(models, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      merge: false
    }, options, addOptions));
  },
  // Remove a model, or a list of models from the set.
  remove: function (models, options) {
    options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({}, options);
    const singular = !Array.isArray(models);
    models = singular ? [models] : models.slice();
    const removed = this._removeModels(models, options);
    if (!options.silent && removed.length) {
      options.changes = {
        added: [],
        merged: [],
        removed: removed
      };
      this.trigger('update', this, options);
    }
    return singular ? removed[0] : removed;
  },
  // Update a collection by `set`-ing a new list of models, adding new ones,
  // removing models that are no longer present, and merging models that
  // already exist in the collection, as necessary. Similar to **Model#set**,
  // the core operation for updating the data contained by the collection.
  set: function (models, options) {
    if (models == null) return;
    options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({}, setOptions, options);
    if (options.parse && !this._isModel(models)) {
      models = this.parse(models, options) || [];
    }
    const singular = !Array.isArray(models);
    models = singular ? [models] : models.slice();
    let at = options.at;
    if (at != null) at = +at;
    if (at > this.length) at = this.length;
    if (at < 0) at += this.length + 1;
    const set = [];
    const toAdd = [];
    const toMerge = [];
    const toRemove = [];
    const modelMap = {};
    const add = options.add;
    const merge = options.merge;
    const remove = options.remove;
    let sort = false;
    const sortable = this.comparator && at == null && options.sort !== false;
    const sortAttr = (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(this.comparator) ? this.comparator : null;

    // Turn bare objects into model references, and prevent invalid models
    // from being added.
    let model, i;
    for (i = 0; i < models.length; i++) {
      model = models[i];

      // If a duplicate is found, prevent it from being added and
      // optionally merge it into the existing model.
      const existing = this.get(model);
      if (existing) {
        if (merge && model !== existing) {
          let attrs = this._isModel(model) ? model.attributes : model;
          if (options.parse) attrs = existing.parse(attrs, options);
          existing.set(attrs, options);
          toMerge.push(existing);
          if (sortable && !sort) sort = existing.hasChanged(sortAttr);
        }
        if (!modelMap[existing.cid]) {
          modelMap[existing.cid] = true;
          set.push(existing);
        }
        models[i] = existing;

        // If this is a new, valid model, push it to the `toAdd` list.
      } else if (add) {
        model = models[i] = this._prepareModel(model, options);
        if (model) {
          toAdd.push(model);
          this._addReference(model, options);
          modelMap[model.cid] = true;
          set.push(model);
        }
      }
    }

    // Remove stale models.
    if (remove) {
      for (i = 0; i < this.length; i++) {
        model = this.models[i];
        if (!modelMap[model.cid]) toRemove.push(model);
      }
      if (toRemove.length) this._removeModels(toRemove, options);
    }

    // See if sorting is needed, update `length` and splice in new models.
    let orderChanged = false;
    const replace = !sortable && add && remove;
    if (set.length && replace) {
      orderChanged = this.length !== set.length || (0,lodash_es_some_js__WEBPACK_IMPORTED_MODULE_5__["default"])(this.models, (m, index) => m !== set[index]);
      this.models.length = 0;
      splice(this.models, set, 0);
      this.length = this.models.length;
    } else if (toAdd.length) {
      if (sortable) sort = true;
      splice(this.models, toAdd, at == null ? this.length : at);
      this.length = this.models.length;
    }

    // Silently sort the collection if appropriate.
    if (sort) this.sort({
      silent: true
    });

    // Unless silenced, it's time to fire all appropriate add/sort/update events.
    if (!options.silent) {
      for (i = 0; i < toAdd.length; i++) {
        if (at != null) options.index = at + i;
        model = toAdd[i];
        model.trigger('add', model, this, options);
      }
      if (sort || orderChanged) this.trigger('sort', this, options);
      if (toAdd.length || toRemove.length || toMerge.length) {
        options.changes = {
          added: toAdd,
          removed: toRemove,
          merged: toMerge
        };
        this.trigger('update', this, options);
      }
    }

    // Return the added (or merged) model (or models).
    return singular ? models[0] : models;
  },
  clearStore: async function () {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let filter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : o => o;
    await Promise.all(this.models.filter(filter).map(m => {
      return new Promise(resolve => {
        m.destroy(Object.assign(options, {
          'success': resolve,
          'error': (m, e) => {
            console.error(e);
            resolve();
          }
        }));
      });
    }));
    await this.browserStorage.clear();
    this.reset();
  },
  // When you have more items than you want to add or remove individually,
  // you can reset the entire set with a new list of models, without firing
  // any granular `add` or `remove` events. Fires `reset` when finished.
  // Useful for bulk operations and optimizations.
  reset: function (models, options) {
    options = options ? (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(options) : {};
    for (let i = 0; i < this.models.length; i++) {
      this._removeReference(this.models[i], options);
    }
    options.previousModels = this.models;
    this._reset();
    models = this.add(models, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      silent: true
    }, options));
    if (!options.silent) this.trigger('reset', this, options);
    return models;
  },
  // Add a model to the end of the collection.
  push: function (model, options) {
    return this.add(model, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      at: this.length
    }, options));
  },
  // Remove a model from the end of the collection.
  pop: function (options) {
    const model = this.at(this.length - 1);
    return this.remove(model, options);
  },
  // Add a model to the beginning of the collection.
  unshift: function (model, options) {
    return this.add(model, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      at: 0
    }, options));
  },
  // Remove a model from the beginning of the collection.
  shift: function (options) {
    const model = this.at(0);
    return this.remove(model, options);
  },
  // Slice out a sub-array of models from the collection.
  slice: function () {
    return slice.apply(this.models, arguments);
  },
  filter: function (callback, thisArg) {
    return this.models.filter((0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(callback) ? callback : m => m.matches(callback), thisArg);
  },
  every: function (pred) {
    return (0,lodash_es_every_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this.models.map(m => m.attributes), pred);
  },
  difference: function (values) {
    return (0,lodash_es_difference_js__WEBPACK_IMPORTED_MODULE_9__["default"])(this.models, values);
  },
  max: function () {
    return Math.max.apply(Math, this.models);
  },
  min: function () {
    return Math.min.apply(Math, this.models);
  },
  drop: function () {
    let n = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    return this.models.slice(n);
  },
  some: function (pred) {
    return (0,lodash_es_some_js__WEBPACK_IMPORTED_MODULE_5__["default"])(this.models.map(m => m.attributes), pred);
  },
  sortBy: function (iteratee) {
    return (0,lodash_es_sortBy_js__WEBPACK_IMPORTED_MODULE_10__["default"])(this.models, (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(iteratee) ? iteratee : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(iteratee) ? m.get(iteratee) : m.matches(iteratee));
  },
  isEmpty: function () {
    return (0,lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_11__["default"])(this.models);
  },
  keyBy: function (iteratee) {
    return (0,lodash_es_keyBy_js__WEBPACK_IMPORTED_MODULE_12__["default"])(this.models, iteratee);
  },
  each: function (callback, thisArg) {
    return this.forEach(callback, thisArg);
  },
  forEach: function (callback, thisArg) {
    return this.models.forEach(callback, thisArg);
  },
  includes: function (item) {
    return this.models.includes(item);
  },
  size: function () {
    return this.models.length;
  },
  countBy: function (f) {
    return (0,lodash_es_countBy_js__WEBPACK_IMPORTED_MODULE_13__["default"])(this.models, (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(f) ? f : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(f) ? m.get(f) : m.matches(f));
  },
  groupBy: function (pred) {
    return (0,lodash_es_groupBy_js__WEBPACK_IMPORTED_MODULE_14__["default"])(this.models, (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(pred) ? pred : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(pred) ? m.get(pred) : m.matches(pred));
  },
  indexOf: function (fromIndex) {
    return (0,lodash_es_indexOf_js__WEBPACK_IMPORTED_MODULE_15__["default"])(this.models, fromIndex);
  },
  findLastIndex: function (pred, fromIndex) {
    return (0,lodash_es_findLastIndex_js__WEBPACK_IMPORTED_MODULE_16__["default"])(this.models, (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(pred) ? pred : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(pred) ? m.get(pred) : m.matches(pred), fromIndex);
  },
  lastIndexOf: function (fromIndex) {
    return (0,lodash_es_lastIndexOf_js__WEBPACK_IMPORTED_MODULE_17__["default"])(this.models, fromIndex);
  },
  findIndex: function (pred) {
    return (0,lodash_es_findIndex_js__WEBPACK_IMPORTED_MODULE_18__["default"])(this.models, (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(pred) ? pred : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(pred) ? m.get(pred) : m.matches(pred));
  },
  last: function () {
    const length = this.models == null ? 0 : this.models.length;
    return length ? this.models[length - 1] : undefined;
  },
  head: function () {
    return this.models[0];
  },
  first: function () {
    return this.head();
  },
  map: function (cb, thisArg) {
    return this.models.map((0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(cb) ? cb : m => (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(cb) ? m.get(cb) : m.matches(cb), thisArg);
  },
  reduce: function (callback, initialValue) {
    return this.models.reduce(callback, initialValue || this.models[0]);
  },
  reduceRight: function (callback, initialValue) {
    return this.models.reduceRight(callback, initialValue || this.models[0]);
  },
  toArray: function () {
    return Array.from(this.models);
  },
  // Get a model from the set by id, cid, model object with id or cid
  // properties, or an attributes object that is transformed through modelId.
  get: function (obj) {
    if (obj == null) return undefined;
    return this._byId[obj] || this._byId[this.modelId(this._isModel(obj) ? obj.attributes : obj)] || obj.cid && this._byId[obj.cid];
  },
  // Returns `true` if the model is in the collection.
  has: function (obj) {
    return this.get(obj) != null;
  },
  // Get the model at the given index.
  at: function (index) {
    if (index < 0) index += this.length;
    return this.models[index];
  },
  // Return models with matching attributes. Useful for simple cases of
  // `filter`.
  where: function (attrs, first) {
    return this[first ? 'find' : 'filter'](attrs);
  },
  // Return the first model with matching attributes. Useful for simple cases
  // of `find`.
  findWhere: function (attrs) {
    return this.where(attrs, true);
  },
  find: function (predicate, fromIndex) {
    const pred = (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(predicate) ? predicate : m => m.matches(predicate);
    return this.models.find(pred, fromIndex);
  },
  // Force the collection to re-sort itself. You don't need to call this under
  // normal circumstances, as the set will maintain sort order as each item
  // is added.
  sort: function (options) {
    let comparator = this.comparator;
    if (!comparator) throw new Error('Cannot sort a set without a comparator');
    options || (options = {});
    const length = comparator.length;
    if ((0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"])(comparator)) comparator = comparator.bind(this);

    // Run sort based on type of `comparator`.
    if (length === 1 || (0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_4__["default"])(comparator)) {
      this.models = this.sortBy(comparator);
    } else {
      this.models.sort(comparator);
    }
    if (!options.silent) this.trigger('sort', this, options);
    return this;
  },
  // Pluck an attribute from each model in the collection.
  pluck: function (attr) {
    return this.map(attr + '');
  },
  // Fetch the default set of models for this collection, resetting the
  // collection when they arrive. If `reset: true` is passed, the response
  // data will be passed through the `reset` method instead of `set`.
  fetch: function (options) {
    options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      parse: true
    }, options);
    const success = options.success;
    const collection = this;
    const promise = options.promise && (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.getResolveablePromise)();
    options.success = function (resp) {
      const method = options.reset ? 'reset' : 'set';
      collection[method](resp, options);
      if (success) success.call(options.context, collection, resp, options);
      promise && promise.resolve();
      collection.trigger('sync', collection, resp, options);
    };
    (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.wrapError)(this, options);
    return promise ? promise : this.sync('read', this, options);
  },
  // Create a new instance of a model in this collection. Add the model to the
  // collection immediately, unless `wait: true` is passed, in which case we
  // wait for the server to agree.
  create: function (model, options) {
    options = options ? (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(options) : {};
    const wait = options.wait;
    const return_promise = options.promise;
    const promise = return_promise && (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.getResolveablePromise)();
    model = this._prepareModel(model, options);
    if (!model) return false;
    if (!wait) this.add(model, options);
    const collection = this;
    const success = options.success;
    const error = options.error;
    options.success = function (m, resp, callbackOpts) {
      if (wait) {
        collection.add(m, callbackOpts);
      }
      if (success) {
        success.call(callbackOpts.context, m, resp, callbackOpts);
      }
      if (return_promise) {
        promise.resolve(m);
      }
    };
    options.error = function (model, e, options) {
      error && error.call(options.context, model, e, options);
      return_promise && promise.reject(e);
    };
    model.save(null, Object.assign(options, {
      'promise': false
    }));
    if (return_promise) {
      return promise;
    } else {
      return model;
    }
  },
  // **parse** converts a response into a list of models to be added to the
  // collection. The default implementation is just to pass it through.
  parse: function (resp, options) {
    return resp;
  },
  // Create a new collection with an identical list of models as this one.
  clone: function () {
    return new this.constructor(this.models, {
      model: this.model,
      comparator: this.comparator
    });
  },
  // Define how to uniquely identify models in the collection.
  modelId: function (attrs) {
    var _this$model$prototype;
    return attrs[((_this$model$prototype = this.model.prototype) === null || _this$model$prototype === void 0 ? void 0 : _this$model$prototype.idAttribute) || 'id'];
  },
  // Get an iterator of all models in this collection.
  values: function () {
    return new CollectionIterator(this, ITERATOR_VALUES);
  },
  // Get an iterator of all model IDs in this collection.
  keys: function () {
    return new CollectionIterator(this, ITERATOR_KEYS);
  },
  // Get an iterator of all [ID, model] tuples in this collection.
  entries: function () {
    return new CollectionIterator(this, ITERATOR_KEYSVALUES);
  },
  // Private method to reset all internal state. Called when the collection
  // is first initialized or reset.
  _reset: function () {
    this.length = 0;
    this.models = [];
    this._byId = {};
  },
  // Prepare a hash of attributes (or other model) to be added to this
  // collection.
  _prepareModel: function (attrs, options) {
    if (this._isModel(attrs)) {
      if (!attrs.collection) attrs.collection = this;
      return attrs;
    }
    options = options ? (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(options) : {};
    options.collection = this;
    const model = new this.model(attrs, options);
    if (!model.validationError) return model;
    this.trigger('invalid', this, model.validationError, options);
    return false;
  },
  // Internal method called by both remove and set.
  _removeModels: function (models, options) {
    const removed = [];
    for (let i = 0; i < models.length; i++) {
      const model = this.get(models[i]);
      if (!model) continue;
      const index = this.indexOf(model);
      this.models.splice(index, 1);
      this.length--;

      // Remove references before triggering 'remove' event to prevent an
      // infinite loop. #3693
      delete this._byId[model.cid];
      const id = this.modelId(model.attributes);
      if (id != null) delete this._byId[id];
      if (!options.silent) {
        options.index = index;
        model.trigger('remove', model, this, options);
      }
      removed.push(model);
      this._removeReference(model, options);
    }
    return removed;
  },
  // Method for checking whether an object should be considered a model for
  // the purposes of adding to the collection.
  _isModel: function (model) {
    return model instanceof _model_js__WEBPACK_IMPORTED_MODULE_2__.Model;
  },
  // Internal method to create a model's ties to a collection.
  _addReference: function (model, options) {
    this._byId[model.cid] = model;
    const id = this.modelId(model.attributes);
    if (id != null) this._byId[id] = model;
    model.on('all', this._onModelEvent, this);
  },
  // Internal method to sever a model's ties to a collection.
  _removeReference: function (model, options) {
    delete this._byId[model.cid];
    const id = this.modelId(model.attributes);
    if (id != null) delete this._byId[id];
    if (this === model.collection) delete model.collection;
    model.off('all', this._onModelEvent, this);
  },
  // Internal method called every time a model in the set fires an event.
  // Sets need to update their indexes when models change ids. All other
  // events simply proxy through. "add" and "remove" events that originate
  // in other collections are ignored.
  _onModelEvent: function (event, model, collection, options) {
    if (model) {
      if ((event === 'add' || event === 'remove') && collection !== this) return;
      if (event === 'destroy') this.remove(model, options);
      if (event === 'change') {
        const prevId = this.modelId(model.previousAttributes());
        const id = this.modelId(model.attributes);
        if (prevId !== id) {
          if (prevId != null) delete this._byId[prevId];
          if (id != null) this._byId[id] = model;
        }
      }
    }
    this.trigger.apply(this, arguments);
  }
});

// Defining an @@iterator method implements JavaScript's Iterable protocol.
// In modern ES2015 browsers, this value is found at Symbol.iterator.
/* global Symbol */
const $$iterator = typeof Symbol === 'function' && Symbol.iterator;
if ($$iterator) {
  Collection.prototype[$$iterator] = Collection.prototype.values;
}

// CollectionIterator
// ------------------

// A CollectionIterator implements JavaScript's Iterator protocol, allowing the
// use of `for of` loops in modern browsers and interoperation between
// Collection and other JavaScript functions and third-party libraries
// which can operate on Iterables.
const CollectionIterator = function (collection, kind) {
  this._collection = collection;
  this._kind = kind;
  this._index = 0;
};

// This "enum" defines the three possible kinds of values which can be emitted
// by a CollectionIterator that correspond to the values(), keys() and entries()
// methods on Collection, respectively.
const ITERATOR_VALUES = 1;
const ITERATOR_KEYS = 2;
const ITERATOR_KEYSVALUES = 3;

// All Iterators should themselves be Iterable.
if ($$iterator) {
  CollectionIterator.prototype[$$iterator] = function () {
    return this;
  };
}
CollectionIterator.prototype.next = function () {
  if (this._collection) {
    // Only continue iterating if the iterated collection is long enough.
    if (this._index < this._collection.length) {
      const model = this._collection.at(this._index);
      this._index++;

      // Construct a value depending on what kind of values should be iterated.
      let value;
      if (this._kind === ITERATOR_VALUES) {
        value = model;
      } else {
        const id = this._collection.modelId(model.attributes);
        if (this._kind === ITERATOR_KEYS) {
          value = id;
        } else {
          // ITERATOR_KEYSVALUES
          value = [id, model];
        }
      }
      return {
        value: value,
        done: false
      };
    }

    // Once exhausted, remove the reference to the collection so future
    // calls to the next method always return done.
    this._collection = undefined;
  }
  return {
    value: undefined,
    done: true
  };
};

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/drivers/sessionStorage.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/drivers/sessionStorage.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! localforage/src/utils/executeCallback */ "./node_modules/localforage/src/utils/executeCallback.js");
/* harmony import */ var localforage_src_utils_getCallback__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! localforage/src/utils/getCallback */ "./node_modules/localforage/src/utils/getCallback.js");
/* harmony import */ var localforage_src_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! localforage/src/utils/normalizeKey */ "./node_modules/localforage/src/utils/normalizeKey.js");
/* harmony import */ var localforage_src_utils_serializer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! localforage/src/utils/serializer */ "./node_modules/localforage/src/utils/serializer.js");
// Copyright 2014 Mozilla
// Copyright 2015 Thodoris Greasidis
// Copyright 2018 JC Brand
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





const serialize = localforage_src_utils_serializer__WEBPACK_IMPORTED_MODULE_3__["default"].serialize;
const deserialize = localforage_src_utils_serializer__WEBPACK_IMPORTED_MODULE_3__["default"].deserialize;
function isSessionStorageValid() {
  // If the app is running inside a Google Chrome packaged webapp, or some
  // other context where sessionStorage isn't available, we don't use
  // sessionStorage. This feature detection is preferred over the old
  // `if (window.chrome && window.chrome.runtime)` code.
  // See: https://github.com/mozilla/localForage/issues/68
  try {
    // If sessionStorage isn't available, we get outta here!
    // This should be inside a try catch
    if (sessionStorage && 'setItem' in sessionStorage) {
      return true;
    }
  } catch (e) {
    console.log(e);
  }
  return false;
}
function _getKeyPrefix(options, defaultConfig) {
  let keyPrefix = options.name + '/';
  if (options.storeName !== defaultConfig.storeName) {
    keyPrefix += options.storeName + '/';
  }
  return keyPrefix;
}
const dbInfo = {
  'serializer': {
    'serialize': serialize,
    'deserialize': deserialize
  }
};
function _initStorage(options) {
  dbInfo.keyPrefix = _getKeyPrefix(options, this._defaultConfig);
  if (options) {
    for (const i in options) {
      // eslint-disable-line guard-for-in
      dbInfo[i] = options[i];
    }
  }
}

// Remove all keys from the datastore, effectively destroying all data in
// the app's key/value store!
function clear(callback) {
  const promise = this.ready().then(function () {
    const keyPrefix = dbInfo.keyPrefix;
    for (let i = sessionStorage.length - 1; i >= 0; i--) {
      const key = sessionStorage.key(i);
      if (key.indexOf(keyPrefix) === 0) {
        sessionStorage.removeItem(key);
      }
    }
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Retrieve an item from the store. Unlike the original async_storage
// library in Gaia, we don't modify return values at all. If a key's value
// is `undefined`, we pass that value to the callback function.
function getItem(key, callback) {
  key = (0,localforage_src_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_2__["default"])(key);
  const promise = this.ready().then(function () {
    let result = sessionStorage.getItem(dbInfo.keyPrefix + key);
    // If a result was found, parse it from the serialized
    // string into a JS object. If result isn't truthy, the key
    // is likely undefined and we'll pass it straight to the
    // callback.
    if (result) {
      result = dbInfo.serializer.deserialize(result);
    }
    return result;
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Iterate over all items in the store.
function iterate(iterator, callback) {
  const self = this;
  const promise = self.ready().then(function () {
    const keyPrefix = dbInfo.keyPrefix;
    const keyPrefixLength = keyPrefix.length;
    const length = sessionStorage.length;

    // We use a dedicated iterator instead of the `i` variable below
    // so other keys we fetch in sessionStorage aren't counted in
    // the `iterationNumber` argument passed to the `iterate()`
    // callback.
    //
    // See: github.com/mozilla/localForage/pull/435#discussion_r38061530
    let iterationNumber = 1;
    for (let i = 0; i < length; i++) {
      const key = sessionStorage.key(i);
      if (key.indexOf(keyPrefix) !== 0) {
        continue;
      }
      let value = sessionStorage.getItem(key);

      // If a result was found, parse it from the serialized
      // string into a JS object. If result isn't truthy, the
      // key is likely undefined and we'll pass it straight
      // to the iterator.
      if (value) {
        value = dbInfo.serializer.deserialize(value);
      }
      value = iterator(value, key.substring(keyPrefixLength), iterationNumber++);
      if (value !== void 0) {
        // eslint-disable-line no-void
        return value;
      }
    }
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Same as sessionStorage's key() method, except takes a callback.
function key(n, callback) {
  const self = this;
  const promise = self.ready().then(function () {
    let result;
    try {
      result = sessionStorage.key(n);
    } catch (error) {
      result = null;
    }

    // Remove the prefix from the key, if a key is found.
    if (result) {
      result = result.substring(dbInfo.keyPrefix.length);
    }
    return result;
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}
function keys(callback) {
  const self = this;
  const promise = self.ready().then(function () {
    const length = sessionStorage.length;
    const keys = [];
    for (let i = 0; i < length; i++) {
      const itemKey = sessionStorage.key(i);
      if (itemKey.indexOf(dbInfo.keyPrefix) === 0) {
        keys.push(itemKey.substring(dbInfo.keyPrefix.length));
      }
    }
    return keys;
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Supply the number of keys in the datastore to the callback function.
function length(callback) {
  const self = this;
  const promise = self.keys().then(function (keys) {
    return keys.length;
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Remove an item from the store, nice and simple.
function removeItem(key, callback) {
  key = (0,localforage_src_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_2__["default"])(key);
  const promise = this.ready().then(function () {
    sessionStorage.removeItem(dbInfo.keyPrefix + key);
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}

// Set a key's value and run an optional callback once the value is set.
// Unlike Gaia's implementation, the callback function is passed the value,
// in case you want to operate on that value only after you're sure it
// saved, or something like that.
function setItem(key, value, callback) {
  key = (0,localforage_src_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_2__["default"])(key);
  const promise = this.ready().then(function () {
    // Convert undefined values to null.
    // https://github.com/mozilla/localForage/pull/42
    if (value === undefined) {
      value = null;
    }

    // Save the original value to pass to the callback.
    const originalValue = value;
    return new Promise(function (resolve, reject) {
      dbInfo.serializer.serialize(value, function (value, error) {
        if (error) {
          reject(error);
        } else {
          try {
            sessionStorage.setItem(dbInfo.keyPrefix + key, value);
            resolve(originalValue);
          } catch (e) {
            // sessionStorage capacity exceeded.
            // TODO: Make this a specific error/event.
            if (e.name === 'QuotaExceededError' || e.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
              reject(e);
            }
            reject(e);
          }
        }
      });
    });
  });
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}
function dropInstance(options, callback) {
  callback = localforage_src_utils_getCallback__WEBPACK_IMPORTED_MODULE_1__["default"].apply(this, arguments);
  options = typeof options !== 'function' && options || {};
  if (!options.name) {
    const currentConfig = this.config();
    options.name = options.name || currentConfig.name;
    options.storeName = options.storeName || currentConfig.storeName;
  }
  const self = this;
  let promise;
  if (!options.name) {
    promise = Promise.reject(new Error('Invalid arguments'));
  } else {
    promise = new Promise(function (resolve) {
      if (!options.storeName) {
        resolve(`${options.name}/`);
      } else {
        resolve(_getKeyPrefix(options, self._defaultConfig));
      }
    }).then(function (keyPrefix) {
      for (let i = sessionStorage.length - 1; i >= 0; i--) {
        const key = sessionStorage.key(i);
        if (key.indexOf(keyPrefix) === 0) {
          sessionStorage.removeItem(key);
        }
      }
    });
  }
  (0,localforage_src_utils_executeCallback__WEBPACK_IMPORTED_MODULE_0__["default"])(promise, callback);
  return promise;
}
const sessionStorageWrapper = {
  _driver: 'sessionStorageWrapper',
  _initStorage: _initStorage,
  _support: isSessionStorageValid(),
  iterate: iterate,
  getItem: getItem,
  setItem: setItem,
  removeItem: removeItem,
  clear: clear,
  length: length,
  key: key,
  keys: keys,
  dropInstance: dropInstance
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (sessionStorageWrapper);

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/element.js":
/*!********************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/element.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ElementView": () => (/* binding */ ElementView)
/* harmony export */ });
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/isFunction.js */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/pick.js */ "./node_modules/lodash-es/pick.js");
/* harmony import */ var lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/uniqueId.js */ "./node_modules/lodash-es/uniqueId.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html */ "./node_modules/lit-html/development/lit-html.js");









const paddedLt = /^\s*</;

// Caches a local reference to `Element.prototype` for faster access.
const ElementProto = typeof Element !== 'undefined' && Element.prototype || {};

// Cached regex to split keys for `delegate`.
const delegateEventSplitter = /^(\S+)\s*(.*)$/;

// List of view options to be set as properties.
const viewOptions = ['model', 'collection', 'events'];
class ElementView extends HTMLElement {
  events = {};
  constructor(options) {
    super();
    // Creating a View creates its initial element outside of the DOM,
    // if an existing element is not provided...
    this.cid = (0,lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_3__["default"])('view');
    this._domEvents = [];
    (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_4__["default"])(this, (0,lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_5__["default"])(options, viewOptions));
  }
  createRenderRoot() {
    // Render without the shadow DOM
    return this;
  }
  connectedCallback() {
    if (!this._initialized) {
      this.preinitialize.apply(this, arguments);
      this.initialize.apply(this, arguments);
      this._initialized = true;
    }
    this.delegateEvents();
  }
  disconnectedCallback() {
    this.undelegateEvents();
    this.stopListening();
  }

  // preinitialize is an empty function by default. You can override it with a function
  // or object.  preinitialize will run before any instantiation logic is run in the View
  preinitialize() {// eslint-disable-line class-methods-use-this
  }

  // Initialize is an empty function by default. Override it with your own
  // initialization logic.
  initialize() {} // eslint-disable-line class-methods-use-this

  // **render** is the core function that your view should override, in order
  // to populate its element (`this.el`), with the appropriate HTML. The
  // convention is for **render** to always return `this`.
  render() {
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.beforeRender) && this.beforeRender();
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.toHTML) && (0,lit_html__WEBPACK_IMPORTED_MODULE_2__.render)(this.toHTML(), this);
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.afterRender) && this.afterRender();
    return this;
  }

  // Set callbacks, where `this.events` is a hash of
  //
  // *{"event selector": "callback"}*
  //
  //     {
  //       'mousedown .title':  'edit',
  //       'click .button':     'save',
  //       'click .open':       function(e) { ... }
  //     }
  //
  // pairs. Callbacks will be bound to the view, with `this` set properly.
  // Uses event delegation for efficiency.
  // Omitting the selector binds the event to `this.el`.
  delegateEvents() {
    if (!this.events) {
      return this;
    }
    this.undelegateEvents();
    for (const key in this.events) {
      let method = this.events[key];
      if (!(0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(method)) method = this[method];
      if (!method) continue;
      const match = key.match(delegateEventSplitter);
      this.delegate(match[1], match[2], method.bind(this));
    }
    return this;
  }

  // Make a event delegation handler for the given `eventName` and `selector`
  // and attach it to `this.el`.
  // If selector is empty, the listener will be bound to `this.el`. If not, a
  // new handler that will recursively traverse up the event target's DOM
  // hierarchy looking for a node that matches the selector. If one is found,
  // the event's `delegateTarget` property is set to it and the return the
  // result of calling bound `listener` with the parameters given to the
  // handler.
  delegate(eventName, selector, listener) {
    const root = this;
    if (!root) {
      return this;
    }
    if (typeof selector === 'function') {
      listener = selector;
      selector = null;
    }
    // Given that `focus` and `blur` events do not bubble, do not delegate these events
    if (['focus', 'blur'].indexOf(eventName) !== -1) {
      const els = this.querySelectorAll(selector);
      for (let i = 0, len = els.length; i < len; i++) {
        const item = els[i];
        item.addEventListener(eventName, listener, false);
        this._domEvents.push({
          el: item,
          eventName: eventName,
          handler: listener
        });
      }
      return listener;
    }
    const handler = selector ? function (e) {
      let node = e.target || e.srcElement;
      for (; node && node != root; node = node.parentNode) {
        if (node.matches(selector)) {
          e.delegateTarget = node;
          listener(e);
        }
      }
    } : listener;
    this.addEventListener(eventName, handler, false);
    this._domEvents.push({
      el: this,
      eventName: eventName,
      handler: handler,
      listener: listener,
      selector: selector
    });
    return this;
  }

  // Clears all callbacks previously bound to the view by `delegateEvents`.
  // You usually don't need to use this, but may wish to if you have multiple
  // Backbone views attached to the same DOM element.
  undelegateEvents() {
    if (this) {
      for (let i = 0, len = this._domEvents.length; i < len; i++) {
        const item = this._domEvents[i];
        item.el.removeEventListener(item.eventName, item.handler, false);
      }
      this._domEvents.length = 0;
    }
    return this;
  }

  // A finer-grained `undelegateEvents` for removing a single delegated event.
  // `selector` and `listener` are both optional.
  undelegate(eventName, selector, listener) {
    if (typeof selector === 'function') {
      listener = selector;
      selector = null;
    }
    if (this) {
      const handlers = this._domEvents.slice();
      let i = handlers.length;
      while (i--) {
        const item = handlers[i];
        const match = item.eventName === eventName && (listener ? item.listener === listener : true) && (selector ? item.selector === selector : true);
        if (!match) {
          continue;
        }
        item.el.removeEventListener(item.eventName, item.handler, false);
        this._domEvents.splice(i, 1);
      }
    }
    return this;
  }
}

// Set up all inheritable **View** properties and methods.
Object.assign(ElementView.prototype, _events_js__WEBPACK_IMPORTED_MODULE_0__.Events);

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/events.js":
/*!*******************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/events.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Events": () => (/* binding */ Events)
/* harmony export */ });
/* harmony import */ var lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash-es/isEmpty.js */ "./node_modules/lodash-es/isEmpty.js");
/* harmony import */ var lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash-es/keys.js */ "./node_modules/lodash-es/keys.js");
/* harmony import */ var lodash_es_once_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/once.js */ "./node_modules/lodash-es/once.js");
/* harmony import */ var lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es/uniqueId.js */ "./node_modules/lodash-es/uniqueId.js");
//     Backbone.js 1.4.0
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.

// Events
// ------

// A module that can be mixed in to *any object* in order to provide it with
// a custom event channel. You may bind a callback to an event with `on` or
// remove with `off`; `trigger`-ing an event fires all callbacks in
// succession.
//
//     let object = {};
//     extend(object, Backbone.Events);
//     object.on('expand', function(){ alert('expanded'); });
//     object.trigger('expand');
//





const Events = {};

// Regular expression used to split event strings.
const eventSplitter = /\s+/;

// A private global variable to share between listeners and listenees.
let _listening;

// Iterates over the standard `event, callback` (as well as the fancy multiple
// space-separated events `"change blur", callback` and jQuery-style event
// maps `{event: callback}`).
const eventsApi = function (iteratee, events, name, callback, opts) {
  let i = 0,
    names;
  if (name && typeof name === 'object') {
    // Handle event maps.
    if (callback !== undefined && 'context' in opts && opts.context === undefined) opts.context = callback;
    for (names = (0,lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(name); i < names.length; i++) {
      events = eventsApi(iteratee, events, names[i], name[names[i]], opts);
    }
  } else if (name && eventSplitter.test(name)) {
    // Handle space-separated event names by delegating them individually.
    for (names = name.split(eventSplitter); i < names.length; i++) {
      events = iteratee(events, names[i], callback, opts);
    }
  } else {
    // Finally, standard events.
    events = iteratee(events, name, callback, opts);
  }
  return events;
};

// Bind an event to a `callback` function. Passing `"all"` will bind
// the callback to all events fired.
Events.on = function (name, callback, context) {
  this._events = eventsApi(onApi, this._events || {}, name, callback, {
    context: context,
    ctx: this,
    listening: _listening
  });
  if (_listening) {
    const listeners = this._listeners || (this._listeners = {});
    listeners[_listening.id] = _listening;
    // Allow the listening to use a counter, instead of tracking
    // callbacks for library interop
    _listening.interop = false;
  }
  return this;
};

// Inversion-of-control versions of `on`. Tell *this* object to listen to
// an event in another object... keeping track of what it's listening to
// for easier unbinding later.
Events.listenTo = function (obj, name, callback) {
  if (!obj) return this;
  const id = obj._listenId || (obj._listenId = (0,lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_1__["default"])('l'));
  const listeningTo = this._listeningTo || (this._listeningTo = {});
  let listening = _listening = listeningTo[id];

  // This object is not listening to any other events on `obj` yet.
  // Setup the necessary references to track the listening callbacks.
  if (!listening) {
    this._listenId || (this._listenId = (0,lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_1__["default"])('l'));
    listening = _listening = listeningTo[id] = new Listening(this, obj);
  }

  // Bind callbacks on obj.
  const error = tryCatchOn(obj, name, callback, this);
  _listening = undefined;
  if (error) throw error;
  // If the target obj is not Backbone.Events, track events manually.
  if (listening.interop) listening.on(name, callback);
  return this;
};

// The reducing API that adds a callback to the `events` object.
const onApi = function (events, name, callback, options) {
  if (callback) {
    const handlers = events[name] || (events[name] = []);
    const context = options.context,
      ctx = options.ctx,
      listening = options.listening;
    if (listening) listening.count++;
    handlers.push({
      callback: callback,
      context: context,
      ctx: context || ctx,
      listening: listening
    });
  }
  return events;
};

// An try-catch guarded #on function, to prevent poisoning the global
// `_listening` variable.
const tryCatchOn = function (obj, name, callback, context) {
  try {
    obj.on(name, callback, context);
  } catch (e) {
    return e;
  }
};

// Remove one or many callbacks. If `context` is null, removes all
// callbacks with that function. If `callback` is null, removes all
// callbacks for the event. If `name` is null, removes all bound
// callbacks for all events.
Events.off = function (name, callback, context) {
  if (!this._events) return this;
  this._events = eventsApi(offApi, this._events, name, callback, {
    context: context,
    listeners: this._listeners
  });
  return this;
};

// Tell this object to stop listening to either specific events ... or
// to every object it's currently listening to.
Events.stopListening = function (obj, name, callback) {
  const listeningTo = this._listeningTo;
  if (!listeningTo) return this;
  const ids = obj ? [obj._listenId] : (0,lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(listeningTo);
  for (let i = 0; i < ids.length; i++) {
    const listening = listeningTo[ids[i]];

    // If listening doesn't exist, this object is not currently
    // listening to obj. Break out early.
    if (!listening) break;
    listening.obj.off(name, callback, this);
    if (listening.interop) listening.off(name, callback);
  }
  if ((0,lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_2__["default"])(listeningTo)) this._listeningTo = undefined;
  return this;
};

// The reducing API that removes a callback from the `events` object.
const offApi = function (events, name, callback, options) {
  if (!events) return;
  const context = options.context,
    listeners = options.listeners;
  let i = 0,
    names;

  // Delete all event listeners and "drop" events.
  if (!name && !context && !callback) {
    for (names = (0,lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(listeners); i < names.length; i++) {
      listeners[names[i]].cleanup();
    }
    return;
  }
  names = name ? [name] : (0,lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(events);
  for (; i < names.length; i++) {
    name = names[i];
    const handlers = events[name];

    // Bail out if there are no events stored.
    if (!handlers) {
      break;
    }

    // Find any remaining events.
    const remaining = [];
    for (let j = 0; j < handlers.length; j++) {
      const handler = handlers[j];
      if (callback && callback !== handler.callback && callback !== handler.callback._callback || context && context !== handler.context) {
        remaining.push(handler);
      } else {
        const listening = handler.listening;
        if (listening) listening.off(name, callback);
      }
    }

    // Replace events if there are any remaining.  Otherwise, clean up.
    if (remaining.length) {
      events[name] = remaining;
    } else {
      delete events[name];
    }
  }
  return events;
};

// Bind an event to only be triggered a single time. After the first time
// the callback is invoked, its listener will be removed. If multiple events
// are passed in using the space-separated syntax, the handler will fire
// once for each event, not once for a combination of all events.
Events.once = function (name, callback, context) {
  // Map the event into a `{event: once}` object.
  const events = eventsApi(onceMap, {}, name, callback, this.off.bind(this));
  if (typeof name === 'string' && (context === null || context === undefined)) callback = undefined;
  return this.on(events, callback, context);
};

// Inversion-of-control versions of `once`.
Events.listenToOnce = function (obj, name, callback) {
  // Map the event into a `{event: once}` object.
  const events = eventsApi(onceMap, {}, name, callback, this.stopListening.bind(this, obj));
  return this.listenTo(obj, events);
};

// Reduces the event callbacks into a map of `{event: onceWrapper}`.
// `offer` unbinds the `onceWrapper` after it has been called.
const onceMap = function (map, name, callback, offer) {
  if (callback) {
    const _once = map[name] = (0,lodash_es_once_js__WEBPACK_IMPORTED_MODULE_3__["default"])(function () {
      offer(name, _once);
      callback.apply(this, arguments);
    });
    _once._callback = callback;
  }
  return map;
};

// Trigger one or many events, firing all bound callbacks. Callbacks are
// passed the same arguments as `trigger` is, apart from the event name
// (unless you're listening on `"all"`, which will cause your callback to
// receive the true name of the event as the first argument).
Events.trigger = function (name) {
  if (!this._events) return this;
  const length = Math.max(0, arguments.length - 1);
  const args = Array(length);
  for (let i = 0; i < length; i++) args[i] = arguments[i + 1];
  eventsApi(triggerApi, this._events, name, undefined, args);
  return this;
};

// Handles triggering the appropriate event callbacks.
const triggerApi = function (objEvents, name, callback, args) {
  if (objEvents) {
    const events = objEvents[name];
    let allEvents = objEvents.all;
    if (events && allEvents) allEvents = allEvents.slice();
    if (events) triggerEvents(events, args);
    if (allEvents) triggerEvents(allEvents, [name].concat(args));
  }
  return objEvents;
};

// A difficult-to-believe, but optimized internal dispatch function for
// triggering events. Tries to keep the usual cases speedy (most internal
// Backbone events have 3 arguments).
const triggerEvents = function (events, args) {
  let ev,
    i = -1;
  const l = events.length,
    a1 = args[0],
    a2 = args[1],
    a3 = args[2];
  switch (args.length) {
    case 0:
      while (++i < l) (ev = events[i]).callback.call(ev.ctx);
      return;
    case 1:
      while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1);
      return;
    case 2:
      while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2);
      return;
    case 3:
      while (++i < l) (ev = events[i]).callback.call(ev.ctx, a1, a2, a3);
      return;
    default:
      while (++i < l) (ev = events[i]).callback.apply(ev.ctx, args);
      return;
  }
};

// A listening class that tracks and cleans up memory bindings
// when all callbacks have been offed.
const Listening = function (listener, obj) {
  this.id = listener._listenId;
  this.listener = listener;
  this.obj = obj;
  this.interop = true;
  this.count = 0;
  this._events = undefined;
};
Listening.prototype.on = Events.on;

// Offs a callback (or several).
// Uses an optimized counter if the listenee uses Backbone.Events.
// Otherwise, falls back to manual tracking to support events
// library interop.
Listening.prototype.off = function (name, callback) {
  let cleanup;
  if (this.interop) {
    this._events = eventsApi(offApi, this._events, name, callback, {
      context: undefined,
      listeners: undefined
    });
    cleanup = !this._events;
  } else {
    this.count--;
    cleanup = this.count === 0;
  }
  if (cleanup) this.cleanup();
};

// Cleans up memory bindings between the listener and the listenee.
Listening.prototype.cleanup = function () {
  delete this.listener._listeningTo[this.obj._listenId];
  if (!this.interop) delete this.obj._listeners[this.id];
};

// Aliases for backwards compatibility.
Events.bind = Events.on;
Events.unbind = Events.off;

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/helpers.js":
/*!********************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/helpers.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotImplementedError": () => (/* binding */ NotImplementedError),
/* harmony export */   "ajax": () => (/* binding */ ajax),
/* harmony export */   "getResolveablePromise": () => (/* binding */ getResolveablePromise),
/* harmony export */   "getSyncMethod": () => (/* binding */ getSyncMethod),
/* harmony export */   "inherits": () => (/* binding */ inherits),
/* harmony export */   "sync": () => (/* binding */ sync),
/* harmony export */   "urlError": () => (/* binding */ urlError),
/* harmony export */   "wrapError": () => (/* binding */ wrapError)
/* harmony export */ });
/* harmony import */ var lodash_es_create_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash-es/create.js */ "./node_modules/lodash-es/create.js");
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_has_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash-es/has.js */ "./node_modules/lodash-es/has.js");
/* harmony import */ var lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/result.js */ "./node_modules/lodash-es/result.js");
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud






/**
 * Custom error for indicating timeouts
 * @namespace _converse
 */
class NotImplementedError extends Error {}

// Helpers
// -------

// Helper function to correctly set up the prototype chain for subclasses.
// Similar to `goog.inherits`, but uses a hash of prototype properties and
// class properties to be extended.
//
function inherits(protoProps, staticProps) {
  const parent = this;
  let child;

  // The constructor function for the new subclass is either defined by you
  // (the "constructor" property in your `extend` definition), or defaulted
  // by us to simply call the parent constructor.
  if (protoProps && (0,lodash_es_has_js__WEBPACK_IMPORTED_MODULE_0__["default"])(protoProps, 'constructor')) {
    child = protoProps.constructor;
  } else {
    child = function () {
      return parent.apply(this, arguments);
    };
  }

  // Add static properties to the constructor function, if supplied.
  (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_1__["default"])(child, parent, staticProps);

  // Set the prototype chain to inherit from `parent`, without calling
  // `parent`'s constructor function and add the prototype properties.
  child.prototype = (0,lodash_es_create_js__WEBPACK_IMPORTED_MODULE_2__["default"])(parent.prototype, protoProps);
  child.prototype.constructor = child;

  // Set a convenience property in case the parent's prototype is needed
  // later.
  child.__super__ = parent.prototype;
  return child;
}
function getResolveablePromise() {
  const wrapper = {
    isResolved: false,
    isPending: true,
    isRejected: false
  };
  const promise = new Promise((resolve, reject) => {
    wrapper.resolve = resolve;
    wrapper.reject = reject;
  });
  Object.assign(promise, wrapper);
  promise.then(function (v) {
    promise.isResolved = true;
    promise.isPending = false;
    promise.isRejected = false;
    return v;
  }, function (e) {
    promise.isResolved = false;
    promise.isPending = false;
    promise.isRejected = true;
    throw e;
  });
  return promise;
}

// Throw an error when a URL is needed, and none is supplied.
function urlError() {
  throw new Error('A "url" property or function must be specified');
}

// Wrap an optional error callback with a fallback error event.
function wrapError(model, options) {
  const error = options.error;
  options.error = function (resp) {
    if (error) error.call(options.context, model, resp, options);
    model.trigger('error', model, resp, options);
  };
}

// Map from CRUD to HTTP for our default `sync` implementation.
const methodMap = {
  create: 'POST',
  update: 'PUT',
  patch: 'PATCH',
  delete: 'DELETE',
  read: 'GET'
};
function getSyncMethod(model) {
  const store = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(model, 'browserStorage') || (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(model.collection, 'browserStorage');
  return store ? store.sync() : sync;
}

// sync
// ----

// Override this function to change the manner in which Backbone persists
// models to the server. You will be passed the type of request, and the
// model in question. By default, makes a RESTful Ajax request
// to the model's `url()`. Some possible customizations could be:
//
// * Use `setTimeout` to batch rapid-fire updates into a single request.
// * Send up the models as XML instead of JSON.
// * Persist models via WebSockets instead of Ajax.
//
function sync(method, model) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const type = methodMap[method];

  // Default JSON-request options.
  const params = {
    type: type,
    dataType: 'json'
  };

  // Ensure that we have a URL.
  if (!options.url) {
    params.url = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(model, 'url') || urlError();
  }

  // Ensure that we have the appropriate request data.
  if (options.data == null && model && (method === 'create' || method === 'update' || method === 'patch')) {
    params.contentType = 'application/json';
    params.data = JSON.stringify(options.attrs || model.toJSON(options));
  }

  // Don't process data on a non-GET request.
  if (params.type !== 'GET') {
    params.processData = false;
  }

  // Pass along `textStatus` and `errorThrown` from jQuery.
  const error = options.error;
  options.error = function (xhr, textStatus, errorThrown) {
    options.textStatus = textStatus;
    options.errorThrown = errorThrown;
    if (error) error.call(options.context, xhr, textStatus, errorThrown);
  };

  // Make the request, allowing the user to override any Ajax options.
  const xhr = options.xhr = ajax((0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_1__["default"])(params, options));
  model.trigger('request', model, xhr, options);
  return xhr;
}
function ajax() {
  return fetch.apply(this, arguments);
}

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/history.js":
/*!********************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/history.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_some_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/some.js */ "./node_modules/lodash-es/some.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
//  Backbone.js 1.4.0
//  (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//  Backbone may be freely distributed under the MIT license.






// History
// -------

// Handles cross-browser history management, based on either
// [pushState](http://diveintohtml5.info/history.html) and real URLs, or
// [onhashchange](https://developer.mozilla.org/en-US/docs/DOM/window.onhashchange)
// and URL fragments. If the browser supports neither (old IE, natch),
// falls back to polling.
const History = function () {
  this.handlers = [];
  this.checkUrl = this.checkUrl.bind(this);

  // Ensure that `History` can be used outside of the browser.
  if (typeof window !== 'undefined') {
    this.location = window.location;
    this.history = window.history;
  }
};
History.extend = _helpers_js__WEBPACK_IMPORTED_MODULE_1__.inherits;

// Cached regex for stripping a leading hash/slash and trailing space.
const routeStripper = /^[#\/]|\s+$/g;
// Cached regex for stripping leading and trailing slashes.
const rootStripper = /^\/+|\/+$/g;
// Cached regex for stripping urls of hash.
const pathStripper = /#.*$/;

// Has the history handling already been started?
History.started = false;

// Set up all inheritable **History** properties and methods.
Object.assign(History.prototype, _events_js__WEBPACK_IMPORTED_MODULE_0__.Events, {
  // The default interval to poll for hash changes, if necessary, is
  // twenty times a second.
  interval: 50,
  // Are we at the app root?
  atRoot: function () {
    const path = this.location.pathname.replace(/[^\/]$/, '$&/');
    return path === this.root && !this.getSearch();
  },
  // Does the pathname match the root?
  matchRoot: function () {
    const path = this.decodeFragment(this.location.pathname);
    const rootPath = path.slice(0, this.root.length - 1) + '/';
    return rootPath === this.root;
  },
  // Unicode characters in `location.pathname` are percent encoded so they're
  // decoded for comparison. `%25` should not be decoded since it may be part
  // of an encoded parameter.
  decodeFragment: function (fragment) {
    return decodeURI(fragment.replace(/%25/g, '%2525'));
  },
  // In IE6, the hash fragment and search params are incorrect if the
  // fragment contains `?`.
  getSearch: function () {
    const match = this.location.href.replace(/#.*/, '').match(/\?.+/);
    return match ? match[0] : '';
  },
  // Gets the true hash value. Cannot use location.hash directly due to bug
  // in Firefox where location.hash will always be decoded.
  getHash: function (window) {
    const match = (window || this).location.href.match(/#(.*)$/);
    return match ? match[1] : '';
  },
  // Get the pathname and search params, without the root.
  getPath: function () {
    const path = this.decodeFragment(this.location.pathname + this.getSearch()).slice(this.root.length - 1);
    return path.charAt(0) === '/' ? path.slice(1) : path;
  },
  // Get the cross-browser normalized URL fragment from the path or hash.
  getFragment: function (fragment) {
    if (fragment == null) {
      if (this._usePushState || !this._wantsHashChange) {
        fragment = this.getPath();
      } else {
        fragment = this.getHash();
      }
    }
    return fragment.replace(routeStripper, '');
  },
  // Start the hash change handling, returning `true` if the current URL matches
  // an existing route, and `false` otherwise.
  start: function (options) {
    if (History.started) throw new Error('history has already been started');
    History.started = true;

    // Figure out the initial configuration. Do we need an iframe?
    // Is pushState desired ... is it available?
    this.options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
      root: '/'
    }, this.options, options);
    this.root = this.options.root;
    this._wantsHashChange = this.options.hashChange !== false;
    this._hasHashChange = 'onhashchange' in window && (document.documentMode === undefined || document.documentMode > 7);
    this._useHashChange = this._wantsHashChange && this._hasHashChange;
    this._wantsPushState = !!this.options.pushState;
    this._hasPushState = !!(this.history && this.history.pushState);
    this._usePushState = this._wantsPushState && this._hasPushState;
    this.fragment = this.getFragment();

    // Normalize root to always include a leading and trailing slash.
    this.root = ('/' + this.root + '/').replace(rootStripper, '/');

    // Transition from hashChange to pushState or vice versa if both are
    // requested.
    if (this._wantsHashChange && this._wantsPushState) {
      // If we've started off with a route from a `pushState`-enabled
      // browser, but we're currently in a browser that doesn't support it...
      if (!this._hasPushState && !this.atRoot()) {
        const rootPath = this.root.slice(0, -1) || '/';
        this.location.replace(rootPath + '#' + this.getPath());
        // Return immediately as browser will do redirect to new url
        return true;

        // Or if we've started out with a hash-based route, but we're currently
        // in a browser where it could be `pushState`-based instead...
      } else if (this._hasPushState && this.atRoot()) {
        this.navigate(this.getHash(), {
          replace: true
        });
      }
    }

    // Proxy an iframe to handle location events if the browser doesn't
    // support the `hashchange` event, HTML5 history, or the user wants
    // `hashChange` but not `pushState`.
    if (!this._hasHashChange && this._wantsHashChange && !this._usePushState) {
      this.iframe = document.createElement('iframe');
      this.iframe.src = 'javascript:0';
      this.iframe.style.display = 'none';
      this.iframe.tabIndex = -1;
      const body = document.body;
      // Using `appendChild` will throw on IE < 9 if the document is not ready.
      const iWindow = body.insertBefore(this.iframe, body.firstChild).contentWindow;
      iWindow.document.open();
      iWindow.document.close();
      iWindow.location.hash = '#' + this.fragment;
    }

    // Depending on whether we're using pushState or hashes, and whether
    // 'onhashchange' is supported, determine how we check the URL state.
    if (this._usePushState) {
      addEventListener('popstate', this.checkUrl, false);
    } else if (this._useHashChange && !this.iframe) {
      addEventListener('hashchange', this.checkUrl, false);
    } else if (this._wantsHashChange) {
      this._checkUrlInterval = setInterval(this.checkUrl, this.interval);
    }
    if (!this.options.silent) return this.loadUrl();
  },
  // Disable history, perhaps temporarily. Not useful in a real app,
  // but possibly useful for unit testing Routers.
  stop: function () {
    // Remove window listeners.
    if (this._usePushState) {
      removeEventListener('popstate', this.checkUrl, false);
    } else if (this._useHashChange && !this.iframe) {
      removeEventListener('hashchange', this.checkUrl, false);
    }

    // Clean up the iframe if necessary.
    if (this.iframe) {
      document.body.removeChild(this.iframe);
      this.iframe = null;
    }

    // Some environments will throw when clearing an undefined interval.
    if (this._checkUrlInterval) clearInterval(this._checkUrlInterval);
    History.started = false;
  },
  // Add a route to be tested when the fragment changes. Routes added later
  // may override previous routes.
  route: function (route, callback) {
    this.handlers.unshift({
      route: route,
      callback: callback
    });
  },
  // Checks the current URL to see if it has changed, and if it has,
  // calls `loadUrl`, normalizing across the hidden iframe.
  checkUrl: function (e) {
    let current = this.getFragment();

    // If the user pressed the back button, the iframe's hash will have
    // changed and we should use that for comparison.
    if (current === this.fragment && this.iframe) {
      current = this.getHash(this.iframe.contentWindow);
    }
    if (current === this.fragment) return false;
    if (this.iframe) this.navigate(current);
    this.loadUrl();
  },
  // Attempt to load the current URL fragment. If a route succeeds with a
  // match, returns `true`. If no defined routes matches the fragment,
  // returns `false`.
  loadUrl: function (fragment) {
    // If the root doesn't match, no routes can match either.
    if (!this.matchRoot()) return false;
    fragment = this.fragment = this.getFragment(fragment);
    return (0,lodash_es_some_js__WEBPACK_IMPORTED_MODULE_3__["default"])(this.handlers, function (handler) {
      if (handler.route.test(fragment)) {
        handler.callback(fragment);
        return true;
      }
    });
  },
  // Save a fragment into the hash history, or replace the URL state if the
  // 'replace' option is passed. You are responsible for properly URL-encoding
  // the fragment in advance.
  //
  // The options object can contain `trigger: true` if you wish to have the
  // route callback be fired (not usually desirable), or `replace: true`, if
  // you wish to modify the current URL without adding an entry to the history.
  navigate: function (fragment, options) {
    if (!History.started) return false;
    if (!options || options === true) options = {
      trigger: !!options
    };

    // Normalize the fragment.
    fragment = this.getFragment(fragment || '');

    // Don't include a trailing slash on the root.
    let rootPath = this.root;
    if (fragment === '' || fragment.charAt(0) === '?') {
      rootPath = rootPath.slice(0, -1) || '/';
    }
    const url = rootPath + fragment;

    // Strip the fragment of the query and hash for matching.
    fragment = fragment.replace(pathStripper, '');

    // Decode for matching.
    const decodedFragment = this.decodeFragment(fragment);
    if (this.fragment === decodedFragment) return;
    this.fragment = decodedFragment;

    // If pushState is available, we use it to set the fragment as a real URL.
    if (this._usePushState) {
      this.history[options.replace ? 'replaceState' : 'pushState']({}, document.title, url);

      // If hash changes haven't been explicitly disabled, update the hash
      // fragment to store history.
    } else if (this._wantsHashChange) {
      this._updateHash(this.location, fragment, options.replace);
      if (this.iframe && fragment !== this.getHash(this.iframe.contentWindow)) {
        const iWindow = this.iframe.contentWindow;

        // Opening and closing the iframe tricks IE7 and earlier to push a
        // history entry on hash-tag change.  When replace is true, we don't
        // want this.
        if (!options.replace) {
          iWindow.document.open();
          iWindow.document.close();
        }
        this._updateHash(iWindow.location, fragment, options.replace);
      }
      // If you've told us that you explicitly don't want fallback hashchange-
      // based history, then `navigate` becomes a page refresh.
    } else {
      return this.location.assign(url);
    }
    if (options.trigger) return this.loadUrl(fragment);
  },
  // Update the hash location, either replacing the current entry, or adding
  // a new one to the browser history.
  _updateHash: function (location, fragment, replace) {
    if (replace) {
      const href = location.href.replace(/(javascript:|#).*$/, '');
      location.replace(href + '#' + fragment);
    } else {
      // Some browsers require that `hash` contains a leading #.
      location.hash = '#' + fragment;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (History);

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/model.js":
/*!******************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/model.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Model": () => (/* binding */ Model)
/* harmony export */ });
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/clone.js */ "./node_modules/lodash-es/clone.js");
/* harmony import */ var lodash_es_defaults_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/defaults.js */ "./node_modules/lodash-es/defaults.js");
/* harmony import */ var lodash_es_defer_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! lodash-es/defer.js */ "./node_modules/lodash-es/defer.js");
/* harmony import */ var lodash_es_escape_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lodash-es/escape.js */ "./node_modules/lodash-es/escape.js");
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_has_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! lodash-es/has.js */ "./node_modules/lodash-es/has.js");
/* harmony import */ var lodash_es_invert_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash-es/invert.js */ "./node_modules/lodash-es/invert.js");
/* harmony import */ var lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash-es/isEmpty.js */ "./node_modules/lodash-es/isEmpty.js");
/* harmony import */ var lodash_es_isEqual_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lodash-es/isEqual.js */ "./node_modules/lodash-es/isEqual.js");
/* harmony import */ var lodash_es_iteratee_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash-es/iteratee.js */ "./node_modules/lodash-es/iteratee.js");
/* harmony import */ var lodash_es_omit_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es/omit.js */ "./node_modules/lodash-es/omit.js");
/* harmony import */ var lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es/pick.js */ "./node_modules/lodash-es/pick.js");
/* harmony import */ var lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/result.js */ "./node_modules/lodash-es/result.js");
/* harmony import */ var lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash-es/uniqueId.js */ "./node_modules/lodash-es/uniqueId.js");
//     Backbone.js 1.4.0
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.

// Model
// -----
// **Models** are the basic data object in the framework --
// frequently representing a row in a table in a database on your server.
// A discrete chunk of data and a bunch of useful, related methods for
// performing computations and transformations on that data.

// Create a new model with the specified attributes. A client id (`cid`)
// is automatically generated and assigned for you.



















const Model = function (attributes, options) {
  let attrs = attributes || {};
  options || (options = {});
  this.preinitialize.apply(this, arguments);
  this.cid = (0,lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_2__["default"])(this.cidPrefix);
  this.attributes = {};
  if (options.collection) this.collection = options.collection;
  if (options.parse) attrs = this.parse(attrs, options) || {};
  const default_attrs = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'defaults');
  attrs = (0,lodash_es_defaults_js__WEBPACK_IMPORTED_MODULE_4__["default"])((0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, default_attrs, attrs), default_attrs);
  this.set(attrs, options);
  this.changed = {};
  this.initialize.apply(this, arguments);
};
Model.extend = _helpers_js__WEBPACK_IMPORTED_MODULE_0__.inherits;

// Attach all inheritable methods to the Model prototype.
Object.assign(Model.prototype, _events_js__WEBPACK_IMPORTED_MODULE_1__.Events, {
  // A hash of attributes whose current and previous value differ.
  changed: null,
  // The value returned during the last failed validation.
  validationError: null,
  // The default name for the JSON `id` attribute is `"id"`. MongoDB and
  // CouchDB users may want to set this to `"_id"`.
  idAttribute: 'id',
  // The prefix is used to create the client id which is used to identify models locally.
  // You may want to override this if you're experiencing name clashes with model ids.
  cidPrefix: 'c',
  // preinitialize is an empty function by default. You can override it with a function
  // or object.  preinitialize will run before any instantiation logic is run in the Model.
  preinitialize: function () {},
  // Initialize is an empty function by default. Override it with your own
  // initialization logic.
  initialize: function () {},
  // Return a copy of the model's `attributes` object.
  toJSON: function (options) {
    return (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.attributes);
  },
  // Proxy `Backbone.sync` by default -- but override this if you need
  // custom syncing semantics for *this* particular model.
  sync: function (method, model, options) {
    return (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.getSyncMethod)(this)(method, model, options);
  },
  // Get the value of an attribute.
  get: function (attr) {
    return this.attributes[attr];
  },
  keys: function () {
    return Object.keys(this.attributes);
  },
  values: function () {
    return Object.values(this.attributes);
  },
  pairs: function () {
    return this.entries();
  },
  entries: function () {
    return Object.entries(this.attributes);
  },
  invert: function () {
    return (0,lodash_es_invert_js__WEBPACK_IMPORTED_MODULE_7__["default"])(this.attributes);
  },
  pick: function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    if (args.length === 1 && Array.isArray(args[0])) {
      args = args[0];
    }
    return (0,lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this.attributes, args);
  },
  omit: function () {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    if (args.length === 1 && Array.isArray(args[0])) {
      args = args[0];
    }
    return (0,lodash_es_omit_js__WEBPACK_IMPORTED_MODULE_9__["default"])(this.attributes, args);
  },
  isEmpty: function () {
    return (0,lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_10__["default"])(this.attributes);
  },
  // Get the HTML-escaped value of an attribute.
  escape: function (attr) {
    return (0,lodash_es_escape_js__WEBPACK_IMPORTED_MODULE_11__["default"])(this.get(attr));
  },
  // Returns `true` if the attribute contains a value that is not null
  // or undefined.
  has: function (attr) {
    return this.get(attr) != null;
  },
  // Special-cased proxy to lodash's `matches` method.
  matches: function (attrs) {
    return !!(0,lodash_es_iteratee_js__WEBPACK_IMPORTED_MODULE_12__["default"])(attrs, this)(this.attributes);
  },
  // Set a hash of model attributes on the object, firing `"change"`. This is
  // the core primitive operation of a model, updating the data and notifying
  // anyone who needs to know about the change in state. The heart of the beast.
  set: function (key, val, options) {
    if (key == null) return this;

    // Handle both `"key", value` and `{key: value}` -style arguments.
    let attrs;
    if (typeof key === 'object') {
      attrs = key;
      options = val;
    } else {
      (attrs = {})[key] = val;
    }
    options || (options = {});

    // Run validation.
    if (!this._validate(attrs, options)) return false;

    // Extract attributes and options.
    const unset = options.unset;
    const silent = options.silent;
    const changes = [];
    const changing = this._changing;
    this._changing = true;
    if (!changing) {
      this._previousAttributes = (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.attributes);
      this.changed = {};
    }
    const current = this.attributes;
    const changed = this.changed;
    const prev = this._previousAttributes;

    // For each `set` attribute, update or delete the current value.
    for (const attr in attrs) {
      val = attrs[attr];
      if (!(0,lodash_es_isEqual_js__WEBPACK_IMPORTED_MODULE_13__["default"])(current[attr], val)) changes.push(attr);
      if (!(0,lodash_es_isEqual_js__WEBPACK_IMPORTED_MODULE_13__["default"])(prev[attr], val)) {
        changed[attr] = val;
      } else {
        delete changed[attr];
      }
      unset ? delete current[attr] : current[attr] = val;
    }

    // Update the `id`.
    if (this.idAttribute in attrs) this.id = this.get(this.idAttribute);

    // Trigger all relevant attribute changes.
    if (!silent) {
      if (changes.length) this._pending = options;
      for (let i = 0; i < changes.length; i++) {
        this.trigger('change:' + changes[i], this, current[changes[i]], options);
      }
    }

    // You might be wondering why there's a `while` loop here. Changes can
    // be recursively nested within `"change"` events.
    if (changing) return this;
    if (!silent) {
      while (this._pending) {
        options = this._pending;
        this._pending = false;
        this.trigger('change', this, options);
      }
    }
    this._pending = false;
    this._changing = false;
    return this;
  },
  // Remove an attribute from the model, firing `"change"`. `unset` is a noop
  // if the attribute doesn't exist.
  unset: function (attr, options) {
    return this.set(attr, undefined, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, options, {
      unset: true
    }));
  },
  // Clear all attributes on the model, firing `"change"`.
  clear: function (options) {
    const attrs = {};
    for (const key in this.attributes) attrs[key] = undefined;
    return this.set(attrs, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, options, {
      unset: true
    }));
  },
  // Determine if the model has changed since the last `"change"` event.
  // If you specify an attribute name, determine if that attribute has changed.
  hasChanged: function (attr) {
    if (attr == null) return !(0,lodash_es_isEmpty_js__WEBPACK_IMPORTED_MODULE_10__["default"])(this.changed);
    return (0,lodash_es_has_js__WEBPACK_IMPORTED_MODULE_14__["default"])(this.changed, attr);
  },
  // Return an object containing all the attributes that have changed, or
  // false if there are no changed attributes. Useful for determining what
  // parts of a view need to be updated and/or what attributes need to be
  // persisted to the server. Unset attributes will be set to undefined.
  // You can also pass an attributes object to diff against the model,
  // determining if there *would be* a change.
  changedAttributes: function (diff) {
    if (!diff) return this.hasChanged() ? (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.changed) : false;
    const old = this._changing ? this._previousAttributes : this.attributes;
    const changed = {};
    let hasChanged;
    for (const attr in diff) {
      const val = diff[attr];
      if ((0,lodash_es_isEqual_js__WEBPACK_IMPORTED_MODULE_13__["default"])(old[attr], val)) continue;
      changed[attr] = val;
      hasChanged = true;
    }
    return hasChanged ? changed : false;
  },
  // Get the previous value of an attribute, recorded at the time the last
  // `"change"` event was fired.
  previous: function (attr) {
    if (attr == null || !this._previousAttributes) return null;
    return this._previousAttributes[attr];
  },
  // Get all of the attributes of the model at the time of the previous
  // `"change"` event.
  previousAttributes: function () {
    return (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this._previousAttributes);
  },
  // Fetch the model from the server, merging the response with the model's
  // local attributes. Any changed attributes will trigger a "change" event.
  fetch: function (options) {
    options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({
      parse: true
    }, options);
    const model = this;
    const success = options.success;
    options.success = function (resp) {
      const serverAttrs = options.parse ? model.parse(resp, options) : resp;
      if (!model.set(serverAttrs, options)) return false;
      if (success) success.call(options.context, model, resp, options);
      model.trigger('sync', model, resp, options);
    };
    (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.wrapError)(this, options);
    return this.sync('read', this, options);
  },
  // Set a hash of model attributes, and sync the model to the server.
  // If the server returns an attributes hash that differs, the model's
  // state will be `set` again.
  save: function (key, val, options) {
    // Handle both `"key", value` and `{key: value}` -style arguments.
    let attrs;
    if (key == null || typeof key === 'object') {
      attrs = key;
      options = val;
    } else {
      (attrs = {})[key] = val;
    }
    options = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({
      validate: true,
      parse: true
    }, options);
    const wait = options.wait;
    const return_promise = options.promise;
    const promise = return_promise && (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.getResolveablePromise)();

    // If we're not waiting and attributes exist, save acts as
    // `set(attr).save(null, opts)` with validation. Otherwise, check if
    // the model will be valid when the attributes, if any, are set.
    if (attrs && !wait) {
      if (!this.set(attrs, options)) return false;
    } else if (!this._validate(attrs, options)) {
      return false;
    }

    // After a successful server-side save, the client is (optionally)
    // updated with the server-side state.
    const model = this;
    const success = options.success;
    const error = options.error;
    const attributes = this.attributes;
    options.success = function (resp) {
      // Ensure attributes are restored during synchronous saves.
      model.attributes = attributes;
      let serverAttrs = options.parse ? model.parse(resp, options) : resp;
      if (wait) serverAttrs = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, attrs, serverAttrs);
      if (serverAttrs && !model.set(serverAttrs, options)) return false;
      if (success) success.call(options.context, model, resp, options);
      model.trigger('sync', model, resp, options);
      return_promise && promise.resolve();
    };
    options.error = function (model, e, options) {
      error && error.call(options.context, model, e, options);
      return_promise && promise.reject(e);
    };
    (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.wrapError)(this, options);

    // Set temporary attributes if `{wait: true}` to properly find new ids.
    if (attrs && wait) this.attributes = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, attributes, attrs);
    const method = this.isNew() ? 'create' : options.patch ? 'patch' : 'update';
    if (method === 'patch' && !options.attrs) options.attrs = attrs;
    const xhr = this.sync(method, this, options);

    // Restore attributes.
    this.attributes = attributes;
    if (return_promise) {
      return promise;
    } else {
      return xhr;
    }
  },
  // Destroy this model on the server if it was already persisted.
  // Optimistically removes the model from its collection, if it has one.
  // If `wait: true` is passed, waits for the server to respond before removal.
  destroy: function (options) {
    options = options ? (0,lodash_es_clone_js__WEBPACK_IMPORTED_MODULE_6__["default"])(options) : {};
    const model = this;
    const success = options.success;
    const wait = options.wait;
    const destroy = function () {
      model.stopListening();
      model.trigger('destroy', model, model.collection, options);
    };
    options.success = function (resp) {
      if (wait) destroy();
      if (success) success.call(options.context, model, resp, options);
      if (!model.isNew()) model.trigger('sync', model, resp, options);
    };
    let xhr = false;
    if (this.isNew()) {
      (0,lodash_es_defer_js__WEBPACK_IMPORTED_MODULE_15__["default"])(options.success);
    } else {
      (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.wrapError)(this, options);
      xhr = this.sync('delete', this, options);
    }
    if (!wait) destroy();
    return xhr;
  },
  // Default URL for the model's representation on the server -- if you're
  // using Backbone's restful methods, override this to change the endpoint
  // that will be called.
  url: function () {
    const base = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'urlRoot') || (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_3__["default"])(this.collection, 'url') || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.urlError)();
    if (this.isNew()) return base;
    const id = this.get(this.idAttribute);
    return base.replace(/[^\/]$/, '$&/') + encodeURIComponent(id);
  },
  // **parse** converts a response into the hash of attributes to be `set` on
  // the model. The default implementation is just to pass the response along.
  parse: function (resp, options) {
    return resp;
  },
  // Create a new model with identical attributes to this one.
  clone: function () {
    return new this.constructor(this.attributes);
  },
  // A model is new if it has never been saved to the server, and lacks an id.
  isNew: function () {
    return !this.has(this.idAttribute);
  },
  // Check if the model is currently in a valid state.
  isValid: function (options) {
    return this._validate({}, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, options, {
      validate: true
    }));
  },
  // Run validation against the next complete set of model attributes,
  // returning `true` if all is well. Otherwise, fire an `"invalid"` event.
  _validate: function (attrs, options) {
    if (!options.validate || !this.validate) return true;
    attrs = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])({}, this.attributes, attrs);
    const error = this.validationError = this.validate(attrs, options) || null;
    if (!error) return true;
    this.trigger('invalid', this, error, (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_5__["default"])(options, {
      validationError: error
    }));
    return false;
  }
});

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/router.js":
/*!*******************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/router.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Router": () => (/* binding */ Router)
/* harmony export */ });
/* harmony import */ var _history_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./history.js */ "./node_modules/@converse/skeletor/src/history.js");
/* harmony import */ var lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/isFunction.js */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var lodash_es_isRegExp_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/isRegExp.js */ "./node_modules/lodash-es/isRegExp.js");
/* harmony import */ var lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/keys.js */ "./node_modules/lodash-es/keys.js");
/* harmony import */ var lodash_es_result_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/result.js */ "./node_modules/lodash-es/result.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
//     Backbone.js 1.4.0
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.

// Router
// ------










// Routers map faux-URLs to actions, and fire events when routes are
// matched. Creating a new one sets its `routes` hash, if not set statically.
const Router = function () {
  let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  this.history = options.history || new _history_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
  this.preinitialize.apply(this, arguments);
  if (options.routes) this.routes = options.routes;
  this._bindRoutes();
  this.initialize.apply(this, arguments);
};
Router.extend = _helpers_js__WEBPACK_IMPORTED_MODULE_2__.inherits;

// Cached regular expressions for matching named param parts and splatted
// parts of route strings.
const optionalParam = /\((.*?)\)/g;
const namedParam = /(\(\?)?:\w+/g;
const splatParam = /\*\w+/g;
const escapeRegExp = /[\-{}\[\]+?.,\\\^$|#\s]/g;

// Set up all inheritable **Router** properties and methods.
Object.assign(Router.prototype, _events_js__WEBPACK_IMPORTED_MODULE_1__.Events, {
  // preinitialize is an empty function by default. You can override it with a function
  // or object.  preinitialize will run before any instantiation logic is run in the Router.
  preinitialize: function () {},
  // Initialize is an empty function by default. Override it with your own
  // initialization logic.
  initialize: function () {},
  // Manually bind a single named route to a callback. For example:
  //
  //     this.route('search/:query/p:num', 'search', function(query, num) {
  //       ...
  //     });
  //
  route: function (route, name, callback) {
    if (!(0,lodash_es_isRegExp_js__WEBPACK_IMPORTED_MODULE_3__["default"])(route)) route = this._routeToRegExp(route);
    if ((0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_4__["default"])(name)) {
      callback = name;
      name = '';
    }
    if (!callback) callback = this[name];
    this.history.route(route, fragment => {
      const args = this._extractParameters(route, fragment);
      if (this.execute(callback, args, name) !== false) {
        this.trigger.apply(this, ['route:' + name].concat(args));
        this.trigger('route', name, args);
        this.history.trigger('route', this, name, args);
      }
    });
    return this;
  },
  // Execute a route handler with the provided parameters.  This is an
  // excellent place to do pre-route setup or post-route cleanup.
  execute: function (callback, args, name) {
    if (callback) callback.apply(this, args);
  },
  // Simple proxy to `history` to save a fragment into the history.
  navigate: function (fragment, options) {
    this.history.navigate(fragment, options);
    return this;
  },
  // Bind all defined routes to `history`. We have to reverse the
  // order of the routes here to support behavior where the most general
  // routes can be defined at the bottom of the route map.
  _bindRoutes: function () {
    if (!this.routes) return;
    this.routes = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_5__["default"])(this, 'routes');
    let route;
    const routes = (0,lodash_es_keys_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.routes);
    while ((route = routes.pop()) != null) {
      this.route(route, this.routes[route]);
    }
  },
  // Convert a route string into a regular expression, suitable for matching
  // against the current location hash.
  _routeToRegExp: function (route) {
    route = route.replace(escapeRegExp, '\\$&').replace(optionalParam, '(?:$1)?').replace(namedParam, function (match, optional) {
      return optional ? match : '([^/?]+)';
    }).replace(splatParam, '([^?]*?)');
    return new RegExp('^' + route + '(?:\\?([\\s\\S]*))?$');
  },
  // Given a route, and a URL fragment that it matches, return the array of
  // extracted decoded parameters. Empty or unmatched parameters will be
  // treated as `null` to normalize cross-browser behavior.
  _extractParameters: function (route, fragment) {
    const params = route.exec(fragment).slice(1);
    return params.map(function (param, i) {
      // Don't decode the search params.
      if (i === params.length - 1) return param || null;
      return param ? decodeURIComponent(param) : null;
    });
  }
});

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/storage.js":
/*!********************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/storage.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var localforage_driver_memory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! localforage-driver-memory */ "./node_modules/localforage-driver-memory/_bundle/umd.js");
/* harmony import */ var localforage_driver_memory__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(localforage_driver_memory__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_es_cloneDeep_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash-es/cloneDeep.js */ "./node_modules/lodash-es/cloneDeep.js");
/* harmony import */ var lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/isString.js */ "./node_modules/lodash-es/isString.js");
/* harmony import */ var localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! localforage/src/localforage */ "./node_modules/localforage/src/localforage.js");
/* harmony import */ var mergebounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! mergebounce */ "./node_modules/mergebounce/mergebounce.js");
/* harmony import */ var _drivers_sessionStorage_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./drivers/sessionStorage.js */ "./node_modules/@converse/skeletor/src/drivers/sessionStorage.js");
/* harmony import */ var localforage_setitems__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! localforage-setitems */ "./node_modules/localforage-setitems/dist/localforage-setitems.js");
/* harmony import */ var localforage_setitems__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(localforage_setitems__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var localforage_getitems__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! localforage-getitems */ "./node_modules/localforage-getitems/dist/localforage-getitems.js");
/* harmony import */ var localforage_getitems__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(localforage_getitems__WEBPACK_IMPORTED_MODULE_5__);
/**
 * IndexedDB, localStorage and sessionStorage adapter
 */








const IN_MEMORY = localforage_driver_memory__WEBPACK_IMPORTED_MODULE_0__._driver;
localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].defineDriver(localforage_driver_memory__WEBPACK_IMPORTED_MODULE_0__);
(0,localforage_setitems__WEBPACK_IMPORTED_MODULE_4__.extendPrototype)(localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"]);
(0,localforage_getitems__WEBPACK_IMPORTED_MODULE_5__.extendPrototype)(localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"]);
function S4() {
  // Generate four random hex digits.
  return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
}
function guid() {
  // Generate a pseudo-GUID by concatenating random hexadecimal.
  return S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
}
class Storage {
  constructor(id, type) {
    let batchedWrites = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (type === 'local' && !window.localStorage) {
      throw new Error("Skeletor.storage: Environment does not support localStorage.");
    } else if (type === 'session' && !window.sessionStorage) {
      throw new Error("Skeletor.storage: Environment does not support sessionStorage.");
    }
    if ((0,lodash_es_isString_js__WEBPACK_IMPORTED_MODULE_6__["default"])(type)) {
      this.storeInitialized = this.initStore(type, batchedWrites);
    } else {
      this.store = type;
      if (batchedWrites) {
        this.store.debouncedSetItems = (0,mergebounce__WEBPACK_IMPORTED_MODULE_2__["default"])(items => this.store.setItems(items), 50, {
          'promise': true
        });
      }
      this.storeInitialized = Promise.resolve();
    }
    this.name = id;
  }
  async initStore(type, batchedWrites) {
    if (type === 'session') {
      localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].setDriver(_drivers_sessionStorage_js__WEBPACK_IMPORTED_MODULE_3__["default"]._driver);
    } else if (type === 'local') {
      await localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].config({
        'driver': localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].LOCALSTORAGE
      });
    } else if (type === 'in_memory') {
      localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].config({
        'driver': IN_MEMORY
      });
    } else if (type !== 'indexed') {
      throw new Error("Skeletor.storage: No storage type was specified");
    }
    this.store = localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"];
    if (batchedWrites) {
      this.store.debouncedSetItems = (0,mergebounce__WEBPACK_IMPORTED_MODULE_2__["default"])(items => this.store.setItems(items), 50, {
        'promise': true
      });
    }
  }
  flush() {
    var _this$store$debounced;
    return (_this$store$debounced = this.store.debouncedSetItems) === null || _this$store$debounced === void 0 ? void 0 : _this$store$debounced.flush();
  }
  async clear() {
    await this.store.removeItem(this.name).catch(e => console.error(e));
    const re = new RegExp(`^${this.name}-`);
    const keys = await this.store.keys();
    const removed_keys = keys.filter(k => re.test(k));
    await Promise.all(removed_keys.map(k => this.store.removeItem(k).catch(e => console.error(e))));
  }
  sync() {
    const that = this;
    async function localSync(method, model, options) {
      let resp, errorMessage, promise, new_attributes;

      // We get the collection (and if necessary the model attribute.
      // Waiting for storeInitialized will cause another iteration of
      // the event loop, after which the collection reference will
      // be removed from the model.
      const collection = model.collection;
      if (['patch', 'update'].includes(method)) {
        new_attributes = (0,lodash_es_cloneDeep_js__WEBPACK_IMPORTED_MODULE_7__["default"])(model.attributes);
      }
      await that.storeInitialized;
      try {
        const original_attributes = model.attributes;
        switch (method) {
          case "read":
            if (model.id !== undefined) {
              resp = await that.find(model);
            } else {
              resp = await that.findAll();
            }
            break;
          case "create":
            resp = await that.create(model, options);
            break;
          case 'patch':
          case "update":
            if (options.wait) {
              // When `wait` is set to true, Skeletor waits until
              // confirmation of storage before setting the values on
              // the model.
              // However, the new attributes needs to be sent, so it
              // sets them manually on the model and then removes
              // them after calling `sync`.
              // Because our `sync` method is asynchronous and we
              // wait for `storeInitialized`, the attributes are
              // already restored once we get here, so we need to do
              // the attributes dance again.
              model.attributes = new_attributes;
            }
            promise = that.update(model, options);
            if (options.wait) {
              model.attributes = original_attributes;
            }
            resp = await promise;
            break;
          case "delete":
            resp = await that.destroy(model, collection);
            break;
        }
      } catch (error) {
        if (error.code === 22 && that.getStorageSize() === 0) {
          errorMessage = "Private browsing is unsupported";
        } else {
          errorMessage = error.message;
        }
      }
      if (resp) {
        if (options && options.success) {
          // When storing, we don't pass back the response (which is
          // the set attributes returned from localforage because
          // Skeletor sets them again on the model and due to the async
          // nature of localforage it can cause stale attributes to be
          // set on a model after it's been updated in the meantime.
          const data = method === "read" ? resp : null;
          options.success(data, options);
        }
      } else {
        errorMessage = errorMessage ? errorMessage : "Record Not Found";
        if (options && options.error) {
          options.error(errorMessage);
        }
      }
    }
    localSync.__name__ = 'localSync';
    return localSync;
  }
  removeCollectionReference(model, collection) {
    if (!collection) {
      return;
    }
    const ids = collection.filter(m => m.id !== model.id).map(m => this.getItemName(m.id));
    return this.store.setItem(this.name, ids);
  }
  addCollectionReference(model, collection) {
    if (!collection) {
      return;
    }
    const ids = collection.map(m => this.getItemName(m.id));
    const new_id = this.getItemName(model.id);
    if (!ids.includes(new_id)) {
      ids.push(new_id);
    }
    return this.store.setItem(this.name, ids);
  }
  getCollectionReferenceData(model) {
    if (!model.collection) {
      return {};
    }
    const ids = model.collection.map(m => this.getItemName(m.id));
    const new_id = this.getItemName(model.id);
    if (!ids.includes(new_id)) {
      ids.push(new_id);
    }
    const result = {};
    result[this.name] = ids;
    return result;
  }
  async save(model) {
    if (this.store.setItems) {
      const items = {};
      items[this.getItemName(model.id)] = model.toJSON();
      Object.assign(items, this.getCollectionReferenceData(model));
      return this.store.debouncedSetItems ? this.store.debouncedSetItems(items) : this.store.setItems(items);
    } else {
      const key = this.getItemName(model.id);
      const data = await this.store.setItem(key, model.toJSON());
      await this.addCollectionReference(model, model.collection);
      return data;
    }
  }
  create(model, options) {
    /* Add a model, giving it a (hopefully)-unique GUID, if it doesn't already
     * have an id of it's own.
     */
    if (!model.id) {
      model.id = guid();
      model.set(model.idAttribute, model.id, options);
    }
    return this.save(model);
  }
  update(model) {
    return this.save(model);
  }
  find(model) {
    return this.store.getItem(this.getItemName(model.id));
  }
  async findAll() {
    /* Return the array of all models currently in storage.
     */
    const keys = await this.store.getItem(this.name);
    if (keys !== null && keys !== void 0 && keys.length) {
      const items = await this.store.getItems(keys);
      return Object.values(items);
    }
    return [];
  }
  async destroy(model, collection) {
    await this.flush();
    await this.store.removeItem(this.getItemName(model.id));
    await this.removeCollectionReference(model, collection);
    return model;
  }
  getStorageSize() {
    return this.store.length;
  }
  getItemName(id) {
    return this.name + "-" + id;
  }
}
Storage.sessionStorageInitialized = localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"].defineDriver(_drivers_sessionStorage_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
Storage.localForage = localforage_src_localforage__WEBPACK_IMPORTED_MODULE_1__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Storage);

/***/ }),

/***/ "./node_modules/@converse/skeletor/src/view.js":
/*!*****************************************************!*\
  !*** ./node_modules/@converse/skeletor/src/view.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "View": () => (/* binding */ View)
/* harmony export */ });
/* harmony import */ var lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/extend.js */ "./node_modules/lodash-es/assignIn.js");
/* harmony import */ var lodash_es_isElement_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash-es/isElement.js */ "./node_modules/lodash-es/isElement.js");
/* harmony import */ var lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es/isFunction.js */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/pick.js */ "./node_modules/lodash-es/pick.js");
/* harmony import */ var lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es/result.js */ "./node_modules/lodash-es/result.js");
/* harmony import */ var lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/uniqueId.js */ "./node_modules/lodash-es/uniqueId.js");
/* harmony import */ var _events_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers.js */ "./node_modules/@converse/skeletor/src/helpers.js");
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html */ "./node_modules/lit-html/development/lit-html.js");
//     Backbone.js 1.4.0
//     (c) 2010-2019 Jeremy Ashkenas and DocumentCloud
//     Backbone may be freely distributed under the MIT license.

// View
// ----

// Views are almost more convention than they are actual code. A View
// is simply a JavaScript object that represents a logical chunk of UI in the
// DOM. This might be a single item, an entire list, a sidebar or panel, or
// even the surrounding frame which wraps your whole app. Defining a chunk of
// UI as a **View** allows you to define your DOM events declaratively, without
// having to worry about render order ... and makes it easy for the view to
// react to specific changes in the state of your models.










const paddedLt = /^\s*</;

// Caches a local reference to `Element.prototype` for faster access.
const ElementProto = typeof Element !== 'undefined' && Element.prototype || {};
const indexOf = function (array, item) {
  for (let i = 0, len = array.length; i < len; i++) if (array[i] === item) return i;
  return -1;
};

// Creating a View creates its initial element outside of the DOM,
// if an existing element is not provided...
const View = function (options) {
  this.cid = (0,lodash_es_uniqueId_js__WEBPACK_IMPORTED_MODULE_3__["default"])('view');
  this._domEvents = [];
  this.preinitialize.apply(this, arguments);
  (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_4__["default"])(this, (0,lodash_es_pick_js__WEBPACK_IMPORTED_MODULE_5__["default"])(options, viewOptions));
  this._ensureElement();
  this.initialize.apply(this, arguments);
};
View.extend = _helpers_js__WEBPACK_IMPORTED_MODULE_1__.inherits;

// Cached regex to split keys for `delegate`.
const delegateEventSplitter = /^(\S+)\s*(.*)$/;

// List of view options to be set as properties.
const viewOptions = ['model', 'collection', 'el', 'id', 'attributes', 'className', 'tagName', 'events'];

// Set up all inheritable **View** properties and methods.
Object.assign(View.prototype, _events_js__WEBPACK_IMPORTED_MODULE_0__.Events, {
  // The default `tagName` of a View's element is `"div"`.
  tagName: 'div',
  $: function (selector) {
    return this.el.querySelectorAll(selector);
  },
  // preinitialize is an empty function by default. You can override it with a function
  // or object.  preinitialize will run before any instantiation logic is run in the View
  preinitialize: function () {},
  // Initialize is an empty function by default. Override it with your own
  // initialization logic.
  initialize: function () {},
  // **render** is the core function that your view should override, in order
  // to populate its element (`this.el`), with the appropriate HTML. The
  // convention is for **render** to always return `this`.
  render: function () {
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.beforeRender) && this.beforeRender();
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.toHTML) && (0,lit_html__WEBPACK_IMPORTED_MODULE_2__.render)(this.toHTML(), this.el);
    (0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(this.afterRender) && this.afterRender();
    return this;
  },
  // Remove this view by taking the element out of the DOM, and removing any
  // applicable Backbone.Events listeners.
  remove: function () {
    this._removeElement();
    this.stopListening();
    return this;
  },
  // Remove this view's element from the document and all event listeners
  // attached to it. Exposed for subclasses using an alternative DOM
  // manipulation API.
  _removeElement: function () {
    this.undelegateEvents();
    if (this.el.parentNode) this.el.parentNode.removeChild(this.el);
  },
  // Change the view's element (`this.el` property) and re-delegate the
  // view's events on the new element.
  setElement: function (element) {
    this.undelegateEvents();
    this._setElement(element);
    this.delegateEvents();
    return this;
  },
  // Apply the `element` to the view. `element` can be a CSS selector,
  // a string of HTML, or an Element node. If passed a NodeList or CSS
  // selector, uses just the first match.
  _setElement: function (element) {
    if (typeof element == 'string') {
      if (paddedLt.test(element)) {
        const el = document.createElement('div');
        el.innerHTML = element;
        this.el = el.firstChild;
      } else {
        this.el = document.querySelector(element);
      }
    } else if (element && !(0,lodash_es_isElement_js__WEBPACK_IMPORTED_MODULE_7__["default"])(element) && element.length) {
      this.el = element[0];
    } else {
      this.el = element;
    }
  },
  // Set callbacks, where `this.events` is a hash of
  //
  // *{"event selector": "callback"}*
  //
  //     {
  //       'mousedown .title':  'edit',
  //       'click .button':     'save',
  //       'click .open':       function(e) { ... }
  //     }
  //
  // pairs. Callbacks will be bound to the view, with `this` set properly.
  // Uses event delegation for efficiency.
  // Omitting the selector binds the event to `this.el`.
  delegateEvents: function (events) {
    events || (events = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'events'));
    if (!events) return this;
    this.undelegateEvents();
    for (const key in events) {
      let method = events[key];
      if (!(0,lodash_es_isFunction_js__WEBPACK_IMPORTED_MODULE_6__["default"])(method)) method = this[method];
      if (!method) continue;
      const match = key.match(delegateEventSplitter);
      this.delegate(match[1], match[2], method.bind(this));
    }
    return this;
  },
  // Make a event delegation handler for the given `eventName` and `selector`
  // and attach it to `this.el`.
  // If selector is empty, the listener will be bound to `this.el`. If not, a
  // new handler that will recursively traverse up the event target's DOM
  // hierarchy looking for a node that matches the selector. If one is found,
  // the event's `delegateTarget` property is set to it and the return the
  // result of calling bound `listener` with the parameters given to the
  // handler.
  delegate: function (eventName, selector, listener) {
    const root = this.el;
    if (!root) {
      return this;
    }
    if (typeof selector === 'function') {
      listener = selector;
      selector = null;
    }
    // Given that `focus` and `blur` events do not bubble, do not delegate these events
    if (['focus', 'blur'].indexOf(eventName) !== -1) {
      const els = this.el.querySelectorAll(selector);
      for (let i = 0, len = els.length; i < len; i++) {
        const item = els[i];
        item.addEventListener(eventName, listener, false);
        this._domEvents.push({
          el: item,
          eventName: eventName,
          handler: listener
        });
      }
      return listener;
    }
    const handler = selector ? function (e) {
      let node = e.target || e.srcElement;
      for (; node && node != root; node = node.parentNode) {
        if (node.matches(selector)) {
          e.delegateTarget = node;
          listener(e);
        }
      }
    } : listener;
    this.el.addEventListener(eventName, handler, false);
    this._domEvents.push({
      el: this.el,
      eventName: eventName,
      handler: handler,
      listener: listener,
      selector: selector
    });
    return this;
  },
  // Clears all callbacks previously bound to the view by `delegateEvents`.
  // You usually don't need to use this, but may wish to if you have multiple
  // Backbone views attached to the same DOM element.
  undelegateEvents: function () {
    if (this.el) {
      for (let i = 0, len = this._domEvents.length; i < len; i++) {
        const item = this._domEvents[i];
        item.el.removeEventListener(item.eventName, item.handler, false);
      }
      this._domEvents.length = 0;
    }
    return this;
  },
  // A finer-grained `undelegateEvents` for removing a single delegated event.
  // `selector` and `listener` are both optional.
  undelegate: function (eventName, selector, listener) {
    if (typeof selector === 'function') {
      listener = selector;
      selector = null;
    }
    if (this.el) {
      const handlers = this._domEvents.slice();
      let i = handlers.length;
      while (i--) {
        const item = handlers[i];
        const match = item.eventName === eventName && (listener ? item.listener === listener : true) && (selector ? item.selector === selector : true);
        if (!match) {
          continue;
        }
        item.el.removeEventListener(item.eventName, item.handler, false);
        this._domEvents.splice(i, 1);
      }
    }
    return this;
  },
  // Produces a DOM element to be assigned to your view. Exposed for
  // subclasses using an alternative DOM manipulation API.
  _createElement: function (tagName) {
    return document.createElement(tagName);
  },
  // Ensure that the View has a DOM element to render into.
  // If `this.el` is a string, pass it through `$()`, take the first
  // matching element, and re-assign it to `el`. Otherwise, create
  // an element from the `id`, `className` and `tagName` properties.
  _ensureElement: function () {
    if (!this.el) {
      const attrs = (0,lodash_es_extend_js__WEBPACK_IMPORTED_MODULE_4__["default"])({}, (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'attributes'));
      if (this.id) attrs.id = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'id');
      if (this.className) attrs['class'] = (0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'className');
      this.setElement(this._createElement((0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'tagName')));
      this._setAttributes(attrs);
    } else {
      this.setElement((0,lodash_es_result_js__WEBPACK_IMPORTED_MODULE_8__["default"])(this, 'el'));
    }
  },
  // Set attributes from a hash on this view's element.  Exposed for
  // subclasses using an alternative DOM manipulation API.
  _setAttributes: function (attrs) {
    for (const attr in attrs) {
      attr in this.el ? this.el[attr] = attrs[attr] : this.el.setAttribute(attr, attrs[attr]);
    }
  }
});

/***/ }),

/***/ "./node_modules/localforage/src/drivers/indexeddb.js":
/*!***********************************************************!*\
  !*** ./node_modules/localforage/src/drivers/indexeddb.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_isIndexedDBValid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/isIndexedDBValid */ "./node_modules/localforage/src/utils/isIndexedDBValid.js");
/* harmony import */ var _utils_createBlob__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/createBlob */ "./node_modules/localforage/src/utils/createBlob.js");
/* harmony import */ var _utils_idb__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/idb */ "./node_modules/localforage/src/utils/idb.js");
/* harmony import */ var _utils_promise__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/promise */ "./node_modules/localforage/src/utils/promise.js");
/* harmony import */ var _utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/executeCallback */ "./node_modules/localforage/src/utils/executeCallback.js");
/* harmony import */ var _utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/executeTwoCallbacks */ "./node_modules/localforage/src/utils/executeTwoCallbacks.js");
/* harmony import */ var _utils_normalizeKey__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/normalizeKey */ "./node_modules/localforage/src/utils/normalizeKey.js");
/* harmony import */ var _utils_getCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getCallback */ "./node_modules/localforage/src/utils/getCallback.js");









// Some code originally from async_storage.js in
// [Gaia](https://github.com/mozilla-b2g/gaia).

const DETECT_BLOB_SUPPORT_STORE = 'local-forage-detect-blob-support';
let supportsBlobs;
const dbContexts = {};
const toString = Object.prototype.toString;

// Transaction Modes
const READ_ONLY = 'readonly';
const READ_WRITE = 'readwrite';

// Transform a binary string to an array buffer, because otherwise
// weird stuff happens when you try to work with the binary string directly.
// It is known.
// From http://stackoverflow.com/questions/14967647/ (continues on next line)
// encode-decode-image-with-base64-breaks-image (2013-04-21)
function _binStringToArrayBuffer(bin) {
  var length = bin.length;
  var buf = new ArrayBuffer(length);
  var arr = new Uint8Array(buf);
  for (var i = 0; i < length; i++) {
    arr[i] = bin.charCodeAt(i);
  }
  return buf;
}

//
// Blobs are not supported in all versions of IndexedDB, notably
// Chrome <37 and Android <5. In those versions, storing a blob will throw.
//
// Various other blob bugs exist in Chrome v37-42 (inclusive).
// Detecting them is expensive and confusing to users, and Chrome 37-42
// is at very low usage worldwide, so we do a hacky userAgent check instead.
//
// content-type bug: https://code.google.com/p/chromium/issues/detail?id=408120
// 404 bug: https://code.google.com/p/chromium/issues/detail?id=447916
// FileReader bug: https://code.google.com/p/chromium/issues/detail?id=447836
//
// Code borrowed from PouchDB. See:
// https://github.com/pouchdb/pouchdb/blob/master/packages/node_modules/pouchdb-adapter-idb/src/blobSupport.js
//
function _checkBlobSupportWithoutCaching(idb) {
  return new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve) {
    var txn = idb.transaction(DETECT_BLOB_SUPPORT_STORE, READ_WRITE);
    var blob = (0,_utils_createBlob__WEBPACK_IMPORTED_MODULE_1__["default"])(['']);
    txn.objectStore(DETECT_BLOB_SUPPORT_STORE).put(blob, 'key');
    txn.onabort = function (e) {
      // If the transaction aborts now its due to not being able to
      // write to the database, likely due to the disk being full
      e.preventDefault();
      e.stopPropagation();
      resolve(false);
    };
    txn.oncomplete = function () {
      var matchedChrome = navigator.userAgent.match(/Chrome\/(\d+)/);
      var matchedEdge = navigator.userAgent.match(/Edge\//);
      // MS Edge pretends to be Chrome 42:
      // https://msdn.microsoft.com/en-us/library/hh869301%28v=vs.85%29.aspx
      resolve(matchedEdge || !matchedChrome || parseInt(matchedChrome[1], 10) >= 43);
    };
  }).catch(function () {
    return false; // error, so assume unsupported
  });
}

function _checkBlobSupport(idb) {
  if (typeof supportsBlobs === 'boolean') {
    return _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve(supportsBlobs);
  }
  return _checkBlobSupportWithoutCaching(idb).then(function (value) {
    supportsBlobs = value;
    return supportsBlobs;
  });
}
function _deferReadiness(dbInfo) {
  var dbContext = dbContexts[dbInfo.name];

  // Create a deferred object representing the current database operation.
  var deferredOperation = {};
  deferredOperation.promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    deferredOperation.resolve = resolve;
    deferredOperation.reject = reject;
  });

  // Enqueue the deferred operation.
  dbContext.deferredOperations.push(deferredOperation);

  // Chain its promise to the database readiness.
  if (!dbContext.dbReady) {
    dbContext.dbReady = deferredOperation.promise;
  } else {
    dbContext.dbReady = dbContext.dbReady.then(function () {
      return deferredOperation.promise;
    });
  }
}
function _advanceReadiness(dbInfo) {
  var dbContext = dbContexts[dbInfo.name];

  // Dequeue a deferred operation.
  var deferredOperation = dbContext.deferredOperations.pop();

  // Resolve its promise (which is part of the database readiness
  // chain of promises).
  if (deferredOperation) {
    deferredOperation.resolve();
    return deferredOperation.promise;
  }
}
function _rejectReadiness(dbInfo, err) {
  var dbContext = dbContexts[dbInfo.name];

  // Dequeue a deferred operation.
  var deferredOperation = dbContext.deferredOperations.pop();

  // Reject its promise (which is part of the database readiness
  // chain of promises).
  if (deferredOperation) {
    deferredOperation.reject(err);
    return deferredOperation.promise;
  }
}
function _getConnection(dbInfo, upgradeNeeded) {
  return new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    dbContexts[dbInfo.name] = dbContexts[dbInfo.name] || createDbContext();
    if (dbInfo.db) {
      if (upgradeNeeded) {
        _deferReadiness(dbInfo);
        dbInfo.db.close();
      } else {
        return resolve(dbInfo.db);
      }
    }
    var dbArgs = [dbInfo.name];
    if (upgradeNeeded) {
      dbArgs.push(dbInfo.version);
    }
    var openreq = _utils_idb__WEBPACK_IMPORTED_MODULE_2__["default"].open.apply(_utils_idb__WEBPACK_IMPORTED_MODULE_2__["default"], dbArgs);
    if (upgradeNeeded) {
      openreq.onupgradeneeded = function (e) {
        var db = openreq.result;
        try {
          db.createObjectStore(dbInfo.storeName);
          if (e.oldVersion <= 1) {
            // Added when support for blob shims was added
            db.createObjectStore(DETECT_BLOB_SUPPORT_STORE);
          }
        } catch (ex) {
          if (ex.name === 'ConstraintError') {
            console.warn('The database "' + dbInfo.name + '"' + ' has been upgraded from version ' + e.oldVersion + ' to version ' + e.newVersion + ', but the storage "' + dbInfo.storeName + '" already exists.');
          } else {
            throw ex;
          }
        }
      };
    }
    openreq.onerror = function (e) {
      e.preventDefault();
      reject(openreq.error);
    };
    openreq.onsuccess = function () {
      var db = openreq.result;
      db.onversionchange = function (e) {
        // Triggered when the database is modified (e.g. adding an objectStore) or
        // deleted (even when initiated by other sessions in different tabs).
        // Closing the connection here prevents those operations from being blocked.
        // If the database is accessed again later by this instance, the connection
        // will be reopened or the database recreated as needed.
        e.target.close();
      };
      resolve(db);
      _advanceReadiness(dbInfo);
    };
  });
}
function _getOriginalConnection(dbInfo) {
  return _getConnection(dbInfo, false);
}
function _getUpgradedConnection(dbInfo) {
  return _getConnection(dbInfo, true);
}
function _isUpgradeNeeded(dbInfo, defaultVersion) {
  if (!dbInfo.db) {
    return true;
  }
  var isNewStore = !dbInfo.db.objectStoreNames.contains(dbInfo.storeName);
  var isDowngrade = dbInfo.version < dbInfo.db.version;
  var isUpgrade = dbInfo.version > dbInfo.db.version;
  if (isDowngrade) {
    // If the version is not the default one
    // then warn for impossible downgrade.
    if (dbInfo.version !== defaultVersion) {
      console.warn('The database "' + dbInfo.name + '"' + " can't be downgraded from version " + dbInfo.db.version + ' to version ' + dbInfo.version + '.');
    }
    // Align the versions to prevent errors.
    dbInfo.version = dbInfo.db.version;
  }
  if (isUpgrade || isNewStore) {
    // If the store is new then increment the version (if needed).
    // This will trigger an "upgradeneeded" event which is required
    // for creating a store.
    if (isNewStore) {
      var incVersion = dbInfo.db.version + 1;
      if (incVersion > dbInfo.version) {
        dbInfo.version = incVersion;
      }
    }
    return true;
  }
  return false;
}

// encode a blob for indexeddb engines that don't support blobs
function _encodeBlob(blob) {
  return new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    var reader = new FileReader();
    reader.onerror = reject;
    reader.onloadend = function (e) {
      var base64 = btoa(e.target.result || '');
      resolve({
        __local_forage_encoded_blob: true,
        data: base64,
        type: blob.type
      });
    };
    reader.readAsBinaryString(blob);
  });
}

// decode an encoded blob
function _decodeBlob(encodedBlob) {
  var arrayBuff = _binStringToArrayBuffer(atob(encodedBlob.data));
  return (0,_utils_createBlob__WEBPACK_IMPORTED_MODULE_1__["default"])([arrayBuff], {
    type: encodedBlob.type
  });
}

// is this one of our fancy encoded blobs?
function _isEncodedBlob(value) {
  return value && value.__local_forage_encoded_blob;
}

// Specialize the default `ready()` function by making it dependent
// on the current database operations. Thus, the driver will be actually
// ready when it's been initialized (default) *and* there are no pending
// operations on the database (initiated by some other instances).
function _fullyReady(callback) {
  var self = this;
  var promise = self._initReady().then(function () {
    var dbContext = dbContexts[self._dbInfo.name];
    if (dbContext && dbContext.dbReady) {
      return dbContext.dbReady;
    }
  });
  (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_5__["default"])(promise, callback, callback);
  return promise;
}

// Try to establish a new db connection to replace the
// current one which is broken (i.e. experiencing
// InvalidStateError while creating a transaction).
function _tryReconnect(dbInfo) {
  _deferReadiness(dbInfo);
  var dbContext = dbContexts[dbInfo.name];
  var forages = dbContext.forages;
  for (var i = 0; i < forages.length; i++) {
    const forage = forages[i];
    if (forage._dbInfo.db) {
      forage._dbInfo.db.close();
      forage._dbInfo.db = null;
    }
  }
  dbInfo.db = null;
  return _getOriginalConnection(dbInfo).then(db => {
    dbInfo.db = db;
    if (_isUpgradeNeeded(dbInfo)) {
      // Reopen the database for upgrading.
      return _getUpgradedConnection(dbInfo);
    }
    return db;
  }).then(db => {
    // store the latest db reference
    // in case the db was upgraded
    dbInfo.db = dbContext.db = db;
    for (var i = 0; i < forages.length; i++) {
      forages[i]._dbInfo.db = db;
    }
  }).catch(err => {
    _rejectReadiness(dbInfo, err);
    throw err;
  });
}

// FF doesn't like Promises (micro-tasks) and IDDB store operations,
// so we have to do it with callbacks
function createTransaction(dbInfo, mode, callback, retries) {
  if (retries === undefined) {
    retries = 1;
  }
  try {
    var tx = dbInfo.db.transaction(dbInfo.storeName, mode);
    callback(null, tx);
  } catch (err) {
    if (retries > 0 && (!dbInfo.db || err.name === 'InvalidStateError' || err.name === 'NotFoundError')) {
      return _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve().then(() => {
        if (!dbInfo.db || err.name === 'NotFoundError' && !dbInfo.db.objectStoreNames.contains(dbInfo.storeName) && dbInfo.version <= dbInfo.db.version) {
          // increase the db version, to create the new ObjectStore
          if (dbInfo.db) {
            dbInfo.version = dbInfo.db.version + 1;
          }
          // Reopen the database for upgrading.
          return _getUpgradedConnection(dbInfo);
        }
      }).then(() => {
        return _tryReconnect(dbInfo).then(function () {
          createTransaction(dbInfo, mode, callback, retries - 1);
        });
      }).catch(callback);
    }
    callback(err);
  }
}
function createDbContext() {
  return {
    // Running localForages sharing a database.
    forages: [],
    // Shared database.
    db: null,
    // Database readiness (promise).
    dbReady: null,
    // Deferred operations on the database.
    deferredOperations: []
  };
}

// Open the IndexedDB database (automatically creates one if one didn't
// previously exist), using any options set in the config.
function _initStorage(options) {
  var self = this;
  var dbInfo = {
    db: null
  };
  if (options) {
    for (var i in options) {
      dbInfo[i] = options[i];
    }
  }

  // Get the current context of the database;
  var dbContext = dbContexts[dbInfo.name];

  // ...or create a new context.
  if (!dbContext) {
    dbContext = createDbContext();
    // Register the new context in the global container.
    dbContexts[dbInfo.name] = dbContext;
  }

  // Register itself as a running localForage in the current context.
  dbContext.forages.push(self);

  // Replace the default `ready()` function with the specialized one.
  if (!self._initReady) {
    self._initReady = self.ready;
    self.ready = _fullyReady;
  }

  // Create an array of initialization states of the related localForages.
  var initPromises = [];
  function ignoreErrors() {
    // Don't handle errors here,
    // just makes sure related localForages aren't pending.
    return _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve();
  }
  for (var j = 0; j < dbContext.forages.length; j++) {
    var forage = dbContext.forages[j];
    if (forage !== self) {
      // Don't wait for itself...
      initPromises.push(forage._initReady().catch(ignoreErrors));
    }
  }

  // Take a snapshot of the related localForages.
  var forages = dbContext.forages.slice(0);

  // Initialize the connection process only when
  // all the related localForages aren't pending.
  return _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].all(initPromises).then(function () {
    dbInfo.db = dbContext.db;
    // Get the connection or open a new one without upgrade.
    return _getOriginalConnection(dbInfo);
  }).then(function (db) {
    dbInfo.db = db;
    if (_isUpgradeNeeded(dbInfo, self._defaultConfig.version)) {
      // Reopen the database for upgrading.
      return _getUpgradedConnection(dbInfo);
    }
    return db;
  }).then(function (db) {
    dbInfo.db = dbContext.db = db;
    self._dbInfo = dbInfo;
    // Share the final connection amongst related localForages.
    for (var k = 0; k < forages.length; k++) {
      var forage = forages[k];
      if (forage !== self) {
        // Self is already up-to-date.
        forage._dbInfo.db = dbInfo.db;
        forage._dbInfo.version = dbInfo.version;
      }
    }
  });
}
function getItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_6__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var req = store.get(key);
          req.onsuccess = function () {
            var value = req.result;
            if (value === undefined) {
              value = null;
            }
            if (_isEncodedBlob(value)) {
              value = _decodeBlob(value);
            }
            resolve(value);
          };
          req.onerror = function () {
            reject(req.error);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}

// Iterate over all items stored in database.
function iterate(iterator, callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var req = store.openCursor();
          var iterationNumber = 1;
          req.onsuccess = function () {
            var cursor = req.result;
            if (cursor) {
              var value = cursor.value;
              if (_isEncodedBlob(value)) {
                value = _decodeBlob(value);
              }
              var result = iterator(value, cursor.key, iterationNumber++);

              // when the iterator callback returns any
              // (non-`undefined`) value, then we stop
              // the iteration immediately
              if (result !== void 0) {
                resolve(result);
              } else {
                cursor.continue();
              }
            } else {
              resolve();
            }
          };
          req.onerror = function () {
            reject(req.error);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function setItem(key, value, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_6__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    var dbInfo;
    self.ready().then(function () {
      dbInfo = self._dbInfo;
      if (toString.call(value) === '[object Blob]') {
        return _checkBlobSupport(dbInfo.db).then(function (blobSupport) {
          if (blobSupport) {
            return value;
          }
          return _encodeBlob(value);
        });
      }
      return value;
    }).then(function (value) {
      createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);

          // The reason we don't _save_ null is because IE 10 does
          // not support saving the `null` type in IndexedDB. How
          // ironic, given the bug below!
          // See: https://github.com/mozilla/localForage/issues/161
          if (value === null) {
            value = undefined;
          }
          var req = store.put(value, key);
          transaction.oncomplete = function () {
            // Cast to undefined so the value passed to
            // callback/promise is the same as what one would get out
            // of `getItem()` later. This leads to some weirdness
            // (setItem('foo', undefined) will return `null`), but
            // it's not my fault localStorage is our baseline and that
            // it's weird.
            if (value === undefined) {
              value = null;
            }
            resolve(value);
          };
          transaction.onabort = transaction.onerror = function () {
            var err = req.error ? req.error : req.transaction.error;
            reject(err);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function removeItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_6__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          // We use a Grunt task to make this safe for IE and some
          // versions of Android (including those used by Cordova).
          // Normally IE won't like `.delete()` and will insist on
          // using `['delete']()`, but we have a build step that
          // fixes this for us now.
          var req = store.delete(key);
          transaction.oncomplete = function () {
            resolve();
          };
          transaction.onerror = function () {
            reject(req.error);
          };

          // The request will be also be aborted if we've exceeded our storage
          // space.
          transaction.onabort = function () {
            var err = req.error ? req.error : req.transaction.error;
            reject(err);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function clear(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var req = store.clear();
          transaction.oncomplete = function () {
            resolve();
          };
          transaction.onabort = transaction.onerror = function () {
            var err = req.error ? req.error : req.transaction.error;
            reject(err);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function length(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var req = store.count();
          req.onsuccess = function () {
            resolve(req.result);
          };
          req.onerror = function () {
            reject(req.error);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function key(n, callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    if (n < 0) {
      resolve(null);
      return;
    }
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var advanced = false;
          var req = store.openKeyCursor();
          req.onsuccess = function () {
            var cursor = req.result;
            if (!cursor) {
              // this means there weren't enough keys
              resolve(null);
              return;
            }
            if (n === 0) {
              // We have the first key, return it if that's what they
              // wanted.
              resolve(cursor.key);
            } else {
              if (!advanced) {
                // Otherwise, ask the cursor to skip ahead n
                // records.
                advanced = true;
                cursor.advance(n);
              } else {
                // When we get here, we've got the nth key.
                resolve(cursor.key);
              }
            }
          };
          req.onerror = function () {
            reject(req.error);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function keys(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"](function (resolve, reject) {
    self.ready().then(function () {
      createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
        if (err) {
          return reject(err);
        }
        try {
          var store = transaction.objectStore(self._dbInfo.storeName);
          var req = store.openKeyCursor();
          var keys = [];
          req.onsuccess = function () {
            var cursor = req.result;
            if (!cursor) {
              resolve(keys);
              return;
            }
            keys.push(cursor.key);
            cursor.continue();
          };
          req.onerror = function () {
            reject(req.error);
          };
        } catch (e) {
          reject(e);
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
function dropInstance(options, callback) {
  callback = _utils_getCallback__WEBPACK_IMPORTED_MODULE_7__["default"].apply(this, arguments);
  var currentConfig = this.config();
  options = typeof options !== 'function' && options || {};
  if (!options.name) {
    options.name = options.name || currentConfig.name;
    options.storeName = options.storeName || currentConfig.storeName;
  }
  var self = this;
  var promise;
  if (!options.name) {
    promise = _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].reject('Invalid arguments');
  } else {
    const isCurrentDb = options.name === currentConfig.name && self._dbInfo.db;
    const dbPromise = isCurrentDb ? _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve(self._dbInfo.db) : _getOriginalConnection(options).then(db => {
      const dbContext = dbContexts[options.name];
      const forages = dbContext.forages;
      dbContext.db = db;
      for (var i = 0; i < forages.length; i++) {
        forages[i]._dbInfo.db = db;
      }
      return db;
    });
    if (!options.storeName) {
      promise = dbPromise.then(db => {
        _deferReadiness(options);
        const dbContext = dbContexts[options.name];
        const forages = dbContext.forages;
        db.close();
        for (var i = 0; i < forages.length; i++) {
          const forage = forages[i];
          forage._dbInfo.db = null;
        }
        const dropDBPromise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"]((resolve, reject) => {
          var req = _utils_idb__WEBPACK_IMPORTED_MODULE_2__["default"].deleteDatabase(options.name);
          req.onerror = () => {
            const db = req.result;
            if (db) {
              db.close();
            }
            reject(req.error);
          };
          req.onblocked = () => {
            // Closing all open connections in onversionchange handler should prevent this situation, but if
            // we do get here, it just means the request remains pending - eventually it will succeed or error
            console.warn('dropInstance blocked for database "' + options.name + '" until all open connections are closed');
          };
          req.onsuccess = () => {
            const db = req.result;
            if (db) {
              db.close();
            }
            resolve(db);
          };
        });
        return dropDBPromise.then(db => {
          dbContext.db = db;
          for (var i = 0; i < forages.length; i++) {
            const forage = forages[i];
            _advanceReadiness(forage._dbInfo);
          }
        }).catch(err => {
          (_rejectReadiness(options, err) || _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve()).catch(() => {});
          throw err;
        });
      });
    } else {
      promise = dbPromise.then(db => {
        if (!db.objectStoreNames.contains(options.storeName)) {
          return;
        }
        const newVersion = db.version + 1;
        _deferReadiness(options);
        const dbContext = dbContexts[options.name];
        const forages = dbContext.forages;
        db.close();
        for (let i = 0; i < forages.length; i++) {
          const forage = forages[i];
          forage._dbInfo.db = null;
          forage._dbInfo.version = newVersion;
        }
        const dropObjectPromise = new _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"]((resolve, reject) => {
          const req = _utils_idb__WEBPACK_IMPORTED_MODULE_2__["default"].open(options.name, newVersion);
          req.onerror = err => {
            const db = req.result;
            db.close();
            reject(err);
          };
          req.onupgradeneeded = () => {
            var db = req.result;
            db.deleteObjectStore(options.storeName);
          };
          req.onsuccess = () => {
            const db = req.result;
            db.close();
            resolve(db);
          };
        });
        return dropObjectPromise.then(db => {
          dbContext.db = db;
          for (let j = 0; j < forages.length; j++) {
            const forage = forages[j];
            forage._dbInfo.db = db;
            _advanceReadiness(forage._dbInfo);
          }
        }).catch(err => {
          (_rejectReadiness(options, err) || _utils_promise__WEBPACK_IMPORTED_MODULE_3__["default"].resolve()).catch(() => {});
          throw err;
        });
      });
    }
  }
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_4__["default"])(promise, callback);
  return promise;
}
var asyncStorage = {
  _driver: 'asyncStorage',
  _initStorage: _initStorage,
  _support: (0,_utils_isIndexedDBValid__WEBPACK_IMPORTED_MODULE_0__["default"])(),
  iterate: iterate,
  getItem: getItem,
  setItem: setItem,
  removeItem: removeItem,
  clear: clear,
  length: length,
  key: key,
  keys: keys,
  dropInstance: dropInstance
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (asyncStorage);

/***/ }),

/***/ "./node_modules/localforage/src/drivers/localstorage.js":
/*!**************************************************************!*\
  !*** ./node_modules/localforage/src/drivers/localstorage.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_isLocalStorageValid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/isLocalStorageValid */ "./node_modules/localforage/src/utils/isLocalStorageValid.js");
/* harmony import */ var _utils_serializer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/serializer */ "./node_modules/localforage/src/utils/serializer.js");
/* harmony import */ var _utils_promise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/promise */ "./node_modules/localforage/src/utils/promise.js");
/* harmony import */ var _utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/executeCallback */ "./node_modules/localforage/src/utils/executeCallback.js");
/* harmony import */ var _utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/normalizeKey */ "./node_modules/localforage/src/utils/normalizeKey.js");
/* harmony import */ var _utils_getCallback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getCallback */ "./node_modules/localforage/src/utils/getCallback.js");
// If IndexedDB isn't available, we'll fall back to localStorage.
// Note that this will have considerable performance and storage
// side-effects (all data will be serialized on save and only data that
// can be converted to a string via `JSON.stringify()` will be saved).







function _getKeyPrefix(options, defaultConfig) {
  var keyPrefix = options.name + '/';
  if (options.storeName !== defaultConfig.storeName) {
    keyPrefix += options.storeName + '/';
  }
  return keyPrefix;
}

// Check if localStorage throws when saving an item
function checkIfLocalStorageThrows() {
  var localStorageTestKey = '_localforage_support_test';
  try {
    localStorage.setItem(localStorageTestKey, true);
    localStorage.removeItem(localStorageTestKey);
    return false;
  } catch (e) {
    return true;
  }
}

// Check if localStorage is usable and allows to save an item
// This method checks if localStorage is usable in Safari Private Browsing
// mode, or in any other case where the available quota for localStorage
// is 0 and there wasn't any saved items yet.
function _isLocalStorageUsable() {
  return !checkIfLocalStorageThrows() || localStorage.length > 0;
}

// Config the localStorage backend, using options set in the config.
function _initStorage(options) {
  var self = this;
  var dbInfo = {};
  if (options) {
    for (var i in options) {
      dbInfo[i] = options[i];
    }
  }
  dbInfo.keyPrefix = _getKeyPrefix(options, self._defaultConfig);
  if (!_isLocalStorageUsable()) {
    return _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"].reject();
  }
  self._dbInfo = dbInfo;
  dbInfo.serializer = _utils_serializer__WEBPACK_IMPORTED_MODULE_1__["default"];
  return _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"].resolve();
}

// Remove all keys from the datastore, effectively destroying all data in
// the app's key/value store!
function clear(callback) {
  var self = this;
  var promise = self.ready().then(function () {
    var keyPrefix = self._dbInfo.keyPrefix;
    for (var i = localStorage.length - 1; i >= 0; i--) {
      var key = localStorage.key(i);
      if (key.indexOf(keyPrefix) === 0) {
        localStorage.removeItem(key);
      }
    }
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Retrieve an item from the store. Unlike the original async_storage
// library in Gaia, we don't modify return values at all. If a key's value
// is `undefined`, we pass that value to the callback function.
function getItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = self.ready().then(function () {
    var dbInfo = self._dbInfo;
    var result = localStorage.getItem(dbInfo.keyPrefix + key);

    // If a result was found, parse it from the serialized
    // string into a JS object. If result isn't truthy, the key
    // is likely undefined and we'll pass it straight to the
    // callback.
    if (result) {
      result = dbInfo.serializer.deserialize(result);
    }
    return result;
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Iterate over all items in the store.
function iterate(iterator, callback) {
  var self = this;
  var promise = self.ready().then(function () {
    var dbInfo = self._dbInfo;
    var keyPrefix = dbInfo.keyPrefix;
    var keyPrefixLength = keyPrefix.length;
    var length = localStorage.length;

    // We use a dedicated iterator instead of the `i` variable below
    // so other keys we fetch in localStorage aren't counted in
    // the `iterationNumber` argument passed to the `iterate()`
    // callback.
    //
    // See: github.com/mozilla/localForage/pull/435#discussion_r38061530
    var iterationNumber = 1;
    for (var i = 0; i < length; i++) {
      var key = localStorage.key(i);
      if (key.indexOf(keyPrefix) !== 0) {
        continue;
      }
      var value = localStorage.getItem(key);

      // If a result was found, parse it from the serialized
      // string into a JS object. If result isn't truthy, the
      // key is likely undefined and we'll pass it straight
      // to the iterator.
      if (value) {
        value = dbInfo.serializer.deserialize(value);
      }
      value = iterator(value, key.substring(keyPrefixLength), iterationNumber++);
      if (value !== void 0) {
        return value;
      }
    }
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Same as localStorage's key() method, except takes a callback.
function key(n, callback) {
  var self = this;
  var promise = self.ready().then(function () {
    var dbInfo = self._dbInfo;
    var result;
    try {
      result = localStorage.key(n);
    } catch (error) {
      result = null;
    }

    // Remove the prefix from the key, if a key is found.
    if (result) {
      result = result.substring(dbInfo.keyPrefix.length);
    }
    return result;
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function keys(callback) {
  var self = this;
  var promise = self.ready().then(function () {
    var dbInfo = self._dbInfo;
    var length = localStorage.length;
    var keys = [];
    for (var i = 0; i < length; i++) {
      var itemKey = localStorage.key(i);
      if (itemKey.indexOf(dbInfo.keyPrefix) === 0) {
        keys.push(itemKey.substring(dbInfo.keyPrefix.length));
      }
    }
    return keys;
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Supply the number of keys in the datastore to the callback function.
function length(callback) {
  var self = this;
  var promise = self.keys().then(function (keys) {
    return keys.length;
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Remove an item from the store, nice and simple.
function removeItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = self.ready().then(function () {
    var dbInfo = self._dbInfo;
    localStorage.removeItem(dbInfo.keyPrefix + key);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Set a key's value and run an optional callback once the value is set.
// Unlike Gaia's implementation, the callback function is passed the value,
// in case you want to operate on that value only after you're sure it
// saved, or something like that.
function setItem(key, value, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = self.ready().then(function () {
    // Convert undefined values to null.
    // https://github.com/mozilla/localForage/pull/42
    if (value === undefined) {
      value = null;
    }

    // Save the original value to pass to the callback.
    var originalValue = value;
    return new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
      var dbInfo = self._dbInfo;
      dbInfo.serializer.serialize(value, function (value, error) {
        if (error) {
          reject(error);
        } else {
          try {
            localStorage.setItem(dbInfo.keyPrefix + key, value);
            resolve(originalValue);
          } catch (e) {
            // localStorage capacity exceeded.
            // TODO: Make this a specific error/event.
            if (e.name === 'QuotaExceededError' || e.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
              reject(e);
            }
            reject(e);
          }
        }
      });
    });
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function dropInstance(options, callback) {
  callback = _utils_getCallback__WEBPACK_IMPORTED_MODULE_5__["default"].apply(this, arguments);
  options = typeof options !== 'function' && options || {};
  if (!options.name) {
    var currentConfig = this.config();
    options.name = options.name || currentConfig.name;
    options.storeName = options.storeName || currentConfig.storeName;
  }
  var self = this;
  var promise;
  if (!options.name) {
    promise = _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"].reject('Invalid arguments');
  } else {
    promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve) {
      if (!options.storeName) {
        resolve(`${options.name}/`);
      } else {
        resolve(_getKeyPrefix(options, self._defaultConfig));
      }
    }).then(function (keyPrefix) {
      for (var i = localStorage.length - 1; i >= 0; i--) {
        var key = localStorage.key(i);
        if (key.indexOf(keyPrefix) === 0) {
          localStorage.removeItem(key);
        }
      }
    });
  }
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
var localStorageWrapper = {
  _driver: 'localStorageWrapper',
  _initStorage: _initStorage,
  _support: (0,_utils_isLocalStorageValid__WEBPACK_IMPORTED_MODULE_0__["default"])(),
  iterate: iterate,
  getItem: getItem,
  setItem: setItem,
  removeItem: removeItem,
  clear: clear,
  length: length,
  key: key,
  keys: keys,
  dropInstance: dropInstance
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (localStorageWrapper);

/***/ }),

/***/ "./node_modules/localforage/src/drivers/websql.js":
/*!********************************************************!*\
  !*** ./node_modules/localforage/src/drivers/websql.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_isWebSQLValid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/isWebSQLValid */ "./node_modules/localforage/src/utils/isWebSQLValid.js");
/* harmony import */ var _utils_serializer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/serializer */ "./node_modules/localforage/src/utils/serializer.js");
/* harmony import */ var _utils_promise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/promise */ "./node_modules/localforage/src/utils/promise.js");
/* harmony import */ var _utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/executeCallback */ "./node_modules/localforage/src/utils/executeCallback.js");
/* harmony import */ var _utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/normalizeKey */ "./node_modules/localforage/src/utils/normalizeKey.js");
/* harmony import */ var _utils_getCallback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getCallback */ "./node_modules/localforage/src/utils/getCallback.js");







/*
 * Includes code from:
 *
 * base64-arraybuffer
 * https://github.com/niklasvh/base64-arraybuffer
 *
 * Copyright (c) 2012 Niklas von Hertzen
 * Licensed under the MIT license.
 */

function createDbTable(t, dbInfo, callback, errorCallback) {
  t.executeSql(`CREATE TABLE IF NOT EXISTS ${dbInfo.storeName} ` + '(id INTEGER PRIMARY KEY, key unique, value)', [], callback, errorCallback);
}

// Open the WebSQL database (automatically creates one if one didn't
// previously exist), using any options set in the config.
function _initStorage(options) {
  var self = this;
  var dbInfo = {
    db: null
  };
  if (options) {
    for (var i in options) {
      dbInfo[i] = typeof options[i] !== 'string' ? options[i].toString() : options[i];
    }
  }
  var dbInfoPromise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    // Open the database; the openDatabase API will automatically
    // create it for us if it doesn't exist.
    try {
      dbInfo.db = openDatabase(dbInfo.name, String(dbInfo.version), dbInfo.description, dbInfo.size);
    } catch (e) {
      return reject(e);
    }

    // Create our key/value table if it doesn't exist.
    dbInfo.db.transaction(function (t) {
      createDbTable(t, dbInfo, function () {
        self._dbInfo = dbInfo;
        resolve();
      }, function (t, error) {
        reject(error);
      });
    }, reject);
  });
  dbInfo.serializer = _utils_serializer__WEBPACK_IMPORTED_MODULE_1__["default"];
  return dbInfoPromise;
}
function tryExecuteSql(t, dbInfo, sqlStatement, args, callback, errorCallback) {
  t.executeSql(sqlStatement, args, callback, function (t, error) {
    if (error.code === error.SYNTAX_ERR) {
      t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name = ?", [dbInfo.storeName], function (t, results) {
        if (!results.rows.length) {
          // if the table is missing (was deleted)
          // re-create it table and retry
          createDbTable(t, dbInfo, function () {
            t.executeSql(sqlStatement, args, callback, errorCallback);
          }, errorCallback);
        } else {
          errorCallback(t, error);
        }
      }, errorCallback);
    } else {
      errorCallback(t, error);
    }
  }, errorCallback);
}
function getItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `SELECT * FROM ${dbInfo.storeName} WHERE key = ? LIMIT 1`, [key], function (t, results) {
          var result = results.rows.length ? results.rows.item(0).value : null;

          // Check to see if this is serialized content we need to
          // unpack.
          if (result) {
            result = dbInfo.serializer.deserialize(result);
          }
          resolve(result);
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function iterate(iterator, callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `SELECT * FROM ${dbInfo.storeName}`, [], function (t, results) {
          var rows = results.rows;
          var length = rows.length;
          for (var i = 0; i < length; i++) {
            var item = rows.item(i);
            var result = item.value;

            // Check to see if this is serialized content
            // we need to unpack.
            if (result) {
              result = dbInfo.serializer.deserialize(result);
            }
            result = iterator(result, item.key, i + 1);

            // void(0) prevents problems with redefinition
            // of `undefined`.
            if (result !== void 0) {
              resolve(result);
              return;
            }
          }
          resolve();
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function _setItem(key, value, callback, retriesLeft) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      // The localStorage API doesn't return undefined values in an
      // "expected" way, so undefined is always cast to null in all
      // drivers. See: https://github.com/mozilla/localForage/pull/42
      if (value === undefined) {
        value = null;
      }

      // Save the original value to pass to the callback.
      var originalValue = value;
      var dbInfo = self._dbInfo;
      dbInfo.serializer.serialize(value, function (value, error) {
        if (error) {
          reject(error);
        } else {
          dbInfo.db.transaction(function (t) {
            tryExecuteSql(t, dbInfo, `INSERT OR REPLACE INTO ${dbInfo.storeName} ` + '(key, value) VALUES (?, ?)', [key, value], function () {
              resolve(originalValue);
            }, function (t, error) {
              reject(error);
            });
          }, function (sqlError) {
            // The transaction failed; check
            // to see if it's a quota error.
            if (sqlError.code === sqlError.QUOTA_ERR) {
              // We reject the callback outright for now, but
              // it's worth trying to re-run the transaction.
              // Even if the user accepts the prompt to use
              // more storage on Safari, this error will
              // be called.
              //
              // Try to re-run the transaction.
              if (retriesLeft > 0) {
                resolve(_setItem.apply(self, [key, originalValue, callback, retriesLeft - 1]));
                return;
              }
              reject(sqlError);
            }
          });
        }
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function setItem(key, value, callback) {
  return _setItem.apply(this, [key, value, callback, 1]);
}
function removeItem(key, callback) {
  var self = this;
  key = (0,_utils_normalizeKey__WEBPACK_IMPORTED_MODULE_4__["default"])(key);
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `DELETE FROM ${dbInfo.storeName} WHERE key = ?`, [key], function () {
          resolve();
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Deletes every item in the table.
// TODO: Find out if this resets the AUTO_INCREMENT number.
function clear(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `DELETE FROM ${dbInfo.storeName}`, [], function () {
          resolve();
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Does a simple `COUNT(key)` to get the number of items stored in
// localForage.
function length(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        // Ahhh, SQL makes this one soooooo easy.
        tryExecuteSql(t, dbInfo, `SELECT COUNT(key) as c FROM ${dbInfo.storeName}`, [], function (t, results) {
          var result = results.rows.item(0).c;
          resolve(result);
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// Return the key located at key index X; essentially gets the key from a
// `WHERE id = ?`. This is the most efficient way I can think to implement
// this rarely-used (in my experience) part of the API, but it can seem
// inconsistent, because we do `INSERT OR REPLACE INTO` on `setItem()`, so
// the ID of each key will change every time it's updated. Perhaps a stored
// procedure for the `setItem()` SQL would solve this problem?
// TODO: Don't change ID on `setItem()`.
function key(n, callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `SELECT key FROM ${dbInfo.storeName} WHERE id = ? LIMIT 1`, [n + 1], function (t, results) {
          var result = results.rows.length ? results.rows.item(0).key : null;
          resolve(result);
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
function keys(callback) {
  var self = this;
  var promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    self.ready().then(function () {
      var dbInfo = self._dbInfo;
      dbInfo.db.transaction(function (t) {
        tryExecuteSql(t, dbInfo, `SELECT key FROM ${dbInfo.storeName}`, [], function (t, results) {
          var keys = [];
          for (var i = 0; i < results.rows.length; i++) {
            keys.push(results.rows.item(i).key);
          }
          resolve(keys);
        }, function (t, error) {
          reject(error);
        });
      });
    }).catch(reject);
  });
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}

// https://www.w3.org/TR/webdatabase/#databases
// > There is no way to enumerate or delete the databases available for an origin from this API.
function getAllStoreNames(db) {
  return new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
    db.transaction(function (t) {
      t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name <> '__WebKitDatabaseInfoTable__'", [], function (t, results) {
        var storeNames = [];
        for (var i = 0; i < results.rows.length; i++) {
          storeNames.push(results.rows.item(i).name);
        }
        resolve({
          db,
          storeNames
        });
      }, function (t, error) {
        reject(error);
      });
    }, function (sqlError) {
      reject(sqlError);
    });
  });
}
function dropInstance(options, callback) {
  callback = _utils_getCallback__WEBPACK_IMPORTED_MODULE_5__["default"].apply(this, arguments);
  var currentConfig = this.config();
  options = typeof options !== 'function' && options || {};
  if (!options.name) {
    options.name = options.name || currentConfig.name;
    options.storeName = options.storeName || currentConfig.storeName;
  }
  var self = this;
  var promise;
  if (!options.name) {
    promise = _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"].reject('Invalid arguments');
  } else {
    promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve) {
      var db;
      if (options.name === currentConfig.name) {
        // use the db reference of the current instance
        db = self._dbInfo.db;
      } else {
        db = openDatabase(options.name, '', '', 0);
      }
      if (!options.storeName) {
        // drop all database tables
        resolve(getAllStoreNames(db));
      } else {
        resolve({
          db,
          storeNames: [options.storeName]
        });
      }
    }).then(function (operationInfo) {
      return new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
        operationInfo.db.transaction(function (t) {
          function dropTable(storeName) {
            return new _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"](function (resolve, reject) {
              t.executeSql(`DROP TABLE IF EXISTS ${storeName}`, [], function () {
                resolve();
              }, function (t, error) {
                reject(error);
              });
            });
          }
          var operations = [];
          for (var i = 0, len = operationInfo.storeNames.length; i < len; i++) {
            operations.push(dropTable(operationInfo.storeNames[i]));
          }
          _utils_promise__WEBPACK_IMPORTED_MODULE_2__["default"].all(operations).then(function () {
            resolve();
          }).catch(function (e) {
            reject(e);
          });
        }, function (sqlError) {
          reject(sqlError);
        });
      });
    });
  }
  (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_3__["default"])(promise, callback);
  return promise;
}
var webSQLStorage = {
  _driver: 'webSQLStorage',
  _initStorage: _initStorage,
  _support: (0,_utils_isWebSQLValid__WEBPACK_IMPORTED_MODULE_0__["default"])(),
  iterate: iterate,
  getItem: getItem,
  setItem: setItem,
  removeItem: removeItem,
  clear: clear,
  length: length,
  key: key,
  keys: keys,
  dropInstance: dropInstance
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (webSQLStorage);

/***/ }),

/***/ "./node_modules/localforage/src/localforage.js":
/*!*****************************************************!*\
  !*** ./node_modules/localforage/src/localforage.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _drivers_indexeddb__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./drivers/indexeddb */ "./node_modules/localforage/src/drivers/indexeddb.js");
/* harmony import */ var _drivers_websql__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./drivers/websql */ "./node_modules/localforage/src/drivers/websql.js");
/* harmony import */ var _drivers_localstorage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./drivers/localstorage */ "./node_modules/localforage/src/drivers/localstorage.js");
/* harmony import */ var _utils_serializer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/serializer */ "./node_modules/localforage/src/utils/serializer.js");
/* harmony import */ var _utils_promise__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/promise */ "./node_modules/localforage/src/utils/promise.js");
/* harmony import */ var _utils_executeCallback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/executeCallback */ "./node_modules/localforage/src/utils/executeCallback.js");
/* harmony import */ var _utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/executeTwoCallbacks */ "./node_modules/localforage/src/utils/executeTwoCallbacks.js");
/* harmony import */ var _utils_includes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/includes */ "./node_modules/localforage/src/utils/includes.js");
/* harmony import */ var _utils_isArray__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/isArray */ "./node_modules/localforage/src/utils/isArray.js");










// Drivers are stored here when `defineDriver()` is called.
// They are shared across all instances of localForage.
const DefinedDrivers = {};
const DriverSupport = {};
const DefaultDrivers = {
  INDEXEDDB: _drivers_indexeddb__WEBPACK_IMPORTED_MODULE_0__["default"],
  WEBSQL: _drivers_websql__WEBPACK_IMPORTED_MODULE_1__["default"],
  LOCALSTORAGE: _drivers_localstorage__WEBPACK_IMPORTED_MODULE_2__["default"]
};
const DefaultDriverOrder = [DefaultDrivers.INDEXEDDB._driver, DefaultDrivers.WEBSQL._driver, DefaultDrivers.LOCALSTORAGE._driver];
const OptionalDriverMethods = ['dropInstance'];
const LibraryMethods = ['clear', 'getItem', 'iterate', 'key', 'keys', 'length', 'removeItem', 'setItem'].concat(OptionalDriverMethods);
const DefaultConfig = {
  description: '',
  driver: DefaultDriverOrder.slice(),
  name: 'localforage',
  // Default DB size is _JUST UNDER_ 5MB, as it's the highest size
  // we can use without a prompt.
  size: 4980736,
  storeName: 'keyvaluepairs',
  version: 1.0
};
function callWhenReady(localForageInstance, libraryMethod) {
  localForageInstance[libraryMethod] = function () {
    const _args = arguments;
    return localForageInstance.ready().then(function () {
      return localForageInstance[libraryMethod].apply(localForageInstance, _args);
    });
  };
}
function extend() {
  for (let i = 1; i < arguments.length; i++) {
    const arg = arguments[i];
    if (arg) {
      for (let key in arg) {
        if (arg.hasOwnProperty(key)) {
          if ((0,_utils_isArray__WEBPACK_IMPORTED_MODULE_8__["default"])(arg[key])) {
            arguments[0][key] = arg[key].slice();
          } else {
            arguments[0][key] = arg[key];
          }
        }
      }
    }
  }
  return arguments[0];
}
class LocalForage {
  constructor(options) {
    for (let driverTypeKey in DefaultDrivers) {
      if (DefaultDrivers.hasOwnProperty(driverTypeKey)) {
        const driver = DefaultDrivers[driverTypeKey];
        const driverName = driver._driver;
        this[driverTypeKey] = driverName;
        if (!DefinedDrivers[driverName]) {
          // we don't need to wait for the promise,
          // since the default drivers can be defined
          // in a blocking manner
          this.defineDriver(driver);
        }
      }
    }
    this._defaultConfig = extend({}, DefaultConfig);
    this._config = extend({}, this._defaultConfig, options);
    this._driverSet = null;
    this._initDriver = null;
    this._ready = false;
    this._dbInfo = null;
    this._wrapLibraryMethodsWithReady();
    this.setDriver(this._config.driver).catch(() => {});
  }

  // Set any config values for localForage; can be called anytime before
  // the first API call (e.g. `getItem`, `setItem`).
  // We loop through options so we don't overwrite existing config
  // values.
  config(options) {
    // If the options argument is an object, we use it to set values.
    // Otherwise, we return either a specified config value or all
    // config values.
    if (typeof options === 'object') {
      // If localforage is ready and fully initialized, we can't set
      // any new configuration values. Instead, we return an error.
      if (this._ready) {
        return new Error("Can't call config() after localforage " + 'has been used.');
      }
      for (let i in options) {
        if (i === 'storeName') {
          options[i] = options[i].replace(/\W/g, '_');
        }
        if (i === 'version' && typeof options[i] !== 'number') {
          return new Error('Database version must be a number.');
        }
        this._config[i] = options[i];
      }

      // after all config options are set and
      // the driver option is used, try setting it
      if ('driver' in options && options.driver) {
        return this.setDriver(this._config.driver);
      }
      return true;
    } else if (typeof options === 'string') {
      return this._config[options];
    } else {
      return this._config;
    }
  }

  // Used to define a custom driver, shared across all instances of
  // localForage.
  defineDriver(driverObject, callback, errorCallback) {
    const promise = new _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"](function (resolve, reject) {
      try {
        const driverName = driverObject._driver;
        const complianceError = new Error('Custom driver not compliant; see ' + 'https://mozilla.github.io/localForage/#definedriver');

        // A driver name should be defined and not overlap with the
        // library-defined, default drivers.
        if (!driverObject._driver) {
          reject(complianceError);
          return;
        }
        const driverMethods = LibraryMethods.concat('_initStorage');
        for (let i = 0, len = driverMethods.length; i < len; i++) {
          const driverMethodName = driverMethods[i];

          // when the property is there,
          // it should be a method even when optional
          const isRequired = !(0,_utils_includes__WEBPACK_IMPORTED_MODULE_7__["default"])(OptionalDriverMethods, driverMethodName);
          if ((isRequired || driverObject[driverMethodName]) && typeof driverObject[driverMethodName] !== 'function') {
            reject(complianceError);
            return;
          }
        }
        const configureMissingMethods = function () {
          const methodNotImplementedFactory = function (methodName) {
            return function () {
              const error = new Error(`Method ${methodName} is not implemented by the current driver`);
              const promise = _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].reject(error);
              (0,_utils_executeCallback__WEBPACK_IMPORTED_MODULE_5__["default"])(promise, arguments[arguments.length - 1]);
              return promise;
            };
          };
          for (let i = 0, len = OptionalDriverMethods.length; i < len; i++) {
            const optionalDriverMethod = OptionalDriverMethods[i];
            if (!driverObject[optionalDriverMethod]) {
              driverObject[optionalDriverMethod] = methodNotImplementedFactory(optionalDriverMethod);
            }
          }
        };
        configureMissingMethods();
        const setDriverSupport = function (support) {
          if (DefinedDrivers[driverName]) {
            console.info(`Redefining LocalForage driver: ${driverName}`);
          }
          DefinedDrivers[driverName] = driverObject;
          DriverSupport[driverName] = support;
          // don't use a then, so that we can define
          // drivers that have simple _support methods
          // in a blocking manner
          resolve();
        };
        if ('_support' in driverObject) {
          if (driverObject._support && typeof driverObject._support === 'function') {
            driverObject._support().then(setDriverSupport, reject);
          } else {
            setDriverSupport(!!driverObject._support);
          }
        } else {
          setDriverSupport(true);
        }
      } catch (e) {
        reject(e);
      }
    });
    (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__["default"])(promise, callback, errorCallback);
    return promise;
  }
  driver() {
    return this._driver || null;
  }
  getDriver(driverName, callback, errorCallback) {
    const getDriverPromise = DefinedDrivers[driverName] ? _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].resolve(DefinedDrivers[driverName]) : _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].reject(new Error('Driver not found.'));
    (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__["default"])(getDriverPromise, callback, errorCallback);
    return getDriverPromise;
  }
  getSerializer(callback) {
    const serializerPromise = _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].resolve(_utils_serializer__WEBPACK_IMPORTED_MODULE_3__["default"]);
    (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__["default"])(serializerPromise, callback);
    return serializerPromise;
  }
  ready(callback) {
    const self = this;
    const promise = self._driverSet.then(() => {
      if (self._ready === null) {
        self._ready = self._initDriver();
      }
      return self._ready;
    });
    (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__["default"])(promise, callback, callback);
    return promise;
  }
  setDriver(drivers, callback, errorCallback) {
    const self = this;
    if (!(0,_utils_isArray__WEBPACK_IMPORTED_MODULE_8__["default"])(drivers)) {
      drivers = [drivers];
    }
    const supportedDrivers = this._getSupportedDrivers(drivers);
    function setDriverToConfig() {
      self._config.driver = self.driver();
    }
    function extendSelfWithDriver(driver) {
      self._extend(driver);
      setDriverToConfig();
      self._ready = self._initStorage(self._config);
      return self._ready;
    }
    function initDriver(supportedDrivers) {
      return function () {
        let currentDriverIndex = 0;
        function driverPromiseLoop() {
          while (currentDriverIndex < supportedDrivers.length) {
            let driverName = supportedDrivers[currentDriverIndex];
            currentDriverIndex++;
            self._dbInfo = null;
            self._ready = null;
            return self.getDriver(driverName).then(extendSelfWithDriver).catch(driverPromiseLoop);
          }
          setDriverToConfig();
          const error = new Error('No available storage method found.');
          self._driverSet = _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].reject(error);
          return self._driverSet;
        }
        return driverPromiseLoop();
      };
    }

    // There might be a driver initialization in progress
    // so wait for it to finish in order to avoid a possible
    // race condition to set _dbInfo
    const oldDriverSetDone = this._driverSet !== null ? this._driverSet.catch(() => _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].resolve()) : _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].resolve();
    this._driverSet = oldDriverSetDone.then(() => {
      const driverName = supportedDrivers[0];
      self._dbInfo = null;
      self._ready = null;
      return self.getDriver(driverName).then(driver => {
        self._driver = driver._driver;
        setDriverToConfig();
        self._wrapLibraryMethodsWithReady();
        self._initDriver = initDriver(supportedDrivers);
      });
    }).catch(() => {
      setDriverToConfig();
      const error = new Error('No available storage method found.');
      self._driverSet = _utils_promise__WEBPACK_IMPORTED_MODULE_4__["default"].reject(error);
      return self._driverSet;
    });
    (0,_utils_executeTwoCallbacks__WEBPACK_IMPORTED_MODULE_6__["default"])(this._driverSet, callback, errorCallback);
    return this._driverSet;
  }
  supports(driverName) {
    return !!DriverSupport[driverName];
  }
  _extend(libraryMethodsAndProperties) {
    extend(this, libraryMethodsAndProperties);
  }
  _getSupportedDrivers(drivers) {
    const supportedDrivers = [];
    for (let i = 0, len = drivers.length; i < len; i++) {
      const driverName = drivers[i];
      if (this.supports(driverName)) {
        supportedDrivers.push(driverName);
      }
    }
    return supportedDrivers;
  }
  _wrapLibraryMethodsWithReady() {
    // Add a stub for each driver API method that delays the call to the
    // corresponding driver method until localForage is ready. These stubs
    // will be replaced by the driver methods as soon as the driver is
    // loaded, so there is no performance impact.
    for (let i = 0, len = LibraryMethods.length; i < len; i++) {
      callWhenReady(this, LibraryMethods[i]);
    }
  }
  createInstance(options) {
    return new LocalForage(options);
  }
}

// The actual localForage object that we expose as a module or via a
// global. It's extended by pulling in one of our other libraries.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new LocalForage());

/***/ }),

/***/ "./node_modules/localforage/src/utils/createBlob.js":
/*!**********************************************************!*\
  !*** ./node_modules/localforage/src/utils/createBlob.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Abstracts constructing a Blob object, so it also works in older
// browsers that don't support the native Blob constructor. (i.e.
// old QtWebKit versions, at least).
// Abstracts constructing a Blob object, so it also works in older
// browsers that don't support the native Blob constructor. (i.e.
// old QtWebKit versions, at least).
function createBlob(parts, properties) {
  /* global BlobBuilder,MSBlobBuilder,MozBlobBuilder,WebKitBlobBuilder */
  parts = parts || [];
  properties = properties || {};
  try {
    return new Blob(parts, properties);
  } catch (e) {
    if (e.name !== 'TypeError') {
      throw e;
    }
    var Builder = typeof BlobBuilder !== 'undefined' ? BlobBuilder : typeof MSBlobBuilder !== 'undefined' ? MSBlobBuilder : typeof MozBlobBuilder !== 'undefined' ? MozBlobBuilder : WebKitBlobBuilder;
    var builder = new Builder();
    for (var i = 0; i < parts.length; i += 1) {
      builder.append(parts[i]);
    }
    return builder.getBlob(properties.type);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createBlob);

/***/ }),

/***/ "./node_modules/localforage/src/utils/executeCallback.js":
/*!***************************************************************!*\
  !*** ./node_modules/localforage/src/utils/executeCallback.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function executeCallback(promise, callback) {
  if (callback) {
    promise.then(function (result) {
      callback(null, result);
    }, function (error) {
      callback(error);
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (executeCallback);

/***/ }),

/***/ "./node_modules/localforage/src/utils/executeTwoCallbacks.js":
/*!*******************************************************************!*\
  !*** ./node_modules/localforage/src/utils/executeTwoCallbacks.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function executeTwoCallbacks(promise, callback, errorCallback) {
  if (typeof callback === 'function') {
    promise.then(callback);
  }
  if (typeof errorCallback === 'function') {
    promise.catch(errorCallback);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (executeTwoCallbacks);

/***/ }),

/***/ "./node_modules/localforage/src/utils/getCallback.js":
/*!***********************************************************!*\
  !*** ./node_modules/localforage/src/utils/getCallback.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getCallback)
/* harmony export */ });
function getCallback() {
  if (arguments.length && typeof arguments[arguments.length - 1] === 'function') {
    return arguments[arguments.length - 1];
  }
}

/***/ }),

/***/ "./node_modules/localforage/src/utils/idb.js":
/*!***************************************************!*\
  !*** ./node_modules/localforage/src/utils/idb.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function getIDB() {
  /* global indexedDB,webkitIndexedDB,mozIndexedDB,OIndexedDB,msIndexedDB */
  try {
    if (typeof indexedDB !== 'undefined') {
      return indexedDB;
    }
    if (typeof webkitIndexedDB !== 'undefined') {
      return webkitIndexedDB;
    }
    if (typeof mozIndexedDB !== 'undefined') {
      return mozIndexedDB;
    }
    if (typeof OIndexedDB !== 'undefined') {
      return OIndexedDB;
    }
    if (typeof msIndexedDB !== 'undefined') {
      return msIndexedDB;
    }
  } catch (e) {
    return;
  }
}
var idb = getIDB();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (idb);

/***/ }),

/***/ "./node_modules/localforage/src/utils/includes.js":
/*!********************************************************!*\
  !*** ./node_modules/localforage/src/utils/includes.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const sameValue = (x, y) => x === y || typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y);
const includes = (array, searchElement) => {
  const len = array.length;
  let i = 0;
  while (i < len) {
    if (sameValue(array[i], searchElement)) {
      return true;
    }
    i++;
  }
  return false;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (includes);

/***/ }),

/***/ "./node_modules/localforage/src/utils/isArray.js":
/*!*******************************************************!*\
  !*** ./node_modules/localforage/src/utils/isArray.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const isArray = Array.isArray || function (arg) {
  return Object.prototype.toString.call(arg) === '[object Array]';
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isArray);

/***/ }),

/***/ "./node_modules/localforage/src/utils/isIndexedDBValid.js":
/*!****************************************************************!*\
  !*** ./node_modules/localforage/src/utils/isIndexedDBValid.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _idb__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./idb */ "./node_modules/localforage/src/utils/idb.js");

function isIndexedDBValid() {
  try {
    // Initialize IndexedDB; fall back to vendor-prefixed versions
    // if needed.
    if (!_idb__WEBPACK_IMPORTED_MODULE_0__["default"] || !_idb__WEBPACK_IMPORTED_MODULE_0__["default"].open) {
      return false;
    }
    // We mimic PouchDB here;
    //
    // We test for openDatabase because IE Mobile identifies itself
    // as Safari. Oh the lulz...
    var isSafari = typeof openDatabase !== 'undefined' && /(Safari|iPhone|iPad|iPod)/.test(navigator.userAgent) && !/Chrome/.test(navigator.userAgent) && !/BlackBerry/.test(navigator.platform);
    var hasFetch = typeof fetch === 'function' && fetch.toString().indexOf('[native code') !== -1;

    // Safari <10.1 does not meet our requirements for IDB support
    // (see: https://github.com/pouchdb/pouchdb/issues/5572).
    // Safari 10.1 shipped with fetch, we can use that to detect it.
    // Note: this creates issues with `window.fetch` polyfills and
    // overrides; see:
    // https://github.com/localForage/localForage/issues/856
    return (!isSafari || hasFetch) && typeof indexedDB !== 'undefined' &&
    // some outdated implementations of IDB that appear on Samsung
    // and HTC Android devices <4.4 are missing IDBKeyRange
    // See: https://github.com/mozilla/localForage/issues/128
    // See: https://github.com/mozilla/localForage/issues/272
    typeof IDBKeyRange !== 'undefined';
  } catch (e) {
    return false;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isIndexedDBValid);

/***/ }),

/***/ "./node_modules/localforage/src/utils/isLocalStorageValid.js":
/*!*******************************************************************!*\
  !*** ./node_modules/localforage/src/utils/isLocalStorageValid.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function isLocalStorageValid() {
  try {
    return typeof localStorage !== 'undefined' && 'setItem' in localStorage &&
    // in IE8 typeof localStorage.setItem === 'object'
    !!localStorage.setItem;
  } catch (e) {
    return false;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isLocalStorageValid);

/***/ }),

/***/ "./node_modules/localforage/src/utils/isWebSQLValid.js":
/*!*************************************************************!*\
  !*** ./node_modules/localforage/src/utils/isWebSQLValid.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function isWebSQLValid() {
  return typeof openDatabase === 'function';
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isWebSQLValid);

/***/ }),

/***/ "./node_modules/localforage/src/utils/normalizeKey.js":
/*!************************************************************!*\
  !*** ./node_modules/localforage/src/utils/normalizeKey.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ normalizeKey)
/* harmony export */ });
function normalizeKey(key) {
  // Cast the key to a string, as that's all we can set as a key.
  if (typeof key !== 'string') {
    console.warn(`${key} used as a key, but it is not a string.`);
    key = String(key);
  }
  return key;
}

/***/ }),

/***/ "./node_modules/localforage/src/utils/promise.js":
/*!*******************************************************!*\
  !*** ./node_modules/localforage/src/utils/promise.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// This is CommonJS because lie is an external dependency, so Rollup
// can just ignore it.
if (typeof Promise === 'undefined') {
  // In the "nopromises" build this will just throw if you don't have
  // a global promise object, but it would throw anyway later.
  __webpack_require__(/*! lie/polyfill */ "./node_modules/lie/polyfill.js");
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Promise);

/***/ }),

/***/ "./node_modules/localforage/src/utils/serializer.js":
/*!**********************************************************!*\
  !*** ./node_modules/localforage/src/utils/serializer.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _createBlob__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createBlob */ "./node_modules/localforage/src/utils/createBlob.js");
/* eslint-disable no-bitwise */


// Sadly, the best way to save binary data in WebSQL/localStorage is serializing
// it to Base64, so this is how we store it to prevent very strange errors with less
// verbose ways of binary <-> string data storage.
var BASE_CHARS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
var BLOB_TYPE_PREFIX = '~~local_forage_type~';
var BLOB_TYPE_PREFIX_REGEX = /^~~local_forage_type~([^~]+)~/;
var SERIALIZED_MARKER = '__lfsc__:';
var SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER.length;

// OMG the serializations!
var TYPE_ARRAYBUFFER = 'arbf';
var TYPE_BLOB = 'blob';
var TYPE_INT8ARRAY = 'si08';
var TYPE_UINT8ARRAY = 'ui08';
var TYPE_UINT8CLAMPEDARRAY = 'uic8';
var TYPE_INT16ARRAY = 'si16';
var TYPE_INT32ARRAY = 'si32';
var TYPE_UINT16ARRAY = 'ur16';
var TYPE_UINT32ARRAY = 'ui32';
var TYPE_FLOAT32ARRAY = 'fl32';
var TYPE_FLOAT64ARRAY = 'fl64';
var TYPE_SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER_LENGTH + TYPE_ARRAYBUFFER.length;
var toString = Object.prototype.toString;
function stringToBuffer(serializedString) {
  // Fill the string into a ArrayBuffer.
  var bufferLength = serializedString.length * 0.75;
  var len = serializedString.length;
  var i;
  var p = 0;
  var encoded1, encoded2, encoded3, encoded4;
  if (serializedString[serializedString.length - 1] === '=') {
    bufferLength--;
    if (serializedString[serializedString.length - 2] === '=') {
      bufferLength--;
    }
  }
  var buffer = new ArrayBuffer(bufferLength);
  var bytes = new Uint8Array(buffer);
  for (i = 0; i < len; i += 4) {
    encoded1 = BASE_CHARS.indexOf(serializedString[i]);
    encoded2 = BASE_CHARS.indexOf(serializedString[i + 1]);
    encoded3 = BASE_CHARS.indexOf(serializedString[i + 2]);
    encoded4 = BASE_CHARS.indexOf(serializedString[i + 3]);

    /*jslint bitwise: true */
    bytes[p++] = encoded1 << 2 | encoded2 >> 4;
    bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
    bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
  }
  return buffer;
}

// Converts a buffer to a string to store, serialized, in the backend
// storage library.
function bufferToString(buffer) {
  // base64-arraybuffer
  var bytes = new Uint8Array(buffer);
  var base64String = '';
  var i;
  for (i = 0; i < bytes.length; i += 3) {
    /*jslint bitwise: true */
    base64String += BASE_CHARS[bytes[i] >> 2];
    base64String += BASE_CHARS[(bytes[i] & 3) << 4 | bytes[i + 1] >> 4];
    base64String += BASE_CHARS[(bytes[i + 1] & 15) << 2 | bytes[i + 2] >> 6];
    base64String += BASE_CHARS[bytes[i + 2] & 63];
  }
  if (bytes.length % 3 === 2) {
    base64String = base64String.substring(0, base64String.length - 1) + '=';
  } else if (bytes.length % 3 === 1) {
    base64String = base64String.substring(0, base64String.length - 2) + '==';
  }
  return base64String;
}

// Serialize a value, afterwards executing a callback (which usually
// instructs the `setItem()` callback/promise to be executed). This is how
// we store binary data with localStorage.
function serialize(value, callback) {
  var valueType = '';
  if (value) {
    valueType = toString.call(value);
  }

  // Cannot use `value instanceof ArrayBuffer` or such here, as these
  // checks fail when running the tests using casper.js...
  //
  // TODO: See why those tests fail and use a better solution.
  if (value && (valueType === '[object ArrayBuffer]' || value.buffer && toString.call(value.buffer) === '[object ArrayBuffer]')) {
    // Convert binary arrays to a string and prefix the string with
    // a special marker.
    var buffer;
    var marker = SERIALIZED_MARKER;
    if (value instanceof ArrayBuffer) {
      buffer = value;
      marker += TYPE_ARRAYBUFFER;
    } else {
      buffer = value.buffer;
      if (valueType === '[object Int8Array]') {
        marker += TYPE_INT8ARRAY;
      } else if (valueType === '[object Uint8Array]') {
        marker += TYPE_UINT8ARRAY;
      } else if (valueType === '[object Uint8ClampedArray]') {
        marker += TYPE_UINT8CLAMPEDARRAY;
      } else if (valueType === '[object Int16Array]') {
        marker += TYPE_INT16ARRAY;
      } else if (valueType === '[object Uint16Array]') {
        marker += TYPE_UINT16ARRAY;
      } else if (valueType === '[object Int32Array]') {
        marker += TYPE_INT32ARRAY;
      } else if (valueType === '[object Uint32Array]') {
        marker += TYPE_UINT32ARRAY;
      } else if (valueType === '[object Float32Array]') {
        marker += TYPE_FLOAT32ARRAY;
      } else if (valueType === '[object Float64Array]') {
        marker += TYPE_FLOAT64ARRAY;
      } else {
        callback(new Error('Failed to get type for BinaryArray'));
      }
    }
    callback(marker + bufferToString(buffer));
  } else if (valueType === '[object Blob]') {
    // Conver the blob to a binaryArray and then to a string.
    var fileReader = new FileReader();
    fileReader.onload = function () {
      // Backwards-compatible prefix for the blob type.
      var str = BLOB_TYPE_PREFIX + value.type + '~' + bufferToString(this.result);
      callback(SERIALIZED_MARKER + TYPE_BLOB + str);
    };
    fileReader.readAsArrayBuffer(value);
  } else {
    try {
      callback(JSON.stringify(value));
    } catch (e) {
      console.error("Couldn't convert value into a JSON string: ", value);
      callback(null, e);
    }
  }
}

// Deserialize data we've inserted into a value column/field. We place
// special markers into our strings to mark them as encoded; this isn't
// as nice as a meta field, but it's the only sane thing we can do whilst
// keeping localStorage support intact.
//
// Oftentimes this will just deserialize JSON content, but if we have a
// special marker (SERIALIZED_MARKER, defined above), we will extract
// some kind of arraybuffer/binary data/typed array out of the string.
function deserialize(value) {
  // If we haven't marked this string as being specially serialized (i.e.
  // something other than serialized JSON), we can just return it and be
  // done with it.
  if (value.substring(0, SERIALIZED_MARKER_LENGTH) !== SERIALIZED_MARKER) {
    return JSON.parse(value);
  }

  // The following code deals with deserializing some kind of Blob or
  // TypedArray. First we separate out the type of data we're dealing
  // with from the data itself.
  var serializedString = value.substring(TYPE_SERIALIZED_MARKER_LENGTH);
  var type = value.substring(SERIALIZED_MARKER_LENGTH, TYPE_SERIALIZED_MARKER_LENGTH);
  var blobType;
  // Backwards-compatible blob type serialization strategy.
  // DBs created with older versions of localForage will simply not have the blob type.
  if (type === TYPE_BLOB && BLOB_TYPE_PREFIX_REGEX.test(serializedString)) {
    var matcher = serializedString.match(BLOB_TYPE_PREFIX_REGEX);
    blobType = matcher[1];
    serializedString = serializedString.substring(matcher[0].length);
  }
  var buffer = stringToBuffer(serializedString);

  // Return the right type based on the code/type set during
  // serialization.
  switch (type) {
    case TYPE_ARRAYBUFFER:
      return buffer;
    case TYPE_BLOB:
      return (0,_createBlob__WEBPACK_IMPORTED_MODULE_0__["default"])([buffer], {
        type: blobType
      });
    case TYPE_INT8ARRAY:
      return new Int8Array(buffer);
    case TYPE_UINT8ARRAY:
      return new Uint8Array(buffer);
    case TYPE_UINT8CLAMPEDARRAY:
      return new Uint8ClampedArray(buffer);
    case TYPE_INT16ARRAY:
      return new Int16Array(buffer);
    case TYPE_UINT16ARRAY:
      return new Uint16Array(buffer);
    case TYPE_INT32ARRAY:
      return new Int32Array(buffer);
    case TYPE_UINT32ARRAY:
      return new Uint32Array(buffer);
    case TYPE_FLOAT32ARRAY:
      return new Float32Array(buffer);
    case TYPE_FLOAT64ARRAY:
      return new Float64Array(buffer);
    default:
      throw new Error('Unkown type: ' + type);
  }
}
var localforageSerializer = {
  serialize: serialize,
  deserialize: deserialize,
  stringToBuffer: stringToBuffer,
  bufferToString: bufferToString
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (localforageSerializer);

/***/ }),

/***/ "./node_modules/mergebounce/mergebounce.js":
/*!*************************************************!*\
  !*** ./node_modules/mergebounce/mergebounce.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es_isObject_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash-es/isObject.js */ "./node_modules/lodash-es/isObject.js");
/* harmony import */ var lodash_es_merge_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/merge.js */ "./node_modules/lodash-es/merge.js");
/* harmony import */ var lodash_es_mergeWith_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/mergeWith.js */ "./node_modules/lodash-es/mergeWith.js");
/* harmony import */ var lodash_es_now_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/now.js */ "./node_modules/lodash-es/now.js");
/* harmony import */ var lodash_es_toNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es/toNumber.js */ "./node_modules/lodash-es/toNumber.js");
/* harmony import */ var _converse_openpromise_openpromise_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/openpromise/openpromise.js */ "./node_modules/@converse/openpromise/openpromise.js");







/** Error message constants. */
const FUNC_ERROR_TEXT = 'Expected a function';

/* Built-in method references for those with the same name as other `lodash` methods. */
const nativeMax = Math.max;
const nativeMin = Math.min;

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 *
 * This function differs from lodash's debounce by merging all passed objects
 * before passing them to the final invoked function.
 *
 * Because of this, invoking can only happen on the trailing edge, since
 * passed-in data would be discarded if invoking happened on the leading edge.
 *
 * If `wait` is `0`, `func` invocation is deferred until to the next tick,
 * similar to `setTimeout` with a timeout of `0`.
 *
 * @static
 * @category Function
 * @param {Function} func The function to mergebounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.concatArrays=false]
 *  By default arrays will be treated as objects when being merged. When
 *  merging two arrays, the values in the 2nd arrray will replace the
 *  corresponding values (i.e. those with the same indexes) in the first array.
 *  When `concatArrays` is set to `true`, arrays will be concatenated instead.
 * @param {boolean} [options.dedupeArrays=false]
 *  This option is similar to `concatArrays`, except that the concatenated
 *  array will also be deduplicated. Thus any entries that are concatenated to the
 *  existing array, which are already contained in the existing array, will
 *  first be removed.
 * @param {boolean} [options.promise=false]
 *  By default, when calling a merge-debounced function that doesn't execute
 *  immediately, you'll receive the result from its previous execution, or
 *  `undefined` if it has never executed before. By setting the `promise`
 *  option to `true`, a promise will be returned instead of the previous
 *  execution result when the function is debounced. The promise will resolve
 *  with the result of the next execution, as soon as it happens.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * window.addEventListener('resize', mergebounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * element.addEventListner('click', mergebounce(sendMail, 300));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * const mergebounced = mergebounce(batchLog, 250, { 'maxWait': 1000 });
 * const source = new EventSource('/stream');
 * jQuery(source).on('message', mergebounced);
 *
 * // Cancel the trailing debounced invocation.
 * window.addEventListener('popstate', mergebounced.cancel);
 */
function mergebounce(func, wait) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  let lastArgs,
    lastThis,
    maxWait,
    result,
    timerId,
    lastCallTime,
    lastInvokeTime = 0,
    maxing = false;
  let promise = options.promise ? (0,_converse_openpromise_openpromise_js__WEBPACK_IMPORTED_MODULE_0__.getOpenPromise)() : null;
  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = (0,lodash_es_toNumber_js__WEBPACK_IMPORTED_MODULE_1__["default"])(wait) || 0;
  if ((0,lodash_es_isObject_js__WEBPACK_IMPORTED_MODULE_2__["default"])(options)) {
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax((0,lodash_es_toNumber_js__WEBPACK_IMPORTED_MODULE_1__["default"])(options.maxWait) || 0, wait) : maxWait;
  }
  function invokeFunc(time) {
    const args = lastArgs;
    const thisArg = lastThis;
    const existingPromise = promise;
    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    if (options.promise) {
      existingPromise.resolve(result);
      promise = (0,_converse_openpromise_openpromise_js__WEBPACK_IMPORTED_MODULE_0__.getOpenPromise)();
    }
    return options.promise ? existingPromise : result;
  }
  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    return options.promise ? promise : result;
  }
  function remainingWait(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime;
    const timeWaiting = wait - timeSinceLastCall;
    return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
  }
  function shouldInvoke(time) {
    const timeSinceLastCall = time - lastCallTime;
    const timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return lastCallTime === undefined || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
  }
  function timerExpired() {
    const time = (0,lodash_es_now_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }
  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return options.promise ? promise : result;
  }
  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }
  function flush() {
    return timerId === undefined ? result : trailingEdge((0,lodash_es_now_js__WEBPACK_IMPORTED_MODULE_3__["default"])());
  }
  function concatArrays(objValue, srcValue) {
    if (Array.isArray(objValue) && Array.isArray(srcValue)) {
      if (options !== null && options !== void 0 && options.dedupeArrays) {
        return objValue.concat(srcValue.filter(i => objValue.indexOf(i) === -1));
      } else {
        return objValue.concat(srcValue);
      }
    }
  }
  function mergeArguments(args) {
    var _lastArgs;
    if ((_lastArgs = lastArgs) !== null && _lastArgs !== void 0 && _lastArgs.length) {
      if (!args.length) {
        return lastArgs;
      }
      if (options !== null && options !== void 0 && options.concatArrays || options !== null && options !== void 0 && options.dedupeArrays) {
        return (0,lodash_es_mergeWith_js__WEBPACK_IMPORTED_MODULE_4__["default"])(lastArgs, args, concatArrays);
      } else {
        return (0,lodash_es_merge_js__WEBPACK_IMPORTED_MODULE_5__["default"])(lastArgs, args);
      }
    } else {
      return args || [];
    }
  }
  function debounced() {
    const time = (0,lodash_es_now_js__WEBPACK_IMPORTED_MODULE_3__["default"])();
    const isInvoking = shouldInvoke(time);
    lastArgs = mergeArguments(Array.from(arguments));
    lastThis = this;
    lastCallTime = time;
    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        clearTimeout(timerId);
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return options.promise ? promise : result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mergebounce);

/***/ }),

/***/ "./node_modules/pluggable.js/src/pluggable.js":
/*!****************************************************!*\
  !*** ./node_modules/pluggable.js/src/pluggable.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "enable": () => (/* binding */ enable)
/* harmony export */ });
/*
       ____  __                        __    __         _
      / __ \/ /_  __ ___   ___  ____ _/ /_  / /__      (_)____
     / /_/ / / / / / __ \/ __ \/ __/ / __ \/ / _ \    / / ___/
    / ____/ / /_/ / /_/ / /_/ / /_/ / /_/ / /  __/   / (__  )
   /_/   /_/\__,_/\__, /\__, /\__/_/_.___/_/\___(_)_/ /____/
                 /____//____/                    /___/
 */

// Pluggable.js lets you to make your Javascript code pluggable while still
// keeping sensitive objects and data private through closures.

// `wrappedOverride` creates a partially applied wrapper function
// that makes sure to set the proper super method when the
// overriding method is called. This is done to enable
// chaining of plugin methods, all the way up to the
// original method.
function wrappedOverride(key, value, super_method, default_super) {
  if (typeof super_method === "function") {
    if (typeof this.__super__ === "undefined") {
      /* We're not on the context of the plugged object.
       * This can happen when the overridden method is called via
       * an event handler or when it's a constructor.
       *
       * In this case, we simply tack on the  __super__ obj.
       */
      this.__super__ = default_super;
    }
    this.__super__[key] = super_method.bind(this);
  }
  for (var _len = arguments.length, args = new Array(_len > 4 ? _len - 4 : 0), _key = 4; _key < _len; _key++) {
    args[_key - 4] = arguments[_key];
  }
  return value.apply(this, args);
}

// The `PluginSocket` class contains the plugin architecture, and gets
// created whenever `pluggable.enable(obj);` is called on the object
// that you want to make pluggable.
// You can also see it as the thing into which the plugins are plugged.
// It takes two parameters, first, the object being made pluggable, and
// then the name by which the pluggable object may be referenced on the
// __super__ object (inside overrides).
class PluginSocket {
  constructor(plugged, name) {
    this.name = name;
    this.plugged = plugged;
    if (typeof this.plugged.__super__ === 'undefined') {
      this.plugged.__super__ = {};
    } else if (typeof this.plugged.__super__ === 'string') {
      this.plugged.__super__ = {
        '__string__': this.plugged.__super__
      };
    }
    this.plugged.__super__[name] = this.plugged;
    this.plugins = {};
    this.initialized_plugins = [];
  }

  // `_overrideAttribute` overrides an attribute on the original object
  // (the thing being plugged into).
  //
  // If the attribute being overridden is a function, then the original
  // function will still be available via the `__super__` attribute.
  //
  // If the same function is being overridden multiple times, then
  // the original function will be available at the end of a chain of
  // functions, starting from the most recent override, all the way
  // back to the original function, each being referenced by the
  // previous' __super__ attribute.
  //
  // For example:
  //
  // `plugin2.MyFunc.__super__.myFunc => plugin1.MyFunc.__super__.myFunc => original.myFunc`
  _overrideAttribute(key, plugin) {
    const value = plugin.overrides[key];
    if (typeof value === "function") {
      const default_super = {};
      default_super[this.name] = this.plugged;
      const super_method = this.plugged[key];
      this.plugged[key] = function () {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }
        return wrappedOverride.apply(this, [key, value, super_method, default_super, ...args]);
      };
    } else {
      this.plugged[key] = value;
    }
  }
  _extendObject(obj, attributes) {
    if (!obj.prototype.__super__) {
      obj.prototype.__super__ = {};
      obj.prototype.__super__[this.name] = this.plugged;
    }
    for (const [key, value] of Object.entries(attributes)) {
      if (key === 'events') {
        obj.prototype[key] = Object.assign(value, obj.prototype[key]);
      } else if (typeof value === 'function') {
        // We create a partially applied wrapper function, that
        // makes sure to set the proper super method when the
        // overriding method is called. This is done to enable
        // chaining of plugin methods, all the way up to the
        // original method.
        const default_super = {};
        default_super[this.name] = this.plugged;
        const super_method = obj.prototype[key];
        obj.prototype[key] = function () {
          for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
            args[_key3] = arguments[_key3];
          }
          return wrappedOverride.apply(this, [key, value, super_method, default_super, ...args]);
        };
      } else {
        obj.prototype[key] = value;
      }
    }
  }

  // Plugins can specify dependencies (by means of the
  // `dependencies` list attribute) which refers to dependencies
  // which will be initialized first, before the plugin itself gets initialized.
  //
  // If `strict_plugin_dependencies` is set to `false` (on the object being
  // made pluggable), then no error will be thrown if any of these plugins aren't
  // available.
  loadPluginDependencies(plugin) {
    var _plugin$dependencies;
    (_plugin$dependencies = plugin.dependencies) === null || _plugin$dependencies === void 0 ? void 0 : _plugin$dependencies.forEach(name => {
      const dep = this.plugins[name];
      if (dep) {
        var _dep$dependencies;
        if ((_dep$dependencies = dep.dependencies) !== null && _dep$dependencies !== void 0 && _dep$dependencies.includes(plugin.__name__)) {
          /* FIXME: circular dependency checking is only one level deep. */
          throw "Found a circular dependency between the plugins \"" + plugin.__name__ + "\" and \"" + name + "\"";
        }
        this.initializePlugin(dep);
      } else {
        this.throwUndefinedDependencyError("Could not find dependency \"" + name + "\" " + "for the plugin \"" + plugin.__name__ + "\". " + "If it's needed, make sure it's loaded by require.js");
      }
    });
  }
  throwUndefinedDependencyError(msg) {
    if (this.plugged.strict_plugin_dependencies) {
      throw msg;
    } else {
      if (console.warn) {
        console.warn(msg);
      } else {
        console.log(msg);
      }
    }
  }

  // `applyOverrides` is called by initializePlugin. It applies any
  // and all overrides of methods or Backbone views and models that
  // are defined on any of the plugins.
  applyOverrides(plugin) {
    Object.keys(plugin.overrides || {}).forEach(key => {
      const override = plugin.overrides[key];
      if (typeof override === "object") {
        if (typeof this.plugged[key] === 'undefined') {
          this.throwUndefinedDependencyError(`Plugin "${plugin.__name__}" tried to override "${key}" but it's not found.`);
        } else {
          this._extendObject(this.plugged[key], override);
        }
      } else {
        this._overrideAttribute(key, plugin);
      }
    });
  }

  // `initializePlugin` applies the overrides (if any) defined on all
  // the registered plugins and then calls the initialize method of the plugin
  initializePlugin(plugin) {
    var _plugin$enabled;
    if (!Object.keys(this.allowed_plugins).includes(plugin.__name__)) {
      /* Don't initialize disallowed plugins. */
      return;
    }
    if (this.initialized_plugins.includes(plugin.__name__)) {
      /* Don't initialize plugins twice, otherwise we get
      * infinite recursion in overridden methods.
      */
      return;
    }
    if (typeof plugin.enabled === 'boolean' && plugin.enabled || (_plugin$enabled = plugin.enabled) !== null && _plugin$enabled !== void 0 && _plugin$enabled.call(plugin, this.plugged) || plugin.enabled == null) {
      // isNil

      Object.assign(plugin, this.properties);
      if (plugin.dependencies) {
        this.loadPluginDependencies(plugin);
      }
      this.applyOverrides(plugin);
      if (typeof plugin.initialize === "function") {
        plugin.initialize.bind(plugin)(this);
      }
      this.initialized_plugins.push(plugin.__name__);
    }
  }

  // `registerPlugin` registers (or inserts, if you'd like) a plugin,
  // by adding it to the `plugins` map on the PluginSocket instance.
  registerPlugin(name, plugin) {
    if (name in this.plugins) {
      throw new Error('Error: Plugin name ' + name + ' is already taken');
    }
    plugin.__name__ = name;
    this.plugins[name] = plugin;
  }

  // `initializePlugins` should get called once all plugins have been
  // registered. It will then iterate through all the plugins, calling
  // `initializePlugin` for each.
  // The passed in  properties variable is an object with attributes and methods
  // which will be attached to the plugins.
  initializePlugins() {
    let properties = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let whitelist = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    let blacklist = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    if (!Object.keys(this.plugins).length) {
      return;
    }
    this.properties = properties;
    this.allowed_plugins = {};
    for (const [key, plugin] of Object.entries(this.plugins)) {
      if ((!whitelist.length || whitelist.includes(key)) && !blacklist.includes(key)) {
        this.allowed_plugins[key] = plugin;
      }
    }
    Object.values(this.allowed_plugins).forEach(o => this.initializePlugin(o));
  }
}
function enable(object, name, attrname) {
  // Call the `enable` method to make an object pluggable
  //
  // It takes three parameters:
  // - `object`: The object that gets made pluggable.
  // - `name`: The string name by which the now pluggable object
  //     may be referenced on the __super__ obj (in overrides).
  //     The default value is "plugged".
  // - `attrname`: The string name of the attribute on the now
  //     pluggable object, which refers to the PluginSocket instance
  //     that gets created.
  if (typeof attrname === "undefined") {
    attrname = "pluginSocket";
  }
  if (typeof name === 'undefined') {
    name = 'plugged';
  }
  object[attrname] = new PluginSocket(object, name);
  return object;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  enable
});

/***/ }),

/***/ "./node_modules/sprintf-js/src/sprintf.js":
/*!************************************************!*\
  !*** ./node_modules/sprintf-js/src/sprintf.js ***!
  \************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_RESULT__;/* global window, exports, define */

!function () {
  'use strict';

  var re = {
    not_string: /[^s]/,
    not_bool: /[^t]/,
    not_type: /[^T]/,
    not_primitive: /[^v]/,
    number: /[diefg]/,
    numeric_arg: /[bcdiefguxX]/,
    json: /[j]/,
    not_json: /[^j]/,
    text: /^[^\x25]+/,
    modulo: /^\x25{2}/,
    placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
    key: /^([a-z_][a-z_\d]*)/i,
    key_access: /^\.([a-z_][a-z_\d]*)/i,
    index_access: /^\[(\d+)\]/,
    sign: /^[+-]/
  };
  function sprintf(key) {
    // `arguments` is not an array, but should be fine for this call
    return sprintf_format(sprintf_parse(key), arguments);
  }
  function vsprintf(fmt, argv) {
    return sprintf.apply(null, [fmt].concat(argv || []));
  }
  function sprintf_format(parse_tree, argv) {
    var cursor = 1,
      tree_length = parse_tree.length,
      arg,
      output = '',
      i,
      k,
      ph,
      pad,
      pad_character,
      pad_length,
      is_positive,
      sign;
    for (i = 0; i < tree_length; i++) {
      if (typeof parse_tree[i] === 'string') {
        output += parse_tree[i];
      } else if (typeof parse_tree[i] === 'object') {
        ph = parse_tree[i]; // convenience purposes only
        if (ph.keys) {
          // keyword argument
          arg = argv[cursor];
          for (k = 0; k < ph.keys.length; k++) {
            if (arg == undefined) {
              throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
            }
            arg = arg[ph.keys[k]];
          }
        } else if (ph.param_no) {
          // positional argument (explicit)
          arg = argv[ph.param_no];
        } else {
          // positional argument (implicit)
          arg = argv[cursor++];
        }
        if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
          arg = arg();
        }
        if (re.numeric_arg.test(ph.type) && typeof arg !== 'number' && isNaN(arg)) {
          throw new TypeError(sprintf('[sprintf] expecting number but found %T', arg));
        }
        if (re.number.test(ph.type)) {
          is_positive = arg >= 0;
        }
        switch (ph.type) {
          case 'b':
            arg = parseInt(arg, 10).toString(2);
            break;
          case 'c':
            arg = String.fromCharCode(parseInt(arg, 10));
            break;
          case 'd':
          case 'i':
            arg = parseInt(arg, 10);
            break;
          case 'j':
            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
            break;
          case 'e':
            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
            break;
          case 'f':
            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
            break;
          case 'g':
            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
            break;
          case 'o':
            arg = (parseInt(arg, 10) >>> 0).toString(8);
            break;
          case 's':
            arg = String(arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case 't':
            arg = String(!!arg);
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case 'T':
            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case 'u':
            arg = parseInt(arg, 10) >>> 0;
            break;
          case 'v':
            arg = arg.valueOf();
            arg = ph.precision ? arg.substring(0, ph.precision) : arg;
            break;
          case 'x':
            arg = (parseInt(arg, 10) >>> 0).toString(16);
            break;
          case 'X':
            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
            break;
        }
        if (re.json.test(ph.type)) {
          output += arg;
        } else {
          if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
            sign = is_positive ? '+' : '-';
            arg = arg.toString().replace(re.sign, '');
          } else {
            sign = '';
          }
          pad_character = ph.pad_char ? ph.pad_char === '0' ? '0' : ph.pad_char.charAt(1) : ' ';
          pad_length = ph.width - (sign + arg).length;
          pad = ph.width ? pad_length > 0 ? pad_character.repeat(pad_length) : '' : '';
          output += ph.align ? sign + arg + pad : pad_character === '0' ? sign + pad + arg : pad + sign + arg;
        }
      }
    }
    return output;
  }
  var sprintf_cache = Object.create(null);
  function sprintf_parse(fmt) {
    if (sprintf_cache[fmt]) {
      return sprintf_cache[fmt];
    }
    var _fmt = fmt,
      match,
      parse_tree = [],
      arg_names = 0;
    while (_fmt) {
      if ((match = re.text.exec(_fmt)) !== null) {
        parse_tree.push(match[0]);
      } else if ((match = re.modulo.exec(_fmt)) !== null) {
        parse_tree.push('%');
      } else if ((match = re.placeholder.exec(_fmt)) !== null) {
        if (match[2]) {
          arg_names |= 1;
          var field_list = [],
            replacement_field = match[2],
            field_match = [];
          if ((field_match = re.key.exec(replacement_field)) !== null) {
            field_list.push(field_match[1]);
            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
              if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                field_list.push(field_match[1]);
              } else {
                throw new SyntaxError('[sprintf] failed to parse named argument key');
              }
            }
          } else {
            throw new SyntaxError('[sprintf] failed to parse named argument key');
          }
          match[2] = field_list;
        } else {
          arg_names |= 2;
        }
        if (arg_names === 3) {
          throw new Error('[sprintf] mixing positional and named placeholders is not (yet) supported');
        }
        parse_tree.push({
          placeholder: match[0],
          param_no: match[1],
          keys: match[2],
          sign: match[3],
          pad_char: match[4],
          align: match[5],
          width: match[6],
          precision: match[7],
          type: match[8]
        });
      } else {
        throw new SyntaxError('[sprintf] unexpected placeholder');
      }
      _fmt = _fmt.substring(match[0].length);
    }
    return sprintf_cache[fmt] = parse_tree;
  }

  /**
   * export to either browser or node.js
   */
  /* eslint-disable quote-props */
  if (true) {
    exports.sprintf = sprintf;
    exports.vsprintf = vsprintf;
  }
  if (typeof window !== 'undefined') {
    window['sprintf'] = sprintf;
    window['vsprintf'] = vsprintf;
    if (true) {
      !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
        return {
          'sprintf': sprintf,
          'vsprintf': vsprintf
        };
      }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
  }
  /* eslint-enable quote-props */
}(); // eslint-disable-line

/***/ }),

/***/ "./node_modules/strophe.js/src/bosh.js":
/*!*********************************************!*\
  !*** ./node_modules/strophe.js/src/bosh.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./shims */ "./src/strophe-shims.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core */ "./node_modules/strophe.js/src/core.js");
/*
    This program is distributed under the terms of the MIT license.
    Please see the LICENSE file for details.

    Copyright 2006-2008, OGG, LLC
*/

/* global ActiveXObject */




/** PrivateClass: Strophe.Request
 *  _Private_ helper class that provides a cross implementation abstraction
 *  for a BOSH related XMLHttpRequest.
 *
 *  The Strophe.Request class is used internally to encapsulate BOSH request
 *  information.  It is not meant to be used from user's code.
 */
_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request = class Request {
  /** PrivateConstructor: Strophe.Request
   *  Create and initialize a new Strophe.Request object.
   *
   *  Parameters:
   *    (XMLElement) elem - The XML data to be sent in the request.
   *    (Function) func - The function that will be called when the
   *      XMLHttpRequest readyState changes.
   *    (Integer) rid - The BOSH rid attribute associated with this request.
   *    (Integer) sends - The number of times this same request has been sent.
   */
  constructor(elem, func, rid, sends) {
    this.id = ++_core__WEBPACK_IMPORTED_MODULE_1__.Strophe._requestId;
    this.xmlData = elem;
    this.data = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(elem);
    // save original function in case we need to make a new request
    // from this one.
    this.origFunc = func;
    this.func = func;
    this.rid = rid;
    this.date = NaN;
    this.sends = sends || 0;
    this.abort = false;
    this.dead = null;
    this.age = function () {
      if (!this.date) {
        return 0;
      }
      const now = new Date();
      return (now - this.date) / 1000;
    };
    this.timeDead = function () {
      if (!this.dead) {
        return 0;
      }
      const now = new Date();
      return (now - this.dead) / 1000;
    };
    this.xhr = this._newXHR();
  }

  /** PrivateFunction: getResponse
   *  Get a response from the underlying XMLHttpRequest.
   *
   *  This function attempts to get a response from the request and checks
   *  for errors.
   *
   *  Throws:
   *    "parsererror" - A parser error occured.
   *    "bad-format" - The entity has sent XML that cannot be processed.
   *
   *  Returns:
   *    The DOM element tree of the response.
   */
  getResponse() {
    let node = null;
    if (this.xhr.responseXML && this.xhr.responseXML.documentElement) {
      node = this.xhr.responseXML.documentElement;
      if (node.tagName === "parsererror") {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("invalid response received");
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("responseText: " + this.xhr.responseText);
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("responseXML: " + _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(this.xhr.responseXML));
        throw new Error("parsererror");
      }
    } else if (this.xhr.responseText) {
      // In React Native, we may get responseText but no responseXML.  We can try to parse it manually.
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("Got responseText but no responseXML; attempting to parse it with DOMParser...");
      node = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(this.xhr.responseText, 'application/xml').documentElement;
      if (!node) {
        throw new Error('Parsing produced null node');
      } else if (node.querySelector('parsererror')) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("invalid response received: " + node.querySelector('parsererror').textContent);
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("responseText: " + this.xhr.responseText);
        const error = new Error();
        error.name = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.ErrorCondition.BAD_FORMAT;
        throw error;
      }
    }
    return node;
  }

  /** PrivateFunction: _newXHR
   *  _Private_ helper function to create XMLHttpRequests.
   *
   *  This function creates XMLHttpRequests across all implementations.
   *
   *  Returns:
   *    A new XMLHttpRequest.
   */
  _newXHR() {
    let xhr = null;
    if (window.XMLHttpRequest) {
      xhr = new XMLHttpRequest();
      if (xhr.overrideMimeType) {
        xhr.overrideMimeType("text/xml; charset=utf-8");
      }
    } else if (window.ActiveXObject) {
      xhr = new ActiveXObject("Microsoft.XMLHTTP");
    }
    // use Function.bind() to prepend ourselves as an argument
    xhr.onreadystatechange = this.func.bind(null, this);
    return xhr;
  }
};

/** Class: Strophe.Bosh
 *  _Private_ helper class that handles BOSH Connections
 *
 *  The Strophe.Bosh class is used internally by Strophe.Connection
 *  to encapsulate BOSH sessions. It is not meant to be used from user's code.
 */

/** File: bosh.js
 *  A JavaScript library to enable BOSH in Strophejs.
 *
 *  this library uses Bidirectional-streams Over Synchronous HTTP (BOSH)
 *  to emulate a persistent, stateful, two-way connection to an XMPP server.
 *  More information on BOSH can be found in XEP 124.
 */

/** PrivateConstructor: Strophe.Bosh
 *  Create and initialize a Strophe.Bosh object.
 *
 *  Parameters:
 *    (Strophe.Connection) connection - The Strophe.Connection that will use BOSH.
 *
 *  Returns:
 *    A new Strophe.Bosh object.
 */
_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Bosh = class Bosh {
  constructor(connection) {
    this._conn = connection;
    /* request id for body tags */
    this.rid = Math.floor(Math.random() * 4294967295);
    /* The current session ID. */
    this.sid = null;

    // default BOSH values
    this.hold = 1;
    this.wait = 60;
    this.window = 5;
    this.errors = 0;
    this.inactivity = null;
    this.lastResponseHeaders = null;
    this._requests = [];
  }

  /** PrivateFunction: _buildBody
   *  _Private_ helper function to generate the <body/> wrapper for BOSH.
   *
   *  Returns:
   *    A Strophe.Builder with a <body/> element.
   */
  _buildBody() {
    const bodyWrap = (0,_core__WEBPACK_IMPORTED_MODULE_1__.$build)('body', {
      'rid': this.rid++,
      'xmlns': _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.HTTPBIND
    });
    if (this.sid !== null) {
      bodyWrap.attrs({
        'sid': this.sid
      });
    }
    if (this._conn.options.keepalive && this._conn._sessionCachingSupported()) {
      this._cacheSession();
    }
    return bodyWrap;
  }

  /** PrivateFunction: _reset
   *  Reset the connection.
   *
   *  This function is called by the reset function of the Strophe Connection
   */
  _reset() {
    this.rid = Math.floor(Math.random() * 4294967295);
    this.sid = null;
    this.errors = 0;
    if (this._conn._sessionCachingSupported()) {
      window.sessionStorage.removeItem('strophe-bosh-session');
    }
    this._conn.nextValidRid(this.rid);
  }

  /** PrivateFunction: _connect
   *  _Private_ function that initializes the BOSH connection.
   *
   *  Creates and sends the Request that initializes the BOSH connection.
   */
  _connect(wait, hold, route) {
    this.wait = wait || this.wait;
    this.hold = hold || this.hold;
    this.errors = 0;
    const body = this._buildBody().attrs({
      "to": this._conn.domain,
      "xml:lang": "en",
      "wait": this.wait,
      "hold": this.hold,
      "content": "text/xml; charset=utf-8",
      "ver": "1.6",
      "xmpp:version": "1.0",
      "xmlns:xmpp": _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.BOSH
    });
    if (route) {
      body.attrs({
        'route': route
      });
    }
    const _connect_cb = this._conn._connect_cb;
    this._requests.push(new _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request(body.tree(), this._onRequestStateChange.bind(this, _connect_cb.bind(this._conn)), body.tree().getAttribute("rid")));
    this._throttledRequestHandler();
  }

  /** PrivateFunction: _attach
   *  Attach to an already created and authenticated BOSH session.
   *
   *  This function is provided to allow Strophe to attach to BOSH
   *  sessions which have been created externally, perhaps by a Web
   *  application.  This is often used to support auto-login type features
   *  without putting user credentials into the page.
   *
   *  Parameters:
   *    (String) jid - The full JID that is bound by the session.
   *    (String) sid - The SID of the BOSH session.
   *    (String) rid - The current RID of the BOSH session.  This RID
   *      will be used by the next request.
   *    (Function) callback The connect callback function.
   *    (Integer) wait - The optional HTTPBIND wait value.  This is the
   *      time the server will wait before returning an empty result for
   *      a request.  The default setting of 60 seconds is recommended.
   *      Other settings will require tweaks to the Strophe.TIMEOUT value.
   *    (Integer) hold - The optional HTTPBIND hold value.  This is the
   *      number of connections the server will hold at one time.  This
   *      should almost always be set to 1 (the default).
   *    (Integer) wind - The optional HTTBIND window value.  This is the
   *      allowed range of request ids that are valid.  The default is 5.
   */
  _attach(jid, sid, rid, callback, wait, hold, wind) {
    this._conn.jid = jid;
    this.sid = sid;
    this.rid = rid;
    this._conn.connect_callback = callback;
    this._conn.domain = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.getDomainFromJid(this._conn.jid);
    this._conn.authenticated = true;
    this._conn.connected = true;
    this.wait = wait || this.wait;
    this.hold = hold || this.hold;
    this.window = wind || this.window;
    this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ATTACHED, null);
  }

  /** PrivateFunction: _restore
   *  Attempt to restore a cached BOSH session
   *
   *  Parameters:
   *    (String) jid - The full JID that is bound by the session.
   *      This parameter is optional but recommended, specifically in cases
   *      where prebinded BOSH sessions are used where it's important to know
   *      that the right session is being restored.
   *    (Function) callback The connect callback function.
   *    (Integer) wait - The optional HTTPBIND wait value.  This is the
   *      time the server will wait before returning an empty result for
   *      a request.  The default setting of 60 seconds is recommended.
   *      Other settings will require tweaks to the Strophe.TIMEOUT value.
   *    (Integer) hold - The optional HTTPBIND hold value.  This is the
   *      number of connections the server will hold at one time.  This
   *      should almost always be set to 1 (the default).
   *    (Integer) wind - The optional HTTBIND window value.  This is the
   *      allowed range of request ids that are valid.  The default is 5.
   */
  _restore(jid, callback, wait, hold, wind) {
    const session = JSON.parse(window.sessionStorage.getItem('strophe-bosh-session'));
    if (typeof session !== "undefined" && session !== null && session.rid && session.sid && session.jid && (typeof jid === "undefined" || jid === null || _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.getBareJidFromJid(session.jid) === _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.getBareJidFromJid(jid) ||
    // If authcid is null, then it's an anonymous login, so
    // we compare only the domains:
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.getNodeFromJid(jid) === null && _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.getDomainFromJid(session.jid) === jid)) {
      this._conn.restored = true;
      this._attach(session.jid, session.sid, session.rid, callback, wait, hold, wind);
    } else {
      const error = new Error("_restore: no restoreable session.");
      error.name = "StropheSessionError";
      throw error;
    }
  }

  /** PrivateFunction: _cacheSession
   *  _Private_ handler for the beforeunload event.
   *
   *  This handler is used to process the Bosh-part of the initial request.
   *  Parameters:
   *    (Strophe.Request) bodyWrap - The received stanza.
   */
  _cacheSession() {
    if (this._conn.authenticated) {
      if (this._conn.jid && this.rid && this.sid) {
        window.sessionStorage.setItem('strophe-bosh-session', JSON.stringify({
          'jid': this._conn.jid,
          'rid': this.rid,
          'sid': this.sid
        }));
      }
    } else {
      window.sessionStorage.removeItem('strophe-bosh-session');
    }
  }

  /** PrivateFunction: _connect_cb
   *  _Private_ handler for initial connection request.
   *
   *  This handler is used to process the Bosh-part of the initial request.
   *  Parameters:
   *    (Strophe.Request) bodyWrap - The received stanza.
   */
  _connect_cb(bodyWrap) {
    const typ = bodyWrap.getAttribute("type");
    if (typ !== null && typ === "terminate") {
      // an error occurred
      let cond = bodyWrap.getAttribute("condition");
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("BOSH-Connection failed: " + cond);
      const conflict = bodyWrap.getElementsByTagName("conflict");
      if (cond !== null) {
        if (cond === "remote-stream-error" && conflict.length > 0) {
          cond = "conflict";
        }
        this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, cond);
      } else {
        this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "unknown");
      }
      this._conn._doDisconnect(cond);
      return _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL;
    }

    // check to make sure we don't overwrite these if _connect_cb is
    // called multiple times in the case of missing stream:features
    if (!this.sid) {
      this.sid = bodyWrap.getAttribute("sid");
    }
    const wind = bodyWrap.getAttribute('requests');
    if (wind) {
      this.window = parseInt(wind, 10);
    }
    const hold = bodyWrap.getAttribute('hold');
    if (hold) {
      this.hold = parseInt(hold, 10);
    }
    const wait = bodyWrap.getAttribute('wait');
    if (wait) {
      this.wait = parseInt(wait, 10);
    }
    const inactivity = bodyWrap.getAttribute('inactivity');
    if (inactivity) {
      this.inactivity = parseInt(inactivity, 10);
    }
  }

  /** PrivateFunction: _disconnect
   *  _Private_ part of Connection.disconnect for Bosh
   *
   *  Parameters:
   *    (Request) pres - This stanza will be sent before disconnecting.
   */
  _disconnect(pres) {
    this._sendTerminate(pres);
  }

  /** PrivateFunction: _doDisconnect
   *  _Private_ function to disconnect.
   *
   *  Resets the SID and RID.
   */
  _doDisconnect() {
    this.sid = null;
    this.rid = Math.floor(Math.random() * 4294967295);
    if (this._conn._sessionCachingSupported()) {
      window.sessionStorage.removeItem('strophe-bosh-session');
    }
    this._conn.nextValidRid(this.rid);
  }

  /** PrivateFunction: _emptyQueue
   * _Private_ function to check if the Request queue is empty.
   *
   *  Returns:
   *    True, if there are no Requests queued, False otherwise.
   */
  _emptyQueue() {
    return this._requests.length === 0;
  }

  /** PrivateFunction: _callProtocolErrorHandlers
   *  _Private_ function to call error handlers registered for HTTP errors.
   *
   *  Parameters:
   *    (Strophe.Request) req - The request that is changing readyState.
   */
  _callProtocolErrorHandlers(req) {
    const reqStatus = Bosh._getRequestStatus(req);
    const err_callback = this._conn.protocolErrorHandlers.HTTP[reqStatus];
    if (err_callback) {
      err_callback.call(this, reqStatus);
    }
  }

  /** PrivateFunction: _hitError
   *  _Private_ function to handle the error count.
   *
   *  Requests are resent automatically until their error count reaches
   *  5.  Each time an error is encountered, this function is called to
   *  increment the count and disconnect if the count is too high.
   *
   *  Parameters:
   *    (Integer) reqStatus - The request status.
   */
  _hitError(reqStatus) {
    this.errors++;
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("request errored, status: " + reqStatus + ", number of errors: " + this.errors);
    if (this.errors > 4) {
      this._conn._onDisconnectTimeout();
    }
  }

  /** PrivateFunction: _no_auth_received
   *
   * Called on stream start/restart when no stream:features
   * has been received and sends a blank poll request.
   */
  _no_auth_received(callback) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Server did not yet offer a supported authentication " + "mechanism. Sending a blank poll request.");
    if (callback) {
      callback = callback.bind(this._conn);
    } else {
      callback = this._conn._connect_cb.bind(this._conn);
    }
    const body = this._buildBody();
    this._requests.push(new _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request(body.tree(), this._onRequestStateChange.bind(this, callback), body.tree().getAttribute("rid")));
    this._throttledRequestHandler();
  }

  /** PrivateFunction: _onDisconnectTimeout
   *  _Private_ timeout handler for handling non-graceful disconnection.
   *
   *  Cancels all remaining Requests and clears the queue.
   */
  _onDisconnectTimeout() {
    this._abortAllRequests();
  }

  /** PrivateFunction: _abortAllRequests
   *  _Private_ helper function that makes sure all pending requests are aborted.
   */
  _abortAllRequests() {
    while (this._requests.length > 0) {
      const req = this._requests.pop();
      req.abort = true;
      req.xhr.abort();
      req.xhr.onreadystatechange = function () {};
    }
  }

  /** PrivateFunction: _onIdle
   *  _Private_ handler called by Strophe.Connection._onIdle
   *
   *  Sends all queued Requests or polls with empty Request if there are none.
   */
  _onIdle() {
    const data = this._conn._data;
    // if no requests are in progress, poll
    if (this._conn.authenticated && this._requests.length === 0 && data.length === 0 && !this._conn.disconnecting) {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("no requests during idle cycle, sending blank request");
      data.push(null);
    }
    if (this._conn.paused) {
      return;
    }
    if (this._requests.length < 2 && data.length > 0) {
      const body = this._buildBody();
      for (let i = 0; i < data.length; i++) {
        if (data[i] !== null) {
          if (data[i] === "restart") {
            body.attrs({
              "to": this._conn.domain,
              "xml:lang": "en",
              "xmpp:restart": "true",
              "xmlns:xmpp": _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.BOSH
            });
          } else {
            body.cnode(data[i]).up();
          }
        }
      }
      delete this._conn._data;
      this._conn._data = [];
      this._requests.push(new _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request(body.tree(), this._onRequestStateChange.bind(this, this._conn._dataRecv.bind(this._conn)), body.tree().getAttribute("rid")));
      this._throttledRequestHandler();
    }
    if (this._requests.length > 0) {
      const time_elapsed = this._requests[0].age();
      if (this._requests[0].dead !== null) {
        if (this._requests[0].timeDead() > Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.SECONDARY_TIMEOUT * this.wait)) {
          this._throttledRequestHandler();
        }
      }
      if (time_elapsed > Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.TIMEOUT * this.wait)) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Request " + this._requests[0].id + " timed out, over " + Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.TIMEOUT * this.wait) + " seconds since last activity");
        this._throttledRequestHandler();
      }
    }
  }

  /** PrivateFunction: _getRequestStatus
   *
   *  Returns the HTTP status code from a Strophe.Request
   *
   *  Parameters:
   *    (Strophe.Request) req - The Strophe.Request instance.
   *    (Integer) def - The default value that should be returned if no
   *          status value was found.
   */
  static _getRequestStatus(req, def) {
    let reqStatus;
    if (req.xhr.readyState === 4) {
      try {
        reqStatus = req.xhr.status;
      } catch (e) {
        // ignore errors from undefined status attribute. Works
        // around a browser bug
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Caught an error while retrieving a request's status, " + "reqStatus: " + reqStatus);
      }
    }
    if (typeof reqStatus === "undefined") {
      reqStatus = typeof def === 'number' ? def : 0;
    }
    return reqStatus;
  }

  /** PrivateFunction: _onRequestStateChange
   *  _Private_ handler for Strophe.Request state changes.
   *
   *  This function is called when the XMLHttpRequest readyState changes.
   *  It contains a lot of error handling logic for the many ways that
   *  requests can fail, and calls the request callback when requests
   *  succeed.
   *
   *  Parameters:
   *    (Function) func - The handler for the request.
   *    (Strophe.Request) req - The request that is changing readyState.
   */
  _onRequestStateChange(func, req) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("request id " + req.id + "." + req.sends + " state changed to " + req.xhr.readyState);
    if (req.abort) {
      req.abort = false;
      return;
    }
    if (req.xhr.readyState !== 4) {
      // The request is not yet complete
      return;
    }
    const reqStatus = Bosh._getRequestStatus(req);
    this.lastResponseHeaders = req.xhr.getAllResponseHeaders();
    if (this._conn.disconnecting && reqStatus >= 400) {
      this._hitError(reqStatus);
      this._callProtocolErrorHandlers(req);
      return;
    }
    const reqIs0 = this._requests[0] === req;
    const reqIs1 = this._requests[1] === req;
    const valid_request = reqStatus > 0 && reqStatus < 500;
    const too_many_retries = req.sends > this._conn.maxRetries;
    if (valid_request || too_many_retries) {
      // remove from internal queue
      this._removeRequest(req);
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("request id " + req.id + " should now be removed");
    }
    if (reqStatus === 200) {
      // request succeeded
      // if request 1 finished, or request 0 finished and request
      // 1 is over Strophe.SECONDARY_TIMEOUT seconds old, we need to
      // restart the other - both will be in the first spot, as the
      // completed request has been removed from the queue already
      if (reqIs1 || reqIs0 && this._requests.length > 0 && this._requests[0].age() > Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.SECONDARY_TIMEOUT * this.wait)) {
        this._restartRequest(0);
      }
      this._conn.nextValidRid(Number(req.rid) + 1);
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("request id " + req.id + "." + req.sends + " got 200");
      func(req); // call handler
      this.errors = 0;
    } else if (reqStatus === 0 || reqStatus >= 400 && reqStatus < 600 || reqStatus >= 12000) {
      // request failed
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("request id " + req.id + "." + req.sends + " error " + reqStatus + " happened");
      this._hitError(reqStatus);
      this._callProtocolErrorHandlers(req);
      if (reqStatus >= 400 && reqStatus < 500) {
        this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.DISCONNECTING, null);
        this._conn._doDisconnect();
      }
    } else {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("request id " + req.id + "." + req.sends + " error " + reqStatus + " happened");
    }
    if (!valid_request && !too_many_retries) {
      this._throttledRequestHandler();
    } else if (too_many_retries && !this._conn.connected) {
      this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "giving-up");
    }
  }

  /** PrivateFunction: _processRequest
   *  _Private_ function to process a request in the queue.
   *
   *  This function takes requests off the queue and sends them and
   *  restarts dead requests.
   *
   *  Parameters:
   *    (Integer) i - The index of the request in the queue.
   */
  _processRequest(i) {
    let req = this._requests[i];
    const reqStatus = Bosh._getRequestStatus(req, -1);

    // make sure we limit the number of retries
    if (req.sends > this._conn.maxRetries) {
      this._conn._onDisconnectTimeout();
      return;
    }
    const time_elapsed = req.age();
    const primary_timeout = !isNaN(time_elapsed) && time_elapsed > Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.TIMEOUT * this.wait);
    const secondary_timeout = req.dead !== null && req.timeDead() > Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.SECONDARY_TIMEOUT * this.wait);
    const server_error = req.xhr.readyState === 4 && (reqStatus < 1 || reqStatus >= 500);
    if (primary_timeout || secondary_timeout || server_error) {
      if (secondary_timeout) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error(`Request ${this._requests[i].id} timed out (secondary), restarting`);
      }
      req.abort = true;
      req.xhr.abort();
      // setting to null fails on IE6, so set to empty function
      req.xhr.onreadystatechange = function () {};
      this._requests[i] = new _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request(req.xmlData, req.origFunc, req.rid, req.sends);
      req = this._requests[i];
    }
    if (req.xhr.readyState === 0) {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("request id " + req.id + "." + req.sends + " posting");
      try {
        const content_type = this._conn.options.contentType || "text/xml; charset=utf-8";
        req.xhr.open("POST", this._conn.service, this._conn.options.sync ? false : true);
        if (typeof req.xhr.setRequestHeader !== 'undefined') {
          // IE9 doesn't have setRequestHeader
          req.xhr.setRequestHeader("Content-Type", content_type);
        }
        if (this._conn.options.withCredentials) {
          req.xhr.withCredentials = true;
        }
      } catch (e2) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("XHR open failed: " + e2.toString());
        if (!this._conn.connected) {
          this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "bad-service");
        }
        this._conn.disconnect();
        return;
      }

      // Fires the XHR request -- may be invoked immediately
      // or on a gradually expanding retry window for reconnects
      const sendFunc = () => {
        req.date = new Date();
        if (this._conn.options.customHeaders) {
          const headers = this._conn.options.customHeaders;
          for (const header in headers) {
            if (Object.prototype.hasOwnProperty.call(headers, header)) {
              req.xhr.setRequestHeader(header, headers[header]);
            }
          }
        }
        req.xhr.send(req.data);
      };

      // Implement progressive backoff for reconnects --
      // First retry (send === 1) should also be instantaneous
      if (req.sends > 1) {
        // Using a cube of the retry number creates a nicely
        // expanding retry window
        const backoff = Math.min(Math.floor(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.TIMEOUT * this.wait), Math.pow(req.sends, 3)) * 1000;
        setTimeout(function () {
          // XXX: setTimeout should be called only with function expressions (23974bc1)
          sendFunc();
        }, backoff);
      } else {
        sendFunc();
      }
      req.sends++;
      if (this._conn.xmlOutput !== _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Connection.prototype.xmlOutput) {
        if (req.xmlData.nodeName === this.strip && req.xmlData.childNodes.length) {
          this._conn.xmlOutput(req.xmlData.childNodes[0]);
        } else {
          this._conn.xmlOutput(req.xmlData);
        }
      }
      if (this._conn.rawOutput !== _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Connection.prototype.rawOutput) {
        this._conn.rawOutput(req.data);
      }
    } else {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("_processRequest: " + (i === 0 ? "first" : "second") + " request has readyState of " + req.xhr.readyState);
    }
  }

  /** PrivateFunction: _removeRequest
   *  _Private_ function to remove a request from the queue.
   *
   *  Parameters:
   *    (Strophe.Request) req - The request to remove.
   */
  _removeRequest(req) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("removing request");
    for (let i = this._requests.length - 1; i >= 0; i--) {
      if (req === this._requests[i]) {
        this._requests.splice(i, 1);
      }
    }
    // IE6 fails on setting to null, so set to empty function
    req.xhr.onreadystatechange = function () {};
    this._throttledRequestHandler();
  }

  /** PrivateFunction: _restartRequest
   *  _Private_ function to restart a request that is presumed dead.
   *
   *  Parameters:
   *    (Integer) i - The index of the request in the queue.
   */
  _restartRequest(i) {
    const req = this._requests[i];
    if (req.dead === null) {
      req.dead = new Date();
    }
    this._processRequest(i);
  }

  /** PrivateFunction: _reqToData
   * _Private_ function to get a stanza out of a request.
   *
   * Tries to extract a stanza out of a Request Object.
   * When this fails the current connection will be disconnected.
   *
   *  Parameters:
   *    (Object) req - The Request.
   *
   *  Returns:
   *    The stanza that was passed.
   */
  _reqToData(req) {
    try {
      return req.getResponse();
    } catch (e) {
      if (e.message !== "parsererror") {
        throw e;
      }
      this._conn.disconnect("strophe-parsererror");
    }
  }

  /** PrivateFunction: _sendTerminate
   *  _Private_ function to send initial disconnect sequence.
   *
   *  This is the first step in a graceful disconnect.  It sends
   *  the BOSH server a terminate body and includes an unavailable
   *  presence if authentication has completed.
   */
  _sendTerminate(pres) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("_sendTerminate was called");
    const body = this._buildBody().attrs({
      type: "terminate"
    });
    if (pres) {
      body.cnode(pres.tree());
    }
    const req = new _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Request(body.tree(), this._onRequestStateChange.bind(this, this._conn._dataRecv.bind(this._conn)), body.tree().getAttribute("rid"));
    this._requests.push(req);
    this._throttledRequestHandler();
  }

  /** PrivateFunction: _send
   *  _Private_ part of the Connection.send function for BOSH
   *
   * Just triggers the RequestHandler to send the messages that are in the queue
   */
  _send() {
    clearTimeout(this._conn._idleTimeout);
    this._throttledRequestHandler();
    this._conn._idleTimeout = setTimeout(() => this._conn._onIdle(), 100);
  }

  /** PrivateFunction: _sendRestart
   *
   *  Send an xmpp:restart stanza.
   */
  _sendRestart() {
    this._throttledRequestHandler();
    clearTimeout(this._conn._idleTimeout);
  }

  /** PrivateFunction: _throttledRequestHandler
   *  _Private_ function to throttle requests to the connection window.
   *
   *  This function makes sure we don't send requests so fast that the
   *  request ids overflow the connection window in the case that one
   *  request died.
   */
  _throttledRequestHandler() {
    if (!this._requests) {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("_throttledRequestHandler called with " + "undefined requests");
    } else {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("_throttledRequestHandler called with " + this._requests.length + " requests");
    }
    if (!this._requests || this._requests.length === 0) {
      return;
    }
    if (this._requests.length > 0) {
      this._processRequest(0);
    }
    if (this._requests.length > 1 && Math.abs(this._requests[0].rid - this._requests[1].rid) < this.window) {
      this._processRequest(1);
    }
  }
};

/** Variable: strip
 *
 *  BOSH-Connections will have all stanzas wrapped in a <body> tag when
 *  passed to <Strophe.Connection.xmlInput> or <Strophe.Connection.xmlOutput>.
 *  To strip this tag, User code can set <Strophe.Bosh.strip> to "body":
 *
 *  > Strophe.Bosh.prototype.strip = "body";
 *
 *  This will enable stripping of the body tag in both
 *  <Strophe.Connection.xmlInput> and <Strophe.Connection.xmlOutput>.
 */
_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Bosh.prototype.strip = null;

/***/ }),

/***/ "./node_modules/strophe.js/src/core.js":
/*!*********************************************!*\
  !*** ./node_modules/strophe.js/src/core.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$build": () => (/* binding */ $build),
/* harmony export */   "$iq": () => (/* binding */ $iq),
/* harmony export */   "$msg": () => (/* binding */ $msg),
/* harmony export */   "$pres": () => (/* binding */ $pres),
/* harmony export */   "Strophe": () => (/* binding */ Strophe),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./shims */ "./src/strophe-shims.js");
/* harmony import */ var _sasl_anon_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sasl-anon.js */ "./node_modules/strophe.js/src/sasl-anon.js");
/* harmony import */ var _sasl_external_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sasl-external.js */ "./node_modules/strophe.js/src/sasl-external.js");
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _sasl_oauthbearer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sasl-oauthbearer.js */ "./node_modules/strophe.js/src/sasl-oauthbearer.js");
/* harmony import */ var _sasl_plain_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sasl-plain.js */ "./node_modules/strophe.js/src/sasl-plain.js");
/* harmony import */ var _sasl_sha1_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./sasl-sha1.js */ "./node_modules/strophe.js/src/sasl-sha1.js");
/* harmony import */ var _sasl_sha256_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./sasl-sha256.js */ "./node_modules/strophe.js/src/sasl-sha256.js");
/* harmony import */ var _sasl_sha384_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sasl-sha384.js */ "./node_modules/strophe.js/src/sasl-sha384.js");
/* harmony import */ var _sasl_sha512_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./sasl-sha512.js */ "./node_modules/strophe.js/src/sasl-sha512.js");
/* harmony import */ var _sasl_xoauth2_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./sasl-xoauth2.js */ "./node_modules/strophe.js/src/sasl-xoauth2.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils */ "./node_modules/strophe.js/src/utils.js");
/* harmony import */ var abab__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! abab */ "./node_modules/abab/index.js");
/* harmony import */ var abab__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(abab__WEBPACK_IMPORTED_MODULE_12__);
/*
    This program is distributed under the terms of the MIT license.
    Please see the LICENSE file for details.

    Copyright 2006-2018, OGG, LLC
*/
/*global define, document, sessionStorage, setTimeout, clearTimeout, ActiveXObject, DOMParser, btoa, atob */















/** Function: $build
 *  Create a Strophe.Builder.
 *  This is an alias for 'new Strophe.Builder(name, attrs)'.
 *
 *  Parameters:
 *    (String) name - The root element name.
 *    (Object) attrs - The attributes for the root element in object notation.
 *
 *  Returns:
 *    A new Strophe.Builder object.
 */
function $build(name, attrs) {
  return new Strophe.Builder(name, attrs);
}

/** Function: $msg
 *  Create a Strophe.Builder with a <message/> element as the root.
 *
 *  Parameters:
 *    (Object) attrs - The <message/> element attributes in object notation.
 *
 *  Returns:
 *    A new Strophe.Builder object.
 */
function $msg(attrs) {
  return new Strophe.Builder("message", attrs);
}

/** Function: $iq
 *  Create a Strophe.Builder with an <iq/> element as the root.
 *
 *  Parameters:
 *    (Object) attrs - The <iq/> element attributes in object notation.
 *
 *  Returns:
 *    A new Strophe.Builder object.
 */
function $iq(attrs) {
  return new Strophe.Builder("iq", attrs);
}

/** Function: $pres
 *  Create a Strophe.Builder with a <presence/> element as the root.
 *
 *  Parameters:
 *    (Object) attrs - The <presence/> element attributes in object notation.
 *
 *  Returns:
 *    A new Strophe.Builder object.
 */
function $pres(attrs) {
  return new Strophe.Builder("presence", attrs);
}

/** Class: Strophe
 *  An object container for all Strophe library functions.
 *
 *  This class is just a container for all the objects and constants
 *  used in the library.  It is not meant to be instantiated, but to
 *  provide a namespace for library objects, constants, and functions.
 */
const Strophe = {
  /** Constant: VERSION */
  VERSION: "1.6.0",
  /** Constants: XMPP Namespace Constants
   *  Common namespace constants from the XMPP RFCs and XEPs.
   *
   *  NS.HTTPBIND - HTTP BIND namespace from XEP 124.
   *  NS.BOSH - BOSH namespace from XEP 206.
   *  NS.CLIENT - Main XMPP client namespace.
   *  NS.AUTH - Legacy authentication namespace.
   *  NS.ROSTER - Roster operations namespace.
   *  NS.PROFILE - Profile namespace.
   *  NS.DISCO_INFO - Service discovery info namespace from XEP 30.
   *  NS.DISCO_ITEMS - Service discovery items namespace from XEP 30.
   *  NS.MUC - Multi-User Chat namespace from XEP 45.
   *  NS.SASL - XMPP SASL namespace from RFC 3920.
   *  NS.STREAM - XMPP Streams namespace from RFC 3920.
   *  NS.BIND - XMPP Binding namespace from RFC 3920 and RFC 6120.
   *  NS.SESSION - XMPP Session namespace from RFC 3920.
   *  NS.XHTML_IM - XHTML-IM namespace from XEP 71.
   *  NS.XHTML - XHTML body namespace from XEP 71.
   */
  NS: {
    HTTPBIND: "http://jabber.org/protocol/httpbind",
    BOSH: "urn:xmpp:xbosh",
    CLIENT: "jabber:client",
    AUTH: "jabber:iq:auth",
    ROSTER: "jabber:iq:roster",
    PROFILE: "jabber:iq:profile",
    DISCO_INFO: "http://jabber.org/protocol/disco#info",
    DISCO_ITEMS: "http://jabber.org/protocol/disco#items",
    MUC: "http://jabber.org/protocol/muc",
    SASL: "urn:ietf:params:xml:ns:xmpp-sasl",
    STREAM: "http://etherx.jabber.org/streams",
    FRAMING: "urn:ietf:params:xml:ns:xmpp-framing",
    BIND: "urn:ietf:params:xml:ns:xmpp-bind",
    SESSION: "urn:ietf:params:xml:ns:xmpp-session",
    VERSION: "jabber:iq:version",
    STANZAS: "urn:ietf:params:xml:ns:xmpp-stanzas",
    XHTML_IM: "http://jabber.org/protocol/xhtml-im",
    XHTML: "http://www.w3.org/1999/xhtml"
  },
  /** Constants: XHTML_IM Namespace
   *  contains allowed tags, tag attributes, and css properties.
   *  Used in the createHtml function to filter incoming html into the allowed XHTML-IM subset.
   *  See http://xmpp.org/extensions/xep-0071.html#profile-summary for the list of recommended
   *  allowed tags and their attributes.
   */
  XHTML: {
    tags: ['a', 'blockquote', 'br', 'cite', 'em', 'img', 'li', 'ol', 'p', 'span', 'strong', 'ul', 'body'],
    attributes: {
      'a': ['href'],
      'blockquote': ['style'],
      'br': [],
      'cite': ['style'],
      'em': [],
      'img': ['src', 'alt', 'style', 'height', 'width'],
      'li': ['style'],
      'ol': ['style'],
      'p': ['style'],
      'span': ['style'],
      'strong': [],
      'ul': ['style'],
      'body': []
    },
    css: ['background-color', 'color', 'font-family', 'font-size', 'font-style', 'font-weight', 'margin-left', 'margin-right', 'text-align', 'text-decoration'],
    /** Function: XHTML.validTag
     *
     * Utility method to determine whether a tag is allowed
     * in the XHTML_IM namespace.
     *
     * XHTML tag names are case sensitive and must be lower case.
     */
    validTag(tag) {
      for (let i = 0; i < Strophe.XHTML.tags.length; i++) {
        if (tag === Strophe.XHTML.tags[i]) {
          return true;
        }
      }
      return false;
    },
    /** Function: XHTML.validAttribute
     *
     * Utility method to determine whether an attribute is allowed
     * as recommended per XEP-0071
     *
     * XHTML attribute names are case sensitive and must be lower case.
     */
    validAttribute(tag, attribute) {
      if (typeof Strophe.XHTML.attributes[tag] !== 'undefined' && Strophe.XHTML.attributes[tag].length > 0) {
        for (let i = 0; i < Strophe.XHTML.attributes[tag].length; i++) {
          if (attribute === Strophe.XHTML.attributes[tag][i]) {
            return true;
          }
        }
      }
      return false;
    },
    validCSS(style) {
      for (let i = 0; i < Strophe.XHTML.css.length; i++) {
        if (style === Strophe.XHTML.css[i]) {
          return true;
        }
      }
      return false;
    }
  },
  /** Constants: Connection Status Constants
   *  Connection status constants for use by the connection handler
   *  callback.
   *
   *  Status.ERROR - An error has occurred
   *  Status.CONNECTING - The connection is currently being made
   *  Status.CONNFAIL - The connection attempt failed
   *  Status.AUTHENTICATING - The connection is authenticating
   *  Status.AUTHFAIL - The authentication attempt failed
   *  Status.CONNECTED - The connection has succeeded
   *  Status.DISCONNECTED - The connection has been terminated
   *  Status.DISCONNECTING - The connection is currently being terminated
   *  Status.ATTACHED - The connection has been attached
   *  Status.REDIRECT - The connection has been redirected
   *  Status.CONNTIMEOUT - The connection has timed out
   */
  Status: {
    ERROR: 0,
    CONNECTING: 1,
    CONNFAIL: 2,
    AUTHENTICATING: 3,
    AUTHFAIL: 4,
    CONNECTED: 5,
    DISCONNECTED: 6,
    DISCONNECTING: 7,
    ATTACHED: 8,
    REDIRECT: 9,
    CONNTIMEOUT: 10,
    BINDREQUIRED: 11,
    ATTACHFAIL: 12
  },
  ErrorCondition: {
    BAD_FORMAT: "bad-format",
    CONFLICT: "conflict",
    MISSING_JID_NODE: "x-strophe-bad-non-anon-jid",
    NO_AUTH_MECH: "no-auth-mech",
    UNKNOWN_REASON: "unknown"
  },
  /** Constants: Log Level Constants
   *  Logging level indicators.
   *
   *  LogLevel.DEBUG - Debug output
   *  LogLevel.INFO - Informational output
   *  LogLevel.WARN - Warnings
   *  LogLevel.ERROR - Errors
   *  LogLevel.FATAL - Fatal errors
   */
  LogLevel: {
    DEBUG: 0,
    INFO: 1,
    WARN: 2,
    ERROR: 3,
    FATAL: 4
  },
  /** PrivateConstants: DOM Element Type Constants
   *  DOM element types.
   *
   *  ElementType.NORMAL - Normal element.
   *  ElementType.TEXT - Text data element.
   *  ElementType.FRAGMENT - XHTML fragment element.
   */
  ElementType: {
    NORMAL: 1,
    TEXT: 3,
    CDATA: 4,
    FRAGMENT: 11
  },
  /** PrivateConstants: Timeout Values
   *  Timeout values for error states.  These values are in seconds.
   *  These should not be changed unless you know exactly what you are
   *  doing.
   *
   *  TIMEOUT - Timeout multiplier. A waiting request will be considered
   *      failed after Math.floor(TIMEOUT * wait) seconds have elapsed.
   *      This defaults to 1.1, and with default wait, 66 seconds.
   *  SECONDARY_TIMEOUT - Secondary timeout multiplier. In cases where
   *      Strophe can detect early failure, it will consider the request
   *      failed if it doesn't return after
   *      Math.floor(SECONDARY_TIMEOUT * wait) seconds have elapsed.
   *      This defaults to 0.1, and with default wait, 6 seconds.
   */
  TIMEOUT: 1.1,
  SECONDARY_TIMEOUT: 0.1,
  /** Function: addNamespace
   *  This function is used to extend the current namespaces in
   *  Strophe.NS.  It takes a key and a value with the key being the
   *  name of the new namespace, with its actual value.
   *  For example:
   *  Strophe.addNamespace('PUBSUB', "http://jabber.org/protocol/pubsub");
   *
   *  Parameters:
   *    (String) name - The name under which the namespace will be
   *      referenced under Strophe.NS
   *    (String) value - The actual namespace.
   */
  addNamespace(name, value) {
    Strophe.NS[name] = value;
  },
  /** Function: forEachChild
   *  Map a function over some or all child elements of a given element.
   *
   *  This is a small convenience function for mapping a function over
   *  some or all of the children of an element.  If elemName is null, all
   *  children will be passed to the function, otherwise only children
   *  whose tag names match elemName will be passed.
   *
   *  Parameters:
   *    (XMLElement) elem - The element to operate on.
   *    (String) elemName - The child element tag name filter.
   *    (Function) func - The function to apply to each child.  This
   *      function should take a single argument, a DOM element.
   */
  forEachChild(elem, elemName, func) {
    for (let i = 0; i < elem.childNodes.length; i++) {
      const childNode = elem.childNodes[i];
      if (childNode.nodeType === Strophe.ElementType.NORMAL && (!elemName || this.isTagEqual(childNode, elemName))) {
        func(childNode);
      }
    }
  },
  /** Function: isTagEqual
   *  Compare an element's tag name with a string.
   *
   *  This function is case sensitive.
   *
   *  Parameters:
   *    (XMLElement) el - A DOM element.
   *    (String) name - The element name.
   *
   *  Returns:
   *    true if the element's tag name matches _el_, and false
   *    otherwise.
   */
  isTagEqual(el, name) {
    return el.tagName === name;
  },
  /** PrivateVariable: _xmlGenerator
   *  _Private_ variable that caches a DOM document to
   *  generate elements.
   */
  _xmlGenerator: null,
  /** Function: xmlGenerator
   *  Get the DOM document to generate elements.
   *
   *  Returns:
   *    The currently used DOM document.
   */
  xmlGenerator() {
    if (!Strophe._xmlGenerator) {
      Strophe._xmlGenerator = _shims__WEBPACK_IMPORTED_MODULE_0__.getDummyXMLDOMDocument();
    }
    return Strophe._xmlGenerator;
  },
  /** Function: xmlElement
   *  Create an XML DOM element.
   *
   *  This function creates an XML DOM element correctly across all
   *  implementations. Note that these are not HTML DOM elements, which
   *  aren't appropriate for XMPP stanzas.
   *
   *  Parameters:
   *    (String) name - The name for the element.
   *    (Array|Object) attrs - An optional array or object containing
   *      key/value pairs to use as element attributes. The object should
   *      be in the format {'key': 'value'} or {key: 'value'}. The array
   *      should have the format [['key1', 'value1'], ['key2', 'value2']].
   *    (String) text - The text child data for the element.
   *
   *  Returns:
   *    A new XML DOM element.
   */
  xmlElement(name) {
    if (!name) {
      return null;
    }
    const node = Strophe.xmlGenerator().createElement(name);
    // FIXME: this should throw errors if args are the wrong type or
    // there are more than two optional args
    for (let a = 1; a < arguments.length; a++) {
      const arg = arguments[a];
      if (!arg) {
        continue;
      }
      if (typeof arg === "string" || typeof arg === "number") {
        node.appendChild(Strophe.xmlTextNode(arg));
      } else if (typeof arg === "object" && typeof arg.sort === "function") {
        for (let i = 0; i < arg.length; i++) {
          const attr = arg[i];
          if (typeof attr === "object" && typeof attr.sort === "function" && attr[1] !== undefined && attr[1] !== null) {
            node.setAttribute(attr[0], attr[1]);
          }
        }
      } else if (typeof arg === "object") {
        for (const k in arg) {
          if (Object.prototype.hasOwnProperty.call(arg, k) && arg[k] !== undefined && arg[k] !== null) {
            node.setAttribute(k, arg[k]);
          }
        }
      }
    }
    return node;
  },
  /*  Function: xmlescape
   *  Excapes invalid xml characters.
   *
   *  Parameters:
   *     (String) text - text to escape.
   *
   *  Returns:
   *      Escaped text.
   */
  xmlescape(text) {
    text = text.replace(/\&/g, "&amp;");
    text = text.replace(/</g, "&lt;");
    text = text.replace(/>/g, "&gt;");
    text = text.replace(/'/g, "&apos;");
    text = text.replace(/"/g, "&quot;");
    return text;
  },
  /*  Function: xmlunescape
  *  Unexcapes invalid xml characters.
  *
  *  Parameters:
  *     (String) text - text to unescape.
  *
  *  Returns:
  *      Unescaped text.
  */
  xmlunescape(text) {
    text = text.replace(/\&amp;/g, "&");
    text = text.replace(/&lt;/g, "<");
    text = text.replace(/&gt;/g, ">");
    text = text.replace(/&apos;/g, "'");
    text = text.replace(/&quot;/g, "\"");
    return text;
  },
  /** Function: xmlTextNode
   *  Creates an XML DOM text node.
   *
   *  Provides a cross implementation version of document.createTextNode.
   *
   *  Parameters:
   *    (String) text - The content of the text node.
   *
   *  Returns:
   *    A new XML DOM text node.
   */
  xmlTextNode(text) {
    return Strophe.xmlGenerator().createTextNode(text);
  },
  /** Function: xmlHtmlNode
   *  Creates an XML DOM html node.
   *
   *  Parameters:
   *    (String) html - The content of the html node.
   *
   *  Returns:
   *    A new XML DOM text node.
   */
  xmlHtmlNode(html) {
    let node;
    //ensure text is escaped
    if (_shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser) {
      const parser = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser();
      node = parser.parseFromString(html, "text/xml");
    } else {
      node = new ActiveXObject("Microsoft.XMLDOM");
      node.async = "false";
      node.loadXML(html);
    }
    return node;
  },
  /** Function: getText
   *  Get the concatenation of all text children of an element.
   *
   *  Parameters:
   *    (XMLElement) elem - A DOM element.
   *
   *  Returns:
   *    A String with the concatenated text of all text element children.
   */
  getText(elem) {
    if (!elem) {
      return null;
    }
    let str = "";
    if (elem.childNodes.length === 0 && elem.nodeType === Strophe.ElementType.TEXT) {
      str += elem.nodeValue;
    }
    for (let i = 0; i < elem.childNodes.length; i++) {
      if (elem.childNodes[i].nodeType === Strophe.ElementType.TEXT) {
        str += elem.childNodes[i].nodeValue;
      }
    }
    return Strophe.xmlescape(str);
  },
  /** Function: copyElement
   *  Copy an XML DOM element.
   *
   *  This function copies a DOM element and all its descendants and returns
   *  the new copy.
   *
   *  Parameters:
   *    (XMLElement) elem - A DOM element.
   *
   *  Returns:
   *    A new, copied DOM element tree.
   */
  copyElement(elem) {
    let el;
    if (elem.nodeType === Strophe.ElementType.NORMAL) {
      el = Strophe.xmlElement(elem.tagName);
      for (let i = 0; i < elem.attributes.length; i++) {
        el.setAttribute(elem.attributes[i].nodeName, elem.attributes[i].value);
      }
      for (let i = 0; i < elem.childNodes.length; i++) {
        el.appendChild(Strophe.copyElement(elem.childNodes[i]));
      }
    } else if (elem.nodeType === Strophe.ElementType.TEXT) {
      el = Strophe.xmlGenerator().createTextNode(elem.nodeValue);
    }
    return el;
  },
  /** Function: createHtml
   *  Copy an HTML DOM element into an XML DOM.
   *
   *  This function copies a DOM element and all its descendants and returns
   *  the new copy.
   *
   *  Parameters:
   *    (HTMLElement) elem - A DOM element.
   *
   *  Returns:
   *    A new, copied DOM element tree.
   */
  createHtml(elem) {
    let el;
    if (elem.nodeType === Strophe.ElementType.NORMAL) {
      const tag = elem.nodeName.toLowerCase(); // XHTML tags must be lower case.
      if (Strophe.XHTML.validTag(tag)) {
        try {
          el = Strophe.xmlElement(tag);
          for (let i = 0; i < Strophe.XHTML.attributes[tag].length; i++) {
            const attribute = Strophe.XHTML.attributes[tag][i];
            let value = elem.getAttribute(attribute);
            if (typeof value === 'undefined' || value === null || value === '' || value === false || value === 0) {
              continue;
            }
            if (attribute === 'style' && typeof value === 'object' && typeof value.cssText !== 'undefined') {
              value = value.cssText; // we're dealing with IE, need to get CSS out
            }
            // filter out invalid css styles
            if (attribute === 'style') {
              const css = [];
              const cssAttrs = value.split(';');
              for (let j = 0; j < cssAttrs.length; j++) {
                const attr = cssAttrs[j].split(':');
                const cssName = attr[0].replace(/^\s*/, "").replace(/\s*$/, "").toLowerCase();
                if (Strophe.XHTML.validCSS(cssName)) {
                  const cssValue = attr[1].replace(/^\s*/, "").replace(/\s*$/, "");
                  css.push(cssName + ': ' + cssValue);
                }
              }
              if (css.length > 0) {
                value = css.join('; ');
                el.setAttribute(attribute, value);
              }
            } else {
              el.setAttribute(attribute, value);
            }
          }
          for (let i = 0; i < elem.childNodes.length; i++) {
            el.appendChild(Strophe.createHtml(elem.childNodes[i]));
          }
        } catch (e) {
          // invalid elements
          el = Strophe.xmlTextNode('');
        }
      } else {
        el = Strophe.xmlGenerator().createDocumentFragment();
        for (let i = 0; i < elem.childNodes.length; i++) {
          el.appendChild(Strophe.createHtml(elem.childNodes[i]));
        }
      }
    } else if (elem.nodeType === Strophe.ElementType.FRAGMENT) {
      el = Strophe.xmlGenerator().createDocumentFragment();
      for (let i = 0; i < elem.childNodes.length; i++) {
        el.appendChild(Strophe.createHtml(elem.childNodes[i]));
      }
    } else if (elem.nodeType === Strophe.ElementType.TEXT) {
      el = Strophe.xmlTextNode(elem.nodeValue);
    }
    return el;
  },
  /** Function: escapeNode
   *  Escape the node part (also called local part) of a JID.
   *
   *  Parameters:
   *    (String) node - A node (or local part).
   *
   *  Returns:
   *    An escaped node (or local part).
   */
  escapeNode(node) {
    if (typeof node !== "string") {
      return node;
    }
    return node.replace(/^\s+|\s+$/g, '').replace(/\\/g, "\\5c").replace(/ /g, "\\20").replace(/\"/g, "\\22").replace(/\&/g, "\\26").replace(/\'/g, "\\27").replace(/\//g, "\\2f").replace(/:/g, "\\3a").replace(/</g, "\\3c").replace(/>/g, "\\3e").replace(/@/g, "\\40");
  },
  /** Function: unescapeNode
   *  Unescape a node part (also called local part) of a JID.
   *
   *  Parameters:
   *    (String) node - A node (or local part).
   *
   *  Returns:
   *    An unescaped node (or local part).
   */
  unescapeNode(node) {
    if (typeof node !== "string") {
      return node;
    }
    return node.replace(/\\20/g, " ").replace(/\\22/g, '"').replace(/\\26/g, "&").replace(/\\27/g, "'").replace(/\\2f/g, "/").replace(/\\3a/g, ":").replace(/\\3c/g, "<").replace(/\\3e/g, ">").replace(/\\40/g, "@").replace(/\\5c/g, "\\");
  },
  /** Function: getNodeFromJid
   *  Get the node portion of a JID String.
   *
   *  Parameters:
   *    (String) jid - A JID.
   *
   *  Returns:
   *    A String containing the node.
   */
  getNodeFromJid(jid) {
    if (jid.indexOf("@") < 0) {
      return null;
    }
    return jid.split("@")[0];
  },
  /** Function: getDomainFromJid
   *  Get the domain portion of a JID String.
   *
   *  Parameters:
   *    (String) jid - A JID.
   *
   *  Returns:
   *    A String containing the domain.
   */
  getDomainFromJid(jid) {
    const bare = Strophe.getBareJidFromJid(jid);
    if (bare.indexOf("@") < 0) {
      return bare;
    } else {
      const parts = bare.split("@");
      parts.splice(0, 1);
      return parts.join('@');
    }
  },
  /** Function: getResourceFromJid
   *  Get the resource portion of a JID String.
   *
   *  Parameters:
   *    (String) jid - A JID.
   *
   *  Returns:
   *    A String containing the resource.
   */
  getResourceFromJid(jid) {
    if (!jid) {
      return null;
    }
    const s = jid.split("/");
    if (s.length < 2) {
      return null;
    }
    s.splice(0, 1);
    return s.join('/');
  },
  /** Function: getBareJidFromJid
   *  Get the bare JID from a JID String.
   *
   *  Parameters:
   *    (String) jid - A JID.
   *
   *  Returns:
   *    A String containing the bare JID.
   */
  getBareJidFromJid(jid) {
    return jid ? jid.split("/")[0] : null;
  },
  /** PrivateFunction: _handleError
   *  _Private_ function that properly logs an error to the console
   */
  _handleError(e) {
    if (typeof e.stack !== "undefined") {
      Strophe.fatal(e.stack);
    }
    if (e.sourceURL) {
      Strophe.fatal("error: " + this.handler + " " + e.sourceURL + ":" + e.line + " - " + e.name + ": " + e.message);
    } else if (e.fileName) {
      Strophe.fatal("error: " + this.handler + " " + e.fileName + ":" + e.lineNumber + " - " + e.name + ": " + e.message);
    } else {
      Strophe.fatal("error: " + e.message);
    }
  },
  /** Function: log
   *  User overrideable logging function.
   *
   *  This function is called whenever the Strophe library calls any
   *  of the logging functions.  The default implementation of this
   *  function logs only fatal errors.  If client code wishes to handle the logging
   *  messages, it should override this with
   *  > Strophe.log = function (level, msg) {
   *  >   (user code here)
   *  > };
   *
   *  Please note that data sent and received over the wire is logged
   *  via Strophe.Connection.rawInput() and Strophe.Connection.rawOutput().
   *
   *  The different levels and their meanings are
   *
   *    DEBUG - Messages useful for debugging purposes.
   *    INFO - Informational messages.  This is mostly information like
   *      'disconnect was called' or 'SASL auth succeeded'.
   *    WARN - Warnings about potential problems.  This is mostly used
   *      to report transient connection errors like request timeouts.
   *    ERROR - Some error occurred.
   *    FATAL - A non-recoverable fatal error occurred.
   *
   *  Parameters:
   *    (Integer) level - The log level of the log message.  This will
   *      be one of the values in Strophe.LogLevel.
   *    (String) msg - The log message.
   */
  log(level, msg) {
    if (level === this.LogLevel.FATAL) {
      var _console;
      (_console = console) === null || _console === void 0 ? void 0 : _console.error(msg);
    }
  },
  /** Function: debug
   *  Log a message at the Strophe.LogLevel.DEBUG level.
   *
   *  Parameters:
   *    (String) msg - The log message.
   */
  debug(msg) {
    this.log(this.LogLevel.DEBUG, msg);
  },
  /** Function: info
   *  Log a message at the Strophe.LogLevel.INFO level.
   *
   *  Parameters:
   *    (String) msg - The log message.
   */
  info(msg) {
    this.log(this.LogLevel.INFO, msg);
  },
  /** Function: warn
   *  Log a message at the Strophe.LogLevel.WARN level.
   *
   *  Parameters:
   *    (String) msg - The log message.
   */
  warn(msg) {
    this.log(this.LogLevel.WARN, msg);
  },
  /** Function: error
   *  Log a message at the Strophe.LogLevel.ERROR level.
   *
   *  Parameters:
   *    (String) msg - The log message.
   */
  error(msg) {
    this.log(this.LogLevel.ERROR, msg);
  },
  /** Function: fatal
   *  Log a message at the Strophe.LogLevel.FATAL level.
   *
   *  Parameters:
   *    (String) msg - The log message.
   */
  fatal(msg) {
    this.log(this.LogLevel.FATAL, msg);
  },
  /** Function: serialize
   *  Render a DOM element and all descendants to a String.
   *
   *  Parameters:
   *    (XMLElement) elem - A DOM element.
   *
   *  Returns:
   *    The serialized element tree as a String.
   */
  serialize(elem) {
    if (!elem) {
      return null;
    }
    if (typeof elem.tree === "function") {
      elem = elem.tree();
    }
    const names = [...Array(elem.attributes.length).keys()].map(i => elem.attributes[i].nodeName);
    names.sort();
    let result = names.reduce((a, n) => `${a} ${n}="${Strophe.xmlescape(elem.attributes.getNamedItem(n).value)}"`, `<${elem.nodeName}`);
    if (elem.childNodes.length > 0) {
      result += ">";
      for (let i = 0; i < elem.childNodes.length; i++) {
        const child = elem.childNodes[i];
        switch (child.nodeType) {
          case Strophe.ElementType.NORMAL:
            // normal element, so recurse
            result += Strophe.serialize(child);
            break;
          case Strophe.ElementType.TEXT:
            // text element to escape values
            result += Strophe.xmlescape(child.nodeValue);
            break;
          case Strophe.ElementType.CDATA:
            // cdata section so don't escape values
            result += "<![CDATA[" + child.nodeValue + "]]>";
        }
      }
      result += "</" + elem.nodeName + ">";
    } else {
      result += "/>";
    }
    return result;
  },
  /** PrivateVariable: _requestId
   *  _Private_ variable that keeps track of the request ids for
   *  connections.
   */
  _requestId: 0,
  /** PrivateVariable: Strophe.connectionPlugins
   *  _Private_ variable Used to store plugin names that need
   *  initialization on Strophe.Connection construction.
   */
  _connectionPlugins: {},
  /** Function: addConnectionPlugin
   *  Extends the Strophe.Connection object with the given plugin.
   *
   *  Parameters:
   *    (String) name - The name of the extension.
   *    (Object) ptype - The plugin's prototype.
   */
  addConnectionPlugin(name, ptype) {
    Strophe._connectionPlugins[name] = ptype;
  }
};

/** Class: Strophe.Builder
 *  XML DOM builder.
 *
 *  This object provides an interface similar to JQuery but for building
 *  DOM elements easily and rapidly.  All the functions except for toString()
 *  and tree() return the object, so calls can be chained.  Here's an
 *  example using the $iq() builder helper.
 *  > $iq({to: 'you', from: 'me', type: 'get', id: '1'})
 *  >     .c('query', {xmlns: 'strophe:example'})
 *  >     .c('example')
 *  >     .toString()
 *
 *  The above generates this XML fragment
 *  > <iq to='you' from='me' type='get' id='1'>
 *  >   <query xmlns='strophe:example'>
 *  >     <example/>
 *  >   </query>
 *  > </iq>
 *  The corresponding DOM manipulations to get a similar fragment would be
 *  a lot more tedious and probably involve several helper variables.
 *
 *  Since adding children makes new operations operate on the child, up()
 *  is provided to traverse up the tree.  To add two children, do
 *  > builder.c('child1', ...).up().c('child2', ...)
 *  The next operation on the Builder will be relative to the second child.
 */

/** Constructor: Strophe.Builder
 *  Create a Strophe.Builder object.
 *
 *  The attributes should be passed in object notation.  For example
 *  > let b = new Builder('message', {to: 'you', from: 'me'});
 *  or
 *  > let b = new Builder('messsage', {'xml:lang': 'en'});
 *
 *  Parameters:
 *    (String) name - The name of the root element.
 *    (Object) attrs - The attributes for the root element in object notation.
 *
 *  Returns:
 *    A new Strophe.Builder.
 */

Strophe.Builder = class Builder {
  constructor(name, attrs) {
    // Set correct namespace for jabber:client elements
    if (name === "presence" || name === "message" || name === "iq") {
      if (attrs && !attrs.xmlns) {
        attrs.xmlns = Strophe.NS.CLIENT;
      } else if (!attrs) {
        attrs = {
          xmlns: Strophe.NS.CLIENT
        };
      }
    }
    // Holds the tree being built.
    this.nodeTree = Strophe.xmlElement(name, attrs);
    // Points to the current operation node.
    this.node = this.nodeTree;
  }

  /** Function: tree
   *  Return the DOM tree.
   *
   *  This function returns the current DOM tree as an element object.  This
   *  is suitable for passing to functions like Strophe.Connection.send().
   *
   *  Returns:
   *    The DOM tree as a element object.
   */
  tree() {
    return this.nodeTree;
  }

  /** Function: toString
   *  Serialize the DOM tree to a String.
   *
   *  This function returns a string serialization of the current DOM
   *  tree.  It is often used internally to pass data to a
   *  Strophe.Request object.
   *
   *  Returns:
   *    The serialized DOM tree in a String.
   */
  toString() {
    return Strophe.serialize(this.nodeTree);
  }

  /** Function: up
   *  Make the current parent element the new current element.
   *
   *  This function is often used after c() to traverse back up the tree.
   *  For example, to add two children to the same element
   *  > builder.c('child1', {}).up().c('child2', {});
   *
   *  Returns:
   *    The Stophe.Builder object.
   */
  up() {
    this.node = this.node.parentNode;
    return this;
  }

  /** Function: root
   *  Make the root element the new current element.
   *
   *  When at a deeply nested element in the tree, this function can be used
   *  to jump back to the root of the tree, instead of having to repeatedly
   *  call up().
   *
   *  Returns:
   *    The Stophe.Builder object.
   */
  root() {
    this.node = this.nodeTree;
    return this;
  }

  /** Function: attrs
   *  Add or modify attributes of the current element.
   *
   *  The attributes should be passed in object notation.  This function
   *  does not move the current element pointer.
   *
   *  Parameters:
   *    (Object) moreattrs - The attributes to add/modify in object notation.
   *
   *  Returns:
   *    The Strophe.Builder object.
   */
  attrs(moreattrs) {
    for (const k in moreattrs) {
      if (Object.prototype.hasOwnProperty.call(moreattrs, k)) {
        if (moreattrs[k] === undefined) {
          this.node.removeAttribute(k);
        } else {
          this.node.setAttribute(k, moreattrs[k]);
        }
      }
    }
    return this;
  }

  /** Function: c
   *  Add a child to the current element and make it the new current
   *  element.
   *
   *  This function moves the current element pointer to the child,
   *  unless text is provided.  If you need to add another child, it
   *  is necessary to use up() to go back to the parent in the tree.
   *
   *  Parameters:
   *    (String) name - The name of the child.
   *    (Object) attrs - The attributes of the child in object notation.
   *    (String) text - The text to add to the child.
   *
   *  Returns:
   *    The Strophe.Builder object.
   */
  c(name, attrs, text) {
    const child = Strophe.xmlElement(name, attrs, text);
    this.node.appendChild(child);
    if (typeof text !== "string" && typeof text !== "number") {
      this.node = child;
    }
    return this;
  }

  /** Function: cnode
   *  Add a child to the current element and make it the new current
   *  element.
   *
   *  This function is the same as c() except that instead of using a
   *  name and an attributes object to create the child it uses an
   *  existing DOM element object.
   *
   *  Parameters:
   *    (XMLElement) elem - A DOM element.
   *
   *  Returns:
   *    The Strophe.Builder object.
   */
  cnode(elem) {
    let impNode;
    const xmlGen = Strophe.xmlGenerator();
    try {
      impNode = xmlGen.importNode !== undefined;
    } catch (e) {
      impNode = false;
    }
    const newElem = impNode ? xmlGen.importNode(elem, true) : Strophe.copyElement(elem);
    this.node.appendChild(newElem);
    this.node = newElem;
    return this;
  }

  /** Function: t
   *  Add a child text element.
   *
   *  This *does not* make the child the new current element since there
   *  are no children of text elements.
   *
   *  Parameters:
   *    (String) text - The text data to append to the current element.
   *
   *  Returns:
   *    The Strophe.Builder object.
   */
  t(text) {
    const child = Strophe.xmlTextNode(text);
    this.node.appendChild(child);
    return this;
  }

  /** Function: h
   *  Replace current element contents with the HTML passed in.
   *
   *  This *does not* make the child the new current element
   *
   *  Parameters:
   *    (String) html - The html to insert as contents of current element.
   *
   *  Returns:
   *    The Strophe.Builder object.
   */
  h(html) {
    const fragment = Strophe.xmlGenerator().createElement('body');
    // force the browser to try and fix any invalid HTML tags
    fragment.innerHTML = html;
    // copy cleaned html into an xml dom
    const xhtml = Strophe.createHtml(fragment);
    while (xhtml.childNodes.length > 0) {
      this.node.appendChild(xhtml.childNodes[0]);
    }
    return this;
  }
};

/** PrivateClass: Strophe.Handler
 *  _Private_ helper class for managing stanza handlers.
 *
 *  A Strophe.Handler encapsulates a user provided callback function to be
 *  executed when matching stanzas are received by the connection.
 *  Handlers can be either one-off or persistant depending on their
 *  return value. Returning true will cause a Handler to remain active, and
 *  returning false will remove the Handler.
 *
 *  Users will not use Strophe.Handler objects directly, but instead they
 *  will use Strophe.Connection.addHandler() and
 *  Strophe.Connection.deleteHandler().
 */

/** PrivateConstructor: Strophe.Handler
 *  Create and initialize a new Strophe.Handler.
 *
 *  Parameters:
 *    (Function) handler - A function to be executed when the handler is run.
 *    (String) ns - The namespace to match.
 *    (String) name - The element name to match.
 *    (String) type - The element type to match.
 *    (String) id - The element id attribute to match.
 *    (String) from - The element from attribute to match.
 *    (Object) options - Handler options
 *
 *  Returns:
 *    A new Strophe.Handler object.
 */
Strophe.Handler = function (handler, ns, name, type, id, from, options) {
  this.handler = handler;
  this.ns = ns;
  this.name = name;
  this.type = type;
  this.id = id;
  this.options = options || {
    'matchBareFromJid': false,
    'ignoreNamespaceFragment': false
  };
  // BBB: Maintain backward compatibility with old `matchBare` option
  if (this.options.matchBare) {
    Strophe.warn('The "matchBare" option is deprecated, use "matchBareFromJid" instead.');
    this.options.matchBareFromJid = this.options.matchBare;
    delete this.options.matchBare;
  }
  if (this.options.matchBareFromJid) {
    this.from = from ? Strophe.getBareJidFromJid(from) : null;
  } else {
    this.from = from;
  }
  // whether the handler is a user handler or a system handler
  this.user = true;
};
Strophe.Handler.prototype = {
  /** PrivateFunction: getNamespace
   *  Returns the XML namespace attribute on an element.
   *  If `ignoreNamespaceFragment` was passed in for this handler, then the
   *  URL fragment will be stripped.
   *
   *  Parameters:
   *    (XMLElement) elem - The XML element with the namespace.
   *
   *  Returns:
   *    The namespace, with optionally the fragment stripped.
   */
  getNamespace(elem) {
    let elNamespace = elem.getAttribute("xmlns");
    if (elNamespace && this.options.ignoreNamespaceFragment) {
      elNamespace = elNamespace.split('#')[0];
    }
    return elNamespace;
  },
  /** PrivateFunction: namespaceMatch
   *  Tests if a stanza matches the namespace set for this Strophe.Handler.
   *
   *  Parameters:
   *    (XMLElement) elem - The XML element to test.
   *
   *  Returns:
   *    true if the stanza matches and false otherwise.
   */
  namespaceMatch(elem) {
    let nsMatch = false;
    if (!this.ns) {
      return true;
    } else {
      Strophe.forEachChild(elem, null, elem => {
        if (this.getNamespace(elem) === this.ns) {
          nsMatch = true;
        }
      });
      return nsMatch || this.getNamespace(elem) === this.ns;
    }
  },
  /** PrivateFunction: isMatch
   *  Tests if a stanza matches the Strophe.Handler.
   *
   *  Parameters:
   *    (XMLElement) elem - The XML element to test.
   *
   *  Returns:
   *    true if the stanza matches and false otherwise.
   */
  isMatch(elem) {
    let from = elem.getAttribute('from');
    if (this.options.matchBareFromJid) {
      from = Strophe.getBareJidFromJid(from);
    }
    const elem_type = elem.getAttribute("type");
    if (this.namespaceMatch(elem) && (!this.name || Strophe.isTagEqual(elem, this.name)) && (!this.type || (Array.isArray(this.type) ? this.type.indexOf(elem_type) !== -1 : elem_type === this.type)) && (!this.id || elem.getAttribute("id") === this.id) && (!this.from || from === this.from)) {
      return true;
    }
    return false;
  },
  /** PrivateFunction: run
   *  Run the callback on a matching stanza.
   *
   *  Parameters:
   *    (XMLElement) elem - The DOM element that triggered the
   *      Strophe.Handler.
   *
   *  Returns:
   *    A boolean indicating if the handler should remain active.
   */
  run(elem) {
    let result = null;
    try {
      result = this.handler(elem);
    } catch (e) {
      Strophe._handleError(e);
      throw e;
    }
    return result;
  },
  /** PrivateFunction: toString
   *  Get a String representation of the Strophe.Handler object.
   *
   *  Returns:
   *    A String.
   */
  toString() {
    return "{Handler: " + this.handler + "(" + this.name + "," + this.id + "," + this.ns + ")}";
  }
};

/** PrivateClass: Strophe.TimedHandler
 *  _Private_ helper class for managing timed handlers.
 *
 *  A Strophe.TimedHandler encapsulates a user provided callback that
 *  should be called after a certain period of time or at regular
 *  intervals.  The return value of the callback determines whether the
 *  Strophe.TimedHandler will continue to fire.
 *
 *  Users will not use Strophe.TimedHandler objects directly, but instead
 *  they will use Strophe.Connection.addTimedHandler() and
 *  Strophe.Connection.deleteTimedHandler().
 */
Strophe.TimedHandler = class TimedHandler {
  /** PrivateConstructor: Strophe.TimedHandler
   *  Create and initialize a new Strophe.TimedHandler object.
   *
   *  Parameters:
   *    (Integer) period - The number of milliseconds to wait before the
   *      handler is called.
   *    (Function) handler - The callback to run when the handler fires.  This
   *      function should take no arguments.
   *
   *  Returns:
   *    A new Strophe.TimedHandler object.
   */
  constructor(period, handler) {
    this.period = period;
    this.handler = handler;
    this.lastCalled = new Date().getTime();
    this.user = true;
  }

  /** PrivateFunction: run
   *  Run the callback for the Strophe.TimedHandler.
   *
   *  Returns:
   *    true if the Strophe.TimedHandler should be called again, and false
   *      otherwise.
   */
  run() {
    this.lastCalled = new Date().getTime();
    return this.handler();
  }

  /** PrivateFunction: reset
   *  Reset the last called time for the Strophe.TimedHandler.
   */
  reset() {
    this.lastCalled = new Date().getTime();
  }

  /** PrivateFunction: toString
   *  Get a string representation of the Strophe.TimedHandler object.
   *
   *  Returns:
   *    The string representation.
   */
  toString() {
    return "{TimedHandler: " + this.handler + "(" + this.period + ")}";
  }
};

/** Class: Strophe.Connection
 *  XMPP Connection manager.
 *
 *  This class is the main part of Strophe.  It manages a BOSH or websocket
 *  connection to an XMPP server and dispatches events to the user callbacks
 *  as data arrives. It supports SASL PLAIN, SASL SCRAM-SHA-1
 *  and legacy authentication.
 *
 *  After creating a Strophe.Connection object, the user will typically
 *  call connect() with a user supplied callback to handle connection level
 *  events like authentication failure, disconnection, or connection
 *  complete.
 *
 *  The user will also have several event handlers defined by using
 *  addHandler() and addTimedHandler().  These will allow the user code to
 *  respond to interesting stanzas or do something periodically with the
 *  connection. These handlers will be active once authentication is
 *  finished.
 *
 *  To send data to the connection, use send().
 */

/** Constructor: Strophe.Connection
 *  Create and initialize a Strophe.Connection object.
 *
 *  The transport-protocol for this connection will be chosen automatically
 *  based on the given service parameter. URLs starting with "ws://" or
 *  "wss://" will use WebSockets, URLs starting with "http://", "https://"
 *  or without a protocol will use BOSH.
 *
 *  To make Strophe connect to the current host you can leave out the protocol
 *  and host part and just pass the path, e.g.
 *
 *  > let conn = new Strophe.Connection("/http-bind/");
 *
 *  Options common to both Websocket and BOSH:
 *  ------------------------------------------
 *
 *  cookies:
 *
 *  The *cookies* option allows you to pass in cookies to be added to the
 *  document. These cookies will then be included in the BOSH XMLHttpRequest
 *  or in the websocket connection.
 *
 *  The passed in value must be a map of cookie names and string values.
 *
 *  > { "myCookie": {
 *  >     "value": "1234",
 *  >     "domain": ".example.org",
 *  >     "path": "/",
 *  >     "expires": expirationDate
 *  >     }
 *  > }
 *
 *  Note that cookies can't be set in this way for other domains (i.e. cross-domain).
 *  Those cookies need to be set under those domains, for example they can be
 *  set server-side by making a XHR call to that domain to ask it to set any
 *  necessary cookies.
 *
 *  mechanisms:
 *
 *  The *mechanisms* option allows you to specify the SASL mechanisms that this
 *  instance of Strophe.Connection (and therefore your XMPP client) will
 *  support.
 *
 *  The value must be an array of objects with Strophe.SASLMechanism
 *  prototypes.
 *
 *  If nothing is specified, then the following mechanisms (and their
 *  priorities) are registered:
 *
 *      SCRAM-SHA-512 - 72
 *      SCRAM-SHA-384 - 71
 *      SCRAM-SHA-256 - 70
 *      SCRAM-SHA-1   - 60
 *      PLAIN         - 50
 *      OAUTHBEARER   - 40
 *      X-OAUTH2      - 30
 *      ANONYMOUS     - 20
 *      EXTERNAL      - 10
 *
 *  explicitResourceBinding:
 *
 *  If `explicitResourceBinding` is set to a truthy value, then the XMPP client
 *  needs to explicitly call `Strophe.Connection.prototype.bind` once the XMPP
 *  server has advertised the "urn:ietf:params:xml:ns:xmpp-bind" feature.
 *
 *  Making this step explicit allows client authors to first finish other
 *  stream related tasks, such as setting up an XEP-0198 Stream Management
 *  session, before binding the JID resource for this session.
 *
 *  WebSocket options:
 *  ------------------
 *
 *  protocol:
 *
 *  If you want to connect to the current host with a WebSocket connection you
 *  can tell Strophe to use WebSockets through a "protocol" attribute in the
 *  optional options parameter. Valid values are "ws" for WebSocket and "wss"
 *  for Secure WebSocket.
 *  So to connect to "wss://CURRENT_HOSTNAME/xmpp-websocket" you would call
 *
 *  > let conn = new Strophe.Connection("/xmpp-websocket/", {protocol: "wss"});
 *
 *  Note that relative URLs _NOT_ starting with a "/" will also include the path
 *  of the current site.
 *
 *  Also because downgrading security is not permitted by browsers, when using
 *  relative URLs both BOSH and WebSocket connections will use their secure
 *  variants if the current connection to the site is also secure (https).
 *
 *  worker:
 *
 *  Set this option to URL from where the shared worker script should be loaded.
 *
 *  To run the websocket connection inside a shared worker.
 *  This allows you to share a single websocket-based connection between
 *  multiple Strophe.Connection instances, for example one per browser tab.
 *
 *  The script to use is the one in `src/shared-connection-worker.js`.
 *
 *  BOSH options:
 *  -------------
 *
 *  By adding "sync" to the options, you can control if requests will
 *  be made synchronously or not. The default behaviour is asynchronous.
 *  If you want to make requests synchronous, make "sync" evaluate to true.
 *  > let conn = new Strophe.Connection("/http-bind/", {sync: true});
 *
 *  You can also toggle this on an already established connection.
 *  > conn.options.sync = true;
 *
 *  The *customHeaders* option can be used to provide custom HTTP headers to be
 *  included in the XMLHttpRequests made.
 *
 *  The *keepalive* option can be used to instruct Strophe to maintain the
 *  current BOSH session across interruptions such as webpage reloads.
 *
 *  It will do this by caching the sessions tokens in sessionStorage, and when
 *  "restore" is called it will check whether there are cached tokens with
 *  which it can resume an existing session.
 *
 *  The *withCredentials* option should receive a Boolean value and is used to
 *  indicate wether cookies should be included in ajax requests (by default
 *  they're not).
 *  Set this value to true if you are connecting to a BOSH service
 *  and for some reason need to send cookies to it.
 *  In order for this to work cross-domain, the server must also enable
 *  credentials by setting the Access-Control-Allow-Credentials response header
 *  to "true". For most usecases however this setting should be false (which
 *  is the default).
 *  Additionally, when using Access-Control-Allow-Credentials, the
 *  Access-Control-Allow-Origin header can't be set to the wildcard "*", but
 *  instead must be restricted to actual domains.
 *
 *  The *contentType* option can be set to change the default Content-Type
 *  of "text/xml; charset=utf-8", which can be useful to reduce the amount of
 *  CORS preflight requests that are sent to the server.
 *
 *  Parameters:
 *    (String) service - The BOSH or WebSocket service URL.
 *    (Object) options - A hash of configuration options
 *
 *  Returns:
 *    A new Strophe.Connection object.
 */

Strophe.Connection = class Connection {
  constructor(service, options) {
    // The service URL
    this.service = service;
    // Configuration options
    this.options = options || {};
    this.setProtocol();

    /* The connected JID. */
    this.jid = "";
    /* the JIDs domain */
    this.domain = null;
    /* stream:features */
    this.features = null;

    // SASL
    this._sasl_data = {};
    this.do_bind = false;
    this.do_session = false;
    this.mechanisms = {};

    // handler lists
    this.timedHandlers = [];
    this.handlers = [];
    this.removeTimeds = [];
    this.removeHandlers = [];
    this.addTimeds = [];
    this.addHandlers = [];
    this.protocolErrorHandlers = {
      'HTTP': {},
      'websocket': {}
    };
    this._idleTimeout = null;
    this._disconnectTimeout = null;
    this.authenticated = false;
    this.connected = false;
    this.disconnecting = false;
    this.do_authentication = true;
    this.paused = false;
    this.restored = false;
    this._data = [];
    this._uniqueId = 0;
    this._sasl_success_handler = null;
    this._sasl_failure_handler = null;
    this._sasl_challenge_handler = null;

    // Max retries before disconnecting
    this.maxRetries = 5;

    // Call onIdle callback every 1/10th of a second
    this._idleTimeout = setTimeout(() => this._onIdle(), 100);
    _utils__WEBPACK_IMPORTED_MODULE_11__["default"].addCookies(this.options.cookies);
    this.registerSASLMechanisms(this.options.mechanisms);

    // A client must always respond to incoming IQ "set" and "get" stanzas.
    // See https://datatracker.ietf.org/doc/html/rfc6120#section-8.2.3
    //
    // This is a fallback handler which gets called when no other handler
    // was called for a received IQ "set" or "get".
    this.iqFallbackHandler = new Strophe.Handler(iq => this.send($iq({
      type: 'error',
      id: iq.getAttribute('id')
    }).c('error', {
      'type': 'cancel'
    }).c('service-unavailable', {
      'xmlns': Strophe.NS.STANZAS
    })), null, 'iq', ['get', 'set']);

    // initialize plugins
    for (const k in Strophe._connectionPlugins) {
      if (Object.prototype.hasOwnProperty.call(Strophe._connectionPlugins, k)) {
        const F = function () {};
        F.prototype = Strophe._connectionPlugins[k];
        this[k] = new F();
        this[k].init(this);
      }
    }
  }

  /** Function: setProtocol
   *  Select protocal based on this.options or this.service
   */
  setProtocol() {
    const proto = this.options.protocol || "";
    if (this.options.worker) {
      this._proto = new Strophe.WorkerWebsocket(this);
    } else if (this.service.indexOf("ws:") === 0 || this.service.indexOf("wss:") === 0 || proto.indexOf("ws") === 0) {
      this._proto = new Strophe.Websocket(this);
    } else {
      this._proto = new Strophe.Bosh(this);
    }
  }

  /** Function: reset
   *  Reset the connection.
   *
   *  This function should be called after a connection is disconnected
   *  before that connection is reused.
   */
  reset() {
    this._proto._reset();

    // SASL
    this.do_session = false;
    this.do_bind = false;

    // handler lists
    this.timedHandlers = [];
    this.handlers = [];
    this.removeTimeds = [];
    this.removeHandlers = [];
    this.addTimeds = [];
    this.addHandlers = [];
    this.authenticated = false;
    this.connected = false;
    this.disconnecting = false;
    this.restored = false;
    this._data = [];
    this._requests = [];
    this._uniqueId = 0;
  }

  /** Function: pause
   *  Pause the request manager.
   *
   *  This will prevent Strophe from sending any more requests to the
   *  server.  This is very useful for temporarily pausing
   *  BOSH-Connections while a lot of send() calls are happening quickly.
   *  This causes Strophe to send the data in a single request, saving
   *  many request trips.
   */
  pause() {
    this.paused = true;
  }

  /** Function: resume
   *  Resume the request manager.
   *
   *  This resumes after pause() has been called.
   */
  resume() {
    this.paused = false;
  }

  /** Function: getUniqueId
   *  Generate a unique ID for use in <iq/> elements.
   *
   *  All <iq/> stanzas are required to have unique id attributes.  This
   *  function makes creating these easy.  Each connection instance has
   *  a counter which starts from zero, and the value of this counter
   *  plus a colon followed by the suffix becomes the unique id. If no
   *  suffix is supplied, the counter is used as the unique id.
   *
   *  Suffixes are used to make debugging easier when reading the stream
   *  data, and their use is recommended.  The counter resets to 0 for
   *  every new connection for the same reason.  For connections to the
   *  same server that authenticate the same way, all the ids should be
   *  the same, which makes it easy to see changes.  This is useful for
   *  automated testing as well.
   *
   *  Parameters:
   *    (String) suffix - A optional suffix to append to the id.
   *
   *  Returns:
   *    A unique string to be used for the id attribute.
   */
  getUniqueId(suffix) {
    // eslint-disable-line class-methods-use-this
    const uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
      const r = Math.random() * 16 | 0,
        v = c === 'x' ? r : r & 0x3 | 0x8;
      return v.toString(16);
    });
    if (typeof suffix === "string" || typeof suffix === "number") {
      return uuid + ":" + suffix;
    } else {
      return uuid + "";
    }
  }

  /** Function: addProtocolErrorHandler
   *  Register a handler function for when a protocol (websocker or HTTP)
   *  error occurs.
   *
   *  NOTE: Currently only HTTP errors for BOSH requests are handled.
   *  Patches that handle websocket errors would be very welcome.
   *
   *  Parameters:
   *    (String) protocol - 'HTTP' or 'websocket'
   *    (Integer) status_code - Error status code (e.g 500, 400 or 404)
   *    (Function) callback - Function that will fire on Http error
   *
   *  Example:
   *  function onError(err_code){
   *    //do stuff
   *  }
   *
   *  let conn = Strophe.connect('http://example.com/http-bind');
   *  conn.addProtocolErrorHandler('HTTP', 500, onError);
   *  // Triggers HTTP 500 error and onError handler will be called
   *  conn.connect('user_jid@incorrect_jabber_host', 'secret', onConnect);
   */
  addProtocolErrorHandler(protocol, status_code, callback) {
    this.protocolErrorHandlers[protocol][status_code] = callback;
  }

  /** Function: connect
   *  Starts the connection process.
   *
   *  As the connection process proceeds, the user supplied callback will
   *  be triggered multiple times with status updates.  The callback
   *  should take two arguments - the status code and the error condition.
   *
   *  The status code will be one of the values in the Strophe.Status
   *  constants.  The error condition will be one of the conditions
   *  defined in RFC 3920 or the condition 'strophe-parsererror'.
   *
   *  The Parameters _wait_, _hold_ and _route_ are optional and only relevant
   *  for BOSH connections. Please see XEP 124 for a more detailed explanation
   *  of the optional parameters.
   *
   *  Parameters:
   *    (String) jid - The user's JID.  This may be a bare JID,
   *      or a full JID.  If a node is not supplied, SASL OAUTHBEARER or
   *      SASL ANONYMOUS authentication will be attempted (OAUTHBEARER will
   *      process the provided password value as an access token).
   *    (String or Object) pass - The user's password, or an object containing
   *      the users SCRAM client and server keys, in a fashion described as follows:
   *
   *      { name: String, representing the hash used (eg. SHA-1),
   *        salt: String, base64 encoded salt used to derive the client key,
   *        iter: Int,    the iteration count used to derive the client key,
   *        ck:   String, the base64 encoding of the SCRAM client key
   *        sk:   String, the base64 encoding of the SCRAM server key
   *      }
   *
   *    (Function) callback - The connect callback function.
   *    (Integer) wait - The optional HTTPBIND wait value.  This is the
   *      time the server will wait before returning an empty result for
   *      a request.  The default setting of 60 seconds is recommended.
   *    (Integer) hold - The optional HTTPBIND hold value.  This is the
   *      number of connections the server will hold at one time.  This
   *      should almost always be set to 1 (the default).
   *    (String) route - The optional route value.
   *    (String) authcid - The optional alternative authentication identity
   *      (username) if intending to impersonate another user.
   *      When using the SASL-EXTERNAL authentication mechanism, for example
   *      with client certificates, then the authcid value is used to
   *      determine whether an authorization JID (authzid) should be sent to
   *      the server. The authzid should NOT be sent to the server if the
   *      authzid and authcid are the same. So to prevent it from being sent
   *      (for example when the JID is already contained in the client
   *      certificate), set authcid to that same JID. See XEP-178 for more
   *      details.
   *     (Integer) disconnection_timeout - The optional disconnection timeout
   *      in milliseconds before _doDisconnect will be called.
   */
  connect(jid, pass, callback, wait, hold, route, authcid) {
    let disconnection_timeout = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 3000;
    this.jid = jid;
    /** Variable: authzid
     *  Authorization identity.
     */
    this.authzid = Strophe.getBareJidFromJid(this.jid);

    /** Variable: authcid
     *  Authentication identity (User name).
     */
    this.authcid = authcid || Strophe.getNodeFromJid(this.jid);

    /** Variable: pass
     *  Authentication identity (User password).
     *
     */
    this.pass = pass;

    /** Variable: scram_keys
     *  The SASL SCRAM client and server keys. This variable will be populated with a non-null
     *  object of the above described form after a successful SCRAM connection
     *
     */
    this.scram_keys = null;
    this.connect_callback = callback;
    this.disconnecting = false;
    this.connected = false;
    this.authenticated = false;
    this.restored = false;
    this.disconnection_timeout = disconnection_timeout;

    // parse jid for domain
    this.domain = Strophe.getDomainFromJid(this.jid);
    this._changeConnectStatus(Strophe.Status.CONNECTING, null);
    this._proto._connect(wait, hold, route);
  }

  /** Function: attach
   *  Attach to an already created and authenticated BOSH session.
   *
   *  This function is provided to allow Strophe to attach to BOSH
   *  sessions which have been created externally, perhaps by a Web
   *  application.  This is often used to support auto-login type features
   *  without putting user credentials into the page.
   *
   *  Parameters:
   *    (String) jid - The full JID that is bound by the session.
   *    (String) sid - The SID of the BOSH session.
   *    (String) rid - The current RID of the BOSH session.  This RID
   *      will be used by the next request.
   *    (Function) callback The connect callback function.
   *    (Integer) wait - The optional HTTPBIND wait value.  This is the
   *      time the server will wait before returning an empty result for
   *      a request.  The default setting of 60 seconds is recommended.
   *      Other settings will require tweaks to the Strophe.TIMEOUT value.
   *    (Integer) hold - The optional HTTPBIND hold value.  This is the
   *      number of connections the server will hold at one time.  This
   *      should almost always be set to 1 (the default).
   *    (Integer) wind - The optional HTTBIND window value.  This is the
   *      allowed range of request ids that are valid.  The default is 5.
   */
  attach(jid, sid, rid, callback, wait, hold, wind) {
    if (this._proto._attach) {
      return this._proto._attach(jid, sid, rid, callback, wait, hold, wind);
    } else {
      const error = new Error('The "attach" method is not available for your connection protocol');
      error.name = 'StropheSessionError';
      throw error;
    }
  }

  /** Function: restore
   *  Attempt to restore a cached BOSH session.
   *
   *  This function is only useful in conjunction with providing the
   *  "keepalive":true option when instantiating a new Strophe.Connection.
   *
   *  When "keepalive" is set to true, Strophe will cache the BOSH tokens
   *  RID (Request ID) and SID (Session ID) and then when this function is
   *  called, it will attempt to restore the session from those cached
   *  tokens.
   *
   *  This function must therefore be called instead of connect or attach.
   *
   *  For an example on how to use it, please see examples/restore.js
   *
   *  Parameters:
   *    (String) jid - The user's JID.  This may be a bare JID or a full JID.
   *    (Function) callback - The connect callback function.
   *    (Integer) wait - The optional HTTPBIND wait value.  This is the
   *      time the server will wait before returning an empty result for
   *      a request.  The default setting of 60 seconds is recommended.
   *    (Integer) hold - The optional HTTPBIND hold value.  This is the
   *      number of connections the server will hold at one time.  This
   *      should almost always be set to 1 (the default).
   *    (Integer) wind - The optional HTTBIND window value.  This is the
   *      allowed range of request ids that are valid.  The default is 5.
   */
  restore(jid, callback, wait, hold, wind) {
    if (this._sessionCachingSupported()) {
      this._proto._restore(jid, callback, wait, hold, wind);
    } else {
      const error = new Error('The "restore" method can only be used with a BOSH connection.');
      error.name = 'StropheSessionError';
      throw error;
    }
  }

  /** PrivateFunction: _sessionCachingSupported
   * Checks whether sessionStorage and JSON are supported and whether we're
   * using BOSH.
   */
  _sessionCachingSupported() {
    if (this._proto instanceof Strophe.Bosh) {
      if (!JSON) {
        return false;
      }
      try {
        sessionStorage.setItem('_strophe_', '_strophe_');
        sessionStorage.removeItem('_strophe_');
      } catch (e) {
        return false;
      }
      return true;
    }
    return false;
  }

  /** Function: xmlInput
   *  User overrideable function that receives XML data coming into the
   *  connection.
   *
   *  The default function does nothing.  User code can override this with
   *  > Strophe.Connection.xmlInput = function (elem) {
   *  >   (user code)
   *  > };
   *
   *  Due to limitations of current Browsers' XML-Parsers the opening and closing
   *  <stream> tag for WebSocket-Connoctions will be passed as selfclosing here.
   *
   *  BOSH-Connections will have all stanzas wrapped in a <body> tag. See
   *  <Strophe.Bosh.strip> if you want to strip this tag.
   *
   *  Parameters:
   *    (XMLElement) elem - The XML data received by the connection.
   */
  xmlInput(elem) {
    // eslint-disable-line
    return;
  }

  /** Function: xmlOutput
   *  User overrideable function that receives XML data sent to the
   *  connection.
   *
   *  The default function does nothing.  User code can override this with
   *  > Strophe.Connection.xmlOutput = function (elem) {
   *  >   (user code)
   *  > };
   *
   *  Due to limitations of current Browsers' XML-Parsers the opening and closing
   *  <stream> tag for WebSocket-Connoctions will be passed as selfclosing here.
   *
   *  BOSH-Connections will have all stanzas wrapped in a <body> tag. See
   *  <Strophe.Bosh.strip> if you want to strip this tag.
   *
   *  Parameters:
   *    (XMLElement) elem - The XMLdata sent by the connection.
   */
  xmlOutput(elem) {
    // eslint-disable-line
    return;
  }

  /** Function: rawInput
   *  User overrideable function that receives raw data coming into the
   *  connection.
   *
   *  The default function does nothing.  User code can override this with
   *  > Strophe.Connection.rawInput = function (data) {
   *  >   (user code)
   *  > };
   *
   *  Parameters:
   *    (String) data - The data received by the connection.
   */
  rawInput(data) {
    // eslint-disable-line
    return;
  }

  /** Function: rawOutput
   *  User overrideable function that receives raw data sent to the
   *  connection.
   *
   *  The default function does nothing.  User code can override this with
   *  > Strophe.Connection.rawOutput = function (data) {
   *  >   (user code)
   *  > };
   *
   *  Parameters:
   *    (String) data - The data sent by the connection.
   */
  rawOutput(data) {
    // eslint-disable-line
    return;
  }

  /** Function: nextValidRid
   *  User overrideable function that receives the new valid rid.
   *
   *  The default function does nothing. User code can override this with
   *  > Strophe.Connection.nextValidRid = function (rid) {
   *  >    (user code)
   *  > };
   *
   *  Parameters:
   *    (Number) rid - The next valid rid
   */
  nextValidRid(rid) {
    // eslint-disable-line
    return;
  }

  /** Function: send
   *  Send a stanza.
   *
   *  This function is called to push data onto the send queue to
   *  go out over the wire.  Whenever a request is sent to the BOSH
   *  server, all pending data is sent and the queue is flushed.
   *
   *  Parameters:
   *    (XMLElement |
   *     [XMLElement] |
   *     Strophe.Builder) elem - The stanza to send.
   */
  send(elem) {
    if (elem === null) {
      return;
    }
    if (typeof elem.sort === "function") {
      for (let i = 0; i < elem.length; i++) {
        this._queueData(elem[i]);
      }
    } else if (typeof elem.tree === "function") {
      this._queueData(elem.tree());
    } else {
      this._queueData(elem);
    }
    this._proto._send();
  }

  /** Function: flush
   *  Immediately send any pending outgoing data.
   *
   *  Normally send() queues outgoing data until the next idle period
   *  (100ms), which optimizes network use in the common cases when
   *  several send()s are called in succession. flush() can be used to
   *  immediately send all pending data.
   */
  flush() {
    // cancel the pending idle period and run the idle function
    // immediately
    clearTimeout(this._idleTimeout);
    this._onIdle();
  }

  /** Function: sendPresence
   *  Helper function to send presence stanzas. The main benefit is for
   *  sending presence stanzas for which you expect a responding presence
   *  stanza with the same id (for example when leaving a chat room).
   *
   *  Parameters:
   *    (XMLElement) elem - The stanza to send.
   *    (Function) callback - The callback function for a successful request.
   *    (Function) errback - The callback function for a failed or timed
   *      out request.  On timeout, the stanza will be null.
   *    (Integer) timeout - The time specified in milliseconds for a
   *      timeout to occur.
   *
   *  Returns:
   *    The id used to send the presence.
   */
  sendPresence(elem, callback, errback, timeout) {
    let timeoutHandler = null;
    if (typeof elem.tree === "function") {
      elem = elem.tree();
    }
    let id = elem.getAttribute('id');
    if (!id) {
      // inject id if not found
      id = this.getUniqueId("sendPresence");
      elem.setAttribute("id", id);
    }
    if (typeof callback === "function" || typeof errback === "function") {
      const handler = this.addHandler(stanza => {
        // remove timeout handler if there is one
        if (timeoutHandler) {
          this.deleteTimedHandler(timeoutHandler);
        }
        if (stanza.getAttribute('type') === 'error') {
          if (errback) {
            errback(stanza);
          }
        } else if (callback) {
          callback(stanza);
        }
      }, null, 'presence', null, id);

      // if timeout specified, set up a timeout handler.
      if (timeout) {
        timeoutHandler = this.addTimedHandler(timeout, () => {
          // get rid of normal handler
          this.deleteHandler(handler);
          // call errback on timeout with null stanza
          if (errback) {
            errback(null);
          }
          return false;
        });
      }
    }
    this.send(elem);
    return id;
  }

  /** Function: sendIQ
   *  Helper function to send IQ stanzas.
   *
   *  Parameters:
   *    (XMLElement) elem - The stanza to send.
   *    (Function) callback - The callback function for a successful request.
   *    (Function) errback - The callback function for a failed or timed
   *      out request.  On timeout, the stanza will be null.
   *    (Integer) timeout - The time specified in milliseconds for a
   *      timeout to occur.
   *
   *  Returns:
   *    The id used to send the IQ.
  */
  sendIQ(elem, callback, errback, timeout) {
    let timeoutHandler = null;
    if (typeof elem.tree === "function") {
      elem = elem.tree();
    }
    let id = elem.getAttribute('id');
    if (!id) {
      // inject id if not found
      id = this.getUniqueId("sendIQ");
      elem.setAttribute("id", id);
    }
    if (typeof callback === "function" || typeof errback === "function") {
      const handler = this.addHandler(stanza => {
        // remove timeout handler if there is one
        if (timeoutHandler) {
          this.deleteTimedHandler(timeoutHandler);
        }
        const iqtype = stanza.getAttribute('type');
        if (iqtype === 'result') {
          if (callback) {
            callback(stanza);
          }
        } else if (iqtype === 'error') {
          if (errback) {
            errback(stanza);
          }
        } else {
          const error = new Error(`Got bad IQ type of ${iqtype}`);
          error.name = "StropheError";
          throw error;
        }
      }, null, 'iq', ['error', 'result'], id);

      // if timeout specified, set up a timeout handler.
      if (timeout) {
        timeoutHandler = this.addTimedHandler(timeout, () => {
          // get rid of normal handler
          this.deleteHandler(handler);
          // call errback on timeout with null stanza
          if (errback) {
            errback(null);
          }
          return false;
        });
      }
    }
    this.send(elem);
    return id;
  }

  /** PrivateFunction: _queueData
   *  Queue outgoing data for later sending.  Also ensures that the data
   *  is a DOMElement.
   */
  _queueData(element) {
    if (element === null || !element.tagName || !element.childNodes) {
      const error = new Error("Cannot queue non-DOMElement.");
      error.name = "StropheError";
      throw error;
    }
    this._data.push(element);
  }

  /** PrivateFunction: _sendRestart
   *  Send an xmpp:restart stanza.
   */
  _sendRestart() {
    this._data.push("restart");
    this._proto._sendRestart();
    this._idleTimeout = setTimeout(() => this._onIdle(), 100);
  }

  /** Function: addTimedHandler
   *  Add a timed handler to the connection.
   *
   *  This function adds a timed handler.  The provided handler will
   *  be called every period milliseconds until it returns false,
   *  the connection is terminated, or the handler is removed.  Handlers
   *  that wish to continue being invoked should return true.
   *
   *  Because of method binding it is necessary to save the result of
   *  this function if you wish to remove a handler with
   *  deleteTimedHandler().
   *
   *  Note that user handlers are not active until authentication is
   *  successful.
   *
   *  Parameters:
   *    (Integer) period - The period of the handler.
   *    (Function) handler - The callback function.
   *
   *  Returns:
   *    A reference to the handler that can be used to remove it.
   */
  addTimedHandler(period, handler) {
    const thand = new Strophe.TimedHandler(period, handler);
    this.addTimeds.push(thand);
    return thand;
  }

  /** Function: deleteTimedHandler
   *  Delete a timed handler for a connection.
   *
   *  This function removes a timed handler from the connection.  The
   *  handRef parameter is *not* the function passed to addTimedHandler(),
   *  but is the reference returned from addTimedHandler().
   *
   *  Parameters:
   *    (Strophe.TimedHandler) handRef - The handler reference.
   */
  deleteTimedHandler(handRef) {
    // this must be done in the Idle loop so that we don't change
    // the handlers during iteration
    this.removeTimeds.push(handRef);
  }

  /** Function: addHandler
   *  Add a stanza handler for the connection.
   *
   *  This function adds a stanza handler to the connection.  The
   *  handler callback will be called for any stanza that matches
   *  the parameters.  Note that if multiple parameters are supplied,
   *  they must all match for the handler to be invoked.
   *
   *  The handler will receive the stanza that triggered it as its argument.
   *  *The handler should return true if it is to be invoked again;
   *  returning false will remove the handler after it returns.*
   *
   *  As a convenience, the ns parameters applies to the top level element
   *  and also any of its immediate children.  This is primarily to make
   *  matching /iq/query elements easy.
   *
   *  Options
   *  ~~~~~~~
   *  With the options argument, you can specify boolean flags that affect how
   *  matches are being done.
   *
   *  Currently two flags exist:
   *
   *  - matchBareFromJid:
   *      When set to true, the from parameter and the
   *      from attribute on the stanza will be matched as bare JIDs instead
   *      of full JIDs. To use this, pass {matchBareFromJid: true} as the
   *      value of options. The default value for matchBareFromJid is false.
   *
   *  - ignoreNamespaceFragment:
   *      When set to true, a fragment specified on the stanza's namespace
   *      URL will be ignored when it's matched with the one configured for
   *      the handler.
   *
   *      This means that if you register like this:
   *      >   connection.addHandler(
   *      >       handler,
   *      >       'http://jabber.org/protocol/muc',
   *      >       null, null, null, null,
   *      >       {'ignoreNamespaceFragment': true}
   *      >   );
   *
   *      Then a stanza with XML namespace of
   *      'http://jabber.org/protocol/muc#user' will also be matched. If
   *      'ignoreNamespaceFragment' is false, then only stanzas with
   *      'http://jabber.org/protocol/muc' will be matched.
   *
   *  Deleting the handler
   *  ~~~~~~~~~~~~~~~~~~~~
   *  The return value should be saved if you wish to remove the handler
   *  with deleteHandler().
   *
   *  Parameters:
   *    (Function) handler - The user callback.
   *    (String) ns - The namespace to match.
   *    (String) name - The stanza name to match.
   *    (String|Array) type - The stanza type (or types if an array) to match.
   *    (String) id - The stanza id attribute to match.
   *    (String) from - The stanza from attribute to match.
   *    (String) options - The handler options
   *
   *  Returns:
   *    A reference to the handler that can be used to remove it.
   */
  addHandler(handler, ns, name, type, id, from, options) {
    const hand = new Strophe.Handler(handler, ns, name, type, id, from, options);
    this.addHandlers.push(hand);
    return hand;
  }

  /** Function: deleteHandler
   *  Delete a stanza handler for a connection.
   *
   *  This function removes a stanza handler from the connection.  The
   *  handRef parameter is *not* the function passed to addHandler(),
   *  but is the reference returned from addHandler().
   *
   *  Parameters:
   *    (Strophe.Handler) handRef - The handler reference.
   */
  deleteHandler(handRef) {
    // this must be done in the Idle loop so that we don't change
    // the handlers during iteration
    this.removeHandlers.push(handRef);
    // If a handler is being deleted while it is being added,
    // prevent it from getting added
    const i = this.addHandlers.indexOf(handRef);
    if (i >= 0) {
      this.addHandlers.splice(i, 1);
    }
  }

  /** Function: registerSASLMechanisms
   *
   * Register the SASL mechanisms which will be supported by this instance of
   * Strophe.Connection (i.e. which this XMPP client will support).
   *
   *  Parameters:
   *    (Array) mechanisms - Array of objects with Strophe.SASLMechanism prototypes
   *
   */
  registerSASLMechanisms(mechanisms) {
    this.mechanisms = {};
    mechanisms = mechanisms || [Strophe.SASLAnonymous, Strophe.SASLExternal, Strophe.SASLOAuthBearer, Strophe.SASLXOAuth2, Strophe.SASLPlain, Strophe.SASLSHA1, Strophe.SASLSHA256, Strophe.SASLSHA384, Strophe.SASLSHA512];
    mechanisms.forEach(m => this.registerSASLMechanism(m));
  }

  /** Function: registerSASLMechanism
   *
   * Register a single SASL mechanism, to be supported by this client.
   *
   *  Parameters:
   *    (Object) mechanism - Object with a Strophe.SASLMechanism prototype
   *
   */
  registerSASLMechanism(Mechanism) {
    const mechanism = new Mechanism();
    this.mechanisms[mechanism.mechname] = mechanism;
  }

  /** Function: disconnect
   *  Start the graceful disconnection process.
   *
   *  This function starts the disconnection process.  This process starts
   *  by sending unavailable presence and sending BOSH body of type
   *  terminate.  A timeout handler makes sure that disconnection happens
   *  even if the BOSH server does not respond.
   *  If the Connection object isn't connected, at least tries to abort all pending requests
   *  so the connection object won't generate successful requests (which were already opened).
   *
   *  The user supplied connection callback will be notified of the
   *  progress as this process happens.
   *
   *  Parameters:
   *    (String) reason - The reason the disconnect is occuring.
   */
  disconnect(reason) {
    this._changeConnectStatus(Strophe.Status.DISCONNECTING, reason);
    if (reason) {
      Strophe.warn("Disconnect was called because: " + reason);
    } else {
      Strophe.info("Disconnect was called");
    }
    if (this.connected) {
      let pres = false;
      this.disconnecting = true;
      if (this.authenticated) {
        pres = $pres({
          'xmlns': Strophe.NS.CLIENT,
          'type': 'unavailable'
        });
      }
      // setup timeout handler
      this._disconnectTimeout = this._addSysTimedHandler(this.disconnection_timeout, this._onDisconnectTimeout.bind(this));
      this._proto._disconnect(pres);
    } else {
      Strophe.warn("Disconnect was called before Strophe connected to the server");
      this._proto._abortAllRequests();
      this._doDisconnect();
    }
  }

  /** PrivateFunction: _changeConnectStatus
   *  _Private_ helper function that makes sure plugins and the user's
   *  callback are notified of connection status changes.
   *
   *  Parameters:
   *    (Integer) status - the new connection status, one of the values
   *      in Strophe.Status
   *    (String) condition - the error condition or null
   *    (XMLElement) elem - The triggering stanza.
   */
  _changeConnectStatus(status, condition, elem) {
    // notify all plugins listening for status changes
    for (const k in Strophe._connectionPlugins) {
      if (Object.prototype.hasOwnProperty.call(Strophe._connectionPlugins, k)) {
        const plugin = this[k];
        if (plugin.statusChanged) {
          try {
            plugin.statusChanged(status, condition);
          } catch (err) {
            Strophe.error(`${k} plugin caused an exception changing status: ${err}`);
          }
        }
      }
    }
    // notify the user's callback
    if (this.connect_callback) {
      try {
        this.connect_callback(status, condition, elem);
      } catch (e) {
        Strophe._handleError(e);
        Strophe.error(`User connection callback caused an exception: ${e}`);
      }
    }
  }

  /** PrivateFunction: _doDisconnect
   *  _Private_ function to disconnect.
   *
   *  This is the last piece of the disconnection logic.  This resets the
   *  connection and alerts the user's connection callback.
   */
  _doDisconnect(condition) {
    if (typeof this._idleTimeout === "number") {
      clearTimeout(this._idleTimeout);
    }

    // Cancel Disconnect Timeout
    if (this._disconnectTimeout !== null) {
      this.deleteTimedHandler(this._disconnectTimeout);
      this._disconnectTimeout = null;
    }
    Strophe.debug("_doDisconnect was called");
    this._proto._doDisconnect();
    this.authenticated = false;
    this.disconnecting = false;
    this.restored = false;

    // delete handlers
    this.handlers = [];
    this.timedHandlers = [];
    this.removeTimeds = [];
    this.removeHandlers = [];
    this.addTimeds = [];
    this.addHandlers = [];

    // tell the parent we disconnected
    this._changeConnectStatus(Strophe.Status.DISCONNECTED, condition);
    this.connected = false;
  }

  /** PrivateFunction: _dataRecv
   *  _Private_ handler to processes incoming data from the the connection.
   *
   *  Except for _connect_cb handling the initial connection request,
   *  this function handles the incoming data for all requests.  This
   *  function also fires stanza handlers that match each incoming
   *  stanza.
   *
   *  Parameters:
   *    (Strophe.Request) req - The request that has data ready.
   *    (string) req - The stanza a raw string (optiona).
   */
  _dataRecv(req, raw) {
    const elem = this._proto._reqToData(req);
    if (elem === null) {
      return;
    }
    if (this.xmlInput !== Strophe.Connection.prototype.xmlInput) {
      if (elem.nodeName === this._proto.strip && elem.childNodes.length) {
        this.xmlInput(elem.childNodes[0]);
      } else {
        this.xmlInput(elem);
      }
    }
    if (this.rawInput !== Strophe.Connection.prototype.rawInput) {
      if (raw) {
        this.rawInput(raw);
      } else {
        this.rawInput(Strophe.serialize(elem));
      }
    }

    // remove handlers scheduled for deletion
    while (this.removeHandlers.length > 0) {
      const hand = this.removeHandlers.pop();
      const i = this.handlers.indexOf(hand);
      if (i >= 0) {
        this.handlers.splice(i, 1);
      }
    }

    // add handlers scheduled for addition
    while (this.addHandlers.length > 0) {
      this.handlers.push(this.addHandlers.pop());
    }

    // handle graceful disconnect
    if (this.disconnecting && this._proto._emptyQueue()) {
      this._doDisconnect();
      return;
    }
    const type = elem.getAttribute("type");
    if (type !== null && type === "terminate") {
      // Don't process stanzas that come in after disconnect
      if (this.disconnecting) {
        return;
      }
      // an error occurred
      let cond = elem.getAttribute("condition");
      const conflict = elem.getElementsByTagName("conflict");
      if (cond !== null) {
        if (cond === "remote-stream-error" && conflict.length > 0) {
          cond = "conflict";
        }
        this._changeConnectStatus(Strophe.Status.CONNFAIL, cond);
      } else {
        this._changeConnectStatus(Strophe.Status.CONNFAIL, Strophe.ErrorCondition.UNKOWN_REASON);
      }
      this._doDisconnect(cond);
      return;
    }

    // send each incoming stanza through the handler chain
    Strophe.forEachChild(elem, null, child => {
      const matches = [];
      this.handlers = this.handlers.reduce((handlers, handler) => {
        try {
          if (handler.isMatch(child) && (this.authenticated || !handler.user)) {
            if (handler.run(child)) {
              handlers.push(handler);
            }
            matches.push(handler);
          } else {
            handlers.push(handler);
          }
        } catch (e) {
          // if the handler throws an exception, we consider it as false
          Strophe.warn('Removing Strophe handlers due to uncaught exception: ' + e.message);
        }
        return handlers;
      }, []);

      // If no handler was fired for an incoming IQ with type="set",
      // then we return an IQ error stanza with service-unavailable.
      if (!matches.length && this.iqFallbackHandler.isMatch(child)) {
        this.iqFallbackHandler.run(child);
      }
    });
  }

  /** PrivateFunction: _connect_cb
   *  _Private_ handler for initial connection request.
   *
   *  This handler is used to process the initial connection request
   *  response from the BOSH server. It is used to set up authentication
   *  handlers and start the authentication process.
   *
   *  SASL authentication will be attempted if available, otherwise
   *  the code will fall back to legacy authentication.
   *
   *  Parameters:
   *    (Strophe.Request) req - The current request.
   *    (Function) _callback - low level (xmpp) connect callback function.
   *      Useful for plugins with their own xmpp connect callback (when they
   *      want to do something special).
   */
  _connect_cb(req, _callback, raw) {
    Strophe.debug("_connect_cb was called");
    this.connected = true;
    let bodyWrap;
    try {
      bodyWrap = this._proto._reqToData(req);
    } catch (e) {
      if (e.name !== Strophe.ErrorCondition.BAD_FORMAT) {
        throw e;
      }
      this._changeConnectStatus(Strophe.Status.CONNFAIL, Strophe.ErrorCondition.BAD_FORMAT);
      this._doDisconnect(Strophe.ErrorCondition.BAD_FORMAT);
    }
    if (!bodyWrap) {
      return;
    }
    if (this.xmlInput !== Strophe.Connection.prototype.xmlInput) {
      if (bodyWrap.nodeName === this._proto.strip && bodyWrap.childNodes.length) {
        this.xmlInput(bodyWrap.childNodes[0]);
      } else {
        this.xmlInput(bodyWrap);
      }
    }
    if (this.rawInput !== Strophe.Connection.prototype.rawInput) {
      if (raw) {
        this.rawInput(raw);
      } else {
        this.rawInput(Strophe.serialize(bodyWrap));
      }
    }
    const conncheck = this._proto._connect_cb(bodyWrap);
    if (conncheck === Strophe.Status.CONNFAIL) {
      return;
    }

    // Check for the stream:features tag
    let hasFeatures;
    if (bodyWrap.getElementsByTagNameNS) {
      hasFeatures = bodyWrap.getElementsByTagNameNS(Strophe.NS.STREAM, "features").length > 0;
    } else {
      hasFeatures = bodyWrap.getElementsByTagName("stream:features").length > 0 || bodyWrap.getElementsByTagName("features").length > 0;
    }
    if (!hasFeatures) {
      this._proto._no_auth_received(_callback);
      return;
    }
    const matched = Array.from(bodyWrap.getElementsByTagName("mechanism")).map(m => this.mechanisms[m.textContent]).filter(m => m);
    if (matched.length === 0) {
      if (bodyWrap.getElementsByTagName("auth").length === 0) {
        // There are no matching SASL mechanisms and also no legacy
        // auth available.
        this._proto._no_auth_received(_callback);
        return;
      }
    }
    if (this.do_authentication !== false) {
      this.authenticate(matched);
    }
  }

  /** Function: sortMechanismsByPriority
   *
   *  Sorts an array of objects with prototype SASLMechanism according to
   *  their priorities.
   *
   *  Parameters:
   *    (Array) mechanisms - Array of SASL mechanisms.
   *
   */
  sortMechanismsByPriority(mechanisms) {
    // eslint-disable-line class-methods-use-this
    // Sorting mechanisms according to priority.
    for (let i = 0; i < mechanisms.length - 1; ++i) {
      let higher = i;
      for (let j = i + 1; j < mechanisms.length; ++j) {
        if (mechanisms[j].priority > mechanisms[higher].priority) {
          higher = j;
        }
      }
      if (higher !== i) {
        const swap = mechanisms[i];
        mechanisms[i] = mechanisms[higher];
        mechanisms[higher] = swap;
      }
    }
    return mechanisms;
  }

  /** Function: authenticate
   * Set up authentication
   *
   *  Continues the initial connection request by setting up authentication
   *  handlers and starting the authentication process.
   *
   *  SASL authentication will be attempted if available, otherwise
   *  the code will fall back to legacy authentication.
   *
   *  Parameters:
   *    (Array) matched - Array of SASL mechanisms supported.
   *
   */
  authenticate(matched) {
    if (!this._attemptSASLAuth(matched)) {
      this._attemptLegacyAuth();
    }
  }

  /** PrivateFunction: _attemptSASLAuth
   *
   *  Iterate through an array of SASL mechanisms and attempt authentication
   *  with the highest priority (enabled) mechanism.
   *
   *  Parameters:
   *    (Array) mechanisms - Array of SASL mechanisms.
   *
   *  Returns:
   *    (Boolean) mechanism_found - true or false, depending on whether a
   *          valid SASL mechanism was found with which authentication could be
   *          started.
   */
  _attemptSASLAuth(mechanisms) {
    mechanisms = this.sortMechanismsByPriority(mechanisms || []);
    let mechanism_found = false;
    for (let i = 0; i < mechanisms.length; ++i) {
      if (!mechanisms[i].test(this)) {
        continue;
      }
      this._sasl_success_handler = this._addSysHandler(this._sasl_success_cb.bind(this), null, "success", null, null);
      this._sasl_failure_handler = this._addSysHandler(this._sasl_failure_cb.bind(this), null, "failure", null, null);
      this._sasl_challenge_handler = this._addSysHandler(this._sasl_challenge_cb.bind(this), null, "challenge", null, null);
      this._sasl_mechanism = mechanisms[i];
      this._sasl_mechanism.onStart(this);
      const request_auth_exchange = $build("auth", {
        'xmlns': Strophe.NS.SASL,
        'mechanism': this._sasl_mechanism.mechname
      });
      if (this._sasl_mechanism.isClientFirst) {
        const response = this._sasl_mechanism.clientChallenge(this);
        request_auth_exchange.t((0,abab__WEBPACK_IMPORTED_MODULE_12__.btoa)(response));
      }
      this.send(request_auth_exchange.tree());
      mechanism_found = true;
      break;
    }
    return mechanism_found;
  }

  /** PrivateFunction: _sasl_challenge_cb
   *  _Private_ handler for the SASL challenge
   *
   */
  async _sasl_challenge_cb(elem) {
    const challenge = (0,abab__WEBPACK_IMPORTED_MODULE_12__.atob)(Strophe.getText(elem));
    const response = await this._sasl_mechanism.onChallenge(this, challenge);
    const stanza = $build('response', {
      'xmlns': Strophe.NS.SASL
    });
    if (response !== "") {
      stanza.t((0,abab__WEBPACK_IMPORTED_MODULE_12__.btoa)(response));
    }
    this.send(stanza.tree());
    return true;
  }

  /** PrivateFunction: _attemptLegacyAuth
   *
   *  Attempt legacy (i.e. non-SASL) authentication.
   */
  _attemptLegacyAuth() {
    if (Strophe.getNodeFromJid(this.jid) === null) {
      // we don't have a node, which is required for non-anonymous
      // client connections
      this._changeConnectStatus(Strophe.Status.CONNFAIL, Strophe.ErrorCondition.MISSING_JID_NODE);
      this.disconnect(Strophe.ErrorCondition.MISSING_JID_NODE);
    } else {
      // Fall back to legacy authentication
      this._changeConnectStatus(Strophe.Status.AUTHENTICATING, null);
      this._addSysHandler(this._onLegacyAuthIQResult.bind(this), null, null, null, "_auth_1");
      this.send($iq({
        'type': "get",
        'to': this.domain,
        'id': "_auth_1"
      }).c("query", {
        xmlns: Strophe.NS.AUTH
      }).c("username", {}).t(Strophe.getNodeFromJid(this.jid)).tree());
    }
  }

  /** PrivateFunction: _onLegacyAuthIQResult
   *  _Private_ handler for legacy authentication.
   *
   *  This handler is called in response to the initial <iq type='get'/>
   *  for legacy authentication.  It builds an authentication <iq/> and
   *  sends it, creating a handler (calling back to _auth2_cb()) to
   *  handle the result
   *
   *  Parameters:
   *    (XMLElement) elem - The stanza that triggered the callback.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _onLegacyAuthIQResult(elem) {
    // eslint-disable-line no-unused-vars
    // build plaintext auth iq
    const iq = $iq({
      type: "set",
      id: "_auth_2"
    }).c('query', {
      xmlns: Strophe.NS.AUTH
    }).c('username', {}).t(Strophe.getNodeFromJid(this.jid)).up().c('password').t(this.pass);
    if (!Strophe.getResourceFromJid(this.jid)) {
      // since the user has not supplied a resource, we pick
      // a default one here.  unlike other auth methods, the server
      // cannot do this for us.
      this.jid = Strophe.getBareJidFromJid(this.jid) + '/strophe';
    }
    iq.up().c('resource', {}).t(Strophe.getResourceFromJid(this.jid));
    this._addSysHandler(this._auth2_cb.bind(this), null, null, null, "_auth_2");
    this.send(iq.tree());
    return false;
  }

  /** PrivateFunction: _sasl_success_cb
   *  _Private_ handler for succesful SASL authentication.
   *
   *  Parameters:
   *    (XMLElement) elem - The matching stanza.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _sasl_success_cb(elem) {
    if (this._sasl_data["server-signature"]) {
      let serverSignature;
      const success = (0,abab__WEBPACK_IMPORTED_MODULE_12__.atob)(Strophe.getText(elem));
      const attribMatch = /([a-z]+)=([^,]+)(,|$)/;
      const matches = success.match(attribMatch);
      if (matches[1] === "v") {
        serverSignature = matches[2];
      }
      if (serverSignature !== this._sasl_data["server-signature"]) {
        // remove old handlers
        this.deleteHandler(this._sasl_failure_handler);
        this._sasl_failure_handler = null;
        if (this._sasl_challenge_handler) {
          this.deleteHandler(this._sasl_challenge_handler);
          this._sasl_challenge_handler = null;
        }
        this._sasl_data = {};
        return this._sasl_failure_cb(null);
      }
    }
    Strophe.info("SASL authentication succeeded.");
    if (this._sasl_data.keys) {
      this.scram_keys = this._sasl_data.keys;
    }
    if (this._sasl_mechanism) {
      this._sasl_mechanism.onSuccess();
    }
    // remove old handlers
    this.deleteHandler(this._sasl_failure_handler);
    this._sasl_failure_handler = null;
    if (this._sasl_challenge_handler) {
      this.deleteHandler(this._sasl_challenge_handler);
      this._sasl_challenge_handler = null;
    }
    const streamfeature_handlers = [];
    const wrapper = (handlers, elem) => {
      while (handlers.length) {
        this.deleteHandler(handlers.pop());
      }
      this._onStreamFeaturesAfterSASL(elem);
      return false;
    };
    streamfeature_handlers.push(this._addSysHandler(elem => wrapper(streamfeature_handlers, elem), null, "stream:features", null, null));
    streamfeature_handlers.push(this._addSysHandler(elem => wrapper(streamfeature_handlers, elem), Strophe.NS.STREAM, "features", null, null));

    // we must send an xmpp:restart now
    this._sendRestart();
    return false;
  }

  /** PrivateFunction: _onStreamFeaturesAfterSASL
   *  Parameters:
   *    (XMLElement) elem - The matching stanza.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _onStreamFeaturesAfterSASL(elem) {
    // save stream:features for future usage
    this.features = elem;
    for (let i = 0; i < elem.childNodes.length; i++) {
      const child = elem.childNodes[i];
      if (child.nodeName === 'bind') {
        this.do_bind = true;
      }
      if (child.nodeName === 'session') {
        this.do_session = true;
      }
    }
    if (!this.do_bind) {
      this._changeConnectStatus(Strophe.Status.AUTHFAIL, null);
      return false;
    } else if (!this.options.explicitResourceBinding) {
      this.bind();
    } else {
      this._changeConnectStatus(Strophe.Status.BINDREQUIRED, null);
    }
    return false;
  }

  /** Function: bind
   *
   *  Sends an IQ to the XMPP server to bind a JID resource for this session.
   *
   *  https://tools.ietf.org/html/rfc6120#section-7.5
   *
   *  If `explicitResourceBinding` was set to a truthy value in the options
   *  passed to the Strophe.Connection constructor, then this function needs
   *  to be called explicitly by the client author.
   *
   *  Otherwise it'll be called automatically as soon as the XMPP server
   *  advertises the "urn:ietf:params:xml:ns:xmpp-bind" stream feature.
   */
  bind() {
    if (!this.do_bind) {
      Strophe.log(Strophe.LogLevel.INFO, `Strophe.Connection.prototype.bind called but "do_bind" is false`);
      return;
    }
    this._addSysHandler(this._onResourceBindResultIQ.bind(this), null, null, null, "_bind_auth_2");
    const resource = Strophe.getResourceFromJid(this.jid);
    if (resource) {
      this.send($iq({
        type: "set",
        id: "_bind_auth_2"
      }).c('bind', {
        xmlns: Strophe.NS.BIND
      }).c('resource', {}).t(resource).tree());
    } else {
      this.send($iq({
        type: "set",
        id: "_bind_auth_2"
      }).c('bind', {
        xmlns: Strophe.NS.BIND
      }).tree());
    }
  }

  /** PrivateFunction: _onResourceBindIQ
   *  _Private_ handler for binding result and session start.
   *
   *  Parameters:
   *    (XMLElement) elem - The matching stanza.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _onResourceBindResultIQ(elem) {
    if (elem.getAttribute("type") === "error") {
      Strophe.warn("Resource binding failed.");
      const conflict = elem.getElementsByTagName("conflict");
      let condition;
      if (conflict.length > 0) {
        condition = Strophe.ErrorCondition.CONFLICT;
      }
      this._changeConnectStatus(Strophe.Status.AUTHFAIL, condition, elem);
      return false;
    }
    // TODO - need to grab errors
    const bind = elem.getElementsByTagName("bind");
    if (bind.length > 0) {
      const jidNode = bind[0].getElementsByTagName("jid");
      if (jidNode.length > 0) {
        this.authenticated = true;
        this.jid = Strophe.getText(jidNode[0]);
        if (this.do_session) {
          this._establishSession();
        } else {
          this._changeConnectStatus(Strophe.Status.CONNECTED, null);
        }
      }
    } else {
      Strophe.warn("Resource binding failed.");
      this._changeConnectStatus(Strophe.Status.AUTHFAIL, null, elem);
      return false;
    }
  }

  /** PrivateFunction: _establishSession
   *  Send IQ request to establish a session with the XMPP server.
   *
   *  See https://xmpp.org/rfcs/rfc3921.html#session
   *
   *  Note: The protocol for session establishment has been determined as
   *  unnecessary and removed in RFC-6121.
   */
  _establishSession() {
    if (!this.do_session) {
      throw new Error(`Strophe.Connection.prototype._establishSession ` + `called but apparently ${Strophe.NS.SESSION} wasn't advertised by the server`);
    }
    this._addSysHandler(this._onSessionResultIQ.bind(this), null, null, null, "_session_auth_2");
    this.send($iq({
      type: "set",
      id: "_session_auth_2"
    }).c('session', {
      xmlns: Strophe.NS.SESSION
    }).tree());
  }

  /** PrivateFunction: _onSessionResultIQ
   *  _Private_ handler for the server's IQ response to a client's session
   *  request.
   *
   *  This sets Connection.authenticated to true on success, which
   *  starts the processing of user handlers.
   *
   *  See https://xmpp.org/rfcs/rfc3921.html#session
   *
   *  Note: The protocol for session establishment has been determined as
   *  unnecessary and removed in RFC-6121.
   *
   *  Parameters:
   *    (XMLElement) elem - The matching stanza.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _onSessionResultIQ(elem) {
    if (elem.getAttribute("type") === "result") {
      this.authenticated = true;
      this._changeConnectStatus(Strophe.Status.CONNECTED, null);
    } else if (elem.getAttribute("type") === "error") {
      this.authenticated = false;
      Strophe.warn("Session creation failed.");
      this._changeConnectStatus(Strophe.Status.AUTHFAIL, null, elem);
      return false;
    }
    return false;
  }

  /** PrivateFunction: _sasl_failure_cb
   *  _Private_ handler for SASL authentication failure.
   *
   *  Parameters:
   *    (XMLElement) elem - The matching stanza.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _sasl_failure_cb(elem) {
    // delete unneeded handlers
    if (this._sasl_success_handler) {
      this.deleteHandler(this._sasl_success_handler);
      this._sasl_success_handler = null;
    }
    if (this._sasl_challenge_handler) {
      this.deleteHandler(this._sasl_challenge_handler);
      this._sasl_challenge_handler = null;
    }
    if (this._sasl_mechanism) this._sasl_mechanism.onFailure();
    this._changeConnectStatus(Strophe.Status.AUTHFAIL, null, elem);
    return false;
  }

  /** PrivateFunction: _auth2_cb
   *  _Private_ handler to finish legacy authentication.
   *
   *  This handler is called when the result from the jabber:iq:auth
   *  <iq/> stanza is returned.
   *
   *  Parameters:
   *    (XMLElement) elem - The stanza that triggered the callback.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _auth2_cb(elem) {
    if (elem.getAttribute("type") === "result") {
      this.authenticated = true;
      this._changeConnectStatus(Strophe.Status.CONNECTED, null);
    } else if (elem.getAttribute("type") === "error") {
      this._changeConnectStatus(Strophe.Status.AUTHFAIL, null, elem);
      this.disconnect('authentication failed');
    }
    return false;
  }

  /** PrivateFunction: _addSysTimedHandler
   *  _Private_ function to add a system level timed handler.
   *
   *  This function is used to add a Strophe.TimedHandler for the
   *  library code.  System timed handlers are allowed to run before
   *  authentication is complete.
   *
   *  Parameters:
   *    (Integer) period - The period of the handler.
   *    (Function) handler - The callback function.
   */
  _addSysTimedHandler(period, handler) {
    const thand = new Strophe.TimedHandler(period, handler);
    thand.user = false;
    this.addTimeds.push(thand);
    return thand;
  }

  /** PrivateFunction: _addSysHandler
   *  _Private_ function to add a system level stanza handler.
   *
   *  This function is used to add a Strophe.Handler for the
   *  library code.  System stanza handlers are allowed to run before
   *  authentication is complete.
   *
   *  Parameters:
   *    (Function) handler - The callback function.
   *    (String) ns - The namespace to match.
   *    (String) name - The stanza name to match.
   *    (String) type - The stanza type attribute to match.
   *    (String) id - The stanza id attribute to match.
   */
  _addSysHandler(handler, ns, name, type, id) {
    const hand = new Strophe.Handler(handler, ns, name, type, id);
    hand.user = false;
    this.addHandlers.push(hand);
    return hand;
  }

  /** PrivateFunction: _onDisconnectTimeout
   *  _Private_ timeout handler for handling non-graceful disconnection.
   *
   *  If the graceful disconnect process does not complete within the
   *  time allotted, this handler finishes the disconnect anyway.
   *
   *  Returns:
   *    false to remove the handler.
   */
  _onDisconnectTimeout() {
    Strophe.debug("_onDisconnectTimeout was called");
    this._changeConnectStatus(Strophe.Status.CONNTIMEOUT, null);
    this._proto._onDisconnectTimeout();
    // actually disconnect
    this._doDisconnect();
    return false;
  }

  /** PrivateFunction: _onIdle
   *  _Private_ handler to process events during idle cycle.
   *
   *  This handler is called every 100ms to fire timed handlers that
   *  are ready and keep poll requests going.
   */
  _onIdle() {
    // add timed handlers scheduled for addition
    // NOTE: we add before remove in the case a timed handler is
    // added and then deleted before the next _onIdle() call.
    while (this.addTimeds.length > 0) {
      this.timedHandlers.push(this.addTimeds.pop());
    }

    // remove timed handlers that have been scheduled for deletion
    while (this.removeTimeds.length > 0) {
      const thand = this.removeTimeds.pop();
      const i = this.timedHandlers.indexOf(thand);
      if (i >= 0) {
        this.timedHandlers.splice(i, 1);
      }
    }

    // call ready timed handlers
    const now = new Date().getTime();
    const newList = [];
    for (let i = 0; i < this.timedHandlers.length; i++) {
      const thand = this.timedHandlers[i];
      if (this.authenticated || !thand.user) {
        const since = thand.lastCalled + thand.period;
        if (since - now <= 0) {
          if (thand.run()) {
            newList.push(thand);
          }
        } else {
          newList.push(thand);
        }
      }
    }
    this.timedHandlers = newList;
    clearTimeout(this._idleTimeout);
    this._proto._onIdle();

    // reactivate the timer only if connected
    if (this.connected) {
      this._idleTimeout = setTimeout(() => this._onIdle(), 100);
    }
  }
};
Strophe.SASLMechanism = _sasl_js__WEBPACK_IMPORTED_MODULE_3__["default"];

/** Constants: SASL mechanisms
 *  Available authentication mechanisms
 *
 *  Strophe.SASLAnonymous   - SASL ANONYMOUS authentication.
 *  Strophe.SASLPlain       - SASL PLAIN authentication.
 *  Strophe.SASLSHA1        - SASL SCRAM-SHA-1 authentication
 *  Strophe.SASLSHA256      - SASL SCRAM-SHA-256 authentication
 *  Strophe.SASLSHA384      - SASL SCRAM-SHA-384 authentication
 *  Strophe.SASLSHA512      - SASL SCRAM-SHA-512 authentication
 *  Strophe.SASLOAuthBearer - SASL OAuth Bearer authentication
 *  Strophe.SASLExternal    - SASL EXTERNAL authentication
 *  Strophe.SASLXOAuth2     - SASL X-OAuth2 authentication
 */
Strophe.SASLAnonymous = _sasl_anon_js__WEBPACK_IMPORTED_MODULE_1__["default"];
Strophe.SASLPlain = _sasl_plain_js__WEBPACK_IMPORTED_MODULE_5__["default"];
Strophe.SASLSHA1 = _sasl_sha1_js__WEBPACK_IMPORTED_MODULE_6__["default"];
Strophe.SASLSHA256 = _sasl_sha256_js__WEBPACK_IMPORTED_MODULE_7__["default"];
Strophe.SASLSHA384 = _sasl_sha384_js__WEBPACK_IMPORTED_MODULE_8__["default"];
Strophe.SASLSHA512 = _sasl_sha512_js__WEBPACK_IMPORTED_MODULE_9__["default"];
Strophe.SASLOAuthBearer = _sasl_oauthbearer_js__WEBPACK_IMPORTED_MODULE_4__["default"];
Strophe.SASLExternal = _sasl_external_js__WEBPACK_IMPORTED_MODULE_2__["default"];
Strophe.SASLXOAuth2 = _sasl_xoauth2_js__WEBPACK_IMPORTED_MODULE_10__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  'Strophe': Strophe,
  '$build': $build,
  '$iq': $iq,
  '$msg': $msg,
  '$pres': $pres
});

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-anon.js":
/*!**************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-anon.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLAnonymous)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");


// Building SASL callbacks

class SASLAnonymous extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLAnonymous
   *  SASL ANONYMOUS authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'ANONYMOUS';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 20;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid === null;
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-external.js":
/*!******************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-external.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLExternal)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");

class SASLExternal extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLExternal
   *  SASL EXTERNAL authentication.
   *
   *  The EXTERNAL mechanism allows a client to request the server to use
   *  credentials established by means external to the mechanism to
   *  authenticate the client. The external means may be, for instance,
   *  TLS services.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'EXTERNAL';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 10;
    super(mechname, isClientFirst, priority);
  }
  onChallenge(connection) {
    // eslint-disable-line class-methods-use-this
    /** According to XEP-178, an authzid SHOULD NOT be presented when the
     * authcid contained or implied in the client certificate is the JID (i.e.
     * authzid) with which the user wants to log in as.
     *
     * To NOT send the authzid, the user should therefore set the authcid equal
     * to the JID when instantiating a new Strophe.Connection object.
     */
    return connection.authcid === connection.authzid ? '' : connection.authzid;
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-oauthbearer.js":
/*!*********************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-oauthbearer.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLOAuthBearer)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/strophe.js/src/utils.js");


class SASLOAuthBearer extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLOAuthBearer
   *  SASL OAuth Bearer authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'OAUTHBEARER';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 40;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.pass !== null;
  }
  onChallenge(connection) {
    // eslint-disable-line class-methods-use-this
    let auth_str = 'n,';
    if (connection.authcid !== null) {
      auth_str = auth_str + 'a=' + connection.authzid;
    }
    auth_str = auth_str + ',';
    auth_str = auth_str + "\u0001";
    auth_str = auth_str + 'auth=Bearer ';
    auth_str = auth_str + connection.pass;
    auth_str = auth_str + "\u0001";
    auth_str = auth_str + "\u0001";
    return _utils__WEBPACK_IMPORTED_MODULE_1__["default"].utf16to8(auth_str);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-plain.js":
/*!***************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-plain.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLPlain)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/strophe.js/src/utils.js");


class SASLPlain extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLPlain
   *  SASL PLAIN authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'PLAIN';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 50;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid !== null;
  }
  onChallenge(connection) {
    // eslint-disable-line class-methods-use-this
    const {
      authcid,
      authzid,
      domain,
      pass
    } = connection;
    if (!domain) {
      throw new Error("SASLPlain onChallenge: domain is not defined!");
    }
    // Only include authzid if it differs from authcid.
    // See: https://tools.ietf.org/html/rfc6120#section-6.3.8
    let auth_str = authzid !== `${authcid}@${domain}` ? authzid : '';
    auth_str = auth_str + "\u0000";
    auth_str = auth_str + authcid;
    auth_str = auth_str + "\u0000";
    auth_str = auth_str + pass;
    return _utils__WEBPACK_IMPORTED_MODULE_1__["default"].utf16to8(auth_str);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-sha1.js":
/*!**************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-sha1.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLSHA1)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _scram_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scram.js */ "./node_modules/strophe.js/src/scram.js");


class SASLSHA1 extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLSHA1
   *  SASL SCRAM SHA 1 authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'SCRAM-SHA-1';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 60;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid !== null;
  }
  async onChallenge(connection, challenge) {
    // eslint-disable-line class-methods-use-this, require-await
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].scramResponse(connection, challenge, "SHA-1", 160);
  }
  clientChallenge(connection, test_cnonce) {
    // eslint-disable-line class-methods-use-this
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].clientChallenge(connection, test_cnonce);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-sha256.js":
/*!****************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-sha256.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLSHA256)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _scram_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scram.js */ "./node_modules/strophe.js/src/scram.js");


class SASLSHA256 extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLSHA256
   *  SASL SCRAM SHA 256 authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'SCRAM-SHA-256';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 70;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid !== null;
  }
  async onChallenge(connection, challenge) {
    // eslint-disable-line class-methods-use-this, require-await
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].scramResponse(connection, challenge, "SHA-256", 256);
  }
  clientChallenge(connection, test_cnonce) {
    // eslint-disable-line class-methods-use-this
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].clientChallenge(connection, test_cnonce);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-sha384.js":
/*!****************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-sha384.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLSHA384)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _scram_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scram.js */ "./node_modules/strophe.js/src/scram.js");


class SASLSHA384 extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLSHA384
   *  SASL SCRAM SHA 384 authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'SCRAM-SHA-384';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 71;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid !== null;
  }
  async onChallenge(connection, challenge) {
    // eslint-disable-line class-methods-use-this, require-await
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].scramResponse(connection, challenge, "SHA-384", 384);
  }
  clientChallenge(connection, test_cnonce) {
    // eslint-disable-line class-methods-use-this
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].clientChallenge(connection, test_cnonce);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-sha512.js":
/*!****************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-sha512.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLSHA512)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _scram_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./scram.js */ "./node_modules/strophe.js/src/scram.js");


class SASLSHA512 extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLSHA512
   *  SASL SCRAM SHA 512 authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'SCRAM-SHA-512';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 72;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.authcid !== null;
  }
  async onChallenge(connection, challenge) {
    // eslint-disable-line class-methods-use-this, require-await
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].scramResponse(connection, challenge, "SHA-512", 512);
  }
  clientChallenge(connection, test_cnonce) {
    // eslint-disable-line class-methods-use-this
    return _scram_js__WEBPACK_IMPORTED_MODULE_1__["default"].clientChallenge(connection, test_cnonce);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl-xoauth2.js":
/*!*****************************************************!*\
  !*** ./node_modules/strophe.js/src/sasl-xoauth2.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLXOAuth2)
/* harmony export */ });
/* harmony import */ var _sasl_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sasl.js */ "./node_modules/strophe.js/src/sasl.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/strophe.js/src/utils.js");


class SASLXOAuth2 extends _sasl_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  /** PrivateConstructor: SASLXOAuth2
   *  SASL X-OAuth2 authentication.
   */
  constructor() {
    let mechname = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'X-OAUTH2';
    let isClientFirst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 30;
    super(mechname, isClientFirst, priority);
  }
  test(connection) {
    // eslint-disable-line class-methods-use-this
    return connection.pass !== null;
  }
  onChallenge(connection) {
    // eslint-disable-line class-methods-use-this
    let auth_str = '\u0000';
    if (connection.authcid !== null) {
      auth_str = auth_str + connection.authzid;
    }
    auth_str = auth_str + "\u0000";
    auth_str = auth_str + connection.pass;
    return _utils__WEBPACK_IMPORTED_MODULE_1__["default"].utf16to8(auth_str);
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/sasl.js":
/*!*********************************************!*\
  !*** ./node_modules/strophe.js/src/sasl.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SASLMechanism)
/* harmony export */ });
/** Class: Strophe.SASLMechanism
 *
 *  Encapsulates an SASL authentication mechanism.
 *
 *  User code may override the priority for each mechanism or disable it completely.
 *  See <priority> for information about changing priority and <test> for informatian on
 *  how to disable a mechanism.
 *
 *  By default, all mechanisms are enabled and the priorities are
 *
 *      SCRAM-SHA-512 - 72
 *      SCRAM-SHA-384 - 71
 *      SCRAM-SHA-256 - 70
 *      SCRAM-SHA-1   - 60
 *      PLAIN         - 50
 *      OAUTHBEARER   - 40
 *      X-OAUTH2      - 30
 *      ANONYMOUS     - 20
 *      EXTERNAL      - 10
 *
 *  See: Strophe.Connection.addSupportedSASLMechanisms
 */
class SASLMechanism {
  /**
   * PrivateConstructor: Strophe.SASLMechanism
   * SASL auth mechanism abstraction.
   *
   *  Parameters:
   *    (String) name - SASL Mechanism name.
   *    (Boolean) isClientFirst - If client should send response first without challenge.
   *    (Number) priority - Priority.
   *
   *  Returns:
   *    A new Strophe.SASLMechanism object.
   */
  constructor(name, isClientFirst, priority) {
    /** PrivateVariable: mechname
     *  Mechanism name.
     */
    this.mechname = name;

    /** PrivateVariable: isClientFirst
     *  If client sends response without initial server challenge.
     */
    this.isClientFirst = isClientFirst;

    /** Variable: priority
     *  Determines which <SASLMechanism> is chosen for authentication (Higher is better).
     *  Users may override this to prioritize mechanisms differently.
     *
     *  Example: (This will cause Strophe to choose the mechanism that the server sent first)
     *
     *  > Strophe.SASLPlain.priority = Strophe.SASLSHA1.priority;
     *
     *  See <SASL mechanisms> for a list of available mechanisms.
     *
     */
    this.priority = priority;
  }

  /**
   *  Function: test
   *  Checks if mechanism able to run.
   *  To disable a mechanism, make this return false;
   *
   *  To disable plain authentication run
   *  > Strophe.SASLPlain.test = function() {
   *  >   return false;
   *  > }
   *
   *  See <SASL mechanisms> for a list of available mechanisms.
   *
   *  Parameters:
   *    (Strophe.Connection) connection - Target Connection.
   *
   *  Returns:
   *    (Boolean) If mechanism was able to run.
   */
  test() {
    // eslint-disable-line class-methods-use-this
    return true;
  }

  /** PrivateFunction: onStart
   *  Called before starting mechanism on some connection.
   *
   *  Parameters:
   *    (Strophe.Connection) connection - Target Connection.
   */
  onStart(connection) {
    this._connection = connection;
  }

  /** PrivateFunction: onChallenge
   *  Called by protocol implementation on incoming challenge.
   *
   *  By deafult, if the client is expected to send data first (isClientFirst === true),
   *  this method is called with `challenge` as null on the first call,
   *  unless `clientChallenge` is overridden in the relevant subclass.
   *
   *  Parameters:
   *    (Strophe.Connection) connection - Target Connection.
   *    (String) challenge - current challenge to handle.
   *
   *  Returns:
   *    (String) Mechanism response.
   */
  onChallenge(connection, challenge) {
    // eslint-disable-line
    throw new Error("You should implement challenge handling!");
  }

  /** PrivateFunction: clientChallenge
   *  Called by the protocol implementation if the client is expected to send
   *  data first in the authentication exchange (i.e. isClientFirst === true).
   *
   *  Parameters:
   *    (Strophe.Connection) connection - Target Connection.
   *
   *  Returns:
   *    (String) Mechanism response.
   */
  clientChallenge(connection) {
    if (!this.isClientFirst) {
      throw new Error("clientChallenge should not be called if isClientFirst is false!");
    }
    return this.onChallenge(connection);
  }

  /** PrivateFunction: onFailure
   *  Protocol informs mechanism implementation about SASL failure.
   */
  onFailure() {
    this._connection = null;
  }

  /** PrivateFunction: onSuccess
   *  Protocol informs mechanism implementation about SASL success.
   */
  onSuccess() {
    this._connection = null;
  }
}

/***/ }),

/***/ "./node_modules/strophe.js/src/scram.js":
/*!**********************************************!*\
  !*** ./node_modules/strophe.js/src/scram.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ scram)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/strophe.js/src/utils.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.js */ "./node_modules/strophe.js/src/core.js");


async function scramClientProof(authMessage, clientKey, hashName) {
  const storedKey = await window.crypto.subtle.importKey("raw", await window.crypto.subtle.digest(hashName, clientKey), {
    "name": "HMAC",
    "hash": hashName
  }, false, ["sign"]);
  const clientSignature = await window.crypto.subtle.sign("HMAC", storedKey, _utils__WEBPACK_IMPORTED_MODULE_0__["default"].stringToArrayBuf(authMessage));
  return _utils__WEBPACK_IMPORTED_MODULE_0__["default"].xorArrayBuffers(clientKey, clientSignature);
}

/* This function parses the information in a SASL SCRAM challenge response,
 * into an object of the form
 * { nonce: String,
 *   salt:  ArrayBuffer,
 *   iter:  Int
 * }
 * Returns undefined on failure.
 */
function scramParseChallenge(challenge) {
  let nonce, salt, iter;
  const attribMatch = /([a-z]+)=([^,]+)(,|$)/;
  while (challenge.match(attribMatch)) {
    const matches = challenge.match(attribMatch);
    challenge = challenge.replace(matches[0], "");
    switch (matches[1]) {
      case "r":
        nonce = matches[2];
        break;
      case "s":
        salt = _utils__WEBPACK_IMPORTED_MODULE_0__["default"].base64ToArrayBuf(matches[2]);
        break;
      case "i":
        iter = parseInt(matches[2], 10);
        break;
      default:
        return undefined;
    }
  }

  // Consider iteration counts less than 4096 insecure, as reccommended by
  // RFC 5802
  if (isNaN(iter) || iter < 4096) {
    _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Failing SCRAM authentication because server supplied iteration count < 4096.");
    return undefined;
  }
  if (!salt) {
    _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Failing SCRAM authentication because server supplied incorrect salt.");
    return undefined;
  }
  return {
    "nonce": nonce,
    "salt": salt,
    "iter": iter
  };
}

/* Derive the client and server keys given a string password,
 * a hash name, and a bit length.
 * Returns an object of the following form:
 * { ck: ArrayBuffer, the client key
 *   sk: ArrayBuffer, the server key
 * }
 */
async function scramDeriveKeys(password, salt, iter, hashName, hashBits) {
  const saltedPasswordBits = await window.crypto.subtle.deriveBits({
    "name": "PBKDF2",
    "salt": salt,
    "iterations": iter,
    "hash": {
      "name": hashName
    }
  }, await window.crypto.subtle.importKey("raw", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].stringToArrayBuf(password), "PBKDF2", false, ["deriveBits"]), hashBits);
  const saltedPassword = await window.crypto.subtle.importKey("raw", saltedPasswordBits, {
    "name": "HMAC",
    "hash": hashName
  }, false, ["sign"]);
  return {
    "ck": await window.crypto.subtle.sign("HMAC", saltedPassword, _utils__WEBPACK_IMPORTED_MODULE_0__["default"].stringToArrayBuf("Client Key")),
    "sk": await window.crypto.subtle.sign("HMAC", saltedPassword, _utils__WEBPACK_IMPORTED_MODULE_0__["default"].stringToArrayBuf("Server Key"))
  };
}
async function scramServerSign(authMessage, sk, hashName) {
  const serverKey = await window.crypto.subtle.importKey("raw", sk, {
    "name": "HMAC",
    "hash": hashName
  }, false, ["sign"]);
  return window.crypto.subtle.sign("HMAC", serverKey, _utils__WEBPACK_IMPORTED_MODULE_0__["default"].stringToArrayBuf(authMessage));
}

// Generate an ASCII nonce (not containing the ',' character)
function generate_cnonce() {
  // generate 16 random bytes of nonce, base64 encoded
  const bytes = new Uint8Array(16);
  return _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(crypto.getRandomValues(bytes).buffer);
}
const scram = {
  /* On success, sets
   * connection_sasl_data["server-signature"]
   * and
   * connection._sasl_data.keys
   *
   * The server signature should be verified after this function completes..
   *
   * On failure, returns connection._sasl_failure_cb();
   */
  async scramResponse(connection, challenge, hashName, hashBits) {
    var _connection$pass, _connection$pass2, _connection$pass3;
    const cnonce = connection._sasl_data.cnonce;
    const challengeData = scramParseChallenge(challenge);

    // The RFC requires that we verify the (server) nonce has the client
    // nonce as an initial substring.
    if (!challengeData && (challengeData === null || challengeData === void 0 ? void 0 : challengeData.nonce.slice(0, cnonce.length)) !== cnonce) {
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Failing SCRAM authentication because server supplied incorrect nonce.");
      connection._sasl_data = {};
      return connection._sasl_failure_cb();
    }
    let clientKey, serverKey;

    // Either restore the client key and server key passed in, or derive new ones
    if (((_connection$pass = connection.pass) === null || _connection$pass === void 0 ? void 0 : _connection$pass.name) === hashName && ((_connection$pass2 = connection.pass) === null || _connection$pass2 === void 0 ? void 0 : _connection$pass2.salt) === _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(challengeData.salt) && ((_connection$pass3 = connection.pass) === null || _connection$pass3 === void 0 ? void 0 : _connection$pass3.iter) === challengeData.iter) {
      clientKey = _utils__WEBPACK_IMPORTED_MODULE_0__["default"].base64ToArrayBuf(connection.pass.ck);
      serverKey = _utils__WEBPACK_IMPORTED_MODULE_0__["default"].base64ToArrayBuf(connection.pass.sk);
    } else if (typeof connection.pass === "string" || connection.pass instanceof String) {
      const keys = await scramDeriveKeys(connection.pass, challengeData.salt, challengeData.iter, hashName, hashBits);
      clientKey = keys.ck;
      serverKey = keys.sk;
    } else {
      return connection._sasl_failure_cb();
    }
    const clientFirstMessageBare = connection._sasl_data["client-first-message-bare"];
    const serverFirstMessage = challenge;
    const clientFinalMessageBare = `c=biws,r=${challengeData.nonce}`;
    const authMessage = `${clientFirstMessageBare},${serverFirstMessage},${clientFinalMessageBare}`;
    const clientProof = await scramClientProof(authMessage, clientKey, hashName);
    const serverSignature = await scramServerSign(authMessage, serverKey, hashName);
    connection._sasl_data["server-signature"] = _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(serverSignature);
    connection._sasl_data.keys = {
      "name": hashName,
      "iter": challengeData.iter,
      "salt": _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(challengeData.salt),
      "ck": _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(clientKey),
      "sk": _utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(serverKey)
    };
    return `${clientFinalMessageBare},p=${_utils__WEBPACK_IMPORTED_MODULE_0__["default"].arrayBufToBase64(clientProof)}`;
  },
  // Returns a string containing the client first message
  clientChallenge(connection, test_cnonce) {
    const cnonce = test_cnonce || generate_cnonce();
    const client_first_message_bare = `n=${connection.authcid},r=${cnonce}`;
    connection._sasl_data.cnonce = cnonce;
    connection._sasl_data["client-first-message-bare"] = client_first_message_bare;
    return `n,,${client_first_message_bare}`;
  }
};


/***/ }),

/***/ "./node_modules/strophe.js/src/strophe.js":
/*!************************************************!*\
  !*** ./node_modules/strophe.js/src/strophe.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$build": () => (/* reexport safe */ _core__WEBPACK_IMPORTED_MODULE_3__.$build),
/* harmony export */   "$iq": () => (/* reexport safe */ _core__WEBPACK_IMPORTED_MODULE_3__.$iq),
/* harmony export */   "$msg": () => (/* reexport safe */ _core__WEBPACK_IMPORTED_MODULE_3__.$msg),
/* harmony export */   "$pres": () => (/* reexport safe */ _core__WEBPACK_IMPORTED_MODULE_3__.$pres),
/* harmony export */   "Strophe": () => (/* reexport safe */ _core__WEBPACK_IMPORTED_MODULE_3__.Strophe)
/* harmony export */ });
/* harmony import */ var _bosh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bosh */ "./node_modules/strophe.js/src/bosh.js");
/* harmony import */ var _websocket__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./websocket */ "./node_modules/strophe.js/src/websocket.js");
/* harmony import */ var _worker_websocket__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./worker-websocket */ "./node_modules/strophe.js/src/worker-websocket.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./core */ "./node_modules/strophe.js/src/core.js");
/*global global*/





__webpack_require__.g.$build = _core__WEBPACK_IMPORTED_MODULE_3__["default"].$build;
__webpack_require__.g.$iq = _core__WEBPACK_IMPORTED_MODULE_3__["default"].$iq;
__webpack_require__.g.$msg = _core__WEBPACK_IMPORTED_MODULE_3__["default"].$msg;
__webpack_require__.g.$pres = _core__WEBPACK_IMPORTED_MODULE_3__["default"].$pres;
__webpack_require__.g.Strophe = _core__WEBPACK_IMPORTED_MODULE_3__["default"].Strophe;


/***/ }),

/***/ "./node_modules/strophe.js/src/utils.js":
/*!**********************************************!*\
  !*** ./node_modules/strophe.js/src/utils.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ utils)
/* harmony export */ });
const utils = {
  utf16to8(str) {
    let out = "";
    const len = str.length;
    for (let i = 0; i < len; i++) {
      const c = str.charCodeAt(i);
      if (c >= 0x0000 && c <= 0x007F) {
        out += str.charAt(i);
      } else if (c > 0x07FF) {
        out += String.fromCharCode(0xE0 | c >> 12 & 0x0F);
        out += String.fromCharCode(0x80 | c >> 6 & 0x3F);
        out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
      } else {
        out += String.fromCharCode(0xC0 | c >> 6 & 0x1F);
        out += String.fromCharCode(0x80 | c >> 0 & 0x3F);
      }
    }
    return out;
  },
  xorArrayBuffers(x, y) {
    const xIntArray = new Uint8Array(x);
    const yIntArray = new Uint8Array(y);
    const zIntArray = new Uint8Array(x.byteLength);
    for (let i = 0; i < x.byteLength; i++) {
      zIntArray[i] = xIntArray[i] ^ yIntArray[i];
    }
    return zIntArray.buffer;
  },
  arrayBufToBase64(buffer) {
    // This function is due to mobz (https://stackoverflow.com/users/1234628/mobz)
    //  and Emmanuel (https://stackoverflow.com/users/288564/emmanuel)
    let binary = '';
    const bytes = new Uint8Array(buffer);
    const len = bytes.byteLength;
    for (let i = 0; i < len; i++) {
      binary += String.fromCharCode(bytes[i]);
    }
    return window.btoa(binary);
  },
  base64ToArrayBuf(str) {
    var _Uint8Array$from;
    return (_Uint8Array$from = Uint8Array.from(atob(str), c => c.charCodeAt(0))) === null || _Uint8Array$from === void 0 ? void 0 : _Uint8Array$from.buffer;
  },
  stringToArrayBuf(str) {
    const bytes = new TextEncoder("utf-8").encode(str);
    return bytes.buffer;
  },
  addCookies(cookies) {
    /* Parameters:
     *  (Object) cookies - either a map of cookie names
     *    to string values or to maps of cookie values.
     *
     * For example:
     * { "myCookie": "1234" }
     *
     * or:
     * { "myCookie": {
     *      "value": "1234",
     *      "domain": ".example.org",
     *      "path": "/",
     *      "expires": expirationDate
     *      }
     *  }
     *
     *  These values get passed to Strophe.Connection via
     *   options.cookies
     */
    cookies = cookies || {};
    for (const cookieName in cookies) {
      if (Object.prototype.hasOwnProperty.call(cookies, cookieName)) {
        let expires = '';
        let domain = '';
        let path = '';
        const cookieObj = cookies[cookieName];
        const isObj = typeof cookieObj === "object";
        const cookieValue = escape(unescape(isObj ? cookieObj.value : cookieObj));
        if (isObj) {
          expires = cookieObj.expires ? ";expires=" + cookieObj.expires : '';
          domain = cookieObj.domain ? ";domain=" + cookieObj.domain : '';
          path = cookieObj.path ? ";path=" + cookieObj.path : '';
        }
        document.cookie = cookieName + '=' + cookieValue + expires + domain + path;
      }
    }
  }
};


/***/ }),

/***/ "./node_modules/strophe.js/src/websocket.js":
/*!**************************************************!*\
  !*** ./node_modules/strophe.js/src/websocket.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./shims */ "./src/strophe-shims.js");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core */ "./node_modules/strophe.js/src/core.js");
/*
    This program is distributed under the terms of the MIT license.
    Please see the LICENSE file for details.

    Copyright 2006-2008, OGG, LLC
*/

/* global window, clearTimeout, WebSocket, DOMParser */




/** Class: Strophe.WebSocket
 *  _Private_ helper class that handles WebSocket Connections
 *
 *  The Strophe.WebSocket class is used internally by Strophe.Connection
 *  to encapsulate WebSocket sessions. It is not meant to be used from user's code.
 */

/** File: websocket.js
 *  A JavaScript library to enable XMPP over Websocket in Strophejs.
 *
 *  This file implements XMPP over WebSockets for Strophejs.
 *  If a Connection is established with a Websocket url (ws://...)
 *  Strophe will use WebSockets.
 *  For more information on XMPP-over-WebSocket see RFC 7395:
 *  http://tools.ietf.org/html/rfc7395
 *
 *  WebSocket support implemented by Andreas Guth (andreas.guth@rwth-aachen.de)
 */
_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Websocket = class Websocket {
  /** PrivateConstructor: Strophe.Websocket
   *  Create and initialize a Strophe.WebSocket object.
   *  Currently only sets the connection Object.
   *
   *  Parameters:
   *    (Strophe.Connection) connection - The Strophe.Connection that will use WebSockets.
   *
   *  Returns:
   *    A new Strophe.WebSocket object.
   */
  constructor(connection) {
    this._conn = connection;
    this.strip = "wrapper";
    const service = connection.service;
    if (service.indexOf("ws:") !== 0 && service.indexOf("wss:") !== 0) {
      // If the service is not an absolute URL, assume it is a path and put the absolute
      // URL together from options, current URL and the path.
      let new_service = "";
      if (connection.options.protocol === "ws" && window.location.protocol !== "https:") {
        new_service += "ws";
      } else {
        new_service += "wss";
      }
      new_service += "://" + window.location.host;
      if (service.indexOf("/") !== 0) {
        new_service += window.location.pathname + service;
      } else {
        new_service += service;
      }
      connection.service = new_service;
    }
  }

  /** PrivateFunction: _buildStream
   *  _Private_ helper function to generate the <stream> start tag for WebSockets
   *
   *  Returns:
   *    A Strophe.Builder with a <stream> element.
   */
  _buildStream() {
    return (0,_core__WEBPACK_IMPORTED_MODULE_1__.$build)("open", {
      "xmlns": _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.FRAMING,
      "to": this._conn.domain,
      "version": '1.0'
    });
  }

  /** PrivateFunction: _checkStreamError
   * _Private_ checks a message for stream:error
   *
   *  Parameters:
   *    (Strophe.Request) bodyWrap - The received stanza.
   *    connectstatus - The ConnectStatus that will be set on error.
   *  Returns:
   *     true if there was a streamerror, false otherwise.
   */
  _checkStreamError(bodyWrap, connectstatus) {
    let errors;
    if (bodyWrap.getElementsByTagNameNS) {
      errors = bodyWrap.getElementsByTagNameNS(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.STREAM, "error");
    } else {
      errors = bodyWrap.getElementsByTagName("stream:error");
    }
    if (errors.length === 0) {
      return false;
    }
    const error = errors[0];
    let condition = "";
    let text = "";
    const ns = "urn:ietf:params:xml:ns:xmpp-streams";
    for (let i = 0; i < error.childNodes.length; i++) {
      const e = error.childNodes[i];
      if (e.getAttribute("xmlns") !== ns) {
        break;
      }
      if (e.nodeName === "text") {
        text = e.textContent;
      } else {
        condition = e.nodeName;
      }
    }
    let errorString = "WebSocket stream error: ";
    if (condition) {
      errorString += condition;
    } else {
      errorString += "unknown";
    }
    if (text) {
      errorString += " - " + text;
    }
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error(errorString);

    // close the connection on stream_error
    this._conn._changeConnectStatus(connectstatus, condition);
    this._conn._doDisconnect();
    return true;
  }

  /** PrivateFunction: _reset
   *  Reset the connection.
   *
   *  This function is called by the reset function of the Strophe Connection.
   *  Is not needed by WebSockets.
   */
  _reset() {
    // eslint-disable-line class-methods-use-this
    return;
  }

  /** PrivateFunction: _connect
   *  _Private_ function called by Strophe.Connection.connect
   *
   *  Creates a WebSocket for a connection and assigns Callbacks to it.
   *  Does nothing if there already is a WebSocket.
   */
  _connect() {
    // Ensure that there is no open WebSocket from a previous Connection.
    this._closeSocket();
    this.socket = new _shims__WEBPACK_IMPORTED_MODULE_0__.WebSocket(this._conn.service, "xmpp");
    this.socket.onopen = () => this._onOpen();
    this.socket.onerror = e => this._onError(e);
    this.socket.onclose = e => this._onClose(e);
    // Gets replaced with this._onMessage once _onInitialMessage is called
    this.socket.onmessage = message => this._onInitialMessage(message);
  }

  /** PrivateFunction: _connect_cb
   *  _Private_ function called by Strophe.Connection._connect_cb
   *
   * checks for stream:error
   *
   *  Parameters:
   *    (Strophe.Request) bodyWrap - The received stanza.
   */
  _connect_cb(bodyWrap) {
    const error = this._checkStreamError(bodyWrap, _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL);
    if (error) {
      return _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL;
    }
  }

  /** PrivateFunction: _handleStreamStart
   * _Private_ function that checks the opening <open /> tag for errors.
   *
   * Disconnects if there is an error and returns false, true otherwise.
   *
   *  Parameters:
   *    (Node) message - Stanza containing the <open /> tag.
   */
  _handleStreamStart(message) {
    let error = false;

    // Check for errors in the <open /> tag
    const ns = message.getAttribute("xmlns");
    if (typeof ns !== "string") {
      error = "Missing xmlns in <open />";
    } else if (ns !== _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.FRAMING) {
      error = "Wrong xmlns in <open />: " + ns;
    }
    const ver = message.getAttribute("version");
    if (typeof ver !== "string") {
      error = "Missing version in <open />";
    } else if (ver !== "1.0") {
      error = "Wrong version in <open />: " + ver;
    }
    if (error) {
      this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, error);
      this._conn._doDisconnect();
      return false;
    }
    return true;
  }

  /** PrivateFunction: _onInitialMessage
   * _Private_ function that handles the first connection messages.
   *
   * On receiving an opening stream tag this callback replaces itself with the real
   * message handler. On receiving a stream error the connection is terminated.
   */
  _onInitialMessage(message) {
    if (message.data.indexOf("<open ") === 0 || message.data.indexOf("<?xml") === 0) {
      // Strip the XML Declaration, if there is one
      const data = message.data.replace(/^(<\?.*?\?>\s*)*/, "");
      if (data === '') return;
      const streamStart = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(data, "text/xml").documentElement;
      this._conn.xmlInput(streamStart);
      this._conn.rawInput(message.data);

      //_handleStreamSteart will check for XML errors and disconnect on error
      if (this._handleStreamStart(streamStart)) {
        //_connect_cb will check for stream:error and disconnect on error
        this._connect_cb(streamStart);
      }
    } else if (message.data.indexOf("<close ") === 0) {
      // <close xmlns="urn:ietf:params:xml:ns:xmpp-framing />
      // Parse the raw string to an XML element
      const parsedMessage = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(message.data, "text/xml").documentElement;
      // Report this input to the raw and xml handlers
      this._conn.xmlInput(parsedMessage);
      this._conn.rawInput(message.data);
      const see_uri = parsedMessage.getAttribute("see-other-uri");
      if (see_uri) {
        const service = this._conn.service;
        // Valid scenarios: WSS->WSS, WS->ANY
        const isSecureRedirect = service.indexOf("wss:") >= 0 && see_uri.indexOf("wss:") >= 0 || service.indexOf("ws:") >= 0;
        if (isSecureRedirect) {
          this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.REDIRECT, "Received see-other-uri, resetting connection");
          this._conn.reset();
          this._conn.service = see_uri;
          this._connect();
        }
      } else {
        this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "Received closing stream");
        this._conn._doDisconnect();
      }
    } else {
      this._replaceMessageHandler();
      const string = this._streamWrap(message.data);
      const elem = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(string, "text/xml").documentElement;
      this._conn._connect_cb(elem, null, message.data);
    }
  }

  /** PrivateFunction: _replaceMessageHandler
   *
   * Called by _onInitialMessage in order to replace itself with the general message handler.
   * This method is overridden by Strophe.WorkerWebsocket, which manages a
   * websocket connection via a service worker and doesn't have direct access
   * to the socket.
   */
  _replaceMessageHandler() {
    this.socket.onmessage = m => this._onMessage(m);
  }

  /** PrivateFunction: _disconnect
   *  _Private_ function called by Strophe.Connection.disconnect
   *
   *  Disconnects and sends a last stanza if one is given
   *
   *  Parameters:
   *    (Request) pres - This stanza will be sent before disconnecting.
   */
  _disconnect(pres) {
    if (this.socket && this.socket.readyState !== _shims__WEBPACK_IMPORTED_MODULE_0__.WebSocket.CLOSED) {
      if (pres) {
        this._conn.send(pres);
      }
      const close = (0,_core__WEBPACK_IMPORTED_MODULE_1__.$build)("close", {
        "xmlns": _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.FRAMING
      });
      this._conn.xmlOutput(close.tree());
      const closeString = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(close);
      this._conn.rawOutput(closeString);
      try {
        this.socket.send(closeString);
      } catch (e) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.warn("Couldn't send <close /> tag.");
      }
    }
    setTimeout(() => this._conn._doDisconnect, 0);
  }

  /** PrivateFunction: _doDisconnect
   *  _Private_ function to disconnect.
   *
   *  Just closes the Socket for WebSockets
   */
  _doDisconnect() {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("WebSockets _doDisconnect was called");
    this._closeSocket();
  }

  /** PrivateFunction _streamWrap
   *  _Private_ helper function to wrap a stanza in a <stream> tag.
   *  This is used so Strophe can process stanzas from WebSockets like BOSH
   */
  _streamWrap(stanza) {
    // eslint-disable-line class-methods-use-this
    return "<wrapper>" + stanza + '</wrapper>';
  }

  /** PrivateFunction: _closeSocket
   *  _Private_ function to close the WebSocket.
   *
   *  Closes the socket if it is still open and deletes it
   */
  _closeSocket() {
    if (this.socket) {
      try {
        this.socket.onclose = null;
        this.socket.onerror = null;
        this.socket.onmessage = null;
        this.socket.close();
      } catch (e) {
        _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug(e.message);
      }
    }
    this.socket = null;
  }

  /** PrivateFunction: _emptyQueue
   * _Private_ function to check if the message queue is empty.
   *
   *  Returns:
   *    True, because WebSocket messages are send immediately after queueing.
   */
  _emptyQueue() {
    // eslint-disable-line class-methods-use-this
    return true;
  }

  /** PrivateFunction: _onClose
   * _Private_ function to handle websockets closing.
   */
  _onClose(e) {
    if (this._conn.connected && !this._conn.disconnecting) {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Websocket closed unexpectedly");
      this._conn._doDisconnect();
    } else if (e && e.code === 1006 && !this._conn.connected && this.socket) {
      // in case the onError callback was not called (Safari 10 does not
      // call onerror when the initial connection fails) we need to
      // dispatch a CONNFAIL status update to be consistent with the
      // behavior on other browsers.
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Websocket closed unexcectedly");
      this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "The WebSocket connection could not be established or was disconnected.");
      this._conn._doDisconnect();
    } else {
      _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("Websocket closed");
    }
  }

  /** PrivateFunction: _no_auth_received
   *
   * Called on stream start/restart when no stream:features
   * has been received.
   */
  _no_auth_received(callback) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Server did not offer a supported authentication mechanism");
    this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.ErrorCondition.NO_AUTH_MECH);
    if (callback) {
      callback.call(this._conn);
    }
    this._conn._doDisconnect();
  }

  /** PrivateFunction: _onDisconnectTimeout
   *  _Private_ timeout handler for handling non-graceful disconnection.
   *
   *  This does nothing for WebSockets
   */
  _onDisconnectTimeout() {} // eslint-disable-line class-methods-use-this

  /** PrivateFunction: _abortAllRequests
   *  _Private_ helper function that makes sure all pending requests are aborted.
   */
  _abortAllRequests() {} // eslint-disable-line class-methods-use-this

  /** PrivateFunction: _onError
   * _Private_ function to handle websockets errors.
   *
   * Parameters:
   * (Object) error - The websocket error.
   */
  _onError(error) {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Websocket error " + JSON.stringify(error));
    this._conn._changeConnectStatus(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "The WebSocket connection could not be established or was disconnected.");
    this._disconnect();
  }

  /** PrivateFunction: _onIdle
   *  _Private_ function called by Strophe.Connection._onIdle
   *
   *  sends all queued stanzas
   */
  _onIdle() {
    const data = this._conn._data;
    if (data.length > 0 && !this._conn.paused) {
      for (let i = 0; i < data.length; i++) {
        if (data[i] !== null) {
          let stanza;
          if (data[i] === "restart") {
            stanza = this._buildStream().tree();
          } else {
            stanza = data[i];
          }
          const rawStanza = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(stanza);
          this._conn.xmlOutput(stanza);
          this._conn.rawOutput(rawStanza);
          this.socket.send(rawStanza);
        }
      }
      this._conn._data = [];
    }
  }

  /** PrivateFunction: _onMessage
   * _Private_ function to handle websockets messages.
   *
   * This function parses each of the messages as if they are full documents.
   * [TODO : We may actually want to use a SAX Push parser].
   *
   * Since all XMPP traffic starts with
   *  <stream:stream version='1.0'
   *                 xml:lang='en'
   *                 xmlns='jabber:client'
   *                 xmlns:stream='http://etherx.jabber.org/streams'
   *                 id='3697395463'
   *                 from='SERVER'>
   *
   * The first stanza will always fail to be parsed.
   *
   * Additionally, the seconds stanza will always be <stream:features> with
   * the stream NS defined in the previous stanza, so we need to 'force'
   * the inclusion of the NS in this stanza.
   *
   * Parameters:
   * (string) message - The websocket message.
   */
  _onMessage(message) {
    let elem;
    // check for closing stream
    const close = '<close xmlns="urn:ietf:params:xml:ns:xmpp-framing" />';
    if (message.data === close) {
      this._conn.rawInput(close);
      this._conn.xmlInput(message);
      if (!this._conn.disconnecting) {
        this._conn._doDisconnect();
      }
      return;
    } else if (message.data.search("<open ") === 0) {
      // This handles stream restarts
      elem = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(message.data, "text/xml").documentElement;
      if (!this._handleStreamStart(elem)) {
        return;
      }
    } else {
      const data = this._streamWrap(message.data);
      elem = new _shims__WEBPACK_IMPORTED_MODULE_0__.DOMParser().parseFromString(data, "text/xml").documentElement;
    }
    if (this._checkStreamError(elem, _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ERROR)) {
      return;
    }

    //handle unavailable presence stanza before disconnecting
    if (this._conn.disconnecting && elem.firstChild.nodeName === "presence" && elem.firstChild.getAttribute("type") === "unavailable") {
      this._conn.xmlInput(elem);
      this._conn.rawInput(_core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(elem));
      // if we are already disconnecting we will ignore the unavailable stanza and
      // wait for the </stream:stream> tag before we close the connection
      return;
    }
    this._conn._dataRecv(elem, message.data);
  }

  /** PrivateFunction: _onOpen
   * _Private_ function to handle websockets connection setup.
   *
   * The opening stream tag is sent here.
   */
  _onOpen() {
    _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("Websocket open");
    const start = this._buildStream();
    this._conn.xmlOutput(start.tree());
    const startString = _core__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(start);
    this._conn.rawOutput(startString);
    this.socket.send(startString);
  }

  /** PrivateFunction: _reqToData
   * _Private_ function to get a stanza out of a request.
   *
   * WebSockets don't use requests, so the passed argument is just returned.
   *
   *  Parameters:
   *    (Object) stanza - The stanza.
   *
   *  Returns:
   *    The stanza that was passed.
   */
  _reqToData(stanza) {
    // eslint-disable-line class-methods-use-this
    return stanza;
  }

  /** PrivateFunction: _send
   *  _Private_ part of the Connection.send function for WebSocket
   *
   * Just flushes the messages that are in the queue
   */
  _send() {
    this._conn.flush();
  }

  /** PrivateFunction: _sendRestart
   *
   *  Send an xmpp:restart stanza.
   */
  _sendRestart() {
    clearTimeout(this._conn._idleTimeout);
    this._conn._onIdle.bind(this._conn)();
  }
};

/***/ }),

/***/ "./node_modules/strophe.js/src/worker-websocket.js":
/*!*********************************************************!*\
  !*** ./node_modules/strophe.js/src/worker-websocket.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _websocket_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./websocket.js */ "./node_modules/strophe.js/src/websocket.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./core.js */ "./node_modules/strophe.js/src/core.js");
/*
    This program is distributed under the terms of the MIT license.
    Please see the LICENSE file for details.

    Copyright 2020, JC Brand
*/



const lmap = {};
lmap['debug'] = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.DEBUG;
lmap['info'] = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.INFO;
lmap['warn'] = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.WARN;
lmap['error'] = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.ERROR;
lmap['fatal'] = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.FATAL;

/** Class: Strophe.WorkerWebsocket
 *  _Private_ helper class that handles a websocket connection inside a shared worker.
 */
_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.WorkerWebsocket = class WorkerWebsocket extends _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Websocket {
  /** PrivateConstructor: Strophe.WorkerWebsocket
   *  Create and initialize a Strophe.WorkerWebsocket object.
   *
   *  Parameters:
   *    (Strophe.Connection) connection - The Strophe.Connection
   *
   *  Returns:
   *    A new Strophe.WorkerWebsocket object.
   */
  constructor(connection) {
    super(connection);
    this._conn = connection;
    this.worker = new SharedWorker(this._conn.options.worker, 'Strophe XMPP Connection');
    this.worker.onerror = e => {
      var _console;
      (_console = console) === null || _console === void 0 ? void 0 : _console.error(e);
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.log(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.ERROR, `Shared Worker Error: ${e}`);
    };
  }
  get socket() {
    return {
      'send': str => this.worker.port.postMessage(['send', str])
    };
  }
  _connect() {
    this._messageHandler = m => this._onInitialMessage(m);
    this.worker.port.start();
    this.worker.port.onmessage = ev => this._onWorkerMessage(ev);
    this.worker.port.postMessage(['_connect', this._conn.service, this._conn.jid]);
  }
  _attach(callback) {
    this._messageHandler = m => this._onMessage(m);
    this._conn.connect_callback = callback;
    this.worker.port.start();
    this.worker.port.onmessage = ev => this._onWorkerMessage(ev);
    this.worker.port.postMessage(['_attach', this._conn.service]);
  }
  _attachCallback(status, jid) {
    if (status === _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ATTACHED) {
      this._conn.jid = jid;
      this._conn.authenticated = true;
      this._conn.connected = true;
      this._conn.restored = true;
      this._conn._changeConnectStatus(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ATTACHED);
    } else if (status === _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ATTACHFAIL) {
      this._conn.authenticated = false;
      this._conn.connected = false;
      this._conn.restored = false;
      this._conn._changeConnectStatus(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.ATTACHFAIL);
    }
  }
  _disconnect(readyState, pres) {
    pres && this._conn.send(pres);
    const close = (0,_core_js__WEBPACK_IMPORTED_MODULE_1__.$build)("close", {
      "xmlns": _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.NS.FRAMING
    });
    this._conn.xmlOutput(close.tree());
    const closeString = _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.serialize(close);
    this._conn.rawOutput(closeString);
    this.worker.port.postMessage(['send', closeString]);
    this._conn._doDisconnect();
  }
  _onClose(e) {
    if (this._conn.connected && !this._conn.disconnecting) {
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Websocket closed unexpectedly");
      this._conn._doDisconnect();
    } else if (e && e.code === 1006 && !this._conn.connected) {
      // in case the onError callback was not called (Safari 10 does not
      // call onerror when the initial connection fails) we need to
      // dispatch a CONNFAIL status update to be consistent with the
      // behavior on other browsers.
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.error("Websocket closed unexcectedly");
      this._conn._changeConnectStatus(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.Status.CONNFAIL, "The WebSocket connection could not be established or was disconnected.");
      this._conn._doDisconnect();
    } else {
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.debug("Websocket closed");
    }
  }
  _closeSocket() {
    this.worker.port.postMessage(['_closeSocket']);
  }

  /** PrivateFunction: _replaceMessageHandler
   *
   * Called by _onInitialMessage in order to replace itself with the general message handler.
   * This method is overridden by Strophe.WorkerWebsocket, which manages a
   * websocket connection via a service worker and doesn't have direct access
   * to the socket.
   */
  _replaceMessageHandler() {
    this._messageHandler = m => this._onMessage(m);
  }

  /** PrivateFunction: _onWorkerMessage
   * _Private_ function that handles messages received from the service worker
   */
  _onWorkerMessage(ev) {
    const {
      data
    } = ev;
    const method_name = data[0];
    if (method_name === '_onMessage') {
      this._messageHandler(data[1]);
    } else if (method_name in this) {
      try {
        this[method_name].apply(this, ev.data.slice(1));
      } catch (e) {
        _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.log(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.ERROR, e);
      }
    } else if (method_name === 'log') {
      const level = data[1];
      const msg = data[2];
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.log(lmap[level], msg);
    } else {
      _core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.log(_core_js__WEBPACK_IMPORTED_MODULE_1__.Strophe.LogLevel.ERROR, `Found unhandled service worker message: ${data}`);
    }
  }
};

/***/ }),

/***/ "./node_modules/urijs/src/IPv6.js":
/*!****************************************!*\
  !*** ./node_modules/urijs/src/IPv6.js ***!
  \****************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 * IPv6 Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */

(function (root, factory) {
  'use strict';

  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if ( true && module.exports) {
    // Node
    module.exports = factory();
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this, function (root) {
  'use strict';

  /*
  var _in = "fe80:0000:0000:0000:0204:61ff:fe9d:f156";
  var _out = IPv6.best(_in);
  var _expected = "fe80::204:61ff:fe9d:f156";
   console.log(_in, _out, _expected, _out === _expected);
  */

  // save current IPv6 variable, if any
  var _IPv6 = root && root.IPv6;
  function bestPresentation(address) {
    // based on:
    // Javascript to test an IPv6 address for proper format, and to
    // present the "best text representation" according to IETF Draft RFC at
    // http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04
    // 8 Feb 2010 Rich Brown, Dartware, LLC
    // Please feel free to use this code as long as you provide a link to
    // http://www.intermapper.com
    // http://intermapper.com/support/tools/IPV6-Validator.aspx
    // http://download.dartware.com/thirdparty/ipv6validator.js

    var _address = address.toLowerCase();
    var segments = _address.split(':');
    var length = segments.length;
    var total = 8;

    // trim colons (:: or ::a:b:c… or …a:b:c::)
    if (segments[0] === '' && segments[1] === '' && segments[2] === '') {
      // must have been ::
      // remove first two items
      segments.shift();
      segments.shift();
    } else if (segments[0] === '' && segments[1] === '') {
      // must have been ::xxxx
      // remove the first item
      segments.shift();
    } else if (segments[length - 1] === '' && segments[length - 2] === '') {
      // must have been xxxx::
      segments.pop();
    }
    length = segments.length;

    // adjust total segments for IPv4 trailer
    if (segments[length - 1].indexOf('.') !== -1) {
      // found a "." which means IPv4
      total = 7;
    }

    // fill empty segments them with "0000"
    var pos;
    for (pos = 0; pos < length; pos++) {
      if (segments[pos] === '') {
        break;
      }
    }
    if (pos < total) {
      segments.splice(pos, 1, '0000');
      while (segments.length < total) {
        segments.splice(pos, 0, '0000');
      }
    }

    // strip leading zeros
    var _segments;
    for (var i = 0; i < total; i++) {
      _segments = segments[i].split('');
      for (var j = 0; j < 3; j++) {
        if (_segments[0] === '0' && _segments.length > 1) {
          _segments.splice(0, 1);
        } else {
          break;
        }
      }
      segments[i] = _segments.join('');
    }

    // find longest sequence of zeroes and coalesce them into one segment
    var best = -1;
    var _best = 0;
    var _current = 0;
    var current = -1;
    var inzeroes = false;
    // i; already declared

    for (i = 0; i < total; i++) {
      if (inzeroes) {
        if (segments[i] === '0') {
          _current += 1;
        } else {
          inzeroes = false;
          if (_current > _best) {
            best = current;
            _best = _current;
          }
        }
      } else {
        if (segments[i] === '0') {
          inzeroes = true;
          current = i;
          _current = 1;
        }
      }
    }
    if (_current > _best) {
      best = current;
      _best = _current;
    }
    if (_best > 1) {
      segments.splice(best, _best, '');
    }
    length = segments.length;

    // assemble remaining segments
    var result = '';
    if (segments[0] === '') {
      result = ':';
    }
    for (i = 0; i < length; i++) {
      result += segments[i];
      if (i === length - 1) {
        break;
      }
      result += ':';
    }
    if (segments[length - 1] === '') {
      result += ':';
    }
    return result;
  }
  function noConflict() {
    /*jshint validthis: true */
    if (root.IPv6 === this) {
      root.IPv6 = _IPv6;
    }
    return this;
  }
  return {
    best: bestPresentation,
    noConflict: noConflict
  };
});

/***/ }),

/***/ "./node_modules/urijs/src/SecondLevelDomains.js":
/*!******************************************************!*\
  !*** ./node_modules/urijs/src/SecondLevelDomains.js ***!
  \******************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 * Second Level Domain (SLD) Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */

(function (root, factory) {
  'use strict';

  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if ( true && module.exports) {
    // Node
    module.exports = factory();
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this, function (root) {
  'use strict';

  // save current SecondLevelDomains variable, if any
  var _SecondLevelDomains = root && root.SecondLevelDomains;
  var SLD = {
    // list of known Second Level Domains
    // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
    // ----
    // publicsuffix.org is more current and actually used by a couple of browsers internally.
    // downside is it also contains domains like "dyndns.org" - which is fine for the security
    // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
    // ----
    list: {
      'ac': ' com gov mil net org ',
      'ae': ' ac co gov mil name net org pro sch ',
      'af': ' com edu gov net org ',
      'al': ' com edu gov mil net org ',
      'ao': ' co ed gv it og pb ',
      'ar': ' com edu gob gov int mil net org tur ',
      'at': ' ac co gv or ',
      'au': ' asn com csiro edu gov id net org ',
      'ba': ' co com edu gov mil net org rs unbi unmo unsa untz unze ',
      'bb': ' biz co com edu gov info net org store tv ',
      'bh': ' biz cc com edu gov info net org ',
      'bn': ' com edu gov net org ',
      'bo': ' com edu gob gov int mil net org tv ',
      'br': ' adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ',
      'bs': ' com edu gov net org ',
      'bz': ' du et om ov rg ',
      'ca': ' ab bc mb nb nf nl ns nt nu on pe qc sk yk ',
      'ck': ' biz co edu gen gov info net org ',
      'cn': ' ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ',
      'co': ' com edu gov mil net nom org ',
      'cr': ' ac c co ed fi go or sa ',
      'cy': ' ac biz com ekloges gov ltd name net org parliament press pro tm ',
      'do': ' art com edu gob gov mil net org sld web ',
      'dz': ' art asso com edu gov net org pol ',
      'ec': ' com edu fin gov info med mil net org pro ',
      'eg': ' com edu eun gov mil name net org sci ',
      'er': ' com edu gov ind mil net org rochest w ',
      'es': ' com edu gob nom org ',
      'et': ' biz com edu gov info name net org ',
      'fj': ' ac biz com info mil name net org pro ',
      'fk': ' ac co gov net nom org ',
      'fr': ' asso com f gouv nom prd presse tm ',
      'gg': ' co net org ',
      'gh': ' com edu gov mil org ',
      'gn': ' ac com gov net org ',
      'gr': ' com edu gov mil net org ',
      'gt': ' com edu gob ind mil net org ',
      'gu': ' com edu gov net org ',
      'hk': ' com edu gov idv net org ',
      'hu': ' 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ',
      'id': ' ac co go mil net or sch web ',
      'il': ' ac co gov idf k12 muni net org ',
      'in': ' ac co edu ernet firm gen gov i ind mil net nic org res ',
      'iq': ' com edu gov i mil net org ',
      'ir': ' ac co dnssec gov i id net org sch ',
      'it': ' edu gov ',
      'je': ' co net org ',
      'jo': ' com edu gov mil name net org sch ',
      'jp': ' ac ad co ed go gr lg ne or ',
      'ke': ' ac co go info me mobi ne or sc ',
      'kh': ' com edu gov mil net org per ',
      'ki': ' biz com de edu gov info mob net org tel ',
      'km': ' asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ',
      'kn': ' edu gov net org ',
      'kr': ' ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ',
      'kw': ' com edu gov net org ',
      'ky': ' com edu gov net org ',
      'kz': ' com edu gov mil net org ',
      'lb': ' com edu gov net org ',
      'lk': ' assn com edu gov grp hotel int ltd net ngo org sch soc web ',
      'lr': ' com edu gov net org ',
      'lv': ' asn com conf edu gov id mil net org ',
      'ly': ' com edu gov id med net org plc sch ',
      'ma': ' ac co gov m net org press ',
      'mc': ' asso tm ',
      'me': ' ac co edu gov its net org priv ',
      'mg': ' com edu gov mil nom org prd tm ',
      'mk': ' com edu gov inf name net org pro ',
      'ml': ' com edu gov net org presse ',
      'mn': ' edu gov org ',
      'mo': ' com edu gov net org ',
      'mt': ' com edu gov net org ',
      'mv': ' aero biz com coop edu gov info int mil museum name net org pro ',
      'mw': ' ac co com coop edu gov int museum net org ',
      'mx': ' com edu gob net org ',
      'my': ' com edu gov mil name net org sch ',
      'nf': ' arts com firm info net other per rec store web ',
      'ng': ' biz com edu gov mil mobi name net org sch ',
      'ni': ' ac co com edu gob mil net nom org ',
      'np': ' com edu gov mil net org ',
      'nr': ' biz com edu gov info net org ',
      'om': ' ac biz co com edu gov med mil museum net org pro sch ',
      'pe': ' com edu gob mil net nom org sld ',
      'ph': ' com edu gov i mil net ngo org ',
      'pk': ' biz com edu fam gob gok gon gop gos gov net org web ',
      'pl': ' art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ',
      'pr': ' ac biz com edu est gov info isla name net org pro prof ',
      'ps': ' com edu gov net org plo sec ',
      'pw': ' belau co ed go ne or ',
      'ro': ' arts com firm info nom nt org rec store tm www ',
      'rs': ' ac co edu gov in org ',
      'sb': ' com edu gov net org ',
      'sc': ' com edu gov net org ',
      'sh': ' co com edu gov net nom org ',
      'sl': ' com edu gov net org ',
      'st': ' co com consulado edu embaixada gov mil net org principe saotome store ',
      'sv': ' com edu gob org red ',
      'sz': ' ac co org ',
      'tr': ' av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ',
      'tt': ' aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ',
      'tw': ' club com ebiz edu game gov idv mil net org ',
      'mu': ' ac co com gov net or org ',
      'mz': ' ac co edu gov org ',
      'na': ' co com ',
      'nz': ' ac co cri geek gen govt health iwi maori mil net org parliament school ',
      'pa': ' abo ac com edu gob ing med net nom org sld ',
      'pt': ' com edu gov int net nome org publ ',
      'py': ' com edu gov mil net org ',
      'qa': ' com edu gov mil net org ',
      're': ' asso com nom ',
      'ru': ' ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ',
      'rw': ' ac co com edu gouv gov int mil net ',
      'sa': ' com edu gov med net org pub sch ',
      'sd': ' com edu gov info med net org tv ',
      'se': ' a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ',
      'sg': ' com edu gov idn net org per ',
      'sn': ' art com edu gouv org perso univ ',
      'sy': ' com edu gov mil net news org ',
      'th': ' ac co go in mi net or ',
      'tj': ' ac biz co com edu go gov info int mil name net nic org test web ',
      'tn': ' agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ',
      'tz': ' ac co go ne or ',
      'ua': ' biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ',
      'ug': ' ac co go ne or org sc ',
      'uk': ' ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ',
      'us': ' dni fed isa kids nsn ',
      'uy': ' com edu gub mil net org ',
      've': ' co com edu gob info mil net org web ',
      'vi': ' co com k12 net org ',
      'vn': ' ac biz com edu gov health info int name net org pro ',
      'ye': ' co com gov ltd me net org plc ',
      'yu': ' ac co edu gov org ',
      'za': ' ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ',
      'zm': ' ac co com edu gov net org sch ',
      // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
      'com': 'ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ',
      'net': 'gb jp se uk ',
      'org': 'ae',
      'de': 'com '
    },
    // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
    // in both performance and memory footprint. No initialization required.
    // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
    // Following methods use lastIndexOf() rather than array.split() in order
    // to avoid any memory allocations.
    has: function (domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
        return false;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset - 1);
      if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
        return false;
      }
      var sldList = SLD.list[domain.slice(tldOffset + 1)];
      if (!sldList) {
        return false;
      }
      return sldList.indexOf(' ' + domain.slice(sldOffset + 1, tldOffset) + ' ') >= 0;
    },
    is: function (domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
        return false;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset - 1);
      if (sldOffset >= 0) {
        return false;
      }
      var sldList = SLD.list[domain.slice(tldOffset + 1)];
      if (!sldList) {
        return false;
      }
      return sldList.indexOf(' ' + domain.slice(0, tldOffset) + ' ') >= 0;
    },
    get: function (domain) {
      var tldOffset = domain.lastIndexOf('.');
      if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
        return null;
      }
      var sldOffset = domain.lastIndexOf('.', tldOffset - 1);
      if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
        return null;
      }
      var sldList = SLD.list[domain.slice(tldOffset + 1)];
      if (!sldList) {
        return null;
      }
      if (sldList.indexOf(' ' + domain.slice(sldOffset + 1, tldOffset) + ' ') < 0) {
        return null;
      }
      return domain.slice(sldOffset + 1);
    },
    noConflict: function () {
      if (root.SecondLevelDomains === this) {
        root.SecondLevelDomains = _SecondLevelDomains;
      }
      return this;
    }
  };
  return SLD;
});

/***/ }),

/***/ "./node_modules/urijs/src/URI.js":
/*!***************************************!*\
  !*** ./node_modules/urijs/src/URI.js ***!
  \***************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
(function (root, factory) {
  'use strict';

  // https://github.com/umdjs/umd/blob/master/returnExports.js
  if ( true && module.exports) {
    // Node
    module.exports = factory(__webpack_require__(/*! ./punycode */ "./node_modules/urijs/src/punycode.js"), __webpack_require__(/*! ./IPv6 */ "./node_modules/urijs/src/IPv6.js"), __webpack_require__(/*! ./SecondLevelDomains */ "./node_modules/urijs/src/SecondLevelDomains.js"));
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! ./punycode */ "./node_modules/urijs/src/punycode.js"), __webpack_require__(/*! ./IPv6 */ "./node_modules/urijs/src/IPv6.js"), __webpack_require__(/*! ./SecondLevelDomains */ "./node_modules/urijs/src/SecondLevelDomains.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this, function (punycode, IPv6, SLD, root) {
  'use strict';

  /*global location, escape, unescape */
  // FIXME: v2.0.0 renamce non-camelCase properties to uppercase
  /*jshint camelcase: false */

  // save current URI variable, if any
  var _URI = root && root.URI;
  function URI(url, base) {
    var _urlSupplied = arguments.length >= 1;
    var _baseSupplied = arguments.length >= 2;

    // Allow instantiation without the 'new' keyword
    if (!(this instanceof URI)) {
      if (_urlSupplied) {
        if (_baseSupplied) {
          return new URI(url, base);
        }
        return new URI(url);
      }
      return new URI();
    }
    if (url === undefined) {
      if (_urlSupplied) {
        throw new TypeError('undefined is not a valid argument for URI');
      }
      if (typeof location !== 'undefined') {
        url = location.href + '';
      } else {
        url = '';
      }
    }
    if (url === null) {
      if (_urlSupplied) {
        throw new TypeError('null is not a valid argument for URI');
      }
    }
    this.href(url);

    // resolve to base according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#constructor
    if (base !== undefined) {
      return this.absoluteTo(base);
    }
    return this;
  }
  function isInteger(value) {
    return /^[0-9]+$/.test(value);
  }
  URI.version = '1.19.11';
  var p = URI.prototype;
  var hasOwn = Object.prototype.hasOwnProperty;
  function escapeRegEx(string) {
    // https://github.com/medialize/URI.js/commit/85ac21783c11f8ccab06106dba9735a31a86924d#commitcomment-821963
    return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
  }
  function getType(value) {
    // IE8 doesn't return [Object Undefined] but [Object Object] for undefined value
    if (value === undefined) {
      return 'Undefined';
    }
    return String(Object.prototype.toString.call(value)).slice(8, -1);
  }
  function isArray(obj) {
    return getType(obj) === 'Array';
  }
  function filterArrayValues(data, value) {
    var lookup = {};
    var i, length;
    if (getType(value) === 'RegExp') {
      lookup = null;
    } else if (isArray(value)) {
      for (i = 0, length = value.length; i < length; i++) {
        lookup[value[i]] = true;
      }
    } else {
      lookup[value] = true;
    }
    for (i = 0, length = data.length; i < length; i++) {
      /*jshint laxbreak: true */
      var _match = lookup && lookup[data[i]] !== undefined || !lookup && value.test(data[i]);
      /*jshint laxbreak: false */
      if (_match) {
        data.splice(i, 1);
        length--;
        i--;
      }
    }
    return data;
  }
  function arrayContains(list, value) {
    var i, length;

    // value may be string, number, array, regexp
    if (isArray(value)) {
      // Note: this can be optimized to O(n) (instead of current O(m * n))
      for (i = 0, length = value.length; i < length; i++) {
        if (!arrayContains(list, value[i])) {
          return false;
        }
      }
      return true;
    }
    var _type = getType(value);
    for (i = 0, length = list.length; i < length; i++) {
      if (_type === 'RegExp') {
        if (typeof list[i] === 'string' && list[i].match(value)) {
          return true;
        }
      } else if (list[i] === value) {
        return true;
      }
    }
    return false;
  }
  function arraysEqual(one, two) {
    if (!isArray(one) || !isArray(two)) {
      return false;
    }

    // arrays can't be equal if they have different amount of content
    if (one.length !== two.length) {
      return false;
    }
    one.sort();
    two.sort();
    for (var i = 0, l = one.length; i < l; i++) {
      if (one[i] !== two[i]) {
        return false;
      }
    }
    return true;
  }
  function trimSlashes(text) {
    var trim_expression = /^\/+|\/+$/g;
    return text.replace(trim_expression, '');
  }
  URI._parts = function () {
    return {
      protocol: null,
      username: null,
      password: null,
      hostname: null,
      urn: null,
      port: null,
      path: null,
      query: null,
      fragment: null,
      // state
      preventInvalidHostname: URI.preventInvalidHostname,
      duplicateQueryParameters: URI.duplicateQueryParameters,
      escapeQuerySpace: URI.escapeQuerySpace
    };
  };
  // state: throw on invalid hostname
  // see https://github.com/medialize/URI.js/pull/345
  // and https://github.com/medialize/URI.js/issues/354
  URI.preventInvalidHostname = false;
  // state: allow duplicate query parameters (a=1&a=1)
  URI.duplicateQueryParameters = false;
  // state: replaces + with %20 (space in query strings)
  URI.escapeQuerySpace = true;
  // static properties
  URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
  URI.idn_expression = /[^a-z0-9\._-]/i;
  URI.punycode_expression = /(xn--)/i;
  // well, 333.444.555.666 matches, but it sure ain't no IPv4 - do we care?
  URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
  // credits to Rich Brown
  // source: http://forums.intermapper.com/viewtopic.php?p=1096#1096
  // specification: http://www.ietf.org/rfc/rfc4291.txt
  URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
  // expression used is "gruber revised" (@gruber v2) determined to be the
  // best solution in a regex-golf we did a couple of ages ago at
  // * http://mathiasbynens.be/demo/url-regex
  // * http://rodneyrehm.de/t/url-regex.html
  URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
  URI.findUri = {
    // valid "scheme://" or "www."
    start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
    // everything up to the next whitespace
    end: /[\s\r\n]|$/,
    // trim trailing punctuation captured by end RegExp
    trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
    // balanced parens inclusion (), [], {}, <>
    parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
  };
  URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
  // https://infra.spec.whatwg.org/#ascii-tab-or-newline
  URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
  // http://www.iana.org/assignments/uri-schemes.html
  // http://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers#Well-known_ports
  URI.defaultPorts = {
    http: '80',
    https: '443',
    ftp: '21',
    gopher: '70',
    ws: '80',
    wss: '443'
  };
  // list of protocols which always require a hostname
  URI.hostProtocols = ['http', 'https'];

  // allowed hostname characters according to RFC 3986
  // ALPHA DIGIT "-" "." "_" "~" "!" "$" "&" "'" "(" ")" "*" "+" "," ";" "=" %encoded
  // I've never seen a (non-IDN) hostname other than: ALPHA DIGIT . - _
  URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
  // map DOM Elements to their URI attribute
  URI.domAttributes = {
    'a': 'href',
    'blockquote': 'cite',
    'link': 'href',
    'base': 'href',
    'script': 'src',
    'form': 'action',
    'img': 'src',
    'area': 'href',
    'iframe': 'src',
    'embed': 'src',
    'source': 'src',
    'track': 'src',
    'input': 'src',
    // but only if type="image"
    'audio': 'src',
    'video': 'src'
  };
  URI.getDomAttribute = function (node) {
    if (!node || !node.nodeName) {
      return undefined;
    }
    var nodeName = node.nodeName.toLowerCase();
    // <input> should only expose src for type="image"
    if (nodeName === 'input' && node.type !== 'image') {
      return undefined;
    }
    return URI.domAttributes[nodeName];
  };
  function escapeForDumbFirefox36(value) {
    // https://github.com/medialize/URI.js/issues/91
    return escape(value);
  }

  // encoding / decoding according to RFC3986
  function strictEncodeURIComponent(string) {
    // see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/encodeURIComponent
    return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, '%2A');
  }
  URI.encode = strictEncodeURIComponent;
  URI.decode = decodeURIComponent;
  URI.iso8859 = function () {
    URI.encode = escape;
    URI.decode = unescape;
  };
  URI.unicode = function () {
    URI.encode = strictEncodeURIComponent;
    URI.decode = decodeURIComponent;
  };
  URI.characters = {
    pathname: {
      encode: {
        // RFC3986 2.1: For consistency, URI producers and normalizers should
        // use uppercase hexadecimal digits for all percent-encodings.
        expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
        map: {
          // -._~!'()*
          '%24': '$',
          '%26': '&',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '=',
          '%3A': ':',
          '%40': '@'
        }
      },
      decode: {
        expression: /[\/\?#]/g,
        map: {
          '/': '%2F',
          '?': '%3F',
          '#': '%23'
        }
      }
    },
    reserved: {
      encode: {
        // RFC3986 2.1: For consistency, URI producers and normalizers should
        // use uppercase hexadecimal digits for all percent-encodings.
        expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
        map: {
          // gen-delims
          '%3A': ':',
          '%2F': '/',
          '%3F': '?',
          '%23': '#',
          '%5B': '[',
          '%5D': ']',
          '%40': '@',
          // sub-delims
          '%21': '!',
          '%24': '$',
          '%26': '&',
          '%27': '\'',
          '%28': '(',
          '%29': ')',
          '%2A': '*',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '='
        }
      }
    },
    urnpath: {
      // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
      // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
      // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
      // note that the colon character is not featured in the encoding map; this is because URI.js
      // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
      // should not appear unencoded in a segment itself.
      // See also the note above about RFC3986 and capitalalized hex digits.
      encode: {
        expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
        map: {
          '%21': '!',
          '%24': '$',
          '%27': '\'',
          '%28': '(',
          '%29': ')',
          '%2A': '*',
          '%2B': '+',
          '%2C': ',',
          '%3B': ';',
          '%3D': '=',
          '%40': '@'
        }
      },
      // These characters are the characters called out by RFC2141 as "reserved" characters that
      // should never appear in a URN, plus the colon character (see note above).
      decode: {
        expression: /[\/\?#:]/g,
        map: {
          '/': '%2F',
          '?': '%3F',
          '#': '%23',
          ':': '%3A'
        }
      }
    }
  };
  URI.encodeQuery = function (string, escapeQuerySpace) {
    var escaped = URI.encode(string + '');
    if (escapeQuerySpace === undefined) {
      escapeQuerySpace = URI.escapeQuerySpace;
    }
    return escapeQuerySpace ? escaped.replace(/%20/g, '+') : escaped;
  };
  URI.decodeQuery = function (string, escapeQuerySpace) {
    string += '';
    if (escapeQuerySpace === undefined) {
      escapeQuerySpace = URI.escapeQuerySpace;
    }
    try {
      return URI.decode(escapeQuerySpace ? string.replace(/\+/g, '%20') : string);
    } catch (e) {
      // we're not going to mess with weird encodings,
      // give up and return the undecoded original string
      // see https://github.com/medialize/URI.js/issues/87
      // see https://github.com/medialize/URI.js/issues/92
      return string;
    }
  };
  // generate encode/decode path functions
  var _parts = {
    'encode': 'encode',
    'decode': 'decode'
  };
  var _part;
  var generateAccessor = function (_group, _part) {
    return function (string) {
      try {
        return URI[_part](string + '').replace(URI.characters[_group][_part].expression, function (c) {
          return URI.characters[_group][_part].map[c];
        });
      } catch (e) {
        // we're not going to mess with weird encodings,
        // give up and return the undecoded original string
        // see https://github.com/medialize/URI.js/issues/87
        // see https://github.com/medialize/URI.js/issues/92
        return string;
      }
    };
  };
  for (_part in _parts) {
    URI[_part + 'PathSegment'] = generateAccessor('pathname', _parts[_part]);
    URI[_part + 'UrnPathSegment'] = generateAccessor('urnpath', _parts[_part]);
  }
  var generateSegmentedPathFunction = function (_sep, _codingFuncName, _innerCodingFuncName) {
    return function (string) {
      // Why pass in names of functions, rather than the function objects themselves? The
      // definitions of some functions (but in particular, URI.decode) will occasionally change due
      // to URI.js having ISO8859 and Unicode modes. Passing in the name and getting it will ensure
      // that the functions we use here are "fresh".
      var actualCodingFunc;
      if (!_innerCodingFuncName) {
        actualCodingFunc = URI[_codingFuncName];
      } else {
        actualCodingFunc = function (string) {
          return URI[_codingFuncName](URI[_innerCodingFuncName](string));
        };
      }
      var segments = (string + '').split(_sep);
      for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = actualCodingFunc(segments[i]);
      }
      return segments.join(_sep);
    };
  };

  // This takes place outside the above loop because we don't want, e.g., encodeUrnPath functions.
  URI.decodePath = generateSegmentedPathFunction('/', 'decodePathSegment');
  URI.decodeUrnPath = generateSegmentedPathFunction(':', 'decodeUrnPathSegment');
  URI.recodePath = generateSegmentedPathFunction('/', 'encodePathSegment', 'decode');
  URI.recodeUrnPath = generateSegmentedPathFunction(':', 'encodeUrnPathSegment', 'decode');
  URI.encodeReserved = generateAccessor('reserved', 'encode');
  URI.parse = function (string, parts) {
    var pos;
    if (!parts) {
      parts = {
        preventInvalidHostname: URI.preventInvalidHostname
      };
    }
    string = string.replace(URI.leading_whitespace_expression, '');
    // https://infra.spec.whatwg.org/#ascii-tab-or-newline
    string = string.replace(URI.ascii_tab_whitespace, '');

    // [protocol"://"[username[":"password]"@"]hostname[":"port]"/"?][path]["?"querystring]["#"fragment]

    // extract fragment
    pos = string.indexOf('#');
    if (pos > -1) {
      // escaping?
      parts.fragment = string.substring(pos + 1) || null;
      string = string.substring(0, pos);
    }

    // extract query
    pos = string.indexOf('?');
    if (pos > -1) {
      // escaping?
      parts.query = string.substring(pos + 1) || null;
      string = string.substring(0, pos);
    }

    // slashes and backslashes have lost all meaning for the web protocols (https, http, wss, ws)
    string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, '$1://');
    // slashes and backslashes have lost all meaning for scheme relative URLs
    string = string.replace(/^[/\\]{2,}/i, '//');

    // extract protocol
    if (string.substring(0, 2) === '//') {
      // relative-scheme
      parts.protocol = null;
      string = string.substring(2);
      // extract "user:pass@host:port"
      string = URI.parseAuthority(string, parts);
    } else {
      pos = string.indexOf(':');
      if (pos > -1) {
        parts.protocol = string.substring(0, pos) || null;
        if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
          // : may be within the path
          parts.protocol = undefined;
        } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, '/') === '//') {
          string = string.substring(pos + 3);

          // extract "user:pass@host:port"
          string = URI.parseAuthority(string, parts);
        } else {
          string = string.substring(pos + 1);
          parts.urn = true;
        }
      }
    }

    // what's left must be the path
    parts.path = string;

    // and we're done
    return parts;
  };
  URI.parseHost = function (string, parts) {
    if (!string) {
      string = '';
    }

    // Copy chrome, IE, opera backslash-handling behavior.
    // Back slashes before the query string get converted to forward slashes
    // See: https://github.com/joyent/node/blob/386fd24f49b0e9d1a8a076592a404168faeecc34/lib/url.js#L115-L124
    // See: https://code.google.com/p/chromium/issues/detail?id=25916
    // https://github.com/medialize/URI.js/pull/233
    string = string.replace(/\\/g, '/');

    // extract host:port
    var pos = string.indexOf('/');
    var bracketPos;
    var t;
    if (pos === -1) {
      pos = string.length;
    }
    if (string.charAt(0) === '[') {
      // IPv6 host - http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04#section-6
      // I claim most client software breaks on IPv6 anyways. To simplify things, URI only accepts
      // IPv6+port in the format [2001:db8::1]:80 (for the time being)
      bracketPos = string.indexOf(']');
      parts.hostname = string.substring(1, bracketPos) || null;
      parts.port = string.substring(bracketPos + 2, pos) || null;
      if (parts.port === '/') {
        parts.port = null;
      }
    } else {
      var firstColon = string.indexOf(':');
      var firstSlash = string.indexOf('/');
      var nextColon = string.indexOf(':', firstColon + 1);
      if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
        // IPv6 host contains multiple colons - but no port
        // this notation is actually not allowed by RFC 3986, but we're a liberal parser
        parts.hostname = string.substring(0, pos) || null;
        parts.port = null;
      } else {
        t = string.substring(0, pos).split(':');
        parts.hostname = t[0] || null;
        parts.port = t[1] || null;
      }
    }
    if (parts.hostname && string.substring(pos).charAt(0) !== '/') {
      pos++;
      string = '/' + string;
    }
    if (parts.preventInvalidHostname) {
      URI.ensureValidHostname(parts.hostname, parts.protocol);
    }
    if (parts.port) {
      URI.ensureValidPort(parts.port);
    }
    return string.substring(pos) || '/';
  };
  URI.parseAuthority = function (string, parts) {
    string = URI.parseUserinfo(string, parts);
    return URI.parseHost(string, parts);
  };
  URI.parseUserinfo = function (string, parts) {
    // extract username:password
    var _string = string;
    var firstBackSlash = string.indexOf('\\');
    if (firstBackSlash !== -1) {
      string = string.replace(/\\/g, '/');
    }
    var firstSlash = string.indexOf('/');
    var pos = string.lastIndexOf('@', firstSlash > -1 ? firstSlash : string.length - 1);
    var t;

    // authority@ must come before /path or \path
    if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
      t = string.substring(0, pos).split(':');
      parts.username = t[0] ? URI.decode(t[0]) : null;
      t.shift();
      parts.password = t[0] ? URI.decode(t.join(':')) : null;
      string = _string.substring(pos + 1);
    } else {
      parts.username = null;
      parts.password = null;
    }
    return string;
  };
  URI.parseQuery = function (string, escapeQuerySpace) {
    if (!string) {
      return {};
    }

    // throw out the funky business - "?"[name"="value"&"]+
    string = string.replace(/&+/g, '&').replace(/^\?*&*|&+$/g, '');
    if (!string) {
      return {};
    }
    var items = {};
    var splits = string.split('&');
    var length = splits.length;
    var v, name, value;
    for (var i = 0; i < length; i++) {
      v = splits[i].split('=');
      name = URI.decodeQuery(v.shift(), escapeQuerySpace);
      // no "=" is null according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#collect-url-parameters
      value = v.length ? URI.decodeQuery(v.join('='), escapeQuerySpace) : null;
      if (name === '__proto__') {
        // ignore attempt at exploiting JavaScript internals
        continue;
      } else if (hasOwn.call(items, name)) {
        if (typeof items[name] === 'string' || items[name] === null) {
          items[name] = [items[name]];
        }
        items[name].push(value);
      } else {
        items[name] = value;
      }
    }
    return items;
  };
  URI.build = function (parts) {
    var t = '';
    var requireAbsolutePath = false;
    if (parts.protocol) {
      t += parts.protocol + ':';
    }
    if (!parts.urn && (t || parts.hostname)) {
      t += '//';
      requireAbsolutePath = true;
    }
    t += URI.buildAuthority(parts) || '';
    if (typeof parts.path === 'string') {
      if (parts.path.charAt(0) !== '/' && requireAbsolutePath) {
        t += '/';
      }
      t += parts.path;
    }
    if (typeof parts.query === 'string' && parts.query) {
      t += '?' + parts.query;
    }
    if (typeof parts.fragment === 'string' && parts.fragment) {
      t += '#' + parts.fragment;
    }
    return t;
  };
  URI.buildHost = function (parts) {
    var t = '';
    if (!parts.hostname) {
      return '';
    } else if (URI.ip6_expression.test(parts.hostname)) {
      t += '[' + parts.hostname + ']';
    } else {
      t += parts.hostname;
    }
    if (parts.port) {
      t += ':' + parts.port;
    }
    return t;
  };
  URI.buildAuthority = function (parts) {
    return URI.buildUserinfo(parts) + URI.buildHost(parts);
  };
  URI.buildUserinfo = function (parts) {
    var t = '';
    if (parts.username) {
      t += URI.encode(parts.username);
    }
    if (parts.password) {
      t += ':' + URI.encode(parts.password);
    }
    if (t) {
      t += '@';
    }
    return t;
  };
  URI.buildQuery = function (data, duplicateQueryParameters, escapeQuerySpace) {
    // according to http://tools.ietf.org/html/rfc3986 or http://labs.apache.org/webarch/uri/rfc/rfc3986.html
    // being »-._~!$&'()*+,;=:@/?« %HEX and alnum are allowed
    // the RFC explicitly states ?/foo being a valid use case, no mention of parameter syntax!
    // URI.js treats the query string as being application/x-www-form-urlencoded
    // see http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type

    var t = '';
    var unique, key, i, length;
    for (key in data) {
      if (key === '__proto__') {
        // ignore attempt at exploiting JavaScript internals
        continue;
      } else if (hasOwn.call(data, key)) {
        if (isArray(data[key])) {
          unique = {};
          for (i = 0, length = data[key].length; i < length; i++) {
            if (data[key][i] !== undefined && unique[data[key][i] + ''] === undefined) {
              t += '&' + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
              if (duplicateQueryParameters !== true) {
                unique[data[key][i] + ''] = true;
              }
            }
          }
        } else if (data[key] !== undefined) {
          t += '&' + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
        }
      }
    }
    return t.substring(1);
  };
  URI.buildQueryParameter = function (name, value, escapeQuerySpace) {
    // http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type -- application/x-www-form-urlencoded
    // don't append "=" for null values, according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#url-parameter-serialization
    return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? '=' + URI.encodeQuery(value, escapeQuerySpace) : '');
  };
  URI.addQuery = function (data, name, value) {
    if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          URI.addQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      if (data[name] === undefined) {
        data[name] = value;
        return;
      } else if (typeof data[name] === 'string') {
        data[name] = [data[name]];
      }
      if (!isArray(value)) {
        value = [value];
      }
      data[name] = (data[name] || []).concat(value);
    } else {
      throw new TypeError('URI.addQuery() accepts an object, string as the name parameter');
    }
  };
  URI.setQuery = function (data, name, value) {
    if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          URI.setQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      data[name] = value === undefined ? null : value;
    } else {
      throw new TypeError('URI.setQuery() accepts an object, string as the name parameter');
    }
  };
  URI.removeQuery = function (data, name, value) {
    var i, length, key;
    if (isArray(name)) {
      for (i = 0, length = name.length; i < length; i++) {
        data[name[i]] = undefined;
      }
    } else if (getType(name) === 'RegExp') {
      for (key in data) {
        if (name.test(key)) {
          data[key] = undefined;
        }
      }
    } else if (typeof name === 'object') {
      for (key in name) {
        if (hasOwn.call(name, key)) {
          URI.removeQuery(data, key, name[key]);
        }
      }
    } else if (typeof name === 'string') {
      if (value !== undefined) {
        if (getType(value) === 'RegExp') {
          if (!isArray(data[name]) && value.test(data[name])) {
            data[name] = undefined;
          } else {
            data[name] = filterArrayValues(data[name], value);
          }
        } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
          data[name] = undefined;
        } else if (isArray(data[name])) {
          data[name] = filterArrayValues(data[name], value);
        }
      } else {
        data[name] = undefined;
      }
    } else {
      throw new TypeError('URI.removeQuery() accepts an object, string, RegExp as the first parameter');
    }
  };
  URI.hasQuery = function (data, name, value, withinArray) {
    switch (getType(name)) {
      case 'String':
        // Nothing to do here
        break;
      case 'RegExp':
        for (var key in data) {
          if (hasOwn.call(data, key)) {
            if (name.test(key) && (value === undefined || URI.hasQuery(data, key, value))) {
              return true;
            }
          }
        }
        return false;
      case 'Object':
        for (var _key in name) {
          if (hasOwn.call(name, _key)) {
            if (!URI.hasQuery(data, _key, name[_key])) {
              return false;
            }
          }
        }
        return true;
      default:
        throw new TypeError('URI.hasQuery() accepts a string, regular expression or object as the name parameter');
    }
    switch (getType(value)) {
      case 'Undefined':
        // true if exists (but may be empty)
        return name in data;
      // data[name] !== undefined;

      case 'Boolean':
        // true if exists and non-empty
        var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
        return value === _booly;
      case 'Function':
        // allow complex comparison
        return !!value(data[name], name, data);
      case 'Array':
        if (!isArray(data[name])) {
          return false;
        }
        var op = withinArray ? arrayContains : arraysEqual;
        return op(data[name], value);
      case 'RegExp':
        if (!isArray(data[name])) {
          return Boolean(data[name] && data[name].match(value));
        }
        if (!withinArray) {
          return false;
        }
        return arrayContains(data[name], value);
      case 'Number':
        value = String(value);
      /* falls through */
      case 'String':
        if (!isArray(data[name])) {
          return data[name] === value;
        }
        if (!withinArray) {
          return false;
        }
        return arrayContains(data[name], value);
      default:
        throw new TypeError('URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter');
    }
  };
  URI.joinPaths = function () {
    var input = [];
    var segments = [];
    var nonEmptySegments = 0;
    for (var i = 0; i < arguments.length; i++) {
      var url = new URI(arguments[i]);
      input.push(url);
      var _segments = url.segment();
      for (var s = 0; s < _segments.length; s++) {
        if (typeof _segments[s] === 'string') {
          segments.push(_segments[s]);
        }
        if (_segments[s]) {
          nonEmptySegments++;
        }
      }
    }
    if (!segments.length || !nonEmptySegments) {
      return new URI('');
    }
    var uri = new URI('').segment(segments);
    if (input[0].path() === '' || input[0].path().slice(0, 1) === '/') {
      uri.path('/' + uri.path());
    }
    return uri.normalize();
  };
  URI.commonPath = function (one, two) {
    var length = Math.min(one.length, two.length);
    var pos;

    // find first non-matching character
    for (pos = 0; pos < length; pos++) {
      if (one.charAt(pos) !== two.charAt(pos)) {
        pos--;
        break;
      }
    }
    if (pos < 1) {
      return one.charAt(0) === two.charAt(0) && one.charAt(0) === '/' ? '/' : '';
    }

    // revert to last /
    if (one.charAt(pos) !== '/' || two.charAt(pos) !== '/') {
      pos = one.substring(0, pos).lastIndexOf('/');
    }
    return one.substring(0, pos + 1);
  };
  URI.withinString = function (string, callback, options) {
    options || (options = {});
    var _start = options.start || URI.findUri.start;
    var _end = options.end || URI.findUri.end;
    var _trim = options.trim || URI.findUri.trim;
    var _parens = options.parens || URI.findUri.parens;
    var _attributeOpen = /[a-z0-9-]=["']?$/i;
    _start.lastIndex = 0;
    while (true) {
      var match = _start.exec(string);
      if (!match) {
        break;
      }
      var start = match.index;
      if (options.ignoreHtml) {
        // attribut(e=["']?$)
        var attributeOpen = string.slice(Math.max(start - 3, 0), start);
        if (attributeOpen && _attributeOpen.test(attributeOpen)) {
          continue;
        }
      }
      var end = start + string.slice(start).search(_end);
      var slice = string.slice(start, end);
      // make sure we include well balanced parens
      var parensEnd = -1;
      while (true) {
        var parensMatch = _parens.exec(slice);
        if (!parensMatch) {
          break;
        }
        var parensMatchEnd = parensMatch.index + parensMatch[0].length;
        parensEnd = Math.max(parensEnd, parensMatchEnd);
      }
      if (parensEnd > -1) {
        slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, '');
      } else {
        slice = slice.replace(_trim, '');
      }
      if (slice.length <= match[0].length) {
        // the extract only contains the starting marker of a URI,
        // e.g. "www" or "http://"
        continue;
      }
      if (options.ignore && options.ignore.test(slice)) {
        continue;
      }
      end = start + slice.length;
      var result = callback(slice, start, end, string);
      if (result === undefined) {
        _start.lastIndex = end;
        continue;
      }
      result = String(result);
      string = string.slice(0, start) + result + string.slice(end);
      _start.lastIndex = start + result.length;
    }
    _start.lastIndex = 0;
    return string;
  };
  URI.ensureValidHostname = function (v, protocol) {
    // Theoretically URIs allow percent-encoding in Hostnames (according to RFC 3986)
    // they are not part of DNS and therefore ignored by URI.js

    var hasHostname = !!v; // not null and not an empty string
    var hasProtocol = !!protocol;
    var rejectEmptyHostname = false;
    if (hasProtocol) {
      rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
    }
    if (rejectEmptyHostname && !hasHostname) {
      throw new TypeError('Hostname cannot be empty, if protocol is ' + protocol);
    } else if (v && v.match(URI.invalid_hostname_characters)) {
      // test punycode
      if (!punycode) {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
      }
      if (punycode.toASCII(v).match(URI.invalid_hostname_characters)) {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-:_]');
      }
    }
  };
  URI.ensureValidPort = function (v) {
    if (!v) {
      return;
    }
    var port = Number(v);
    if (isInteger(port) && port > 0 && port < 65536) {
      return;
    }
    throw new TypeError('Port "' + v + '" is not a valid port');
  };

  // noConflict
  URI.noConflict = function (removeAll) {
    if (removeAll) {
      var unconflicted = {
        URI: this.noConflict()
      };
      if (root.URITemplate && typeof root.URITemplate.noConflict === 'function') {
        unconflicted.URITemplate = root.URITemplate.noConflict();
      }
      if (root.IPv6 && typeof root.IPv6.noConflict === 'function') {
        unconflicted.IPv6 = root.IPv6.noConflict();
      }
      if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === 'function') {
        unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
      }
      return unconflicted;
    } else if (root.URI === this) {
      root.URI = _URI;
    }
    return this;
  };
  p.build = function (deferBuild) {
    if (deferBuild === true) {
      this._deferred_build = true;
    } else if (deferBuild === undefined || this._deferred_build) {
      this._string = URI.build(this._parts);
      this._deferred_build = false;
    }
    return this;
  };
  p.clone = function () {
    return new URI(this);
  };
  p.valueOf = p.toString = function () {
    return this.build(false)._string;
  };
  function generateSimpleAccessor(_part) {
    return function (v, build) {
      if (v === undefined) {
        return this._parts[_part] || '';
      } else {
        this._parts[_part] = v || null;
        this.build(!build);
        return this;
      }
    };
  }
  function generatePrefixAccessor(_part, _key) {
    return function (v, build) {
      if (v === undefined) {
        return this._parts[_part] || '';
      } else {
        if (v !== null) {
          v = v + '';
          if (v.charAt(0) === _key) {
            v = v.substring(1);
          }
        }
        this._parts[_part] = v;
        this.build(!build);
        return this;
      }
    };
  }
  p.protocol = generateSimpleAccessor('protocol');
  p.username = generateSimpleAccessor('username');
  p.password = generateSimpleAccessor('password');
  p.hostname = generateSimpleAccessor('hostname');
  p.port = generateSimpleAccessor('port');
  p.query = generatePrefixAccessor('query', '?');
  p.fragment = generatePrefixAccessor('fragment', '#');
  p.search = function (v, build) {
    var t = this.query(v, build);
    return typeof t === 'string' && t.length ? '?' + t : t;
  };
  p.hash = function (v, build) {
    var t = this.fragment(v, build);
    return typeof t === 'string' && t.length ? '#' + t : t;
  };
  p.pathname = function (v, build) {
    if (v === undefined || v === true) {
      var res = this._parts.path || (this._parts.hostname ? '/' : '');
      return v ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
    } else {
      if (this._parts.urn) {
        this._parts.path = v ? URI.recodeUrnPath(v) : '';
      } else {
        this._parts.path = v ? URI.recodePath(v) : '/';
      }
      this.build(!build);
      return this;
    }
  };
  p.path = p.pathname;
  p.href = function (href, build) {
    var key;
    if (href === undefined) {
      return this.toString();
    }
    this._string = '';
    this._parts = URI._parts();
    var _URI = href instanceof URI;
    var _object = typeof href === 'object' && (href.hostname || href.path || href.pathname);
    if (href.nodeName) {
      var attribute = URI.getDomAttribute(href);
      href = href[attribute] || '';
      _object = false;
    }

    // window.location is reported to be an object, but it's not the sort
    // of object we're looking for:
    // * location.protocol ends with a colon
    // * location.query != object.search
    // * location.hash != object.fragment
    // simply serializing the unknown object should do the trick
    // (for location, not for everything...)
    if (!_URI && _object && href.pathname !== undefined) {
      href = href.toString();
    }
    if (typeof href === 'string' || href instanceof String) {
      this._parts = URI.parse(String(href), this._parts);
    } else if (_URI || _object) {
      var src = _URI ? href._parts : href;
      for (key in src) {
        if (key === 'query') {
          continue;
        }
        if (hasOwn.call(this._parts, key)) {
          this._parts[key] = src[key];
        }
      }
      if (src.query) {
        this.query(src.query, false);
      }
    } else {
      throw new TypeError('invalid input');
    }
    this.build(!build);
    return this;
  };

  // identification accessors
  p.is = function (what) {
    var ip = false;
    var ip4 = false;
    var ip6 = false;
    var name = false;
    var sld = false;
    var idn = false;
    var punycode = false;
    var relative = !this._parts.urn;
    if (this._parts.hostname) {
      relative = false;
      ip4 = URI.ip4_expression.test(this._parts.hostname);
      ip6 = URI.ip6_expression.test(this._parts.hostname);
      ip = ip4 || ip6;
      name = !ip;
      sld = name && SLD && SLD.has(this._parts.hostname);
      idn = name && URI.idn_expression.test(this._parts.hostname);
      punycode = name && URI.punycode_expression.test(this._parts.hostname);
    }
    switch (what.toLowerCase()) {
      case 'relative':
        return relative;
      case 'absolute':
        return !relative;

      // hostname identification
      case 'domain':
      case 'name':
        return name;
      case 'sld':
        return sld;
      case 'ip':
        return ip;
      case 'ip4':
      case 'ipv4':
      case 'inet4':
        return ip4;
      case 'ip6':
      case 'ipv6':
      case 'inet6':
        return ip6;
      case 'idn':
        return idn;
      case 'url':
        return !this._parts.urn;
      case 'urn':
        return !!this._parts.urn;
      case 'punycode':
        return punycode;
    }
    return null;
  };

  // component specific input validation
  var _protocol = p.protocol;
  var _port = p.port;
  var _hostname = p.hostname;
  p.protocol = function (v, build) {
    if (v) {
      // accept trailing ://
      v = v.replace(/:(\/\/)?$/, '');
      if (!v.match(URI.protocol_expression)) {
        throw new TypeError('Protocol "' + v + '" contains characters other than [A-Z0-9.+-] or doesn\'t start with [A-Z]');
      }
    }
    return _protocol.call(this, v, build);
  };
  p.scheme = p.protocol;
  p.port = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v !== undefined) {
      if (v === 0) {
        v = null;
      }
      if (v) {
        v += '';
        if (v.charAt(0) === ':') {
          v = v.substring(1);
        }
        URI.ensureValidPort(v);
      }
    }
    return _port.call(this, v, build);
  };
  p.hostname = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v !== undefined) {
      var x = {
        preventInvalidHostname: this._parts.preventInvalidHostname
      };
      var res = URI.parseHost(v, x);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }
      v = x.hostname;
      if (this._parts.preventInvalidHostname) {
        URI.ensureValidHostname(v, this._parts.protocol);
      }
    }
    return _hostname.call(this, v, build);
  };

  // compound accessors
  p.origin = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined) {
      var protocol = this.protocol();
      var authority = this.authority();
      if (!authority) {
        return '';
      }
      return (protocol ? protocol + '://' : '') + this.authority();
    } else {
      var origin = URI(v);
      this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
      return this;
    }
  };
  p.host = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined) {
      return this._parts.hostname ? URI.buildHost(this._parts) : '';
    } else {
      var res = URI.parseHost(v, this._parts);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }
      this.build(!build);
      return this;
    }
  };
  p.authority = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined) {
      return this._parts.hostname ? URI.buildAuthority(this._parts) : '';
    } else {
      var res = URI.parseAuthority(v, this._parts);
      if (res !== '/') {
        throw new TypeError('Hostname "' + v + '" contains characters other than [A-Z0-9.-]');
      }
      this.build(!build);
      return this;
    }
  };
  p.userinfo = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined) {
      var t = URI.buildUserinfo(this._parts);
      return t ? t.substring(0, t.length - 1) : t;
    } else {
      if (v[v.length - 1] !== '@') {
        v += '@';
      }
      URI.parseUserinfo(v, this._parts);
      this.build(!build);
      return this;
    }
  };
  p.resource = function (v, build) {
    var parts;
    if (v === undefined) {
      return this.path() + this.search() + this.hash();
    }
    parts = URI.parse(v);
    this._parts.path = parts.path;
    this._parts.query = parts.query;
    this._parts.fragment = parts.fragment;
    this.build(!build);
    return this;
  };

  // fraction accessors
  p.subdomain = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }

    // convenience, return "www" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }

      // grab domain and add another segment
      var end = this._parts.hostname.length - this.domain().length - 1;
      return this._parts.hostname.substring(0, end) || '';
    } else {
      var e = this._parts.hostname.length - this.domain().length;
      var sub = this._parts.hostname.substring(0, e);
      var replace = new RegExp('^' + escapeRegEx(sub));
      if (v && v.charAt(v.length - 1) !== '.') {
        v += '.';
      }
      if (v.indexOf(':') !== -1) {
        throw new TypeError('Domains cannot contain colons');
      }
      if (v) {
        URI.ensureValidHostname(v, this._parts.protocol);
      }
      this._parts.hostname = this._parts.hostname.replace(replace, v);
      this.build(!build);
      return this;
    }
  };
  p.domain = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (typeof v === 'boolean') {
      build = v;
      v = undefined;
    }

    // convenience, return "example.org" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }

      // if hostname consists of 1 or 2 segments, it must be the domain
      var t = this._parts.hostname.match(/\./g);
      if (t && t.length < 2) {
        return this._parts.hostname;
      }

      // grab tld and add another segment
      var end = this._parts.hostname.length - this.tld(build).length - 1;
      end = this._parts.hostname.lastIndexOf('.', end - 1) + 1;
      return this._parts.hostname.substring(end) || '';
    } else {
      if (!v) {
        throw new TypeError('cannot set domain empty');
      }
      if (v.indexOf(':') !== -1) {
        throw new TypeError('Domains cannot contain colons');
      }
      URI.ensureValidHostname(v, this._parts.protocol);
      if (!this._parts.hostname || this.is('IP')) {
        this._parts.hostname = v;
      } else {
        var replace = new RegExp(escapeRegEx(this.domain()) + '$');
        this._parts.hostname = this._parts.hostname.replace(replace, v);
      }
      this.build(!build);
      return this;
    }
  };
  p.tld = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (typeof v === 'boolean') {
      build = v;
      v = undefined;
    }

    // return "org" from "www.example.org"
    if (v === undefined) {
      if (!this._parts.hostname || this.is('IP')) {
        return '';
      }
      var pos = this._parts.hostname.lastIndexOf('.');
      var tld = this._parts.hostname.substring(pos + 1);
      if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
        return SLD.get(this._parts.hostname) || tld;
      }
      return tld;
    } else {
      var replace;
      if (!v) {
        throw new TypeError('cannot set TLD empty');
      } else if (v.match(/[^a-zA-Z0-9-]/)) {
        if (SLD && SLD.is(v)) {
          replace = new RegExp(escapeRegEx(this.tld()) + '$');
          this._parts.hostname = this._parts.hostname.replace(replace, v);
        } else {
          throw new TypeError('TLD "' + v + '" contains characters other than [A-Z0-9]');
        }
      } else if (!this._parts.hostname || this.is('IP')) {
        throw new ReferenceError('cannot set TLD on non-domain host');
      } else {
        replace = new RegExp(escapeRegEx(this.tld()) + '$');
        this._parts.hostname = this._parts.hostname.replace(replace, v);
      }
      this.build(!build);
      return this;
    }
  };
  p.directory = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined || v === true) {
      if (!this._parts.path && !this._parts.hostname) {
        return '';
      }
      if (this._parts.path === '/') {
        return '/';
      }
      var end = this._parts.path.length - this.filename().length - 1;
      var res = this._parts.path.substring(0, end) || (this._parts.hostname ? '/' : '');
      return v ? URI.decodePath(res) : res;
    } else {
      var e = this._parts.path.length - this.filename().length;
      var directory = this._parts.path.substring(0, e);
      var replace = new RegExp('^' + escapeRegEx(directory));

      // fully qualifier directories begin with a slash
      if (!this.is('relative')) {
        if (!v) {
          v = '/';
        }
        if (v.charAt(0) !== '/') {
          v = '/' + v;
        }
      }

      // directories always end with a slash
      if (v && v.charAt(v.length - 1) !== '/') {
        v += '/';
      }
      v = URI.recodePath(v);
      this._parts.path = this._parts.path.replace(replace, v);
      this.build(!build);
      return this;
    }
  };
  p.filename = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (typeof v !== 'string') {
      if (!this._parts.path || this._parts.path === '/') {
        return '';
      }
      var pos = this._parts.path.lastIndexOf('/');
      var res = this._parts.path.substring(pos + 1);
      return v ? URI.decodePathSegment(res) : res;
    } else {
      var mutatedDirectory = false;
      if (v.charAt(0) === '/') {
        v = v.substring(1);
      }
      if (v.match(/\.?\//)) {
        mutatedDirectory = true;
      }
      var replace = new RegExp(escapeRegEx(this.filename()) + '$');
      v = URI.recodePath(v);
      this._parts.path = this._parts.path.replace(replace, v);
      if (mutatedDirectory) {
        this.normalizePath(build);
      } else {
        this.build(!build);
      }
      return this;
    }
  };
  p.suffix = function (v, build) {
    if (this._parts.urn) {
      return v === undefined ? '' : this;
    }
    if (v === undefined || v === true) {
      if (!this._parts.path || this._parts.path === '/') {
        return '';
      }
      var filename = this.filename();
      var pos = filename.lastIndexOf('.');
      var s, res;
      if (pos === -1) {
        return '';
      }

      // suffix may only contain alnum characters (yup, I made this up.)
      s = filename.substring(pos + 1);
      res = /^[a-z0-9%]+$/i.test(s) ? s : '';
      return v ? URI.decodePathSegment(res) : res;
    } else {
      if (v.charAt(0) === '.') {
        v = v.substring(1);
      }
      var suffix = this.suffix();
      var replace;
      if (!suffix) {
        if (!v) {
          return this;
        }
        this._parts.path += '.' + URI.recodePath(v);
      } else if (!v) {
        replace = new RegExp(escapeRegEx('.' + suffix) + '$');
      } else {
        replace = new RegExp(escapeRegEx(suffix) + '$');
      }
      if (replace) {
        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);
      }
      this.build(!build);
      return this;
    }
  };
  p.segment = function (segment, v, build) {
    var separator = this._parts.urn ? ':' : '/';
    var path = this.path();
    var absolute = path.substring(0, 1) === '/';
    var segments = path.split(separator);
    if (segment !== undefined && typeof segment !== 'number') {
      build = v;
      v = segment;
      segment = undefined;
    }
    if (segment !== undefined && typeof segment !== 'number') {
      throw new Error('Bad segment "' + segment + '", must be 0-based integer');
    }
    if (absolute) {
      segments.shift();
    }
    if (segment < 0) {
      // allow negative indexes to address from the end
      segment = Math.max(segments.length + segment, 0);
    }
    if (v === undefined) {
      /*jshint laxbreak: true */
      return segment === undefined ? segments : segments[segment];
      /*jshint laxbreak: false */
    } else if (segment === null || segments[segment] === undefined) {
      if (isArray(v)) {
        segments = [];
        // collapse empty elements within array
        for (var i = 0, l = v.length; i < l; i++) {
          if (!v[i].length && (!segments.length || !segments[segments.length - 1].length)) {
            continue;
          }
          if (segments.length && !segments[segments.length - 1].length) {
            segments.pop();
          }
          segments.push(trimSlashes(v[i]));
        }
      } else if (v || typeof v === 'string') {
        v = trimSlashes(v);
        if (segments[segments.length - 1] === '') {
          // empty trailing elements have to be overwritten
          // to prevent results such as /foo//bar
          segments[segments.length - 1] = v;
        } else {
          segments.push(v);
        }
      }
    } else {
      if (v) {
        segments[segment] = trimSlashes(v);
      } else {
        segments.splice(segment, 1);
      }
    }
    if (absolute) {
      segments.unshift('');
    }
    return this.path(segments.join(separator), build);
  };
  p.segmentCoded = function (segment, v, build) {
    var segments, i, l;
    if (typeof segment !== 'number') {
      build = v;
      v = segment;
      segment = undefined;
    }
    if (v === undefined) {
      segments = this.segment(segment, v, build);
      if (!isArray(segments)) {
        segments = segments !== undefined ? URI.decode(segments) : undefined;
      } else {
        for (i = 0, l = segments.length; i < l; i++) {
          segments[i] = URI.decode(segments[i]);
        }
      }
      return segments;
    }
    if (!isArray(v)) {
      v = typeof v === 'string' || v instanceof String ? URI.encode(v) : v;
    } else {
      for (i = 0, l = v.length; i < l; i++) {
        v[i] = URI.encode(v[i]);
      }
    }
    return this.segment(segment, v, build);
  };

  // mutating query string
  var q = p.query;
  p.query = function (v, build) {
    if (v === true) {
      return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    } else if (typeof v === 'function') {
      var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
      var result = v.call(this, data);
      this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
      this.build(!build);
      return this;
    } else if (v !== undefined && typeof v !== 'string') {
      this._parts.query = URI.buildQuery(v, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
      this.build(!build);
      return this;
    } else {
      return q.call(this, v, build);
    }
  };
  p.setQuery = function (name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    if (typeof name === 'string' || name instanceof String) {
      data[name] = value !== undefined ? value : null;
    } else if (typeof name === 'object') {
      for (var key in name) {
        if (hasOwn.call(name, key)) {
          data[key] = name[key];
        }
      }
    } else {
      throw new TypeError('URI.addQuery() accepts an object, string as the name parameter');
    }
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }
    this.build(!build);
    return this;
  };
  p.addQuery = function (name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.addQuery(data, name, value === undefined ? null : value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }
    this.build(!build);
    return this;
  };
  p.removeQuery = function (name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.removeQuery(data, name, value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== 'string') {
      build = value;
    }
    this.build(!build);
    return this;
  };
  p.hasQuery = function (name, value, withinArray) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    return URI.hasQuery(data, name, value, withinArray);
  };
  p.setSearch = p.setQuery;
  p.addSearch = p.addQuery;
  p.removeSearch = p.removeQuery;
  p.hasSearch = p.hasQuery;

  // sanitizing URLs
  p.normalize = function () {
    if (this._parts.urn) {
      return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
    }
    return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
  };
  p.normalizeProtocol = function (build) {
    if (typeof this._parts.protocol === 'string') {
      this._parts.protocol = this._parts.protocol.toLowerCase();
      this.build(!build);
    }
    return this;
  };
  p.normalizeHostname = function (build) {
    if (this._parts.hostname) {
      if (this.is('IDN') && punycode) {
        this._parts.hostname = punycode.toASCII(this._parts.hostname);
      } else if (this.is('IPv6') && IPv6) {
        this._parts.hostname = IPv6.best(this._parts.hostname);
      }
      this._parts.hostname = this._parts.hostname.toLowerCase();
      this.build(!build);
    }
    return this;
  };
  p.normalizePort = function (build) {
    // remove port of it's the protocol's default
    if (typeof this._parts.protocol === 'string' && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
      this._parts.port = null;
      this.build(!build);
    }
    return this;
  };
  p.normalizePath = function (build) {
    var _path = this._parts.path;
    if (!_path) {
      return this;
    }
    if (this._parts.urn) {
      this._parts.path = URI.recodeUrnPath(this._parts.path);
      this.build(!build);
      return this;
    }
    if (this._parts.path === '/') {
      return this;
    }
    _path = URI.recodePath(_path);
    var _was_relative;
    var _leadingParents = '';
    var _parent, _pos;

    // handle relative paths
    if (_path.charAt(0) !== '/') {
      _was_relative = true;
      _path = '/' + _path;
    }

    // handle relative files (as opposed to directories)
    if (_path.slice(-3) === '/..' || _path.slice(-2) === '/.') {
      _path += '/';
    }

    // resolve simples
    _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, '/').replace(/\/{2,}/g, '/');

    // remember leading parents
    if (_was_relative) {
      _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || '';
      if (_leadingParents) {
        _leadingParents = _leadingParents[0];
      }
    }

    // resolve parents
    while (true) {
      _parent = _path.search(/\/\.\.(\/|$)/);
      if (_parent === -1) {
        // no more ../ to resolve
        break;
      } else if (_parent === 0) {
        // top level cannot be relative, skip it
        _path = _path.substring(3);
        continue;
      }
      _pos = _path.substring(0, _parent).lastIndexOf('/');
      if (_pos === -1) {
        _pos = _parent;
      }
      _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
    }

    // revert to relative
    if (_was_relative && this.is('relative')) {
      _path = _leadingParents + _path.substring(1);
    }
    this._parts.path = _path;
    this.build(!build);
    return this;
  };
  p.normalizePathname = p.normalizePath;
  p.normalizeQuery = function (build) {
    if (typeof this._parts.query === 'string') {
      if (!this._parts.query.length) {
        this._parts.query = null;
      } else {
        this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
      }
      this.build(!build);
    }
    return this;
  };
  p.normalizeFragment = function (build) {
    if (!this._parts.fragment) {
      this._parts.fragment = null;
      this.build(!build);
    }
    return this;
  };
  p.normalizeSearch = p.normalizeQuery;
  p.normalizeHash = p.normalizeFragment;
  p.iso8859 = function () {
    // expect unicode input, iso8859 output
    var e = URI.encode;
    var d = URI.decode;
    URI.encode = escape;
    URI.decode = decodeURIComponent;
    try {
      this.normalize();
    } finally {
      URI.encode = e;
      URI.decode = d;
    }
    return this;
  };
  p.unicode = function () {
    // expect iso8859 input, unicode output
    var e = URI.encode;
    var d = URI.decode;
    URI.encode = strictEncodeURIComponent;
    URI.decode = unescape;
    try {
      this.normalize();
    } finally {
      URI.encode = e;
      URI.decode = d;
    }
    return this;
  };
  p.readable = function () {
    var uri = this.clone();
    // removing username, password, because they shouldn't be displayed according to RFC 3986
    uri.username('').password('').normalize();
    var t = '';
    if (uri._parts.protocol) {
      t += uri._parts.protocol + '://';
    }
    if (uri._parts.hostname) {
      if (uri.is('punycode') && punycode) {
        t += punycode.toUnicode(uri._parts.hostname);
        if (uri._parts.port) {
          t += ':' + uri._parts.port;
        }
      } else {
        t += uri.host();
      }
    }
    if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== '/') {
      t += '/';
    }
    t += uri.path(true);
    if (uri._parts.query) {
      var q = '';
      for (var i = 0, qp = uri._parts.query.split('&'), l = qp.length; i < l; i++) {
        var kv = (qp[i] || '').split('=');
        q += '&' + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, '%26');
        if (kv[1] !== undefined) {
          q += '=' + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, '%26');
        }
      }
      t += '?' + q.substring(1);
    }
    t += URI.decodeQuery(uri.hash(), true);
    return t;
  };

  // resolving relative and absolute URLs
  p.absoluteTo = function (base) {
    var resolved = this.clone();
    var properties = ['protocol', 'username', 'password', 'hostname', 'port'];
    var basedir, i, p;
    if (this._parts.urn) {
      throw new Error('URNs do not have any generally defined hierarchical components');
    }
    if (!(base instanceof URI)) {
      base = new URI(base);
    }
    if (resolved._parts.protocol) {
      // Directly returns even if this._parts.hostname is empty.
      return resolved;
    } else {
      resolved._parts.protocol = base._parts.protocol;
    }
    if (this._parts.hostname) {
      return resolved;
    }
    for (i = 0; p = properties[i]; i++) {
      resolved._parts[p] = base._parts[p];
    }
    if (!resolved._parts.path) {
      resolved._parts.path = base._parts.path;
      if (!resolved._parts.query) {
        resolved._parts.query = base._parts.query;
      }
    } else {
      if (resolved._parts.path.substring(-2) === '..') {
        resolved._parts.path += '/';
      }
      if (resolved.path().charAt(0) !== '/') {
        basedir = base.directory();
        basedir = basedir ? basedir : base.path().indexOf('/') === 0 ? '/' : '';
        resolved._parts.path = (basedir ? basedir + '/' : '') + resolved._parts.path;
        resolved.normalizePath();
      }
    }
    resolved.build();
    return resolved;
  };
  p.relativeTo = function (base) {
    var relative = this.clone().normalize();
    var relativeParts, baseParts, common, relativePath, basePath;
    if (relative._parts.urn) {
      throw new Error('URNs do not have any generally defined hierarchical components');
    }
    base = new URI(base).normalize();
    relativeParts = relative._parts;
    baseParts = base._parts;
    relativePath = relative.path();
    basePath = base.path();
    if (relativePath.charAt(0) !== '/') {
      throw new Error('URI is already relative');
    }
    if (basePath.charAt(0) !== '/') {
      throw new Error('Cannot calculate a URI relative to another relative URI');
    }
    if (relativeParts.protocol === baseParts.protocol) {
      relativeParts.protocol = null;
    }
    if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
      return relative.build();
    }
    if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
      return relative.build();
    }
    if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
      relativeParts.hostname = null;
      relativeParts.port = null;
    } else {
      return relative.build();
    }
    if (relativePath === basePath) {
      relativeParts.path = '';
      return relative.build();
    }

    // determine common sub path
    common = URI.commonPath(relativePath, basePath);

    // If the paths have nothing in common, return a relative URL with the absolute path.
    if (!common) {
      return relative.build();
    }
    var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, '').replace(/.*?\//g, '../');
    relativeParts.path = parents + relativeParts.path.substring(common.length) || './';
    return relative.build();
  };

  // comparing URIs
  p.equals = function (uri) {
    var one = this.clone();
    var two = new URI(uri);
    var one_map = {};
    var two_map = {};
    var checked = {};
    var one_query, two_query, key;
    one.normalize();
    two.normalize();

    // exact match
    if (one.toString() === two.toString()) {
      return true;
    }

    // extract query string
    one_query = one.query();
    two_query = two.query();
    one.query('');
    two.query('');

    // definitely not equal if not even non-query parts match
    if (one.toString() !== two.toString()) {
      return false;
    }

    // query parameters have the same length, even if they're permuted
    if (one_query.length !== two_query.length) {
      return false;
    }
    one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
    two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
    for (key in one_map) {
      if (hasOwn.call(one_map, key)) {
        if (!isArray(one_map[key])) {
          if (one_map[key] !== two_map[key]) {
            return false;
          }
        } else if (!arraysEqual(one_map[key], two_map[key])) {
          return false;
        }
        checked[key] = true;
      }
    }
    for (key in two_map) {
      if (hasOwn.call(two_map, key)) {
        if (!checked[key]) {
          // two contains a parameter not present in one
          return false;
        }
      }
    }
    return true;
  };

  // state
  p.preventInvalidHostname = function (v) {
    this._parts.preventInvalidHostname = !!v;
    return this;
  };
  p.duplicateQueryParameters = function (v) {
    this._parts.duplicateQueryParameters = !!v;
    return this;
  };
  p.escapeQuerySpace = function (v) {
    this._parts.escapeQuerySpace = !!v;
    return this;
  };
  return URI;
});

/***/ }),

/***/ "./node_modules/urijs/src/punycode.js":
/*!********************************************!*\
  !*** ./node_modules/urijs/src/punycode.js ***!
  \********************************************/
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_RESULT__;/*! https://mths.be/punycode v1.4.0 by @mathias */
;
(function (root) {
  /** Detect free variables */
  var freeExports =  true && exports && !exports.nodeType && exports;
  var freeModule =  true && module && !module.nodeType && module;
  var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g;
  if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
    root = freeGlobal;
  }

  /**
   * The `punycode` object.
   * @name punycode
   * @type Object
   */
  var punycode,
    /** Highest positive signed 32-bit float value */
    maxInt = 2147483647,
    // aka. 0x7FFFFFFF or 2^31-1

    /** Bootstring parameters */
    base = 36,
    tMin = 1,
    tMax = 26,
    skew = 38,
    damp = 700,
    initialBias = 72,
    initialN = 128,
    // 0x80
    delimiter = '-',
    // '\x2D'

    /** Regular expressions */
    regexPunycode = /^xn--/,
    regexNonASCII = /[^\x20-\x7E]/,
    // unprintable ASCII chars + non-ASCII chars
    regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g,
    // RFC 3490 separators

    /** Error messages */
    errors = {
      'overflow': 'Overflow: input needs wider integers to process',
      'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
      'invalid-input': 'Invalid input'
    },
    /** Convenience shortcuts */
    baseMinusTMin = base - tMin,
    floor = Math.floor,
    stringFromCharCode = String.fromCharCode,
    /** Temporary variable */
    key;

  /*--------------------------------------------------------------------------*/

  /**
   * A generic error utility function.
   * @private
   * @param {String} type The error type.
   * @returns {Error} Throws a `RangeError` with the applicable error message.
   */
  function error(type) {
    throw new RangeError(errors[type]);
  }

  /**
   * A generic `Array#map` utility function.
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} callback The function that gets called for every array
   * item.
   * @returns {Array} A new array of values returned by the callback function.
   */
  function map(array, fn) {
    var length = array.length;
    var result = [];
    while (length--) {
      result[length] = fn(array[length]);
    }
    return result;
  }

  /**
   * A simple `Array#map`-like wrapper to work with domain name strings or email
   * addresses.
   * @private
   * @param {String} domain The domain name or email address.
   * @param {Function} callback The function that gets called for every
   * character.
   * @returns {Array} A new string of characters returned by the callback
   * function.
   */
  function mapDomain(string, fn) {
    var parts = string.split('@');
    var result = '';
    if (parts.length > 1) {
      // In email addresses, only the domain name should be punycoded. Leave
      // the local part (i.e. everything up to `@`) intact.
      result = parts[0] + '@';
      string = parts[1];
    }
    // Avoid `split(regex)` for IE8 compatibility. See #17.
    string = string.replace(regexSeparators, '\x2E');
    var labels = string.split('.');
    var encoded = map(labels, fn).join('.');
    return result + encoded;
  }

  /**
   * Creates an array containing the numeric code points of each Unicode
   * character in the string. While JavaScript uses UCS-2 internally,
   * this function will convert a pair of surrogate halves (each of which
   * UCS-2 exposes as separate characters) into a single code point,
   * matching UTF-16.
   * @see `punycode.ucs2.encode`
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode.ucs2
   * @name decode
   * @param {String} string The Unicode input string (UCS-2).
   * @returns {Array} The new array of code points.
   */
  function ucs2decode(string) {
    var output = [],
      counter = 0,
      length = string.length,
      value,
      extra;
    while (counter < length) {
      value = string.charCodeAt(counter++);
      if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
        // high surrogate, and there is a next character
        extra = string.charCodeAt(counter++);
        if ((extra & 0xFC00) == 0xDC00) {
          // low surrogate
          output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
        } else {
          // unmatched surrogate; only append this code unit, in case the next
          // code unit is the high surrogate of a surrogate pair
          output.push(value);
          counter--;
        }
      } else {
        output.push(value);
      }
    }
    return output;
  }

  /**
   * Creates a string based on an array of numeric code points.
   * @see `punycode.ucs2.decode`
   * @memberOf punycode.ucs2
   * @name encode
   * @param {Array} codePoints The array of numeric code points.
   * @returns {String} The new Unicode string (UCS-2).
   */
  function ucs2encode(array) {
    return map(array, function (value) {
      var output = '';
      if (value > 0xFFFF) {
        value -= 0x10000;
        output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
        value = 0xDC00 | value & 0x3FF;
      }
      output += stringFromCharCode(value);
      return output;
    }).join('');
  }

  /**
   * Converts a basic code point into a digit/integer.
   * @see `digitToBasic()`
   * @private
   * @param {Number} codePoint The basic numeric code point value.
   * @returns {Number} The numeric value of a basic code point (for use in
   * representing integers) in the range `0` to `base - 1`, or `base` if
   * the code point does not represent a value.
   */
  function basicToDigit(codePoint) {
    if (codePoint - 48 < 10) {
      return codePoint - 22;
    }
    if (codePoint - 65 < 26) {
      return codePoint - 65;
    }
    if (codePoint - 97 < 26) {
      return codePoint - 97;
    }
    return base;
  }

  /**
   * Converts a digit/integer into a basic code point.
   * @see `basicToDigit()`
   * @private
   * @param {Number} digit The numeric value of a basic code point.
   * @returns {Number} The basic code point whose value (when used for
   * representing integers) is `digit`, which needs to be in the range
   * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
   * used; else, the lowercase form is used. The behavior is undefined
   * if `flag` is non-zero and `digit` has no uppercase form.
   */
  function digitToBasic(digit, flag) {
    //  0..25 map to ASCII a..z or A..Z
    // 26..35 map to ASCII 0..9
    return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
  }

  /**
   * Bias adaptation function as per section 3.4 of RFC 3492.
   * https://tools.ietf.org/html/rfc3492#section-3.4
   * @private
   */
  function adapt(delta, numPoints, firstTime) {
    var k = 0;
    delta = firstTime ? floor(delta / damp) : delta >> 1;
    delta += floor(delta / numPoints);
    for (; delta > baseMinusTMin * tMax >> 1; k += base) {
      delta = floor(delta / baseMinusTMin);
    }
    return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
  }

  /**
   * Converts a Punycode string of ASCII-only symbols to a string of Unicode
   * symbols.
   * @memberOf punycode
   * @param {String} input The Punycode string of ASCII-only symbols.
   * @returns {String} The resulting string of Unicode symbols.
   */
  function decode(input) {
    // Don't use UCS-2
    var output = [],
      inputLength = input.length,
      out,
      i = 0,
      n = initialN,
      bias = initialBias,
      basic,
      j,
      index,
      oldi,
      w,
      k,
      digit,
      t,
      /** Cached calculation results */
      baseMinusT;

    // Handle the basic code points: let `basic` be the number of input code
    // points before the last delimiter, or `0` if there is none, then copy
    // the first basic code points to the output.

    basic = input.lastIndexOf(delimiter);
    if (basic < 0) {
      basic = 0;
    }
    for (j = 0; j < basic; ++j) {
      // if it's not a basic code point
      if (input.charCodeAt(j) >= 0x80) {
        error('not-basic');
      }
      output.push(input.charCodeAt(j));
    }

    // Main decoding loop: start just after the last delimiter if any basic code
    // points were copied; start at the beginning otherwise.

    for (index = basic > 0 ? basic + 1 : 0; index < inputLength;) {
      // `index` is the index of the next character to be consumed.
      // Decode a generalized variable-length integer into `delta`,
      // which gets added to `i`. The overflow checking is easier
      // if we increase `i` as we go, then subtract off its starting
      // value at the end to obtain `delta`.
      for (oldi = i, w = 1, k = base;; k += base) {
        if (index >= inputLength) {
          error('invalid-input');
        }
        digit = basicToDigit(input.charCodeAt(index++));
        if (digit >= base || digit > floor((maxInt - i) / w)) {
          error('overflow');
        }
        i += digit * w;
        t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
        if (digit < t) {
          break;
        }
        baseMinusT = base - t;
        if (w > floor(maxInt / baseMinusT)) {
          error('overflow');
        }
        w *= baseMinusT;
      }
      out = output.length + 1;
      bias = adapt(i - oldi, out, oldi == 0);

      // `i` was supposed to wrap around from `out` to `0`,
      // incrementing `n` each time, so we'll fix that now:
      if (floor(i / out) > maxInt - n) {
        error('overflow');
      }
      n += floor(i / out);
      i %= out;

      // Insert `n` at position `i` of the output
      output.splice(i++, 0, n);
    }
    return ucs2encode(output);
  }

  /**
   * Converts a string of Unicode symbols (e.g. a domain name label) to a
   * Punycode string of ASCII-only symbols.
   * @memberOf punycode
   * @param {String} input The string of Unicode symbols.
   * @returns {String} The resulting Punycode string of ASCII-only symbols.
   */
  function encode(input) {
    var n,
      delta,
      handledCPCount,
      basicLength,
      bias,
      j,
      m,
      q,
      k,
      t,
      currentValue,
      output = [],
      /** `inputLength` will hold the number of code points in `input`. */
      inputLength,
      /** Cached calculation results */
      handledCPCountPlusOne,
      baseMinusT,
      qMinusT;

    // Convert the input in UCS-2 to Unicode
    input = ucs2decode(input);

    // Cache the length
    inputLength = input.length;

    // Initialize the state
    n = initialN;
    delta = 0;
    bias = initialBias;

    // Handle the basic code points
    for (j = 0; j < inputLength; ++j) {
      currentValue = input[j];
      if (currentValue < 0x80) {
        output.push(stringFromCharCode(currentValue));
      }
    }
    handledCPCount = basicLength = output.length;

    // `handledCPCount` is the number of code points that have been handled;
    // `basicLength` is the number of basic code points.

    // Finish the basic string - if it is not empty - with a delimiter
    if (basicLength) {
      output.push(delimiter);
    }

    // Main encoding loop:
    while (handledCPCount < inputLength) {
      // All non-basic code points < n have been handled already. Find the next
      // larger one:
      for (m = maxInt, j = 0; j < inputLength; ++j) {
        currentValue = input[j];
        if (currentValue >= n && currentValue < m) {
          m = currentValue;
        }
      }

      // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
      // but guard against overflow
      handledCPCountPlusOne = handledCPCount + 1;
      if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
        error('overflow');
      }
      delta += (m - n) * handledCPCountPlusOne;
      n = m;
      for (j = 0; j < inputLength; ++j) {
        currentValue = input[j];
        if (currentValue < n && ++delta > maxInt) {
          error('overflow');
        }
        if (currentValue == n) {
          // Represent delta as a generalized variable-length integer
          for (q = delta, k = base;; k += base) {
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (q < t) {
              break;
            }
            qMinusT = q - t;
            baseMinusT = base - t;
            output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
            q = floor(qMinusT / baseMinusT);
          }
          output.push(stringFromCharCode(digitToBasic(q, 0)));
          bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
          delta = 0;
          ++handledCPCount;
        }
      }
      ++delta;
      ++n;
    }
    return output.join('');
  }

  /**
   * Converts a Punycode string representing a domain name or an email address
   * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
   * it doesn't matter if you call it on a string that has already been
   * converted to Unicode.
   * @memberOf punycode
   * @param {String} input The Punycoded domain name or email address to
   * convert to Unicode.
   * @returns {String} The Unicode representation of the given Punycode
   * string.
   */
  function toUnicode(input) {
    return mapDomain(input, function (string) {
      return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
    });
  }

  /**
   * Converts a Unicode string representing a domain name or an email address to
   * Punycode. Only the non-ASCII parts of the domain name will be converted,
   * i.e. it doesn't matter if you call it with a domain that's already in
   * ASCII.
   * @memberOf punycode
   * @param {String} input The domain name or email address to convert, as a
   * Unicode string.
   * @returns {String} The Punycode representation of the given domain name or
   * email address.
   */
  function toASCII(input) {
    return mapDomain(input, function (string) {
      return regexNonASCII.test(string) ? 'xn--' + encode(string) : string;
    });
  }

  /*--------------------------------------------------------------------------*/

  /** Define the public API */
  punycode = {
    /**
     * A string representing the current Punycode.js version number.
     * @memberOf punycode
     * @type String
     */
    'version': '1.3.2',
    /**
     * An object of methods to convert from JavaScript's internal character
     * representation (UCS-2) to Unicode code points, and back.
     * @see <https://mathiasbynens.be/notes/javascript-encoding>
     * @memberOf punycode
     * @type Object
     */
    'ucs2': {
      'decode': ucs2decode,
      'encode': ucs2encode
    },
    'decode': decode,
    'encode': encode,
    'toASCII': toASCII,
    'toUnicode': toUnicode
  };

  /** Expose `punycode` */
  // Some AMD build optimizers, like r.js, check for specific condition patterns
  // like the following:
  if (true) {
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
      return punycode;
    }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(this);

/***/ }),

/***/ "./src/converse.js":
/*!*************************!*\
  !*** ./src/converse.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_headless__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/headless */ "./src/headless/headless.js");
/* harmony import */ var _i18n_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./i18n/index.js */ "./src/i18n/index.js");
/* harmony import */ var shared_registry_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! shared/registry.js */ "./src/shared/registry.js");
/* harmony import */ var shared_components_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! shared/components/element */ "./src/shared/components/element.js");
/* harmony import */ var _shared_constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./shared/constants.js */ "./src/shared/constants.js");
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var shared_styles_index_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! shared/styles/index.scss */ "./src/shared/styles/index.scss");
/* harmony import */ var _plugins_modal_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./plugins/modal/index.js */ "./src/plugins/modal/index.js");
/* harmony import */ var _plugins_adhoc_views_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./plugins/adhoc-views/index.js */ "./src/plugins/adhoc-views/index.js");
/* harmony import */ var _plugins_bookmark_views_index_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./plugins/bookmark-views/index.js */ "./src/plugins/bookmark-views/index.js");
/* harmony import */ var _plugins_chatview_index_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./plugins/chatview/index.js */ "./src/plugins/chatview/index.js");
/* harmony import */ var _plugins_controlbox_index_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./plugins/controlbox/index.js */ "./src/plugins/controlbox/index.js");
/* harmony import */ var _plugins_headlines_view_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./plugins/headlines-view/index.js */ "./src/plugins/headlines-view/index.js");
/* harmony import */ var _plugins_mam_views_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./plugins/mam-views/index.js */ "./src/plugins/mam-views/index.js");
/* harmony import */ var _plugins_muc_views_index_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./plugins/muc-views/index.js */ "./src/plugins/muc-views/index.js");
/* harmony import */ var _plugins_minimize_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./plugins/minimize/index.js */ "./src/plugins/minimize/index.js");
/* harmony import */ var _plugins_notifications_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./plugins/notifications/index.js */ "./src/plugins/notifications/index.js");
/* harmony import */ var _plugins_profile_index_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./plugins/profile/index.js */ "./src/plugins/profile/index.js");
/* harmony import */ var _plugins_omemo_index_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./plugins/omemo/index.js */ "./src/plugins/omemo/index.js");
/* harmony import */ var _plugins_push_index_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./plugins/push/index.js */ "./src/plugins/push/index.js");
/* harmony import */ var _plugins_register_index_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./plugins/register/index.js */ "./src/plugins/register/index.js");
/* harmony import */ var _plugins_roomslist_index_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./plugins/roomslist/index.js */ "./src/plugins/roomslist/index.js");
/* harmony import */ var _plugins_rootview_index_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./plugins/rootview/index.js */ "./src/plugins/rootview/index.js");
/* harmony import */ var _plugins_rosterview_index_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./plugins/rosterview/index.js */ "./src/plugins/rosterview/index.js");
/* harmony import */ var _plugins_singleton_index_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./plugins/singleton/index.js */ "./src/plugins/singleton/index.js");
/* harmony import */ var _plugins_dragresize_index_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./plugins/dragresize/index.js */ "./src/plugins/dragresize/index.js");
/* harmony import */ var _plugins_fullscreen_index_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./plugins/fullscreen/index.js */ "./src/plugins/fullscreen/index.js");
/**
 * @description Converse.js (A browser based XMPP chat client)
 * @copyright 2021, The Converse developers
 * @license Mozilla Public License (MPLv2)
 */









/* START: Removable plugins
 * ------------------------
 * Any of the following plugin imports may be removed if the plugin is not needed
 */

 // Views for XEP-0050 Ad-Hoc commands
 // Views for XEP-0048 Bookmarks
 // Renders standalone chat boxes for single user chat
 // The control box


 // Views related to MUC
 // Allows chat boxes to be minimized



 // XEP-0357 Push Notifications
 // XEP-0077 In-band registration
 // Show currently open chat rooms



 // Allows chat boxes to be resized by dragging them

/* END: Removable components */

_converse_headless_core__WEBPACK_IMPORTED_MODULE_5__._converse.CustomElement = shared_components_element__WEBPACK_IMPORTED_MODULE_3__.CustomElement;
const initialize = _converse_headless_core__WEBPACK_IMPORTED_MODULE_5__.converse.initialize;
_converse_headless_core__WEBPACK_IMPORTED_MODULE_5__.converse.initialize = function (settings, callback) {
  if (Array.isArray(settings.whitelisted_plugins)) {
    settings.whitelisted_plugins = settings.whitelisted_plugins.concat(_shared_constants_js__WEBPACK_IMPORTED_MODULE_4__.VIEW_PLUGINS);
  } else {
    settings.whitelisted_plugins = _shared_constants_js__WEBPACK_IMPORTED_MODULE_4__.VIEW_PLUGINS;
  }
  return initialize(settings, callback);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_converse_headless_core__WEBPACK_IMPORTED_MODULE_5__.converse);

/***/ }),

/***/ "./src/headless/core.js":
/*!******************************!*\
  !*** ./src/headless/core.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_converse": () => (/* reexport safe */ _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "api": () => (/* binding */ api),
/* harmony export */   "converse": () => (/* binding */ converse),
/* harmony export */   "i18n": () => (/* reexport safe */ _converse_headless_shared_i18n__WEBPACK_IMPORTED_MODULE_5__["default"])
/* harmony export */ });
/* harmony import */ var urijs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! urijs */ "./node_modules/urijs/src/URI.js");
/* harmony import */ var urijs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(urijs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/shared/_converse */ "./src/headless/shared/_converse.js");
/* harmony import */ var dayjs_plugin_advancedFormat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! dayjs/plugin/advancedFormat */ "./node_modules/dayjs/plugin/advancedFormat.js");
/* harmony import */ var dayjs_plugin_advancedFormat__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(dayjs_plugin_advancedFormat__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _converse_headless_shared_connection_api_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/shared/connection/api.js */ "./src/headless/shared/connection/api.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _converse_headless_shared_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/shared/i18n */ "./src/headless/shared/i18n.js");
/* harmony import */ var lodash_es_invoke__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! lodash-es/invoke */ "./node_modules/lodash-es/invoke.js");
/* harmony import */ var lodash_es_isFunction__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! lodash-es/isFunction */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var pluggable_js_src_pluggable_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! pluggable.js/src/pluggable.js */ "./node_modules/pluggable.js/src/pluggable.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @converse/headless/utils/core.js */ "./src/headless/utils/core.js");
/* harmony import */ var _shared_constants_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./shared/constants.js */ "./src/headless/shared/constants.js");
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _converse_headless_shared_connection_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @converse/headless/shared/connection/index.js */ "./src/headless/shared/connection/index.js");
/* harmony import */ var _converse_skeletor_src_events_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @converse/skeletor/src/events.js */ "./node_modules/@converse/skeletor/src/events.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! strophe.js/src/strophe */ "./node_modules/strophe.js/src/strophe.js");
/* harmony import */ var _converse_headless_shared_errors__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @converse/headless/shared/errors */ "./src/headless/shared/errors.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");
/* harmony import */ var lit__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! lit */ "./node_modules/lit/index.js");
/* harmony import */ var _converse_headless_shared_settings_utils_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @converse/headless/shared/settings/utils.js */ "./src/headless/shared/settings/utils.js");
/* harmony import */ var _converse_headless_shared_settings_api_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @converse/headless/shared/settings/api.js */ "./src/headless/shared/settings/api.js");
/* harmony import */ var sprintf_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! sprintf-js */ "./node_modules/sprintf-js/src/sprintf.js");
/* harmony import */ var sprintf_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(sprintf_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var _utils_init_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./utils/init.js */ "./src/headless/utils/init.js");
/**
 * @copyright The Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */



























dayjs__WEBPACK_IMPORTED_MODULE_4___default().extend((dayjs_plugin_advancedFormat__WEBPACK_IMPORTED_MODULE_2___default()));

// Add Strophe Namespaces
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('ACTIVITY', 'http://jabber.org/protocol/activity');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('CARBONS', 'urn:xmpp:carbons:2');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('CHATSTATES', 'http://jabber.org/protocol/chatstates');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('CSI', 'urn:xmpp:csi:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('DELAY', 'urn:xmpp:delay');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('EME', 'urn:xmpp:eme:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('FASTEN', 'urn:xmpp:fasten:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('FORWARD', 'urn:xmpp:forward:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('HINTS', 'urn:xmpp:hints');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('HTTPUPLOAD', 'urn:xmpp:http:upload:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('MAM', 'urn:xmpp:mam:2');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('MARKERS', 'urn:xmpp:chat-markers:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('MENTIONS', 'urn:xmpp:mmn:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('MESSAGE_CORRECT', 'urn:xmpp:message-correct:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('MODERATE', 'urn:xmpp:message-moderate:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('NICK', 'http://jabber.org/protocol/nick');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('OCCUPANTID', 'urn:xmpp:occupant-id:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('OMEMO', 'eu.siacs.conversations.axolotl');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('OUTOFBAND', 'jabber:x:oob');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('PUBSUB', 'http://jabber.org/protocol/pubsub');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('RAI', 'urn:xmpp:rai:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('RECEIPTS', 'urn:xmpp:receipts');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('REFERENCE', 'urn:xmpp:reference:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('REGISTER', 'jabber:iq:register');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('RETRACT', 'urn:xmpp:message-retract:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('ROSTERX', 'http://jabber.org/protocol/rosterx');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('RSM', 'http://jabber.org/protocol/rsm');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('SID', 'urn:xmpp:sid:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('SPOILER', 'urn:xmpp:spoiler:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('STANZAS', 'urn:ietf:params:xml:ns:xmpp-stanzas');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('STYLING', 'urn:xmpp:styling:0');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('VCARD', 'vcard-temp');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('VCARDUPDATE', 'vcard-temp:x:update');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('XFORM', 'jabber:x:data');
strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.addNamespace('XHTML', 'http://www.w3.org/1999/xhtml');
_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].VERSION_NAME = "v10.0.0";
Object.assign(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"], _converse_skeletor_src_events_js__WEBPACK_IMPORTED_MODULE_13__.Events);

// Make converse pluggable
pluggable_js_src_pluggable_js__WEBPACK_IMPORTED_MODULE_7__["default"].enable(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"], '_converse', 'pluggable');

/**
 * ### The private API
 *
 * The private API methods are only accessible via the closured {@link _converse}
 * object, which is only available to plugins.
 *
 * These methods are kept private (i.e. not global) because they may return
 * sensitive data which should be kept off-limits to other 3rd-party scripts
 * that might be running in the page.
 *
 * @namespace _converse.api
 * @memberOf _converse
 */
const api = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].api = {
  connection: _converse_headless_shared_connection_api_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  settings: _converse_headless_shared_settings_api_js__WEBPACK_IMPORTED_MODULE_20__.settings_api,
  /**
   * Lets you trigger events, which can be listened to via
   * {@link _converse.api.listen.on} or {@link _converse.api.listen.once}
   * (see [_converse.api.listen](http://localhost:8000/docs/html/api/-_converse.api.listen.html)).
   *
   * Some events also double as promises and can be waited on via {@link _converse.api.waitUntil}.
   *
   * @method _converse.api.trigger
   * @param {string} name - The event name
   * @param {...any} [argument] - Argument to be passed to the event handler
   * @param {object} [options]
   * @param {boolean} [options.synchronous] - Whether the event is synchronous or not.
   *  When a synchronous event is fired, a promise will be returned
   *  by {@link _converse.api.trigger} which resolves once all the
   *  event handlers' promises have been resolved.
   */
  async trigger(name) {
    if (!_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]._events) {
      return;
    }
    const args = Array.from(arguments);
    const options = args.pop();
    if (options && options.synchronous) {
      const events = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]._events[name] || [];
      const event_args = args.splice(1);
      await Promise.all(events.map(e => e.callback.apply(e.ctx, event_args)));
    } else {
      _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].trigger.apply(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"], arguments);
    }
    const promise = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].promises[name];
    if (promise !== undefined) {
      promise.resolve();
    }
  },
  /**
   * Triggers a hook which can be intercepted by registered listeners via
   * {@link _converse.api.listen.on} or {@link _converse.api.listen.once}.
   * (see [_converse.api.listen](http://localhost:8000/docs/html/api/-_converse.api.listen.html)).
   * A hook is a special kind of event which allows you to intercept a data
   * structure in order to modify it, before passing it back.
   * @async
   * @param {string} name - The hook name
   * @param {...any} context - The context to which the hook applies (could be for example, a {@link _converse.ChatBox)).
   * @param {...any} data - The data structure to be intercepted and modified by the hook listeners.
   * @returns {Promise<any>} - A promise that resolves with the modified data structure.
   */
  hook(name, context, data) {
    const events = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]._events[name] || [];
    if (events.length) {
      // Create a chain of promises, with each one feeding its output to
      // the next. The first input is a promise with the original data
      // sent to this hook.
      return events.reduce((o, e) => o.then(d => e.callback(context, d)), Promise.resolve(data));
    } else {
      return data;
    }
  },
  /**
   * This grouping collects API functions related to the current logged in user.
   *
   * @namespace _converse.api.user
   * @memberOf _converse.api
   */
  user: {
    settings: _converse_headless_shared_settings_api_js__WEBPACK_IMPORTED_MODULE_20__.user_settings_api,
    /**
     * @method _converse.api.user.jid
     * @returns {string} The current user's full JID (Jabber ID)
     * @example _converse.api.user.jid())
     */
    jid() {
      return _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.jid;
    },
    /**
     * Logs the user in.
     *
     * If called without any parameters, Converse will try
     * to log the user in by calling the `prebind_url` or `credentials_url` depending
     * on whether prebinding is used or not.
     *
     * @method _converse.api.user.login
     * @param {string} [jid]
     * @param {string} [password]
     * @param {boolean} [automatic=false] - An internally used flag that indicates whether
     *  this method was called automatically once the connection has been
     *  initialized. It's used together with the `auto_login` configuration flag
     *  to determine whether Converse should try to log the user in if it
     *  fails to restore a previous auth'd session.
     *  @returns  {void}
     */
    async login(jid, password) {
      var _converse$connection, _api$settings$get;
      let automatic = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      jid = jid || api.settings.get('jid');
      if (!((_converse$connection = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection) !== null && _converse$connection !== void 0 && _converse$connection.jid) || jid && !_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"].isSameDomain(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.jid, jid)) {
        await _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].initConnection();
      }
      if ((_api$settings$get = api.settings.get("connection_options")) !== null && _api$settings$get !== void 0 && _api$settings$get.worker && (await _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.restoreWorkerSession())) {
        return;
      }
      if (jid) {
        jid = await (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.setUserJID)(jid);
      }

      // See whether there is a BOSH session to re-attach to
      const bosh_plugin = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].pluggable.plugins["converse-bosh"];
      if (bosh_plugin !== null && bosh_plugin !== void 0 && bosh_plugin.enabled()) {
        if (await _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].restoreBOSHSession()) {
          return;
        } else if (api.settings.get("authentication") === _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].PREBIND && (!automatic || api.settings.get("auto_login"))) {
          return _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].startNewPreboundBOSHSession();
        }
      }
      password = password || api.settings.get("password");
      const credentials = jid && password ? {
        jid,
        password
      } : null;
      (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.attemptNonPreboundSession)(credentials, automatic);
    },
    /**
     * Logs the user out of the current XMPP session.
     * @method _converse.api.user.logout
     * @example _converse.api.user.logout();
     */
    async logout() {
      /**
       * Triggered before the user is logged out
       * @event _converse#beforeLogout
       */
      await api.trigger('beforeLogout', {
        'synchronous': true
      });
      const promise = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_17__.getOpenPromise)();
      const complete = () => {
        // Recreate all the promises
        Object.keys(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].promises).forEach(_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.replacePromise);
        delete _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].jid;
        /**
         * Triggered once the user has logged out.
         * @event _converse#logout
         */
        api.trigger('logout');
        promise.resolve();
      };
      _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.setDisconnectionCause(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].LOGOUT, undefined, true);
      if (_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection !== undefined) {
        api.listen.once('disconnected', () => complete());
        _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.disconnect();
      } else {
        complete();
      }
      return promise;
    }
  },
  /**
   * Converse and its plugins trigger various events which you can listen to via the
   * {@link _converse.api.listen} namespace.
   *
   * Some of these events are also available as [ES2015 Promises](http://es6-features.org/#PromiseUsage)
   * although not all of them could logically act as promises, since some events
   * might be fired multpile times whereas promises are to be resolved (or
   * rejected) only once.
   *
   * Events which are also promises include:
   *
   * * [cachedRoster](/docs/html/events.html#cachedroster)
   * * [chatBoxesFetched](/docs/html/events.html#chatBoxesFetched)
   * * [pluginsInitialized](/docs/html/events.html#pluginsInitialized)
   * * [roster](/docs/html/events.html#roster)
   * * [rosterContactsFetched](/docs/html/events.html#rosterContactsFetched)
   * * [rosterGroupsFetched](/docs/html/events.html#rosterGroupsFetched)
   * * [rosterInitialized](/docs/html/events.html#rosterInitialized)
   *
   * The various plugins might also provide promises, and they do this by using the
   * `promises.add` api method.
   *
   * @namespace _converse.api.promises
   * @memberOf _converse.api
   */
  promises: {
    /**
     * By calling `promises.add`, a new [Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)
     * is made available for other code or plugins to depend on via the
     * {@link _converse.api.waitUntil} method.
     *
     * Generally, it's the responsibility of the plugin which adds the promise to
     * also resolve it.
     *
     * This is done by calling {@link _converse.api.trigger}, which not only resolves the
     * promise, but also emits an event with the same name (which can be listened to
     * via {@link _converse.api.listen}).
     *
     * @method _converse.api.promises.add
     * @param {string|array} [name|names] The name or an array of names for the promise(s) to be added
     * @param {boolean} [replace=true] Whether this promise should be replaced with a new one when the user logs out.
     * @example _converse.api.promises.add('foo-completed');
     */
    add(promises) {
      let replace = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      promises = Array.isArray(promises) ? promises : [promises];
      promises.forEach(name => {
        const promise = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_17__.getOpenPromise)();
        promise.replace = replace;
        _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].promises[name] = promise;
      });
    }
  },
  /**
   * Converse emits events to which you can subscribe to.
   *
   * The `listen` namespace exposes methods for creating event listeners
   * (aka handlers) for these events.
   *
   * @namespace _converse.api.listen
   * @memberOf _converse
   */
  listen: {
    /**
     * Lets you listen to an event exactly once.
     * @method _converse.api.listen.once
     * @param {string} name The event's name
     * @param {function} callback The callback method to be called when the event is emitted.
     * @param {object} [context] The value of the `this` parameter for the callback.
     * @example _converse.api.listen.once('message', function (messageXML) { ... });
     */
    once: _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].once.bind(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]),
    /**
     * Lets you subscribe to an event.
     * Every time the event fires, the callback method specified by `callback` will be called.
     * @method _converse.api.listen.on
     * @param {string} name The event's name
     * @param {function} callback The callback method to be called when the event is emitted.
     * @param {object} [context] The value of the `this` parameter for the callback.
     * @example _converse.api.listen.on('message', function (messageXML) { ... });
     */
    on: _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].on.bind(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]),
    /**
     * To stop listening to an event, you can use the `not` method.
     * @method _converse.api.listen.not
     * @param {string} name The event's name
     * @param {function} callback The callback method that is to no longer be called when the event fires
     * @example _converse.api.listen.not('message', function (messageXML);
     */
    not: _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].off.bind(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]),
    /**
     * Subscribe to an incoming stanza
     * Every a matched stanza is received, the callback method specified by
     * `callback` will be called.
     * @method _converse.api.listen.stanza
     * @param {string} name The stanza's name
     * @param {object} options Matching options (e.g. 'ns' for namespace, 'type' for stanza type, also 'id' and 'from');
     * @param {function} handler The callback method to be called when the stanza appears
     */
    stanza(name, options, handler) {
      if ((0,lodash_es_isFunction__WEBPACK_IMPORTED_MODULE_23__["default"])(options)) {
        handler = options;
        options = {};
      } else {
        options = options || {};
      }
      _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.addHandler(handler, options.ns, name, options.type, options.id, options.from, options);
    }
  },
  /**
   * Wait until a promise is resolved or until the passed in function returns
   * a truthy value.
   * @method _converse.api.waitUntil
   * @param {string|function} condition - The name of the promise to wait for,
   * or a function which should eventually return a truthy value.
   * @returns {Promise}
   */
  waitUntil(condition) {
    if ((0,lodash_es_isFunction__WEBPACK_IMPORTED_MODULE_23__["default"])(condition)) {
      return _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"].waitUntil(condition);
    } else {
      const promise = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].promises[condition];
      if (promise === undefined) {
        return null;
      }
      return promise;
    }
  },
  /**
   * Allows you to send XML stanzas.
   * @method _converse.api.send
   * @param {XMLElement} stanza
   * @return {void}
   * @example
   * const msg = converse.env.$msg({
   *     'from': 'juliet@example.com/balcony',
   *     'to': 'romeo@example.net',
   *     'type':'chat'
   * });
   * _converse.api.send(msg);
   */
  send(stanza) {
    var _stanza;
    if (!api.connection.connected()) {
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].warn("Not sending stanza because we're not connected!");
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].warn(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.serialize(stanza));
      return;
    }
    if (typeof stanza === 'string') {
      stanza = _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"].toStanza(stanza);
    } else if ((_stanza = stanza) !== null && _stanza !== void 0 && _stanza.nodeTree) {
      stanza = stanza.nodeTree;
    }
    if (stanza.tagName === 'iq') {
      return api.sendIQ(stanza);
    } else {
      _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.send(stanza);
      api.trigger('send', stanza);
    }
  },
  /**
   * Send an IQ stanza
   * @method _converse.api.sendIQ
   * @param {XMLElement} stanza
   * @param {Integer} [timeout=_converse.STANZA_TIMEOUT]
   * @param {Boolean} [reject=true] - Whether an error IQ should cause the promise
   *  to be rejected. If `false`, the promise will resolve instead of being rejected.
   * @returns {Promise} A promise which resolves (or potentially rejected) once we
   *  receive a `result` or `error` stanza or once a timeout is reached.
   *  If the IQ stanza being sent is of type `result` or `error`, there's
   *  nothing to wait for, so an already resolved promise is returned.
   */
  sendIQ(stanza) {
    var _stanza2;
    let timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].STANZA_TIMEOUT;
    let reject = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    let promise;
    stanza = ((_stanza2 = stanza) === null || _stanza2 === void 0 ? void 0 : _stanza2.nodeTree) ?? stanza;
    if (['get', 'set'].includes(stanza.getAttribute('type'))) {
      timeout = timeout || _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].STANZA_TIMEOUT;
      if (reject) {
        promise = new Promise((resolve, reject) => _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.sendIQ(stanza, resolve, reject, timeout));
        promise.catch(e => {
          if (e === null) {
            throw new _converse_headless_shared_errors__WEBPACK_IMPORTED_MODULE_16__.TimeoutError(`Timeout error after ${timeout}ms for the following IQ stanza: ${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.serialize(stanza)}`);
          }
        });
      } else {
        promise = new Promise(resolve => _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.sendIQ(stanza, resolve, resolve, timeout));
      }
    } else {
      _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.sendIQ(stanza);
      promise = Promise.resolve();
    }
    api.trigger('send', stanza);
    return promise;
  }
};
_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].shouldClearCache = () => !_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].config.get('trusted') || api.settings.get('clear_cache_on_logout') || _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].isTestEnv();
_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].initConnection = function () {
  const api = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].api;
  if (!api.settings.get('bosh_service_url')) {
    if (api.settings.get("authentication") === _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].PREBIND) {
      throw new Error("authentication is set to 'prebind' but we don't have a BOSH connection");
    }
  }
  const XMPPConnection = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].isTestEnv() ? _converse_headless_shared_connection_index_js__WEBPACK_IMPORTED_MODULE_12__.MockConnection : _converse_headless_shared_connection_index_js__WEBPACK_IMPORTED_MODULE_12__.Connection;
  _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection = new XMPPConnection((0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.getConnectionServiceURL)(), Object.assign(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].default_connection_options, api.settings.get("connection_options"), {
    'keepalive': api.settings.get("keepalive")
  }));
  setUpXMLLogging();
  /**
   * Triggered once the `Connection` constructor has been initialized, which
   * will be responsible for managing the connection to the XMPP server.
   *
   * @event _converse#connectionInitialized
   */
  api.trigger('connectionInitialized');
};
function setUpXMLLogging() {
  const lmap = {};
  lmap[strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.LogLevel.DEBUG] = 'debug';
  lmap[strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.LogLevel.INFO] = 'info';
  lmap[strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.LogLevel.WARN] = 'warn';
  lmap[strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.LogLevel.ERROR] = 'error';
  lmap[strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.LogLevel.FATAL] = 'fatal';
  strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.log = (level, msg) => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].log(msg, lmap[level]);
  strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.error = msg => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].error(msg);
  _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.xmlInput = body => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].debug(body.outerHTML, 'color: darkgoldenrod');
  _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connection.xmlOutput = body => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].debug(body.outerHTML, 'color: darkcyan');
}
_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].saveWindowState = function (ev) {
  // XXX: eventually we should be able to just use
  // document.visibilityState (when we drop support for older
  // browsers).
  let state;
  const event_map = {
    'focus': "visible",
    'focusin': "visible",
    'pageshow': "visible",
    'blur': "hidden",
    'focusout': "hidden",
    'pagehide': "hidden"
  };
  ev = ev || document.createEvent('Events');
  if (ev.type in event_map) {
    state = event_map[ev.type];
  } else {
    state = document.hidden ? "hidden" : "visible";
  }
  _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].windowState = state;
  /**
      * Triggered when window state has changed.
      * Used to determine when a user left the page and when came back.
      * @event _converse#windowStateChanged
      * @type { object }
      * @property{ string } state - Either "hidden" or "visible"
      * @example _converse.api.listen.on('windowStateChanged', obj => { ... });
      */
  api.trigger('windowStateChanged', {
    state
  });
};
_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].ConnectionFeedback = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_14__.Model.extend({
  defaults: {
    'connection_status': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe.Status.DISCONNECTED,
    'message': ''
  },
  initialize() {
    this.on('change', () => api.trigger('connfeedback', _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connfeedback));
  }
});
const converse = window.converse || {};

/**
 * ### The Public API
 *
 * This namespace contains public API methods which are are
 * accessible on the global `converse` object.
 * They are public, because any JavaScript in the
 * page can call them. Public methods therefore don’t expose any sensitive
 * or closured data. To do that, you’ll need to create a plugin, which has
 * access to the private API method.
 *
 * @global
 * @namespace converse
 */
Object.assign(converse, {
  CHAT_STATES: _shared_constants_js__WEBPACK_IMPORTED_MODULE_10__.CHAT_STATES,
  keycodes: _shared_constants_js__WEBPACK_IMPORTED_MODULE_10__.KEYCODES,
  /**
   * Public API method which initializes Converse.
   * This method must always be called when using Converse.
   * @async
   * @memberOf converse
   * @method initialize
   * @param {object} config A map of [configuration-settings](https://conversejs.org/docs/html/configuration.html#configuration-settings).
   * @example
   * converse.initialize({
   *     auto_list_rooms: false,
   *     auto_subscribe: false,
   *     bosh_service_url: 'https://bind.example.com',
   *     hide_muc_server: false,
   *     i18n: 'en',
   *     play_sounds: true,
   *     show_controlbox_by_default: true,
   *     debug: false,
   *     roster_groups: true
   * });
   */
  async initialize(settings) {
    var _api$elements;
    await (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.cleanup)(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]);
    (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.setUnloadEvent)();
    (0,_converse_headless_shared_settings_utils_js__WEBPACK_IMPORTED_MODULE_19__.initAppSettings)(settings);
    _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].strict_plugin_dependencies = settings.strict_plugin_dependencies; // Needed by pluggable.js
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].setLogLevel(api.settings.get("loglevel"));
    if (api.settings.get("authentication") === _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].ANONYMOUS) {
      if (api.settings.get("auto_login") && !api.settings.get('jid')) {
        throw new Error("Config Error: you need to provide the server's " + "domain via the 'jid' option when using anonymous " + "authentication with auto_login.");
      }
    }
    _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].router.route(/^converse\?loglevel=(debug|info|warn|error|fatal)$/, 'loglevel', l => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].setLogLevel(l));
    _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].connfeedback = new _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].ConnectionFeedback();

    /* When reloading the page:
     * For new sessions, we need to send out a presence stanza to notify
     * the server/network that we're online.
     * When re-attaching to an existing session we don't need to again send out a presence stanza,
     * because it's as if "we never left" (see onConnectStatusChanged).
     * https://github.com/conversejs/converse.js/issues/521
     */
    _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].send_initial_presence = true;
    await (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.initSessionStorage)(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]);
    await (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.initClientConfig)(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]);
    await _converse_headless_shared_i18n__WEBPACK_IMPORTED_MODULE_5__["default"].initialize();
    (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.initPlugins)(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]);

    // Register all custom elements
    // XXX: api.elements is defined in the UI part of Converse, outside of @converse/headless.
    // This line should probably be moved to the UI code as part of a larger refactoring.
    (_api$elements = api.elements) === null || _api$elements === void 0 ? void 0 : _api$elements.register();
    (0,_utils_init_js__WEBPACK_IMPORTED_MODULE_22__.registerGlobalEventHandlers)(_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"]);
    try {
      !History.started && _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].router.history.start();
    } catch (e) {
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"].error(e);
    }
    const plugins = _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].pluggable.plugins;
    if (api.settings.get("auto_login") || api.settings.get("keepalive") && (0,lodash_es_invoke__WEBPACK_IMPORTED_MODULE_24__["default"])(plugins['converse-bosh'], 'enabled')) {
      await api.user.login(null, null, true);
    }

    /**
     * Triggered once converse.initialize has finished.
     * @event _converse#initialized
     */
    api.trigger('initialized');
    if (_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].isTestEnv()) {
      return _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"];
    }
  },
  /**
   * Exposes methods for adding and removing plugins. You'll need to write a plugin
   * if you want to have access to the private API methods defined further down below.
   *
   * For more information on plugins, read the documentation on [writing a plugin](/docs/html/plugin_development.html).
   * @namespace plugins
   * @memberOf converse
   */
  plugins: {
    /**
     * Registers a new plugin.
     * @method converse.plugins.add
     * @param {string} name The name of the plugin
     * @param {object} plugin The plugin object
     * @example
     *  const plugin = {
     *      initialize: function () {
     *          // Gets called as soon as the plugin has been loaded.
     *
     *          // Inside this method, you have access to the private
     *          // API via `_covnerse.api`.
     *
     *          // The private _converse object contains the core logic
     *          // and data-structures of Converse.
     *      }
     *  }
     *  converse.plugins.add('myplugin', plugin);
     */
    add(name, plugin) {
      plugin.__name__ = name;
      if (_converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].pluggable.plugins[name] !== undefined) {
        throw new TypeError(`Error: plugin with name "${name}" has already been ` + 'registered!');
      } else {
        _converse_headless_shared_converse__WEBPACK_IMPORTED_MODULE_1__["default"].pluggable.plugins[name] = plugin;
      }
    }
  },
  /**
   * Utility methods and globals from bundled 3rd party libraries.
   * @typedef ConverseEnv
   * @property {function} converse.env.$build    - Creates a Strophe.Builder, for creating stanza objects.
   * @property {function} converse.env.$iq       - Creates a Strophe.Builder with an <iq/> element as the root.
   * @property {function} converse.env.$msg      - Creates a Strophe.Builder with an <message/> element as the root.
   * @property {function} converse.env.$pres     - Creates a Strophe.Builder with an <presence/> element as the root.
   * @property {function} converse.env.Promise   - The Promise implementation used by Converse.
   * @property {function} converse.env.Strophe   - The [Strophe](http://strophe.im/strophejs) XMPP library used by Converse.
   * @property {function} converse.env.f         - And instance of Lodash with its methods wrapped to produce immutable auto-curried iteratee-first data-last methods.
   * @property {function} converse.env.sizzle    - [Sizzle](https://sizzlejs.com) CSS selector engine.
   * @property {function} converse.env.sprintf
   * @property {object} converse.env._           - The instance of [lodash-es](http://lodash.com) used by Converse.
   * @property {object} converse.env.dayjs       - [DayJS](https://github.com/iamkun/dayjs) date manipulation library.
   * @property {object} converse.env.utils       - Module containing common utility methods used by Converse.
   * @memberOf converse
   */
  'env': {
    $build: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.$build,
    $iq: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.$iq,
    $msg: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.$msg,
    $pres: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.$pres,
    'utils': _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"],
    Collection: _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_11__.Collection,
    Model: _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_14__.Model,
    Promise,
    Strophe: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_15__.Strophe,
    URI: (urijs__WEBPACK_IMPORTED_MODULE_0___default()),
    dayjs: (dayjs__WEBPACK_IMPORTED_MODULE_4___default()),
    html: lit__WEBPACK_IMPORTED_MODULE_18__.html,
    log: _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_6__["default"],
    sizzle: (sizzle__WEBPACK_IMPORTED_MODULE_8___default()),
    sprintf: sprintf_js__WEBPACK_IMPORTED_MODULE_21__.sprintf,
    stx: _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"].stx,
    u: _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_9__["default"]
  }
});

/***/ }),

/***/ "./src/headless/headless.js":
/*!**********************************!*\
  !*** ./src/headless/headless.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _plugins_adhoc_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plugins/adhoc.js */ "./src/headless/plugins/adhoc.js");
/* harmony import */ var _plugins_bookmarks_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./plugins/bookmarks/index.js */ "./src/headless/plugins/bookmarks/index.js");
/* harmony import */ var _plugins_bosh_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./plugins/bosh.js */ "./src/headless/plugins/bosh.js");
/* harmony import */ var _plugins_caps_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./plugins/caps/index.js */ "./src/headless/plugins/caps/index.js");
/* harmony import */ var _plugins_chat_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./plugins/chat/index.js */ "./src/headless/plugins/chat/index.js");
/* harmony import */ var _plugins_chatboxes_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./plugins/chatboxes/index.js */ "./src/headless/plugins/chatboxes/index.js");
/* harmony import */ var _plugins_disco_index_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./plugins/disco/index.js */ "./src/headless/plugins/disco/index.js");
/* harmony import */ var _plugins_headlines_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./plugins/headlines/index.js */ "./src/headless/plugins/headlines/index.js");
/* harmony import */ var _plugins_mam_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./plugins/mam/index.js */ "./src/headless/plugins/mam/index.js");
/* harmony import */ var _plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./plugins/muc/index.js */ "./src/headless/plugins/muc/index.js");
/* harmony import */ var _plugins_ping_index_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./plugins/ping/index.js */ "./src/headless/plugins/ping/index.js");
/* harmony import */ var _plugins_pubsub_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./plugins/pubsub.js */ "./src/headless/plugins/pubsub.js");
/* harmony import */ var _plugins_roster_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./plugins/roster/index.js */ "./src/headless/plugins/roster/index.js");
/* harmony import */ var _plugins_smacks_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./plugins/smacks/index.js */ "./src/headless/plugins/smacks/index.js");
/* harmony import */ var _plugins_status_index_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./plugins/status/index.js */ "./src/headless/plugins/status/index.js");
/* harmony import */ var _plugins_vcard_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./plugins/vcard/index.js */ "./src/headless/plugins/vcard/index.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./core.js */ "./src/headless/core.js");
/* START: Removable components
 * --------------------
 * Any of the following components may be removed if they're not needed.
 */
 // XEP-0050 Ad Hoc Commands
 // XEP-0199 XMPP Ping
 // XEP-0206 BOSH
 // XEP-0115 Entity Capabilities
 // RFC-6121 Instant messaging

 // XEP-0030 Service discovery
 // Support for headline messages
 // XEP-0313 Message Archive Management
 // XEP-0045 Multi-user chat
 // XEP-0199 XMPP Ping
 // XEP-0060 Pubsub
 // RFC-6121 Contacts Roster
 // XEP-0198 Stream Management

 // XEP-0054 VCard-temp
/* END: Removable components */


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_core_js__WEBPACK_IMPORTED_MODULE_16__.converse);

/***/ }),

/***/ "./src/headless/log.js":
/*!*****************************!*\
  !*** ./src/headless/log.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es_isElement__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash-es/isElement */ "./node_modules/lodash-es/isElement.js");
var _console, _console2, _console3, _console4;

const LEVELS = {
  'debug': 0,
  'info': 1,
  'warn': 2,
  'error': 3,
  'fatal': 4
};
const logger = Object.assign({
  'debug': (_console = console) !== null && _console !== void 0 && _console.log ? console.log.bind(console) : function noop() {},
  'error': (_console2 = console) !== null && _console2 !== void 0 && _console2.log ? console.log.bind(console) : function noop() {},
  'info': (_console3 = console) !== null && _console3 !== void 0 && _console3.log ? console.log.bind(console) : function noop() {},
  'warn': (_console4 = console) !== null && _console4 !== void 0 && _console4.log ? console.log.bind(console) : function noop() {}
}, console);

/**
 * The log namespace
 * @namespace log
 */
const log = {
  /**
   * The the log-level, which determines how verbose the logging is.
   * @method log#setLogLevel
   * @param { integer } level - The loglevel which allows for filtering of log messages
   */
  setLogLevel(level) {
    if (!['debug', 'info', 'warn', 'error', 'fatal'].includes(level)) {
      throw new Error(`Invalid loglevel: ${level}`);
    }
    this.loglevel = level;
  },
  /**
   * Logs messages to the browser's developer console.
   * Available loglevels are 0 for 'debug', 1 for 'info', 2 for 'warn',
   * 3 for 'error' and 4 for 'fatal'.
   * When using the 'error' or 'warn' loglevels, a full stacktrace will be
   * logged as well.
   * @method log#log
   * @param { string | Error } message - The message to be logged
   * @param { integer } level - The loglevel which allows for filtering of log messages
   */
  log(message, level) {
    let style = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
    if (LEVELS[level] < LEVELS[this.loglevel]) {
      return;
    }
    if (level === 'error' || level === 'fatal') {
      style = style || 'color: maroon';
    } else if (level === 'debug') {
      style = style || 'color: green';
    }
    if (message instanceof Error) {
      message = message.stack;
    } else if ((0,lodash_es_isElement__WEBPACK_IMPORTED_MODULE_0__["default"])(message)) {
      message = message.outerHTML;
    }
    const prefix = style ? '%c' : '';
    if (level === 'error') {
      logger.error(`${prefix} ERROR: ${message}`, style);
    } else if (level === 'warn') {
      logger.warn(`${prefix} ${new Date().toISOString()} WARNING: ${message}`, style);
    } else if (level === 'fatal') {
      logger.error(`${prefix} FATAL: ${message}`, style);
    } else if (level === 'debug') {
      logger.debug(`${prefix} ${new Date().toISOString()} DEBUG: ${message}`, style);
    } else {
      logger.info(`${prefix} ${new Date().toISOString()} INFO: ${message}`, style);
    }
  },
  debug(message, style) {
    this.log(message, 'debug', style);
  },
  error(message, style) {
    this.log(message, 'error', style);
  },
  info(message, style) {
    this.log(message, 'info', style);
  },
  warn(message, style) {
    this.log(message, 'warn', style);
  },
  fatal(message, style) {
    this.log(message, 'fatal', style);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (log);

/***/ }),

/***/ "./src/headless/plugins/adhoc.js":
/*!***************************************!*\
  !*** ./src/headless/plugins/adhoc.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/shared/parsers */ "./src/headless/shared/parsers.js");




const {
  Strophe
} = _core_js__WEBPACK_IMPORTED_MODULE_0__.converse.env;
let _converse, api;
Strophe.addNamespace('ADHOC', 'http://jabber.org/protocol/commands');
function parseForCommands(stanza) {
  const items = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`query[xmlns="${Strophe.NS.DISCO_ITEMS}"][node="${Strophe.NS.ADHOC}"] item`, stanza);
  return items.map(_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_3__.getAttributes);
}
const adhoc_api = {
  /**
   * The XEP-0050 Ad-Hoc Commands API
   *
   * This API lets you discover ad-hoc commands available for an entity in the XMPP network.
   *
   * @namespace api.adhoc
   * @memberOf api
   */
  adhoc: {
    /**
     * @method api.adhoc.getCommands
     * @param { String } to_jid
     */
    async getCommands(to_jid) {
      let commands = [];
      try {
        commands = parseForCommands(await api.disco.items(to_jid, Strophe.NS.ADHOC));
      } catch (e) {
        if (e === null) {
          _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(`Error: timeout while fetching ad-hoc commands for ${to_jid}`);
        } else {
          _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(`Error while fetching ad-hoc commands for ${to_jid}`);
          _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(e);
        }
      }
      return commands;
    }
  }
};
_core_js__WEBPACK_IMPORTED_MODULE_0__.converse.plugins.add('converse-adhoc', {
  dependencies: ["converse-disco"],
  initialize() {
    _converse = this._converse;
    api = _converse.api;
    Object.assign(api, adhoc_api);
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (adhoc_api);

/***/ }),

/***/ "./src/headless/plugins/bookmarks/collection.js":
/*!******************************************************!*\
  !*** ./src/headless/plugins/bookmarks/collection.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/plugins/muc/index.js */ "./src/headless/plugins/muc/index.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./model.js */ "./src/headless/plugins/bookmarks/model.js");
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");
/* harmony import */ var _converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/utils/storage.js */ "./src/headless/utils/storage.js");






const {
  Strophe,
  $iq,
  sizzle
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env;
const Bookmarks = {
  model: _model_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  comparator: item => item.get('name').toLowerCase(),
  async initialize() {
    this.on('add', bm => this.openBookmarkedRoom(bm).then(bm => this.markRoomAsBookmarked(bm)).catch(e => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].fatal(e)));
    this.on('remove', this.markRoomAsUnbookmarked, this);
    this.on('remove', this.sendBookmarkStanza, this);
    const cache_key = `converse.room-bookmarks${_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid}`;
    this.fetched_flag = cache_key + 'fetched';
    (0,_converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_5__.initStorage)(this, cache_key);
    await this.fetchBookmarks();

    /**
     * Triggered once the _converse.Bookmarks collection
     * has been created and cached bookmarks have been fetched.
     * @event _converse#bookmarksInitialized
     * @type { _converse.Bookmarks }
     * @example _converse.api.listen.on('bookmarksInitialized', (bookmarks) => { ... });
     */
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.trigger('bookmarksInitialized', this);
  },
  async openBookmarkedRoom(bookmark) {
    if (_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('muc_respect_autojoin') && bookmark.get('autojoin')) {
      const groupchat = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.rooms.create(bookmark.get('jid'), {
        'nick': bookmark.get('nick')
      });
      groupchat.maybeShow();
    }
    return bookmark;
  },
  fetchBookmarks() {
    const deferred = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_4__.getOpenPromise)();
    if (window.sessionStorage.getItem(this.fetched_flag)) {
      this.fetch({
        'success': () => deferred.resolve(),
        'error': () => deferred.resolve()
      });
    } else {
      this.fetchBookmarksFromServer(deferred);
    }
    return deferred;
  },
  createBookmark(options) {
    this.create(options);
    this.sendBookmarkStanza().catch(iq => this.onBookmarkError(iq, options));
  },
  sendBookmarkStanza() {
    const stanza = $iq({
      'type': 'set',
      'from': _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.connection.jid
    }).c('pubsub', {
      'xmlns': Strophe.NS.PUBSUB
    }).c('publish', {
      'node': Strophe.NS.BOOKMARKS
    }).c('item', {
      'id': 'current'
    }).c('storage', {
      'xmlns': Strophe.NS.BOOKMARKS
    });
    this.forEach(model => {
      stanza.c('conference', {
        'name': model.get('name'),
        'autojoin': model.get('autojoin'),
        'jid': model.get('jid')
      }).c('nick').t(model.get('nick')).up().up();
    });
    stanza.up().up().up();
    stanza.c('publish-options').c('x', {
      'xmlns': Strophe.NS.XFORM,
      'type': 'submit'
    }).c('field', {
      'var': 'FORM_TYPE',
      'type': 'hidden'
    }).c('value').t('http://jabber.org/protocol/pubsub#publish-options').up().up().c('field', {
      'var': 'pubsub#persist_items'
    }).c('value').t('true').up().up().c('field', {
      'var': 'pubsub#access_model'
    }).c('value').t('whitelist');
    return _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ(stanza);
  },
  onBookmarkError(iq, options) {
    var _this$get;
    const {
      __
    } = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse;
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error("Error while trying to add bookmark");
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error(iq);
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.alert('error', __('Error'), [__("Sorry, something went wrong while trying to save your bookmark.")]);
    (_this$get = this.get(options.jid)) === null || _this$get === void 0 ? void 0 : _this$get.destroy();
  },
  fetchBookmarksFromServer(deferred) {
    const stanza = $iq({
      'from': _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.connection.jid,
      'type': 'get'
    }).c('pubsub', {
      'xmlns': Strophe.NS.PUBSUB
    }).c('items', {
      'node': Strophe.NS.BOOKMARKS
    });
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ(stanza).then(iq => this.onBookmarksReceived(deferred, iq)).catch(iq => this.onBookmarksReceivedError(deferred, iq));
  },
  markRoomAsBookmarked(bookmark) {
    const groupchat = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes.get(bookmark.get('jid'));
    groupchat === null || groupchat === void 0 ? void 0 : groupchat.save('bookmarked', true);
  },
  markRoomAsUnbookmarked(bookmark) {
    const groupchat = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes.get(bookmark.get('jid'));
    groupchat === null || groupchat === void 0 ? void 0 : groupchat.save('bookmarked', false);
  },
  createBookmarksFromStanza(stanza) {
    const xmlns = Strophe.NS.BOOKMARKS;
    const sel = `items[node="${xmlns}"] item storage[xmlns="${xmlns}"] conference`;
    sizzle(sel, stanza).forEach(el => {
      var _el$querySelector;
      const jid = el.getAttribute('jid');
      const bookmark = this.get(jid);
      const attrs = {
        'jid': jid,
        'name': el.getAttribute('name') || jid,
        'autojoin': el.getAttribute('autojoin') === 'true',
        'nick': ((_el$querySelector = el.querySelector('nick')) === null || _el$querySelector === void 0 ? void 0 : _el$querySelector.textContent) || ''
      };
      bookmark ? bookmark.save(attrs) : this.create(attrs);
    });
  },
  onBookmarksReceived(deferred, iq) {
    this.createBookmarksFromStanza(iq);
    window.sessionStorage.setItem(this.fetched_flag, true);
    if (deferred !== undefined) {
      return deferred.resolve();
    }
  },
  onBookmarksReceivedError(deferred, iq) {
    const {
      __
    } = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse;
    if (iq === null) {
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error('Error: timeout while fetching bookmarks');
      _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.alert('error', __('Timeout Error'), [__("The server did not return your bookmarks within the allowed time. " + "You can reload the page to request them again.")]);
    } else if (deferred) {
      if (iq.querySelector('error[type="cancel"] item-not-found')) {
        // Not an exception, the user simply doesn't have any bookmarks.
        window.sessionStorage.setItem(this.fetched_flag, true);
        return deferred.resolve();
      } else {
        _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error('Error while fetching bookmarks');
        _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error(iq);
        return deferred.reject(new Error("Could not fetch bookmarks"));
      }
    } else {
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error('Error while fetching bookmarks');
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error(iq);
    }
  },
  async getUnopenedBookmarks() {
    await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.waitUntil('bookmarksInitialized');
    await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.waitUntil('chatBoxesFetched');
    return this.filter(b => !_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes.get(b.get('jid')));
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Bookmarks);

/***/ }),

/***/ "./src/headless/plugins/bookmarks/index.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/bookmarks/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/plugins/muc/index.js */ "./src/headless/plugins/muc/index.js");
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./model.js */ "./src/headless/plugins/bookmarks/model.js");
/* harmony import */ var _collection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./collection.js */ "./src/headless/plugins/bookmarks/collection.js");
/* harmony import */ var _converse_skeletor_src_collection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/skeletor/src/collection.js */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/bookmarks/utils.js");
/**
 * @description
 * Converse.js plugin which adds views for bookmarks specified in XEP-0048.
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */






const {
  Strophe
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.converse.env;
Strophe.addNamespace('BOOKMARKS', 'storage:bookmarks');
_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.converse.plugins.add('converse-bookmarks', {
  dependencies: ["converse-chatboxes", "converse-muc"],
  overrides: {
    // Overrides mentioned here will be picked up by converse.js's
    // plugin architecture they will replace existing methods on the
    // relevant objects or classes.
    // New functions which don't exist yet can also be added.

    ChatRoom: {
      getDisplayName() {
        var _converse$bookmarks;
        const {
          _converse,
          getDisplayName
        } = this.__super__;
        const bookmark = this.get('bookmarked') ? (_converse$bookmarks = _converse.bookmarks) === null || _converse$bookmarks === void 0 ? void 0 : _converse$bookmarks.get(this.get('jid')) : null;
        return (bookmark === null || bookmark === void 0 ? void 0 : bookmark.get('name')) || getDisplayName.apply(this, arguments);
      },
      getAndPersistNickname(nick) {
        nick = nick || (0,_utils_js__WEBPACK_IMPORTED_MODULE_5__.getNicknameFromBookmark)(this.get('jid'));
        return this.__super__.getAndPersistNickname.call(this, nick);
      }
    }
  },
  initialize() {
    // Configuration values for this plugin
    // ====================================
    // Refer to docs/source/configuration.rst for explanations of these
    // configuration settings.
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.extend({
      allow_bookmarks: true,
      allow_public_bookmarks: false,
      muc_respect_autojoin: true
    });
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.promises.add('bookmarksInitialized');
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.Bookmark = _model_js__WEBPACK_IMPORTED_MODULE_1__["default"];
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.Bookmarks = _converse_skeletor_src_collection_js__WEBPACK_IMPORTED_MODULE_3__.Collection.extend(_collection_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('addClientFeatures', () => {
      if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('allow_bookmarks')) {
        _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.disco.own.features.add(Strophe.NS.BOOKMARKS + '+notify');
      }
    });
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('clearSession', () => {
      if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bookmarks) {
        _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bookmarks.clearStore({
          'silent': true
        });
        window.sessionStorage.removeItem(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bookmarks.fetched_flag);
        delete _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bookmarks;
      }
    });
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('connected', async () => {
      // Add a handler for bookmarks pushed from other connected clients
      const {
        connection
      } = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse;
      connection.addHandler(_utils_js__WEBPACK_IMPORTED_MODULE_5__.handleBookmarksPush, null, 'message', 'headline', null, _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bare_jid);
      await Promise.all([_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.waitUntil('chatBoxesFetched')]);
      (0,_utils_js__WEBPACK_IMPORTED_MODULE_5__.initBookmarks)();
    });
  }
});

/***/ }),

/***/ "./src/headless/plugins/bookmarks/model.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/bookmarks/model.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");


const {
  Strophe
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.converse.env;
const Bookmark = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_1__.Model.extend({
  idAttribute: 'jid',
  getDisplayName() {
    return Strophe.xmlunescape(this.get('name'));
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Bookmark);

/***/ }),

/***/ "./src/headless/plugins/bookmarks/utils.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/bookmarks/utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "checkBookmarksSupport": () => (/* binding */ checkBookmarksSupport),
/* harmony export */   "getNicknameFromBookmark": () => (/* binding */ getNicknameFromBookmark),
/* harmony export */   "handleBookmarksPush": () => (/* binding */ handleBookmarksPush),
/* harmony export */   "initBookmarks": () => (/* binding */ initBookmarks)
/* harmony export */ });
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");


const {
  Strophe,
  sizzle
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.env;
async function checkBookmarksSupport() {
  const identity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.getIdentity('pubsub', 'pep', _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bare_jid);
  if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.settings.get('allow_public_bookmarks')) {
    return !!identity;
  } else {
    return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.supports(Strophe.NS.PUBSUB + '#publish-options', _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bare_jid);
  }
}
async function initBookmarks() {
  if (!_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.settings.get('allow_bookmarks')) {
    return;
  }
  if (await checkBookmarksSupport()) {
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bookmarks = new _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.Bookmarks();
  }
}
function getNicknameFromBookmark(jid) {
  var _converse$bookmarks, _converse$bookmarks$g;
  if (!_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.settings.get('allow_bookmarks')) {
    return null;
  }
  return (_converse$bookmarks = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bookmarks) === null || _converse$bookmarks === void 0 ? void 0 : (_converse$bookmarks$g = _converse$bookmarks.get(jid)) === null || _converse$bookmarks$g === void 0 ? void 0 : _converse$bookmarks$g.get('nick');
}
function handleBookmarksPush(message) {
  if (sizzle(`event[xmlns="${Strophe.NS.PUBSUB}#event"] items[node="${Strophe.NS.BOOKMARKS}"]`, message).length) {
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('bookmarksInitialized').then(() => _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bookmarks.createBookmarksFromStanza(message)).catch(e => _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].fatal(e));
  }
  return true;
}

/***/ }),

/***/ "./src/headless/plugins/bosh.js":
/*!**************************************!*\
  !*** ./src/headless/plugins/bosh.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var strophe_js_src_bosh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! strophe.js/src/bosh */ "./node_modules/strophe.js/src/bosh.js");
/* harmony import */ var _log_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../log.js */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_shared_constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/shared/constants.js */ "./src/headless/shared/constants.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_utils_init_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/utils/init.js */ "./src/headless/utils/init.js");
/**
 * @copyright The Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 * @description Converse.js plugin which add support for XEP-0206: XMPP Over BOSH
 */






const {
  Strophe
} = _core_js__WEBPACK_IMPORTED_MODULE_4__.converse.env;
const BOSH_SESSION_ID = 'converse.bosh-session';
_core_js__WEBPACK_IMPORTED_MODULE_4__.converse.plugins.add('converse-bosh', {
  enabled() {
    return !_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.api.settings.get("blacklisted_plugins").includes('converse-bosh');
  },
  initialize() {
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.extend({
      bosh_service_url: undefined,
      prebind_url: null
    });
    async function initBOSHSession() {
      const id = BOSH_SESSION_ID;
      if (!_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session) {
        _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session = new _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__.Model({
          id
        });
        _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.browserStorage = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, "session");
        await new Promise(resolve => _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.fetch({
          'success': resolve,
          'error': resolve
        }));
      }
      if (_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.jid) {
        if (_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.get('jid') !== _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.jid) {
          const jid = await (0,_converse_headless_utils_init_js__WEBPACK_IMPORTED_MODULE_5__.setUserJID)(_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.jid);
          _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.clear({
            'silent': true
          });
          _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.save({
            jid
          });
        }
      } else {
        // Keepalive
        const jid = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.get('jid');
        jid && (await (0,_converse_headless_utils_init_js__WEBPACK_IMPORTED_MODULE_5__.setUserJID)(jid));
      }
      return _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session;
    }
    _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.startNewPreboundBOSHSession = function () {
      if (!_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('prebind_url')) {
        throw new Error("startNewPreboundBOSHSession: If you use prebind then you MUST supply a prebind_url");
      }
      const xhr = new XMLHttpRequest();
      xhr.open('GET', _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('prebind_url'), true);
      xhr.setRequestHeader('Accept', 'application/json, text/javascript');
      xhr.onload = async function () {
        if (xhr.status >= 200 && xhr.status < 400) {
          const data = JSON.parse(xhr.responseText);
          const jid = await (0,_converse_headless_utils_init_js__WEBPACK_IMPORTED_MODULE_5__.setUserJID)(data.jid);
          _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.attach(jid, data.sid, data.rid, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.onConnectStatusChanged, _converse_headless_shared_constants_js__WEBPACK_IMPORTED_MODULE_2__.BOSH_WAIT);
        } else {
          xhr.onerror();
        }
      };
      xhr.onerror = function () {
        delete _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection;
        /**
         * Triggered when fetching prebind tokens failed
         * @event _converse#noResumeableBOSHSession
         * @type { _converse }
         * @example _converse.api.listen.on('noResumeableBOSHSession', _converse => { ... });
         */
        _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('noResumeableBOSHSession', _core_js__WEBPACK_IMPORTED_MODULE_4__._converse);
      };
      xhr.send();
    };
    _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.restoreBOSHSession = async function () {
      const jid = (await initBOSHSession()).get('jid');
      if (jid && _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection._proto instanceof Strophe.Bosh) {
        try {
          _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.restore(jid, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.onConnectStatusChanged);
          return true;
        } catch (e) {
          !_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.isTestEnv() && _log_js__WEBPACK_IMPORTED_MODULE_1__["default"].warn("Could not restore session for jid: " + jid + " Error message: " + e.message);
          return false;
        }
      }
      return false;
    };

    /************************ BEGIN Event Handlers ************************/
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('clearSession', () => {
      if (_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session === undefined) {
        // Remove manually, even if we don't have the corresponding
        // model, to avoid trying to reconnect to a stale BOSH session
        const id = BOSH_SESSION_ID;
        sessionStorage.removeItem(id);
        sessionStorage.removeItem(`${id}-${id}`);
      } else {
        _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.destroy();
        delete _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session;
      }
    });
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('setUserJID', () => {
      if (_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session !== undefined) {
        _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bosh_session.save({
          'jid': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.jid
        });
      }
    });
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('addClientFeatures', () => _core_js__WEBPACK_IMPORTED_MODULE_4__.api.disco.own.features.add(Strophe.NS.BOSH));

    /************************ END Event Handlers ************************/

    /************************ BEGIN API ************************/
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_4__.api, {
      /**
       * This namespace lets you access the BOSH tokens
       *
       * @namespace api.tokens
       * @memberOf api
       */
      tokens: {
        /**
         * @method api.tokens.get
         * @param {string} [id] The type of token to return ('rid' or 'sid').
         * @returns 'string' A token, either the RID or SID token depending on what's asked for.
         * @example _converse.api.tokens.get('rid');
         */
        get(id) {
          if (_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection === undefined) {
            return null;
          }
          if (id.toLowerCase() === 'rid') {
            return _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.rid || _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection._proto.rid;
          } else if (id.toLowerCase() === 'sid') {
            return _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.sid || _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection._proto.sid;
          }
        }
      }
    });
    /************************ end api ************************/
  }
});

/***/ }),

/***/ "./src/headless/plugins/caps/index.js":
/*!********************************************!*\
  !*** ./src/headless/plugins/caps/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/caps/utils.js");
/**
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */


const {
  Strophe
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.converse.env;
Strophe.addNamespace('CAPS', "http://jabber.org/protocol/caps");
_converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.converse.plugins.add('converse-caps', {
  dependencies: ['converse-status'],
  initialize() {
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.listen.on('constructedPresence', (_, p) => (0,_utils_js__WEBPACK_IMPORTED_MODULE_1__.addCapsNode)(p));
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.listen.on('constructedMUCPresence', (_, p) => (0,_utils_js__WEBPACK_IMPORTED_MODULE_1__.addCapsNode)(p));
  }
});

/***/ }),

/***/ "./src/headless/plugins/caps/utils.js":
/*!********************************************!*\
  !*** ./src/headless/plugins/caps/utils.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "addCapsNode": () => (/* binding */ addCapsNode)
/* harmony export */ });
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_utils_arraybuffer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/utils/arraybuffer.js */ "./src/headless/utils/arraybuffer.js");


const {
  Strophe,
  $build
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.converse.env;
function propertySort(array, property) {
  return array.sort((a, b) => {
    return a[property] > b[property] ? -1 : 1;
  });
}
async function generateVerificationString() {
  const identities = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.api.disco.own.identities.get();
  const features = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.api.disco.own.features.get();
  if (identities.length > 1) {
    propertySort(identities, "category");
    propertySort(identities, "type");
    propertySort(identities, "lang");
  }
  let S = identities.reduce((result, id) => `${result}${id.category}/${id.type}/${(id === null || id === void 0 ? void 0 : id.lang) ?? ''}/${id.name}<`, "");
  features.sort();
  S = features.reduce((result, feature) => `${result}${feature}<`, S);
  const ab = await crypto.subtle.digest('SHA-1', (0,_converse_headless_utils_arraybuffer_js__WEBPACK_IMPORTED_MODULE_1__.stringToArrayBuffer)(S));
  return (0,_converse_headless_utils_arraybuffer_js__WEBPACK_IMPORTED_MODULE_1__.arrayBufferToBase64)(ab);
}
async function createCapsNode() {
  return $build("c", {
    'xmlns': Strophe.NS.CAPS,
    'hash': "sha-1",
    'node': "https://conversejs.org",
    'ver': await generateVerificationString()
  }).nodeTree;
}

/**
 * Given a stanza, adds a XEP-0115 CAPS element
 * @param { XMLElement } stanza
 */
async function addCapsNode(stanza) {
  const caps_el = await createCapsNode();
  stanza.root().cnode(caps_el).up();
  return stanza;
}

/***/ }),

/***/ "./src/headless/plugins/chat/api.js":
/*!******************************************!*\
  !*** ./src/headless/plugins/chat/api.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _log_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../log.js */ "./src/headless/log.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The "chats" namespace (used for one-on-one chats)
   *
   * @namespace api.chats
   * @memberOf api
   */
  chats: {
    /**
     * @method api.chats.create
     * @param {string|string[]} jid|jids An jid or array of jids
     * @param {object} [attrs] An object containing configuration attributes.
     */
    async create(jids, attrs) {
      if (typeof jids === 'string') {
        if (attrs && !(attrs !== null && attrs !== void 0 && attrs.fullname)) {
          var _contact$attributes;
          const contact = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.contacts.get(jids);
          attrs.fullname = contact === null || contact === void 0 ? void 0 : (_contact$attributes = contact.attributes) === null || _contact$attributes === void 0 ? void 0 : _contact$attributes.fullname;
        }
        const chatbox = _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.get(jids, attrs, true);
        if (!chatbox) {
          _log_js__WEBPACK_IMPORTED_MODULE_1__["default"].error("Could not open chatbox for JID: " + jids);
          return;
        }
        return chatbox;
      }
      if (Array.isArray(jids)) {
        return Promise.all(jids.forEach(async jid => {
          var _contact$attributes2;
          const contact = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.contacts.get(jids);
          attrs.fullname = contact === null || contact === void 0 ? void 0 : (_contact$attributes2 = contact.attributes) === null || _contact$attributes2 === void 0 ? void 0 : _contact$attributes2.fullname;
          return _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.get(jid, attrs, true).maybeShow();
        }));
      }
      _log_js__WEBPACK_IMPORTED_MODULE_1__["default"].error("chats.create: You need to provide at least one JID");
      return null;
    },
    /**
     * Opens a new one-on-one chat.
     *
     * @method api.chats.open
     * @param {String|string[]} name - e.g. 'buddy@example.com' or ['buddy1@example.com', 'buddy2@example.com']
     * @param {Object} [attrs] - Attributes to be set on the _converse.ChatBox model.
     * @param {Boolean} [attrs.minimized] - Should the chat be created in minimized state.
     * @param {Boolean} [force=false] - By default, a minimized
     *   chat won't be maximized (in `overlayed` view mode) and in
     *   `fullscreen` view mode a newly opened chat won't replace
     *   another chat already in the foreground.
     *   Set `force` to `true` if you want to force the chat to be
     *   maximized or shown.
     * @returns {Promise} Promise which resolves with the
     *   _converse.ChatBox representing the chat.
     *
     * @example
     * // To open a single chat, provide the JID of the contact you're chatting with in that chat:
     * converse.plugins.add('myplugin', {
     *     initialize: function() {
     *         const _converse = this._converse;
     *         // Note, buddy@example.org must be in your contacts roster!
     *         api.chats.open('buddy@example.com').then(chat => {
     *             // Now you can do something with the chat model
     *         });
     *     }
     * });
     *
     * @example
     * // To open an array of chats, provide an array of JIDs:
     * converse.plugins.add('myplugin', {
     *     initialize: function () {
     *         const _converse = this._converse;
     *         // Note, these users must first be in your contacts roster!
     *         api.chats.open(['buddy1@example.com', 'buddy2@example.com']).then(chats => {
     *             // Now you can do something with the chat models
     *         });
     *     }
     * });
     */
    async open(jids, attrs, force) {
      if (typeof jids === 'string') {
        const chat = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.get(jids, attrs, true);
        if (chat) {
          return chat.maybeShow(force);
        }
        return chat;
      } else if (Array.isArray(jids)) {
        return Promise.all(jids.map(j => _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.get(j, attrs, true).then(c => c && c.maybeShow(force))).filter(c => c));
      }
      const err_msg = "chats.open: You need to provide at least one JID";
      _log_js__WEBPACK_IMPORTED_MODULE_1__["default"].error(err_msg);
      throw new Error(err_msg);
    },
    /**
     * Retrieves a chat or all chats.
     *
     * @method api.chats.get
     * @param {String|string[]} jids - e.g. 'buddy@example.com' or ['buddy1@example.com', 'buddy2@example.com']
     * @param {Object} [attrs] - Attributes to be set on the _converse.ChatBox model.
     * @param {Boolean} [create=false] - Whether the chat should be created if it's not found.
     * @returns { Promise<_converse.ChatBox> }
     *
     * @example
     * // To return a single chat, provide the JID of the contact you're chatting with in that chat:
     * const model = await api.chats.get('buddy@example.com');
     *
     * @example
     * // To return an array of chats, provide an array of JIDs:
     * const models = await api.chats.get(['buddy1@example.com', 'buddy2@example.com']);
     *
     * @example
     * // To return all open chats, call the method without any parameters::
     * const models = await api.chats.get();
     *
     */
    async get(jids) {
      let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      let create = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.waitUntil('chatBoxesFetched');
      async function _get(jid) {
        let model = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.get(jid);
        if (!model && create) {
          model = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.create(jid, attrs, _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.ChatBox);
        } else {
          model = model && model.get('type') === _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.PRIVATE_CHAT_TYPE ? model : null;
          if (model && Object.keys(attrs).length) {
            model.save(attrs);
          }
        }
        return model;
      }
      if (jids === undefined) {
        const chats = await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.get();
        return chats.filter(c => c.get('type') === _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.PRIVATE_CHAT_TYPE);
      } else if (typeof jids === 'string') {
        return _get(jids);
      }
      return Promise.all(jids.map(jid => _get(jid)));
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/chat/index.js":
/*!********************************************!*\
  !*** ./src/headless/plugins/chat/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _model_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./model.js */ "./src/headless/plugins/chat/model.js");
/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message.js */ "./src/headless/plugins/chat/message.js");
/* harmony import */ var _model_with_contact_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./model-with-contact.js */ "./src/headless/plugins/chat/model-with-contact.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/chat/api.js");
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/chat/utils.js");
/**
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */







_core_js__WEBPACK_IMPORTED_MODULE_5__.converse.plugins.add('converse-chat', {
  dependencies: ['converse-chatboxes', 'converse-disco'],
  initialize() {
    // Configuration values for this plugin
    // ====================================
    // Refer to docs/source/configuration.rst for explanations of these
    // configuration settings.
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.settings.extend({
      'allow_message_corrections': 'all',
      'allow_message_retraction': 'all',
      'allow_message_styling': true,
      'auto_join_private_chats': [],
      'clear_messages_on_reconnection': false,
      'filter_by_resource': false,
      'prune_messages_above': undefined,
      'pruning_behavior': 'unscrolled',
      'send_chat_markers': ['received', 'displayed', 'acknowledged'],
      'send_chat_state_notifications': true
    });
    _core_js__WEBPACK_IMPORTED_MODULE_5__._converse.Message = _model_with_contact_js__WEBPACK_IMPORTED_MODULE_2__["default"].extend(_message_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    _core_js__WEBPACK_IMPORTED_MODULE_5__._converse.Messages = _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_4__.Collection.extend({
      model: _core_js__WEBPACK_IMPORTED_MODULE_5__._converse.Message,
      comparator: 'time'
    });
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_5__._converse, {
      ChatBox: _model_js__WEBPACK_IMPORTED_MODULE_0__["default"],
      handleMessageStanza: _utils_js__WEBPACK_IMPORTED_MODULE_6__.handleMessageStanza
    });
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_5__.api, _api_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    _core_js__WEBPACK_IMPORTED_MODULE_5__._converse.router.route('converse/chat?jid=:jid', _utils_js__WEBPACK_IMPORTED_MODULE_6__.openChat);
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.listen.on('chatBoxesFetched', _utils_js__WEBPACK_IMPORTED_MODULE_6__.autoJoinChats);
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.listen.on('presencesInitialized', _utils_js__WEBPACK_IMPORTED_MODULE_6__.registerMessageHandlers);
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.listen.on('clearSession', _utils_js__WEBPACK_IMPORTED_MODULE_6__.onClearSession);
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.listen.on('connected', () => (0,_utils_js__WEBPACK_IMPORTED_MODULE_6__.enableCarbons)());
    _core_js__WEBPACK_IMPORTED_MODULE_5__.api.listen.on('reconnected', () => (0,_utils_js__WEBPACK_IMPORTED_MODULE_6__.enableCarbons)());
  }
});

/***/ }),

/***/ "./src/headless/plugins/chat/message.js":
/*!**********************************************!*\
  !*** ./src/headless/plugins/chat/message.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _model_with_contact_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./model-with-contact.js */ "./src/headless/plugins/chat/model-with-contact.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _log_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../log.js */ "./src/headless/log.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");





const {
  Strophe,
  sizzle,
  u
} = _core_js__WEBPACK_IMPORTED_MODULE_3__.converse.env;

/**
 * Mixin which turns a `ModelWithContact` model into a non-MUC message. These can be either `chat` messages or `headline` messages.
 * @mixin
 * @namespace _converse.Message
 * @memberOf _converse
 * @example const msg = new _converse.Message({'message': 'hello world!'});
 */
const MessageMixin = {
  defaults() {
    return {
      'msgid': u.getUniqueId(),
      'time': new Date().toISOString(),
      'is_ephemeral': false
    };
  },
  async initialize() {
    if (!this.checkValidity()) {
      return;
    }
    this.initialized = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_4__.getOpenPromise)();
    if (this.get('file')) {
      this.on('change:put', () => this.uploadFile());
    }
    // If `type` changes from `error` to `chat`, we want to set the contact. See #2733
    this.on('change:type', () => this.setContact());
    this.on('change:is_ephemeral', () => this.setTimerForEphemeralMessage());
    await this.setContact();
    this.setTimerForEphemeralMessage();
    /**
     * Triggered once a {@link _converse.Message} has been created and initialized.
     * @event _converse#messageInitialized
     * @type { _converse.Message}
     * @example _converse.api.listen.on('messageInitialized', model => { ... });
     */
    await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.trigger('messageInitialized', this, {
      'Synchronous': true
    });
    this.initialized.resolve();
  },
  setContact() {
    if (this.get('type') === 'chat') {
      _model_with_contact_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype.initialize.apply(this, arguments);
      this.setRosterContact(Strophe.getBareJidFromJid(this.get('from')));
    }
  },
  /**
   * Sets an auto-destruct timer for this message, if it's is_ephemeral.
   * @private
   * @method _converse.Message#setTimerForEphemeralMessage
   */
  setTimerForEphemeralMessage() {
    if (this.ephemeral_timer) {
      clearTimeout(this.ephemeral_timer);
    }
    const is_ephemeral = this.isEphemeral();
    if (is_ephemeral) {
      const timeout = typeof is_ephemeral === "number" ? is_ephemeral : 10000;
      this.ephemeral_timer = window.setTimeout(() => this.safeDestroy(), timeout);
    }
  },
  checkValidity() {
    if (Object.keys(this.attributes).length === 3) {
      // XXX: This is an empty message with only the 3 default values.
      // This seems to happen when saving a newly created message
      // fails for some reason.
      // TODO: This is likely fixable by setting `wait` when
      // creating messages. See the wait-for-messages branch.
      this.validationError = 'Empty message';
      this.safeDestroy();
      return false;
    }
    return true;
  },
  /**
   * Determines whether this messsage may be retracted by the current user.
   * @private
   * @method _converse.Messages#mayBeRetracted
   * @returns { Boolean }
   */
  mayBeRetracted() {
    const is_own_message = this.get('sender') === 'me';
    const not_canceled = this.get('error_type') !== 'cancel';
    return is_own_message && not_canceled && ['all', 'own'].includes(_core_js__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('allow_message_retraction'));
  },
  safeDestroy() {
    try {
      this.destroy();
    } catch (e) {
      _log_js__WEBPACK_IMPORTED_MODULE_2__["default"].warn(`safeDestroy: ${e}`);
    }
  },
  /**
   * Returns a boolean indicating whether this message is ephemeral,
   * meaning it will get automatically removed after ten seconds.
   * @returns { boolean }
   */
  isEphemeral() {
    return this.get('is_ephemeral');
  },
  /**
   * Returns a boolean indicating whether this message is a XEP-0245 /me command.
   * @returns { boolean }
   */
  isMeCommand() {
    const text = this.getMessageText();
    if (!text) {
      return false;
    }
    return text.startsWith('/me ');
  },
  /**
   * Returns a boolean indicating whether this message is considered a followup
   * message from the previous one. Followup messages are shown grouped together
   * under one author heading.
   * A message is considered a followup of it's predecessor when it's a chat
   * message from the same author, within 10 minutes.
   * @returns { boolean }
   */
  isFollowup() {
    const messages = this.collection.models;
    const idx = messages.indexOf(this);
    const prev_model = idx ? messages[idx - 1] : null;
    if (prev_model === null) {
      return false;
    }
    const date = dayjs__WEBPACK_IMPORTED_MODULE_1___default()(this.get('time'));
    return this.get('from') === prev_model.get('from') && !this.isMeCommand() && !prev_model.isMeCommand() && !!this.get('is_encrypted') === !!prev_model.get('is_encrypted') && this.get('type') === prev_model.get('type') && this.get('type') !== 'info' && date.isBefore(dayjs__WEBPACK_IMPORTED_MODULE_1___default()(prev_model.get('time')).add(10, 'minutes')) && (this.get('type') === 'groupchat' ? this.get('occupant_id') === prev_model.get('occupant_id') : true);
  },
  getDisplayName() {
    if (this.contact) {
      return this.contact.getDisplayName();
    } else if (this.vcard) {
      return this.vcard.getDisplayName();
    } else {
      return this.get('from');
    }
  },
  getMessageText() {
    if (this.get('is_encrypted')) {
      const {
        __
      } = _core_js__WEBPACK_IMPORTED_MODULE_3__._converse;
      return this.get('plaintext') || this.get('body') || __('Undecryptable OMEMO message');
    } else if (['groupchat', 'chat'].includes(this.get('type'))) {
      return this.get('body');
    } else {
      return this.get('message');
    }
  },
  /**
   * Send out an IQ stanza to request a file upload slot.
   * https://xmpp.org/extensions/xep-0363.html#request
   * @private
   * @method _converse.Message#sendSlotRequestStanza
   */
  sendSlotRequestStanza() {
    if (!this.file) {
      return Promise.reject(new Error('file is undefined'));
    }
    const iq = _core_js__WEBPACK_IMPORTED_MODULE_3__.converse.env.$iq({
      'from': _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.jid,
      'to': this.get('slot_request_url'),
      'type': 'get'
    }).c('request', {
      'xmlns': Strophe.NS.HTTPUPLOAD,
      'filename': this.file.name,
      'size': this.file.size,
      'content-type': this.file.type
    });
    return _core_js__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ(iq);
  },
  getUploadRequestMetadata(stanza) {
    const headers = sizzle(`slot[xmlns="${Strophe.NS.HTTPUPLOAD}"] put header`, stanza);
    // https://xmpp.org/extensions/xep-0363.html#request
    // TODO: Can't set the Cookie header in JavaScipt, instead cookies need
    // to be manually set via document.cookie, so we're leaving it out here.
    return {
      'headers': headers.map(h => ({
        'name': h.getAttribute('name'),
        'value': h.textContent
      })).filter(h => ['Authorization', 'Expires'].includes(h.name))
    };
  },
  async getRequestSlotURL() {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_3__._converse;
    let stanza;
    try {
      stanza = await this.sendSlotRequestStanza();
    } catch (e) {
      _log_js__WEBPACK_IMPORTED_MODULE_2__["default"].error(e);
      return this.save({
        'type': 'error',
        'message': __('Sorry, could not determine upload URL.'),
        'is_ephemeral': true
      });
    }
    const slot = sizzle(`slot[xmlns="${Strophe.NS.HTTPUPLOAD}"]`, stanza).pop();
    if (slot) {
      this.upload_metadata = this.getUploadRequestMetadata(stanza);
      this.save({
        'get': slot.querySelector('get').getAttribute('url'),
        'put': slot.querySelector('put').getAttribute('url')
      });
    } else {
      return this.save({
        'type': 'error',
        'message': __('Sorry, could not determine file upload URL.'),
        'is_ephemeral': true
      });
    }
  },
  uploadFile() {
    var _this$upload_metadata;
    const xhr = new XMLHttpRequest();
    xhr.onreadystatechange = async () => {
      if (xhr.readyState === XMLHttpRequest.DONE) {
        _log_js__WEBPACK_IMPORTED_MODULE_2__["default"].info('Status: ' + xhr.status);
        if (xhr.status === 200 || xhr.status === 201) {
          let attrs = {
            'upload': _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.SUCCESS,
            'oob_url': this.get('get'),
            'message': this.get('get'),
            'body': this.get('get')
          };
          /**
           * *Hook* which allows plugins to change the attributes
           * saved on the message once a file has been uploaded.
           * @event _converse#afterFileUploaded
           */
          attrs = await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.hook('afterFileUploaded', this, attrs);
          this.save(attrs);
        } else {
          xhr.onerror();
        }
      }
    };
    xhr.upload.addEventListener('progress', evt => {
      if (evt.lengthComputable) {
        this.set('progress', evt.loaded / evt.total);
      }
    }, false);
    xhr.onerror = () => {
      const {
        __
      } = _core_js__WEBPACK_IMPORTED_MODULE_3__._converse;
      let message;
      if (xhr.responseText) {
        message = __('Sorry, could not succesfully upload your file. Your server’s response: "%1$s"', xhr.responseText);
      } else {
        message = __('Sorry, could not succesfully upload your file.');
      }
      this.save({
        'type': 'error',
        'upload': _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.FAILURE,
        'message': message,
        'is_ephemeral': true
      });
    };
    xhr.open('PUT', this.get('put'), true);
    xhr.setRequestHeader('Content-type', this.file.type);
    (_this$upload_metadata = this.upload_metadata.headers) === null || _this$upload_metadata === void 0 ? void 0 : _this$upload_metadata.forEach(h => xhr.setRequestHeader(h.name, h.value));
    xhr.send(this.file);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MessageMixin);

/***/ }),

/***/ "./src/headless/plugins/chat/model-with-contact.js":
/*!*********************************************************!*\
  !*** ./src/headless/plugins/chat/model-with-contact.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");



const ModelWithContact = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__.Model.extend({
  initialize() {
    this.rosterContactAdded = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_2__.getOpenPromise)();
  },
  async setRosterContact(jid) {
    const contact = await _core_js__WEBPACK_IMPORTED_MODULE_1__.api.contacts.get(jid);
    if (contact) {
      this.contact = contact;
      this.set('nickname', contact.get('nickname'));
      this.rosterContactAdded.resolve();
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModelWithContact);

/***/ }),

/***/ "./src/headless/plugins/chat/model.js":
/*!********************************************!*\
  !*** ./src/headless/plugins/chat/model.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _model_with_contact_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./model-with-contact.js */ "./src/headless/plugins/chat/model-with-contact.js");
/* harmony import */ var filesize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! filesize */ "./node_modules/filesize/lib/filesize.min.js");
/* harmony import */ var filesize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(filesize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_es_isMatch__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! lodash-es/isMatch */ "./node_modules/lodash-es/isMatch.js");
/* harmony import */ var lodash_es_isObject__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash-es/isObject */ "./node_modules/lodash-es/isObject.js");
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var lodash_es_pick__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! lodash-es/pick */ "./node_modules/lodash-es/pick.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_shared_chat_utils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/shared/chat/utils.js */ "./src/headless/shared/chat/utils.js");
/* harmony import */ var _converse_headless_shared_parsers_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @converse/headless/shared/parsers.js */ "./src/headless/shared/parsers.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");
/* harmony import */ var _converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @converse/headless/utils/storage.js */ "./src/headless/utils/storage.js");
/* harmony import */ var _utils_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/core.js */ "./src/headless/utils/core.js");
/* harmony import */ var _parsers_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./parsers.js */ "./src/headless/plugins/chat/parsers.js");
/* harmony import */ var _converse_headless_shared_actions_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @converse/headless/shared/actions.js */ "./src/headless/shared/actions.js");















const {
  Strophe,
  $msg
} = _core_js__WEBPACK_IMPORTED_MODULE_4__.converse.env;
const u = _core_js__WEBPACK_IMPORTED_MODULE_4__.converse.env.utils;

/**
 * Represents an open/ongoing chat conversation.
 *
 * @class
 * @namespace _converse.ChatBox
 * @memberOf _converse
 */
const ChatBox = _model_with_contact_js__WEBPACK_IMPORTED_MODULE_0__["default"].extend({
  defaults() {
    return {
      'bookmarked': false,
      'chat_state': undefined,
      'hidden': (0,_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.isUniView)() && !_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('singleton'),
      'message_type': 'chat',
      'nickname': undefined,
      'num_unread': 0,
      'time_opened': this.get('time_opened') || new Date().getTime(),
      'time_sent': new Date(0).toISOString(),
      'type': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.PRIVATE_CHAT_TYPE,
      'url': ''
    };
  },
  async initialize() {
    this.initialized = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_7__.getOpenPromise)();
    _model_with_contact_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype.initialize.apply(this, arguments);
    const jid = this.get('jid');
    if (!jid) {
      // XXX: The `validate` method will prevent this model
      // from being persisted if there's no jid, but that gets
      // called after model instantiation, so we have to deal
      // with invalid models here also.
      // This happens when the controlbox is in browser storage,
      // but we're in embedded mode.
      return;
    }
    this.set({
      'box_id': `box-${jid}`
    });
    this.initNotifications();
    this.initUI();
    this.initMessages();
    if (this.get('type') === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.PRIVATE_CHAT_TYPE) {
      this.presence = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.presences.get(jid) || _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.presences.create({
        jid
      });
      await this.setRosterContact(jid);
      this.presence.on('change:show', item => this.onPresenceChanged(item));
    }
    this.on('change:chat_state', this.sendChatState, this);
    this.ui.on('change:scrolled', this.onScrolledChanged, this);
    await this.fetchMessages();
    /**
     * Triggered once a {@link _converse.ChatBox} has been created and initialized.
     * @event _converse#chatBoxInitialized
     * @type { _converse.ChatBox}
     * @example _converse.api.listen.on('chatBoxInitialized', model => { ... });
     */
    await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('chatBoxInitialized', this, {
      'Synchronous': true
    });
    this.initialized.resolve();
  },
  getMessagesCollection() {
    return new _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.Messages();
  },
  getMessagesCacheKey() {
    return `converse.messages-${this.get('jid')}-${_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bare_jid}`;
  },
  initMessages() {
    this.messages = this.getMessagesCollection();
    this.messages.fetched = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_7__.getOpenPromise)();
    this.messages.chatbox = this;
    (0,_converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_8__.initStorage)(this.messages, this.getMessagesCacheKey());
    this.listenTo(this.messages, 'change:upload', this.onMessageUploadChanged, this);
    this.listenTo(this.messages, 'add', this.onMessageAdded, this);
  },
  initUI() {
    this.ui = new _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__.Model();
  },
  initNotifications() {
    this.notifications = new _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__.Model();
  },
  getNotificationsText() {
    var _this$notifications, _this$notifications2, _this$notifications3;
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse;
    if (((_this$notifications = this.notifications) === null || _this$notifications === void 0 ? void 0 : _this$notifications.get('chat_state')) === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.COMPOSING) {
      return __('%1$s is typing', this.getDisplayName());
    } else if (((_this$notifications2 = this.notifications) === null || _this$notifications2 === void 0 ? void 0 : _this$notifications2.get('chat_state')) === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.PAUSED) {
      return __('%1$s has stopped typing', this.getDisplayName());
    } else if (((_this$notifications3 = this.notifications) === null || _this$notifications3 === void 0 ? void 0 : _this$notifications3.get('chat_state')) === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.GONE) {
      return __('%1$s has gone away', this.getDisplayName());
    } else {
      return '';
    }
  },
  afterMessagesFetched() {
    this.pruneHistoryWhenScrolledDown();
    /**
     * Triggered whenever a { @link _converse.ChatBox } or ${ @link _converse.ChatRoom }
     * has fetched its messages from the local cache.
     * @event _converse#afterMessagesFetched
     * @type { _converse.ChatBox| _converse.ChatRoom }
     * @example _converse.api.listen.on('afterMessagesFetched', (chat) => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('afterMessagesFetched', this);
  },
  fetchMessages() {
    if (this.messages.fetched_flag) {
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].info(`Not re-fetching messages for ${this.get('jid')}`);
      return;
    }
    this.messages.fetched_flag = true;
    const resolve = this.messages.fetched.resolve;
    this.messages.fetch({
      'add': true,
      'success': msgs => {
        this.afterMessagesFetched(msgs);
        resolve();
      },
      'error': () => {
        this.afterMessagesFetched();
        resolve();
      }
    });
    return this.messages.fetched;
  },
  async handleErrorMessageStanza(stanza) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse;
    const attrs = await (0,_parsers_js__WEBPACK_IMPORTED_MODULE_10__.parseMessage)(stanza, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse);
    if (!(await this.shouldShowErrorMessage(attrs))) {
      return;
    }
    const message = this.getMessageReferencedByError(attrs);
    if (message) {
      const new_attrs = {
        'error': attrs.error,
        'error_condition': attrs.error_condition,
        'error_text': attrs.error_text,
        'error_type': attrs.error_type,
        'editable': false
      };
      if (attrs.msgid === message.get('retraction_id')) {
        // The error message refers to a retraction
        new_attrs.retraction_id = undefined;
        if (!attrs.error) {
          if (attrs.error_condition === 'forbidden') {
            new_attrs.error = __("You're not allowed to retract your message.");
          } else {
            new_attrs.error = __('Sorry, an error occurred while trying to retract your message.');
          }
        }
      } else if (!attrs.error) {
        if (attrs.error_condition === 'forbidden') {
          new_attrs.error = __("You're not allowed to send a message.");
        } else {
          new_attrs.error = __('Sorry, an error occurred while trying to send your message.');
        }
      }
      message.save(new_attrs);
    } else {
      this.createMessage(attrs);
    }
  },
  /**
   * Queue an incoming `chat` message stanza for processing.
   * @async
   * @private
   * @method _converse.ChatBox#queueMessage
   * @param { Promise<MessageAttributes> } attrs - A promise which resolves to the message attributes
   */
  queueMessage(attrs) {
    this.msg_chain = (this.msg_chain || this.messages.fetched).then(() => this.onMessage(attrs)).catch(e => _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(e));
    return this.msg_chain;
  },
  /**
   * @async
   * @private
   * @method _converse.ChatBox#onMessage
   * @param { MessageAttributes } attrs_promse - A promise which resolves to the message attributes.
   */
  async onMessage(attrs) {
    attrs = await attrs;
    if (u.isErrorObject(attrs)) {
      attrs.stanza && _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(attrs.stanza);
      return _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(attrs.message);
    }
    const message = this.getDuplicateMessage(attrs);
    if (message) {
      this.updateMessage(message, attrs);
    } else if (!this.handleReceipt(attrs) && !this.handleChatMarker(attrs) && !(await this.handleRetraction(attrs))) {
      this.setEditable(attrs, attrs.time);
      if (attrs['chat_state'] && attrs.sender === 'them') {
        this.notifications.set('chat_state', attrs.chat_state);
      }
      if (u.shouldCreateMessage(attrs)) {
        const msg = (await (0,_converse_headless_shared_chat_utils_js__WEBPACK_IMPORTED_MODULE_5__.handleCorrection)(this, attrs)) || (await this.createMessage(attrs));
        this.notifications.set({
          'chat_state': null
        });
        this.handleUnreadMessage(msg);
      }
    }
  },
  async onMessageUploadChanged(message) {
    if (message.get('upload') === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.SUCCESS) {
      const attrs = {
        'body': message.get('body'),
        'spoiler_hint': message.get('spoiler_hint'),
        'oob_url': message.get('oob_url')
      };
      await this.sendMessage(attrs);
      message.destroy();
    }
  },
  onMessageAdded(message) {
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('prune_messages_above') && (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('pruning_behavior') === 'scrolled' || !this.ui.get('scrolled')) && !(0,_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.isEmptyMessage)(message)) {
      (0,_converse_headless_shared_chat_utils_js__WEBPACK_IMPORTED_MODULE_5__.debouncedPruneHistory)(this);
    }
  },
  async clearMessages() {
    try {
      await this.messages.clearStore();
    } catch (e) {
      this.messages.trigger('reset');
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(e);
    } finally {
      // No point in fetching messages from the cache if it's been cleared.
      // Make sure to resolve the fetched promise to avoid freezes.
      this.messages.fetched.resolve();
    }
  },
  async close() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.connection.connected()) {
      // Immediately sending the chat state, because the
      // model is going to be destroyed afterwards.
      this.setChatState(_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.INACTIVE);
      this.sendChatState();
    }
    try {
      await new Promise((success, reject) => {
        return this.destroy({
          success,
          'error': (m, e) => reject(e)
        });
      });
    } catch (e) {
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(e);
    } finally {
      if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('clear_messages_on_reconnection')) {
        await this.clearMessages();
      }
    }
    /**
     * Triggered once a chatbox has been closed.
     * @event _converse#chatBoxClosed
     * @type {_converse.ChatBox | _converse.ChatRoom}
     * @example _converse.api.listen.on('chatBoxClosed', chat => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('chatBoxClosed', this);
  },
  announceReconnection() {
    /**
     * Triggered whenever a `_converse.ChatBox` instance has reconnected after an outage
     * @event _converse#onChatReconnected
     * @type {_converse.ChatBox | _converse.ChatRoom}
     * @example _converse.api.listen.on('onChatReconnected', chat => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('chatReconnected', this);
  },
  async onReconnection() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('clear_messages_on_reconnection')) {
      await this.clearMessages();
    }
    this.announceReconnection();
  },
  onPresenceChanged(item) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse;
    const show = item.get('show');
    const fullname = this.getDisplayName();
    let text;
    if (show === 'offline') {
      text = __('%1$s has gone offline', fullname);
    } else if (show === 'away') {
      text = __('%1$s has gone away', fullname);
    } else if (show === 'dnd') {
      text = __('%1$s is busy', fullname);
    } else if (show === 'online') {
      text = __('%1$s is online', fullname);
    }
    text && this.createMessage({
      'message': text,
      'type': 'info'
    });
  },
  onScrolledChanged() {
    if (!this.ui.get('scrolled')) {
      this.clearUnreadMsgCounter();
      this.pruneHistoryWhenScrolledDown();
    }
  },
  pruneHistoryWhenScrolledDown() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('prune_messages_above') && _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('pruning_behavior') === 'unscrolled' && !this.ui.get('scrolled')) {
      (0,_converse_headless_shared_chat_utils_js__WEBPACK_IMPORTED_MODULE_5__.debouncedPruneHistory)(this);
    }
  },
  validate(attrs) {
    if (!attrs.jid) {
      return 'Ignored ChatBox without JID';
    }
    const room_jids = _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('auto_join_rooms').map(s => (0,lodash_es_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(s) ? s.jid : s);
    const auto_join = _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('auto_join_private_chats').concat(room_jids);
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get("singleton") && !auto_join.includes(attrs.jid) && !_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('auto_join_on_invite')) {
      const msg = `${attrs.jid} is not allowed because singleton is true and it's not being auto_joined`;
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].warn(msg);
      return msg;
    }
  },
  getDisplayName() {
    if (this.contact) {
      return this.contact.getDisplayName();
    } else if (this.vcard) {
      return this.vcard.getDisplayName();
    } else {
      return this.get('jid');
    }
  },
  async createMessageFromError(error) {
    if (error instanceof _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.TimeoutError) {
      const msg = await this.createMessage({
        'type': 'error',
        'message': error.message,
        'retry_event_id': error.retry_event_id,
        'is_ephemeral': 30000
      });
      msg.error = error;
    }
  },
  editEarlierMessage() {
    let message;
    let idx = this.messages.findLastIndex('correcting');
    if (idx >= 0) {
      this.messages.at(idx).save('correcting', false);
      while (idx > 0) {
        idx -= 1;
        const candidate = this.messages.at(idx);
        if (candidate.get('editable')) {
          message = candidate;
          break;
        }
      }
    }
    message = message || this.messages.filter({
      'sender': 'me'
    }).reverse().find(m => m.get('editable'));
    if (message) {
      message.save('correcting', true);
    }
  },
  editLaterMessage() {
    let message;
    let idx = this.messages.findLastIndex('correcting');
    if (idx >= 0) {
      this.messages.at(idx).save('correcting', false);
      while (idx < this.messages.length - 1) {
        idx += 1;
        const candidate = this.messages.at(idx);
        if (candidate.get('editable')) {
          message = candidate;
          message.save('correcting', true);
          break;
        }
      }
    }
    return message;
  },
  getOldestMessage() {
    for (let i = 0; i < this.messages.length; i++) {
      const message = this.messages.at(i);
      if (message.get('type') === this.get('message_type')) {
        return message;
      }
    }
  },
  getMostRecentMessage() {
    for (let i = this.messages.length - 1; i >= 0; i--) {
      const message = this.messages.at(i);
      if (message.get('type') === this.get('message_type')) {
        return message;
      }
    }
  },
  getUpdatedMessageAttributes(message, attrs) {
    if (!attrs.error_type && message.get('error_type') === 'Decryption') {
      // Looks like we have a failed decrypted message stored, and now
      // we have a properly decrypted version of the same message.
      // See issue: https://github.com/conversejs/converse.js/issues/2733#issuecomment-1035493594
      return Object.assign({}, attrs, {
        error_condition: undefined,
        error_message: undefined,
        error_text: undefined,
        error_type: undefined,
        is_archived: attrs.is_archived,
        is_ephemeral: false,
        is_error: false
      });
    } else {
      return {
        is_archived: attrs.is_archived
      };
    }
  },
  updateMessage(message, attrs) {
    const new_attrs = this.getUpdatedMessageAttributes(message, attrs);
    new_attrs && message.save(new_attrs);
  },
  /**
   * Mutator for setting the chat state of this chat session.
   * Handles clearing of any chat state notification timeouts and
   * setting new ones if necessary.
   * Timeouts are set when the  state being set is COMPOSING or PAUSED.
   * After the timeout, COMPOSING will become PAUSED and PAUSED will become INACTIVE.
   * See XEP-0085 Chat State Notifications.
   * @private
   * @method _converse.ChatBox#setChatState
   * @param { string } state - The chat state (consts ACTIVE, COMPOSING, PAUSED, INACTIVE, GONE)
   */
  setChatState(state, options) {
    if (this.chat_state_timeout !== undefined) {
      window.clearTimeout(this.chat_state_timeout);
      delete this.chat_state_timeout;
    }
    if (state === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.COMPOSING) {
      this.chat_state_timeout = window.setTimeout(this.setChatState.bind(this), _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.TIMEOUTS.PAUSED, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.PAUSED);
    } else if (state === _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.PAUSED) {
      this.chat_state_timeout = window.setTimeout(this.setChatState.bind(this), _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.TIMEOUTS.INACTIVE, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.INACTIVE);
    }
    this.set('chat_state', state, options);
    return this;
  },
  /**
   * Given an error `<message>` stanza's attributes, find the saved message model which is
   * referenced by that error.
   * @param { Object } attrs
   */
  getMessageReferencedByError(attrs) {
    const id = attrs.msgid;
    return id && this.messages.models.find(m => [m.get('msgid'), m.get('retraction_id')].includes(id));
  },
  /**
   * @private
   * @method _converse.ChatBox#shouldShowErrorMessage
   * @returns {boolean}
   */
  shouldShowErrorMessage(attrs) {
    const msg = this.getMessageReferencedByError(attrs);
    if (!msg && attrs.chat_state) {
      // If the error refers to a message not included in our store,
      // and it has a chat state tag, we assume that this was a
      // CSI message (which we don't store).
      // See https://github.com/conversejs/converse.js/issues/1317
      return;
    }
    // Gets overridden in ChatRoom
    return true;
  },
  isSameUser(jid1, jid2) {
    return u.isSameBareJID(jid1, jid2);
  },
  /**
   * Looks whether we already have a retraction for this
   * incoming message. If so, it's considered "dangling" because it
   * probably hasn't been applied to anything yet, given that the
   * relevant message is only coming in now.
   * @private
   * @method _converse.ChatBox#findDanglingRetraction
   * @param { object } attrs - Attributes representing a received
   *  message, as returned by {@link parseMessage}
   * @returns { _converse.Message }
   */
  findDanglingRetraction(attrs) {
    if (!attrs.origin_id || !this.messages.length) {
      return null;
    }
    // Only look for dangling retractions if there are newer
    // messages than this one, since retractions come after.
    if (this.messages.last().get('time') > attrs.time) {
      // Search from latest backwards
      const messages = Array.from(this.messages.models);
      messages.reverse();
      return messages.find(_ref => {
        let {
          attributes
        } = _ref;
        return attributes.retracted_id === attrs.origin_id && attributes.from === attrs.from && !attributes.moderated_by;
      });
    }
  },
  /**
   * Handles message retraction based on the passed in attributes.
   * @private
   * @method _converse.ChatBox#handleRetraction
   * @param { object } attrs - Attributes representing a received
   *  message, as returned by {@link parseMessage}
   * @returns { Boolean } Returns `true` or `false` depending on
   *  whether a message was retracted or not.
   */
  async handleRetraction(attrs) {
    const RETRACTION_ATTRIBUTES = ['retracted', 'retracted_id', 'editable'];
    if (attrs.retracted) {
      if (attrs.is_tombstone) {
        return false;
      }
      const message = this.messages.findWhere({
        'origin_id': attrs.retracted_id,
        'from': attrs.from
      });
      if (!message) {
        attrs['dangling_retraction'] = true;
        await this.createMessage(attrs);
        return true;
      }
      message.save((0,lodash_es_pick__WEBPACK_IMPORTED_MODULE_13__["default"])(attrs, RETRACTION_ATTRIBUTES));
      return true;
    } else {
      // Check if we have dangling retraction
      const message = this.findDanglingRetraction(attrs);
      if (message) {
        const retraction_attrs = (0,lodash_es_pick__WEBPACK_IMPORTED_MODULE_13__["default"])(message.attributes, RETRACTION_ATTRIBUTES);
        const new_attrs = Object.assign({
          'dangling_retraction': false
        }, attrs, retraction_attrs);
        delete new_attrs['id']; // Delete id, otherwise a new cache entry gets created
        message.save(new_attrs);
        return true;
      }
    }
    return false;
  },
  /**
   * Returns an already cached message (if it exists) based on the
   * passed in attributes map.
   * @private
   * @method _converse.ChatBox#getDuplicateMessage
   * @param { object } attrs - Attributes representing a received
   *  message, as returned by {@link parseMessage}
   * @returns {Promise<_converse.Message>}
   */
  getDuplicateMessage(attrs) {
    const queries = [...this.getStanzaIdQueryAttrs(attrs), this.getOriginIdQueryAttrs(attrs), this.getMessageBodyQueryAttrs(attrs)].filter(s => s);
    const msgs = this.messages.models;
    return msgs.find(m => queries.reduce((out, q) => out || (0,lodash_es_isMatch__WEBPACK_IMPORTED_MODULE_14__["default"])(m.attributes, q), false));
  },
  getOriginIdQueryAttrs(attrs) {
    return attrs.origin_id && {
      'origin_id': attrs.origin_id,
      'from': attrs.from
    };
  },
  getStanzaIdQueryAttrs(attrs) {
    const keys = Object.keys(attrs).filter(k => k.startsWith('stanza_id '));
    return keys.map(key => {
      const by_jid = key.replace(/^stanza_id /, '');
      const query = {};
      query[`stanza_id ${by_jid}`] = attrs[key];
      return query;
    });
  },
  getMessageBodyQueryAttrs(attrs) {
    if (attrs.msgid) {
      const query = {
        'from': attrs.from,
        'msgid': attrs.msgid
      };
      // XXX: Need to take XEP-428 <fallback> into consideration
      if (!attrs.is_encrypted && attrs.body) {
        // We can't match the message if it's a reflected
        // encrypted message (e.g. via MAM or in a MUC)
        query['body'] = attrs.body;
      }
      return query;
    }
  },
  /**
   * Retract one of your messages in this chat
   * @private
   * @method _converse.ChatBoxView#retractOwnMessage
   * @param { _converse.Message } message - The message which we're retracting.
   */
  retractOwnMessage(message) {
    this.sendRetractionMessage(message);
    message.save({
      'retracted': new Date().toISOString(),
      'retracted_id': message.get('origin_id'),
      'retraction_id': message.get('id'),
      'is_ephemeral': true,
      'editable': false
    });
  },
  /**
   * Sends a message stanza to retract a message in this chat
   * @private
   * @method _converse.ChatBox#sendRetractionMessage
   * @param { _converse.Message } message - The message which we're retracting.
   */
  sendRetractionMessage(message) {
    const origin_id = message.get('origin_id');
    if (!origin_id) {
      throw new Error("Can't retract message without a XEP-0359 Origin ID");
    }
    const msg = $msg({
      'id': u.getUniqueId(),
      'to': this.get('jid'),
      'type': "chat"
    }).c('store', {
      xmlns: Strophe.NS.HINTS
    }).up().c("apply-to", {
      'id': origin_id,
      'xmlns': Strophe.NS.FASTEN
    }).c('retract', {
      xmlns: Strophe.NS.RETRACT
    });
    return _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.send(msg);
  },
  /**
   * Finds the last eligible message and then sends a XEP-0333 chat marker for it.
   * @param { ('received'|'displayed'|'acknowledged') } [type='displayed']
   * @param { Boolean } force - Whether a marker should be sent for the
   *  message, even if it didn't include a `markable` element.
   */
  sendMarkerForLastMessage() {
    let type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'displayed';
    let force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    const msgs = Array.from(this.messages.models);
    msgs.reverse();
    const msg = msgs.find(m => m.get('sender') === 'them' && (force || m.get('is_markable')));
    msg && this.sendMarkerForMessage(msg, type, force);
  },
  /**
   * Given the passed in message object, send a XEP-0333 chat marker.
   * @param { _converse.Message } msg
   * @param { ('received'|'displayed'|'acknowledged') } [type='displayed']
   * @param { Boolean } force - Whether a marker should be sent for the
   *  message, even if it didn't include a `markable` element.
   */
  sendMarkerForMessage(msg) {
    let type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'displayed';
    let force = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (!msg || !_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('send_chat_markers').includes(type)) {
      return;
    }
    if (msg !== null && msg !== void 0 && msg.get('is_markable') || force) {
      const from_jid = Strophe.getBareJidFromJid(msg.get('from'));
      (0,_converse_headless_shared_actions_js__WEBPACK_IMPORTED_MODULE_11__.sendMarker)(from_jid, msg.get('msgid'), type, msg.get('type'));
    }
  },
  handleChatMarker(attrs) {
    const to_bare_jid = Strophe.getBareJidFromJid(attrs.to);
    if (to_bare_jid !== _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bare_jid) {
      return false;
    }
    if (attrs.is_markable) {
      if (this.contact && !attrs.is_archived && !attrs.is_carbon) {
        (0,_converse_headless_shared_actions_js__WEBPACK_IMPORTED_MODULE_11__.sendMarker)(attrs.from, attrs.msgid, 'received');
      }
      return false;
    } else if (attrs.marker_id) {
      const message = this.messages.findWhere({
        'msgid': attrs.marker_id
      });
      const field_name = `marker_${attrs.marker}`;
      if (message && !message.get(field_name)) {
        message.save({
          field_name: new Date().toISOString()
        });
      }
      return true;
    }
  },
  sendReceiptStanza(to_jid, id) {
    const receipt_stanza = $msg({
      'from': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.jid,
      'id': u.getUniqueId(),
      'to': to_jid,
      'type': 'chat'
    }).c('received', {
      'xmlns': Strophe.NS.RECEIPTS,
      'id': id
    }).up().c('store', {
      'xmlns': Strophe.NS.HINTS
    }).up();
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.send(receipt_stanza);
  },
  handleReceipt(attrs) {
    if (attrs.sender === 'them') {
      if (attrs.is_valid_receipt_request) {
        this.sendReceiptStanza(attrs.from, attrs.msgid);
      } else if (attrs.receipt_id) {
        const message = this.messages.findWhere({
          'msgid': attrs.receipt_id
        });
        if (message && !message.get('received')) {
          message.save({
            'received': new Date().toISOString()
          });
        }
        return true;
      }
    }
    return false;
  },
  /**
   * Given a {@link _converse.Message} return the XML stanza that represents it.
   * @private
   * @method _converse.ChatBox#createMessageStanza
   * @param { _converse.Message } message - The message object
   */
  async createMessageStanza(message) {
    const stanza = $msg({
      'from': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.connection.jid,
      'to': this.get('jid'),
      'type': this.get('message_type'),
      'id': message.get('edited') && u.getUniqueId() || message.get('msgid')
    }).c('body').t(message.get('body')).up().c(_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.ACTIVE, {
      'xmlns': Strophe.NS.CHATSTATES
    }).root();
    if (message.get('type') === 'chat') {
      stanza.c('request', {
        'xmlns': Strophe.NS.RECEIPTS
      }).root();
    }
    if (!message.get('is_encrypted')) {
      if (message.get('is_spoiler')) {
        if (message.get('spoiler_hint')) {
          stanza.c('spoiler', {
            'xmlns': Strophe.NS.SPOILER
          }, message.get('spoiler_hint')).root();
        } else {
          stanza.c('spoiler', {
            'xmlns': Strophe.NS.SPOILER
          }).root();
        }
      }
      (message.get('references') || []).forEach(reference => {
        const attrs = {
          'xmlns': Strophe.NS.REFERENCE,
          'begin': reference.begin,
          'end': reference.end,
          'type': reference.type
        };
        if (reference.uri) {
          attrs.uri = reference.uri;
        }
        stanza.c('reference', attrs).root();
      });
      if (message.get('oob_url')) {
        stanza.c('x', {
          'xmlns': Strophe.NS.OUTOFBAND
        }).c('url').t(message.get('oob_url')).root();
      }
    }
    if (message.get('edited')) {
      stanza.c('replace', {
        'xmlns': Strophe.NS.MESSAGE_CORRECT,
        'id': message.get('msgid')
      }).root();
    }
    if (message.get('origin_id')) {
      stanza.c('origin-id', {
        'xmlns': Strophe.NS.SID,
        'id': message.get('origin_id')
      }).root();
    }
    stanza.root();
    /**
     * *Hook* which allows plugins to update an outgoing message stanza
     * @event _converse#createMessageStanza
     * @param { _converse.ChatBox | _converse.ChatRoom } - The chat from
     *      which this message stanza is being sent.
     * @param { Object } data - Message data
     * @param { _converse.Message | _converse.ChatRoomMessage } data.message
     *      The message object from which the stanza is created and which gets persisted to storage.
     * @param { Strophe.Builder } data.stanza
     *      The stanza that will be sent out, as a Strophe.Builder object.
     *      You can use the Strophe.Builder functions to extend the stanza.
     *      See http://strophe.im/strophejs/doc/1.4.3/files/strophe-umd-js.html#Strophe.Builder.Functions
     */
    const data = await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.hook('createMessageStanza', this, {
      message,
      stanza
    });
    return data.stanza;
  },
  async getOutgoingMessageAttributes(attrs) {
    var _attrs;
    await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.emojis.initialize();
    const is_spoiler = !!this.get('composing_spoiler');
    const origin_id = u.getUniqueId();
    const text = (_attrs = attrs) === null || _attrs === void 0 ? void 0 : _attrs.body;
    const body = text ? u.shortnamesToUnicode(text) : undefined;
    attrs = Object.assign({}, attrs, {
      'from': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.bare_jid,
      'fullname': _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.xmppstatus.get('fullname'),
      'id': origin_id,
      'is_only_emojis': text ? u.isOnlyEmojis(text) : false,
      'jid': this.get('jid'),
      'message': body,
      'msgid': origin_id,
      'nickname': this.get('nickname'),
      'sender': 'me',
      'time': new Date().toISOString(),
      'type': this.get('message_type'),
      body,
      is_spoiler,
      origin_id
    }, (0,_converse_headless_shared_parsers_js__WEBPACK_IMPORTED_MODULE_6__.getMediaURLsMetadata)(text));

    /**
     * *Hook* which allows plugins to update the attributes of an outgoing message.
     * These attributes get set on the { @link _converse.Message } or
     * { @link _converse.ChatRoomMessage } and persisted to storage.
     * @event _converse#getOutgoingMessageAttributes
     * @param { _converse.ChatBox | _converse.ChatRoom } chat
     *      The chat from which this message will be sent.
     * @param { MessageAttributes } attrs
     *      The message attributes, from which the stanza will be created.
     */
    attrs = await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.hook('getOutgoingMessageAttributes', this, attrs);
    return attrs;
  },
  /**
   * Responsible for setting the editable attribute of messages.
   * If api.settings.get('allow_message_corrections') is "last", then only the last
   * message sent from me will be editable. If set to "all" all messages
   * will be editable. Otherwise no messages will be editable.
   * @method _converse.ChatBox#setEditable
   * @memberOf _converse.ChatBox
   * @param { Object } attrs An object containing message attributes.
   * @param { String } send_time - time when the message was sent
   */
  setEditable(attrs, send_time) {
    if (attrs.is_headline || (0,_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.isEmptyMessage)(attrs) || attrs.sender !== 'me') {
      return;
    }
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('allow_message_corrections') === 'all') {
      attrs.editable = !(attrs.file || attrs.retracted || 'oob_url' in attrs);
    } else if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('allow_message_corrections') === 'last' && send_time > this.get('time_sent')) {
      var _this$messages$findWh;
      this.set({
        'time_sent': send_time
      });
      (_this$messages$findWh = this.messages.findWhere({
        'editable': true
      })) === null || _this$messages$findWh === void 0 ? void 0 : _this$messages$findWh.save({
        'editable': false
      });
      attrs.editable = !(attrs.file || attrs.retracted || 'oob_url' in attrs);
    }
  },
  /**
   * Queue the creation of a message, to make sure that we don't run
   * into a race condition whereby we're creating a new message
   * before the collection has been fetched.
   * @async
   * @private
   * @method _converse.ChatBox#createMessage
   * @param { Object } attrs
   */
  async createMessage(attrs, options) {
    attrs.time = attrs.time || new Date().toISOString();
    await this.messages.fetched;
    return this.messages.create(attrs, options);
  },
  /**
   * Responsible for sending off a text message inside an ongoing chat conversation.
   * @private
   * @method _converse.ChatBox#sendMessage
   * @memberOf _converse.ChatBox
   * @param { Object } [attrs] - A map of attributes to be saved on the message
   * @returns { _converse.Message }
   * @example
   * const chat = api.chats.get('buddy1@example.org');
   * chat.sendMessage({'body': 'hello world'});
   */
  async sendMessage(attrs) {
    attrs = await this.getOutgoingMessageAttributes(attrs);
    let message = this.messages.findWhere('correcting');
    if (message) {
      const older_versions = message.get('older_versions') || {};
      const edited_time = message.get('edited') || message.get('time');
      older_versions[edited_time] = message.getMessageText();
      message.save({
        ...(0,lodash_es_pick__WEBPACK_IMPORTED_MODULE_13__["default"])(attrs, ['body', 'is_only_emojis', 'media_urls', 'references', 'is_encrypted']),
        ...{
          'correcting': false,
          'edited': new Date().toISOString(),
          'message': attrs.body,
          'ogp_metadata': [],
          'origin_id': u.getUniqueId(),
          'received': undefined,
          older_versions,
          plaintext: attrs.is_encrypted ? attrs.message : undefined
        }
      });
    } else {
      this.setEditable(attrs, new Date().toISOString());
      message = await this.createMessage(attrs);
    }
    try {
      const stanza = await this.createMessageStanza(message);
      _core_js__WEBPACK_IMPORTED_MODULE_4__.api.send(stanza);
    } catch (e) {
      message.destroy();
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_2__["default"].error(e);
      return;
    }

    /**
     * Triggered when a message is being sent out
     * @event _converse#sendMessage
     * @type { Object }
     * @param { Object } data
     * @property { (_converse.ChatBox | _converse.ChatRoom) } data.chatbox
     * @property { (_converse.Message | _converse.ChatRoomMessage) } data.message
     */
    _core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('sendMessage', {
      'chatbox': this,
      message
    });
    return message;
  },
  /**
   * Sends a message with the current XEP-0085 chat state of the user
   * as taken from the `chat_state` attribute of the {@link _converse.ChatBox}.
   * @private
   * @method _converse.ChatBox#sendChatState
   */
  sendChatState() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('send_chat_state_notifications') && this.get('chat_state')) {
      const allowed = _core_js__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('send_chat_state_notifications');
      if (Array.isArray(allowed) && !allowed.includes(this.get('chat_state'))) {
        return;
      }
      _core_js__WEBPACK_IMPORTED_MODULE_4__.api.send($msg({
        'id': u.getUniqueId(),
        'to': this.get('jid'),
        'type': 'chat'
      }).c(this.get('chat_state'), {
        'xmlns': Strophe.NS.CHATSTATES
      }).up().c('no-store', {
        'xmlns': Strophe.NS.HINTS
      }).up().c('no-permanent-store', {
        'xmlns': Strophe.NS.HINTS
      }));
    }
  },
  async sendFiles(files) {
    var _maxFileSize;
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse;
    const result = await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.disco.features.get(Strophe.NS.HTTPUPLOAD, _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.domain);
    const item = result.pop();
    if (!item) {
      this.createMessage({
        'message': __("Sorry, looks like file upload is not supported by your server."),
        'type': 'error',
        'is_ephemeral': true
      });
      return;
    }
    const data = item.dataforms.where({
      'FORM_TYPE': {
        'value': Strophe.NS.HTTPUPLOAD,
        'type': "hidden"
      }
    }).pop();
    const max_file_size = window.parseInt((_maxFileSize = ((data === null || data === void 0 ? void 0 : data.attributes) || {})['max-file-size']) === null || _maxFileSize === void 0 ? void 0 : _maxFileSize.value);
    const slot_request_url = item === null || item === void 0 ? void 0 : item.id;
    if (!slot_request_url) {
      this.createMessage({
        'message': __("Sorry, looks like file upload is not supported by your server."),
        'type': 'error',
        'is_ephemeral': true
      });
      return;
    }
    Array.from(files).forEach(async file => {
      /**
       * *Hook* which allows plugins to transform files before they'll be
       * uploaded. The main use-case is to encrypt the files.
       * @event _converse#beforeFileUpload
       * @param { _converse.ChatBox | _converse.ChatRoom } chat
       *      The chat from which this file will be uploaded.
       * @param { File } file
       *      The file that will be uploaded
       */
      file = await _core_js__WEBPACK_IMPORTED_MODULE_4__.api.hook('beforeFileUpload', this, file);
      if (!window.isNaN(max_file_size) && window.parseInt(file.size) > max_file_size) {
        return this.createMessage({
          'message': __('The size of your file, %1$s, exceeds the maximum allowed by your server, which is %2$s.', file.name, filesize__WEBPACK_IMPORTED_MODULE_1___default()(max_file_size)),
          'type': 'error',
          'is_ephemeral': true
        });
      } else {
        const initial_attrs = await this.getOutgoingMessageAttributes();
        const attrs = Object.assign(initial_attrs, {
          'file': true,
          'progress': 0,
          'slot_request_url': slot_request_url
        });
        this.setEditable(attrs, new Date().toISOString());
        const message = await this.createMessage(attrs, {
          'silent': true
        });
        message.file = file;
        this.messages.trigger('add', message);
        message.getRequestSlotURL();
      }
    });
  },
  maybeShow(force) {
    if ((0,_utils_core_js__WEBPACK_IMPORTED_MODULE_9__.isUniView)()) {
      const filter = c => !c.get('hidden') && c.get('jid') !== this.get('jid') && c.get('id') !== 'controlbox';
      const other_chats = _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.chatboxes.filter(filter);
      if (force || other_chats.length === 0) {
        // We only have one chat visible at any one time.
        // So before opening a chat, we make sure all other chats are hidden.
        other_chats.forEach(c => u.safeSave(c, {
          'hidden': true
        }));
        u.safeSave(this, {
          'hidden': false
        });
      }
      return;
    }
    u.safeSave(this, {
      'hidden': false
    });
    this.trigger('show');
    return this;
  },
  /**
   * Indicates whether the chat is hidden and therefore
   * whether a newly received message will be visible
   * to the user or not.
   * @returns {boolean}
   */
  isHidden() {
    // Note: This methods gets overridden by converse-minimize
    return this.get('hidden') || this.isScrolledUp() || _core_js__WEBPACK_IMPORTED_MODULE_4__._converse.windowState === 'hidden';
  },
  /**
   * Given a newly received {@link _converse.Message} instance,
   * update the unread counter if necessary.
   * @private
   * @method _converse.ChatBox#handleUnreadMessage
   * @param {_converse.Message} message
   */
  handleUnreadMessage(message) {
    if (!(message !== null && message !== void 0 && message.get('body'))) {
      return;
    }
    if (u.isNewMessage(message)) {
      if (message.get('sender') === 'me') {
        // We remove the "scrolled" flag so that the chat area
        // gets scrolled down. We always want to scroll down
        // when the user writes a message as opposed to when a
        // message is received.
        this.ui.set('scrolled', false);
      } else if (this.isHidden()) {
        this.incrementUnreadMsgsCounter(message);
      } else {
        this.sendMarkerForMessage(message);
      }
    }
  },
  incrementUnreadMsgsCounter(message) {
    const settings = {
      'num_unread': this.get('num_unread') + 1
    };
    if (this.get('num_unread') === 0) {
      settings['first_unread_id'] = message.get('id');
    }
    this.save(settings);
  },
  clearUnreadMsgCounter() {
    if (this.get('num_unread') > 0) {
      this.sendMarkerForMessage(this.messages.last());
    }
    u.safeSave(this, {
      'num_unread': 0
    });
  },
  isScrolledUp() {
    return this.ui.get('scrolled');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatBox);

/***/ }),

/***/ "./src/headless/plugins/chat/parsers.js":
/*!**********************************************!*\
  !*** ./src/headless/plugins/chat/parsers.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "parseMessage": () => (/* binding */ parseMessage)
/* harmony export */ });
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dayjs */ "./node_modules/dayjs/dayjs.min.js");
/* harmony import */ var dayjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dayjs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_utils_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/utils/core */ "./src/headless/utils/core.js");
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_shared_actions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/headless/shared/actions */ "./src/headless/shared/actions.js");
/* harmony import */ var _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/shared/parsers */ "./src/headless/shared/parsers.js");






const {
  Strophe,
  sizzle
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env;

/**
 * Parses a passed in message stanza and returns an object of attributes.
 * @method st#parseMessage
 * @param { XMLElement } stanza - The message stanza
 * @param { _converse } _converse
 * @returns { (MessageAttributes|Error) }
 */
async function parseMessage(stanza) {
  var _stanza$querySelector, _stanza$querySelector2, _contact, _contact$attributes, _stanza$querySelector3, _stanza$querySelector4;
  (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.throwErrorIfInvalidForward)(stanza);
  let to_jid = stanza.getAttribute('to');
  const to_resource = Strophe.getResourceFromJid(to_jid);
  if (_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('filter_by_resource') && to_resource && to_resource !== _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.resource) {
    return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Ignoring incoming message intended for a different resource: ${to_jid}`, stanza);
  }
  const original_stanza = stanza;
  let from_jid = stanza.getAttribute('from') || _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid;
  if ((0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isCarbon)(stanza)) {
    if (from_jid === _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid) {
      const selector = `[xmlns="${Strophe.NS.CARBONS}"] > forwarded[xmlns="${Strophe.NS.FORWARD}"] > message`;
      stanza = sizzle(selector, stanza).pop();
      to_jid = stanza.getAttribute('to');
      from_jid = stanza.getAttribute('from');
    } else {
      // Prevent message forging via carbons: https://xmpp.org/extensions/xep-0280.html#security
      (0,_converse_headless_shared_actions__WEBPACK_IMPORTED_MODULE_4__.rejectMessage)(stanza, 'Rejecting carbon from invalid JID');
      return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Rejecting carbon from invalid JID ${to_jid}`, stanza);
    }
  }
  const is_archived = (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isArchived)(stanza);
  if (is_archived) {
    if (from_jid === _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid) {
      const selector = `[xmlns="${Strophe.NS.MAM}"] > forwarded[xmlns="${Strophe.NS.FORWARD}"] > message`;
      stanza = sizzle(selector, stanza).pop();
      to_jid = stanza.getAttribute('to');
      from_jid = stanza.getAttribute('from');
    } else {
      return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Invalid Stanza: alleged MAM message from ${stanza.getAttribute('from')}`, stanza);
    }
  }
  const from_bare_jid = Strophe.getBareJidFromJid(from_jid);
  const is_me = from_bare_jid === _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid;
  if (is_me && to_jid === null) {
    return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Don't know how to handle message stanza without 'to' attribute. ${stanza.outerHTML}`, stanza);
  }
  const is_headline = (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isHeadline)(stanza);
  const is_server_message = (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isServerMessage)(stanza);
  let contact, contact_jid;
  if (!is_headline && !is_server_message) {
    contact_jid = is_me ? Strophe.getBareJidFromJid(to_jid) : from_bare_jid;
    contact = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.contacts.get(contact_jid);
    if (contact === undefined && !_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('allow_non_roster_messaging')) {
      _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(stanza);
      return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Blocking messaging with a JID not in our roster because allow_non_roster_messaging is false.`, stanza);
    }
  }
  /**
   * @typedef { Object } MessageAttributes
   * The object which {@link parseMessage} returns
   * @property { ('me'|'them') } sender - Whether the message was sent by the current user or someone else
   * @property { Array<Object> } references - A list of objects representing XEP-0372 references
   * @property { Boolean } editable - Is this message editable via XEP-0308?
   * @property { Boolean } is_archived -  Is this message from a XEP-0313 MAM archive?
   * @property { Boolean } is_carbon - Is this message a XEP-0280 Carbon?
   * @property { Boolean } is_delayed - Was delivery of this message was delayed as per XEP-0203?
   * @property { Boolean } is_encrypted -  Is this message XEP-0384  encrypted?
   * @property { Boolean } is_error - Whether an error was received for this message
   * @property { Boolean } is_headline - Is this a "headline" message?
   * @property { Boolean } is_markable - Can this message be marked with a XEP-0333 chat marker?
   * @property { Boolean } is_marker - Is this message a XEP-0333 Chat Marker?
   * @property { Boolean } is_only_emojis - Does the message body contain only emojis?
   * @property { Boolean } is_spoiler - Is this a XEP-0382 spoiler message?
   * @property { Boolean } is_tombstone - Is this a XEP-0424 tombstone?
   * @property { Boolean } is_unstyled - Whether XEP-0393 styling hints should be ignored
   * @property { Boolean } is_valid_receipt_request - Does this message request a XEP-0184 receipt (and is not from us or a carbon or archived message)
   * @property { Object } encrypted -  XEP-0384 encryption payload attributes
   * @property { String } body - The contents of the <body> tag of the message stanza
   * @property { String } chat_state - The XEP-0085 chat state notification contained in this message
   * @property { String } contact_jid - The JID of the other person or entity
   * @property { String } edited - An ISO8601 string recording the time that the message was edited per XEP-0308
   * @property { String } error_condition - The defined error condition
   * @property { String } error_text - The error text received from the server
   * @property { String } error_type - The type of error received from the server
   * @property { String } from - The sender JID
   * @property { String } fullname - The full name of the sender
   * @property { String } marker - The XEP-0333 Chat Marker value
   * @property { String } marker_id - The `id` attribute of a XEP-0333 chat marker
   * @property { String } msgid - The root `id` attribute of the stanza
   * @property { String } nick - The roster nickname of the sender
   * @property { String } oob_desc - The description of the XEP-0066 out of band data
   * @property { String } oob_url - The URL of the XEP-0066 out of band data
   * @property { String } origin_id - The XEP-0359 Origin ID
   * @property { String } receipt_id - The `id` attribute of a XEP-0184 <receipt> element
   * @property { String } received - An ISO8601 string recording the time that the message was received
   * @property { String } replace_id - The `id` attribute of a XEP-0308 <replace> element
   * @property { String } retracted - An ISO8601 string recording the time that the message was retracted
   * @property { String } retracted_id - The `id` attribute of a XEP-424 <retracted> element
   * @property { String } spoiler_hint  The XEP-0382 spoiler hint
   * @property { String } stanza_id - The XEP-0359 Stanza ID. Note: the key is actualy `stanza_id ${by_jid}` and there can be multiple.
   * @property { String } subject - The <subject> element value
   * @property { String } thread - The <thread> element value
   * @property { String } time - The time (in ISO8601 format), either given by the XEP-0203 <delay> element, or of receipt.
   * @property { String } to - The recipient JID
   * @property { String } type - The type of message
   */
  const delay = sizzle(`delay[xmlns="${Strophe.NS.DELAY}"]`, original_stanza).pop();
  const marker = (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getChatMarker)(stanza);
  const now = new Date().toISOString();
  let attrs = Object.assign({
    contact_jid,
    is_archived,
    is_headline,
    is_server_message,
    'body': (_stanza$querySelector = stanza.querySelector('body')) === null || _stanza$querySelector === void 0 ? void 0 : (_stanza$querySelector2 = _stanza$querySelector.textContent) === null || _stanza$querySelector2 === void 0 ? void 0 : _stanza$querySelector2.trim(),
    'chat_state': (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getChatState)(stanza),
    'from': Strophe.getBareJidFromJid(stanza.getAttribute('from')),
    'is_carbon': (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isCarbon)(original_stanza),
    'is_delayed': !!delay,
    'is_markable': !!sizzle(`markable[xmlns="${Strophe.NS.MARKERS}"]`, stanza).length,
    'is_marker': !!marker,
    'is_unstyled': !!sizzle(`unstyled[xmlns="${Strophe.NS.STYLING}"]`, stanza).length,
    'marker_id': marker && marker.getAttribute('id'),
    'msgid': stanza.getAttribute('id') || original_stanza.getAttribute('id'),
    'nick': (_contact = contact) === null || _contact === void 0 ? void 0 : (_contact$attributes = _contact.attributes) === null || _contact$attributes === void 0 ? void 0 : _contact$attributes.nickname,
    'receipt_id': (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getReceiptId)(stanza),
    'received': new Date().toISOString(),
    'references': (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getReferences)(stanza),
    'sender': is_me ? 'me' : 'them',
    'subject': (_stanza$querySelector3 = stanza.querySelector('subject')) === null || _stanza$querySelector3 === void 0 ? void 0 : _stanza$querySelector3.textContent,
    'thread': (_stanza$querySelector4 = stanza.querySelector('thread')) === null || _stanza$querySelector4 === void 0 ? void 0 : _stanza$querySelector4.textContent,
    'time': delay ? dayjs__WEBPACK_IMPORTED_MODULE_0___default()(delay.getAttribute('stamp')).toISOString() : now,
    'to': stanza.getAttribute('to'),
    'type': stanza.getAttribute('type')
  }, (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getErrorAttributes)(stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getOutOfBandAttributes)(stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getSpoilerAttributes)(stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getCorrectionAttributes)(stanza, original_stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getStanzaIDs)(stanza, original_stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getRetractionAttributes)(stanza, original_stanza), (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getEncryptionAttributes)(stanza, _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse));
  if (attrs.is_archived) {
    const from = original_stanza.getAttribute('from');
    if (from && from !== _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid) {
      return new _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.StanzaParseError(`Invalid Stanza: Forged MAM message from ${from}`, stanza);
    }
  }
  await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.emojis.initialize();
  attrs = Object.assign({
    'message': attrs.body || attrs.error,
    // TODO: Remove and use body and error attributes instead
    'is_only_emojis': attrs.body ? _converse_headless_utils_core__WEBPACK_IMPORTED_MODULE_2__["default"].isOnlyEmojis(attrs.body) : false,
    'is_valid_receipt_request': (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.isValidReceiptRequest)(stanza, attrs)
  }, attrs);

  // We prefer to use one of the XEP-0359 unique and stable stanza IDs
  // as the Model id, to avoid duplicates.
  attrs['id'] = attrs['origin_id'] || attrs[`stanza_id ${attrs.from}`] || _converse_headless_utils_core__WEBPACK_IMPORTED_MODULE_2__["default"].getUniqueId();

  /**
   * *Hook* which allows plugins to add additional parsing
   * @event _converse#parseMessage
   */
  attrs = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.hook('parseMessage', stanza, attrs);

  // We call this after the hook, to allow plugins (like omemo) to decrypt encrypted
  // messages, since we need to parse the message text to determine whether
  // there are media urls.
  return Object.assign(attrs, (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_5__.getMediaURLsMetadata)(attrs.is_encrypted ? attrs.plaintext : attrs.body));
}

/***/ }),

/***/ "./src/headless/plugins/chat/utils.js":
/*!********************************************!*\
  !*** ./src/headless/plugins/chat/utils.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "autoJoinChats": () => (/* binding */ autoJoinChats),
/* harmony export */   "enableCarbons": () => (/* binding */ enableCarbons),
/* harmony export */   "handleMessageStanza": () => (/* binding */ handleMessageStanza),
/* harmony export */   "onClearSession": () => (/* binding */ onClearSession),
/* harmony export */   "openChat": () => (/* binding */ openChat),
/* harmony export */   "registerMessageHandlers": () => (/* binding */ registerMessageHandlers)
/* harmony export */ });
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/shared/parsers */ "./src/headless/shared/parsers.js");
/* harmony import */ var _parsers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parsers.js */ "./src/headless/plugins/chat/parsers.js");
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");




const {
  Strophe,
  sizzle,
  u
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.converse.env;
function openChat(jid) {
  if (!u.isValidJID(jid)) {
    return _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].warn(`Invalid JID "${jid}" provided in URL fragment`);
  }
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.open(jid);
}
async function onClearSession() {
  if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.shouldClearCache()) {
    await Promise.all(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.map(c => c.messages && c.messages.clearStore({
      'silent': true
    })));
    const filter = o => o.get('type') !== _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.CONTROLBOX_TYPE;
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.clearStore({
      'silent': true
    }, filter);
  }
}
async function handleErrorMessage(stanza) {
  const from_jid = Strophe.getBareJidFromJid(stanza.getAttribute('from'));
  if (u.isSameBareJID(from_jid, _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.bare_jid)) {
    return;
  }
  const chatbox = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.get(from_jid);
  if ((chatbox === null || chatbox === void 0 ? void 0 : chatbox.get('type')) === _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.PRIVATE_CHAT_TYPE) {
    chatbox === null || chatbox === void 0 ? void 0 : chatbox.handleErrorMessageStanza(stanza);
  }
}
function autoJoinChats() {
  // Automatically join private chats, based on the
  // "auto_join_private_chats" configuration setting.
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.settings.get('auto_join_private_chats').forEach(jid => {
    if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.where({
      'jid': jid
    }).length) {
      return;
    }
    if (typeof jid === 'string') {
      _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.open(jid);
    } else {
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].error('Invalid jid criteria specified for "auto_join_private_chats"');
    }
  });
  /**
   * Triggered once any private chats have been automatically joined as
   * specified by the `auto_join_private_chats` setting.
   * See: https://conversejs.org/docs/html/configuration.html#auto-join-private-chats
   * @event _converse#privateChatsAutoJoined
   * @example _converse.api.listen.on('privateChatsAutoJoined', () => { ... });
   * @example _converse.api.waitUntil('privateChatsAutoJoined').then(() => { ... });
   */
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.trigger('privateChatsAutoJoined');
}
function registerMessageHandlers() {
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.addHandler(stanza => {
    if (sizzle(`message > result[xmlns="${Strophe.NS.MAM}"]`, stanza).pop()) {
      // MAM messages are handled in converse-mam.
      // We shouldn't get MAM messages here because
      // they shouldn't have a `type` attribute.
      _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].warn(`Received a MAM message with type "chat".`);
      return true;
    }
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.handleMessageStanza(stanza);
    return true;
  }, null, 'message', 'chat');
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.addHandler(stanza => {
    // Message receipts are usually without the `type` attribute. See #1353
    if (stanza.getAttribute('type') !== null) {
      // TODO: currently Strophe has no way to register a handler
      // for stanzas without a `type` attribute.
      // We could update it to accept null to mean no attribute,
      // but that would be a backward-incompatible change
      return true; // Gets handled above.
    }

    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.handleMessageStanza(stanza);
    return true;
  }, Strophe.NS.RECEIPTS, 'message');
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.addHandler(stanza => {
    handleErrorMessage(stanza);
    return true;
  }, null, 'message', 'error');
}

/**
 * Handler method for all incoming single-user chat "message" stanzas.
 * @param { MessageAttributes } attrs - The message attributes
 */
async function handleMessageStanza(stanza) {
  if ((0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_1__.isServerMessage)(stanza)) {
    // Prosody sends headline messages with type `chat`, so we need to filter them out here.
    const from = stanza.getAttribute('from');
    return _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].info(`handleMessageStanza: Ignoring incoming server message from JID: ${from}`);
  }
  let attrs;
  try {
    attrs = await (0,_parsers_js__WEBPACK_IMPORTED_MODULE_2__.parseMessage)(stanza, _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse);
  } catch (e) {
    return _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].error(e);
  }
  if (u.isErrorObject(attrs)) {
    attrs.stanza && _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].error(attrs.stanza);
    return _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].error(attrs.message);
  }
  // XXX: Need to take XEP-428 <fallback> into consideration
  const has_body = !!(attrs.body || attrs.plaintext);
  const chatbox = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.chats.get(attrs.contact_jid, {
    'nickname': attrs.nick
  }, has_body);
  await (chatbox === null || chatbox === void 0 ? void 0 : chatbox.queueMessage(attrs));
  /**
   * @typedef { Object } MessageData
   * An object containing the original message stanza, as well as the
   * parsed attributes.
   * @property { XMLElement } stanza
   * @property { MessageAttributes } stanza
   * @property { ChatBox } chatbox
   */
  const data = {
    stanza,
    attrs,
    chatbox
  };
  /**
   * Triggered when a message stanza is been received and processed.
   * @event _converse#message
   * @type { object }
   * @property { module:converse-chat~MessageData } data
   */
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.trigger('message', data);
}

/**
 * Ask the XMPP server to enable Message Carbons
 * See [XEP-0280](https://xmpp.org/extensions/xep-0280.html#enabling)
 * @param { Boolean } reconnecting
 */
async function enableCarbons() {
  const domain = Strophe.getDomainFromJid(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.bare_jid);
  const supported = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.supports(Strophe.NS.CARBONS, domain);
  if (!supported) {
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].warn("Not enabling carbons because it's not supported!");
    return;
  }
  const iq = new Strophe.Builder('iq', {
    'from': _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.jid,
    'type': 'set'
  }).c('enable', {
    xmlns: Strophe.NS.CARBONS
  });
  const result = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.sendIQ(iq, null, false);
  if (result === null) {
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].warn(`A timeout occurred while trying to enable carbons`);
  } else if (u.isErrorStanza(result)) {
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].warn('An error occurred while trying to enable message carbons.');
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].error(result);
  } else {
    _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_3__["default"].debug('Message carbons have been enabled.');
  }
}

/***/ }),

/***/ "./src/headless/plugins/chatboxes/api.js":
/*!***********************************************!*\
  !*** ./src/headless/plugins/chatboxes/api.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/chatboxes/utils.js");



/**
 * The "chatboxes" namespace.
 *
 * @namespace api.chatboxes
 * @memberOf api
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * @method api.chats.create
   * @param { String|String[] } jids - A JID or array of JIDs
   * @param { Object } [attrs] An object containing configuration attributes
   * @param { Model } model - The type of chatbox that should be created
   */
  async create() {
    let jids = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    let model = arguments.length > 2 ? arguments[2] : undefined;
    await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.waitUntil('chatBoxesFetched');
    if (typeof jids === 'string') {
      return (0,_utils_js__WEBPACK_IMPORTED_MODULE_1__.createChatBox)(jids, attrs, model);
    } else {
      return Promise.all(jids.map(jid => (0,_utils_js__WEBPACK_IMPORTED_MODULE_1__.createChatBox)(jid, attrs, model)));
    }
  },
  /**
   * @method api.chats.get
   * @param { String|String[] } jids - A JID or array of JIDs
   */
  async get(jids) {
    await _core_js__WEBPACK_IMPORTED_MODULE_0__.api.waitUntil('chatBoxesFetched');
    if (jids === undefined) {
      return _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.models;
    } else if (typeof jids === 'string') {
      return _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.get(jids.toLowerCase());
    } else {
      jids = jids.map(j => j.toLowerCase());
      return _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.models.filter(m => jids.includes(m.get('jid')));
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/chatboxes/chatboxes.js":
/*!*****************************************************!*\
  !*** ./src/headless/plugins/chatboxes/chatboxes.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/utils/storage.js */ "./src/headless/utils/storage.js");



const ChatBoxes = _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_0__.Collection.extend({
  comparator: 'time_opened',
  model(attrs, options) {
    return new _core_js__WEBPACK_IMPORTED_MODULE_1__._converse.ChatBox(attrs, options);
  },
  onChatBoxesFetched(collection) {
    collection.filter(c => !c.isValid()).forEach(c => c.destroy());
    /**
     * Triggered once all chat boxes have been recreated from the browser cache
     * @event _converse#chatBoxesFetched
     * @type { object }
     * @property { _converse.ChatBox | _converse.ChatRoom } chatbox
     * @property { XMLElement } stanza
     * @example _converse.api.listen.on('chatBoxesFetched', obj => { ... });
     * @example _converse.api.waitUntil('chatBoxesFetched').then(() => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_1__.api.trigger('chatBoxesFetched');
  },
  onConnected(reconnecting) {
    if (reconnecting) {
      return;
    }
    (0,_converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_2__.initStorage)(this, `converse.chatboxes-${_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.bare_jid}`);
    this.fetch({
      'add': true,
      'success': c => this.onChatBoxesFetched(c)
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatBoxes);

/***/ }),

/***/ "./src/headless/plugins/chatboxes/index.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/chatboxes/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _emoji_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../emoji/index.js */ "./src/headless/plugins/emoji/index.js");
/* harmony import */ var _chatboxes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chatboxes.js */ "./src/headless/plugins/chatboxes/chatboxes.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/chatboxes/api.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/**
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */




const {
  Strophe
} = _core_js__WEBPACK_IMPORTED_MODULE_3__.converse.env;
_core_js__WEBPACK_IMPORTED_MODULE_3__.converse.plugins.add('converse-chatboxes', {
  dependencies: ["converse-emoji", "converse-roster", "converse-vcard"],
  initialize() {
    _core_js__WEBPACK_IMPORTED_MODULE_3__.api.promises.add(['chatBoxesFetched', 'chatBoxesInitialized', 'privateChatsAutoJoined']);
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_3__.api, {
      'chatboxes': _api_js__WEBPACK_IMPORTED_MODULE_2__["default"]
    });
    _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.ChatBoxes = _chatboxes_js__WEBPACK_IMPORTED_MODULE_1__["default"];
    _core_js__WEBPACK_IMPORTED_MODULE_3__.api.listen.on('addClientFeatures', () => {
      _core_js__WEBPACK_IMPORTED_MODULE_3__.api.disco.own.features.add(Strophe.NS.MESSAGE_CORRECT);
      _core_js__WEBPACK_IMPORTED_MODULE_3__.api.disco.own.features.add(Strophe.NS.HTTPUPLOAD);
      _core_js__WEBPACK_IMPORTED_MODULE_3__.api.disco.own.features.add(Strophe.NS.OUTOFBAND);
    });
    _core_js__WEBPACK_IMPORTED_MODULE_3__.api.listen.on('pluginsInitialized', () => {
      _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes = new _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.ChatBoxes();
      /**
       * Triggered once the _converse.ChatBoxes collection has been initialized.
       * @event _converse#chatBoxesInitialized
       * @example _converse.api.listen.on('chatBoxesInitialized', () => { ... });
       * @example _converse.api.waitUntil('chatBoxesInitialized').then(() => { ... });
       */
      _core_js__WEBPACK_IMPORTED_MODULE_3__.api.trigger('chatBoxesInitialized');
    });
    _core_js__WEBPACK_IMPORTED_MODULE_3__.api.listen.on('presencesInitialized', reconnecting => _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes.onConnected(reconnecting));
    _core_js__WEBPACK_IMPORTED_MODULE_3__.api.listen.on('reconnected', () => _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.chatboxes.forEach(m => m.onReconnection()));
  }
});

/***/ }),

/***/ "./src/headless/plugins/chatboxes/utils.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/chatboxes/utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createChatBox": () => (/* binding */ createChatBox)
/* harmony export */ });
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../log */ "./src/headless/log.js");


const {
  Strophe
} = _core_js__WEBPACK_IMPORTED_MODULE_0__.converse.env;
async function createChatBox(jid, attrs, Model) {
  jid = Strophe.getBareJidFromJid(jid.toLowerCase());
  Object.assign(attrs, {
    'jid': jid,
    'id': jid
  });
  let chatbox;
  try {
    chatbox = new Model(attrs, {
      'collection': _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes
    });
  } catch (e) {
    _log__WEBPACK_IMPORTED_MODULE_1__["default"].error(e);
    return null;
  }
  await chatbox.initialized;
  if (!chatbox.isValid()) {
    chatbox.destroy();
    return null;
  }
  _core_js__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.add(chatbox);
  return chatbox;
}

/***/ }),

/***/ "./src/headless/plugins/disco/api.js":
/*!*******************************************!*\
  !*** ./src/headless/plugins/disco/api.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es_isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es/isObject */ "./node_modules/lodash-es/isObject.js");
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");




const {
  Strophe,
  $iq
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.env;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The XEP-0030 service discovery API
   *
   * This API lets you discover information about entities on the
   * XMPP network.
   *
   * @namespace api.disco
   * @memberOf api
   */
  disco: {
    /**
     * @namespace api.disco.stream
     * @memberOf api.disco
     */
    stream: {
      /**
       * @method api.disco.stream.getFeature
       * @param {String} name The feature name
       * @param {String} xmlns The XML namespace
       * @example _converse.api.disco.stream.getFeature('ver', 'urn:xmpp:features:rosterver')
       */
      async getFeature(name, xmlns) {
        await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('streamFeaturesAdded');
        if (!name || !xmlns) {
          throw new Error("name and xmlns need to be provided when calling disco.stream.getFeature");
        }
        if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.stream_features === undefined && !_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.connection.connected()) {
          // Happens during tests when disco lookups happen asynchronously after teardown.
          const msg = `Tried to get feature ${name} ${xmlns} but _converse.stream_features has been torn down`;
          _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].warn(msg);
          return;
        }
        return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.stream_features.findWhere({
          'name': name,
          'xmlns': xmlns
        });
      }
    },
    /**
     * @namespace api.disco.own
     * @memberOf api.disco
     */
    own: {
      /**
       * @namespace api.disco.own.identities
       * @memberOf api.disco.own
       */
      identities: {
        /**
         * Lets you add new identities for this client (i.e. instance of Converse)
         * @method api.disco.own.identities.add
         *
         * @param {String} category - server, client, gateway, directory, etc.
         * @param {String} type - phone, pc, web, etc.
         * @param {String} name - "Converse"
         * @param {String} lang - en, el, de, etc.
         *
         * @example _converse.api.disco.own.identities.clear();
         */
        add(category, type, name, lang) {
          for (var i = 0; i < _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities.length; i++) {
            if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities[i].category == category && _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities[i].type == type && _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities[i].name == name && _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities[i].lang == lang) {
              return false;
            }
          }
          _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities.push({
            category: category,
            type: type,
            name: name,
            lang: lang
          });
        },
        /**
         * Clears all previously registered identities.
         * @method api.disco.own.identities.clear
         * @example _converse.api.disco.own.identities.clear();
         */
        clear() {
          _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities = [];
        },
        /**
         * Returns all of the identities registered for this client
         * (i.e. instance of Converse).
         * @method api.disco.identities.get
         * @example const identities = api.disco.own.identities.get();
         */
        get() {
          return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._identities;
        }
      },
      /**
       * @namespace api.disco.own.features
       * @memberOf api.disco.own
       */
      features: {
        /**
         * Lets you register new disco features for this client (i.e. instance of Converse)
         * @method api.disco.own.features.add
         * @param {String} name - e.g. http://jabber.org/protocol/caps
         * @example _converse.api.disco.own.features.add("http://jabber.org/protocol/caps");
         */
        add(name) {
          for (var i = 0; i < _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._features.length; i++) {
            if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._features[i] == name) {
              return false;
            }
          }
          _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._features.push(name);
        },
        /**
         * Clears all previously registered features.
         * @method api.disco.own.features.clear
         * @example _converse.api.disco.own.features.clear();
         */
        clear() {
          _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._features = [];
        },
        /**
         * Returns all of the features registered for this client (i.e. instance of Converse).
         * @method api.disco.own.features.get
         * @example const features = api.disco.own.features.get();
         */
        get() {
          return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco._features;
        }
      }
    },
    /**
     * Query for information about an XMPP entity
     *
     * @method api.disco.info
     * @param {string} jid The Jabber ID of the entity to query
     * @param {string} [node] A specific node identifier associated with the JID
     * @returns {promise} Promise which resolves once we have a result from the server.
     */
    info(jid, node) {
      const attrs = {
        xmlns: Strophe.NS.DISCO_INFO
      };
      if (node) {
        attrs.node = node;
      }
      const info = $iq({
        'from': _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.connection.jid,
        'to': jid,
        'type': 'get'
      }).c('query', attrs);
      return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.sendIQ(info);
    },
    /**
     * Query for items associated with an XMPP entity
     *
     * @method api.disco.items
     * @param {string} jid The Jabber ID of the entity to query for items
     * @param {string} [node] A specific node identifier associated with the JID
     * @returns {promise} Promise which resolves once we have a result from the server.
     */
    items(jid, node) {
      const attrs = {
        'xmlns': Strophe.NS.DISCO_ITEMS
      };
      if (node) {
        attrs.node = node;
      }
      return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.sendIQ($iq({
        'from': _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.connection.jid,
        'to': jid,
        'type': 'get'
      }).c('query', attrs));
    },
    /**
     * Namespace for methods associated with disco entities
     *
     * @namespace api.disco.entities
     * @memberOf api.disco
     */
    entities: {
      /**
       * Get the corresponding `DiscoEntity` instance.
       *
       * @method api.disco.entities.get
       * @param {string} jid The Jabber ID of the entity
       * @param {boolean} [create] Whether the entity should be created if it doesn't exist.
       * @example _converse.api.disco.entities.get(jid);
       */
      async get(jid) {
        let create = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('discoInitialized');
        if (!jid) {
          return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco_entities;
        }
        if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco_entities === undefined) {
          // Happens during tests when disco lookups happen asynchronously after teardown.
          const msg = `Tried to look up entity ${jid} but _converse.disco_entities has been torn down`;
          _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].warn(msg);
          return;
        }
        const entity = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco_entities.get(jid);
        if (entity || !create) {
          return entity;
        }
        return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.create(jid);
      },
      /**
       * Create a new disco entity. It's identity and features
       * will automatically be fetched from cache or from the
       * XMPP server.
       *
       * Fetching from cache can be disabled by passing in
       * `ignore_cache: true` in the options parameter.
       *
       * @method api.disco.entities.create
       * @param {string} jid The Jabber ID of the entity
       * @param {object} [options] Additional options
       * @param {boolean} [options.ignore_cache]
       *     If true, fetch all features from the XMPP server instead of restoring them from cache
       * @example _converse.api.disco.entities.create(jid, {'ignore_cache': true});
       */
      create(jid, options) {
        return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco_entities.create({
          'jid': jid
        }, options);
      }
    },
    /**
     * @namespace api.disco.features
     * @memberOf api.disco
     */
    features: {
      /**
       * Return a given feature of a disco entity
       *
       * @method api.disco.features.get
       * @param {string} feature The feature that might be
       *     supported. In the XML stanza, this is the `var`
       *     attribute of the `<feature>` element. For
       *     example: `http://jabber.org/protocol/muc`
       * @param {string} jid The JID of the entity
       *     (and its associated items) which should be queried
       * @returns {promise} A promise which resolves with a list containing
       *     _converse.Entity instances representing the entity
       *     itself or those items associated with the entity if
       *     they support the given feature.
       * @example
       * api.disco.features.get(Strophe.NS.MAM, _converse.bare_jid);
       */
      async get(feature, jid) {
        if (!jid) {
          throw new TypeError('You need to provide an entity JID');
        }
        await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('discoInitialized');
        let entity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.get(jid, true);
        if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__._converse.disco_entities === undefined && !_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.connection.connected()) {
          // Happens during tests when disco lookups happen asynchronously after teardown.
          const msg = `Tried to get feature ${feature} for ${jid} but _converse.disco_entities has been torn down`;
          _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].warn(msg);
          return;
        }
        entity = await entity.waitUntilFeaturesDiscovered;
        const promises = [...entity.items.map(i => i.hasFeature(feature)), entity.hasFeature(feature)];
        const result = await Promise.all(promises);
        return result.filter(lodash_es_isObject__WEBPACK_IMPORTED_MODULE_3__["default"]);
      }
    },
    /**
     * Used to determine whether an entity supports a given feature.
     *
     * @method api.disco.supports
     * @param {string} feature The feature that might be
     *     supported. In the XML stanza, this is the `var`
     *     attribute of the `<feature>` element. For
     *     example: `http://jabber.org/protocol/muc`
     * @param {string} jid The JID of the entity
     *     (and its associated items) which should be queried
     * @returns {promise} A promise which resolves with `true` or `false`.
     * @example
     * if (await api.disco.supports(Strophe.NS.MAM, _converse.bare_jid)) {
     *     // The feature is supported
     * } else {
     *     // The feature is not supported
     * }
     */
    async supports(feature, jid) {
      const features = (await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.features.get(feature, jid)) || [];
      return features.length > 0;
    },
    /**
     * Refresh the features, fields and identities associated with a
     * disco entity by refetching them from the server
     * @method api.disco.refresh
     * @param {string} jid The JID of the entity whose features are refreshed.
     * @returns {promise} A promise which resolves once the features have been refreshed
     * @example
     * await api.disco.refresh('room@conference.example.org');
     */
    async refresh(jid) {
      if (!jid) {
        throw new TypeError('api.disco.refresh: You need to provide an entity JID');
      }
      await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('discoInitialized');
      let entity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.get(jid);
      if (entity) {
        entity.features.reset();
        entity.fields.reset();
        entity.identities.reset();
        if (!entity.waitUntilFeaturesDiscovered.isPending) {
          entity.waitUntilFeaturesDiscovered = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_2__.getOpenPromise)();
        }
        entity.queryInfo();
      } else {
        // Create it if it doesn't exist
        entity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.create(jid, {
          'ignore_cache': true
        });
      }
      return entity.waitUntilFeaturesDiscovered;
    },
    /**
     * @deprecated Use {@link api.disco.refresh} instead.
     * @method api.disco.refreshFeatures
     */
    refreshFeatures(jid) {
      return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.refresh(jid);
    },
    /**
     * Return all the features associated with a disco entity
     *
     * @method api.disco.getFeatures
     * @param {string} jid The JID of the entity whose features are returned.
     * @returns {promise} A promise which resolves with the returned features
     * @example
     * const features = await api.disco.getFeatures('room@conference.example.org');
     */
    async getFeatures(jid) {
      if (!jid) {
        throw new TypeError('api.disco.getFeatures: You need to provide an entity JID');
      }
      await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('discoInitialized');
      let entity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.get(jid, true);
      entity = await entity.waitUntilFeaturesDiscovered;
      return entity.features;
    },
    /**
     * Return all the service discovery extensions fields
     * associated with an entity.
     *
     * See [XEP-0129: Service Discovery Extensions](https://xmpp.org/extensions/xep-0128.html)
     *
     * @method api.disco.getFields
     * @param {string} jid The JID of the entity whose fields are returned.
     * @example
     * const fields = await api.disco.getFields('room@conference.example.org');
     */
    async getFields(jid) {
      if (!jid) {
        throw new TypeError('api.disco.getFields: You need to provide an entity JID');
      }
      await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.waitUntil('discoInitialized');
      let entity = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.get(jid, true);
      entity = await entity.waitUntilFeaturesDiscovered;
      return entity.fields;
    },
    /**
     * Get the identity (with the given category and type) for a given disco entity.
     *
     * For example, when determining support for PEP (personal eventing protocol), you
     * want to know whether the user's own JID has an identity with
     * `category='pubsub'` and `type='pep'` as explained in this section of
     * XEP-0163: https://xmpp.org/extensions/xep-0163.html#support
     *
     * @method api.disco.getIdentity
     * @param {string} The identity category.
     *     In the XML stanza, this is the `category`
     *     attribute of the `<identity>` element.
     *     For example: 'pubsub'
     * @param {string} type The identity type.
     *     In the XML stanza, this is the `type`
     *     attribute of the `<identity>` element.
     *     For example: 'pep'
     * @param {string} jid The JID of the entity which might have the identity
     * @returns {promise} A promise which resolves with a map indicating
     *     whether an identity with a given type is provided by the entity.
     * @example
     * api.disco.getIdentity('pubsub', 'pep', _converse.bare_jid).then(
     *     function (identity) {
     *         if (identity) {
     *             // The entity DOES have this identity
     *         } else {
     *             // The entity DOES NOT have this identity
     *         }
     *     }
     * ).catch(e => log.error(e));
     */
    async getIdentity(category, type, jid) {
      const e = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.disco.entities.get(jid, true);
      if (e === undefined && !_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_1__.api.connection.connected()) {
        // Happens during tests when disco lookups happen asynchronously after teardown.
        const msg = `Tried to look up category ${category} for ${jid} but _converse.disco_entities has been torn down`;
        _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].warn(msg);
        return;
      }
      return e.getIdentity(category, type);
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/disco/entities.js":
/*!************************************************!*\
  !*** ./src/headless/plugins/disco/entities.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _entity_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./entity.js */ "./src/headless/plugins/disco/entity.js");
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");



const DiscoEntities = _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__.Collection.extend({
  model: _entity_js__WEBPACK_IMPORTED_MODULE_0__["default"],
  fetchEntities() {
    return new Promise((resolve, reject) => {
      this.fetch({
        add: true,
        success: resolve,
        error(_m, e) {
          _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_1__["default"].error(e);
          reject(new Error("Could not fetch disco entities"));
        }
      });
    });
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoEntities);

/***/ }),

/***/ "./src/headless/plugins/disco/entity.js":
/*!**********************************************!*\
  !*** ./src/headless/plugins/disco/entity.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/log.js */ "./src/headless/log.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");






const {
  Strophe
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.converse.env;

/**
 * @class
 * @namespace _converse.DiscoEntity
 * @memberOf _converse
 *
 * A Disco Entity is a JID addressable entity that can be queried for features.
 *
 * See XEP-0030: https://xmpp.org/extensions/xep-0030.html
 */
const DiscoEntity = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_3__.Model.extend({
  idAttribute: 'jid',
  async initialize(_, options) {
    this.waitUntilFeaturesDiscovered = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_5__.getOpenPromise)();
    this.dataforms = new _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__.Collection();
    let id = `converse.dataforms-${this.get('jid')}`;
    this.dataforms.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, 'session');
    this.features = new _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__.Collection();
    id = `converse.features-${this.get('jid')}`;
    this.features.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, 'session');
    this.listenTo(this.features, 'add', this.onFeatureAdded);
    this.fields = new _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__.Collection();
    id = `converse.fields-${this.get('jid')}`;
    this.fields.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, 'session');
    this.listenTo(this.fields, 'add', this.onFieldAdded);
    this.items = new _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.DiscoEntities();
    id = `converse.disco-items-${this.get('jid')}`;
    this.items.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, 'session');
    await new Promise(f => this.items.fetch({
      'success': f,
      'error': f
    }));
    this.identities = new _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_2__.Collection();
    id = `converse.identities-${this.get('jid')}`;
    this.identities.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.createStore(id, 'session');
    this.fetchFeatures(options);
  },
  /**
   * Returns a Promise which resolves with a map indicating
   * whether a given identity is provided by this entity.
   * @private
   * @method _converse.DiscoEntity#getIdentity
   * @param { String } category - The identity category
   * @param { String } type - The identity type
   */
  async getIdentity(category, type) {
    await this.waitUntilFeaturesDiscovered;
    return this.identities.findWhere({
      'category': category,
      'type': type
    });
  },
  /**
   * Returns a Promise which resolves with a map indicating
   * whether a given feature is supported.
   * @private
   * @method _converse.DiscoEntity#hasFeature
   * @param { String } feature - The feature that might be supported.
   */
  async hasFeature(feature) {
    await this.waitUntilFeaturesDiscovered;
    if (this.features.findWhere({
      'var': feature
    })) {
      return this;
    }
  },
  onFeatureAdded(feature) {
    feature.entity = this;
    /**
     * Triggered when Converse has learned of a service provided by the XMPP server.
     * See XEP-0030.
     * @event _converse#serviceDiscovered
     * @type { Model }
     * @example _converse.api.listen.on('featuresDiscovered', feature => { ... });
     */
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('serviceDiscovered', feature);
  },
  onFieldAdded(field) {
    field.entity = this;
    /**
     * Triggered when Converse has learned of a disco extension field.
     * See XEP-0030.
     * @event _converse#discoExtensionFieldDiscovered
     * @example _converse.api.listen.on('discoExtensionFieldDiscovered', () => { ... });
     */
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.trigger('discoExtensionFieldDiscovered', field);
  },
  async fetchFeatures(options) {
    if (options.ignore_cache) {
      this.queryInfo();
    } else {
      const store_id = this.features.browserStorage.name;
      const result = await this.features.browserStorage.store.getItem(store_id);
      if (result && result.length === 0 || result === null) {
        this.queryInfo();
      } else {
        this.features.fetch({
          add: true,
          success: () => {
            this.waitUntilFeaturesDiscovered.resolve(this);
            this.trigger('featuresDiscovered');
          }
        });
        this.identities.fetch({
          add: true
        });
      }
    }
  },
  async queryInfo() {
    let stanza;
    try {
      stanza = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.disco.info(this.get('jid'), null);
    } catch (iq) {
      iq === null ? _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Timeout for disco#info query for ${this.get('jid')}`) : _converse_headless_log_js__WEBPACK_IMPORTED_MODULE_0__["default"].error(iq);
      this.waitUntilFeaturesDiscovered.resolve(this);
      return;
    }
    this.onInfo(stanza);
  },
  onDiscoItems(stanza) {
    sizzle__WEBPACK_IMPORTED_MODULE_1___default()(`query[xmlns="${Strophe.NS.DISCO_ITEMS}"] item`, stanza).forEach(item => {
      if (item.getAttribute("node")) {
        // XXX: Ignore nodes for now.
        // See: https://xmpp.org/extensions/xep-0030.html#items-nodes
        return;
      }
      const jid = item.getAttribute('jid');
      if (this.items.get(jid) === undefined) {
        const entities = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__._converse.disco_entities;
        const entity = entities.get(jid) || entities.create({
          jid,
          name: item.getAttribute('name')
        });
        this.items.create(entity);
      }
    });
  },
  async queryForItems() {
    if (this.identities.where({
      'category': 'server'
    }).length === 0) {
      // Don't fetch features and items if this is not a
      // server or a conference component.
      return;
    }
    const stanza = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_4__.api.disco.items(this.get('jid'));
    this.onDiscoItems(stanza);
  },
  onInfo(stanza) {
    Array.from(stanza.querySelectorAll('identity')).forEach(identity => {
      this.identities.create({
        'category': identity.getAttribute('category'),
        'type': identity.getAttribute('type'),
        'name': identity.getAttribute('name')
      });
    });
    sizzle__WEBPACK_IMPORTED_MODULE_1___default()(`x[type="result"][xmlns="${Strophe.NS.XFORM}"]`, stanza).forEach(form => {
      const data = {};
      sizzle__WEBPACK_IMPORTED_MODULE_1___default()('field', form).forEach(field => {
        var _field$querySelector;
        data[field.getAttribute('var')] = {
          'value': (_field$querySelector = field.querySelector('value')) === null || _field$querySelector === void 0 ? void 0 : _field$querySelector.textContent,
          'type': field.getAttribute('type')
        };
      });
      this.dataforms.create(data);
    });
    if (stanza.querySelector(`feature[var="${Strophe.NS.DISCO_ITEMS}"]`)) {
      this.queryForItems();
    }
    Array.from(stanza.querySelectorAll('feature')).forEach(feature => {
      this.features.create({
        'var': feature.getAttribute('var'),
        'from': stanza.getAttribute('from')
      });
    });

    // XEP-0128 Service Discovery Extensions
    sizzle__WEBPACK_IMPORTED_MODULE_1___default()('x[type="result"][xmlns="jabber:x:data"] field', stanza).forEach(field => {
      var _field$querySelector2;
      this.fields.create({
        'var': field.getAttribute('var'),
        'value': (_field$querySelector2 = field.querySelector('value')) === null || _field$querySelector2 === void 0 ? void 0 : _field$querySelector2.textContent,
        'from': stanza.getAttribute('from')
      });
    });
    this.waitUntilFeaturesDiscovered.resolve(this);
    this.trigger('featuresDiscovered');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscoEntity);

/***/ }),

/***/ "./src/headless/plugins/disco/index.js":
/*!*********************************************!*\
  !*** ./src/headless/plugins/disco/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _entities_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./entities.js */ "./src/headless/plugins/disco/entities.js");
/* harmony import */ var _entity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./entity.js */ "./src/headless/plugins/disco/entity.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/disco/utils.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/disco/api.js");
/**
 * @copyright The Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 * @description Converse plugin which add support for XEP-0030: Service Discovery
 */





const {
  Strophe
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.converse.env;
_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.converse.plugins.add('converse-disco', {
  initialize() {
    Object.assign(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api, _api_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.promises.add('discoInitialized');
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.promises.add('streamFeaturesAdded');
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.DiscoEntity = _entity_js__WEBPACK_IMPORTED_MODULE_1__["default"];
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.DiscoEntities = _entities_js__WEBPACK_IMPORTED_MODULE_0__["default"];
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.disco = {
      _identities: [],
      _features: []
    };
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('userSessionInitialized', async () => {
      (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.initStreamFeatures)();
      if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.connfeedback.get('connection_status') === Strophe.Status.ATTACHED) {
        // When re-attaching to a BOSH session, we fetch the stream features from the cache.
        await new Promise((success, error) => _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.stream_features.fetch({
          success,
          error
        }));
        (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.notifyStreamFeaturesAdded)();
      }
    });
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('beforeResourceBinding', _utils_js__WEBPACK_IMPORTED_MODULE_3__.populateStreamFeatures);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('reconnected', _utils_js__WEBPACK_IMPORTED_MODULE_3__.initializeDisco);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('connected', _utils_js__WEBPACK_IMPORTED_MODULE_3__.initializeDisco);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('beforeTearDown', async () => {
      _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.promises.add('streamFeaturesAdded');
      if (_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.stream_features) {
        await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.stream_features.clearStore();
        delete _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.stream_features;
      }
    });

    // All disco entities stored in sessionStorage and are refetched
    // upon login or reconnection and then stored with new ids, so to
    // avoid sessionStorage filling up, we remove them.
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('will-reconnect', _utils_js__WEBPACK_IMPORTED_MODULE_3__.clearSession);
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('clearSession', _utils_js__WEBPACK_IMPORTED_MODULE_3__.clearSession);
  }
});

/***/ }),

/***/ "./src/headless/plugins/disco/utils.js":
/*!*********************************************!*\
  !*** ./src/headless/plugins/disco/utils.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearSession": () => (/* binding */ clearSession),
/* harmony export */   "initStreamFeatures": () => (/* binding */ initStreamFeatures),
/* harmony export */   "initializeDisco": () => (/* binding */ initializeDisco),
/* harmony export */   "notifyStreamFeaturesAdded": () => (/* binding */ notifyStreamFeaturesAdded),
/* harmony export */   "populateStreamFeatures": () => (/* binding */ populateStreamFeatures)
/* harmony export */ });
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");


const {
  Strophe,
  $iq
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.converse.env;
function onDiscoInfoRequest(stanza) {
  const node = stanza.getElementsByTagName('query')[0].getAttribute('node');
  const attrs = {
    xmlns: Strophe.NS.DISCO_INFO
  };
  if (node) {
    attrs.node = node;
  }
  const iqresult = $iq({
    'type': 'result',
    'id': stanza.getAttribute('id')
  });
  const from = stanza.getAttribute('from');
  if (from !== null) {
    iqresult.attrs({
      'to': from
    });
  }
  iqresult.c('query', attrs);
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco._identities.forEach(identity => {
    const attrs = {
      'category': identity.category,
      'type': identity.type
    };
    if (identity.name) {
      attrs.name = identity.name;
    }
    if (identity.lang) {
      attrs['xml:lang'] = identity.lang;
    }
    iqresult.c('identity', attrs).up();
  });
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco._features.forEach(f => iqresult.c('feature', {
    'var': f
  }).up());
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.send(iqresult.tree());
  return true;
}
function addClientFeatures() {
  // See https://xmpp.org/registrar/disco-categories.html
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.own.identities.add('client', 'web', 'Converse');
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.own.features.add(Strophe.NS.CHATSTATES);
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.own.features.add(Strophe.NS.DISCO_INFO);
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.own.features.add(Strophe.NS.ROSTERX); // Limited support
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.disco.own.features.add(Strophe.NS.CARBONS);
  /**
   * Triggered in converse-disco once the core disco features of
   * Converse have been added.
   * @event _converse#addClientFeatures
   * @example _converse.api.listen.on('addClientFeatures', () => { ... });
   */
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.trigger('addClientFeatures');
  return this;
}
async function initializeDisco() {
  addClientFeatures();
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.addHandler(stanza => onDiscoInfoRequest(stanza), Strophe.NS.DISCO_INFO, 'iq', 'get', null, null);
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities = new _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.DiscoEntities();
  const id = `converse.disco-entities-${_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.bare_jid}`;
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.createStore(id, 'session');
  const collection = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities.fetchEntities();
  if (collection.length === 0 || !collection.get(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.domain)) {
    // If we don't have an entity for our own XMPP server, create one.
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities.create({
      'jid': _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.domain
    });
  }
  /**
   * Triggered once the `converse-disco` plugin has been initialized and the
   * `_converse.disco_entities` collection will be available and populated with at
   * least the service discovery features of the user's own server.
   * @event _converse#discoInitialized
   * @example _converse.api.listen.on('discoInitialized', () => { ... });
   */
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.trigger('discoInitialized');
}
function initStreamFeatures() {
  // Initialize the stream_features collection, and if we're
  // re-attaching to a pre-existing BOSH session, we restore the
  // features from cache.
  // Otherwise the features will be created once we've received them
  // from the server (see populateStreamFeatures).
  if (!_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.stream_features) {
    const bare_jid = Strophe.getBareJidFromJid(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.jid);
    const id = `converse.stream-features-${bare_jid}`;
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.promises.add('streamFeaturesAdded');
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.stream_features = new _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_1__.Collection();
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.stream_features.browserStorage = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.createStore(id, "session");
  }
}
function notifyStreamFeaturesAdded() {
  /**
   * Triggered as soon as the stream features are known.
   * If you want to check whether a stream feature is supported before proceeding,
   * then you'll first want to wait for this event.
   * @event _converse#streamFeaturesAdded
   * @example _converse.api.listen.on('streamFeaturesAdded', () => { ... });
   */
  _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__.api.trigger('streamFeaturesAdded');
}
function populateStreamFeatures() {
  // Strophe.js sets the <stream:features> element on the
  // Strophe.Connection instance (_converse.connection).
  //
  // Once this is we populate the _converse.stream_features collection
  // and trigger streamFeaturesAdded.
  initStreamFeatures();
  Array.from(_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.connection.features.childNodes).forEach(feature => {
    _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.stream_features.create({
      'name': feature.nodeName,
      'xmlns': feature.getAttribute('xmlns')
    });
  });
  notifyStreamFeaturesAdded();
}
function clearSession() {
  var _converse$disco_entit, _converse$disco_entit2, _converse$disco_entit3, _converse$disco_entit4, _converse$disco_entit5;
  (_converse$disco_entit = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities) === null || _converse$disco_entit === void 0 ? void 0 : _converse$disco_entit.forEach(e => e.features.clearStore());
  (_converse$disco_entit2 = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities) === null || _converse$disco_entit2 === void 0 ? void 0 : _converse$disco_entit2.forEach(e => e.identities.clearStore());
  (_converse$disco_entit3 = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities) === null || _converse$disco_entit3 === void 0 ? void 0 : _converse$disco_entit3.forEach(e => e.dataforms.clearStore());
  (_converse$disco_entit4 = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities) === null || _converse$disco_entit4 === void 0 ? void 0 : _converse$disco_entit4.forEach(e => e.fields.clearStore());
  (_converse$disco_entit5 = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities) === null || _converse$disco_entit5 === void 0 ? void 0 : _converse$disco_entit5.clearStore();
  delete _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_0__._converse.disco_entities;
}

/***/ }),

/***/ "./src/headless/plugins/emoji/index.js":
/*!*********************************************!*\
  !*** ./src/headless/plugins/emoji/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");
/**
 * @module converse-emoji
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */



_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis = {
  'initialized': false,
  'initialized_promise': (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_2__.getOpenPromise)()
};
_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.plugins.add('converse-emoji', {
  initialize() {
    /* The initialize function gets called as soon as the plugin is
     * loaded by converse.js's plugin machinery.
     */
    const {
      ___
    } = _core_js__WEBPACK_IMPORTED_MODULE_1__._converse;
    _core_js__WEBPACK_IMPORTED_MODULE_1__.api.settings.extend({
      'emoji_image_path': 'https://twemoji.maxcdn.com/v/12.1.6/',
      'emoji_categories': {
        "smileys": ":grinning:",
        "people": ":thumbsup:",
        "activity": ":soccer:",
        "travel": ":motorcycle:",
        "objects": ":bomb:",
        "nature": ":rainbow:",
        "food": ":hotdog:",
        "symbols": ":musical_note:",
        "flags": ":flag_ac:",
        "custom": null
      },
      // We use the triple-underscore method which doesn't actually
      // translate but does signify to gettext that these strings should
      // go into the POT file. The translation then happens in the
      // template. We do this so that users can pass in their own
      // strings via converse.initialize, which is before __ is
      // available.
      'emoji_category_labels': {
        "smileys": ___("Smileys and emotions"),
        "people": ___("People"),
        "activity": ___("Activities"),
        "travel": ___("Travel"),
        "objects": ___("Objects"),
        "nature": ___("Animals and nature"),
        "food": ___("Food and drink"),
        "symbols": ___("Symbols"),
        "flags": ___("Flags"),
        "custom": ___("Stickers")
      }
    });

    /**
     * Model for storing data related to the Emoji picker widget
     * @class
     * @namespace _converse.EmojiPicker
     * @memberOf _converse
     */
    _core_js__WEBPACK_IMPORTED_MODULE_1__._converse.EmojiPicker = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__.Model.extend({
      defaults: {
        'current_category': 'smileys',
        'current_skintone': '',
        'scroll_position': 0
      }
    });

    // We extend the default converse.js API to add methods specific to MUC groupchats.
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_1__.api, {
      /**
       * @namespace api.emojis
       * @memberOf api
       */
      emojis: {
        /**
         * Initializes Emoji support by downloading the emojis JSON (and any applicable images).
         * @method api.emojis.initialize
         * @returns {Promise}
         */
        async initialize() {
          if (!_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.initialized) {
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.initialized = true;
            const {
              default: json
            } = await __webpack_require__.e(/*! import() | emojis */ "emojis").then(__webpack_require__.t.bind(__webpack_require__, /*! ./emoji.json */ "./src/headless/plugins/emoji/emoji.json", 19));
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.json = json;
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.by_sn = Object.keys(json).reduce((result, cat) => Object.assign(result, json[cat]), {});
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.list = Object.values(_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.by_sn);
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.list.sort((a, b) => a.sn < b.sn ? -1 : a.sn > b.sn ? 1 : 0);
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.shortnames = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.list.map(m => m.sn);
            const getShortNames = () => _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.shortnames.map(s => s.replace(/[+]/g, "\\$&")).join('|');
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.shortnames_regex = new RegExp(getShortNames(), "gi");
            _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.initialized_promise.resolve();
          }
          return _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.initialized_promise;
        }
      }
    });
  }
});

/***/ }),

/***/ "./src/headless/plugins/emoji/regexes.js":
/*!***********************************************!*\
  !*** ./src/headless/plugins/emoji/regexes.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ASCII_REPLACE_REGEX": () => (/* binding */ ASCII_REPLACE_REGEX),
/* harmony export */   "CODEPOINTS_REGEX": () => (/* binding */ CODEPOINTS_REGEX)
/* harmony export */ });
const ASCII_REGEX = '(\\*\\\\0\\/\\*|\\*\\\\O\\/\\*|\\-___\\-|\\:\'\\-\\)|\'\\:\\-\\)|\'\\:\\-D|\\>\\:\\-\\)|>\\:\\-\\)|\'\\:\\-\\(|\\>\\:\\-\\(|>\\:\\-\\(|\\:\'\\-\\(|O\\:\\-\\)|0\\:\\-3|0\\:\\-\\)|0;\\^\\)|O;\\-\\)|0;\\-\\)|O\\:\\-3|\\-__\\-|\\:\\-Þ|\\:\\-Þ|\\<\\/3|<\\/3|\\:\'\\)|\\:\\-D|\'\\:\\)|\'\\=\\)|\'\\:D|\'\\=D|\\>\\:\\)|>\\:\\)|\\>;\\)|>;\\)|\\>\\=\\)|>\\=\\)|;\\-\\)|\\*\\-\\)|;\\-\\]|;\\^\\)|\'\\:\\(|\'\\=\\(|\\:\\-\\*|\\:\\^\\*|\\>\\:P|>\\:P|X\\-P|\\>\\:\\[|>\\:\\[|\\:\\-\\(|\\:\\-\\[|\\>\\:\\(|>\\:\\(|\\:\'\\(|;\\-\\(|\\>\\.\\<|>\\.<|#\\-\\)|%\\-\\)|X\\-\\)|\\\\0\\/|\\\\O\\/|0\\:3|0\\:\\)|O\\:\\)|O\\=\\)|O\\:3|B\\-\\)|8\\-\\)|B\\-D|8\\-D|\\-_\\-|\\>\\:\\\\|>\\:\\\\|\\>\\:\\/|>\\:\\/|\\:\\-\\/|\\:\\-\\.|\\:\\-P|\\:Þ|\\:Þ|\\:\\-b|\\:\\-O|O_O|\\>\\:O|>\\:O|\\:\\-X|\\:\\-#|\\:\\-\\)|\\(y\\)|\\<3|<3|\\:D|\\=D|;\\)|\\*\\)|;\\]|;D|\\:\\*|\\=\\*|\\:\\(|\\:\\[|\\=\\(|\\:@|;\\(|D\\:|\\:\\$|\\=\\$|#\\)|%\\)|X\\)|B\\)|8\\)|\\:\\/|\\:\\\\|\\=\\/|\\=\\\\|\\:L|\\=L|\\:P|\\=P|\\:b|\\:O|\\:X|\\:#|\\=X|\\=#|\\:\\)|\\=\\]|\\=\\)|\\:\\])';
const ASCII_REPLACE_REGEX = new RegExp("<object[^>]*>.*?<\/object>|<span[^>]*>.*?<\/span>|<(?:object|embed|svg|img|div|span|p|a)[^>]*>|((\\s|^)" + ASCII_REGEX + "(?=\\s|$|[!,.?]))", "gi");
const CODEPOINTS_REGEX = /(?:\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffc-\udfff]|\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffd-\udfff]|\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffd\udfff]|\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffe]|\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffc-\udfff]|\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffc-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffd-\udfff]|\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb\udffd-\udfff]|\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb\udffc\udffe\udfff]|\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffd\udfff]|\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb-\udffd\udfff]|\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c[\udffb-\udffe]|\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c[\udffb-\udffe]|\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c[\udffb-\udfff]|\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1|\ud83d\udc6b\ud83c[\udffb-\udfff]|\ud83d\udc6c\ud83c[\udffb-\udfff]|\ud83d\udc6d\ud83c[\udffb-\udfff]|\ud83d[\udc6b-\udc6d])|(?:\ud83d[\udc68\udc69]|\ud83e\uddd1)(?:\ud83c[\udffb-\udfff])?\u200d(?:\u2695\ufe0f|\u2696\ufe0f|\u2708\ufe0f|\ud83c[\udf3e\udf73\udf93\udfa4\udfa8\udfeb\udfed]|\ud83d[\udcbb\udcbc\udd27\udd2c\ude80\ude92]|\ud83e[\uddaf-\uddb3\uddbc\uddbd])|(?:\ud83c[\udfcb\udfcc]|\ud83d[\udd74\udd75]|\u26f9)((?:\ud83c[\udffb-\udfff]|\ufe0f)\u200d[\u2640\u2642]\ufe0f)|(?:\ud83c[\udfc3\udfc4\udfca]|\ud83d[\udc6e\udc71\udc73\udc77\udc81\udc82\udc86\udc87\ude45-\ude47\ude4b\ude4d\ude4e\udea3\udeb4-\udeb6]|\ud83e[\udd26\udd35\udd37-\udd39\udd3d\udd3e\uddb8\uddb9\uddcd-\uddcf\uddd6-\udddd])(?:\ud83c[\udffb-\udfff])?\u200d[\u2640\u2642]\ufe0f|(?:\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68|\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d[\udc68\udc69]|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc68|\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d[\udc66\udc67]|\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d[\udc68\udc69]|\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66|\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83c\udff3\ufe0f\u200d\u26a7\ufe0f|\ud83c\udff3\ufe0f\u200d\ud83c\udf08|\ud83c\udff4\u200d\u2620\ufe0f|\ud83d\udc15\u200d\ud83e\uddba|\ud83d\udc41\u200d\ud83d\udde8|\ud83d\udc68\u200d\ud83d[\udc66\udc67]|\ud83d\udc69\u200d\ud83d[\udc66\udc67]|\ud83d\udc6f\u200d\u2640\ufe0f|\ud83d\udc6f\u200d\u2642\ufe0f|\ud83e\udd3c\u200d\u2640\ufe0f|\ud83e\udd3c\u200d\u2642\ufe0f|\ud83e\uddde\u200d\u2640\ufe0f|\ud83e\uddde\u200d\u2642\ufe0f|\ud83e\udddf\u200d\u2640\ufe0f|\ud83e\udddf\u200d\u2642\ufe0f)|[#*0-9]\ufe0f?\u20e3|(?:[©®\u2122\u265f]\ufe0f)|(?:\ud83c[\udc04\udd70\udd71\udd7e\udd7f\ude02\ude1a\ude2f\ude37\udf21\udf24-\udf2c\udf36\udf7d\udf96\udf97\udf99-\udf9b\udf9e\udf9f\udfcd\udfce\udfd4-\udfdf\udff3\udff5\udff7]|\ud83d[\udc3f\udc41\udcfd\udd49\udd4a\udd6f\udd70\udd73\udd76-\udd79\udd87\udd8a-\udd8d\udda5\udda8\uddb1\uddb2\uddbc\uddc2-\uddc4\uddd1-\uddd3\udddc-\uddde\udde1\udde3\udde8\uddef\uddf3\uddfa\udecb\udecd-\udecf\udee0-\udee5\udee9\udef0\udef3]|[\u203c\u2049\u2139\u2194-\u2199\u21a9\u21aa\u231a\u231b\u2328\u23cf\u23ed-\u23ef\u23f1\u23f2\u23f8-\u23fa\u24c2\u25aa\u25ab\u25b6\u25c0\u25fb-\u25fe\u2600-\u2604\u260e\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262a\u262e\u262f\u2638-\u263a\u2640\u2642\u2648-\u2653\u2660\u2663\u2665\u2666\u2668\u267b\u267f\u2692-\u2697\u2699\u269b\u269c\u26a0\u26a1\u26a7\u26aa\u26ab\u26b0\u26b1\u26bd\u26be\u26c4\u26c5\u26c8\u26cf\u26d1\u26d3\u26d4\u26e9\u26ea\u26f0-\u26f5\u26f8\u26fa\u26fd\u2702\u2708\u2709\u270f\u2712\u2714\u2716\u271d\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u2764\u27a1\u2934\u2935\u2b05-\u2b07\u2b1b\u2b1c\u2b50\u2b55\u3030\u303d\u3297\u3299])(?:\ufe0f|(?!\ufe0e))|(?:(?:\ud83c[\udfcb\udfcc]|\ud83d[\udd74\udd75\udd90]|[\u261d\u26f7\u26f9\u270c\u270d])(?:\ufe0f|(?!\ufe0e))|(?:\ud83c[\udf85\udfc2-\udfc4\udfc7\udfca]|\ud83d[\udc42\udc43\udc46-\udc50\udc66-\udc69\udc6e\udc70-\udc78\udc7c\udc81-\udc83\udc85-\udc87\udcaa\udd7a\udd95\udd96\ude45-\ude47\ude4b-\ude4f\udea3\udeb4-\udeb6\udec0\udecc]|\ud83e[\udd0f\udd18-\udd1c\udd1e\udd1f\udd26\udd30-\udd39\udd3d\udd3e\uddb5\uddb6\uddb8\uddb9\uddbb\uddcd-\uddcf\uddd1-\udddd]|[\u270a\u270b]))(?:\ud83c[\udffb-\udfff])?|(?:\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc65\udb40\udc6e\udb40\udc67\udb40\udc7f|\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc73\udb40\udc63\udb40\udc74\udb40\udc7f|\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc77\udb40\udc6c\udb40\udc73\udb40\udc7f|\ud83c\udde6\ud83c[\udde8-\uddec\uddee\uddf1\uddf2\uddf4\uddf6-\uddfa\uddfc\uddfd\uddff]|\ud83c\udde7\ud83c[\udde6\udde7\udde9-\uddef\uddf1-\uddf4\uddf6-\uddf9\uddfb\uddfc\uddfe\uddff]|\ud83c\udde8\ud83c[\udde6\udde8\udde9\uddeb-\uddee\uddf0-\uddf5\uddf7\uddfa-\uddff]|\ud83c\udde9\ud83c[\uddea\uddec\uddef\uddf0\uddf2\uddf4\uddff]|\ud83c\uddea\ud83c[\udde6\udde8\uddea\uddec\udded\uddf7-\uddfa]|\ud83c\uddeb\ud83c[\uddee-\uddf0\uddf2\uddf4\uddf7]|\ud83c\uddec\ud83c[\udde6\udde7\udde9-\uddee\uddf1-\uddf3\uddf5-\uddfa\uddfc\uddfe]|\ud83c\udded\ud83c[\uddf0\uddf2\uddf3\uddf7\uddf9\uddfa]|\ud83c\uddee\ud83c[\udde8-\uddea\uddf1-\uddf4\uddf6-\uddf9]|\ud83c\uddef\ud83c[\uddea\uddf2\uddf4\uddf5]|\ud83c\uddf0\ud83c[\uddea\uddec-\uddee\uddf2\uddf3\uddf5\uddf7\uddfc\uddfe\uddff]|\ud83c\uddf1\ud83c[\udde6-\udde8\uddee\uddf0\uddf7-\uddfb\uddfe]|\ud83c\uddf2\ud83c[\udde6\udde8-\udded\uddf0-\uddff]|\ud83c\uddf3\ud83c[\udde6\udde8\uddea-\uddec\uddee\uddf1\uddf4\uddf5\uddf7\uddfa\uddff]|\ud83c\uddf4\ud83c\uddf2|\ud83c\uddf5\ud83c[\udde6\uddea-\udded\uddf0-\uddf3\uddf7-\uddf9\uddfc\uddfe]|\ud83c\uddf6\ud83c\udde6|\ud83c\uddf7\ud83c[\uddea\uddf4\uddf8\uddfa\uddfc]|\ud83c\uddf8\ud83c[\udde6-\uddea\uddec-\uddf4\uddf7-\uddf9\uddfb\uddfd-\uddff]|\ud83c\uddf9\ud83c[\udde6\udde8\udde9\uddeb-\udded\uddef-\uddf4\uddf7\uddf9\uddfb\uddfc\uddff]|\ud83c\uddfa\ud83c[\udde6\uddec\uddf2\uddf3\uddf8\uddfe\uddff]|\ud83c\uddfb\ud83c[\udde6\udde8\uddea\uddec\uddee\uddf3\uddfa]|\ud83c\uddfc\ud83c[\uddeb\uddf8]|\ud83c\uddfd\ud83c\uddf0|\ud83c\uddfe\ud83c[\uddea\uddf9]|\ud83c\uddff\ud83c[\udde6\uddf2\uddfc]|\ud83c[\udccf\udd8e\udd91-\udd9a\udde6-\uddff\ude01\ude32-\ude36\ude38-\ude3a\ude50\ude51\udf00-\udf20\udf2d-\udf35\udf37-\udf7c\udf7e-\udf84\udf86-\udf93\udfa0-\udfc1\udfc5\udfc6\udfc8\udfc9\udfcf-\udfd3\udfe0-\udff0\udff4\udff8-\udfff]|\ud83d[\udc00-\udc3e\udc40\udc44\udc45\udc51-\udc65\udc6a\udc6f\udc79-\udc7b\udc7d-\udc80\udc84\udc88-\udca9\udcab-\udcfc\udcff-\udd3d\udd4b-\udd4e\udd50-\udd67\udda4\uddfb-\ude44\ude48-\ude4a\ude80-\udea2\udea4-\udeb3\udeb7-\udebf\udec1-\udec5\uded0-\uded2\uded5\udeeb\udeec\udef4-\udefa\udfe0-\udfeb]|\ud83e[\udd0d\udd0e\udd10-\udd17\udd1d\udd20-\udd25\udd27-\udd2f\udd3a\udd3c\udd3f-\udd45\udd47-\udd71\udd73-\udd76\udd7a-\udda2\udda5-\uddaa\uddae-\uddb4\uddb7\uddba\uddbc-\uddca\uddd0\uddde-\uddff\ude70-\ude73\ude78-\ude7a\ude80-\ude82\ude90-\ude95]|[\u23e9-\u23ec\u23f0\u23f3\u267e\u26ce\u2705\u2728\u274c\u274e\u2753-\u2755\u2795-\u2797\u27b0\u27bf\ue50a])|\ufe0f/g;

/***/ }),

/***/ "./src/headless/plugins/emoji/utils.js":
/*!*********************************************!*\
  !*** ./src/headless/plugins/emoji/utils.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "convertASCII2Emoji": () => (/* binding */ convertASCII2Emoji),
/* harmony export */   "getCodePointReferences": () => (/* binding */ getCodePointReferences),
/* harmony export */   "getShortnameReferences": () => (/* binding */ getShortnameReferences)
/* harmony export */ });
/* harmony import */ var _regexes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./regexes.js */ "./src/headless/plugins/emoji/regexes.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");


const {
  u
} = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.env;

// Closured cache
const emojis_by_attribute = {};
const ASCII_LIST = {
  '*\\0/*': '1f646',
  '*\\O/*': '1f646',
  '-___-': '1f611',
  ':\'-)': '1f602',
  '\':-)': '1f605',
  '\':-D': '1f605',
  '>:-)': '1f606',
  '\':-(': '1f613',
  '>:-(': '1f620',
  ':\'-(': '1f622',
  'O:-)': '1f607',
  '0:-3': '1f607',
  '0:-)': '1f607',
  '0;^)': '1f607',
  'O;-)': '1f607',
  '0;-)': '1f607',
  'O:-3': '1f607',
  '-__-': '1f611',
  ':-Þ': '1f61b',
  '</3': '1f494',
  ':\')': '1f602',
  ':-D': '1f603',
  '\':)': '1f605',
  '\'=)': '1f605',
  '\':D': '1f605',
  '\'=D': '1f605',
  '>:)': '1f606',
  '>;)': '1f606',
  '>=)': '1f606',
  ';-)': '1f609',
  '*-)': '1f609',
  ';-]': '1f609',
  ';^)': '1f609',
  '\':(': '1f613',
  '\'=(': '1f613',
  ':-*': '1f618',
  ':^*': '1f618',
  '>:P': '1f61c',
  'X-P': '1f61c',
  '>:[': '1f61e',
  ':-(': '1f61e',
  ':-[': '1f61e',
  '>:(': '1f620',
  ':\'(': '1f622',
  ';-(': '1f622',
  '>.<': '1f623',
  '#-)': '1f635',
  '%-)': '1f635',
  'X-)': '1f635',
  '\\0/': '1f646',
  '\\O/': '1f646',
  '0:3': '1f607',
  '0:)': '1f607',
  'O:)': '1f607',
  'O=)': '1f607',
  'O:3': '1f607',
  'B-)': '1f60e',
  '8-)': '1f60e',
  'B-D': '1f60e',
  '8-D': '1f60e',
  '-_-': '1f611',
  '>:\\': '1f615',
  '>:/': '1f615',
  ':-/': '1f615',
  ':-.': '1f615',
  ':-P': '1f61b',
  ':Þ': '1f61b',
  ':-b': '1f61b',
  ':-O': '1f62e',
  'O_O': '1f62e',
  '>:O': '1f62e',
  ':-X': '1f636',
  ':-#': '1f636',
  ':-)': '1f642',
  '(y)': '1f44d',
  '<3': '2764',
  ':D': '1f603',
  '=D': '1f603',
  ';)': '1f609',
  '*)': '1f609',
  ';]': '1f609',
  ';D': '1f609',
  ':*': '1f618',
  '=*': '1f618',
  ':(': '1f61e',
  ':[': '1f61e',
  '=(': '1f61e',
  ':@': '1f620',
  ';(': '1f622',
  'D:': '1f628',
  ':$': '1f633',
  '=$': '1f633',
  '#)': '1f635',
  '%)': '1f635',
  'X)': '1f635',
  'B)': '1f60e',
  '8)': '1f60e',
  ':/': '1f615',
  ':\\': '1f615',
  '=/': '1f615',
  '=\\': '1f615',
  ':L': '1f615',
  '=L': '1f615',
  ':P': '1f61b',
  '=P': '1f61b',
  ':b': '1f61b',
  ':O': '1f62e',
  ':X': '1f636',
  ':#': '1f636',
  '=X': '1f636',
  '=#': '1f636',
  ':)': '1f642',
  '=]': '1f642',
  '=)': '1f642',
  ':]': '1f642'
};
function toCodePoint(unicode_surrogates) {
  const r = [];
  let p = 0;
  let i = 0;
  while (i < unicode_surrogates.length) {
    const c = unicode_surrogates.charCodeAt(i++);
    if (p) {
      r.push((0x10000 + (p - 0xD800 << 10) + (c - 0xDC00)).toString(16));
      p = 0;
    } else if (0xD800 <= c && c <= 0xDBFF) {
      p = c;
    } else {
      r.push(c.toString(16));
    }
  }
  return r.join('-');
}
function fromCodePoint(codepoint) {
  let code = typeof codepoint === 'string' ? parseInt(codepoint, 16) : codepoint;
  if (code < 0x10000) {
    return String.fromCharCode(code);
  }
  code -= 0x10000;
  return String.fromCharCode(0xD800 + (code >> 10), 0xDC00 + (code & 0x3FF));
}
function convert(unicode) {
  // Converts unicode code points and code pairs to their respective characters
  if (unicode.indexOf("-") > -1) {
    const parts = [],
      s = unicode.split('-');
    for (let i = 0; i < s.length; i++) {
      let part = parseInt(s[i], 16);
      if (part >= 0x10000 && part <= 0x10FFFF) {
        const hi = Math.floor((part - 0x10000) / 0x400) + 0xD800;
        const lo = (part - 0x10000) % 0x400 + 0xDC00;
        part = String.fromCharCode(hi) + String.fromCharCode(lo);
      } else {
        part = String.fromCharCode(part);
      }
      parts.push(part);
    }
    return parts.join('');
  }
  return fromCodePoint(unicode);
}
function convertASCII2Emoji(str) {
  // Replace ASCII smileys
  return str.replace(_regexes_js__WEBPACK_IMPORTED_MODULE_0__.ASCII_REPLACE_REGEX, (entire, _, m2, m3) => {
    if (typeof m3 === 'undefined' || m3 === '' || !(u.unescapeHTML(m3) in ASCII_LIST)) {
      // if the ascii doesnt exist just return the entire match
      return entire;
    }
    m3 = u.unescapeHTML(m3);
    const unicode = ASCII_LIST[m3].toUpperCase();
    return m2 + convert(unicode);
  });
}
function getShortnameReferences(text) {
  if (!_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.initialized) {
    throw new Error('getShortnameReferences called before emojis are initialized. ' + 'To avoid this problem, first await the converse.emojis.initialized_promise');
  }
  const references = [...text.matchAll(_core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.shortnames_regex)].filter(ref => ref[0].length > 0);
  return references.map(ref => {
    const cp = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.by_sn[ref[0]].cp;
    return {
      cp,
      'begin': ref.index,
      'end': ref.index + ref[0].length,
      'shortname': ref[0],
      'emoji': cp ? convert(cp) : null
    };
  });
}
function parseStringForEmojis(str, callback) {
  const UFE0Fg = /\uFE0F/g;
  const U200D = String.fromCharCode(0x200D);
  return String(str).replace(_regexes_js__WEBPACK_IMPORTED_MODULE_0__.CODEPOINTS_REGEX, (emoji, _, offset) => {
    const icon_id = toCodePoint(emoji.indexOf(U200D) < 0 ? emoji.replace(UFE0Fg, '') : emoji);
    if (icon_id) callback(icon_id, emoji, offset);
  });
}
function getCodePointReferences(text) {
  const references = [];
  parseStringForEmojis(text, (icon_id, emoji, offset) => {
    var _getEmojisByAtrribute;
    references.push({
      'begin': offset,
      'cp': icon_id,
      'emoji': emoji,
      'end': offset + emoji.length,
      'shortname': ((_getEmojisByAtrribute = getEmojisByAtrribute('cp')[icon_id]) === null || _getEmojisByAtrribute === void 0 ? void 0 : _getEmojisByAtrribute.sn) || ''
    });
  });
  return references;
}
function addEmojisMarkup(text) {
  let list = [text];
  [...getShortnameReferences(text), ...getCodePointReferences(text)].sort((a, b) => b.begin - a.begin).forEach(ref => {
    const text = list.shift();
    const emoji = ref.emoji || ref.shortname;
    list = [text.slice(0, ref.begin) + emoji + text.slice(ref.end), ...list];
  });
  return list;
}

/**
 * Replaces all shortnames in the passed in string with their
 * unicode (emoji) representation.
 * @namespace u
 * @method u.shortnamesToUnicode
 * @param { String } str - String containing the shortname(s)
 * @returns { String }
 */
function shortnamesToUnicode(str) {
  return addEmojisMarkup(convertASCII2Emoji(str)).pop();
}

/**
 * Determines whether the passed in string is just a single emoji shortname;
 * @namespace u
 * @method u.isOnlyEmojis
 * @param { String } shortname - A string which migh be just an emoji shortname
 * @returns { Boolean }
 */
function isOnlyEmojis(text) {
  const words = text.trim().split(/\s+/);
  if (words.length === 0 || words.length > 3) {
    return false;
  }
  const emojis = words.filter(text => {
    const refs = getCodePointReferences(u.shortnamesToUnicode(text));
    return refs.length === 1 && (text === refs[0]['shortname'] || text === refs[0]['emoji']);
  });
  return emojis.length === words.length;
}

/**
 * @namespace u
 * @method u.getEmojisByAtrribute
 * @param { 'category'|'cp'|'sn' } attr
 *  The attribute according to which the returned map should be keyed.
 * @returns { Object }
 *  Map of emojis with the passed in `attr` used as key and a list of emojis as values.
 */
function getEmojisByAtrribute(attr) {
  if (emojis_by_attribute[attr]) {
    return emojis_by_attribute[attr];
  }
  if (attr === 'category') {
    return _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.json;
  }
  const all_variants = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.list.map(e => e[attr]).filter((c, i, arr) => arr.indexOf(c) == i);
  emojis_by_attribute[attr] = {};
  all_variants.forEach(v => emojis_by_attribute[attr][v] = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.emojis.list.find(i => i[attr] === v));
  return emojis_by_attribute[attr];
}
Object.assign(u, {
  getEmojisByAtrribute,
  isOnlyEmojis,
  shortnamesToUnicode
});

/***/ }),

/***/ "./src/headless/plugins/headlines/api.js":
/*!***********************************************!*\
  !*** ./src/headless/plugins/headlines/api.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The "headlines" namespace, which is used for headline-channels
   * which are read-only channels containing messages of type
   * "headline".
   *
   * @namespace api.headlines
   * @memberOf api
   */
  headlines: {
    /**
     * Retrieves a headline-channel or all headline-channels.
     *
     * @method api.headlines.get
     * @param {String|String[]} jids - e.g. 'buddy@example.com' or ['buddy1@example.com', 'buddy2@example.com']
     * @param {Object} [attrs] - Attributes to be set on the _converse.ChatBox model.
     * @param {Boolean} [create=false] - Whether the chat should be created if it's not found.
     * @returns { Promise<_converse.HeadlinesFeed> }
     */
    async get(jids) {
      let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      let create = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      async function _get(jid) {
        let model = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.get(jid);
        if (!model && create) {
          model = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.create(jid, attrs, _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.HeadlinesFeed);
        } else {
          model = model && model.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.HEADLINES_TYPE ? model : null;
          if (model && Object.keys(attrs).length) {
            model.save(attrs);
          }
        }
        return model;
      }
      if (jids === undefined) {
        const chats = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.chatboxes.get();
        return chats.filter(c => c.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.HEADLINES_TYPE);
      } else if (typeof jids === 'string') {
        return _get(jids);
      }
      return Promise.all(jids.map(jid => _get(jid)));
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/headlines/feed.js":
/*!************************************************!*\
  !*** ./src/headless/plugins/headlines/feed.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HeadlinesFeed)
/* harmony export */ });
/* harmony import */ var _converse_headless_plugins_chat_model_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/plugins/chat/model.js */ "./src/headless/plugins/chat/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");


class HeadlinesFeed extends _converse_headless_plugins_chat_model_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  defaults() {
    return {
      'bookmarked': false,
      'hidden': ['mobile', 'fullscreen'].includes(_core_js__WEBPACK_IMPORTED_MODULE_1__.api.settings.get("view_mode")),
      'message_type': 'headline',
      'num_unread': 0,
      'time_opened': this.get('time_opened') || new Date().getTime(),
      'type': _core_js__WEBPACK_IMPORTED_MODULE_1__._converse.HEADLINES_TYPE
    };
  }
  async initialize() {
    this.set({
      'box_id': `box-${this.get('jid')}`
    });
    this.initUI();
    this.initMessages();
    await this.fetchMessages();
    /**
     * Triggered once a { @link _converse.HeadlinesFeed } has been created and initialized.
     * @event _converse#headlinesFeedInitialized
     * @type { _converse.HeadlinesFeed }
     * @example _converse.api.listen.on('headlinesFeedInitialized', model => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_1__.api.trigger('headlinesFeedInitialized', this);
  }
}

/***/ }),

/***/ "./src/headless/plugins/headlines/index.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/headlines/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _feed_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./feed.js */ "./src/headless/plugins/headlines/feed.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/headlines/api.js");
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/headlines/utils.js");
/**
 * @module converse-headlines
 * @copyright 2022, the Converse.js contributors
 */




_converse_headless_core__WEBPACK_IMPORTED_MODULE_2__.converse.plugins.add('converse-headlines', {
  dependencies: ["converse-chat"],
  overrides: {
    // Overrides mentioned here will be picked up by converse.js's
    // plugin architecture they will replace existing methods on the
    // relevant objects or classes.

    ChatBoxes: {
      model(attrs, options) {
        const {
          _converse
        } = this.__super__;
        if (attrs.type == _converse.HEADLINES_TYPE) {
          return new _converse.HeadlinesFeed(attrs, options);
        } else {
          return this.__super__.model.apply(this, arguments);
        }
      }
    }
  },
  initialize() {
    /**
     * Shows headline messages
     * @class
     * @namespace _converse.HeadlinesFeed
     * @memberOf _converse
     */
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_2__._converse.HeadlinesFeed = _feed_js__WEBPACK_IMPORTED_MODULE_0__["default"];
    function registerHeadlineHandler() {
      _converse_headless_core__WEBPACK_IMPORTED_MODULE_2__._converse.connection.addHandler(m => (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.onHeadlineMessage)(m) || true, null, 'message');
    }
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('connected', registerHeadlineHandler);
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_2__.api.listen.on('reconnected', registerHeadlineHandler);
    Object.assign(_converse_headless_core__WEBPACK_IMPORTED_MODULE_2__.api, _api_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
  }
});

/***/ }),

/***/ "./src/headless/plugins/headlines/utils.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/headlines/utils.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "onHeadlineMessage": () => (/* binding */ onHeadlineMessage)
/* harmony export */ });
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/shared/parsers */ "./src/headless/shared/parsers.js");
/* harmony import */ var _converse_headless_plugins_chat_parsers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/plugins/chat/parsers */ "./src/headless/plugins/chat/parsers.js");




/**
 * Handler method for all incoming messages of type "headline".
 * @param { XMLElement } stanza
 */
async function onHeadlineMessage(stanza) {
  if ((0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_1__.isHeadline)(stanza) || (0,_converse_headless_shared_parsers__WEBPACK_IMPORTED_MODULE_1__.isServerMessage)(stanza)) {
    const from_jid = stanza.getAttribute('from');
    await _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.waitUntil('rosterInitialized');
    if (from_jid.includes('@') && !_converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.roster.get(from_jid) && !_converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.settings.get("allow_non_roster_messaging")) {
      return;
    }
    if (stanza.querySelector('body') === null) {
      // Avoid creating a chat box if we have nothing to show inside it.
      return;
    }
    const chatbox = _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.chatboxes.create({
      'id': from_jid,
      'jid': from_jid,
      'type': _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse.HEADLINES_TYPE,
      'from': from_jid
    });
    const attrs = await (0,_converse_headless_plugins_chat_parsers__WEBPACK_IMPORTED_MODULE_2__.parseMessage)(stanza, _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__._converse);
    await chatbox.createMessage(attrs);
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_0__.api.trigger('message', {
      chatbox,
      stanza,
      attrs
    });
  }
}

/***/ }),

/***/ "./src/headless/plugins/mam/api.js":
/*!*****************************************!*\
  !*** ./src/headless/plugins/mam/api.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _converse_headless_shared_rsm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/shared/rsm */ "./src/headless/shared/rsm.js");
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");




const {
  Strophe,
  $iq,
  dayjs
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env;
const {
  NS
} = Strophe;
const u = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env.utils;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The [XEP-0313](https://xmpp.org/extensions/xep-0313.html) Message Archive Management API
   *
   * Enables you to query an XMPP server for archived messages.
   *
   * See also the [message-archiving](/docs/html/configuration.html#message-archiving)
   * option in the configuration settings section, which you'll
   * usually want to use in conjunction with this API.
   *
   * @namespace _converse.api.archive
   * @memberOf _converse.api
   */
  archive: {
    /**
     * @typedef { module:converse-rsm~RSMQueryParameters } MAMFilterParameters
     * Filter parameters which can be used to filter a MAM XEP-0313 archive
     * @property { String } [end] - A date string in ISO-8601 format, before which messages should be returned. Implies backward paging.
     * @property { String } [start] - A date string in ISO-8601 format, after which messages should be returned. Implies forward paging.
     * @property { String } [with] - A JID against which to match messages, according to either their `to` or `from` attributes.
     *     An item in a MUC archive matches if the publisher of the item matches the JID.
     *     If `with` is omitted, all messages that match the rest of the query will be returned, regardless of to/from
     *     addresses of each message.
     */

    /**
     * The options that can be passed in to the {@link _converse.api.archive.query } method
     * @typedef { module:converse-mam~MAMFilterParameters } ArchiveQueryOptions
     * @property { Boolean } [groupchat=false] - Whether the MAM archive is for a groupchat.
     */

    /**
     * Query for archived messages.
     *
     * The options parameter can also be an instance of
     * RSM to enable easy querying between results pages.
     *
     * @method _converse.api.archive.query
     * @param { module:converse-mam~ArchiveQueryOptions } options - An object containing query parameters
     * @throws {Error} An error is thrown if the XMPP server responds with an error.
     * @returns { Promise<module:converse-mam~MAMQueryResult> } A promise which resolves
     *     to a {@link module:converse-mam~MAMQueryResult } object.
     *
     * @example
     * // Requesting all archived messages
     * // ================================
     * //
     * // The simplest query that can be made is to simply not pass in any parameters.
     * // Such a query will return all archived messages for the current user.
     *
     * let result;
     * try {
     *     result = await api.archive.query();
     * } catch (e) {
     *     // The query was not successful, perhaps inform the user?
     *     // The IQ stanza returned by the XMPP server is passed in, so that you
     *     // may inspect it and determine what the problem was.
     * }
     * // Do something with the messages, like showing them in your webpage.
     * result.messages.forEach(m => this.showMessage(m));
     *
     * @example
     * // Requesting all archived messages for a particular contact or room
     * // =================================================================
     * //
     * // To query for messages sent between the current user and another user or room,
     * // the query options need to contain the the JID (Jabber ID) of the user or
     * // room under the  `with` key.
     *
     * // For a particular user
     * let result;
     * try {
     *    result = await api.archive.query({'with': 'john@doe.net'});
     * } catch (e) {
     *     // The query was not successful
     * }
     *
     * // For a particular room
     * let result;
     * try {
     *    result = await api.archive.query({'with': 'discuss@conference.doglovers.net', 'groupchat': true});
     * } catch (e) {
     *     // The query was not successful
     * }
     *
     * @example
     * // Requesting all archived messages before or after a certain date
     * // ===============================================================
     * //
     * // The `start` and `end` parameters are used to query for messages
     * // within a certain timeframe. The passed in date values may either be ISO8601
     * // formatted date strings, or JavaScript Date objects.
     *
     *  const options = {
     *      'with': 'john@doe.net',
     *      'start': '2010-06-07T00:00:00Z',
     *      'end': '2010-07-07T13:23:54Z'
     *  };
     * let result;
     * try {
     *    result = await api.archive.query(options);
     * } catch (e) {
     *     // The query was not successful
     * }
     *
     * @example
     * // Limiting the amount of messages returned
     * // ========================================
     * //
     * // The amount of returned messages may be limited with the `max` parameter.
     * // By default, the messages are returned from oldest to newest.
     *
     * // Return maximum 10 archived messages
     * let result;
     * try {
     *     result = await api.archive.query({'with': 'john@doe.net', 'max':10});
     * } catch (e) {
     *     // The query was not successful
     * }
     *
     * @example
     * // Paging forwards through a set of archived messages
     * // ==================================================
     * //
     * // When limiting the amount of messages returned per query, you might want to
     * // repeatedly make a further query to fetch the next batch of messages.
     * //
     * // To simplify this usecase for you, the callback method receives not only an array
     * // with the returned archived messages, but also a special RSM (*Result Set Management*)
     * // object which contains the query parameters you passed in, as well
     * // as two utility methods `next`, and `previous`.
     * //
     * // When you call one of these utility methods on the returned RSM object, and then
     * // pass the result into a new query, you'll receive the next or previous batch of
     * // archived messages. Please note, when calling these methods, pass in an integer
     * // to limit your results.
     *
     * const options = {'with': 'john@doe.net', 'max':10};
     * let result;
     * try {
     *     result = await api.archive.query(options);
     * } catch (e) {
     *     // The query was not successful
     * }
     * // Do something with the messages, like showing them in your webpage.
     * result.messages.forEach(m => this.showMessage(m));
     *
     * while (!result.complete) {
     *     try {
     *         result = await api.archive.query(Object.assign(options, rsm.next(10).query));
     *     } catch (e) {
     *         // The query was not successful
     *     }
     *     // Do something with the messages, like showing them in your webpage.
     *     result.messages.forEach(m => this.showMessage(m));
     * }
     *
     * @example
     * // Paging backwards through a set of archived messages
     * // ===================================================
     * //
     * // To page backwards through the archive, you need to know the UID of the message
     * // which you'd like to page backwards from and then pass that as value for the
     * // `before` parameter. If you simply want to page backwards from the most recent
     * // message, pass in the `before` parameter with an empty string value `''`.
     *
     * let result;
     * const options = {'before': '', 'max':5};
     * try {
     *     result = await api.archive.query(options);
     * } catch (e) {
     *     // The query was not successful
     * }
     * // Do something with the messages, like showing them in your webpage.
     * result.messages.forEach(m => this.showMessage(m));
     *
     * // Now we query again, to get the previous batch.
     * try {
     *      result = await api.archive.query(Object.assign(options, rsm.previous(5).query));
     * } catch (e) {
     *     // The query was not successful
     * }
     * // Do something with the messages, like showing them in your webpage.
     * result.messages.forEach(m => this.showMessage(m));
     *
     */
    async query(options) {
      if (!_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.connection.connected()) {
        throw new Error('Can\'t call `api.archive.query` before having established an XMPP session');
      }
      const attrs = {
        'type': 'set'
      };
      if (options && options.groupchat) {
        if (!options['with']) {
          throw new Error('You need to specify a "with" value containing ' + 'the chat room JID, when querying groupchat messages.');
        }
        attrs.to = options['with'];
      }
      const jid = attrs.to || _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid;
      const supported = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.disco.supports(NS.MAM, jid);
      if (!supported) {
        _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(`Did not fetch MAM archive for ${jid} because it doesn't support ${NS.MAM}`);
        return {
          'messages': []
        };
      }
      const queryid = u.getUniqueId();
      const stanza = $iq(attrs).c('query', {
        'xmlns': NS.MAM,
        'queryid': queryid
      });
      if (options) {
        stanza.c('x', {
          'xmlns': NS.XFORM,
          'type': 'submit'
        }).c('field', {
          'var': 'FORM_TYPE',
          'type': 'hidden'
        }).c('value').t(NS.MAM).up().up();
        if (options['with'] && !options.groupchat) {
          stanza.c('field', {
            'var': 'with'
          }).c('value').t(options['with']).up().up();
        }
        ['start', 'end'].forEach(t => {
          if (options[t]) {
            const date = dayjs(options[t]);
            if (date.isValid()) {
              stanza.c('field', {
                'var': t
              }).c('value').t(date.toISOString()).up().up();
            } else {
              throw new TypeError(`archive.query: invalid date provided for: ${t}`);
            }
          }
        });
        stanza.up();
        const rsm = new _converse_headless_shared_rsm__WEBPACK_IMPORTED_MODULE_0__.RSM(options);
        if (Object.keys(rsm.query).length) {
          stanza.cnode(rsm.toXML());
        }
      }
      const messages = [];
      const message_handler = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.connection.addHandler(stanza => {
        const result = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`message > result[xmlns="${NS.MAM}"]`, stanza).pop();
        if (result === undefined || result.getAttribute('queryid') !== queryid) {
          return true;
        }
        const from = stanza.getAttribute('from') || _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid;
        if (options.groupchat) {
          if (from !== options['with']) {
            _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(`Ignoring alleged groupchat MAM message from ${stanza.getAttribute('from')}`);
            return true;
          }
        } else if (from !== _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid) {
          _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(`Ignoring alleged MAM message from ${stanza.getAttribute('from')}`);
          return true;
        }
        messages.push(stanza);
        return true;
      }, NS.MAM);
      let error;
      const timeout = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving_timeout');
      const iq_result = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ(stanza, timeout, false);
      if (iq_result === null) {
        const {
          __
        } = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse;
        const err_msg = __("Timeout while trying to fetch archived messages.");
        _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(err_msg);
        error = new _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.TimeoutError(err_msg);
        return {
          messages,
          error
        };
      } else if (u.isErrorStanza(iq_result)) {
        const {
          __
        } = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse;
        const err_msg = __('An error occurred while querying for archived messages.');
        _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(err_msg);
        _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(iq_result);
        error = new Error(err_msg);
        return {
          messages,
          error
        };
      }
      _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.connection.deleteHandler(message_handler);
      let rsm;
      const fin = iq_result && sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`fin[xmlns="${NS.MAM}"]`, iq_result).pop();
      const complete = (fin === null || fin === void 0 ? void 0 : fin.getAttribute('complete')) === 'true';
      const set = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`set[xmlns="${NS.RSM}"]`, fin).pop();
      if (set) {
        rsm = new _converse_headless_shared_rsm__WEBPACK_IMPORTED_MODULE_0__.RSM({
          ...options,
          'xml': set
        });
      }
      /**
       * @typedef { Object } MAMQueryResult
       * @property { Array } messages
       * @property { RSM } [rsm] - An instance of {@link RSM}.
       *  You can call `next()` or `previous()` on this instance,
       *  to get the RSM query parameters for the next or previous
       *  page in the result set.
       * @property { Boolean } complete
       * @property { Error } [error]
       */
      return {
        messages,
        rsm,
        complete
      };
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/mam/index.js":
/*!*******************************************!*\
  !*** ./src/headless/plugins/mam/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _disco_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../disco/index.js */ "./src/headless/plugins/disco/index.js");
/* harmony import */ var _placeholder_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./placeholder.js */ "./src/headless/plugins/mam/placeholder.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/mam/api.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/mam/utils.js");
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/**
 * @description XEP-0313 Message Archive Management
 * @copyright 2022, the Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */





const {
  Strophe
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.converse.env;
const {
  NS
} = Strophe;
_converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.converse.plugins.add('converse-mam', {
  dependencies: ['converse-disco', 'converse-muc'],
  initialize() {
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.settings.extend({
      archived_messages_page_size: '50',
      mam_request_all_pages: true,
      message_archiving: undefined,
      // Supported values are 'always', 'never', 'roster' (https://xmpp.org/extensions/xep-0313.html#prefs)
      message_archiving_timeout: 20000 // Time (in milliseconds) to wait before aborting MAM request
    });

    Object.assign(_converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api, _api_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
    // This is mainly done to aid with tests
    Object.assign(_converse_headless_core__WEBPACK_IMPORTED_MODULE_4__._converse, {
      onMAMError: _utils_js__WEBPACK_IMPORTED_MODULE_3__.onMAMError,
      onMAMPreferences: _utils_js__WEBPACK_IMPORTED_MODULE_3__.onMAMPreferences,
      handleMAMResult: _utils_js__WEBPACK_IMPORTED_MODULE_3__.handleMAMResult,
      MAMPlaceholderMessage: _placeholder_js__WEBPACK_IMPORTED_MODULE_1__["default"]
    });

    /************************ Event Handlers ************************/
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('addClientFeatures', () => _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.disco.own.features.add(NS.MAM));
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('serviceDiscovered', _utils_js__WEBPACK_IMPORTED_MODULE_3__.getMAMPrefsFromFeature);
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('chatRoomViewInitialized', view => {
      if (_converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.settings.get('muc_show_logs_before_join')) {
        (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.preMUCJoinMAMFetch)(view.model);
        // If we want to show MAM logs before entering the MUC, we need
        // to be informed once it's clear that this MUC supports MAM.
        view.model.features.on('change:mam_enabled', () => (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.preMUCJoinMAMFetch)(view.model));
      }
    });
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('enteredNewRoom', muc => muc.features.get('mam_enabled') && (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.fetchNewestMessages)(muc));
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('chatReconnected', chat => {
      if (chat.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__._converse.PRIVATE_CHAT_TYPE) {
        (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.fetchNewestMessages)(chat);
      }
    });
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__.api.listen.on('afterMessagesFetched', chat => {
      if (chat.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_4__._converse.PRIVATE_CHAT_TYPE) {
        (0,_utils_js__WEBPACK_IMPORTED_MODULE_3__.fetchNewestMessages)(chat);
      }
    });
  }
});

/***/ }),

/***/ "./src/headless/plugins/mam/placeholder.js":
/*!*************************************************!*\
  !*** ./src/headless/plugins/mam/placeholder.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MAMPlaceholderMessage)
/* harmony export */ });
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");


const u = _core_js__WEBPACK_IMPORTED_MODULE_1__.converse.env.utils;
class MAMPlaceholderMessage extends _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_0__.Model {
  defaults() {
    // eslint-disable-line class-methods-use-this
    return {
      'msgid': u.getUniqueId(),
      'is_ephemeral': false
    };
  }
}

/***/ }),

/***/ "./src/headless/plugins/mam/utils.js":
/*!*******************************************!*\
  !*** ./src/headless/plugins/mam/utils.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fetchArchivedMessages": () => (/* binding */ fetchArchivedMessages),
/* harmony export */   "fetchNewestMessages": () => (/* binding */ fetchNewestMessages),
/* harmony export */   "getMAMPrefsFromFeature": () => (/* binding */ getMAMPrefsFromFeature),
/* harmony export */   "handleMAMResult": () => (/* binding */ handleMAMResult),
/* harmony export */   "onMAMError": () => (/* binding */ onMAMError),
/* harmony export */   "onMAMPreferences": () => (/* binding */ onMAMPreferences),
/* harmony export */   "preMUCJoinMAMFetch": () => (/* binding */ preMUCJoinMAMFetch)
/* harmony export */ });
/* harmony import */ var _placeholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./placeholder.js */ "./src/headless/plugins/mam/placeholder.js");
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @converse/headless/core */ "./src/headless/core.js");
/* harmony import */ var _converse_headless_plugins_muc_parsers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/headless/plugins/muc/parsers */ "./src/headless/plugins/muc/parsers.js");
/* harmony import */ var _converse_headless_plugins_chat_parsers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @converse/headless/plugins/chat/parsers */ "./src/headless/plugins/chat/parsers.js");






const {
  Strophe,
  $iq
} = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env;
const {
  NS
} = Strophe;
const u = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.converse.env.utils;
function onMAMError(iq) {
  if (iq !== null && iq !== void 0 && iq.querySelectorAll('feature-not-implemented').length) {
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(`Message Archive Management (XEP-0313) not supported by ${iq.getAttribute('from')}`);
  } else {
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(`Error while trying to set archiving preferences for ${iq.getAttribute('from')}.`);
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].error(iq);
  }
}

/**
 * Handle returned IQ stanza containing Message Archive
 * Management (XEP-0313) preferences.
 *
 * XXX: For now we only handle the global default preference.
 * The XEP also provides for per-JID preferences, which is
 * currently not supported in converse.js.
 *
 * Per JID preferences will be set in chat boxes, so it'll
 * probbaly be handled elsewhere in any case.
 */
function onMAMPreferences(iq, feature) {
  const preference = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`prefs[xmlns="${NS.MAM}"]`, iq).pop();
  const default_pref = preference.getAttribute('default');
  if (default_pref !== _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving')) {
    const stanza = $iq({
      'type': 'set'
    }).c('prefs', {
      'xmlns': NS.MAM,
      'default': _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving')
    });
    Array.from(preference.children).forEach(child => stanza.cnode(child).up());

    // XXX: Strictly speaking, the server should respond with the updated prefs
    // (see example 18: https://xmpp.org/extensions/xep-0313.html#config)
    // but Prosody doesn't do this, so we don't rely on it.
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ(stanza).then(() => feature.save({
      'preferences': {
        'default': _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving')
      }
    })).catch(_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.onMAMError);
  } else {
    feature.save({
      'preferences': {
        'default': _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving')
      }
    });
  }
}
function getMAMPrefsFromFeature(feature) {
  const prefs = feature.get('preferences') || {};
  if (feature.get('var') !== NS.MAM || _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving') === undefined) {
    return;
  }
  if (prefs['default'] !== _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('message_archiving')) {
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.sendIQ($iq({
      'type': 'get'
    }).c('prefs', {
      'xmlns': NS.MAM
    })).then(iq => _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.onMAMPreferences(iq, feature)).catch(_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.onMAMError);
  }
}
function preMUCJoinMAMFetch(muc) {
  if (!_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('muc_show_logs_before_join') || !muc.features.get('mam_enabled') || muc.get('prejoin_mam_fetched')) {
    return;
  }
  fetchNewestMessages(muc);
  muc.save({
    'prejoin_mam_fetched': true
  });
}
async function handleMAMResult(model, result, query, options, should_page) {
  await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.emojis.initialize();
  const is_muc = model.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.CHATROOMS_TYPE;
  const doParseMessage = s => is_muc ? (0,_converse_headless_plugins_muc_parsers__WEBPACK_IMPORTED_MODULE_4__.parseMUCMessage)(s, model) : (0,_converse_headless_plugins_chat_parsers__WEBPACK_IMPORTED_MODULE_5__.parseMessage)(s);
  const messages = await Promise.all(result.messages.map(doParseMessage));
  result.messages = messages;

  /**
   * Synchronous event which allows listeners to first do some
   * work based on the MAM result before calling the handlers here.
   * @event _converse#MAMResult
   */
  const data = {
    query,
    'chatbox': model,
    messages
  };
  await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.trigger('MAMResult', data, {
    'synchronous': true
  });
  messages.forEach(m => model.queueMessage(m));
  if (result.error) {
    const event_id = result.error.retry_event_id = u.getUniqueId();
    _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.listen.once(event_id, () => fetchArchivedMessages(model, options, should_page));
    model.createMessageFromError(result.error);
  }
}

/**
 * @typedef { Object } MAMOptions
 * A map of MAM related options that may be passed to fetchArchivedMessages
 * @param { integer } [options.max] - The maximum number of items to return.
 *  Defaults to "archived_messages_page_size"
 * @param { string } [options.after] - The XEP-0359 stanza ID of a message
 *  after which messages should be returned. Implies forward paging.
 * @param { string } [options.before] - The XEP-0359 stanza ID of a message
 *  before which messages should be returned. Implies backward paging.
 * @param { string } [options.end] - A date string in ISO-8601 format,
 *  before which messages should be returned. Implies backward paging.
 * @param { string } [options.start] - A date string in ISO-8601 format,
 *  after which messages should be returned. Implies forward paging.
 * @param { string } [options.with] - The JID of the entity with
 *  which messages were exchanged.
 * @param { boolean } [options.groupchat] - True if archive in groupchat.
 */

/**
 * Fetch XEP-0313 archived messages based on the passed in criteria.
 * @param { _converse.ChatBox | _converse.ChatRoom } model
 * @param { MAMOptions } [options]
 * @param { ('forwards'|'backwards'|null)} [should_page=null] - Determines whether
 *  this function should recursively page through the entire result set if a limited
 *  number of results were returned.
 */
async function fetchArchivedMessages(model) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  let should_page = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (model.disable_mam) {
    return;
  }
  const is_muc = model.get('type') === _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.CHATROOMS_TYPE;
  const mam_jid = is_muc ? model.get('jid') : _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid;
  if (!(await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.disco.supports(NS.MAM, mam_jid))) {
    return;
  }
  const max = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('archived_messages_page_size');
  const query = Object.assign({
    'groupchat': is_muc,
    'max': max,
    'with': model.get('jid')
  }, options);
  const result = await _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.archive.query(query);
  await handleMAMResult(model, result, query, options, should_page);
  if (result.rsm && !result.complete) {
    if (should_page) {
      if (should_page === 'forwards') {
        options = result.rsm.next(max, options.before).query;
      } else if (should_page === 'backwards') {
        options = result.rsm.previous(max, options.after).query;
      }
      return fetchArchivedMessages(model, options, should_page);
    } else {
      createPlaceholder(model, options, result);
    }
  }
}

/**
 * Create a placeholder message which is used to indicate gaps in the history.
 * @param { _converse.ChatBox | _converse.ChatRoom } model
 * @param { MAMOptions } options
 * @param { object } result - The RSM result object
 */
async function createPlaceholder(model, options, result) {
  if (options.before == '' && (model.messages.length === 0 || !options.start)) {
    // Fetching the latest MAM messages with an empty local cache
    return;
  }
  if (options.before && !options.start) {
    // Infinite scrolling upward
    return;
  }
  if (options.before == null) {
    // eslint-disable-line no-eq-null
    // Adding placeholders when paging forwards is not supported yet,
    // since currently with standard Converse, we only page forwards
    // when fetching the entire history (i.e. no gaps should arise).
    return;
  }
  const msgs = await Promise.all(result.messages);
  const {
    rsm
  } = result;
  const key = `stanza_id ${model.get('jid')}`;
  const adjacent_message = msgs.find(m => m[key] === rsm.result.first);
  const msg_data = {
    'template_hook': 'getMessageTemplate',
    'time': new Date(new Date(adjacent_message['time']) - 1).toISOString(),
    'before': rsm.result.first,
    'start': options.start
  };
  model.messages.add(new _placeholder_js__WEBPACK_IMPORTED_MODULE_0__["default"](msg_data));
}

/**
 * Fetches messages that might have been archived *after*
 * the last archived message in our local cache.
 * @param { _converse.ChatBox | _converse.ChatRoom }
 */
function fetchNewestMessages(model) {
  if (model.disable_mam) {
    return;
  }
  const most_recent_msg = model.getMostRecentMessage();

  // if clear_messages_on_reconnection is true, than any recent messages
  // must have been received *after* connection and we instead must query
  // for earlier messages
  if (most_recent_msg && !_converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('clear_messages_on_reconnection')) {
    const should_page = _converse_headless_core__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('mam_request_all_pages');
    if (should_page) {
      const stanza_id = most_recent_msg.get(`stanza_id ${model.get('jid')}`);
      if (stanza_id) {
        fetchArchivedMessages(model, {
          'after': stanza_id
        }, 'forwards');
      } else {
        fetchArchivedMessages(model, {
          'start': most_recent_msg.get('time')
        }, 'forwards');
      }
    } else {
      fetchArchivedMessages(model, {
        'before': '',
        'start': most_recent_msg.get('time')
      });
    }
  } else {
    fetchArchivedMessages(model, {
      'before': ''
    });
  }
}

/***/ }),

/***/ "./src/headless/plugins/muc/affiliations/api.js":
/*!******************************************************!*\
  !*** ./src/headless/plugins/muc/affiliations/api.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/muc/affiliations/utils.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The "affiliations" namespace groups methods relevant to setting and
   * getting MUC affiliations.
   *
   * @namespace api.rooms.affiliations
   * @memberOf api.rooms
   */
  affiliations: {
    /**
     * Set the given affliation for the given JIDs in the specified MUCs
     *
     * @param { String|Array<String> } muc_jids - The JIDs of the MUCs in
     *  which the affiliation should be set.
     * @param { Object[] } users - An array of objects representing users
     *  for whom the affiliation is to be set.
     * @param { String } users[].jid - The JID of the user whose affiliation will change
     * @param { ('outcast'|'member'|'admin'|'owner') } users[].affiliation - The new affiliation for this user
     * @param { String } [users[].reason] - An optional reason for the affiliation change
     * @returns { Promise }
     *
     * @example
     *  api.rooms.affiliations.set(
     *      [
     *          'muc1@muc.example.org',
     *          'muc2@muc.example.org'
     *      ], [
     *          {
     *              'jid': 'user@example.org',
     *              'affiliation': 'member',
     *              'reason': "You're one of us now!"
     *          }
     *      ]
     *  )
     */
    set(muc_jids, users) {
      users = !Array.isArray(users) ? [users] : users;
      muc_jids = !Array.isArray(muc_jids) ? [muc_jids] : muc_jids;
      return (0,_utils_js__WEBPACK_IMPORTED_MODULE_0__.setAffiliations)(muc_jids, users);
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/muc/affiliations/utils.js":
/*!********************************************************!*\
  !*** ./src/headless/plugins/muc/affiliations/utils.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "computeAffiliationsDelta": () => (/* binding */ computeAffiliationsDelta),
/* harmony export */   "getAffiliationList": () => (/* binding */ getAffiliationList),
/* harmony export */   "getAssignableAffiliations": () => (/* binding */ getAssignableAffiliations),
/* harmony export */   "setAffiliation": () => (/* binding */ setAffiliation),
/* harmony export */   "setAffiliations": () => (/* binding */ setAffiliations)
/* harmony export */ });
/* harmony import */ var _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @converse/headless/plugins/muc/index.js */ "./src/headless/plugins/muc/index.js");
/* harmony import */ var lodash_es_difference__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es/difference */ "./node_modules/lodash-es/difference.js");
/* harmony import */ var lodash_es_indexOf__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es/indexOf */ "./node_modules/lodash-es/indexOf.js");
/* harmony import */ var _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @converse/headless/log */ "./src/headless/log.js");
/* harmony import */ var _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @converse/headless/core.js */ "./src/headless/core.js");
/* harmony import */ var _parsers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../parsers.js */ "./src/headless/plugins/muc/parsers.js");
/**
 * @copyright The Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 */






const {
  Strophe,
  $iq,
  u
} = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.converse.env;

/**
 * Sends an IQ stanza to the server, asking it for the relevant affiliation list .
 * Returns an array of {@link MemberListItem} objects, representing occupants
 * that have the given affiliation.
 * See: https://xmpp.org/extensions/xep-0045.html#modifymember
 * @param { ("admin"|"owner"|"member") } affiliation
 * @param { String } muc_jid - The JID of the MUC for which the affiliation list should be fetched
 * @returns { Promise<MemberListItem[]> }
 */
async function getAffiliationList(affiliation, muc_jid) {
  const {
    __
  } = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse;
  const iq = $iq({
    'to': muc_jid,
    'type': 'get'
  }).c('query', {
    xmlns: Strophe.NS.MUC_ADMIN
  }).c('item', {
    'affiliation': affiliation
  });
  const result = await _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.sendIQ(iq, null, false);
  if (result === null) {
    const err_msg = __('Error: timeout while fetching %1s list for MUC %2s', affiliation, muc_jid);
    const err = new Error(err_msg);
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(err_msg);
    return err;
  }
  if (u.isErrorStanza(result)) {
    const err_msg = __('Error: not allowed to fetch %1s list for MUC %2s', affiliation, muc_jid);
    const err = new Error(err_msg);
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(err_msg);
    _converse_headless_log__WEBPACK_IMPORTED_MODULE_1__["default"].warn(result);
    return err;
  }
  return (0,_parsers_js__WEBPACK_IMPORTED_MODULE_3__.parseMemberListIQ)(result).filter(p => p).sort((a, b) => a.nick < b.nick ? -1 : a.nick > b.nick ? 1 : 0);
}

/**
 * Given an occupant model, see which affiliations may be assigned to that user.
 * @param { Model } occupant
 * @returns { Array<('owner'|'admin'|'member'|'outcast'|'none')> } - An array of assignable affiliations
 */
function getAssignableAffiliations(occupant) {
  let disabled = _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.settings.get('modtools_disable_assign');
  if (!Array.isArray(disabled)) {
    disabled = disabled ? _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__.AFFILIATIONS : [];
  }
  if (occupant.get('affiliation') === 'owner') {
    return _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__.AFFILIATIONS.filter(a => !disabled.includes(a));
  } else if (occupant.get('affiliation') === 'admin') {
    return _converse_headless_plugins_muc_index_js__WEBPACK_IMPORTED_MODULE_0__.AFFILIATIONS.filter(a => !['owner', 'admin', ...disabled].includes(a));
  } else {
    return [];
  }
}

// Necessary for tests
_converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__._converse.getAssignableAffiliations = getAssignableAffiliations;

/**
 * Send IQ stanzas to the server to modify affiliations for users in this groupchat.
 * See: https://xmpp.org/extensions/xep-0045.html#modifymember
 * @param { Array<Object> } users
 * @param { string } users[].jid - The JID of the user whose affiliation will change
 * @param { Array } users[].affiliation - The new affiliation for this user
 * @param { string } [users[].reason] - An optional reason for the affiliation change
 * @returns { Promise }
 */
function setAffiliations(muc_jid, users) {
  const affiliations = [...new Set(users.map(u => u.affiliation))];
  return Promise.all(affiliations.map(a => setAffiliation(a, muc_jid, users)));
}

/**
 * Send IQ stanzas to the server to set an affiliation for
 * the provided JIDs.
 * See: https://xmpp.org/extensions/xep-0045.html#modifymember
 *
 * Prosody doesn't accept multiple JIDs' affiliations
 * being set in one IQ stanza, so as a workaround we send
 * a separate stanza for each JID.
 * Related ticket: https://issues.prosody.im/345
 *
 * @param { ('outcast'|'member'|'admin'|'owner') } affiliation - The affiliation to be set
 * @param { String|Array<String> } jids - The JID(s) of the MUCs in which the
 *  affiliations need to be set.
 * @param { object } members - A map of jids, affiliations and
 *  optionally reasons. Only those entries with the
 *  same affiliation as being currently set will be considered.
 * @returns { Promise } A promise which resolves and fails depending on the XMPP server response.
 */
function setAffiliation(affiliation, muc_jids, members) {
  if (!Array.isArray(muc_jids)) {
    muc_jids = [muc_jids];
  }
  members = members.filter(m => [undefined, affiliation].includes(m.affiliation));
  return Promise.all(muc_jids.reduce((acc, jid) => [...acc, ...members.map(m => sendAffiliationIQ(affiliation, jid, m))], []));
}

/**
 * Send an IQ stanza specifying an affiliation change.
 * @private
 * @param { String } affiliation: affiliation (could also be stored on the member object).
 * @param { String } muc_jid: The JID of the MUC in which the affiliation should be set.
 * @param { Object } member: Map containing the member's jid and optionally a reason and affiliation.
 */
function sendAffiliationIQ(affiliation, muc_jid, member) {
  const iq = $iq({
    to: muc_jid,
    type: 'set'
  }).c('query', {
    xmlns: Strophe.NS.MUC_ADMIN
  }).c('item', {
    'affiliation': member.affiliation || affiliation,
    'nick': member.nick,
    'jid': member.jid
  });
  if (member.reason !== undefined) {
    iq.c('reason', member.reason);
  }
  return _converse_headless_core_js__WEBPACK_IMPORTED_MODULE_2__.api.sendIQ(iq);
}

/**
 * Given two lists of objects with 'jid', 'affiliation' and
 * 'reason' properties, return a new list containing
 * those objects that are new, changed or removed
 * (depending on the 'remove_absentees' boolean).
 *
 * The affiliations for new and changed members stay the
 * same, for removed members, the affiliation is set to 'none'.
 *
 * The 'reason' property is not taken into account when
 * comparing whether affiliations have been changed.
 * @param { boolean } exclude_existing - Indicates whether JIDs from
 *      the new list which are also in the old list
 *      (regardless of affiliation) should be excluded
 *      from the delta. One reason to do this
 *      would be when you want to add a JID only if it
 *      doesn't have *any* existing affiliation at all.
 * @param { boolean } remove_absentees - Indicates whether JIDs
 *      from the old list which are not in the new list
 *      should be considered removed and therefore be
 *      included in the delta with affiliation set
 *      to 'none'.
 * @param { array } new_list - Array containing the new affiliations
 * @param { array } old_list - Array containing the old affiliations
 * @returns { array }
 */
function computeAffiliationsDelta(exclude_existing, remove_absentees, new_list, old_list) {
  const new_jids = new_list.map(o => o.jid);
  const old_jids = old_list.map(o => o.jid);
  // Get the new affiliations
  let delta = (0,lodash_es_difference__WEBPACK_IMPORTED_MODULE_4__["default"])(new_jids, old_jids).map(jid => new_list[(0,lodash_es_indexOf__WEBPACK_IMPORTED_MODULE_5__["default"])(new_jids, jid)]);
  if (!exclude_existing) {
    // Get the changed affiliations
    delta = delta.concat(new_list.filter(item => {
      const idx = (0,lodash_es_indexOf__WEBPACK_IMPORTED_MODULE_5__["default"])(old_jids, item.jid);
      return idx >= 0 ? item.affiliation !== old_list[idx].affiliation : false;
    }));
  }
  if (remove_absentees) {
    // Get the removed affiliations
    delta = delta.concat((0,lodash_es_difference__WEBPACK_IMPORTED_MODULE_4__["default"])(old_jids, new_jids).map(jid => ({
      'jid': jid,
      'affiliation': 'none'
    })));
  }
  return delta;
}

/***/ }),

/***/ "./src/headless/plugins/muc/api.js":
/*!*****************************************!*\
  !*** ./src/headless/plugins/muc/api.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../log */ "./src/headless/log.js");
/* harmony import */ var _utils_form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/form */ "./src/headless/utils/form.js");
/* harmony import */ var strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! strophe.js/src/strophe */ "./node_modules/strophe.js/src/strophe.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /**
   * The "rooms" namespace groups methods relevant to chatrooms
   * (aka groupchats).
   *
   * @namespace api.rooms
   * @memberOf api
   */
  rooms: {
    /**
     * Creates a new MUC chatroom (aka groupchat)
     *
     * Similar to {@link api.rooms.open}, but creates
     * the chatroom in the background (i.e. doesn't cause a view to open).
     *
     * @method api.rooms.create
     * @param {(string[]|string)} jid|jids The JID or array of
     *     JIDs of the chatroom(s) to create
     * @param {object} [attrs] attrs The room attributes
     * @returns {Promise} Promise which resolves with the Model representing the chat.
     */
    create(jids) {
      let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      attrs = typeof attrs === 'string' ? {
        'nick': attrs
      } : attrs || {};
      if (!attrs.nick && _core_js__WEBPACK_IMPORTED_MODULE_3__.api.settings.get('muc_nickname_from_jid')) {
        attrs.nick = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_2__.Strophe.getNodeFromJid(_core_js__WEBPACK_IMPORTED_MODULE_3__._converse.bare_jid);
      }
      if (jids === undefined) {
        throw new TypeError('rooms.create: You need to provide at least one JID');
      } else if (typeof jids === 'string') {
        return _core_js__WEBPACK_IMPORTED_MODULE_3__.api.rooms.get(_utils_form__WEBPACK_IMPORTED_MODULE_1__["default"].getJIDFromURI(jids), attrs, true);
      }
      return jids.map(jid => _core_js__WEBPACK_IMPORTED_MODULE_3__.api.rooms.get(_utils_form__WEBPACK_IMPORTED_MODULE_1__["default"].getJIDFromURI(jid), attrs, true));
    },
    /**
     * Opens a MUC chatroom (aka groupchat)
     *
     * Similar to {@link api.chats.open}, but for groupchats.
     *
     * @method api.rooms.open
     * @param {string} jid The room JID or JIDs (if not specified, all
     *     currently open rooms will be returned).
     * @param {string} attrs A map  containing any extra room attributes.
     * @param {string} [attrs.nick] The current user's nickname for the MUC
     * @param {boolean} [attrs.auto_configure] A boolean, indicating
     *     whether the room should be configured automatically or not.
     *     If set to `true`, then it makes sense to pass in configuration settings.
     * @param {object} [attrs.roomconfig] A map of configuration settings to be used when the room gets
     *     configured automatically. Currently it doesn't make sense to specify
     *     `roomconfig` values if `auto_configure` is set to `false`.
     *     For a list of configuration values that can be passed in, refer to these values
     *     in the [XEP-0045 MUC specification](https://xmpp.org/extensions/xep-0045.html#registrar-formtype-owner).
     *     The values should be named without the `muc#roomconfig_` prefix.
     * @param {boolean} [attrs.minimized] A boolean, indicating whether the room should be opened minimized or not.
     * @param {boolean} [attrs.bring_to_foreground] A boolean indicating whether the room should be
     *     brought to the foreground and therefore replace the currently shown chat.
     *     If there is no chat currently open, then this option is ineffective.
     * @param {Boolean} [force=false] - By default, a minimized
     *   room won't be maximized (in `overlayed` view mode) and in
     *   `fullscreen` view mode a newly opened room won't replace
     *   another chat already in the foreground.
     *   Set `force` to `true` if you want to force the room to be
     *   maximized or shown.
     * @returns {Promise} Promise which resolves with the Model representing the chat.
     *
     * @example
     * api.rooms.open('group@muc.example.com')
     *
     * @example
     * // To return an array of rooms, provide an array of room JIDs:
     * api.rooms.open(['group1@muc.example.com', 'group2@muc.example.com'])
     *
     * @example
     * // To setup a custom nickname when joining the room, provide the optional nick argument:
     * api.rooms.open('group@muc.example.com', {'nick': 'mycustomnick'})
     *
     * @example
     * // For example, opening a room with a specific default configuration:
     * api.rooms.open(
     *     'myroom@conference.example.org',
     *     { 'nick': 'coolguy69',
     *       'auto_configure': true,
     *       'roomconfig': {
     *           'changesubject': false,
     *           'membersonly': true,
     *           'persistentroom': true,
     *           'publicroom': true,
     *           'roomdesc': 'Comfy room for hanging out',
     *           'whois': 'anyone'
     *       }
     *     }
     * );
     */
    async open(jids) {
      let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      let force = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.waitUntil('chatBoxesFetched');
      if (jids === undefined) {
        const err_msg = 'rooms.open: You need to provide at least one JID';
        _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(err_msg);
        throw new TypeError(err_msg);
      } else if (typeof jids === 'string') {
        const room = await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.rooms.get(jids, attrs, true);
        !attrs.hidden && (room === null || room === void 0 ? void 0 : room.maybeShow(force));
        return room;
      } else {
        const rooms = await Promise.all(jids.map(jid => _core_js__WEBPACK_IMPORTED_MODULE_3__.api.rooms.get(jid, attrs, true)));
        rooms.forEach(r => !attrs.hidden && r.maybeShow(force));
        return rooms;
      }
    },
    /**
     * Fetches the object representing a MUC chatroom (aka groupchat)
     *
     * @method api.rooms.get
     * @param { String } [jid] The room JID (if not specified, all rooms will be returned).
     * @param { Object } [attrs] A map containing any extra room attributes
     *  to be set if `create` is set to `true`
     * @param { String } [attrs.nick] Specify the nickname
     * @param { String } [attrs.password ] Specify a password if needed to enter a new room
     * @param { Boolean } create A boolean indicating whether the room should be created
     *     if not found (default: `false`)
     * @returns { Promise<_converse.ChatRoom> }
     * @example
     * api.waitUntil('roomsAutoJoined').then(() => {
     *     const create_if_not_found = true;
     *     api.rooms.get(
     *         'group@muc.example.com',
     *         {'nick': 'dread-pirate-roberts', 'password': 'secret'},
     *         create_if_not_found
     *     )
     * });
     */
    async get(jids) {
      let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      let create = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.waitUntil('chatBoxesFetched');
      async function _get(jid) {
        jid = _utils_form__WEBPACK_IMPORTED_MODULE_1__["default"].getJIDFromURI(jid);
        let model = await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.chatboxes.get(jid);
        if (!model && create) {
          model = await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.chatboxes.create(jid, attrs, _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.ChatRoom);
        } else {
          model = model && model.get('type') === _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.CHATROOMS_TYPE ? model : null;
          if (model && Object.keys(attrs).length) {
            model.save(attrs);
          }
        }
        return model;
      }
      if (jids === undefined) {
        const chats = await _core_js__WEBPACK_IMPORTED_MODULE_3__.api.chatboxes.get();
        return chats.filter(c => c.get('type') === _core_js__WEBPACK_IMPORTED_MODULE_3__._converse.CHATROOMS_TYPE);
      } else if (typeof jids === 'string') {
        return _get(jids);
      }
      return Promise.all(jids.map(jid => _get(jid)));
    }
  }
});

/***/ }),

/***/ "./src/headless/plugins/muc/constants.js":
/*!***********************************************!*\
  !*** ./src/headless/plugins/muc/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AFFILIATIONS": () => (/* binding */ AFFILIATIONS),
/* harmony export */   "AFFILIATION_CHANGES": () => (/* binding */ AFFILIATION_CHANGES),
/* harmony export */   "AFFILIATION_CHANGES_LIST": () => (/* binding */ AFFILIATION_CHANGES_LIST),
/* harmony export */   "INFO_CODES": () => (/* binding */ INFO_CODES),
/* harmony export */   "MUC_NICK_CHANGED_CODE": () => (/* binding */ MUC_NICK_CHANGED_CODE),
/* harmony export */   "MUC_ROLE_CHANGES": () => (/* binding */ MUC_ROLE_CHANGES),
/* harmony export */   "MUC_ROLE_CHANGES_LIST": () => (/* binding */ MUC_ROLE_CHANGES_LIST),
/* harmony export */   "MUC_ROLE_WEIGHTS": () => (/* binding */ MUC_ROLE_WEIGHTS),
/* harmony export */   "MUC_TRAFFIC_STATES": () => (/* binding */ MUC_TRAFFIC_STATES),
/* harmony export */   "MUC_TRAFFIC_STATES_LIST": () => (/* binding */ MUC_TRAFFIC_STATES_LIST),
/* harmony export */   "ROLES": () => (/* binding */ ROLES),
/* harmony export */   "ROOMSTATUS": () => (/* binding */ ROOMSTATUS),
/* harmony export */   "ROOM_FEATURES": () => (/* binding */ ROOM_FEATURES)
/* harmony export */ });
const ROLES = ['moderator', 'participant', 'visitor'];
const AFFILIATIONS = ['owner', 'admin', 'member', 'outcast', 'none'];
const MUC_ROLE_WEIGHTS = {
  'moderator': 1,
  'participant': 2,
  'visitor': 3,
  'none': 2
};
const AFFILIATION_CHANGES = {
  OWNER: 'owner',
  ADMIN: 'admin',
  MEMBER: 'member',
  EXADMIN: 'exadmin',
  EXOWNER: 'exowner',
  EXOUTCAST: 'exoutcast',
  EXMEMBER: 'exmember'
};
const AFFILIATION_CHANGES_LIST = Object.values(AFFILIATION_CHANGES);
const MUC_TRAFFIC_STATES = {
  ENTERED: 'entered',
  EXITED: 'exited'
};
const MUC_TRAFFIC_STATES_LIST = Object.values(MUC_TRAFFIC_STATES);
const MUC_ROLE_CHANGES = {
  OP: 'op',
  DEOP: 'deop',
  VOICE: 'voice',
  MUTE: 'mute'
};
const MUC_ROLE_CHANGES_LIST = Object.values(MUC_ROLE_CHANGES);
const INFO_CODES = {
  'visibility_changes': ['100', '102', '103', '172', '173', '174'],
  'self': ['110'],
  'non_privacy_changes': ['104', '201'],
  'muc_logging_changes': ['170', '171'],
  'nickname_changes': ['210', '303'],
  'disconnected': ['301', '307', '321', '322', '332', '333'],
  'affiliation_changes': [...AFFILIATION_CHANGES_LIST],
  'join_leave_events': [...MUC_TRAFFIC_STATES_LIST],
  'role_changes': [...MUC_ROLE_CHANGES_LIST]
};
const ROOMSTATUS = {
  CONNECTED: 0,
  CONNECTING: 1,
  NICKNAME_REQUIRED: 2,
  PASSWORD_REQUIRED: 3,
  DISCONNECTED: 4,
  ENTERED: 5,
  DESTROYED: 6,
  BANNED: 7,
  CLOSING: 8
};
const ROOM_FEATURES = ['passwordprotected', 'unsecured', 'hidden', 'publicroom', 'membersonly', 'open', 'persistent', 'temporary', 'nonanonymous', 'semianonymous', 'moderated', 'unmoderated', 'mam_enabled'];
const MUC_NICK_CHANGED_CODE = '303';

// No longer used in code, but useful as reference.
//
// const ROOM_FEATURES_MAP = {
//     'passwordprotected': 'unsecured',
//     'unsecured': 'passwordprotected',
//     'hidden': 'publicroom',
//     'publicroom': 'hidden',
//     'membersonly': 'open',
//     'open': 'membersonly',
//     'persistent': 'temporary',
//     'temporary': 'persistent',
//     'nonanonymous': 'semianonymous',
//     'semianonymous': 'nonanonymous',
//     'moderated': 'unmoderated',
//     'unmoderated': 'moderated'
// };

/***/ }),

/***/ "./src/headless/plugins/muc/index.js":
/*!*******************************************!*\
  !*** ./src/headless/plugins/muc/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AFFILIATIONS": () => (/* binding */ AFFILIATIONS),
/* harmony export */   "ROLES": () => (/* binding */ ROLES)
/* harmony export */ });
/* harmony import */ var _chat_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../chat/index.js */ "./src/headless/plugins/chat/index.js");
/* harmony import */ var _disco_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../disco/index.js */ "./src/headless/plugins/disco/index.js");
/* harmony import */ var _emoji_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../emoji/index.js */ "./src/headless/plugins/emoji/index.js");
/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./message.js */ "./src/headless/plugins/muc/message.js");
/* harmony import */ var _muc_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./muc.js */ "./src/headless/plugins/muc/muc.js");
/* harmony import */ var _occupant_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./occupant.js */ "./src/headless/plugins/muc/occupant.js");
/* harmony import */ var _occupants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./occupants.js */ "./src/headless/plugins/muc/occupants.js");
/* harmony import */ var _affiliations_api_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./affiliations/api.js */ "./src/headless/plugins/muc/affiliations/api.js");
/* harmony import */ var _api_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./api.js */ "./src/headless/plugins/muc/api.js");
/* harmony import */ var _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @converse/skeletor/src/collection */ "./node_modules/@converse/skeletor/src/collection.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils.js */ "./src/headless/plugins/muc/utils.js");
/* harmony import */ var _affiliations_utils_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./affiliations/utils.js */ "./src/headless/plugins/muc/affiliations/utils.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./constants.js */ "./src/headless/plugins/muc/constants.js");
/**
 * @copyright The Converse.js contributors
 * @license Mozilla Public License (MPLv2)
 * @description Implements the non-view logic for XEP-0045 Multi-User Chat
 */














const ROLES = ['moderator', 'participant', 'visitor'];
const AFFILIATIONS = ['owner', 'admin', 'member', 'outcast', 'none'];
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.AFFILIATION_CHANGES = _constants_js__WEBPACK_IMPORTED_MODULE_13__.AFFILIATION_CHANGES;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.AFFILIATION_CHANGES_LIST = _constants_js__WEBPACK_IMPORTED_MODULE_13__.AFFILIATION_CHANGES_LIST;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC_TRAFFIC_STATES = _constants_js__WEBPACK_IMPORTED_MODULE_13__.MUC_TRAFFIC_STATES;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC_TRAFFIC_STATES_LIST = _constants_js__WEBPACK_IMPORTED_MODULE_13__.MUC_TRAFFIC_STATES_LIST;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC_ROLE_CHANGES = _constants_js__WEBPACK_IMPORTED_MODULE_13__.MUC_ROLE_CHANGES;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC_ROLE_CHANGES_LIST = _constants_js__WEBPACK_IMPORTED_MODULE_13__.MUC_ROLE_CHANGES_LIST;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC = {
  INFO_CODES: _constants_js__WEBPACK_IMPORTED_MODULE_13__.INFO_CODES
};
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC_NICK_CHANGED_CODE = _constants_js__WEBPACK_IMPORTED_MODULE_13__.MUC_NICK_CHANGED_CODE;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.ROOM_FEATURES = _constants_js__WEBPACK_IMPORTED_MODULE_13__.ROOM_FEATURES;
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.ROOMSTATUS = _constants_js__WEBPACK_IMPORTED_MODULE_13__.ROOMSTATUS;
const {
  Strophe
} = _core_js__WEBPACK_IMPORTED_MODULE_10__.converse.env;

// Add Strophe Namespaces
Strophe.addNamespace('MUC_ADMIN', Strophe.NS.MUC + '#admin');
Strophe.addNamespace('MUC_OWNER', Strophe.NS.MUC + '#owner');
Strophe.addNamespace('MUC_REGISTER', 'jabber:iq:register');
Strophe.addNamespace('MUC_ROOMCONF', Strophe.NS.MUC + '#roomconfig');
Strophe.addNamespace('MUC_USER', Strophe.NS.MUC + '#user');
Strophe.addNamespace('MUC_HATS', 'xmpp:prosody.im/protocol/hats:1');
Strophe.addNamespace('CONFINFO', 'urn:ietf:params:xml:ns:conference-info');
_core_js__WEBPACK_IMPORTED_MODULE_10__.converse.plugins.add('converse-muc', {
  dependencies: ['converse-chatboxes', 'converse-chat', 'converse-disco'],
  overrides: {
    ChatBoxes: {
      model(attrs, options) {
        const {
          _converse
        } = this.__super__;
        if (attrs && attrs.type == _converse.CHATROOMS_TYPE) {
          return new _converse.ChatRoom(attrs, options);
        } else {
          return this.__super__.model.apply(this, arguments);
        }
      }
    }
  },
  initialize() {
    /* The initialize function gets called as soon as the plugin is
     * loaded by converse.js's plugin machinery.
     */
    const {
      __,
      ___
    } = _core_js__WEBPACK_IMPORTED_MODULE_10__._converse;

    // Configuration values for this plugin
    // ====================================
    // Refer to docs/source/configuration.rst for explanations of these
    // configuration settings.
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.settings.extend({
      'allow_muc_invitations': true,
      'auto_join_on_invite': false,
      'auto_join_rooms': [],
      'auto_register_muc_nickname': false,
      'hide_muc_participants': false,
      'locked_muc_domain': false,
      'modtools_disable_assign': false,
      'muc_clear_messages_on_leave': true,
      'muc_domain': undefined,
      'muc_fetch_members': true,
      'muc_history_max_stanzas': undefined,
      'muc_instant_rooms': true,
      'muc_nickname_from_jid': false,
      'muc_send_probes': false,
      'muc_show_info_messages': [..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.visibility_changes, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.self, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.non_privacy_changes, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.muc_logging_changes, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.nickname_changes, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.disconnected, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.affiliation_changes, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.join_leave_events, ..._core_js__WEBPACK_IMPORTED_MODULE_10__.converse.MUC.INFO_CODES.role_changes],
      'muc_show_logs_before_join': false,
      'muc_subscribe_to_rai': false
    });
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.promises.add(['roomsAutoJoined']);
    if (_core_js__WEBPACK_IMPORTED_MODULE_10__.api.settings.get('locked_muc_domain') && typeof _core_js__WEBPACK_IMPORTED_MODULE_10__.api.settings.get('muc_domain') !== 'string') {
      throw new Error('Config Error: it makes no sense to set locked_muc_domain ' + 'to true when muc_domain is not set');
    }

    // This is for tests (at least until we can import modules inside tests)
    _core_js__WEBPACK_IMPORTED_MODULE_10__.converse.env.muc_utils = {
      computeAffiliationsDelta: _affiliations_utils_js__WEBPACK_IMPORTED_MODULE_12__.computeAffiliationsDelta
    };
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_10__.api, _api_js__WEBPACK_IMPORTED_MODULE_8__["default"]);
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_10__.api.rooms, _affiliations_api_js__WEBPACK_IMPORTED_MODULE_7__["default"]);

    /* https://xmpp.org/extensions/xep-0045.html
     * ----------------------------------------
     * 100 message      Entering a groupchat         Inform user that any occupant is allowed to see the user's full JID
     * 101 message (out of band)                     Affiliation change  Inform user that his or her affiliation changed while not in the groupchat
     * 102 message      Configuration change         Inform occupants that groupchat now shows unavailable members
     * 103 message      Configuration change         Inform occupants that groupchat now does not show unavailable members
     * 104 message      Configuration change         Inform occupants that a non-privacy-related groupchat configuration change has occurred
     * 110 presence     Any groupchat presence       Inform user that presence refers to one of its own groupchat occupants
     * 170 message or initial presence               Configuration change    Inform occupants that groupchat logging is now enabled
     * 171 message      Configuration change         Inform occupants that groupchat logging is now disabled
     * 172 message      Configuration change         Inform occupants that the groupchat is now non-anonymous
     * 173 message      Configuration change         Inform occupants that the groupchat is now semi-anonymous
     * 174 message      Configuration change         Inform occupants that the groupchat is now fully-anonymous
     * 201 presence     Entering a groupchat         Inform user that a new groupchat has been created
     * 210 presence     Entering a groupchat         Inform user that the service has assigned or modified the occupant's roomnick
     * 301 presence     Removal from groupchat       Inform user that he or she has been banned from the groupchat
     * 303 presence     Exiting a groupchat          Inform all occupants of new groupchat nickname
     * 307 presence     Removal from groupchat       Inform user that he or she has been kicked from the groupchat
     * 321 presence     Removal from groupchat       Inform user that he or she is being removed from the groupchat because of an affiliation change
     * 322 presence     Removal from groupchat       Inform user that he or she is being removed from the groupchat because the groupchat has been changed to members-only and the user is not a member
     * 332 presence     Removal from groupchat       Inform user that he or she is being removed from the groupchat because of a system shutdown
     */
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.muc = {
      info_messages: {
        100: __('This groupchat is not anonymous'),
        102: __('This groupchat now shows unavailable members'),
        103: __('This groupchat does not show unavailable members'),
        104: __('The groupchat configuration has changed'),
        170: __('Groupchat logging is now enabled'),
        171: __('Groupchat logging is now disabled'),
        172: __('This groupchat is now no longer anonymous'),
        173: __('This groupchat is now semi-anonymous'),
        174: __('This groupchat is now fully-anonymous'),
        201: __('A new groupchat has been created')
      },
      new_nickname_messages: {
        // XXX: Note the triple underscore function and not double underscore.
        210: ___('Your nickname has been automatically set to %1$s'),
        303: ___('Your nickname has been changed to %1$s')
      },
      disconnect_messages: {
        301: __('You have been banned from this groupchat'),
        333: __('You have exited this groupchat due to a technical problem'),
        307: __('You have been kicked from this groupchat'),
        321: __('You have been removed from this groupchat because of an affiliation change'),
        322: __("You have been removed from this groupchat because the groupchat has changed to members-only and you're not a member"),
        332: __('You have been removed from this groupchat because the service hosting it is being shut down')
      }
    };
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.router.route('converse/room?jid=:jid', _utils_js__WEBPACK_IMPORTED_MODULE_11__.routeToRoom);
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoom = _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatBox.extend(_muc_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoomMessage = _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.Message.extend(_message_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoomOccupants = _occupants_js__WEBPACK_IMPORTED_MODULE_6__["default"];
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoomOccupant = _occupant_js__WEBPACK_IMPORTED_MODULE_5__["default"];

    /**
     * Collection which stores MUC messages
     * @class
     * @namespace _converse.ChatRoomMessages
     * @memberOf _converse
     */
    _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoomMessages = _converse_skeletor_src_collection__WEBPACK_IMPORTED_MODULE_9__.Collection.extend({
      model: _core_js__WEBPACK_IMPORTED_MODULE_10__._converse.ChatRoomMessage,
      comparator: 'time'
    });
    Object.assign(_core_js__WEBPACK_IMPORTED_MODULE_10__._converse, {
      getDefaultMUCNickname: _utils_js__WEBPACK_IMPORTED_MODULE_11__.getDefaultMUCNickname,
      isInfoVisible: _utils_js__WEBPACK_IMPORTED_MODULE_11__.isInfoVisible,
      onDirectMUCInvitation: _utils_js__WEBPACK_IMPORTED_MODULE_11__.onDirectMUCInvitation
    });

    /************************ BEGIN Event Handlers ************************/

    if (_core_js__WEBPACK_IMPORTED_MODULE_10__.api.settings.get('allow_muc_invitations')) {
      _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('connected', _utils_js__WEBPACK_IMPORTED_MODULE_11__.registerDirectInvitationHandler);
      _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('reconnected', _utils_js__WEBPACK_IMPORTED_MODULE_11__.registerDirectInvitationHandler);
    }
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('addClientFeatures', () => _core_js__WEBPACK_IMPORTED_MODULE_10__.api.disco.own.features.add(`${Strophe.NS.CONFINFO}+notify`));
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('addClientFeatures', _utils_js__WEBPACK_IMPORTED_MODULE_11__.onAddClientFeatures);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('beforeResourceBinding', _utils_js__WEBPACK_IMPORTED_MODULE_11__.onBeforeResourceBinding);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('beforeTearDown', _utils_js__WEBPACK_IMPORTED_MODULE_11__.onBeforeTearDown);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('chatBoxesFetched', _utils_js__WEBPACK_IMPORTED_MODULE_11__.autoJoinRooms);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('disconnected', _utils_js__WEBPACK_IMPORTED_MODULE_11__.disconnectChatRooms);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('statusInitialized', _utils_js__WEBPACK_IMPORTED_MODULE_11__.onStatusInitialized);
    _core_js__WEBPACK_IMPORTED_MODULE_10__.api.listen.on('windowStateChanged', _utils_js__WEBPACK_IMPORTED_MODULE_11__.onWindowStateChanged);
  }
});

/***/ }),

/***/ "./src/headless/plugins/muc/message.js":
/*!*********************************************!*\
  !*** ./src/headless/plugins/muc/message.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../log */ "./src/headless/log.js");
/* harmony import */ var strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! strophe.js/src/strophe */ "./node_modules/strophe.js/src/strophe.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");




/**
 * Mixing that turns a Message model into a ChatRoomMessage model.
 * @class
 * @namespace _converse.ChatRoomMessage
 * @memberOf _converse
 */
const ChatRoomMessageMixin = {
  initialize() {
    if (!this.checkValidity()) {
      return;
    }
    if (this.get('file')) {
      this.on('change:put', () => this.uploadFile());
    }
    // If `type` changes from `error` to `groupchat`, we want to set the occupant. See #2733
    this.on('change:type', () => this.setOccupant());
    this.on('change:is_ephemeral', () => this.setTimerForEphemeralMessage());
    this.setTimerForEphemeralMessage();
    this.setOccupant();
    /**
     * Triggered once a { @link _converse.ChatRoomMessage } has been created and initialized.
     * @event _converse#chatRoomMessageInitialized
     * @type { _converse.ChatRoomMessages}
     * @example _converse.api.listen.on('chatRoomMessageInitialized', model => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_2__.api.trigger('chatRoomMessageInitialized', this);
  },
  getDisplayName() {
    var _this$occupant;
    return ((_this$occupant = this.occupant) === null || _this$occupant === void 0 ? void 0 : _this$occupant.getDisplayName()) || this.get('nick');
  },
  /**
   * Determines whether this messsage may be moderated,
   * based on configuration settings and server support.
   * @async
   * @private
   * @method _converse.ChatRoomMessages#mayBeModerated
   * @returns { Boolean }
   */
  mayBeModerated() {
    if (typeof this.get('from_muc') === 'undefined') {
      // If from_muc is not defined, then this message hasn't been
      // reflected yet, which means we won't have a XEP-0359 stanza id.
      return;
    }
    return ['all', 'moderator'].includes(_core_js__WEBPACK_IMPORTED_MODULE_2__.api.settings.get('allow_message_retraction')) && this.get(`stanza_id ${this.get('from_muc')}`) && this.collection.chatbox.canModerateMessages();
  },
  checkValidity() {
    const result = _core_js__WEBPACK_IMPORTED_MODULE_2__._converse.Message.prototype.checkValidity.call(this);
    !result && this.collection.chatbox.debouncedRejoin();
    return result;
  },
  onOccupantRemoved() {
    var _this$collection;
    this.stopListening(this.occupant);
    delete this.occupant;
    const chatbox = this === null || this === void 0 ? void 0 : (_this$collection = this.collection) === null || _this$collection === void 0 ? void 0 : _this$collection.chatbox;
    if (!chatbox) {
      return _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Could not get collection.chatbox for message: ${JSON.stringify(this.toJSON())}`);
    }
    this.listenTo(chatbox.occupants, 'add', this.onOccupantAdded);
  },
  onOccupantAdded(occupant) {
    var _this$collection2;
    if (this.get('occupant_id')) {
      if (occupant.get('occupant_id') !== this.get('occupant_id')) {
        return;
      }
    } else if (occupant.get('nick') !== strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_1__.Strophe.getResourceFromJid(this.get('from'))) {
      return;
    }
    const chatbox = this === null || this === void 0 ? void 0 : (_this$collection2 = this.collection) === null || _this$collection2 === void 0 ? void 0 : _this$collection2.chatbox;
    if (!chatbox) {
      return _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Could not get collection.chatbox for message: ${JSON.stringify(this.toJSON())}`);
    }
    this.occupant = occupant;
    if (occupant.get('jid')) {
      this.save('from_real_jid', occupant.get('jid'));
    }
    this.trigger('occupantAdded');
    this.listenTo(this.occupant, 'destroy', this.onOccupantRemoved);
    this.stopListening(chatbox.occupants, 'add', this.onOccupantAdded);
  },
  setOccupant() {
    var _this$collection3;
    if (this.get('type') !== 'groupchat' || this.isEphemeral() || this.occupant) {
      return;
    }
    const chatbox = this === null || this === void 0 ? void 0 : (_this$collection3 = this.collection) === null || _this$collection3 === void 0 ? void 0 : _this$collection3.chatbox;
    if (!chatbox) {
      return _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Could not get collection.chatbox for message: ${JSON.stringify(this.toJSON())}`);
    }
    const nick = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_1__.Strophe.getResourceFromJid(this.get('from'));
    const occupant_id = this.get('occupant_id');
    this.occupant = chatbox.occupants.findOccupant({
      nick,
      occupant_id
    });
    if (!this.occupant && _core_js__WEBPACK_IMPORTED_MODULE_2__.api.settings.get('muc_send_probes')) {
      this.occupant = chatbox.occupants.create({
        nick,
        occupant_id,
        'type': 'unavailable'
      });
      const jid = `${chatbox.get('jid')}/${nick}`;
      _core_js__WEBPACK_IMPORTED_MODULE_2__.api.user.presence.send('probe', jid);
    }
    if (this.occupant) {
      this.listenTo(this.occupant, 'destroy', this.onOccupantRemoved);
    } else {
      this.listenTo(chatbox.occupants, 'add', this.onOccupantAdded);
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChatRoomMessageMixin);

/***/ }),

/***/ "./src/headless/plugins/muc/muc.js":
/*!*****************************************!*\
  !*** ./src/headless/plugins/muc/muc.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash_es_debounce__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! lodash-es/debounce */ "./node_modules/lodash-es/debounce.js");
/* harmony import */ var lodash_es_invoke__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! lodash-es/invoke */ "./node_modules/lodash-es/invoke.js");
/* harmony import */ var lodash_es_isElement__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! lodash-es/isElement */ "./node_modules/lodash-es/isElement.js");
/* harmony import */ var _log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../log */ "./src/headless/log.js");
/* harmony import */ var _utils_parse_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/parse-helpers */ "./src/headless/utils/parse-helpers.js");
/* harmony import */ var lodash_es_pick__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! lodash-es/pick */ "./node_modules/lodash-es/pick.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! sizzle */ "./node_modules/sizzle/dist/sizzle.js");
/* harmony import */ var sizzle__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(sizzle__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_form__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/form */ "./src/headless/utils/form.js");
/* harmony import */ var _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @converse/skeletor/src/model.js */ "./node_modules/@converse/skeletor/src/model.js");
/* harmony import */ var strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! strophe.js/src/strophe */ "./node_modules/strophe.js/src/strophe.js");
/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core.js */ "./src/headless/core.js");
/* harmony import */ var _affiliations_utils_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./affiliations/utils.js */ "./src/headless/plugins/muc/affiliations/utils.js");
/* harmony import */ var _converse_headless_shared_chat_utils_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @converse/headless/shared/chat/utils.js */ "./src/headless/shared/chat/utils.js");
/* harmony import */ var _converse_openpromise__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @converse/openpromise */ "./node_modules/@converse/openpromise/openpromise.js");
/* harmony import */ var _converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @converse/headless/utils/storage.js */ "./src/headless/utils/storage.js");
/* harmony import */ var _converse_headless_shared_parsers_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @converse/headless/shared/parsers.js */ "./src/headless/shared/parsers.js");
/* harmony import */ var _converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @converse/headless/utils/core.js */ "./src/headless/utils/core.js");
/* harmony import */ var _parsers_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./parsers.js */ "./src/headless/plugins/muc/parsers.js");
/* harmony import */ var _converse_headless_shared_actions_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @converse/headless/shared/actions.js */ "./src/headless/shared/actions.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./constants.js */ "./src/headless/plugins/muc/constants.js");




















const OWNER_COMMANDS = ['owner'];
const ADMIN_COMMANDS = ['admin', 'ban', 'deop', 'destroy', 'member', 'op', 'revoke'];
const MODERATOR_COMMANDS = ['kick', 'mute', 'voice', 'modtools'];
const VISITOR_COMMANDS = ['nick'];
const METADATA_ATTRIBUTES = ["og:article:author", "og:article:published_time", "og:description", "og:image", "og:image:height", "og:image:width", "og:site_name", "og:title", "og:type", "og:url", "og:video:height", "og:video:secure_url", "og:video:tag", "og:video:type", "og:video:url", "og:video:width"];
const ACTION_INFO_CODES = ['301', '303', '333', '307', '321', '322'];
const MUCSession = _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_4__.Model.extend({
  defaults() {
    return {
      'connection_status': _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.DISCONNECTED
    };
  }
});

/**
 * Represents an open/ongoing groupchat conversation.
 * @mixin
 * @namespace _converse.ChatRoom
 * @memberOf _converse
 */
const ChatRoomMixin = {
  defaults() {
    return {
      'bookmarked': false,
      'chat_state': undefined,
      'has_activity': false,
      // XEP-437
      'hidden': (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.isUniView)() && !_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('singleton'),
      'hidden_occupants': !!_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('hide_muc_participants'),
      'message_type': 'groupchat',
      'name': '',
      // For group chats, we distinguish between generally unread
      // messages and those ones that specifically mention the
      // user.
      //
      // To keep things simple, we reuse `num_unread` from
      // _converse.ChatBox to indicate unread messages which
      // mention the user and `num_unread_general` to indicate
      // generally unread messages (which *includes* mentions!).
      'num_unread_general': 0,
      'num_unread': 0,
      'roomconfig': {},
      'time_opened': this.get('time_opened') || new Date().getTime(),
      'time_sent': new Date(0).toISOString(),
      'type': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.CHATROOMS_TYPE
    };
  },
  async initialize() {
    this.initialized = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_9__.getOpenPromise)();
    this.debouncedRejoin = (0,lodash_es_debounce__WEBPACK_IMPORTED_MODULE_16__["default"])(this.rejoin, 250);
    this.set('box_id', `box-${this.get('jid')}`);
    this.initNotifications();
    this.initMessages();
    this.initUI();
    this.initOccupants();
    this.initDiscoModels(); // sendChatState depends on this.features
    this.registerHandlers();
    this.on('change:chat_state', this.sendChatState, this);
    this.on('change:hidden', this.onHiddenChange, this);
    this.on('destroy', this.removeHandlers, this);
    this.ui.on('change:scrolled', this.onScrolledChanged, this);
    await this.restoreSession();
    this.session.on('change:connection_status', this.onConnectionStatusChanged, this);
    this.listenTo(this.occupants, 'add', this.onOccupantAdded);
    this.listenTo(this.occupants, 'remove', this.onOccupantRemoved);
    this.listenTo(this.occupants, 'change:show', this.onOccupantShowChanged);
    this.listenTo(this.occupants, 'change:affiliation', this.createAffiliationChangeMessage);
    this.listenTo(this.occupants, 'change:role', this.createRoleChangeMessage);
    const restored = await this.restoreFromCache();
    if (!restored) {
      this.join();
    }
    /**
     * Triggered once a {@link _converse.ChatRoom} has been created and initialized.
     * @event _converse#chatRoomInitialized
     * @type { _converse.ChatRoom }
     * @example _converse.api.listen.on('chatRoomInitialized', model => { ... });
     */
    await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.trigger('chatRoomInitialized', this, {
      'Synchronous': true
    });
    this.initialized.resolve();
  },
  isEntered() {
    return this.session.get('connection_status') === _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.ENTERED;
  },
  /**
   * Checks whether we're still joined and if so, restores the MUC state from cache.
   * @private
   * @method _converse.ChatRoom#restoreFromCache
   * @returns { Boolean } Returns `true` if we're still joined, otherwise returns `false`.
   */
  async restoreFromCache() {
    if (this.isEntered() && (await this.isJoined())) {
      // We've restored the room from cache and we're still joined.
      await new Promise(r => this.features.fetch({
        'success': r,
        'error': r
      }));
      await new Promise(r => this.config.fetch({
        'success': r,
        'error': r
      }));
      await this.fetchOccupants().catch(e => _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e));
      await this.fetchMessages().catch(e => _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e));
      return true;
    } else {
      this.session.save('connection_status', _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.DISCONNECTED);
      this.clearOccupantsCache();
      return false;
    }
  },
  /**
   * Join the MUC
   * @private
   * @method _converse.ChatRoom#join
   * @param { String } nick - The user's nickname
   * @param { String } [password] - Optional password, if required by the groupchat.
   *  Will fall back to the `password` value stored in the room
   *  model (if available).
   */
  async join(nick, password) {
    if (this.isEntered()) {
      // We have restored a groupchat from session storage,
      // so we don't send out a presence stanza again.
      return this;
    }
    // Set this early, so we don't rejoin in onHiddenChange
    this.session.save('connection_status', _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.CONNECTING);
    await this.refreshDiscoInfo();
    nick = await this.getAndPersistNickname(nick);
    if (!nick) {
      (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.safeSave)(this.session, {
        'connection_status': _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.NICKNAME_REQUIRED
      });
      if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_show_logs_before_join')) {
        await this.fetchMessages();
      }
      return this;
    }
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send(await this.constructJoinPresence(password));
    return this;
  },
  /**
   * Clear stale cache and re-join a MUC we've been in before.
   * @private
   * @method _converse.ChatRoom#rejoin
   */
  rejoin() {
    this.session.save('connection_status', _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.DISCONNECTED);
    this.registerHandlers();
    this.clearOccupantsCache();
    return this.join();
  },
  async constructJoinPresence(password) {
    let stanza = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$pres)({
      'id': (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.getUniqueId)(),
      'from': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.jid,
      'to': this.getRoomJIDAndNick()
    }).c('x', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC
    }).c('history', {
      'maxstanzas': this.features.get('mam_enabled') ? 0 : _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_history_max_stanzas')
    }).up();
    password = password || this.get('password');
    if (password) {
      stanza.cnode(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.xmlElement('password', [], password));
    }
    stanza.up(); // Go one level up, out of the `x` element.
    /**
     * *Hook* which allows plugins to update an outgoing MUC join presence stanza
     * @event _converse#constructedMUCPresence
     * @param { _converse.ChatRoom } - The MUC from which this message stanza is being sent.
     * @param { XMLElement } stanza - The stanza which will be sent out
     */
    stanza = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.hook('constructedMUCPresence', this, stanza);
    return stanza;
  },
  clearOccupantsCache() {
    if (this.occupants.length) {
      // Remove non-members when reconnecting
      this.occupants.filter(o => !o.isMember()).forEach(o => o.destroy());
    } else {
      // Looks like we haven't restored occupants from cache, so we clear it.
      this.occupants.clearStore();
    }
  },
  /**
   * Given the passed in MUC message, send a XEP-0333 chat marker.
   * @param { _converse.MUCMessage } msg
   * @param { ('received'|'displayed'|'acknowledged') } [type='displayed']
   * @param { Boolean } force - Whether a marker should be sent for the
   *  message, even if it didn't include a `markable` element.
   */
  sendMarkerForMessage(msg) {
    let type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'displayed';
    let force = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (!msg || !_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('send_chat_markers').includes(type) || (msg === null || msg === void 0 ? void 0 : msg.get('type')) !== 'groupchat') {
      return;
    }
    if (msg !== null && msg !== void 0 && msg.get('is_markable') || force) {
      const key = `stanza_id ${this.get('jid')}`;
      const id = msg.get(key);
      if (!id) {
        _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Can't send marker for message without stanza ID: ${key}`);
        return;
      }
      const from_jid = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(msg.get('from'));
      (0,_converse_headless_shared_actions_js__WEBPACK_IMPORTED_MODULE_14__.sendMarker)(from_jid, id, type, msg.get('type'));
    }
  },
  /**
   * Ensures that the user is subscribed to XEP-0437 Room Activity Indicators
   * if `muc_subscribe_to_rai` is set to `true`.
   * Only affiliated users can subscribe to RAI, but this method doesn't
   * check whether the current user is affiliated because it's intended to be
   * called after the MUC has been left and we don't have that information
   * anymore.
   * @private
   * @method _converse.ChatRoom#enableRAI
   */
  enableRAI() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_subscribe_to_rai')) {
      const muc_domain = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getDomainFromJid(this.get('jid'));
      _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.presence.send(null, muc_domain, null, (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$build)('rai', {
        'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.RAI
      }));
    }
  },
  /**
   * Handler that gets called when the 'hidden' flag is toggled.
   * @private
   * @method _converse.ChatRoom#onHiddenChange
   */
  async onHiddenChange() {
    const roomstatus = _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS;
    const conn_status = this.session.get('connection_status');
    if (this.get('hidden')) {
      if (conn_status === roomstatus.ENTERED && _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_subscribe_to_rai') && this.getOwnAffiliation() !== 'none') {
        this.sendMarkerForLastMessage('received', true);
        await this.leave();
        this.enableRAI();
      }
    } else {
      if (conn_status === roomstatus.DISCONNECTED) {
        this.rejoin();
      }
      this.clearUnreadMsgCounter();
    }
  },
  onOccupantAdded(occupant) {
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.isInfoVisible(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.ENTERED) && this.session.get('connection_status') === _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.ENTERED && occupant.get('show') === 'online') {
      this.updateNotifications(occupant.get('nick'), _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.ENTERED);
    }
  },
  onOccupantRemoved(occupant) {
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.isInfoVisible(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.EXITED) && this.isEntered() && occupant.get('show') === 'online') {
      this.updateNotifications(occupant.get('nick'), _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.EXITED);
    }
  },
  onOccupantShowChanged(occupant) {
    if (occupant.get('states').includes('303')) {
      return;
    }
    if (occupant.get('show') === 'offline' && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.isInfoVisible(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.EXITED)) {
      this.updateNotifications(occupant.get('nick'), _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.EXITED);
    } else if (occupant.get('show') === 'online' && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.isInfoVisible(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.ENTERED)) {
      this.updateNotifications(occupant.get('nick'), _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_TRAFFIC_STATES.ENTERED);
    }
  },
  async onRoomEntered() {
    await this.occupants.fetchMembers();
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('clear_messages_on_reconnection')) {
      await this.clearMessages();
    } else {
      await this.fetchMessages();
    }
    /**
     * Triggered when the user has entered a new MUC
     * @event _converse#enteredNewRoom
     * @type { _converse.ChatRoom}
     * @example _converse.api.listen.on('enteredNewRoom', model => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.trigger('enteredNewRoom', this);
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('auto_register_muc_nickname') && (await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.supports(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER, this.get('jid')))) {
      this.registerNickname();
    }
  },
  async onConnectionStatusChanged() {
    if (this.isEntered()) {
      if (this.get('hidden') && _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_subscribe_to_rai') && this.getOwnAffiliation() !== 'none') {
        try {
          await this.leave();
        } catch (e) {
          _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
        }
        this.enableRAI();
      } else {
        await this.onRoomEntered();
      }
    }
  },
  async onReconnection() {
    await this.rejoin();
    this.announceReconnection();
  },
  getMessagesCollection() {
    return new _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.ChatRoomMessages();
  },
  restoreSession() {
    const id = `muc.session-${_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid}-${this.get('jid')}`;
    this.session = new MUCSession({
      id
    });
    (0,_converse_headless_utils_storage_js__WEBPACK_IMPORTED_MODULE_10__.initStorage)(this.session, id, 'session');
    return new Promise(r => this.session.fetch({
      'success': r,
      'error': r
    }));
  },
  initDiscoModels() {
    let id = `converse.muc-features-${_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid}-${this.get('jid')}`;
    this.features = new _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_4__.Model(Object.assign({
      id
    }, _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.ROOM_FEATURES.reduce((acc, feature) => {
      acc[feature] = false;
      return acc;
    }, {})));
    this.features.browserStorage = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.createStore(id, 'session');
    this.features.listenTo(_core_js__WEBPACK_IMPORTED_MODULE_6__._converse, 'beforeLogout', () => this.features.browserStorage.flush());
    id = `converse.muc-config-${_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid}-${this.get('jid')}`;
    this.config = new _converse_skeletor_src_model_js__WEBPACK_IMPORTED_MODULE_4__.Model({
      id
    });
    this.config.browserStorage = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.createStore(id, 'session');
    this.config.listenTo(_core_js__WEBPACK_IMPORTED_MODULE_6__._converse, 'beforeLogout', () => this.config.browserStorage.flush());
  },
  initOccupants() {
    this.occupants = new _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.ChatRoomOccupants();
    const id = `converse.occupants-${_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid}${this.get('jid')}`;
    this.occupants.browserStorage = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.createStore(id, 'session');
    this.occupants.chatroom = this;
    this.occupants.listenTo(_core_js__WEBPACK_IMPORTED_MODULE_6__._converse, 'beforeLogout', () => this.occupants.browserStorage.flush());
  },
  fetchOccupants() {
    this.occupants.fetched = new Promise(resolve => {
      this.occupants.fetch({
        'add': true,
        'silent': true,
        'success': resolve,
        'error': resolve
      });
    });
    return this.occupants.fetched;
  },
  handleAffiliationChangedMessage(stanza) {
    const item = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`x[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_USER}"] item`, stanza).pop();
    if (item) {
      const from = stanza.getAttribute('from');
      const type = stanza.getAttribute('type');
      const affiliation = item.getAttribute('affiliation');
      const jid = item.getAttribute('jid');
      const data = {
        from,
        type,
        affiliation,
        'states': [],
        'show': type == 'unavailable' ? 'offline' : 'online',
        'role': item.getAttribute('role'),
        'jid': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(jid),
        'resource': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getResourceFromJid(jid)
      };
      const occupant = this.occupants.findOccupant({
        'jid': data.jid
      });
      if (occupant) {
        occupant.save(data);
      } else {
        this.occupants.create(data);
      }
    }
  },
  async handleErrorMessageStanza(stanza) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    const attrs = await (0,_parsers_js__WEBPACK_IMPORTED_MODULE_13__.parseMUCMessage)(stanza, this, _core_js__WEBPACK_IMPORTED_MODULE_6__._converse);
    if (!(await this.shouldShowErrorMessage(attrs))) {
      return;
    }
    const message = this.getMessageReferencedByError(attrs);
    if (message) {
      const new_attrs = {
        'error': attrs.error,
        'error_condition': attrs.error_condition,
        'error_text': attrs.error_text,
        'error_type': attrs.error_type,
        'editable': false
      };
      if (attrs.msgid === message.get('retraction_id')) {
        // The error message refers to a retraction
        new_attrs.retracted = undefined;
        new_attrs.retraction_id = undefined;
        new_attrs.retracted_id = undefined;
        if (!attrs.error) {
          if (attrs.error_condition === 'forbidden') {
            new_attrs.error = __("You're not allowed to retract your message.");
          } else if (attrs.error_condition === 'not-acceptable') {
            new_attrs.error = __("Your retraction was not delivered because you're not present in the groupchat.");
          } else {
            new_attrs.error = __('Sorry, an error occurred while trying to retract your message.');
          }
        }
      } else if (!attrs.error) {
        if (attrs.error_condition === 'forbidden') {
          new_attrs.error = __("Your message was not delivered because you weren't allowed to send it.");
        } else if (attrs.error_condition === 'not-acceptable') {
          new_attrs.error = __("Your message was not delivered because you're not present in the groupchat.");
        } else {
          new_attrs.error = __('Sorry, an error occurred while trying to send your message.');
        }
      }
      message.save(new_attrs);
    } else {
      this.createMessage(attrs);
    }
  },
  /**
   * Handles incoming message stanzas from the service that hosts this MUC
   * @private
   * @method _converse.ChatRoom#handleMessageFromMUCHost
   * @param { XMLElement } stanza
   */
  handleMessageFromMUCHost(stanza) {
    if (this.isEntered()) {
      // We're not interested in activity indicators when already joined to the room
      return;
    }
    const rai = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`rai[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.RAI}"]`, stanza).pop();
    const active_mucs = Array.from((rai === null || rai === void 0 ? void 0 : rai.querySelectorAll('activity')) || []).map(m => m.textContent);
    if (active_mucs.includes(this.get('jid'))) {
      this.save({
        'has_activity': true,
        'num_unread_general': 0 // Either/or between activity and unreads
      });
    }
  },

  /**
   * Handles XEP-0452 MUC Mention Notification messages
   * @private
   * @method _converse.ChatRoom#handleForwardedMentions
   * @param { XMLElement } stanza
   */
  handleForwardedMentions(stanza) {
    if (this.isEntered()) {
      // Avoid counting mentions twice
      return;
    }
    const msgs = sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`mentions[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MENTIONS}"] forwarded[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.FORWARD}"] message[type="groupchat"]`, stanza);
    const muc_jid = this.get('jid');
    const mentions = msgs.filter(m => strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(m.getAttribute('from')) === muc_jid);
    if (mentions.length) {
      this.save({
        'has_activity': true,
        'num_unread': this.get('num_unread') + mentions.length
      });
      mentions.forEach(async stanza => {
        const attrs = await (0,_parsers_js__WEBPACK_IMPORTED_MODULE_13__.parseMUCMessage)(stanza, this, _core_js__WEBPACK_IMPORTED_MODULE_6__._converse);
        const data = {
          stanza,
          attrs,
          'chatbox': this
        };
        _core_js__WEBPACK_IMPORTED_MODULE_6__.api.trigger('message', data);
      });
    }
  },
  /**
   * Parses an incoming message stanza and queues it for processing.
   * @private
   * @method _converse.ChatRoom#handleMessageStanza
   * @param { XMLElement } stanza
   */
  async handleMessageStanza(stanza) {
    const type = stanza.getAttribute('type');
    if (type === 'error') {
      return this.handleErrorMessageStanza(stanza);
    }
    if (type === 'groupchat') {
      if ((0,_converse_headless_shared_parsers_js__WEBPACK_IMPORTED_MODULE_11__.isArchived)(stanza)) {
        // MAM messages are handled in converse-mam.
        // We shouldn't get MAM messages here because
        // they shouldn't have a `type` attribute.
        return _log__WEBPACK_IMPORTED_MODULE_0__["default"].warn(`Received a MAM message with type "groupchat"`);
      }
      this.createInfoMessages(stanza);
      this.fetchFeaturesIfConfigurationChanged(stanza);
    } else if (!type) {
      return this.handleForwardedMentions(stanza);
    }
    /**
     * @typedef { Object } MUCMessageData
     * An object containing the parsed {@link MUCMessageAttributes} and
     * current {@link ChatRoom}.
     * @property { MUCMessageAttributes } attrs
     * @property { ChatRoom } chatbox
     */
    let attrs;
    try {
      attrs = await (0,_parsers_js__WEBPACK_IMPORTED_MODULE_13__.parseMUCMessage)(stanza, this, _core_js__WEBPACK_IMPORTED_MODULE_6__._converse);
    } catch (e) {
      return _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
    }
    const data = {
      stanza,
      attrs,
      'chatbox': this
    };
    /**
     * Triggered when a groupchat message stanza has been received and parsed.
     * @event _converse#message
     * @type { object }
     * @property { module:converse-muc~MUCMessageData } data
     */
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.trigger('message', data);
    return attrs && this.queueMessage(attrs);
  },
  /**
   * Register presence and message handlers relevant to this groupchat
   * @private
   * @method _converse.ChatRoom#registerHandlers
   */
  registerHandlers() {
    const muc_jid = this.get('jid');
    const muc_domain = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getDomainFromJid(muc_jid);
    this.removeHandlers();
    this.presence_handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => this.onPresence(stanza) || true, null, 'presence', null, null, muc_jid, {
      'ignoreNamespaceFragment': true,
      'matchBareFromJid': true
    });
    this.domain_presence_handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => this.onPresenceFromMUCHost(stanza) || true, null, 'presence', null, null, muc_domain);
    this.message_handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => !!this.handleMessageStanza(stanza) || true, null, 'message', null, null, muc_jid, {
      'matchBareFromJid': true
    });
    this.domain_message_handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => this.handleMessageFromMUCHost(stanza) || true, null, 'message', null, null, muc_domain);
    this.affiliation_message_handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => this.handleAffiliationChangedMessage(stanza) || true, strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_USER, 'message', null, null, muc_jid);
  },
  removeHandlers() {
    // Remove the presence and message handlers that were
    // registered for this groupchat.
    if (this.message_handler) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(this.message_handler);
      delete this.message_handler;
    }
    if (this.domain_message_handler) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(this.domain_message_handler);
      delete this.domain_message_handler;
    }
    if (this.presence_handler) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(this.presence_handler);
      delete this.presence_handler;
    }
    if (this.domain_presence_handler) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(this.domain_presence_handler);
      delete this.domain_presence_handler;
    }
    if (this.affiliation_message_handler) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(this.affiliation_message_handler);
      delete this.affiliation_message_handler;
    }
    return this;
  },
  invitesAllowed() {
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('allow_muc_invitations') && (this.features.get('open') || this.getOwnAffiliation() === 'owner');
  },
  getDisplayName() {
    const name = this.get('name');
    if (name) {
      return name;
    } else if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('locked_muc_domain') === 'hidden') {
      return strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getNodeFromJid(this.get('jid'));
    } else {
      return this.get('jid');
    }
  },
  /**
   * Sends a message stanza to the XMPP server and expects a reflection
   * or error message within a specific timeout period.
   * @private
   * @method _converse.ChatRoom#sendTimedMessage
   * @param { _converse.Message|XMLElement } message
   * @returns { Promise<XMLElement>|Promise<_converse.TimeoutError> } Returns a promise
   *  which resolves with the reflected message stanza or with an error stanza or {@link _converse.TimeoutError}.
   */
  sendTimedMessage(el) {
    if (typeof el.tree === 'function') {
      el = el.tree();
    }
    let id = el.getAttribute('id');
    if (!id) {
      // inject id if not found
      id = this.getUniqueId('sendIQ');
      el.setAttribute('id', id);
    }
    const promise = (0,_converse_openpromise__WEBPACK_IMPORTED_MODULE_9__.getOpenPromise)();
    const timeoutHandler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addTimedHandler(_core_js__WEBPACK_IMPORTED_MODULE_6__._converse.STANZA_TIMEOUT, () => {
      _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteHandler(handler);
      const err = new _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.TimeoutError('Timeout Error: No response from server');
      promise.resolve(err);
      return false;
    });
    const handler = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.addHandler(stanza => {
      timeoutHandler && _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.deleteTimedHandler(timeoutHandler);
      promise.resolve(stanza);
    }, null, 'message', ['error', 'groupchat'], id);
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send(el);
    return promise;
  },
  /**
   * Retract one of your messages in this groupchat
   * @private
   * @method _converse.ChatRoom#retractOwnMessage
   * @param { _converse.Message } message - The message which we're retracting.
   */
  async retractOwnMessage(message) {
    const __ = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.__;
    const origin_id = message.get('origin_id');
    if (!origin_id) {
      throw new Error("Can't retract message without a XEP-0359 Origin ID");
    }
    const editable = message.get('editable');
    const stanza = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$msg)({
      'id': (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.getUniqueId)(),
      'to': this.get('jid'),
      'type': 'groupchat'
    }).c('store', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.HINTS
    }).up().c('apply-to', {
      'id': origin_id,
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.FASTEN
    }).c('retract', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.RETRACT
    });

    // Optimistic save
    message.set({
      'retracted': new Date().toISOString(),
      'retracted_id': origin_id,
      'retraction_id': stanza.nodeTree.getAttribute('id'),
      'editable': false
    });
    const result = await this.sendTimedMessage(stanza);
    if (_utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isErrorStanza(result)) {
      _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(result);
    } else if (result instanceof _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.TimeoutError) {
      _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(result);
      message.save({
        editable,
        'error_type': 'timeout',
        'error': __('A timeout happened while while trying to retract your message.'),
        'retracted': undefined,
        'retracted_id': undefined,
        'retraction_id': undefined
      });
    }
  },
  /**
   * Retract someone else's message in this groupchat.
   * @private
   * @method _converse.ChatRoom#retractOtherMessage
   * @param { _converse.Message } message - The message which we're retracting.
   * @param { string } [reason] - The reason for retracting the message.
   * @example
   *  const room = await api.rooms.get(jid);
   *  const message = room.messages.findWhere({'body': 'Get rich quick!'});
   *  room.retractOtherMessage(message, 'spam');
   */
  async retractOtherMessage(message, reason) {
    const editable = message.get('editable');
    // Optimistic save
    message.save({
      'moderated': 'retracted',
      'moderated_by': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid,
      'moderated_id': message.get('msgid'),
      'moderation_reason': reason,
      'editable': false
    });
    const result = await this.sendRetractionIQ(message, reason);
    if (result === null || _utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isErrorStanza(result)) {
      // Undo the save if something went wrong
      message.save({
        editable,
        'moderated': undefined,
        'moderated_by': undefined,
        'moderated_id': undefined,
        'moderation_reason': undefined
      });
    }
    return result;
  },
  /**
   * Sends an IQ stanza to the XMPP server to retract a message in this groupchat.
   * @private
   * @method _converse.ChatRoom#sendRetractionIQ
   * @param { _converse.Message } message - The message which we're retracting.
   * @param { string } [reason] - The reason for retracting the message.
   */
  sendRetractionIQ(message, reason) {
    const iq = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'type': 'set'
    }).c('apply-to', {
      'id': message.get(`stanza_id ${this.get('jid')}`),
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.FASTEN
    }).c('moderate', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MODERATE
    }).c('retract', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.RETRACT
    }).up().c('reason').t(reason || '');
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(iq, null, false);
  },
  /**
   * Sends an IQ stanza to the XMPP server to destroy this groupchat. Not
   * to be confused with the {@link _converse.ChatRoom#destroy}
   * method, which simply removes the room from the local browser storage cache.
   * @private
   * @method _converse.ChatRoom#sendDestroyIQ
   * @param { string } [reason] - The reason for destroying the groupchat.
   * @param { string } [new_jid] - The JID of the new groupchat which replaces this one.
   */
  sendDestroyIQ(reason, new_jid) {
    const destroy = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$build)('destroy');
    if (new_jid) {
      destroy.attrs({
        'jid': new_jid
      });
    }
    const iq = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'type': 'set'
    }).c('query', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_OWNER
    }).cnode(destroy.node);
    if (reason && reason.length > 0) {
      iq.c('reason', reason);
    }
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(iq);
  },
  /**
   * Leave the groupchat.
   * @private
   * @method _converse.ChatRoom#leave
   * @param { string } [exit_msg] - Message to indicate your reason for leaving
   */
  async leave(exit_msg) {
    var _converse$disco_entit;
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.connection.connected() && _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.presence.send('unavailable', this.getRoomJIDAndNick(), exit_msg);

    // Delete the features model
    if (this.features) {
      await new Promise(resolve => this.features.destroy({
        'success': resolve,
        'error': (_, e) => {
          _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
          resolve();
        }
      }));
    }
    // Delete disco entity
    const disco_entity = (_converse$disco_entit = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.disco_entities) === null || _converse$disco_entit === void 0 ? void 0 : _converse$disco_entit.get(this.get('jid'));
    if (disco_entity) {
      await new Promise(resolve => disco_entity.destroy({
        'success': resolve,
        'error': (_, e) => {
          _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
          resolve();
        }
      }));
    }
    (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.safeSave)(this.session, {
      'connection_status': _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.DISCONNECTED
    });
  },
  async close(ev) {
    const {
      ENTERED,
      CLOSING
    } = _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS;
    const was_entered = this.session.get('connection_status') === ENTERED;
    (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.safeSave)(this.session, {
      'connection_status': CLOSING
    });
    was_entered && this.sendMarkerForLastMessage('received', true);
    await this.unregisterNickname();
    await this.leave();
    this.occupants.clearStore();
    if ((ev === null || ev === void 0 ? void 0 : ev.name) !== 'closeAllChatBoxes' && _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_clear_messages_on_leave')) {
      this.clearMessages();
    }

    // Delete the session model
    await new Promise(resolve => this.session.destroy({
      'success': resolve,
      'error': (_, e) => {
        _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
        resolve();
      }
    }));
    return _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.ChatBox.prototype.close.call(this);
  },
  canModerateMessages() {
    const self = this.getOwnOccupant();
    return self && self.isModerator() && _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.supports(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MODERATE, this.get('jid'));
  },
  /**
   * Return an array of unique nicknames based on all occupants and messages in this MUC.
   * @private
   * @method _converse.ChatRoom#getAllKnownNicknames
   * @returns { String[] }
   */
  getAllKnownNicknames() {
    return [...new Set([...this.occupants.map(o => o.get('nick')), ...this.messages.map(m => m.get('nick'))])].filter(n => n);
  },
  getAllKnownNicknamesRegex() {
    const longNickString = this.getAllKnownNicknames().map(n => _utils_parse_helpers__WEBPACK_IMPORTED_MODULE_1__["default"].escapeRegexString(n)).join('|');
    return RegExp(`(?:\\p{P}|\\p{Z}|^)@(${longNickString})(?![\\w@-])`, 'uig');
  },
  getOccupantByJID(jid) {
    return this.occupants.findOccupant({
      jid
    });
  },
  getOccupantByNickname(nick) {
    return this.occupants.findOccupant({
      nick
    });
  },
  getReferenceURIFromNickname(nickname) {
    const muc_jid = this.get('jid');
    const occupant = this.getOccupant(nickname);
    const uri = this.features.get('nonanonymous') && (occupant === null || occupant === void 0 ? void 0 : occupant.get('jid')) || `${muc_jid}/${nickname}`;
    return encodeURI(`xmpp:${uri}`);
  },
  /**
   * Given a text message, look for `@` mentions and turn them into
   * XEP-0372 references
   * @param { String } text
   */
  parseTextForReferences(text) {
    const mentions_regex = /(\p{P}|\p{Z}|^)([@][\w_-]+(?:\.\w+)*)/giu;
    if (!text || !mentions_regex.test(text)) {
      return [text, []];
    }
    const getMatchingNickname = _utils_parse_helpers__WEBPACK_IMPORTED_MODULE_1__["default"].findFirstMatchInArray(this.getAllKnownNicknames());
    const matchToReference = match => {
      let at_sign_index = match[0].indexOf('@');
      if (match[0][at_sign_index + 1] === '@') {
        // edge-case
        at_sign_index += 1;
      }
      const begin = match.index + at_sign_index;
      const end = begin + match[0].length - at_sign_index;
      const value = getMatchingNickname(match[1]);
      const type = 'mention';
      const uri = this.getReferenceURIFromNickname(value);
      return {
        begin,
        end,
        value,
        type,
        uri
      };
    };
    const regex = this.getAllKnownNicknamesRegex();
    const mentions = [...text.matchAll(regex)].filter(m => !m[0].startsWith('/'));
    const references = mentions.map(matchToReference);
    const [updated_message, updated_references] = _utils_parse_helpers__WEBPACK_IMPORTED_MODULE_1__["default"].reduceTextFromReferences(text, references);
    return [updated_message, updated_references];
  },
  async getOutgoingMessageAttributes(attrs) {
    var _attrs;
    await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.emojis.initialize();
    const is_spoiler = this.get('composing_spoiler');
    let text = '',
      references;
    if ((_attrs = attrs) !== null && _attrs !== void 0 && _attrs.body) {
      [text, references] = this.parseTextForReferences(attrs.body);
    }
    const origin_id = (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.getUniqueId)();
    const body = text ? _utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].shortnamesToUnicode(text) : undefined;
    attrs = Object.assign({}, attrs, {
      body,
      is_spoiler,
      origin_id,
      references,
      'id': origin_id,
      'msgid': origin_id,
      'from': `${this.get('jid')}/${this.get('nick')}`,
      'fullname': this.get('nick'),
      'is_only_emojis': text ? _utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isOnlyEmojis(text) : false,
      'message': body,
      'nick': this.get('nick'),
      'sender': 'me',
      'type': 'groupchat'
    }, (0,_converse_headless_shared_parsers_js__WEBPACK_IMPORTED_MODULE_11__.getMediaURLsMetadata)(text));

    /**
     * *Hook* which allows plugins to update the attributes of an outgoing
     * message.
     * @event _converse#getOutgoingMessageAttributes
     */
    attrs = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.hook('getOutgoingMessageAttributes', this, attrs);
    return attrs;
  },
  /**
   * Utility method to construct the JID for the current user as occupant of the groupchat.
   * @private
   * @method _converse.ChatRoom#getRoomJIDAndNick
   * @returns {string} - The groupchat JID with the user's nickname added at the end.
   * @example groupchat@conference.example.org/nickname
   */
  getRoomJIDAndNick() {
    const nick = this.get('nick');
    const jid = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(this.get('jid'));
    return jid + (nick !== null ? `/${nick}` : '');
  },
  /**
   * Sends a message with the current XEP-0085 chat state of the user
   * as taken from the `chat_state` attribute of the {@link _converse.ChatRoom}.
   * @private
   * @method _converse.ChatRoom#sendChatState
   */
  sendChatState() {
    if (!_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('send_chat_state_notifications') || !this.get('chat_state') || !this.isEntered() || this.features.get('moderated') && this.getOwnRole() === 'visitor') {
      return;
    }
    const allowed = _core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('send_chat_state_notifications');
    if (Array.isArray(allowed) && !allowed.includes(this.get('chat_state'))) {
      return;
    }
    const chat_state = this.get('chat_state');
    if (chat_state === _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.GONE) {
      // <gone/> is not applicable within MUC context
      return;
    }
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$msg)({
      'to': this.get('jid'),
      'type': 'groupchat'
    }).c(chat_state, {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.CHATSTATES
    }).up().c('no-store', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.HINTS
    }).up().c('no-permanent-store', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.HINTS
    }));
  },
  /**
   * Send a direct invitation as per XEP-0249
   * @private
   * @method _converse.ChatRoom#directInvite
   * @param { String } recipient - JID of the person being invited
   * @param { String } [reason] - Reason for the invitation
   */
  directInvite(recipient, reason) {
    if (this.features.get('membersonly')) {
      // When inviting to a members-only groupchat, we first add
      // the person to the member list by giving them an
      // affiliation of 'member' otherwise they won't be able to join.
      this.updateMemberLists([{
        'jid': recipient,
        'affiliation': 'member',
        'reason': reason
      }]);
    }
    const attrs = {
      'xmlns': 'jabber:x:conference',
      'jid': this.get('jid')
    };
    if (reason !== null) {
      attrs.reason = reason;
    }
    if (this.get('password')) {
      attrs.password = this.get('password');
    }
    const invitation = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$msg)({
      'from': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.jid,
      'to': recipient,
      'id': (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.getUniqueId)()
    }).c('x', attrs);
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send(invitation);
    /**
     * After the user has sent out a direct invitation (as per XEP-0249),
     * to a roster contact, asking them to join a room.
     * @event _converse#chatBoxMaximized
     * @type {object}
     * @property {_converse.ChatRoom} room
     * @property {string} recipient - The JID of the person being invited
     * @property {string} reason - The original reason for the invitation
     * @example _converse.api.listen.on('chatBoxMaximized', view => { ... });
     */
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.trigger('roomInviteSent', {
      'room': this,
      'recipient': recipient,
      'reason': reason
    });
  },
  /**
   * Refresh the disco identity, features and fields for this {@link _converse.ChatRoom}.
   * *features* are stored on the features {@link Model} attribute on this {@link _converse.ChatRoom}.
   * *fields* are stored on the config {@link Model} attribute on this {@link _converse.ChatRoom}.
   * @private
   * @returns {Promise}
   */
  refreshDiscoInfo() {
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.refresh(this.get('jid')).then(() => this.getDiscoInfo()).catch(e => _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e));
  },
  /**
   * Fetch the *extended* MUC info from the server and cache it locally
   * https://xmpp.org/extensions/xep-0045.html#disco-roominfo
   * @private
   * @method _converse.ChatRoom#getDiscoInfo
   * @returns {Promise}
   */
  getDiscoInfo() {
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.getIdentity('conference', 'text', this.get('jid')).then(identity => this.save({
      'name': identity === null || identity === void 0 ? void 0 : identity.get('name')
    })).then(() => this.getDiscoInfoFields()).then(() => this.getDiscoInfoFeatures()).catch(e => _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e));
  },
  /**
   * Fetch the *extended* MUC info fields from the server and store them locally
   * in the `config` {@link Model} attribute.
   * See: https://xmpp.org/extensions/xep-0045.html#disco-roominfo
   * @private
   * @method _converse.ChatRoom#getDiscoInfoFields
   * @returns {Promise}
   */
  async getDiscoInfoFields() {
    const fields = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.getFields(this.get('jid'));
    const config = fields.reduce((config, f) => {
      const name = f.get('var');
      if (name !== null && name !== void 0 && name.startsWith('muc#roominfo_')) {
        config[name.replace('muc#roominfo_', '')] = f.get('value');
      }
      return config;
    }, {});
    this.config.save(config);
  },
  /**
   * Use converse-disco to populate the features {@link Model} which
   * is stored as an attibute on this {@link _converse.ChatRoom}.
   * The results may be cached. If you want to force fetching the features from the
   * server, call {@link _converse.ChatRoom#refreshDiscoInfo} instead.
   * @private
   * @returns {Promise}
   */
  async getDiscoInfoFeatures() {
    const features = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.getFeatures(this.get('jid'));
    const attrs = _core_js__WEBPACK_IMPORTED_MODULE_6__.converse.ROOM_FEATURES.reduce((acc, feature) => {
      acc[feature] = false;
      return acc;
    }, {
      'fetched': new Date().toISOString()
    });
    features.each(feature => {
      const fieldname = feature.get('var');
      if (!fieldname.startsWith('muc_')) {
        if (fieldname === strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MAM) {
          attrs.mam_enabled = true;
        } else {
          attrs[fieldname] = true;
        }
        return;
      }
      attrs[fieldname.replace('muc_', '')] = true;
    });
    this.features.save(attrs);
  },
  /**
   * Given a <field> element, return a copy with a <value> child if
   * we can find a value for it in this rooms config.
   * @private
   * @method _converse.ChatRoom#addFieldValue
   * @returns { Element }
   */
  addFieldValue(field) {
    const type = field.getAttribute('type');
    if (type === 'fixed') {
      return field;
    }
    const fieldname = field.getAttribute('var').replace('muc#roomconfig_', '');
    const config = this.get('roomconfig');
    if (fieldname in config) {
      let values;
      switch (type) {
        case 'boolean':
          values = [config[fieldname] ? 1 : 0];
          break;
        case 'list-multi':
          values = config[fieldname];
          break;
        default:
          values = [config[fieldname]];
      }
      field.innerHTML = values.map(v => (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$build)('value').t(v)).join('');
    }
    return field;
  },
  /**
   * Automatically configure the groupchat based on this model's
   * 'roomconfig' data.
   * @private
   * @method _converse.ChatRoom#autoConfigureChatRoom
   * @returns { Promise<XMLElement> }
   * Returns a promise which resolves once a response IQ has
   * been received.
   */
  async autoConfigureChatRoom() {
    const stanza = await this.fetchRoomConfiguration();
    const fields = sizzle__WEBPACK_IMPORTED_MODULE_2___default()('field', stanza);
    const configArray = fields.map(f => this.addFieldValue(f));
    if (configArray.length) {
      return this.sendConfiguration(configArray);
    }
  },
  /**
   * Send an IQ stanza to fetch the groupchat configuration data.
   * Returns a promise which resolves once the response IQ
   * has been received.
   * @private
   * @method _converse.ChatRoom#fetchRoomConfiguration
   * @returns { Promise<XMLElement> }
   */
  fetchRoomConfiguration() {
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'type': 'get'
    }).c('query', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_OWNER
    }));
  },
  /**
   * Sends an IQ stanza with the groupchat configuration.
   * @private
   * @method _converse.ChatRoom#sendConfiguration
   * @param { Array } config - The groupchat configuration
   * @returns { Promise<XMLElement> } - A promise which resolves with
   * the `result` stanza received from the XMPP server.
   */
  sendConfiguration() {
    let config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    const iq = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      to: this.get('jid'),
      type: 'set'
    }).c('query', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_OWNER
    }).c('x', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.XFORM,
      type: 'submit'
    });
    config.forEach(node => iq.cnode(node).up());
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(iq);
  },
  onCommandError(err) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    _log__WEBPACK_IMPORTED_MODULE_0__["default"].fatal(err);
    const message = __('Sorry, an error happened while running the command.') + ' ' + __("Check your browser's developer console for details.");
    this.createMessage({
      message,
      'type': 'error'
    });
  },
  getNickOrJIDFromCommandArgs(args) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    if (_utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isValidJID(args.trim())) {
      return args.trim();
    }
    if (!args.startsWith('@')) {
      args = '@' + args;
    }
    const [_text, references] = this.parseTextForReferences(args); // eslint-disable-line no-unused-vars
    if (!references.length) {
      const message = __("Error: couldn't find a groupchat participant based on your arguments");
      this.createMessage({
        message,
        'type': 'error'
      });
      return;
    }
    if (references.length > 1) {
      const message = __('Error: found multiple groupchat participant based on your arguments');
      this.createMessage({
        message,
        'type': 'error'
      });
      return;
    }
    const nick_or_jid = references.pop().value;
    const reason = args.split(nick_or_jid, 2)[1];
    if (reason && !reason.startsWith(' ')) {
      const message = __("Error: couldn't find a groupchat participant based on your arguments");
      this.createMessage({
        message,
        'type': 'error'
      });
      return;
    }
    return nick_or_jid;
  },
  validateRoleOrAffiliationChangeArgs(command, args) {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    if (!args) {
      const message = __('Error: the "%1$s" command takes two arguments, the user\'s nickname and optionally a reason.', command);
      this.createMessage({
        message,
        'type': 'error'
      });
      return false;
    }
    return true;
  },
  getAllowedCommands() {
    let allowed_commands = ['clear', 'help', 'me', 'nick', 'register'];
    if (this.config.get('changesubject') || ['owner', 'admin'].includes(this.getOwnAffiliation())) {
      allowed_commands = [...allowed_commands, ...['subject', 'topic']];
    }
    const occupant = this.occupants.findWhere({
      'jid': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid
    });
    if (this.verifyAffiliations(['owner'], occupant, false)) {
      allowed_commands = allowed_commands.concat(OWNER_COMMANDS).concat(ADMIN_COMMANDS);
    } else if (this.verifyAffiliations(['admin'], occupant, false)) {
      allowed_commands = allowed_commands.concat(ADMIN_COMMANDS);
    }
    if (this.verifyRoles(['moderator'], occupant, false)) {
      allowed_commands = allowed_commands.concat(MODERATOR_COMMANDS).concat(VISITOR_COMMANDS);
    } else if (!this.verifyRoles(['visitor', 'participant', 'moderator'], occupant, false)) {
      allowed_commands = allowed_commands.concat(VISITOR_COMMANDS);
    }
    allowed_commands.sort();
    if (Array.isArray(_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_disable_slash_commands'))) {
      return allowed_commands.filter(c => !_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('muc_disable_slash_commands').includes(c));
    } else {
      return allowed_commands;
    }
  },
  verifyAffiliations(affiliations, occupant) {
    let show_error = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    if (!Array.isArray(affiliations)) {
      throw new TypeError('affiliations must be an Array');
    }
    if (!affiliations.length) {
      return true;
    }
    occupant = occupant || this.occupants.findWhere({
      'jid': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid
    });
    if (occupant) {
      const a = occupant.get('affiliation');
      if (affiliations.includes(a)) {
        return true;
      }
    }
    if (show_error) {
      const message = __('Forbidden: you do not have the necessary affiliation in order to do that.');
      this.createMessage({
        message,
        'type': 'error'
      });
    }
    return false;
  },
  verifyRoles(roles, occupant) {
    let show_error = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    if (!Array.isArray(roles)) {
      throw new TypeError('roles must be an Array');
    }
    if (!roles.length) {
      return true;
    }
    occupant = occupant || this.occupants.findWhere({
      'jid': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.bare_jid
    });
    if (occupant) {
      const role = occupant.get('role');
      if (roles.includes(role)) {
        return true;
      }
    }
    if (show_error) {
      const message = __('Forbidden: you do not have the necessary role in order to do that.');
      this.createMessage({
        message,
        'type': 'error',
        'is_ephemeral': 20000
      });
    }
    return false;
  },
  /**
   * Returns the `role` which the current user has in this MUC
   * @private
   * @method _converse.ChatRoom#getOwnRole
   * @returns { ('none'|'visitor'|'participant'|'moderator') }
   */
  getOwnRole() {
    var _this$getOwnOccupant, _this$getOwnOccupant$;
    return (_this$getOwnOccupant = this.getOwnOccupant()) === null || _this$getOwnOccupant === void 0 ? void 0 : (_this$getOwnOccupant$ = _this$getOwnOccupant.attributes) === null || _this$getOwnOccupant$ === void 0 ? void 0 : _this$getOwnOccupant$.role;
  },
  /**
   * Returns the `affiliation` which the current user has in this MUC
   * @private
   * @method _converse.ChatRoom#getOwnAffiliation
   * @returns { ('none'|'outcast'|'member'|'admin'|'owner') }
   */
  getOwnAffiliation() {
    var _this$getOwnOccupant2, _this$getOwnOccupant3;
    return ((_this$getOwnOccupant2 = this.getOwnOccupant()) === null || _this$getOwnOccupant2 === void 0 ? void 0 : (_this$getOwnOccupant3 = _this$getOwnOccupant2.attributes) === null || _this$getOwnOccupant3 === void 0 ? void 0 : _this$getOwnOccupant3.affiliation) || 'none';
  },
  /**
   * Get the {@link _converse.ChatRoomOccupant} instance which
   * represents the current user.
   * @method _converse.ChatRoom#getOwnOccupant
   * @returns { _converse.ChatRoomOccupant }
   */
  getOwnOccupant() {
    return this.occupants.getOwnOccupant();
  },
  /**
   * Send a presence stanza to update the user's nickname in this MUC.
   * @param { String } nick
   */
  async setNickname(nick) {
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('auto_register_muc_nickname') && (await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.supports(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER, this.get('jid')))) {
      const old_nick = this.get('nick');
      this.set({
        nick
      });
      try {
        await this.registerNickname();
      } catch (e) {
        const {
          __
        } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
        _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
        const message = __("Error: couldn't register new nickname in members only room");
        this.createMessage({
          message,
          'type': 'error',
          'is_ephemeral': true
        });
        this.set({
          'nick': old_nick
        });
        return;
      }
    }
    const jid = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(this.get('jid'));
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$pres)({
      'from': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.jid,
      'to': `${jid}/${nick}`,
      'id': (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.getUniqueId)()
    }).tree());
  },
  /**
   * Send an IQ stanza to modify an occupant's role
   * @private
   * @method _converse.ChatRoom#setRole
   * @param { _converse.ChatRoomOccupant } occupant
   * @param { String } role
   * @param { String } reason
   * @param { function } onSuccess - callback for a succesful response
   * @param { function } onError - callback for an error response
   */
  setRole(occupant, role, reason, onSuccess, onError) {
    const item = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$build)('item', {
      'nick': occupant.get('nick'),
      role
    });
    const iq = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'type': 'set'
    }).c('query', {
      xmlns: strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_ADMIN
    }).cnode(item.node);
    if (reason !== null) {
      iq.c('reason', reason);
    }
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(iq).then(onSuccess).catch(onError);
  },
  /**
   * @private
   * @method _converse.ChatRoom#getOccupant
   * @param { String } nickname_or_jid - The nickname or JID of the occupant to be returned
   * @returns { _converse.ChatRoomOccupant }
   */
  getOccupant(nickname_or_jid) {
    return _utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isValidJID(nickname_or_jid) ? this.getOccupantByJID(nickname_or_jid) : this.getOccupantByNickname(nickname_or_jid);
  },
  /**
   * Return an array of occupant models that have the required role
   * @private
   * @method _converse.ChatRoom#getOccupantsWithRole
   * @param { String } role
   * @returns { _converse.ChatRoomOccupant[] }
   */
  getOccupantsWithRole(role) {
    return this.getOccupantsSortedBy('nick').filter(o => o.get('role') === role).map(item => {
      return {
        'jid': item.get('jid'),
        'nick': item.get('nick'),
        'role': item.get('role')
      };
    });
  },
  /**
   * Return an array of occupant models that have the required affiliation
   * @private
   * @method _converse.ChatRoom#getOccupantsWithAffiliation
   * @param { String } affiliation
   * @returns { _converse.ChatRoomOccupant[] }
   */
  getOccupantsWithAffiliation(affiliation) {
    return this.getOccupantsSortedBy('nick').filter(o => o.get('affiliation') === affiliation).map(item => {
      return {
        'jid': item.get('jid'),
        'nick': item.get('nick'),
        'affiliation': item.get('affiliation')
      };
    });
  },
  /**
   * Return an array of occupant models, sorted according to the passed-in attribute.
   * @private
   * @method _converse.ChatRoom#getOccupantsSortedBy
   * @param { String } attr - The attribute to sort the returned array by
   * @returns { _converse.ChatRoomOccupant[] }
   */
  getOccupantsSortedBy(attr) {
    return Array.from(this.occupants.models).sort((a, b) => a.get(attr) < b.get(attr) ? -1 : a.get(attr) > b.get(attr) ? 1 : 0);
  },
  /**
   * Fetch the lists of users with the given affiliations.
   * Then compute the delta between those users and
   * the passed in members, and if it exists, send the delta
   * to the XMPP server to update the member list.
   * @private
   * @method _converse.ChatRoom#updateMemberLists
   * @param { object } members - Map of member jids and affiliations.
   * @returns { Promise }
   *  A promise which is resolved once the list has been
   *  updated or once it's been established there's no need
   *  to update the list.
   */
  async updateMemberLists(members) {
    const muc_jid = this.get('jid');
    const all_affiliations = ['member', 'admin', 'owner'];
    const aff_lists = await Promise.all(all_affiliations.map(a => (0,_affiliations_utils_js__WEBPACK_IMPORTED_MODULE_7__.getAffiliationList)(a, muc_jid)));
    const old_members = aff_lists.reduce((acc, val) => _utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isErrorObject(val) ? acc : [...val, ...acc], []);
    await (0,_affiliations_utils_js__WEBPACK_IMPORTED_MODULE_7__.setAffiliations)(muc_jid, (0,_affiliations_utils_js__WEBPACK_IMPORTED_MODULE_7__.computeAffiliationsDelta)(true, false, members, old_members));
    await this.occupants.fetchMembers();
  },
  /**
   * Given a nick name, save it to the model state, otherwise, look
   * for a server-side reserved nickname or default configured
   * nickname and if found, persist that to the model state.
   * @private
   * @method _converse.ChatRoom#getAndPersistNickname
   * @returns { Promise<string> } A promise which resolves with the nickname
   */
  async getAndPersistNickname(nick) {
    nick = nick || this.get('nick') || (await this.getReservedNick()) || _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.getDefaultMUCNickname();
    if (nick) (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.safeSave)(this, {
      nick
    }, {
      'silent': true
    });
    return nick;
  },
  /**
   * Use service-discovery to ask the XMPP server whether
   * this user has a reserved nickname for this groupchat.
   * If so, we'll use that, otherwise we render the nickname form.
   * @private
   * @method _converse.ChatRoom#getReservedNick
   * @returns { Promise<string> } A promise which resolves with the reserved nick or null
   */
  async getReservedNick() {
    const stanza = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'from': _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.jid,
      'type': 'get'
    }).c('query', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.DISCO_INFO,
      'node': 'x-roomuser-item'
    });
    const result = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(stanza, null, false);
    if (_utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isErrorObject(result)) {
      throw result;
    }
    // Result might be undefined due to a timeout
    const identity_el = result === null || result === void 0 ? void 0 : result.querySelector('query[node="x-roomuser-item"] identity');
    return identity_el ? identity_el.getAttribute('name') : null;
  },
  /**
   * Send an IQ stanza to the MUC to register this user's nickname.
   * This sets the user's affiliation to 'member' (if they weren't affiliated
   * before) and reserves the nickname for this user, thereby preventing other
   * users from using it in this MUC.
   * See https://xmpp.org/extensions/xep-0045.html#register
   * @private
   * @method _converse.ChatRoom#registerNickname
   */
  async registerNickname() {
    const {
      __
    } = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse;
    const nick = this.get('nick');
    const jid = this.get('jid');
    let iq, err_msg;
    try {
      iq = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
        'to': jid,
        'type': 'get'
      }).c('query', {
        'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER
      }));
    } catch (e) {
      if (sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`not-allowed[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.STANZAS}"]`, e).length) {
        err_msg = __("You're not allowed to register yourself in this groupchat.");
      } else if (sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`registration-required[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.STANZAS}"]`, e).length) {
        err_msg = __("You're not allowed to register in this groupchat because it's members-only.");
      }
      _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
      return err_msg;
    }
    const required_fields = sizzle__WEBPACK_IMPORTED_MODULE_2___default()('field required', iq).map(f => f.parentElement);
    if (required_fields.length > 1 && required_fields[0].getAttribute('var') !== 'muc#register_roomnick') {
      return _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(`Can't register the user register in the groupchat ${jid} due to the required fields`);
    }
    try {
      await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
        'to': jid,
        'type': 'set'
      }).c('query', {
        'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER
      }).c('x', {
        'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.XFORM,
        'type': 'submit'
      }).c('field', {
        'var': 'FORM_TYPE'
      }).c('value').t('http://jabber.org/protocol/muc#register').up().up().c('field', {
        'var': 'muc#register_roomnick'
      }).c('value').t(nick));
    } catch (e) {
      if (sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`service-unavailable[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.STANZAS}"]`, e).length) {
        err_msg = __("Can't register your nickname in this groupchat, it doesn't support registration.");
      } else if (sizzle__WEBPACK_IMPORTED_MODULE_2___default()(`bad-request[xmlns="${strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.STANZAS}"]`, e).length) {
        err_msg = __("Can't register your nickname in this groupchat, invalid data form supplied.");
      }
      _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(err_msg);
      _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
      return err_msg;
    }
  },
  /**
   * Check whether we should unregister the user from this MUC, and if so,
   * call { @link _converse.ChatRoom#sendUnregistrationIQ }
   * @method _converse.ChatRoom#unregisterNickname
   */
  async unregisterNickname() {
    if (_core_js__WEBPACK_IMPORTED_MODULE_6__.api.settings.get('auto_register_muc_nickname') === 'unregister') {
      try {
        if (await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.disco.supports(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER, this.get('jid'))) {
          await this.sendUnregistrationIQ();
        }
      } catch (e) {
        _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e);
      }
    }
  },
  /**
   * Send an IQ stanza to the MUC to unregister this user's nickname.
   * If the user had a 'member' affiliation, it'll be removed and their
   * nickname will no longer be reserved and can instead be used (and
   * registered) by other users.
   * @method _converse.ChatRoom#sendUnregistrationIQ
   */
  sendUnregistrationIQ() {
    const iq = (0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$iq)({
      'to': this.get('jid'),
      'type': 'set'
    }).c('query', {
      'xmlns': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.MUC_REGISTER
    }).c('remove');
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.sendIQ(iq).catch(e => _log__WEBPACK_IMPORTED_MODULE_0__["default"].error(e));
  },
  /**
   * Given a presence stanza, update the occupant model based on its contents.
   * @private
   * @method _converse.ChatRoom#updateOccupantsOnPresence
   * @param { XMLElement } pres - The presence stanza
   */
  updateOccupantsOnPresence(pres) {
    var _occupant$attributes, _occupant$attributes2;
    const data = (0,_parsers_js__WEBPACK_IMPORTED_MODULE_13__.parseMUCPresence)(pres, this);
    if (data.type === 'error' || !data.jid && !data.nick && !data.occupant_id) {
      return true;
    }
    const occupant = this.occupants.findOccupant(data);
    // Destroy an unavailable occupant if this isn't a nick change operation and if they're not affiliated
    if (data.type === 'unavailable' && occupant && !data.states.includes(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_NICK_CHANGED_CODE) && !['admin', 'owner', 'member'].includes(data['affiliation'])) {
      // Before destroying we set the new data, so that we can show the disconnection message
      occupant.set(data);
      occupant.destroy();
      return;
    }
    const jid = data.jid || '';
    const attributes = {
      ...data,
      'jid': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(jid) || (occupant === null || occupant === void 0 ? void 0 : (_occupant$attributes = occupant.attributes) === null || _occupant$attributes === void 0 ? void 0 : _occupant$attributes.jid),
      'resource': strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getResourceFromJid(jid) || (occupant === null || occupant === void 0 ? void 0 : (_occupant$attributes2 = occupant.attributes) === null || _occupant$attributes2 === void 0 ? void 0 : _occupant$attributes2.resource)
    };
    if (data.is_me) {
      let modified = false;
      if (data.states.includes(_core_js__WEBPACK_IMPORTED_MODULE_6__.converse.MUC_NICK_CHANGED_CODE)) {
        modified = true;
        this.set('nick', data.nick);
      }
      if (this.features.get(strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.NS.OCCUPANTID) && this.get('occupant-id') !== data.occupant_id) {
        modified = true;
        this.set('occupant_id', data.occupant_id);
      }
      modified && this.save();
    }
    if (occupant) {
      occupant.save(attributes);
    } else {
      this.occupants.create(attributes);
    }
  },
  fetchFeaturesIfConfigurationChanged(stanza) {
    // 104: configuration change
    // 170: logging enabled
    // 171: logging disabled
    // 172: room no longer anonymous
    // 173: room now semi-anonymous
    // 174: room now fully anonymous
    const codes = ['104', '170', '171', '172', '173', '174'];
    if (sizzle__WEBPACK_IMPORTED_MODULE_2___default()('status', stanza).filter(e => codes.includes(e.getAttribute('status'))).length) {
      this.refreshDiscoInfo();
    }
  },
  /**
   * Given two JIDs, which can be either user JIDs or MUC occupant JIDs,
   * determine whether they belong to the same user.
   * @private
   * @method _converse.ChatRoom#isSameUser
   * @param { String } jid1
   * @param { String } jid2
   * @returns { Boolean }
   */
  isSameUser(jid1, jid2) {
    const bare_jid1 = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(jid1);
    const bare_jid2 = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getBareJidFromJid(jid2);
    const resource1 = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getResourceFromJid(jid1);
    const resource2 = strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getResourceFromJid(jid2);
    if (_utils_form__WEBPACK_IMPORTED_MODULE_3__["default"].isSameBareJID(jid1, jid2)) {
      if (bare_jid1 === this.get('jid')) {
        // MUC JIDs
        return resource1 === resource2;
      } else {
        return true;
      }
    } else {
      const occupant1 = bare_jid1 === this.get('jid') ? this.occupants.findOccupant({
        'nick': resource1
      }) : this.occupants.findOccupant({
        'jid': bare_jid1
      });
      const occupant2 = bare_jid2 === this.get('jid') ? this.occupants.findOccupant({
        'nick': resource2
      }) : this.occupants.findOccupant({
        'jid': bare_jid2
      });
      return occupant1 === occupant2;
    }
  },
  async isSubjectHidden() {
    const jids = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.settings.get('mucs_with_hidden_subject', []);
    return jids.includes(this.get('jid'));
  },
  async toggleSubjectHiddenState() {
    const muc_jid = this.get('jid');
    const jids = await _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.settings.get('mucs_with_hidden_subject', []);
    if (jids.includes(this.get('jid'))) {
      _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.settings.set('mucs_with_hidden_subject', jids.filter(jid => jid !== muc_jid));
    } else {
      _core_js__WEBPACK_IMPORTED_MODULE_6__.api.user.settings.set('mucs_with_hidden_subject', [...jids, muc_jid]);
    }
  },
  /**
   * Handle a possible subject change and return `true` if so.
   * @private
   * @method _converse.ChatRoom#handleSubjectChange
   * @param { object } attrs - Attributes representing a received
   *  message, as returned by {@link parseMUCMessage}
   */
  async handleSubjectChange(attrs) {
    const __ = _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.__;
    if (typeof attrs.subject === 'string' && !attrs.thread && !attrs.message) {
      // https://xmpp.org/extensions/xep-0045.html#subject-mod
      // -----------------------------------------------------
      // The subject is changed by sending a message of type "groupchat" to the <room@service>,
      // where the <message/> MUST contain a <subject/> element that specifies the new subject but
      // MUST NOT contain a <body/> element (or a <thread/> element).
      const subject = attrs.subject;
      const author = attrs.nick;
      (0,_converse_headless_utils_core_js__WEBPACK_IMPORTED_MODULE_12__.safeSave)(this, {
        'subject': {
          author,
          'text': attrs.subject || ''
        }
      });
      if (!attrs.is_delayed && author) {
        const message = subject ? __('Topic set by %1$s', author) : __('Topic cleared by %1$s', author);
        const prev_msg = this.messages.last();
        if ((prev_msg === null || prev_msg === void 0 ? void 0 : prev_msg.get('nick')) !== attrs.nick || (prev_msg === null || prev_msg === void 0 ? void 0 : prev_msg.get('type')) !== 'info' || (prev_msg === null || prev_msg === void 0 ? void 0 : prev_msg.get('message')) !== message) {
          this.createMessage({
            message,
            'nick': attrs.nick,
            'type': 'info',
            'is_ephemeral': true
          });
        }
        if (await this.isSubjectHidden()) {
          this.toggleSubjectHiddenState();
        }
      }
      return true;
    }
    return false;
  },
  /**
   * Set the subject for this {@link _converse.ChatRoom}
   * @private
   * @method _converse.ChatRoom#setSubject
   * @param { String } value
   */
  setSubject() {
    let value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send((0,strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.$msg)({
      to: this.get('jid'),
      from: _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.connection.jid,
      type: 'groupchat'
    }).c('subject', {
      xmlns: 'jabber:client'
    }).t(value).tree());
  },
  /**
   * Is this a chat state notification that can be ignored,
   * because it's old or because it's from us.
   * @private
   * @method _converse.ChatRoom#ignorableCSN
   * @param { Object } attrs - The message attributes
   */
  ignorableCSN(attrs) {
    return attrs.chat_state && !attrs.body && (attrs.is_delayed || this.isOwnMessage(attrs));
  },
  /**
   * Determines whether the message is from ourselves by checking
   * the `from` attribute. Doesn't check the `type` attribute.
   * @private
   * @method _converse.ChatRoom#isOwnMessage
   * @param { Object|XMLElement|_converse.Message } msg
   * @returns { boolean }
   */
  isOwnMessage(msg) {
    let from;
    if ((0,lodash_es_isElement__WEBPACK_IMPORTED_MODULE_17__["default"])(msg)) {
      from = msg.getAttribute('from');
    } else if (msg instanceof _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.Message) {
      from = msg.get('from');
    } else {
      from = msg.from;
    }
    return strophe_js_src_strophe__WEBPACK_IMPORTED_MODULE_5__.Strophe.getResourceFromJid(from) == this.get('nick');
  },
  getUpdatedMessageAttributes(message, attrs) {
    const new_attrs = {
      ..._core_js__WEBPACK_IMPORTED_MODULE_6__._converse.ChatBox.prototype.getUpdatedMessageAttributes.call(this, message, attrs),
      ...(0,lodash_es_pick__WEBPACK_IMPORTED_MODULE_18__["default"])(attrs, ['from_muc', 'occupant_id'])
    };
    if (this.isOwnMessage(attrs)) {
      const stanza_id_keys = Object.keys(attrs).filter(k => k.startsWith('stanza_id'));
      Object.assign(new_attrs, (0,lodash_es_pick__WEBPACK_IMPORTED_MODULE_18__["default"])(attrs, stanza_id_keys));
      if (!message.get('received')) {
        new_attrs.received = new Date().toISOString();
      }
    }
    return new_attrs;
  },
  /**
   * Send a MUC-0410 MUC Self-Ping stanza to room to determine
   * whether we're still joined.
   * @async
   * @private
   * @method _converse.ChatRoom#isJoined
   * @returns {Promise<boolean>}
   */
  async isJoined() {
    if (!_core_js__WEBPACK_IMPORTED_MODULE_6__.api.connection.connected()) {
      await new Promise(resolve => _core_js__WEBPACK_IMPORTED_MODULE_6__.api.listen.once('reconnected', resolve));
    }
    return _core_js__WEBPACK_IMPORTED_MODULE_6__.api.ping(`${this.get('jid')}/${this.get('nick')}`);
  },
  /**
   * Sends a status update presence (i.e. based on the `<show>` element)
   * @method _converse.ChatRoom#sendStatusPresence
   * @param { String } type
   * @param { String } [status] - An optional status message
   * @param { Element[]|Strophe.Builder[]|Element|Strophe.Builder } [child_nodes]
   *  Nodes(s) to be added as child nodes of the `presence` XML element.
   */
  async sendStatusPresence(type, status, child_nodes) {
    if (this.session.get('connection_status') === _constants_js__WEBPACK_IMPORTED_MODULE_15__.ROOMSTATUS.ENTERED) {
      const presence = await _core_js__WEBPACK_IMPORTED_MODULE_6__._converse.xmppstatus.constructPresence(type, this.getRoomJIDAndNick(), status);
      child_nodes === null || child_nodes === void 0 ? void 0 : child_nodes.map(c => (c === null || c === void 0 ? void 0 : c.tree()) ?? c).forEach(c => presence.cnode(c).up());
      _core_js__WEBPACK_IMPORTED_MODULE_6__.api.send(presence);
    }
  },
  /**
   * Check whether we're still joined and re-join if not
   * @async
   * @method _converse.ChatRoom#rejoinIfNecessary
   */
  async rejoinIfNecessary() {
    if (!(await this.isJoined())) {
      this.rejoin();
      return true;
    }
  },
  /**
   * @private
   * @method _converse.ChatRoom#shouldShowErrorMessage
   * @returns {Promise<boolean>}
   */
  async shouldShowErrorMessage(attrs) {
    if (attrs.error_type === 'Decryption') {
      if (attrs.error_message === "Message key not found. The counter was repeated or the key was not filled.") {
        // OMEMO message which we already decrypted before
        return false;
      } else if (attrs.error_condition === 'not-encrypted-for-this-device') {
        return false;
      }
    } else i