/*!
 * @license Voxbone v2.2.5
 * Copyright 2017 Voxbone. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License")
 */
/** vim: et:ts=4:sw=4:sts=4
 * @license RequireJS 2.3.2 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, https://github.com/requirejs/requirejs/blob/master/LICENSE
 */
function handleSessionTimersInIncomingRequest(a, b) {
    if (this.sessionTimers.enabled) {
        var c;
        a.session_expires && a.session_expires >= JsSIP.C.MIN_SESSION_EXPIRES ? (this.sessionTimers.currentExpires = a.session_expires, c = a.session_expires_refresher || "uas") : (this.sessionTimers.currentExpires = this.sessionTimers.defaultExpires, c = "uas"), b.push("Session-Expires: " + this.sessionTimers.currentExpires + ";refresher=" + c), this.sessionTimers.refresher = "uas" === c, runSessionTimer.call(this)
    }
}

function handleSessionTimersInIncomingResponse(a) {
    if (this.sessionTimers.enabled) {
        var b;
        a.session_expires && a.session_expires >= JsSIP_C.MIN_SESSION_EXPIRES ? (this.sessionTimers.currentExpires = a.session_expires, b = a.session_expires_refresher || "uac") : (this.sessionTimers.currentExpires = this.sessionTimers.defaultExpires, b = "uac"), this.sessionTimers.refresher = "uac" === b, runSessionTimer.call(this)
    }
}

function runSessionTimer() {
    var a = this,
        b = this.sessionTimers.currentExpires;
    this.sessionTimers.running = !0, clearTimeout(this.sessionTimers.timer), this.sessionTimers.refresher ? this.sessionTimers.timer = setTimeout(function() {
        a.status !== JsSIP.C.STATUS_TERMINATED && sendUpdate.call(a, {
            eventHandlers: {
                succeeded: function(b) {
                    handleSessionTimersInIncomingResponse.call(a, b)
                }
            }
        })
    }, 500 * b) : this.sessionTimers.timer = setTimeout(function() {
        a.status !== JsSIP.C.STATUS_TERMINATED && a.terminate({
            cause: JsSIP_C.causes.REQUEST_TIMEOUT,
            status_code: 408,
            reason_phrase: "Session Timer Expired"
        })
    }, 1100 * b)
}

function setInvite2xxTimer(a, b) {
    var c = this,
        d = Timers.T1;
    this.timers.invite2xxTimer = setTimeout(function e() {
        c.status === JsSIP.C.STATUS_WAITING_FOR_ACK && (a.reply(200, null, ["Contact: " + c.contact], b), d < Timers.T2 && (d *= 2) > Timers.T2 && (d = Timers.T2), c.timers.invite2xxTimer = setTimeout(e, d))
    }, d)
}

function setACKTimer() {
    var a = this;
    this.timers.ackTimer = setTimeout(function() {
        a.status === JsSIP.C.STATUS_WAITING_FOR_ACK && (clearTimeout(a.timers.invite2xxTimer), sendRequest.call(a, JsSIP.C.BYE), ended.call(a, "remote", null, JsSIP.C.causes.NO_ACK))
    }, Timers.TIMER_H)
}

function ended(a, b, c) {
    this.end_time = new Date, this.close(), this.emit("ended", {
        originator: a,
        message: b || null,
        cause: c
    })
}

function configJsSIP(a) {
    a.C.SESSION_EXPIRES = 3600, a.debug.enable("JsSIP:*"), a.debug.log = function() {
        return (-1 === arguments[0].indexOf("ERROR") ? a.VoxboneLogger.loginfo : a.VoxboneLogger.logerror).apply(this, arguments)
    }, a.VoxboneLogger = {
        loginfo: function() {
            var a = Array.prototype.slice.call(arguments);
            info.apply(console, a)
        },
        logerror: function() {
            var a = Array.prototype.slice.call(arguments);
            error.apply(console, a)
        },
        setError: function(a) {
            error = a
        },
        setInfo: function(a) {
            info = a
        }
    }, a.VoxboneLogger.setInfo(function() {
        var a = Array.prototype.slice.call(arguments);
        console.debug.apply(console, a)
    }), a.VoxboneLogger.setError = function() {
        var a = Array.prototype.slice.call(arguments);
        console.error.apply(console, a)
    }
}

function extend(a, b) {
    var c = Object.prototype.toString,
        d = c.call({});
    for (var e in b) b[e] && d === c.call(b[e]) ? (a[e] = a[e] || {}, extend(a[e], b[e])) : a[e] = b[e];
    return a
}
var requirejs, require, define;
! function(global, setTimeout) {
    function commentReplace(a, b) {
        return b || ""
    }

    function isFunction(a) {
        return "[object Function]" === ostring.call(a)
    }

    function isArray(a) {
        return "[object Array]" === ostring.call(a)
    }

    function each(a, b) {
        if (a) {
            var c;
            for (c = 0; c < a.length && (!a[c] || !b(a[c], c, a)); c += 1);
        }
    }

    function eachReverse(a, b) {
        if (a) {
            var c;
            for (c = a.length - 1; c > -1 && (!a[c] || !b(a[c], c, a)); c -= 1);
        }
    }

    function hasProp(a, b) {
        return hasOwn.call(a, b)
    }

    function getOwn(a, b) {
        return hasProp(a, b) && a[b]
    }

    function eachProp(a, b) {
        var c;
        for (c in a)
            if (hasProp(a, c) && b(a[c], c)) break
    }

    function mixin(a, b, c, d) {
        return b && eachProp(b, function(b, e) {
            !c && hasProp(a, e) || (!d || "object" != typeof b || !b || isArray(b) || isFunction(b) || b instanceof RegExp ? a[e] = b : (a[e] || (a[e] = {}), mixin(a[e], b, c, d)))
        }), a
    }

    function bind(a, b) {
        return function() {
            return b.apply(a, arguments)
        }
    }

    function scripts() {
        return document.getElementsByTagName("script")
    }

    function defaultOnError(a) {
        throw a
    }

    function getGlobal(a) {
        if (!a) return a;
        var b = global;
        return each(a.split("."), function(a) {
            b = b[a]
        }), b
    }

    function makeError(a, b, c, d) {
        var e = new Error(b + "\nhttp://requirejs.org/docs/errors.html#" + a);
        return e.requireType = a, e.requireModules = d, c && (e.originalError = c), e
    }

    function newContext(a) {
        function b(a) {
            var b, c;
            for (b = 0; b < a.length; b++)
                if ("." === (c = a[b])) a.splice(b, 1), b -= 1;
                else if (".." === c) {
                if (0 === b || 1 === b && ".." === a[2] || ".." === a[b - 1]) continue;
                b > 0 && (a.splice(b - 1, 2), b -= 2)
            }
        }

        function c(a, c, d) {
            var e, f, g, h, i, j, k, l, m, n, o, p = c && c.split("/"),
                q = x.map,
                r = q && q["*"];
            if (a && (a = a.split("/"), j = a.length - 1, x.nodeIdCompat && jsSuffixRegExp.test(a[j]) && (a[j] = a[j].replace(jsSuffixRegExp, "")), "." === a[0].charAt(0) && p && (o = p.slice(0, p.length - 1), a = o.concat(a)), b(a), a = a.join("/")), d && q && (p || r)) {
                f = a.split("/");
                a: for (g = f.length; g > 0; g -= 1) {
                    if (i = f.slice(0, g).join("/"), p)
                        for (h = p.length; h > 0; h -= 1)
                            if ((e = getOwn(q, p.slice(0, h).join("/"))) && (e = getOwn(e, i))) {
                                k = e, l = g;
                                break a
                            }!m && r && getOwn(r, i) && (m = getOwn(r, i), n = g)
                }!k && m && (k = m, l = n), k && (f.splice(0, l, k), a = f.join("/"))
            }
            return getOwn(x.pkgs, a) || a
        }

        function d(a) {
            isBrowser && each(scripts(), function(b) {
                if (b.getAttribute("data-requiremodule") === a && b.getAttribute("data-requirecontext") === u.contextName) return b.parentNode.removeChild(b), !0
            })
        }

        function e(a) {
            var b = getOwn(x.paths, a);
            if (b && isArray(b) && b.length > 1) return b.shift(), u.require.undef(a), u.makeRequire(null, {
                skipMap: !0
            })([a]), !0
        }

        function f(a) {
            var b, c = a ? a.indexOf("!") : -1;
            return c > -1 && (b = a.substring(0, c), a = a.substring(c + 1, a.length)), [b, a]
        }

        function g(a, b, d, e) {
            var g, h, i, j, k = null,
                l = b ? b.name : null,
                m = a,
                n = !0,
                o = "";
            return a || (n = !1, a = "_@r" + (F += 1)), j = f(a), k = j[0], a = j[1], k && (k = c(k, l, e), h = getOwn(C, k)), a && (k ? o = h && h.normalize ? h.normalize(a, function(a) {
                return c(a, l, e)
            }) : -1 === a.indexOf("!") ? c(a, l, e) : a : (o = c(a, l, e), j = f(o), k = j[0], o = j[1], d = !0, g = u.nameToUrl(o))), i = !k || h || d ? "" : "_unnormalized" + (G += 1), {
                prefix: k,
                name: o,
                parentMap: b,
                unnormalized: !!i,
                url: g,
                originalName: m,
                isDefine: n,
                id: (k ? k + "!" + o : o) + i
            }
        }

        function h(a) {
            var b = a.id,
                c = getOwn(y, b);
            return c || (c = y[b] = new u.Module(a)), c
        }

        function i(a, b, c) {
            var d = a.id,
                e = getOwn(y, d);
            !hasProp(C, d) || e && !e.defineEmitComplete ? (e = h(a), e.error && "error" === b ? c(e.error) : e.on(b, c)) : "defined" === b && c(C[d])
        }

        function j(a, b) {
            var c = a.requireModules,
                d = !1;
            b ? b(a) : (each(c, function(b) {
                var c = getOwn(y, b);
                c && (c.error = a, c.events.error && (d = !0, c.emit("error", a)))
            }), d || req.onError(a))
        }

        function k() {
            globalDefQueue.length && (each(globalDefQueue, function(a) {
                var b = a[0];
                "string" == typeof b && (u.defQueueMap[b] = !0), B.push(a)
            }), globalDefQueue = [])
        }

        function l(a) {
            delete y[a], delete z[a]
        }

        function m(a, b, c) {
            var d = a.map.id;
            a.error ? a.emit("error", a.error) : (b[d] = !0, each(a.depMaps, function(d, e) {
                var f = d.id,
                    g = getOwn(y, f);
                !g || a.depMatched[e] || c[f] || (getOwn(b, f) ? (a.defineDep(e, C[f]), a.check()) : m(g, b, c))
            }), c[d] = !0)
        }

        function n() {
            var a, b, c = 1e3 * x.waitSeconds,
                f = c && u.startTime + c < (new Date).getTime(),
                g = [],
                h = [],
                i = !1,
                k = !0;
            if (!s) {
                if (s = !0, eachProp(z, function(a) {
                        var c = a.map,
                            j = c.id;
                        if (a.enabled && (c.isDefine || h.push(a), !a.error))
                            if (!a.inited && f) e(j) ? (b = !0, i = !0) : (g.push(j), d(j));
                            else if (!a.inited && a.fetched && c.isDefine && (i = !0, !c.prefix)) return k = !1
                    }), f && g.length) return a = makeError("timeout", "Load timeout for modules: " + g, null, g), a.contextName = u.contextName, j(a);
                k && each(h, function(a) {
                    m(a, {}, {})
                }), f && !b || !i || !isBrowser && !isWebWorker || w || (w = setTimeout(function() {
                    w = 0, n()
                }, 50)), s = !1
            }
        }

        function o(a) {
            hasProp(C, a[0]) || h(g(a[0], null, !0)).init(a[1], a[2])
        }

        function p(a, b, c, d) {
            a.detachEvent && !isOpera ? d && a.detachEvent(d, b) : a.removeEventListener(c, b, !1)
        }

        function q(a) {
            var b = a.currentTarget || a.srcElement;
            return p(b, u.onScriptLoad, "load", "onreadystatechange"), p(b, u.onScriptError, "error"), {
                node: b,
                id: b && b.getAttribute("data-requiremodule")
            }
        }

        function r() {
            var a;
            for (k(); B.length;) {
                if (a = B.shift(), null === a[0]) return j(makeError("mismatch", "Mismatched anonymous define() module: " + a[a.length - 1]));
                o(a)
            }
            u.defQueueMap = {}
        }
        var s, t, u, v, w, x = {
                waitSeconds: 7,
                baseUrl: "./",
                paths: {},
                bundles: {},
                pkgs: {},
                shim: {},
                config: {}
            },
            y = {},
            z = {},
            A = {},
            B = [],
            C = {},
            D = {},
            E = {},
            F = 1,
            G = 1;
        return v = {
            require: function(a) {
                return a.require ? a.require : a.require = u.makeRequire(a.map)
            },
            exports: function(a) {
                if (a.usingExports = !0, a.map.isDefine) return a.exports ? C[a.map.id] = a.exports : a.exports = C[a.map.id] = {}
            },
            module: function(a) {
                return a.module ? a.module : a.module = {
                    id: a.map.id,
                    uri: a.map.url,
                    config: function() {
                        return getOwn(x.config, a.map.id) || {}
                    },
                    exports: a.exports || (a.exports = {})
                }
            }
        }, t = function(a) {
            this.events = getOwn(A, a.id) || {}, this.map = a, this.shim = getOwn(x.shim, a.id), this.depExports = [], this.depMaps = [], this.depMatched = [], this.pluginMaps = {}, this.depCount = 0
        }, t.prototype = {
            init: function(a, b, c, d) {
                d = d || {}, this.inited || (this.factory = b, c ? this.on("error", c) : this.events.error && (c = bind(this, function(a) {
                    this.emit("error", a)
                })), this.depMaps = a && a.slice(0), this.errback = c, this.inited = !0, this.ignore = d.ignore, d.enabled || this.enabled ? this.enable() : this.check())
            },
            defineDep: function(a, b) {
                this.depMatched[a] || (this.depMatched[a] = !0, this.depCount -= 1, this.depExports[a] = b)
            },
            fetch: function() {
                if (!this.fetched) {
                    this.fetched = !0, u.startTime = (new Date).getTime();
                    var a = this.map;
                    if (!this.shim) return a.prefix ? this.callPlugin() : this.load();
                    u.makeRequire(this.map, {
                        enableBuildCallback: !0
                    })(this.shim.deps || [], bind(this, function() {
                        return a.prefix ? this.callPlugin() : this.load()
                    }))
                }
            },
            load: function() {
                var a = this.map.url;
                D[a] || (D[a] = !0, u.load(this.map.id, a))
            },
            check: function() {
                if (this.enabled && !this.enabling) {
                    var a, b, c = this.map.id,
                        d = this.depExports,
                        e = this.exports,
                        f = this.factory;
                    if (this.inited) {
                        if (this.error) this.emit("error", this.error);
                        else if (!this.defining) {
                            if (this.defining = !0, this.depCount < 1 && !this.defined) {
                                if (isFunction(f)) {
                                    if (this.events.error && this.map.isDefine || req.onError !== defaultOnError) try {
                                        e = u.execCb(c, f, d, e)
                                    } catch (b) {
                                        a = b
                                    } else e = u.execCb(c, f, d, e);
                                    if (this.map.isDefine && void 0 === e && (b = this.module, b ? e = b.exports : this.usingExports && (e = this.exports)), a) return a.requireMap = this.map, a.requireModules = this.map.isDefine ? [this.map.id] : null, a.requireType = this.map.isDefine ? "define" : "require", j(this.error = a)
                                } else e = f;
                                if (this.exports = e, this.map.isDefine && !this.ignore && (C[c] = e, req.onResourceLoad)) {
                                    var g = [];
                                    each(this.depMaps, function(a) {
                                        g.push(a.normalizedMap || a)
                                    }), req.onResourceLoad(u, this.map, g)
                                }
                                l(c), this.defined = !0
                            }
                            this.defining = !1, this.defined && !this.defineEmitted && (this.defineEmitted = !0, this.emit("defined", this.exports), this.defineEmitComplete = !0)
                        }
                    } else hasProp(u.defQueueMap, c) || this.fetch()
                }
            },
            callPlugin: function() {
                var a = this.map,
                    b = a.id,
                    d = g(a.prefix);
                this.depMaps.push(d), i(d, "defined", bind(this, function(d) {
                    var e, f, k, m = getOwn(E, this.map.id),
                        n = this.map.name,
                        o = this.map.parentMap ? this.map.parentMap.name : null,
                        p = u.makeRequire(a.parentMap, {
                            enableBuildCallback: !0
                        });
                    return this.map.unnormalized ? (d.normalize && (n = d.normalize(n, function(a) {
                        return c(a, o, !0)
                    }) || ""), f = g(a.prefix + "!" + n, this.map.parentMap), i(f, "defined", bind(this, function(a) {
                        this.map.normalizedMap = f, this.init([], function() {
                            return a
                        }, null, {
                            enabled: !0,
                            ignore: !0
                        })
                    })), void((k = getOwn(y, f.id)) && (this.depMaps.push(f), this.events.error && k.on("error", bind(this, function(a) {
                        this.emit("error", a)
                    })), k.enable()))) : m ? (this.map.url = u.nameToUrl(m), void this.load()) : (e = bind(this, function(a) {
                        this.init([], function() {
                            return a
                        }, null, {
                            enabled: !0
                        })
                    }), e.error = bind(this, function(a) {
                        this.inited = !0, this.error = a, a.requireModules = [b], eachProp(y, function(a) {
                            0 === a.map.id.indexOf(b + "_unnormalized") && l(a.map.id)
                        }), j(a)
                    }), e.fromText = bind(this, function(c, d) {
                        var f = a.name,
                            i = g(f),
                            k = useInteractive;
                        d && (c = d), k && (useInteractive = !1), h(i), hasProp(x.config, b) && (x.config[f] = x.config[b]);
                        try {
                            req.exec(c)
                        } catch (a) {
                            return j(makeError("fromtexteval", "fromText eval for " + b + " failed: " + a, a, [b]))
                        }
                        k && (useInteractive = !0), this.depMaps.push(i), u.completeLoad(f), p([f], e)
                    }), void d.load(a.name, p, e, x))
                })), u.enable(d, this), this.pluginMaps[d.id] = d
            },
            enable: function() {
                z[this.map.id] = this, this.enabled = !0, this.enabling = !0, each(this.depMaps, bind(this, function(a, b) {
                    var c, d, e;
                    if ("string" == typeof a) {
                        if (a = g(a, this.map.isDefine ? this.map : this.map.parentMap, !1, !this.skipMap), this.depMaps[b] = a, e = getOwn(v, a.id)) return void(this.depExports[b] = e(this));
                        this.depCount += 1, i(a, "defined", bind(this, function(a) {
                            this.undefed || (this.defineDep(b, a), this.check())
                        })), this.errback ? i(a, "error", bind(this, this.errback)) : this.events.error && i(a, "error", bind(this, function(a) {
                            this.emit("error", a)
                        }))
                    }
                    c = a.id, d = y[c], hasProp(v, c) || !d || d.enabled || u.enable(a, this)
                })), eachProp(this.pluginMaps, bind(this, function(a) {
                    var b = getOwn(y, a.id);
                    b && !b.enabled && u.enable(a, this)
                })), this.enabling = !1, this.check()
            },
            on: function(a, b) {
                var c = this.events[a];
                c || (c = this.events[a] = []), c.push(b)
            },
            emit: function(a, b) {
                each(this.events[a], function(a) {
                    a(b)
                }), "error" === a && delete this.events[a]
            }
        }, u = {
            config: x,
            contextName: a,
            registry: y,
            defined: C,
            urlFetched: D,
            defQueue: B,
            defQueueMap: {},
            Module: t,
            makeModuleMap: g,
            nextTick: req.nextTick,
            onError: j,
            configure: function(a) {
                if (a.baseUrl && "/" !== a.baseUrl.charAt(a.baseUrl.length - 1) && (a.baseUrl += "/"), "string" == typeof a.urlArgs) {
                    var b = a.urlArgs;
                    a.urlArgs = function(a, c) {
                        return (-1 === c.indexOf("?") ? "?" : "&") + b
                    }
                }
                var c = x.shim,
                    d = {
                        paths: !0,
                        bundles: !0,
                        config: !0,
                        map: !0
                    };
                eachProp(a, function(a, b) {
                    d[b] ? (x[b] || (x[b] = {}), mixin(x[b], a, !0, !0)) : x[b] = a
                }), a.bundles && eachProp(a.bundles, function(a, b) {
                    each(a, function(a) {
                        a !== b && (E[a] = b)
                    })
                }), a.shim && (eachProp(a.shim, function(a, b) {
                    isArray(a) && (a = {
                        deps: a
                    }), !a.exports && !a.init || a.exportsFn || (a.exportsFn = u.makeShimExports(a)), c[b] = a
                }), x.shim = c), a.packages && each(a.packages, function(a) {
                    var b, c;
                    a = "string" == typeof a ? {
                        name: a
                    } : a, c = a.name, b = a.location, b && (x.paths[c] = a.location), x.pkgs[c] = a.name + "/" + (a.main || "main").replace(currDirRegExp, "").replace(jsSuffixRegExp, "")
                }), eachProp(y, function(a, b) {
                    a.inited || a.map.unnormalized || (a.map = g(b, null, !0))
                }), (a.deps || a.callback) && u.require(a.deps || [], a.callback)
            },
            makeShimExports: function(a) {
                function b() {
                    var b;
                    return a.init && (b = a.init.apply(global, arguments)), b || a.exports && getGlobal(a.exports)
                }
                return b
            },
            makeRequire: function(b, e) {
                function f(c, d, i) {
                    var k, l, m;
                    return e.enableBuildCallback && d && isFunction(d) && (d.__requireJsBuild = !0), "string" == typeof c ? isFunction(d) ? j(makeError("requireargs", "Invalid require call"), i) : b && hasProp(v, c) ? v[c](y[b.id]) : req.get ? req.get(u, c, b, f) : (l = g(c, b, !1, !0), k = l.id, hasProp(C, k) ? C[k] : j(makeError("notloaded", 'Module name "' + k + '" has not been loaded yet for context: ' + a + (b ? "" : ". Use require([])")))) : (r(), u.nextTick(function() {
                        r(), m = h(g(null, b)), m.skipMap = e.skipMap, m.init(c, d, i, {
                            enabled: !0
                        }), n()
                    }), f)
                }
                return e = e || {}, mixin(f, {
                    isBrowser: isBrowser,
                    toUrl: function(a) {
                        var d, e = a.lastIndexOf("."),
                            f = a.split("/")[0],
                            g = "." === f || ".." === f;
                        return -1 !== e && (!g || e > 1) && (d = a.substring(e, a.length), a = a.substring(0, e)), u.nameToUrl(c(a, b && b.id, !0), d, !0)
                    },
                    defined: function(a) {
                        return hasProp(C, g(a, b, !1, !0).id)
                    },
                    specified: function(a) {
                        return a = g(a, b, !1, !0).id, hasProp(C, a) || hasProp(y, a)
                    }
                }), b || (f.undef = function(a) {
                    k();
                    var c = g(a, b, !0),
                        e = getOwn(y, a);
                    e.undefed = !0, d(a), delete C[a], delete D[c.url], delete A[a], eachReverse(B, function(b, c) {
                        b[0] === a && B.splice(c, 1)
                    }), delete u.defQueueMap[a], e && (e.events.defined && (A[a] = e.events), l(a))
                }), f
            },
            enable: function(a) {
                getOwn(y, a.id) && h(a).enable()
            },
            completeLoad: function(a) {
                var b, c, d, f = getOwn(x.shim, a) || {},
                    g = f.exports;
                for (k(); B.length;) {
                    if (c = B.shift(), null === c[0]) {
                        if (c[0] = a, b) break;
                        b = !0
                    } else c[0] === a && (b = !0);
                    o(c)
                }
                if (u.defQueueMap = {}, d = getOwn(y, a), !b && !hasProp(C, a) && d && !d.inited) {
                    if (!(!x.enforceDefine || g && getGlobal(g))) return e(a) ? void 0 : j(makeError("nodefine", "No define call for " + a, null, [a]));
                    o([a, f.deps || [], f.exportsFn])
                }
                n()
            },
            nameToUrl: function(a, b, c) {
                var d, e, f, g, h, i, j, k = getOwn(x.pkgs, a);
                if (k && (a = k), j = getOwn(E, a)) return u.nameToUrl(j, b, c);
                if (req.jsExtRegExp.test(a)) h = a + (b || "");
                else {
                    for (d = x.paths, e = a.split("/"), f = e.length; f > 0; f -= 1)
                        if (g = e.slice(0, f).join("/"), i = getOwn(d, g)) {
                            isArray(i) && (i = i[0]), e.splice(0, f, i);
                            break
                        }
                    h = e.join("/"), h += b || (/^data\:|^blob\:|\?/.test(h) || c ? "" : ".js"), h = ("/" === h.charAt(0) || h.match(/^[\w\+\.\-]+:/) ? "" : x.baseUrl) + h
                }
                return x.urlArgs && !/^blob\:/.test(h) ? h + x.urlArgs(a, h) : h
            },
            load: function(a, b) {
                req.load(u, a, b)
            },
            execCb: function(a, b, c, d) {
                return b.apply(d, c)
            },
            onScriptLoad: function(a) {
                if ("load" === a.type || readyRegExp.test((a.currentTarget || a.srcElement).readyState)) {
                    interactiveScript = null;
                    var b = q(a);
                    u.completeLoad(b.id)
                }
            },
            onScriptError: function(a) {
                var b = q(a);
                if (!e(b.id)) {
                    var c = [];
                    return eachProp(y, function(a, d) {
                        0 !== d.indexOf("_@r") && each(a.depMaps, function(a) {
                            if (a.id === b.id) return c.push(d), !0
                        })
                    }), j(makeError("scripterror", 'Script error for "' + b.id + (c.length ? '", needed by: ' + c.join(", ") : '"'), a, [b.id]))
                }
            }
        }, u.require = u.makeRequire(), u
    }

    function getInteractiveScript() {
        return interactiveScript && "interactive" === interactiveScript.readyState ? interactiveScript : (eachReverse(scripts(), function(a) {
            if ("interactive" === a.readyState) return interactiveScript = a
        }), interactiveScript)
    }
    var req, s, head, baseElement, dataMain, src, interactiveScript, currentlyAddingScript, mainScript, subPath, version = "2.3.2",
        commentRegExp = /\/\*[\s\S]*?\*\/|([^:"'=]|^)\/\/.*$/gm,
        cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,
        jsSuffixRegExp = /\.js$/,
        currDirRegExp = /^\.\//,
        op = Object.prototype,
        ostring = op.toString,
        hasOwn = op.hasOwnProperty,
        isBrowser = !("undefined" == typeof window || "undefined" == typeof navigator || !window.document),
        isWebWorker = !isBrowser && "undefined" != typeof importScripts,
        readyRegExp = isBrowser && "PLAYSTATION 3" === navigator.platform ? /^complete$/ : /^(complete|loaded)$/,
        defContextName = "_",
        isOpera = "undefined" != typeof opera && "[object Opera]" === opera.toString(),
        contexts = {},
        cfg = {},
        globalDefQueue = [],
        useInteractive = !1;
    if (void 0 === define) {
        if (void 0 !== requirejs) {
            if (isFunction(requirejs)) return;
            cfg = requirejs, requirejs = void 0
        }
        void 0 === require || isFunction(require) || (cfg = require, require = void 0), req = requirejs = function(a, b, c, d) {
            var e, f, g = defContextName;
            return isArray(a) || "string" == typeof a || (f = a, isArray(b) ? (a = b, b = c, c = d) : a = []), f && f.context && (g = f.context), e = getOwn(contexts, g), e || (e = contexts[g] = req.s.newContext(g)), f && e.configure(f), e.require(a, b, c)
        }, req.config = function(a) {
            return req(a)
        }, req.nextTick = void 0 !== setTimeout ? function(a) {
            setTimeout(a, 4)
        } : function(a) {
            a()
        }, require || (require = req), req.version = version, req.jsExtRegExp = /^\/|:|\?|\.js$/, req.isBrowser = isBrowser, s = req.s = {
            contexts: contexts,
            newContext: newContext
        }, req({}), each(["toUrl", "undef", "defined", "specified"], function(a) {
            req[a] = function() {
                var b = contexts[defContextName];
                return b.require[a].apply(b, arguments)
            }
        }), isBrowser && (head = s.head = document.getElementsByTagName("head")[0], (baseElement = document.getElementsByTagName("base")[0]) && (head = s.head = baseElement.parentNode)), req.onError = defaultOnError, req.createNode = function(a, b, c) {
            var d = a.xhtml ? document.createElementNS("http://www.w3.org/1999/xhtml", "html:script") : document.createElement("script");
            return d.type = a.scriptType || "text/javascript", d.charset = "utf-8", d.async = !0, d
        }, req.load = function(a, b, c) {
            var d, e = a && a.config || {};
            if (isBrowser) return d = req.createNode(e, b, c), d.setAttribute("data-requirecontext", a.contextName), d.setAttribute("data-requiremodule", b), !d.attachEvent || d.attachEvent.toString && d.attachEvent.toString().indexOf("[native code") < 0 || isOpera ? (d.addEventListener("load", a.onScriptLoad, !1), d.addEventListener("error", a.onScriptError, !1)) : (useInteractive = !0, d.attachEvent("onreadystatechange", a.onScriptLoad)), d.src = c, e.onNodeCreated && e.onNodeCreated(d, e, b, c), currentlyAddingScript = d, baseElement ? head.insertBefore(d, baseElement) : head.appendChild(d), currentlyAddingScript = null, d;
            if (isWebWorker) try {
                setTimeout(function() {}, 0), importScripts(c), a.completeLoad(b)
            } catch (d) {
                a.onError(makeError("importscripts", "importScripts failed for " + b + " at " + c, d, [b]))
            }
        }, isBrowser && !cfg.skipDataMain && eachReverse(scripts(), function(a) {
            if (head || (head = a.parentNode), dataMain = a.getAttribute("data-main")) return mainScript = dataMain, cfg.baseUrl || -1 !== mainScript.indexOf("!") || (src = mainScript.split("/"), mainScript = src.pop(), subPath = src.length ? src.join("/") + "/" : "./", cfg.baseUrl = subPath), mainScript = mainScript.replace(jsSuffixRegExp, ""), req.jsExtRegExp.test(mainScript) && (mainScript = dataMain), cfg.deps = cfg.deps ? cfg.deps.concat(mainScript) : [mainScript], !0
        }), define = function(a, b, c) {
            var d, e;
            "string" != typeof a && (c = b, b = a, a = null), isArray(b) || (c = b, b = null), !b && isFunction(c) && (b = [], c.length && (c.toString().replace(commentRegExp, commentReplace).replace(cjsRequireRegExp, function(a, c) {
                b.push(c)
            }), b = (1 === c.length ? ["require"] : ["require", "exports", "module"]).concat(b))), useInteractive && (d = currentlyAddingScript || getInteractiveScript()) && (a || (a = d.getAttribute("data-requiremodule")), e = contexts[d.getAttribute("data-requirecontext")]), e ? (e.defQueue.push([a, b, c]), e.defQueueMap[a] = !0) : globalDefQueue.push([a, b, c])
        }, define.amd = {
            jQuery: !0
        }, req.exec = function(text) {
            return eval(text)
        }, req(cfg)
    }
}(this, "undefined" == typeof setTimeout ? void 0 : setTimeout);
var T1 = 500,
    T2 = 4e3,
    T4 = 5e3,
    Timers = {
        T1: T1,
        T2: T2,
        T4: T4,
        TIMER_B: 64 * T1,
        TIMER_D: 0 * T1,
        TIMER_F: 64 * T1,
        TIMER_H: 64 * T1,
        TIMER_I: 0 * T1,
        TIMER_J: 0 * T1,
        TIMER_K: 0 * T4,
        TIMER_L: 64 * T1,
        TIMER_M: 64 * T1,
        PROVISIONAL_RESPONSE_INTERVAL: 6e4
    },
    JsSIP, voxbone = voxbone || {};
requirejs.config({
    paths: {
        jssip: [click2Dial.server_url + "/scripts/jssip.min"]
    }
}), requirejs(["jssip"], function(a) {
    configJsSIP(a), JsSIP = a
}), extend(voxbone, {
    Request: {
        param: function(a) {
            var b = "";
            for (var c in a) a.hasOwnProperty(c) && (b.length > 0 && (b += "&"), b += c + "=" + encodeURIComponent(a[c]));
            return b
        },
        post: function(a, b, c) {

            var d = new XMLHttpRequest,
                e = this.param(b);
            d.open("POST", a), d.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"), d.onload = function() {
                "function" == typeof c && c({
                    status: d.status,
                    message: d.responseText
                })
            }, d.send(e)
        },
        jsonp: function(a, b) {
            var c = a + (a.indexOf("?") + 1 ? "&" : "?"),
                d = document.getElementsByTagName("head")[0],
                e = document.createElement("script");
            c += this.param(b), e.type = "text/javascript", e.src = c, this.currentScript && d.removeChild(currentScript), d.appendChild(e)
        }
    }
}), extend(voxbone, {
    Logger: {
        loginfo: function(a) {
            console.debug(a)
        },
        logerror: function(a) {
            console.error(a)
        },
        addLogToBuffer: function(a) {

        },
        log_level: {
            NONE: 0,
            ERROR: 1,
            INFO: 2
        }
    }
}), extend(voxbone, {
    Pinger: {
        pingResults: [],
        ping: function(a, b) {
            var c = (new Date).getTime(),
                d = this,
                e = this.recordPingResult;
            this.img = new Image, d.inUse = !0, this.img.onload = function() {
                var b = (new Date).getTime() - c;
                e(a, b), d.inUse = !1
            }, this.img.onerror = function(b) {
                d.inUse = !1, e(a, -1)
            }, this.img.src = b + "?" + (new Date).getTime(), this.timer = setTimeout(function() {
                d.inUse && (d.inUse = !1, e(a, -1))
            }, 1500)
        },
        recordPingResult: function(a, b) {
            voxbone.Logger.loginfo("[ping] " + a + " replied in " + b);
            var c = {
                name: a,
                ping: b
            };
            voxbone.Pinger.pingResults.push(c)
        },
        getBestPop: function() {
            var a;
            if (0 === this.pingResults.length) a = {
                name: "BE",
                ping: -1
            };
            else
                for (var b = 0; b < this.pingResults.length; b++) {
                    var c = this.pingResults[b];
                    (void 0 === a || c.ping > 0 && (a.ping < 0 || c.ping < a.ping)) && (a = c)
                }
            return a
        }
    }
}), extend(voxbone, {
    WebRTC: {
        audioComponentName: "peer-audio",
        videoComponentName: "peer-video",
        allowVideo: !1,
        authServerURL: "https://cdn.voxbone.com/authentication/createToken",
        basicAuthServerURL: "https://cdn.voxbone.com/authentication/basicToken",
        webrtcLogs: "",
        rtcSession: {},
        callid: "",
        previous_callid: "",
        audioContext: void 0,
        localVolume: 0,
        remoteVolume: 0,
        localVolumeTimer: void 0,
        remoteVolumeTimer: void 0,
        dtmfTimer: void 0,
        localAudioScriptProcessor: {},
        remoteAudioScriptProcessor: {},
        preferedPop: void 0,
        inboundCalling: !1,
        register: !1,
        username: null,
        password: null,
        onCall: null,
        configuration: {
            authorization_user: undefined,
            password: undefined,
            ws_servers: undefined,
            stun_servers: void 0,
            turn_servers: void 0,
            log_level: voxbone.Logger.log_level.INFO,
            post_logs: !1,
            post_logs_nocall: !1,
            webrtc_log: undefined,
            uri: undefined,
            trace_sip: false,
            register: false,
            dialer_string: void 0,
            digit_duration: 100,
            digit_gap: 500,
            post_logs: false
        },
        customEventHandler: {
            progress: function(a) {},
            accepted: function(a) {},
            getUserMediaFailed: function(a) {
                voxbone.Logger.logerror("Failed to access mic/camera")
            },
            localMediaVolume: function(a) {},
            remoteMediaVolume: function(a) {},
            failed: function(a) {},
            ended: function(a) {},
            authExpired: function(a) {},
            readyToCall: function(a) {},
            getUserMediaAccepted: function(a) {
                voxbone.Logger.loginfo("local media accepted")
            },
            connected: function(a) {},
            registered: function(a) {}
        },
        phone: void 0,
        context: void 0,
        init: function(a, b) {
            voxbone.Logger.loginfo("auth server: " + this.authServerURL);
            var c = {
                username: a.username,
                key: a.key,
                expires: a.expires,
                timestamp: Date.now(),
                jsonp: "voxbone.WebRTC.processAuthData"
            };
            voxbone.Request.jsonp(this.authServerURL, c)
        },
        basicAuthInit: function(a, b) {
            voxbone.Logger.loginfo("auth server: " + this.basicAuthServerURL);
            var c = {
                username: a,
                key: b,
                timestamp: Date.now(),
                jsonp: "voxbone.WebRTC.processAuthData"
            };
            voxbone.Request.jsonp(this.basicAuthServerURL, c)
        },
        processAuthData: function(a) {
            this.onCall instanceof Function ? this.configuration.ws_servers || (this.configuration.ws_servers = ["wss://workshop-gateway.voxbone.com"]) : this.configuration.ws_servers = a.wss, this.configuration.stun_servers = a.stunServers, this.configuration.turn_servers = a.turnServers, this.configuration.webrtc_log = a.log, this.configuration.authorization_user = a.username, this.configuration.password = a.password;
            var b = this.getAuthExpiration();
            if (b > 0 && (voxbone.Logger.loginfo("Credential expires in " + b + " seconds"), setTimeout(this.customEventHandler.authExpired, 750 * b)), this.onCall instanceof Function && !this.phone) this.inboundCalling = !0, this.configuration.register = !0, this.setupInboundCalling();
            else if (void 0 === this.preferedPop) {
                voxbone.Logger.loginfo("prefered pop undefined, pinging...."), this.pingServers = a.pingServers;
                for (var c = 0; c < this.pingServers.length; c++) voxbone.Pinger.ping(c, this.pingServers[c])
            } else voxbone.Logger.loginfo("preferred pop already set to " + this.preferedPop);
            this.customEventHandler.readyToCall()
        },
        getAuthExpiration: function(a) {
            var b = Math.floor((new Date).getTime() / 1e3);
            return this.configuration.authorization_user.split(/:/)[0] - b
        },
        initAudioElement: function(a, b) {
            var c = document.getElementById(a);
            return c || (c = document.createElement("audio"), c.id = a, c.hidden = !1, c.autoplay = !0, document.body.appendChild(c)), c.srcObject = b, c
        },
        initVideoElement: function(a, b) {
            var c = document.getElementById(a);
            return c || (c = document.createElement("video"), c.id = a, c.hidden = !1, c.autoplay = !0, document.body.appendChild(c)), c.srcObject = b, c
        },
        sendPreConfiguredDtmf: function(a) {
            var b, c = 0;
            if (void 0 !== voxbone.WebRTC.dtmfTimer && (clearTimeout(voxbone.WebRTC.dtmfTimer), voxbone.WebRTC.dtmfTime = void 0), a.length > 0) {
                if (-1 != a[0].indexOf("ms") ? c = parseInt(a[0].substring(0, a[0].indexOf("ms"))) : b = a[0], a = a.slice(1, a.length), void 0 !== b) {
                    Date.now();
                    voxbone.WebRTC.rtcSession.sendDTMF(b), !0
                }
                if (a.length > 0) {
                    var d = c > 0 ? c - voxbone.WebRTC.configuration.digit_gap : voxbone.WebRTC.configuration.digit_gap + voxbone.WebRTC.configuration.digit_duration;
                    d < 0 && (d = 0), voxbone.WebRTC.dtmfTimer = setTimeout(function() {
                        voxbone.WebRTC.sendPreConfiguredDtmf(a)
                    }, d)
                }
            }
        },
        postCallRating: function(a, b, c, d) {
            if (void 0 !== voxbone.WebRTC.previous_callid) {
                var e = {
                        payload_type: "webrtc_call_rating",
                        username: voxbone.WebRTC.configuration.authorization_user,
                        password: voxbone.WebRTC.configuration.password,
                        callid: voxbone.WebRTC.previous_callid,
                        e164: a,
                        url: d,
                        rating: b,
                        comment: c
                    },
                    f = voxbone.WebRTC.configuration.webrtc_log;
                voxbone.Request.post(f, e), voxbone.WebRTC.previous_callid = void 0
            }
        },
        postLogsToServer: function() {
            if (!0 === voxbone.WebRTC.configuration.post_logs && void 0 !== voxbone.WebRTC.configuration.webrtc_log) {
                var a = voxbone.WebRTC.configuration.webrtc_log,
                    b = {
                        payload_type: "webrtc_logs",
                        username: voxbone.WebRTC.configuration.authorization_user,
                        password: voxbone.WebRTC.configuration.password,
                        callid: voxbone.WebRTC.callid,
                        pop: voxbone.WebRTC.preferedPop,
                        context: voxbone.WebRTC.context,
                        uri: voxbone.WebRTC.configuration.uri,
                        logs: voxbone.WebRTC.webrtcLogs
                    };
                voxbone.Request.post(a, b)
            }
        },
        cleanUp: function() {
            ["local", "remote"].forEach(function(a) {
                void 0 !== voxbone.WebRTC[a + "VolumeTimer"] && (clearInterval(voxbone.WebRTC[a + "VolumeTimer"]), voxbone.WebRTC[a + "VolumeTimer"] = void 0);
                var b = a + "AudioScriptProcessor";
                void 0 !== voxbone.WebRTC[b] && (void 0 !== voxbone.WebRTC.audioContext && void 0 !== voxbone.WebRTC.audioContext.destination && voxbone.WebRTC[b].disconnect(voxbone.WebRTC.audioContext.destination), voxbone.WebRTC[b] = void 0)
            }), void 0 !== voxbone.WebRTC.dtmfTimer && (clearTimeout(voxbone.WebRTC.dtmfTimer), voxbone.WebRTC.dtmfTimer = void 0), voxbone.WebRTC.cleanAudioElement(voxbone.WebRTC.audioComponentName), voxbone.WebRTC.previous_callid = voxbone.WebRTC.callid, voxbone.WebRTC.callid = "", voxbone.WebRTC.webrtcLogs = "", voxbone.WebRTC.rtcSession = {}, voxbone.WebRTC.inboundCalling || delete voxbone.WebRTC.phone
        },
        cleanAudioElement: function(a) {
            var b = document.getElementById(a);
            return b && (b.removeAttribute("src"), b.load()), b
        },
        monitorStreamVolume: function(a) {
            a = a || "local", console.debug("monitoring volume on ", a);
            var b = "local" === a ? "getLocalStreams" : "getRemoteStreams",
                c = "local" === a ? "localVolume" : "remoteVolume",
                d = "local" === a ? "localVolumeTimer" : "remoteVolumeTimer",
                e = "local" === a ? "localMediaVolume" : "remoteMediaVolume",
                f = "local" === a ? "localAudioScriptProcessor" : "remoteAudioScriptProcessor",
                g = voxbone.WebRTC.rtcSession.connection[b]();
            voxbone.Logger.loginfo("streams " + g.length);
            for (var h = 0; h < g.length; h++)
                if (g[h].getAudioTracks().length > 0) {
                    try {
                        void 0 === voxbone.WebRTC.audioContext && (voxbone.WebRTC.audioContext = new AudioContext)
                    } catch (a) {
                        voxbone.Logger.logerror("Web Audio API not supported " + a)
                    }
                    voxbone.WebRTC[f] = voxbone.WebRTC.audioContext.createScriptProcessor(0, 1, 1);
                    var i = voxbone.WebRTC.audioContext.createMediaStreamSource(g[h]);
                    i.connect(voxbone.WebRTC[f]), voxbone.WebRTC[f].connect(voxbone.WebRTC.audioContext.destination), voxbone.WebRTC[f].onaudioprocess = function(a) {
                        var b, d = a.inputBuffer.getChannelData(0),
                            e = 0;
                        for (b = 0; b < d.length; ++b) e += d[b] * d[b];
                        voxbone.WebRTC[c] = Math.sqrt(e / d.length)
                    }, voxbone.WebRTC[d] = setInterval(function() {
                        var a = {};
                        a[c] = voxbone.WebRTC[c].toFixed(2), voxbone.WebRTC.customEventHandler[e](a)
                    }, 200);
                    break
                }
        },
        getOptions: function() {
            var a = {
                eventHandlers: {
                    peerconnection: function(a) {},
                    sending: function(a) {
                        voxbone.WebRTC.callid = a.request.call_id;
                        voxbone.WebRTC.rtcSession.connection.pc, voxbone.WebRTC.rtcSession.remote_identity.uri.user
                    },
                    progress: function(a) {
                        voxbone.WebRTC.customEventHandler.progress(a)
                    },
                    failed: function(a) {
                        var b = voxbone.WebRTC.callid;
                        switch (voxbone.Logger.logerror("Call (" + b + ") failed. Cause: " + a.cause), void 0 !== voxbone.WebRTC.rtcSession.connection && voxbone.WebRTC.rtcSession.connection && voxbone.WebRTC.rtcSession.connection.pc, a.cause) {
                            case JsSIP.C.causes.USER_DENIED_MEDIA_ACCESS:
                                voxbone.WebRTC.customEventHandler.getUserMediaFailed(a);
                                break;
                            case JsSIP.C.causes.INCOMPATIBLE_SDP:
                            case JsSIP.C.causes.MISSING_SDP:
                            case JsSIP.C.causes.BYE:
                            case JsSIP.C.causes.CANCELED:
                            case JsSIP.C.causes.NO_ANSWER:
                            case JsSIP.C.causes.EXPIRES:
                            case JsSIP.C.causes.NO_ACK:
                            case JsSIP.C.causes.BUSY:
                            case JsSIP.C.causes.REJECTED:
                            case JsSIP.C.causes.REDIRECTED:
                            case JsSIP.C.causes.UNAVAILABLE:
                            case JsSIP.C.causes.NOT_FOUND:
                        }
                        voxbone.WebRTC.postLogsToServer(), voxbone.WebRTC.cleanUp(), voxbone.WebRTC.customEventHandler.failed(a)
                    },
                    accepted: function(a) {
                        voxbone.WebRTC.customEventHandler.accepted(a)
                    },
                    addstream: function(a) {
                        voxbone.WebRTC.monitorStreamVolume("local"), voxbone.WebRTC.monitorStreamVolume("remote"), voxbone.WebRTC.allowVideo ? voxbone.WebRTC.initVideoElement(voxbone.WebRTC.videoComponentName, a.stream) : voxbone.WebRTC.initAudioElement(voxbone.WebRTC.audioComponentName, a.stream)
                    },
                    confirmed: function(a) {
                        if (void 0 !== voxbone.WebRTC.configuration.dialer_string && voxbone.WebRTC.configuration.dialer_string.length > 0) {
                            var b = voxbone.WebRTC.configuration.dialer_string.split(",");
                            voxbone.WebRTC.sendPreConfiguredDtmf(b)
                        }
                    },
                    ended: function(a) {
                        voxbone.WebRTC.postLogsToServer(), voxbone.WebRTC.cleanUp(), voxbone.WebRTC.customEventHandler.ended(a)
                    }
                },
                extraHeaders: [],
                pcConfig: {
                    rtcpMuxPolicy: "negotiate"
                },
                mediaConstraints: {
                    audio: !0,
                    video: voxbone.WebRTC.allowVideo
                }
            };
            if (void 0 !== this.configuration.stun_servers || void 0 !== this.configuration.turn_servers) {
                var b = [];
                for (i = 0; i < this.configuration.stun_servers.length; i++) b.push(this.configuration.stun_servers[i]);
                for (i = 0; i < this.configuration.turn_servers.length; i++) b.push(this.configuration.turn_servers[i]);
                a.pcConfig.iceServers = b, a.pcConfig.gatheringTimeoutAfterRelay = 5e3
            }
            return a.pcConfig.iceCandidatePoolSize = 10, a
        },
        setupInboundCalling: function() {
            var a = new JsSIP.WebSocketInterface(this.configuration.ws_servers[0]);
            a.via_transport = "tcp";
            var b = {},
                c = [];
            extend(b, this.configuration), delete b.ws_servers, b.sockets = [a], voxbone.WebRTC.phone = new JsSIP.UA(b), c.length && voxbone.WebRTC.phone.registrator().setExtraHeaders(c), voxbone.WebRTC.phone.on("connected", function(a) {
                voxbone.WebRTC.customEventHandler.connected(a), voxbone.Logger.loginfo("connected to websocket")
            }), voxbone.WebRTC.phone.on("registered", function(a) {
                voxbone.WebRTC.customEventHandler.registered(a)
            }), voxbone.WebRTC.phone.on("newRTCSession", function(a) {
                if ("remote" === a.originator) {
                    voxbone.WebRTC.rtcSession = a.session;
                    var b = voxbone.WebRTC.getOptions();
                    Object.keys(b.eventHandlers).forEach(function(c) {
                        a.session.on(c, b.eventHandlers[c])
                    }), a.session.on("connecting", function(a) {
                        voxbone.WebRTC.customEventHandler.getUserMediaAccepted(a)
                    });
                    var c = function(c) {
                        c ? a.session.answer({
                            extraHeaders: b.extraHeaders,
                            pcConfig: b.pcConfig,
                            mediaConstraints: b.mediaConstraints
                        }) : a.session.terminate()
                    };
                    voxbone.WebRTC.onCall(a, c)
                }
            }), voxbone.WebRTC.phone.start()
        },
        call: function(a) {
            // BAO

            var z = infoVoxbone.sip.domain;

            if (a.indexOf("@") > -1)
            {
                var y = a.split("@");
                a = y[0];
                z = y[1];
            }
            var b = new JsSIP.URI("sip", a, z);

            void 0 === this.preferedPop && (this.preferedPop = voxbone.Pinger.getBestPop().name), voxbone.Logger.loginfo("prefered pop: " + this.preferedPop);
            var c = [];
            var d = voxbone.WebRTC.getOptions();
            d.extraHeaders = c, void 0 === this.phone ? (this.phone = new JsSIP.UA(this.configuration), this.phone.once("connected", function() {
                voxbone.WebRTC.rtcSession = voxbone.WebRTC.phone.call(b.toAor(), d)
            }), this.phone.on("newRTCSession", function(a) {
                a.session.on("connecting", function(a) {
                    voxbone.WebRTC.customEventHandler.getUserMediaAccepted(a)
                }), a.session.on("reinvite", function(b) {
                    request = b.request;
                    var c = ["Contact: " + a.session.contact];
                    handleSessionTimersInIncomingRequest.call(a.session, request, c), request.reply(200, null, c, null, function() {
                        self.status = JsSIP.C.STATUS_WAITING_FOR_ACK, setInvite2xxTimer.call(a.session, request, null), setACKTimer.call(a.session)
                    })
                })
            }), this.phone.start()) : (this.phone.configuration = this.configuration, this.rtcSession = this.phone.call(b.toAor(), d))
        },
        isCallOpen: function() {
            return "function" == typeof voxbone.WebRTC.rtcSession.isEstablished && "function" == typeof voxbone.WebRTC.rtcSession.isInProgress && (!0 === voxbone.WebRTC.rtcSession.isInProgress() || !0 === voxbone.WebRTC.rtcSession.isEstablished())
        },
        sendDTMF: function(a) {
            this.rtcSession.sendDTMF(a)
        },
        hangup: function() {
            void 0 !== this.rtcSession && this.rtcSession.terminate()
        },
        isMuted: !1,
        isRemoteMuted: !1,
        mute: function(a) {
            var b;
            a && "remote" === a ? (b = this.rtcSession.connection.getRemoteStreams(), this.isRemoteMuted = !0) : (b = this.rtcSession.connection.getLocalStreams(), this.isMuted = !0);
            for (var c = 0; c < b.length; c++)
                for (var d = 0; d < b[c].getAudioTracks().length; d++) b[c].getAudioTracks()[d].enabled = !1
        },
        unmute: function(a) {
            var b;
            a && "remote" === a ? (b = this.rtcSession.connection.getRemoteStreams(), this.isRemoteMuted = !1) : (b = this.rtcSession.connection.getLocalStreams(), this.isMuted = !1);
            for (var c = 0; c < b.length; c++)
                for (var d = 0; d < b[c].getAudioTracks().length; d++) b[c].getAudioTracks()[d].enabled = !0
        },
        unloadHandler: function() {
            voxbone.WebRTC.isCallOpen() ? (voxbone.Logger.loginfo("Page unloading while a call was in progress, hanging up"), voxbone.WebRTC.hangup(), voxbone.WebRTC.postLogsToServer()) : !0 === voxbone.WebRTC.configuration.post_logs_nocall && voxbone.WebRTC.postLogsToServer()
        },
        isWebRTCSupported: function() {
            if (window.navigator.webkitGetUserMedia || window.navigator.mozGetUserMedia) {
                if (navigator.userAgent.toLowerCase().indexOf("firefox") > -1) {
                    var a = new RegExp("firefox/([0-9])+"),
                        b = new RegExp("([0-9])+"),
                        c = a.exec(navigator.userAgent.toLowerCase())[0];
                    if (b.exec(c)[0] < 23) return !1
                }
                return !0
            }
            return !1
        }
    }
});